/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.triplea.ai.AdvancedAI;

import games.strategy.engine.data.GameData;
import games.strategy.engine.data.PlayerID;
import games.strategy.engine.data.Territory;
import games.strategy.engine.data.UnitType;
import games.strategy.engine.framework.GameRunner;
import games.strategy.triplea.ai.AdvancedAI.AITurn;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileFilter;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.swing.JOptionPane;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AIStrategy {
    private final String[] mapNames = new String[]{"World War II Classic", "World War II Revised", "World War II v3 1941", "World War II v3 1942", "WW2 NWO 2.0 Neutrals", "WW2 NWO 3.0 Neutrals", "WW2 Phillipines - v2", "New World Order 1939 Lebowski", "Stalingrad", "The Rising Sun", "Big World : 1942", "Big World : 1942 v3 Rules", "New World Order"};
    private final String[] fileNames = new String[]{"World War II Classic", "World War II Revised", "World War II v3", "World War II v3", "WW2 NEW WORLD ORDER", "WW2 NEW WORLD ORDER", "WW2 Phillipines", "New World Order Lebowski Edition", "Stalingrad", "The_Rising_Sun", "big_world", "big_world", "new_world_order"};
    private final HashMap<Integer, AITurn> hashTurns = new HashMap();
    private PlayerID player;
    private String gameName;
    private String fileName;
    private final String fileEnding;
    private final List<File> stratFileName = new ArrayList<File>();
    Properties stratProp;
    int mapType = -2;
    String strategy;

    public AIStrategy(String name) {
        this.fileEnding = ".moore_strat";
    }

    public void setPlayerID(PlayerID id) {
        this.player = id;
    }

    private String getFileName() {
        if (this.getMapType() >= 0) {
            return this.fileNames[this.getMapType()];
        }
        return "";
    }

    private void setGameName(String gN) {
        this.gameName = gN;
    }

    private String getGameName() {
        return this.gameName;
    }

    private int getMapType() {
        return this.mapType;
    }

    private String getFileEnding() {
        return this.fileEnding;
    }

    public Collection<Territory> getAIAmphibStrategy(int currentTurn) {
        if (this.hashTurns.containsKey(currentTurn)) {
            return this.hashTurns.get(currentTurn).getLandingTerrs();
        }
        return null;
    }

    public HashMap<UnitType, Integer> getAIPurchaseStrategy(int currentTurn) {
        if (this.hashTurns.containsKey(currentTurn)) {
            return this.hashTurns.get(currentTurn).getPurchaseScheme();
        }
        return null;
    }

    public HashMap<Territory, Integer> getAITerritoryStrategy(int currentTurn) {
        if (this.hashTurns.containsKey(currentTurn)) {
            return this.hashTurns.get(currentTurn).getTargetTerr();
        }
        return null;
    }

    public HashMap<UnitType, HashMap<Territory, Integer>> getAIPlacementStrategy(int currentTurn) {
        if (this.hashTurns.containsKey(currentTurn)) {
            return this.hashTurns.get(currentTurn).getPlaceScheme();
        }
        return null;
    }

    public void initializeAIStrategy(GameData data) {
        this.setGameName(data.getGameName());
        this.determineMapType(this.getGameName());
        this.setFilePathAndName(data);
        this.strategy = this.readStratFile();
        this.parseStrategy(data);
    }

    private void setFilePathAndName(GameData data) {
        List<File> addFiles;
        String dirName;
        String thisGame = data.getGameName().trim();
        if (this.mapType >= 0) {
            thisGame = this.getFileName();
        }
        String thisGame2 = thisGame;
        String dirName2 = dirName = (thisGame = thisGame.replace(' ', '_'));
        this.fileName = thisGame + this.getFileEnding();
        String fileName2 = thisGame2 + this.getFileEnding();
        dirName = dirName + File.separator + "AI" + File.separator + this.fileName;
        dirName2 = dirName2 + File.separator + "AI" + File.separator + fileName2;
        File userMapsFolder = GameRunner.getUserMapsFolder();
        File[] userFiles = userMapsFolder.listFiles(new SpecialFileFilter(".zip"));
        this.stratFileName.add(new File(GameRunner.getUserMapsFolder(), dirName));
        this.stratFileName.add(new File(new File(GameRunner.getRootFolder(), "maps"), dirName));
        this.stratFileName.add(new File(GameRunner.getUserMapsFolder(), dirName2));
        this.stratFileName.add(new File(new File(GameRunner.getRootFolder(), "maps"), dirName2));
        boolean addMore = this.moveFilesFromZip(userFiles);
        if (addMore && (addFiles = this.findFileFromTempAI(new File(userMapsFolder, "tempAI"))) != null) {
            this.stratFileName.addAll(addFiles);
        }
    }

    private List<File> findFileFromTempAI(File path) {
        if (path == null) {
            return null;
        }
        File[] allAIFiles = path.listFiles(new SpecialFileFilter(this.getFileEnding()));
        int numFiles = allAIFiles.length;
        if (numFiles == 0) {
            return null;
        }
        ArrayList<File> otherAIFiles = new ArrayList<File>();
        for (int i = 0; i < numFiles; ++i) {
            otherAIFiles.add(allAIFiles[i]);
        }
        return otherAIFiles;
    }

    private boolean moveFilesFromZip(File[] userFiles) {
        byte[] buffer = new byte[1024];
        boolean someFilesMoved = false;
        for (File openFile : userFiles) {
            String openPath = openFile.getParent();
            File createDir = new File(openPath, "tempAI");
            if (!createDir.isDirectory()) {
                if (createDir.exists()) {
                    JOptionPane.showMessageDialog(null, "The maps directory contains an invalid file named tempAI. Please delete it.");
                }
                try {
                    createDir.mkdirs();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            try {
                ZipFile zipFile = new ZipFile(openFile);
                Enumeration<? extends ZipEntry> entries = zipFile.entries();
                while (entries.hasMoreElements()) {
                    ZipEntry anEntry = entries.nextElement();
                    String checkThisEntry = anEntry.getName().trim();
                    if (!checkThisEntry.toLowerCase().startsWith("ai") || !checkThisEntry.endsWith(this.getFileEnding())) continue;
                    String fName = checkThisEntry.substring(3, checkThisEntry.length());
                    File createFile = new File(createDir, fName);
                    if (createFile.exists()) {
                        createFile.delete();
                    }
                    FileOutputStream oStream = new FileOutputStream(createFile);
                    InputStream ziStream = zipFile.getInputStream(anEntry);
                    int len = ziStream.read(buffer);
                    while (len > 0) {
                        oStream.write(buffer, 0, len);
                        len = ziStream.read(buffer);
                    }
                    oStream.close();
                    ziStream.close();
                    someFilesMoved = true;
                }
                zipFile.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return someFilesMoved;
    }

    private void determineMapType(String mapName) {
        for (int i = 0; i < 13; ++i) {
            if (!mapName.equals(this.mapNames[i])) continue;
            this.mapType = i;
        }
        if (this.mapType == -2) {
            this.mapType = -1;
        }
    }

    private Territory getTerritory(Collection<Territory> allTerritories, String terr) {
        for (Territory thisTerr : allTerritories) {
            if (!thisTerr.getName().equals(terr)) continue;
            return thisTerr;
        }
        return null;
    }

    private UnitType getUnitType(Collection<UnitType> allUnits, String unit) {
        for (UnitType thisUnit : allUnits) {
            if (!thisUnit.getName().equals(unit)) continue;
            return thisUnit;
        }
        return null;
    }

    public void makeStrategyFile() throws FileNotFoundException {
        try {
            FileOutputStream outputStream = new FileOutputStream(this.fileName);
            outputStream.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private String[] splitLine(String line) {
        String[] splitData = line.split("=");
        return splitData;
    }

    private boolean isComment(String line) {
        return line.trim().startsWith("//");
    }

    private String readStratFile() {
        String s = "";
        try {
            boolean fileFound = false;
            Iterator<File> fileIter = this.stratFileName.iterator();
            while (!fileFound && fileIter.hasNext()) {
                File tryThisFile = fileIter.next();
                if (!tryThisFile.exists()) continue;
                FileReader fileStream = new FileReader(tryThisFile);
                BufferedReader inputStream = new BufferedReader(fileStream);
                String line = inputStream.readLine();
                while (line != null && this.isComment(line)) {
                    line = inputStream.readLine();
                }
                if (line == null || !line.split("=")[1].toLowerCase().trim().equals(this.getGameName().toLowerCase().trim())) continue;
                boolean beginWriting = false;
                while (line != null) {
                    if (line.toLowerCase().trim().equals("player=" + this.player.getName().toLowerCase())) {
                        beginWriting = true;
                    }
                    if (!this.isComment(line) && beginWriting) {
                        s = s + line + ";";
                    }
                    if (line.toLowerCase().trim().equals("endplayer=" + this.player.getName().toLowerCase())) {
                        beginWriting = false;
                    }
                    line = inputStream.readLine();
                }
                inputStream.close();
                fileFound = true;
            }
        }
        catch (FileNotFoundException e) {
            return null;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return s;
    }

    private void parseStrategy(GameData data) {
        if (this.strategy == null) {
            return;
        }
        String[] allStrat = this.strategy.trim().split(";");
        int size = allStrat.length;
        if (size <= 1) {
            return;
        }
        int position = 0;
        Collection<Territory> allTerritories = data.getMap().getTerritories();
        boolean foundPlayer = false;
        String thisPlayer = this.player.getName();
        Set<UnitType> allUnits = data.getUnitTypeList().getAllUnitTypes();
        while (position < size) {
            String line;
            if ((line = allStrat[position++]) == null) continue;
            String[] command = this.splitLine(line);
            if (!foundPlayer && (foundPlayer = command[1].contains(thisPlayer))) {
                line = allStrat[position++];
            }
            if (!foundPlayer || line == null) continue;
            command = this.splitLine(line);
            int turn = 0;
            while (!command[0].toLowerCase().trim().contains("endplayer")) {
                if (command[0].toLowerCase().trim().contains("turn")) {
                    turn = Integer.parseInt(command[1]);
                }
                AITurn thisTurn = new AITurn(turn);
                line = allStrat[position++];
                command = this.splitLine(line);
                while (!command[0].toLowerCase().trim().contains("endturn")) {
                    UnitType nUnit;
                    int i;
                    int numTerr;
                    ArrayList<Territory> landingTerrs = new ArrayList<Territory>();
                    HashMap<Territory, Integer> targetTerrs = new HashMap<Territory, Integer>();
                    HashMap<UnitType, Integer> purchaseStrat = new HashMap<UnitType, Integer>();
                    HashMap<UnitType, HashMap<Territory, Integer>> placeStrat = new HashMap<UnitType, HashMap<Territory, Integer>>();
                    if (command[0].toLowerCase().trim().contains("amphibtargets")) {
                        numTerr = Integer.parseInt(command[1].trim());
                        for (i = 0; i < numTerr; ++i) {
                            Territory landingTerr;
                            if (!(command = (line = allStrat[position++]).split("="))[0].toLowerCase().trim().equals("target") || (landingTerr = this.getTerritory(allTerritories, command[1].trim())) == null) continue;
                            landingTerrs.add(landingTerr);
                        }
                        thisTurn.setLandingTerrs(landingTerrs);
                    } else if (command[0].toLowerCase().trim().contains("territory")) {
                        numTerr = Integer.parseInt(command[1].trim());
                        for (i = 0; i < numTerr; ++i) {
                            Territory nTerr;
                            if ((nTerr = this.getTerritory(allTerritories, (command = this.splitLine(line = allStrat[position++]))[0].trim())) == null) continue;
                            Integer thisNum = Integer.parseInt(command[1].trim());
                            targetTerrs.put(nTerr, thisNum);
                        }
                        thisTurn.setTargetTerr(targetTerrs);
                    } else if (command[0].toLowerCase().trim().contains("purchase")) {
                        int numPurchase = Integer.parseInt(command[1]);
                        for (i = 0; i < numPurchase; ++i) {
                            if ((nUnit = this.getUnitType(allUnits, (command = this.splitLine(line = allStrat[position++]))[0].trim())) == null) continue;
                            Integer thisNum = 0;
                            thisNum = command[1].toLowerCase().trim().equals("max") ? Integer.valueOf(-99) : Integer.valueOf(Integer.parseInt(command[1].trim()));
                            purchaseStrat.put(nUnit, thisNum);
                        }
                        thisTurn.setPurchaseScheme(purchaseStrat);
                    } else if (command[0].toLowerCase().trim().contains("placement")) {
                        int numPlace = Integer.parseInt(command[1].trim());
                        for (i = 0; i < numPlace; ++i) {
                            line = allStrat[position++];
                            command = this.splitLine(line);
                            nUnit = this.getUnitType(allUnits, command[0].trim());
                            int iNumForThisUnit = Integer.parseInt(command[1].trim());
                            HashMap<Territory, Integer> thisUnitMap = new HashMap<Territory, Integer>();
                            for (int j = 0; j < iNumForThisUnit; ++j) {
                                line = allStrat[position++];
                                command = this.splitLine(line);
                                Territory placeTerr = this.getTerritory(allTerritories, command[0].trim());
                                if (nUnit == null || placeTerr == null) continue;
                                Integer iPlaceNum = command[1].toLowerCase().trim().equals("max") ? Integer.valueOf(-99) : Integer.valueOf(Integer.parseInt(command[1].trim()));
                                thisUnitMap.put(placeTerr, iPlaceNum);
                            }
                            placeStrat.put(nUnit, thisUnitMap);
                        }
                        thisTurn.setPlaceScheme(placeStrat);
                    }
                    line = allStrat[position++];
                    command = this.splitLine(line);
                }
                this.hashTurns.put(turn, thisTurn);
                line = allStrat[position++];
                command = this.splitLine(line);
            }
        }
    }

    public void SaveStrategyResourceFile() throws IOException {
        FileOutputStream outputStream = new FileOutputStream(this.fileName);
        try {
            this.stratProp.storeToXML(outputStream, "Properties for " + this.player.getName());
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public class SpecialFileFilter
    implements FileFilter {
        String thisOnly;

        public SpecialFileFilter(String checkThis) {
            this.thisOnly = checkThis;
        }

        public boolean accept(File file) {
            return file.getName().trim().toLowerCase().endsWith(this.thisOnly);
        }
    }
}

