/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.triplea.ai.Dynamix_AI.Code;

import games.strategy.engine.data.GameData;
import games.strategy.engine.data.PlayerID;
import games.strategy.engine.data.Route;
import games.strategy.engine.data.Territory;
import games.strategy.engine.data.Unit;
import games.strategy.triplea.ai.Dynamix_AI.Code.DoNonCombatMove;
import games.strategy.triplea.ai.Dynamix_AI.CommandCenter.CachedCalculationCenter;
import games.strategy.triplea.ai.Dynamix_AI.CommandCenter.CachedInstanceCenter;
import games.strategy.triplea.ai.Dynamix_AI.CommandCenter.GlobalCenter;
import games.strategy.triplea.ai.Dynamix_AI.CommandCenter.ReconsiderSignalCenter;
import games.strategy.triplea.ai.Dynamix_AI.CommandCenter.ThreatInvalidationCenter;
import games.strategy.triplea.ai.Dynamix_AI.DMatches;
import games.strategy.triplea.ai.Dynamix_AI.DSettings;
import games.strategy.triplea.ai.Dynamix_AI.DUtils;
import games.strategy.triplea.ai.Dynamix_AI.Dynamix_AI;
import games.strategy.triplea.ai.Dynamix_AI.Group.MovePackage;
import games.strategy.triplea.ai.Dynamix_AI.Group.UnitGroup;
import games.strategy.triplea.ai.Dynamix_AI.Others.CM_Task;
import games.strategy.triplea.ai.Dynamix_AI.Others.CM_TaskType;
import games.strategy.triplea.attatchments.TerritoryAttachment;
import games.strategy.triplea.delegate.Matches;
import games.strategy.triplea.delegate.remote.IMoveDelegate;
import games.strategy.triplea.oddsCalculator.ta.AggregateResults;
import games.strategy.util.CompositeMatchAnd;
import games.strategy.util.CompositeMatchOr;
import games.strategy.util.Match;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import javax.swing.SwingUtilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DoCombatMove {
    public static void doCombatMove(Dynamix_AI ai, GameData data, IMoveDelegate mover, PlayerID player) {
        if (DSettings.LoadSettings().AIC_disableAllUnitMovements) {
            final String message = ai.getName() + " is skipping it's cm phase, as instructed.";
            DUtils.Log(Level.FINE, message, new Object[0]);
            Runnable runner = new Runnable(){

                public void run() {
                    CachedInstanceCenter.CachedDelegateBridge.getHistoryWriter().startEvent(message);
                }
            };
            try {
                SwingUtilities.invokeAndWait(runner);
            }
            catch (InterruptedException ex) {
            }
            catch (InvocationTargetException ex) {
                // empty catch block
            }
            Dynamix_AI.Pause();
            return;
        }
        MovePackage pack = new MovePackage(ai, data, mover, player, null, null, null);
        List<CM_Task> tasks = DoCombatMove.GenerateTasks(pack);
        List<Territory> ourCaps = TerritoryAttachment.getAllCapitals(player, data);
        ArrayList<Territory> capsAndNeighbors = new ArrayList<Territory>();
        for (Territory cap : ourCaps) {
            capsAndNeighbors.addAll(DUtils.GetTerritoriesWithinXDistanceOfY(data, cap, 1));
        }
        ArrayList<CM_Task> capsAndNeighborsAttackTasks = new ArrayList<CM_Task>();
        for (CM_Task task : tasks) {
            if (!capsAndNeighbors.contains(task.GetTarget())) continue;
            capsAndNeighborsAttackTasks.add(task);
        }
        DUtils.Log(Level.FINE, "  Beginning capital-protecting attacks on cap-neighboring enemies section", new Object[0]);
        while (DoCombatMove.considerAndPerformWorthwhileTasks(pack, capsAndNeighborsAttackTasks)) {
        }
        DoNonCombatMove.doPreCombatMove(ai, data, mover, player);
        DUtils.Log(Level.FINE, "  Beginning task consideration loop section", new Object[0]);
        for (int i = 0; i < 5; ++i) {
            DUtils.Log(Level.FINE, "  Task consideration loop {0} started", i + 1);
            ReconsiderSignalCenter.get((GameData)data, (PlayerID)player).ObjectsToReconsider.clear();
            ArrayList<Territory> tersAttackedBeforeLoop = new ArrayList<Territory>();
            for (CM_Task task : tasks) {
                if (!task.IsCompleted()) continue;
                tersAttackedBeforeLoop.add(task.GetTarget());
            }
            while (DoCombatMove.considerAndPerformWorthwhileTasks(pack, tasks)) {
            }
            if (ReconsiderSignalCenter.get((GameData)data, (PlayerID)player).ObjectsToReconsider.isEmpty()) break;
            List tersToReconsider = DUtils.ToList(ReconsiderSignalCenter.get((GameData)data, (PlayerID)player).ObjectsToReconsider);
            for (CM_Task task : tasks) {
                if (!tersToReconsider.contains(task.GetTarget()) || task.IsCompleted()) continue;
                task.Reset();
            }
        }
        DUtils.Log(Level.FINE, "  Calculating and adding additional task recruits. (Wave 2)", new Object[0]);
        for (CM_Task task : tasks) {
            if (!task.IsCompleted()) continue;
            task.RecruitUnits2();
            if (!task.IsTaskWithAdditionalRecruitsWorthwhile()) continue;
            task.PerformTask(mover);
            task.InvalidateThreatsThisTaskResists();
        }
        DUtils.Log(Level.FINE, "  Calculating and adding additional task recruits. (Wave 3)", new Object[0]);
        for (CM_Task task : tasks) {
            if (!task.IsCompleted()) continue;
            task.RecruitUnits3();
            if (!task.IsTaskWithAdditionalRecruitsWorthwhile()) continue;
            task.PerformTask(mover);
            task.InvalidateThreatsThisTaskResists();
        }
        ThreatInvalidationCenter.get(data, player).SuspendThreatInvalidation();
        DUtils.Log(Level.FINE, "  Calculating and adding additional task recruits. (Wave 4)", new Object[0]);
        for (CM_Task task : tasks) {
            if (!task.IsCompleted()) continue;
            task.RecruitUnits4();
            if (!task.IsTaskWithAdditionalRecruitsWorthwhile()) continue;
            task.PerformTask(mover);
            task.InvalidateThreatsThisTaskResists();
        }
        ThreatInvalidationCenter.get(data, player).ResumeThreatInvalidation();
        DUtils.Log(Level.FINE, "  Beginning of temporary ship movement block.", new Object[0]);
        UnitGroup.PerformBufferedMovesAndDisableMoveBufferring(mover);
        for (Territory ter : data.getMap().getTerritories()) {
            String error;
            UnitGroup ships;
            List<Unit> ourUnitGroup;
            if (!ter.isWater() || (ourUnitGroup = ter.getUnits().getMatches(Matches.unitIsOwnedBy(player))).isEmpty()) continue;
            int unfilledTransports = 0;
            int filledTransports = 0;
            for (Unit unit : ourUnitGroup) {
                if (!Matches.UnitIsTransport.match(unit)) continue;
                if (Matches.unitIsTransporting().match(unit)) {
                    ++filledTransports;
                    continue;
                }
                ++unfilledTransports;
            }
            if (unfilledTransports > 0 && filledTransports < 10) {
                Territory loadingTer = null;
                Territory loadingPort = null;
                int highestLoadingTerScore = Integer.MIN_VALUE;
                for (Territory ter2 : data.getMap().getTerritories()) {
                    List<Territory> areaTroubleTers;
                    if (ter2.isWater() || ter2.getUnits().getMatches(DUtils.CompMatchAnd(Matches.unitIsLandAndOwnedBy(player), Matches.UnitHasEnoughMovement(1), Matches.UnitCanBeTransported)).isEmpty() || (areaTroubleTers = DUtils.GetTerritoriesWithinXDistanceOfYMatchingZAndHavingRouteMatchingA(data, ter2, (int)(3.0f * GlobalCenter.MapTerCountScale), DUtils.CompMatchAnd(Matches.TerritoryIsLand, Matches.territoryHasEnemyLandUnits(player, data)), DMatches.TerritoryIsLandAndPassable)).size() > 0) continue;
                    Territory openPort = null;
                    for (Territory port : data.getMap().getNeighbors(ter2, Matches.TerritoryIsWater)) {
                        if (data.getMap().getRoute(ter2, port, DUtils.CompMatchAnd(Matches.TerritoryIsWater)) == null) continue;
                        openPort = port;
                        break;
                    }
                    if (openPort == null) continue;
                    int score = 0;
                    Route seaRoute = CachedCalculationCenter.GetSeaRoute(data, ter, openPort);
                    if (seaRoute == null || (score -= seaRoute.getLength()) <= highestLoadingTerScore) continue;
                    highestLoadingTerScore = score;
                    loadingTer = ter2;
                    loadingPort = openPort;
                }
                if (loadingTer == null) continue;
                ships = DUtils.CreateUnitGroupForUnits(ourUnitGroup, ter, data);
                error = ships.MoveAsFarTo_CM(loadingPort, mover);
                if (error != null) {
                    DUtils.Log(Level.FINER, "    There was an error moving ships[{0}] to loading port({1}->{2}): {3}", ships, ter, loadingPort, error);
                    continue;
                }
                List<Unit> toLoadOntoShips = loadingTer.getUnits().getMatches(DUtils.CompMatchAnd(Matches.unitIsLandAndOwnedBy(player), Matches.UnitHasEnoughMovement(1), Matches.UnitCanBeTransported));
                for (Unit unit : toLoadOntoShips) {
                    UnitGroup ug = DUtils.CreateUnitGroupForUnit(unit, loadingTer, data);
                    String error2 = ug.MoveAsFarTo_NCM(loadingPort, mover);
                    if (error2 != null) {
                        DUtils.Log(Level.FINER, "    There was an error moving units[{0}] onto ship({1}->{2}): {3}", ug, loadingTer, loadingPort, error2);
                        continue;
                    }
                    ourUnitGroup.add(unit);
                }
            } else if (filledTransports == 0) {
                Territory closestTerWithOtherShips = DUtils.GetClosestTerMatchingX(data, ter, DUtils.CompMatchAnd(Matches.TerritoryIsWater, Matches.territoryIs(ter).invert(), Matches.territoryHasUnitsThatMatch(Matches.unitIsOwnedBy(player))));
                for (Unit unit : ourUnitGroup) {
                    UnitGroup ug = DUtils.CreateUnitGroupForUnit(unit, ter, data);
                    ug.MoveAsFarTo_CM(closestTerWithOtherShips, mover);
                }
            }
            unfilledTransports = 0;
            filledTransports = 0;
            for (Unit unit : ourUnitGroup) {
                if (!Matches.UnitIsTransport.match(unit)) continue;
                if (Matches.unitIsTransporting().match(unit)) {
                    ++filledTransports;
                    continue;
                }
                ++unfilledTransports;
            }
            Territory unloadingTer = null;
            Territory unloadingPort = null;
            int highestUnloadingTerScore = Integer.MIN_VALUE;
            for (Territory ter2 : data.getMap().getTerritories()) {
                List<Territory> continentTroubleTers;
                if (ter2.isWater() || !Matches.TerritoryIsPassableAndNotRestricted(player, data).match(ter2)) continue;
                Territory openPort = null;
                for (Territory port : data.getMap().getNeighbors(ter2, Matches.TerritoryIsWater)) {
                    if (data.getMap().getRoute(ourUnitGroup.get(0).getTerritoryUnitIsIn(), port, DUtils.CompMatchAnd(Matches.TerritoryIsWater)) == null) continue;
                    openPort = port;
                    break;
                }
                if (openPort == null) continue;
                int score = 0;
                List<Territory> areaTroubleTers = DUtils.GetTerritoriesWithinXDistanceOfYMatchingZAndHavingRouteMatchingA(data, ter2, (int)(3.0f * GlobalCenter.MapTerCountScale), DUtils.CompMatchAnd(Matches.TerritoryIsLand, Matches.territoryHasEnemyLandUnits(player, data)), DMatches.TerritoryIsLandAndPassable);
                if (areaTroubleTers.isEmpty()) {
                    score -= 1000000000;
                }
                if ((continentTroubleTers = DUtils.GetTerritoriesWithinXDistanceOfYMatchingZAndHavingRouteMatchingA(data, ter2, Integer.MAX_VALUE, DUtils.CompMatchAnd(Matches.TerritoryIsLand, Matches.territoryHasEnemyLandUnits(player, data)), DMatches.TerritoryIsLandAndPassable)).isEmpty()) {
                    score -= 10000000;
                }
                score -= CachedCalculationCenter.GetSeaRoute(data, ourUnitGroup.get(0).getTerritoryUnitIsIn(), openPort).getLength() * 100000;
                score -= ter2.getUnits().getMatches(Matches.unitIsEnemyOf(data, player)).size() * 100;
                if ((score += TerritoryAttachment.get(ter2).getProduction()) <= highestUnloadingTerScore) continue;
                highestUnloadingTerScore = score;
                unloadingTer = ter2;
                unloadingPort = openPort;
            }
            if (unloadingTer == null || unfilledTransports > 0 && unloadingPort != ourUnitGroup.get(0).getTerritoryUnitIsIn() && filledTransports < 10) continue;
            ships = DUtils.CreateUnitGroupForUnits(ourUnitGroup, ourUnitGroup.get(0).getTerritoryUnitIsIn(), data);
            error = ships.MoveAsFarTo_CM(unloadingPort, mover);
            if (error != null) {
                DUtils.Log(Level.FINER, "    There was an error moving ships[{0}] to unloading port({1}->{2}): {3}", ships, ourUnitGroup.get(0).getTerritoryUnitIsIn(), unloadingPort, error);
                continue;
            }
            for (Unit unit : Match.getMatches(ourUnitGroup, DUtils.CompMatchAnd(Matches.UnitIsLand))) {
                UnitGroup ug = DUtils.CreateUnitGroupForUnit(unit, unloadingPort, data);
                String error2 = ug.MoveAsFarTo_CM(unloadingTer, mover);
                if (error2 == null) continue;
                DUtils.Log(Level.FINER, "    There was an error moving units[{0}] to unloading ter({1}->{2}): {3}", ug, unloadingPort, unloadingTer, error2);
            }
        }
    }

    private static List<CM_Task> GenerateTasks(MovePackage pack) {
        ArrayList<CM_Task> result = new ArrayList<CM_Task>();
        final GameData data = pack.Data;
        final PlayerID player = pack.Player;
        final List<Territory> ourCaps = TerritoryAttachment.getAllCapitals(player, data);
        Match<Territory> isLandGrab = new Match<Territory>(){

            @Override
            public boolean match(Territory ter) {
                if (!DSettings.LoadSettings().TR_enableAttackLandGrab) {
                    return false;
                }
                if (ter.isWater()) {
                    return false;
                }
                if (TerritoryAttachment.get(ter) == null || TerritoryAttachment.get(ter).getIsImpassible()) {
                    return false;
                }
                if (data.getRelationshipTracker().isAllied(ter.getOwner(), player)) {
                    return false;
                }
                if (TerritoryAttachment.get(ter) == null) {
                    return false;
                }
                if (TerritoryAttachment.get(ter).getProduction() < 1) {
                    return false;
                }
                return ter.getUnits().getMatches(new CompositeMatchAnd<Unit>(Matches.unitHasDefenseThatIsMoreThanOrEqualTo(1), Matches.unitIsEnemyOf(data, player), Matches.UnitIsNotAA)).size() <= 0;
            }
        };
        final ArrayList<Territory> capsAndNeighbors = new ArrayList<Territory>();
        for (Territory cap : ourCaps) {
            capsAndNeighbors.addAll(DUtils.GetTerritoriesWithinXDistanceOfY(data, cap, 1));
        }
        Match<Territory> isAttack_Stabilize = new Match<Territory>(){

            @Override
            public boolean match(Territory ter) {
                if (!DSettings.LoadSettings().TR_enableAttackStabalize) {
                    return false;
                }
                if (ter.isWater()) {
                    return false;
                }
                if (TerritoryAttachment.get(ter) == null || TerritoryAttachment.get(ter).getIsImpassible()) {
                    return false;
                }
                if (ter.getOwner() != null && data.getRelationshipTracker().isAllied(ter.getOwner(), player)) {
                    return false;
                }
                return !(GlobalCenter.IsFFAGame ? !capsAndNeighbors.contains(ter) : !ourCaps.contains(ter));
            }
        };
        Match<Territory> isAttack_Offensive = new Match<Territory>(){

            @Override
            public boolean match(Territory ter) {
                if (!DSettings.LoadSettings().TR_enableAttackOffensive) {
                    return false;
                }
                if (ter.isWater()) {
                    return false;
                }
                if (TerritoryAttachment.get(ter) == null || TerritoryAttachment.get(ter).getIsImpassible()) {
                    return false;
                }
                return ter.getOwner() == null || !data.getRelationshipTracker().isAllied(ter.getOwner(), player);
            }
        };
        Match<Territory> isAttack_Trade = new Match<Territory>(){

            @Override
            public boolean match(Territory ter) {
                if (!DSettings.LoadSettings().TR_enableAttackTrade) {
                    return false;
                }
                if (ter.isWater()) {
                    return false;
                }
                if (TerritoryAttachment.get(ter) == null || TerritoryAttachment.get(ter).getIsImpassible()) {
                    return false;
                }
                if (ter.getOwner() != null && data.getRelationshipTracker().isAllied(ter.getOwner(), player)) {
                    return false;
                }
                return !ter.getUnits().getMatches(new CompositeMatchAnd<Unit>(Matches.unitHasDefenseThatIsMoreThanOrEqualTo(1), Matches.unitIsEnemyOf(data, player), Matches.UnitIsNotAA)).isEmpty();
            }
        };
        List<Territory> tersWeCanAttack = DUtils.GetEnemyTersThatCanBeAttackedByUnitsOwnedBy(data, player);
        DUtils.Log(Level.FINE, "  Beginning task creation loop. tersWeCanAttack: {0}", tersWeCanAttack);
        for (Territory ter : tersWeCanAttack) {
            CM_Task task;
            float priority;
            AggregateResults results;
            List<Unit> possibleAttackers;
            if (isAttack_Trade.match(ter)) {
                possibleAttackers = DUtils.GetUnitsOwnedByPlayerThatCanReach(data, ter, player, Matches.TerritoryIsLandOrWater);
                Match[] matchArray = new Match[]{Matches.UnitIsLand, Matches.UnitIsAir};
                results = DUtils.GetBattleResults(possibleAttackers = Match.getMatches(possibleAttackers, new CompositeMatchOr(matchArray)), DUtils.ToList(ter.getUnits().getUnits()), ter, data, DSettings.LoadSettings().CA_CM_determinesIfTaskCreationsWorthwhileBasedOnTakeoverChance, true);
                if (results.getAttackerWinPercent() > 0.5) {
                    priority = DUtils.GetCMTaskPriority_Trade(data, player, ter);
                    task = new CM_Task(data, ter, CM_TaskType.Land_Attack_Trade, priority);
                    result.add(task);
                    DUtils.Log(Level.FINER, "    Attack_Trade task added. Ter: {0} Priority: {1}", ter.getName(), Float.valueOf(priority));
                }
            }
            if (isLandGrab.match(ter)) {
                float priority2 = DUtils.GetCMTaskPriority_LandGrab(data, player, ter);
                CM_Task task2 = new CM_Task(data, ter, CM_TaskType.Land_LandGrab, priority2);
                result.add(task2);
                DUtils.Log(Level.FINER, "    Land grab task added. Ter: {0} Priority: {1}", ter.getName(), Float.valueOf(priority2));
                continue;
            }
            if (isAttack_Stabilize.match(ter)) {
                possibleAttackers = DUtils.GetUnitsOwnedByPlayerThatCanReach(data, ter, player, Matches.TerritoryIsLandOrWater);
                results = DUtils.GetBattleResults(possibleAttackers = Match.getMatches(possibleAttackers, new CompositeMatchOr(Matches.UnitIsLand, Matches.UnitIsAir)), DUtils.ToList(ter.getUnits().getUnits()), ter, data, DSettings.LoadSettings().CA_CM_determinesIfTaskCreationsWorthwhileBasedOnTakeoverChance, true);
                if (results.getAttackerWinPercent() < 0.25) continue;
                priority = DUtils.GetCMTaskPriority_Stabalization(data, player, ter);
                task = new CM_Task(data, ter, CM_TaskType.Land_Attack_Stabilize, priority);
                result.add(task);
                DUtils.Log(Level.FINER, "    Attack_Stabilize task added. Ter: {0} Priority: {1}", ter.getName(), Float.valueOf(priority));
                continue;
            }
            if (!isAttack_Offensive.match(ter)) continue;
            possibleAttackers = DUtils.GetUnitsOwnedByPlayerThatCanReach(data, ter, player, Matches.TerritoryIsLandOrWater);
            results = DUtils.GetBattleResults(possibleAttackers = Match.getMatches(possibleAttackers, new CompositeMatchOr(Matches.UnitIsLand, Matches.UnitIsAir)), DUtils.ToList(ter.getUnits().getUnits()), ter, data, DSettings.LoadSettings().CA_CM_determinesIfTaskCreationsWorthwhileBasedOnTakeoverChance, true);
            if (results.getAttackerWinPercent() < (double)0.2f) continue;
            priority = DUtils.GetCMTaskPriority_Offensive(data, player, ter);
            task = new CM_Task(data, ter, CM_TaskType.Land_Attack_Offensive, priority);
            result.add(task);
            DUtils.Log(Level.FINER, "    Attack_Offensive task added. Ter: {0} Priority: {1}", ter.getName(), Float.valueOf(priority));
        }
        return result;
    }

    private static boolean considerAndPerformWorthwhileTasks(MovePackage pack, List<CM_Task> tasks) {
        GameData data = pack.Data;
        PlayerID player = pack.Player;
        IMoveDelegate mover = pack.Mover;
        CM_Task highestPriorityTask = null;
        float highestTaskPriority = -2.1474836E9f;
        for (CM_Task task : tasks) {
            float priority;
            if (task.IsDisqualified() || task.IsCompleted() || !((priority = task.GetPriority()) > highestTaskPriority)) continue;
            highestPriorityTask = task;
            highestTaskPriority = priority;
        }
        if (highestPriorityTask != null) {
            highestPriorityTask.CalculateTaskRequirements();
            highestPriorityTask.RecruitUnits();
            if (highestPriorityTask.IsPlannedAttackWorthwhile(tasks)) {
                DUtils.Log(Level.FINER, "      Task worthwhile, performing planned task.", new Object[0]);
                highestPriorityTask.PerformTask(mover);
                highestPriorityTask.InvalidateThreatsThisTaskResists();
            } else {
                highestPriorityTask.Disqualify();
            }
        }
        return highestPriorityTask != null;
    }
}

