/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.triplea.ai.Dynamix_AI.Code;

import games.strategy.engine.data.GameData;
import games.strategy.engine.data.PlayerID;
import games.strategy.engine.data.Route;
import games.strategy.engine.data.Territory;
import games.strategy.engine.data.Unit;
import games.strategy.triplea.ai.Dynamix_AI.CommandCenter.CachedInstanceCenter;
import games.strategy.triplea.ai.Dynamix_AI.CommandCenter.GlobalCenter;
import games.strategy.triplea.ai.Dynamix_AI.CommandCenter.ReconsiderSignalCenter;
import games.strategy.triplea.ai.Dynamix_AI.CommandCenter.StatusCenter;
import games.strategy.triplea.ai.Dynamix_AI.CommandCenter.StrategyCenter;
import games.strategy.triplea.ai.Dynamix_AI.CommandCenter.TacticalCenter;
import games.strategy.triplea.ai.Dynamix_AI.CommandCenter.ThreatInvalidationCenter;
import games.strategy.triplea.ai.Dynamix_AI.DMatches;
import games.strategy.triplea.ai.Dynamix_AI.DSettings;
import games.strategy.triplea.ai.Dynamix_AI.DUtils;
import games.strategy.triplea.ai.Dynamix_AI.Dynamix_AI;
import games.strategy.triplea.ai.Dynamix_AI.Group.MovePackage;
import games.strategy.triplea.ai.Dynamix_AI.Group.UnitGroup;
import games.strategy.triplea.ai.Dynamix_AI.Others.NCM_AirLandingCalculator;
import games.strategy.triplea.ai.Dynamix_AI.Others.NCM_Call;
import games.strategy.triplea.ai.Dynamix_AI.Others.NCM_CallType;
import games.strategy.triplea.ai.Dynamix_AI.Others.NCM_TargetCalculator;
import games.strategy.triplea.ai.Dynamix_AI.Others.NCM_Task;
import games.strategy.triplea.ai.Dynamix_AI.Others.NCM_TaskType;
import games.strategy.triplea.ai.Dynamix_AI.Others.StrategyType;
import games.strategy.triplea.attatchments.TerritoryAttachment;
import games.strategy.triplea.delegate.Matches;
import games.strategy.triplea.delegate.remote.IMoveDelegate;
import games.strategy.triplea.oddsCalculator.ta.AggregateResults;
import games.strategy.util.CompositeMatchAnd;
import games.strategy.util.Match;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Level;
import javax.swing.SwingUtilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DoNonCombatMove {
    public static void doPreCombatMove(Dynamix_AI ai, GameData data, IMoveDelegate mover, PlayerID player) {
        DUtils.Log(Level.FINE, "  Beginning pre-combat move section", new Object[0]);
        Territory ourCap = TerritoryAttachment.getCapital(player, data);
        if (DUtils.GetTerTakeoverChanceAtEndOfTurn(data, player, ourCap) > 0.1f) {
            float priority = DUtils.GetNCMTaskPriority_Stabalize(data, player, ourCap);
            NCM_Task task = new NCM_Task(data, ourCap, NCM_TaskType.Land_Reinforce_Stabilize, priority);
            task.SetTaskRequirements(0.1f);
            task.RecruitUnits();
            if (task.IsPlannedMoveWorthwhile(Arrays.asList(task))) {
                DUtils.Log(Level.FINE, "    Pre-combat-move capital reinforcement task being performed.", new Object[0]);
                task.PerformTask(mover);
            }
            TacticalCenter.NotifyStartOfRound();
            ThreatInvalidationCenter.NotifyStartOfRound();
        }
    }

    public static void doNonCombatMove(Dynamix_AI ai, GameData data, IMoveDelegate mover, PlayerID player) {
        if (DSettings.LoadSettings().AIC_disableAllUnitMovements) {
            final String message = ai.getName() + " is skipping it's ncm phase, as instructed.";
            DUtils.Log(Level.FINE, message, new Object[0]);
            Runnable runner = new Runnable(){

                public void run() {
                    CachedInstanceCenter.CachedDelegateBridge.getHistoryWriter().startEvent(message);
                }
            };
            try {
                SwingUtilities.invokeAndWait(runner);
            }
            catch (InterruptedException ex) {
            }
            catch (InvocationTargetException ex) {
                // empty catch block
            }
            Dynamix_AI.Pause();
            return;
        }
        MovePackage pack = new MovePackage(ai, data, mover, player, null, null, null);
        List<NCM_Task> tasks = DoNonCombatMove.GenerateTasks(pack);
        DUtils.Log(Level.FINE, "  Beginning task consideration loop section", new Object[0]);
        for (int i = 0; i < 5; ++i) {
            DUtils.Log(Level.FINE, "  Task consideration loop {0} started", i + 1);
            ReconsiderSignalCenter.get((GameData)data, (PlayerID)player).ObjectsToReconsider.clear();
            ArrayList<Territory> tersAttackedBeforeLoop = new ArrayList<Territory>();
            for (NCM_Task task : tasks) {
                if (!task.IsCompleted()) continue;
                tersAttackedBeforeLoop.add(task.GetTarget());
            }
            while (DoNonCombatMove.considerAndPerformWorthwhileTasks(pack, tasks)) {
            }
            if (ReconsiderSignalCenter.get((GameData)data, (PlayerID)player).ObjectsToReconsider.isEmpty()) break;
            List tersToReconsider = DUtils.ToList(ReconsiderSignalCenter.get((GameData)data, (PlayerID)player).ObjectsToReconsider);
            for (NCM_Task task : tasks) {
                if (!tersToReconsider.contains(task.GetTarget()) || task.IsCompleted()) continue;
                task.Reset();
            }
        }
        DUtils.Log(Level.FINE, "  Performing target retreats on diqualified tasks.", new Object[0]);
        for (NCM_Task task : tasks) {
            if (!task.IsDisqualified()) continue;
            task.PerformTargetRetreat(tasks, mover);
            StatusCenter.get((GameData)data, (PlayerID)GlobalCenter.CurrentPlayer).GetStatusOfTerritory((Territory)task.GetTarget()).WasRetreatedFrom = true;
        }
        DUtils.Log(Level.FINE, "  Calculating and adding additional task recruits. (Wave 2)", new Object[0]);
        for (NCM_Task task : tasks) {
            if (!task.IsCompleted()) continue;
            task.RecruitUnits2();
            if (!task.IsTaskWithAdditionalRecruitsWorthwhile()) continue;
            task.PerformTask(mover);
            task.InvalidateThreatsThisTaskResists();
        }
        DUtils.Log(Level.FINE, "  Calculating and adding additional task recruits. (Wave 3)", new Object[0]);
        for (NCM_Task task : tasks) {
            if (!task.IsCompleted()) continue;
            task.RecruitUnits3();
            if (!task.IsTaskWithAdditionalRecruitsWorthwhile()) continue;
            task.PerformTask(mover);
            task.InvalidateThreatsThisTaskResists();
        }
        ThreatInvalidationCenter.get(data, player).SuspendThreatInvalidation();
        DUtils.Log(Level.FINE, "  Calculating and adding additional task recruits. (Wave 4)", new Object[0]);
        for (NCM_Task task : tasks) {
            if (!task.IsCompleted()) continue;
            task.RecruitUnits4();
            if (!task.IsTaskWithAdditionalRecruitsWorthwhile()) continue;
            task.PerformTask(mover);
            task.InvalidateThreatsThisTaskResists();
        }
        ThreatInvalidationCenter.get(data, player).ResumeThreatInvalidation();
        List<NCM_Call> calls = DoNonCombatMove.GenerateCalls(pack);
        DUtils.Log(Level.FINE, "  Beginning call consideration section", new Object[0]);
        while (DoNonCombatMove.considerAndPerformWorthwhileCalls(pack, calls)) {
        }
        DUtils.Log(Level.FINE, "  Calculating and performing regular ncm move-to-target moves.", new Object[0]);
        for (Territory ter : DUtils.ShuffleList(data.getMap().getTerritories())) {
            Unit firstAA;
            if (!DMatches.territoryIsOwnedByXOrAlly(data, player).match(ter)) continue;
            List<Unit> terUnits = ter.getUnits().getMatches(DUtils.CompMatchAnd(Matches.unitIsOwnedBy(player), Matches.unitHasMovementLeft, Matches.UnitIsNotAir));
            if (ter.getUnits().getMatches(Matches.UnitCanProduceUnitsAndCanBeDamaged).size() > 0 && (firstAA = DUtils.GetFirstUnitMatching(terUnits, Matches.UnitIsAAforAnything, 0)) != null) {
                terUnits.remove(firstAA);
            }
            terUnits.removeAll(TacticalCenter.get(data, player).GetFrozenUnits());
            if (terUnits.isEmpty()) continue;
            DoNonCombatMove.doNonCombatMoveForTer(pack, ter, terUnits, tasks);
        }
        ThreatInvalidationCenter.get(data, player).ClearInvalidatedThreats();
        DUtils.Log(Level.FINE, "  Attempting to land aircraft on safe territories.", new Object[0]);
        for (Territory ter : data.getMap().getTerritories()) {
            List<Unit> airUnits = ter.getUnits().getMatches(DUtils.CompMatchAnd(Matches.unitIsOwnedBy(player), Matches.unitHasMovementLeft, Matches.UnitIsAir));
            if (airUnits.isEmpty()) continue;
            Territory landingLoc = NCM_AirLandingCalculator.CalculateLandingLocationForAirUnits(data, player, ter, airUnits, tasks);
            if (landingLoc == null) {
                DUtils.Log(Level.FINER, "    Landing location not found. Ter: {0} Air Units: {1}", ter, DUtils.UnitList_ToString(airUnits));
                continue;
            }
            List<UnitGroup> ugs = DUtils.CreateUnitGroupsForUnits(airUnits, ter, data);
            DUtils.Log(Level.FINER, "    Landing aircraft at {0}. From: {1}.", landingLoc, ter);
            UnitGroup.EnableMoveBuffering();
            for (UnitGroup ug : ugs) {
                String error = ug.MoveAsFarTo_NCM(landingLoc, mover);
                if (error != null) {
                    DUtils.Log(Level.FINEST, "        Landing failed, reason: {0}", error);
                    continue;
                }
                TacticalCenter.get(data, player).FreezeUnits(airUnits);
            }
            String errors = UnitGroup.PerformBufferedMovesAndDisableMoveBufferring(mover);
            if (errors == null) continue;
            DUtils.Log(Level.FINER, "      Some errors occurred while performing moves: {0}", errors);
        }
    }

    private static List<NCM_Task> GenerateTasks(MovePackage pack) {
        ArrayList<NCM_Task> result = new ArrayList<NCM_Task>();
        final GameData data = pack.Data;
        final PlayerID player = pack.Player;
        final List<Territory> ourCaps = TerritoryAttachment.getAllCapitals(player, data);
        Match<Territory> isLand_Reinforce_Block = new Match<Territory>(){

            @Override
            public boolean match(Territory ter) {
                if (!DSettings.LoadSettings().TR_enableReinforceBlock) {
                    return false;
                }
                if (ter.isWater()) {
                    return false;
                }
                if (DUtils.GetNNNEnemyUnitsThatCanReach(data, ter, player, Matches.TerritoryIsLandOrWater, 1).isEmpty()) {
                    return false;
                }
                if (!DMatches.territoryIsOwnedByXOrAlly(data, player).match(ter) && !CachedInstanceCenter.CachedBattleTracker.wasConquered(ter)) {
                    return false;
                }
                if (Match.getMatches(DUtils.GetTerUnitsAtEndOfTurn(data, player, ter), Matches.unitHasDefenseThatIsMoreThanOrEqualTo(1)).size() > 0) {
                    return false;
                }
                if (data.getMap().getNeighbors(ter, DMatches.territoryIsOwnedByNNEnemy(data, player)).isEmpty()) {
                    return false;
                }
                List<Unit> blitzers = DUtils.GetNNEnemyLUnitsThatCanReach(data, ter, player, Matches.TerritoryIsLandOrWater);
                if (blitzers.isEmpty()) {
                    return false;
                }
                return !data.getMap().getNeighbors(ter, DMatches.terIsFriendlyEmptyAndWithoutEnemyNeighbors(data, player)).isEmpty();
            }
        };
        final ArrayList<Territory> capsAndNeighbors = new ArrayList<Territory>();
        for (Territory cap : ourCaps) {
            capsAndNeighbors.addAll(DUtils.GetTerritoriesWithinXDistanceOfY(data, cap, 1));
        }
        Match<Territory> isLand_Reinforce_Stabilize = new Match<Territory>(){

            @Override
            public boolean match(Territory ter) {
                if (!DSettings.LoadSettings().TR_enableReinforceStabalize) {
                    return false;
                }
                if (ter.isWater()) {
                    return false;
                }
                if (DUtils.GetNNNEnemyUnitsThatCanReach(data, ter, player, Matches.TerritoryIsLandOrWater, 1).isEmpty()) {
                    return false;
                }
                if (!DMatches.territoryIsOwnedByXOrAlly(data, player).match(ter)) {
                    return false;
                }
                return !(GlobalCenter.IsFFAGame ? !capsAndNeighbors.contains(ter) : !ourCaps.contains(ter));
            }
        };
        Match<Territory> isLand_Reinforce_FrontLine = new Match<Territory>(){

            @Override
            public boolean match(Territory ter) {
                if (!DSettings.LoadSettings().TR_enableReinforceFrontLine) {
                    return false;
                }
                if (ter.isWater()) {
                    return false;
                }
                if (!DMatches.territoryIsOwnedByXOrAlly(data, player).match(ter)) {
                    return false;
                }
                if (data.getMap().getNeighbors(ter, DMatches.territoryIsOwnedByNNEnemy(data, player)).isEmpty()) {
                    return false;
                }
                List friendlyNeighbors = DUtils.ToList(data.getMap().getNeighbors(ter, DMatches.territoryIsOwnedByXOrAlly(data, player)));
                List uniqueEnemyNeighbors = DUtils.ToList(data.getMap().getNeighbors(ter, DMatches.territoryIsOwnedByNNEnemy(data, player)));
                boolean isTerLinkBetweenFriendlies = false;
                for (Territory friendlyNeighbor : friendlyNeighbors) {
                    for (Territory friendlyNeighbor2 : friendlyNeighbors) {
                        if (friendlyNeighbor2.equals(friendlyNeighbor) || data.getMap().isValidRoute(new Route(friendlyNeighbor, friendlyNeighbor2))) continue;
                        isTerLinkBetweenFriendlies = true;
                    }
                }
                for (Territory neighbor : friendlyNeighbors) {
                    if (neighbor.getUnits().size() <= 1) continue;
                    List n_EnemyNeighbors = DUtils.ToList(data.getMap().getNeighbors(neighbor, DMatches.territoryIsOwnedByNNEnemy(data, player)));
                    uniqueEnemyNeighbors.removeAll(n_EnemyNeighbors);
                }
                if (uniqueEnemyNeighbors.isEmpty() && !isTerLinkBetweenFriendlies) {
                    return false;
                }
                return !DUtils.GetNNNEnemyUnitsThatCanReach(data, ter, player, Matches.TerritoryIsLandOrWater, 1).isEmpty();
            }
        };
        List<Territory> tersWeCanMoveTo = DUtils.GetLandTersThatCanBeReinforcedByUnitsOwnedBy(data, player);
        DUtils.Log(Level.FINE, "  Beginning task creation loop.", new Object[0]);
        for (Territory ter : tersWeCanMoveTo) {
            NCM_Task task;
            float priority;
            if (isLand_Reinforce_Block.match(ter)) {
                priority = DUtils.GetNCMTaskPriority_Block(data, player, ter);
                task = new NCM_Task(data, ter, NCM_TaskType.Land_Reinforce_Block, priority);
                result.add(task);
                DUtils.Log(Level.FINER, "     Reinforce block task added. Ter: {0} Priority: {1}", ter.getName(), Float.valueOf(priority));
                continue;
            }
            if (isLand_Reinforce_Stabilize.match(ter)) {
                priority = DUtils.GetNCMTaskPriority_Stabalize(data, player, ter);
                task = new NCM_Task(data, ter, NCM_TaskType.Land_Reinforce_Stabilize, priority);
                result.add(task);
                DUtils.Log(Level.FINER, "     Reinforce stabalize task added. Ter: {0} Priority: {1}", ter.getName(), Float.valueOf(priority));
                continue;
            }
            if (!isLand_Reinforce_FrontLine.match(ter)) continue;
            priority = DUtils.GetNCMTaskPriority_Frontline(data, player, ter);
            task = new NCM_Task(data, ter, NCM_TaskType.Land_Reinforce_FrontLine, priority);
            result.add(task);
            DUtils.Log(Level.FINER, "     Reinforce frontline task added. Ter: {0} Priority: {1}", ter.getName(), Float.valueOf(priority));
        }
        return result;
    }

    private static boolean considerAndPerformWorthwhileTasks(MovePackage pack, List<NCM_Task> tasks) {
        GameData data = pack.Data;
        PlayerID player = pack.Player;
        IMoveDelegate mover = pack.Mover;
        NCM_Task highestPriorityTask = null;
        float highestTaskPriority = -2.1474836E9f;
        for (NCM_Task task : tasks) {
            float priority;
            if (task.IsDisqualified() || task.IsCompleted() || !((priority = task.GetPriority()) > highestTaskPriority)) continue;
            highestPriorityTask = task;
            highestTaskPriority = priority;
        }
        if (highestPriorityTask != null) {
            highestPriorityTask.CalculateTaskRequirements();
            highestPriorityTask.RecruitUnits();
            if (highestPriorityTask.IsPlannedMoveWorthwhile(tasks)) {
                DUtils.Log(Level.FINER, "      Task worthwhile, performing planned task.", new Object[0]);
                highestPriorityTask.PerformTask(mover);
                highestPriorityTask.InvalidateThreatsThisTaskResists();
            } else {
                highestPriorityTask.Disqualify();
            }
        }
        return highestPriorityTask != null;
    }

    private static List<NCM_Call> GenerateCalls(MovePackage pack) {
        ArrayList<NCM_Call> result = new ArrayList<NCM_Call>();
        final GameData data = pack.Data;
        final PlayerID player = pack.Player;
        final List<Territory> ourCaps = TerritoryAttachment.getAllCapitals(player, data);
        Match<Territory> isLandGrabCall = new Match<Territory>(){

            @Override
            public boolean match(Territory ter) {
                if (!DSettings.LoadSettings().CR_enableCallForLandGrab) {
                    return false;
                }
                if (ter.isWater()) {
                    return false;
                }
                if (TerritoryAttachment.get(ter) == null || TerritoryAttachment.get(ter).getIsImpassible()) {
                    return false;
                }
                if (data.getRelationshipTracker().isAllied(ter.getOwner(), player)) {
                    return false;
                }
                if (TerritoryAttachment.get(ter).getProduction() < 1) {
                    return false;
                }
                if (ter.getUnits().getMatches(new CompositeMatchAnd<Unit>(Matches.unitHasDefenseThatIsMoreThanOrEqualTo(1), Matches.unitIsEnemyOf(data, player), Matches.UnitIsNotAA)).size() > 0) {
                    return false;
                }
                if (Match.getMatches(DUtils.GetUnitsOwnedByPlayerThatCanReach(data, ter, player, Matches.TerritoryIsLandOrWater), Matches.UnitIsLand).size() > 0) {
                    return false;
                }
                return !data.getMap().getNeighbors(ter, DMatches.territoryIsOwnedByXOrAlly(data, player)).isEmpty();
            }
        };
        Match<Territory> isDefensiveFrontCall = new Match<Territory>(){

            @Override
            public boolean match(Territory ter) {
                if (!DSettings.LoadSettings().CR_enableCallForDefensiveFront) {
                    return false;
                }
                if (ter.isWater()) {
                    return false;
                }
                if (TerritoryAttachment.get(ter) == null || TerritoryAttachment.get(ter).getIsImpassible()) {
                    return false;
                }
                if (!data.getRelationshipTracker().isAllied(ter.getOwner(), player)) {
                    return false;
                }
                List<Unit> attackers = DUtils.GetNNEnemyUnitsThatCanReach(data, ter, player, Matches.TerritoryIsLandOrWater);
                if (attackers.isEmpty()) {
                    return false;
                }
                List<Unit> spAttackers = DUtils.GetSPUnitsInList(attackers);
                if (spAttackers.isEmpty()) {
                    return false;
                }
                PlayerID mainAttacker = spAttackers.get(0).getOwner();
                StrategyType strategy = StrategyCenter.get(data, player).GetCalculatedStrategyAssignments().get(mainAttacker);
                if (strategy != StrategyType.Enemy_Defensive) {
                    return false;
                }
                List<Unit> defenders = DUtils.GetUnitsOwnedByPlayerThatCanReach(data, ter, player, Matches.TerritoryIsLandOrWater);
                defenders.removeAll(DUtils.GetTerUnitsAtEndOfTurn(data, player, ter));
                defenders.addAll(DUtils.GetTerUnitsAtEndOfTurn(data, player, ter));
                AggregateResults results = DUtils.GetBattleResults(attackers, defenders, ter, data, 50, true);
                return !(results.getAttackerWinPercent() < 0.25);
            }
        };
        Match<Territory> isCapitalDefenseCall = new Match<Territory>(){

            @Override
            public boolean match(Territory ter) {
                if (!DSettings.LoadSettings().CR_enableCallForDefensiveFront) {
                    return false;
                }
                if (ter.isWater()) {
                    return false;
                }
                if (TerritoryAttachment.get(ter) == null || TerritoryAttachment.get(ter).getIsImpassible()) {
                    return false;
                }
                if (!data.getRelationshipTracker().isAllied(ter.getOwner(), player)) {
                    return false;
                }
                return ourCaps.contains(ter);
            }
        };
        List tersWeCanCallTo = DUtils.ToList(data.getMap().getTerritories());
        DUtils.Log(Level.FINE, "  Beginning call creation loop.", new Object[0]);
        for (Territory ter : tersWeCanCallTo) {
            NCM_Call task;
            float priority;
            if (isLandGrabCall.match(ter)) {
                priority = DUtils.GetNCMCallPriority_ForLandGrab(data, player, ter);
                task = new NCM_Call(data, ter, NCM_CallType.Land_ForLandGrab, priority);
                result.add(task);
                DUtils.Log(Level.FINER, "     For land grab call added. Ter: {0} Priority: {1}", ter.getName(), Float.valueOf(priority));
                continue;
            }
            if (isDefensiveFrontCall.match(ter)) {
                priority = DUtils.GetNCMCallPriority_ForDefensiveFront(data, player, ter);
                task = new NCM_Call(data, ter, NCM_CallType.Land_ForDefensiveFront, priority);
                result.add(task);
                DUtils.Log(Level.FINER, "     For defensive front call added. Ter: {0} Priority: {1}", ter.getName(), Float.valueOf(priority));
                continue;
            }
            if (!isCapitalDefenseCall.match(ter)) continue;
            priority = DUtils.GetNCMCallPriority_ForCapitalDefense(data, player, ter);
            task = new NCM_Call(data, ter, NCM_CallType.Land_ForCapitalDefense, priority);
            result.add(task);
            DUtils.Log(Level.FINER, "     For capital defense call added. Ter: {0} Priority: {1}", ter.getName(), Float.valueOf(priority));
        }
        return result;
    }

    private static boolean considerAndPerformWorthwhileCalls(MovePackage pack, List<NCM_Call> calls) {
        GameData data = pack.Data;
        PlayerID player = pack.Player;
        IMoveDelegate mover = pack.Mover;
        NCM_Call highestPriorityCall = null;
        float highestCallPriority = -2.1474836E9f;
        for (NCM_Call call : calls) {
            float priority;
            if (call.IsDisqualified() || call.IsCompleted() || !((priority = call.GetPriority()) > highestCallPriority)) continue;
            highestPriorityCall = call;
            highestCallPriority = priority;
        }
        if (highestPriorityCall != null) {
            highestPriorityCall.CalculateCallRequirements();
            highestPriorityCall.RecruitUnits();
            if (highestPriorityCall.IsPlannedMoveWorthwhile(calls)) {
                DUtils.Log(Level.FINER, "      Call worthwhile, performing planned call.", new Object[0]);
                highestPriorityCall.PerformCall(mover);
            } else {
                highestPriorityCall.Disqualify();
            }
        }
        return highestPriorityCall != null;
    }

    private static void doNonCombatMoveForTer(MovePackage pack, Territory ter, List<Unit> terUnits, List<NCM_Task> tasks) {
        List<Float> fromDangerBeforeAndAfter;
        GameData data = pack.Data;
        IMoveDelegate mover = pack.Mover;
        PlayerID player = pack.Player;
        Territory target = NCM_TargetCalculator.CalculateNCMTargetForTerritory(data, player, ter, terUnits, tasks);
        if (target == null) {
            List<Territory> reachableEmptyLand = DUtils.GetTerritoriesWithinXDistanceOfYMatchingZAndHavingRouteMatchingA(data, ter, Integer.MAX_VALUE, DUtils.CompMatchAnd(DMatches.TerritoryIsLandAndPassable, Matches.territoryHasUnitsOwnedBy(player).invert()), DMatches.TerritoryIsLandAndPassable);
            if (reachableEmptyLand.size() > 0) {
                target = reachableEmptyLand.get(0);
            }
            if (target == null) {
                List<Territory> reachableLand = DUtils.GetTerritoriesWithinXDistanceOfYMatchingZAndHavingRouteMatchingA(data, ter, Integer.MAX_VALUE, DMatches.TerritoryIsLandAndPassable, DMatches.TerritoryIsLandAndPassable);
                target = DUtils.GetRandomTerritoryMatchingXInList(reachableLand, DMatches.TerritoryIsLandAndPassable);
            }
            DUtils.Log(Level.FINER, "    NCM target not found, so using random reachable ter. Ter: {0} Target: {1}", ter, target);
            if (target == null) {
                return;
            }
        }
        float valueOfFrom = DUtils.GetValueOfLandTer(ter, data, player);
        float valueOfHighestTo = -2.1474836E9f;
        ArrayList<Territory> movedToTers = new ArrayList<Territory>();
        List<UnitGroup> ugs = DUtils.CreateSpeedSplitUnitGroupsForUnits(terUnits, ter, data);
        for (UnitGroup ug : ugs) {
            Route ncmRoute = ug.GetNCMRoute(target, true);
            if (ncmRoute == null) continue;
            Territory to = ncmRoute.getEnd();
            movedToTers.add(to);
            float toValue = DUtils.GetValueOfLandTer(to, data, player);
            if (!(toValue > valueOfHighestTo)) continue;
            valueOfHighestTo = toValue;
        }
        if (valueOfFrom >= valueOfHighestTo * 2.0f && (fromDangerBeforeAndAfter = DUtils.GetTerTakeoverChanceBeforeAndAfterMoves(data, player, ter, movedToTers, terUnits, DSettings.LoadSettings().CA_NCM_determinesSurvivalChanceOfFromTerAfterMoveToSeeIfToCancelMove)).get(1).floatValue() > 0.5f && fromDangerBeforeAndAfter.get(0).floatValue() < 0.5f) {
            DUtils.Log(Level.FINER, "    Regular ncm move-to-target from {0} to {1} canceled because of endangering of more valuable from ter. Units: {2}", ter, target, DUtils.UnitGroupList_ToString(ugs));
            return;
        }
        DUtils.Log(Level.FINER, "    Performing regular ncm move-to-target move from {0} to {1}. Units: {2}", ter, target, DUtils.UnitGroupList_ToString(ugs));
        UnitGroup.EnableMoveBuffering();
        for (UnitGroup ug : ugs) {
            String error = ug.MoveAsFarTo_NCM(target, mover, true);
            if (error != null) {
                DUtils.Log(Level.FINER, "      NCM move-to-target move or preparation failed, reason: {0}", error);
                continue;
            }
            Dynamix_AI.Pause();
        }
        String errors = UnitGroup.PerformBufferedMovesAndDisableMoveBufferring(mover);
        if (errors != null) {
            DUtils.Log(Level.FINER, "      Some errors occurred while performing moves: {0}", errors);
        }
    }
}

