/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.triplea.ai.Dynamix_AI.CommandCenter;

import games.strategy.engine.data.GameData;
import games.strategy.engine.data.PlayerID;
import games.strategy.triplea.ai.Dynamix_AI.DUtils;
import games.strategy.triplea.ai.Dynamix_AI.Others.StrategyType;
import java.util.HashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StrategyCenter {
    private static HashMap<PlayerID, StrategyCenter> s_SCInstances = new HashMap();
    private GameData m_data = null;
    private PlayerID m_player = null;
    private HashMap<PlayerID, StrategyType> CalculatedStrategyAssignments = new HashMap();

    public static StrategyCenter get(GameData data, PlayerID player) {
        if (!s_SCInstances.containsKey(player)) {
            s_SCInstances.put(player, StrategyCenter.create(data, player));
        }
        return s_SCInstances.get(player);
    }

    private static StrategyCenter create(GameData data, PlayerID player) {
        return new StrategyCenter(data, player);
    }

    public static void ClearStaticInstances() {
        s_SCInstances.clear();
    }

    public static void NotifyStartOfRound() {
        s_SCInstances.clear();
    }

    public StrategyCenter(GameData data, PlayerID player) {
        this.m_data = data;
        this.m_player = player;
    }

    public HashMap<PlayerID, StrategyType> GetCalculatedStrategyAssignments() {
        if (this.CalculatedStrategyAssignments == null || this.CalculatedStrategyAssignments.isEmpty()) {
            this.CalculatedStrategyAssignments = DUtils.CalculateStrategyAssignments(this.m_data, this.m_player);
        }
        return this.CalculatedStrategyAssignments;
    }
}

