/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.triplea.ai.Dynamix_AI.CommandCenter;

import games.strategy.engine.data.GameData;
import games.strategy.engine.data.PlayerID;
import games.strategy.engine.data.Territory;
import games.strategy.engine.data.Unit;
import games.strategy.triplea.ai.Dynamix_AI.DUtils;
import games.strategy.triplea.ai.Dynamix_AI.Group.UnitGroup;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.logging.Level;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TacticalCenter {
    private static HashMap<PlayerID, TacticalCenter> s_TCInstances = new HashMap();
    private GameData m_data = null;
    private PlayerID m_player = null;
    public List<UnitGroup> AllDelegateUnitGroups = new ArrayList<UnitGroup>();
    private final HashSet<Unit> UnitsToFreezeSoon = new HashSet();
    private final HashSet<Unit> FrozenUnits = new HashSet();
    public HashMap<Territory, Float> BattleRetreatChanceAssignments = new HashMap();
    private final HashMap<Unit, Territory> UnitLocationsAtStartOfTurn = new HashMap();

    public static TacticalCenter get(GameData data, PlayerID player) {
        if (!s_TCInstances.containsKey(player)) {
            s_TCInstances.put(player, TacticalCenter.create(data, player));
        }
        return s_TCInstances.get(player);
    }

    private static TacticalCenter create(GameData data, PlayerID player) {
        return new TacticalCenter(data, player);
    }

    public static void ClearStaticInstances() {
        s_TCInstances.clear();
    }

    public static void NotifyStartOfRound() {
        s_TCInstances.clear();
    }

    public TacticalCenter(GameData data, PlayerID player) {
        this.m_data = data;
        this.m_player = player;
    }

    public void PerformBufferedFreezes() {
        if (this.UnitsToFreezeSoon.isEmpty()) {
            return;
        }
        this.FrozenUnits.addAll(this.UnitsToFreezeSoon);
        DUtils.Log(Level.FINER, "          Freezing buffered units for the rest of this phase. Units: {0} New Total Size: {1}", DUtils.UnitList_ToString(this.UnitsToFreezeSoon), this.FrozenUnits.size());
        this.UnitsToFreezeSoon.clear();
    }

    public void FreezeUnits(List<Unit> units) {
        if (UnitGroup.IsBufferringMoves()) {
            this.UnitsToFreezeSoon.addAll(units);
        } else {
            this.FrozenUnits.addAll(units);
            DUtils.Log(Level.FINER, "          Freezing units for the rest of this phase. Units: {0} New Total Size: {1}", DUtils.UnitList_ToString(units), this.FrozenUnits.size());
        }
    }

    public HashSet<Unit> GetFrozenUnits() {
        return this.FrozenUnits;
    }

    public void ClearFrozenUnits() {
        DUtils.Log(Level.FINER, "          Clearing frozen units. Frozen Units: {0}", DUtils.UnitList_ToString(this.FrozenUnits));
        this.FrozenUnits.clear();
    }

    public void SetUnitStartLocation_IfNotAlreadySet(Unit unit, Territory startTer) {
        if (this.UnitLocationsAtStartOfTurn.containsKey(unit)) {
            return;
        }
        this.UnitLocationsAtStartOfTurn.put(unit, startTer);
    }

    public Territory GetUnitLocationAtStartOfTurn(Unit unit) {
        if (!this.UnitLocationsAtStartOfTurn.containsKey(unit)) {
            this.UnitLocationsAtStartOfTurn.put(unit, DUtils.GetUnitLocation(this.m_data, unit));
        }
        return this.UnitLocationsAtStartOfTurn.get(unit);
    }

    public void ClearStartOfTurnUnitLocations() {
        this.UnitLocationsAtStartOfTurn.clear();
    }
}

