/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.triplea.ai.Dynamix_AI;

import games.strategy.engine.data.ChangeFactory;
import games.strategy.engine.data.ChangePerformer;
import games.strategy.engine.data.CompositeChange;
import games.strategy.engine.data.GameData;
import games.strategy.engine.data.PlayerID;
import games.strategy.engine.data.Territory;
import games.strategy.engine.data.TerritoryEffect;
import games.strategy.engine.data.Unit;
import games.strategy.engine.framework.GameDataUtils;
import games.strategy.triplea.ai.Dynamix_AI.DummyDelegateBridge;
import games.strategy.triplea.delegate.BattleCalculator;
import games.strategy.triplea.delegate.BattleTracker;
import games.strategy.triplea.delegate.MustFightBattle;
import games.strategy.triplea.delegate.TerritoryEffectHelper;
import games.strategy.triplea.delegate.TripleADelegateBridge;
import games.strategy.triplea.oddsCalculator.ta.AggregateResults;
import games.strategy.triplea.oddsCalculator.ta.BattleResults;
import java.util.ArrayList;
import java.util.Collection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DOddsCalculator {
    private PlayerID m_attacker;
    private PlayerID m_defender;
    private static GameData s_dataForSimulation;
    private Territory m_location;
    private Collection<Unit> m_attackingUnits = new ArrayList<Unit>();
    private Collection<Unit> m_defendingUnits = new ArrayList<Unit>();
    private Collection<Unit> m_bombardingUnits = new ArrayList<Unit>();
    private boolean m_keepOneAttackingLandUnit = false;
    private boolean m_amphibious = false;
    private volatile boolean m_cancelled = false;

    public static void clearCachedStaticData() {
        s_dataForSimulation = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void SetGameData(GameData data) {
        data.acquireReadLock();
        try {
            s_dataForSimulation = GameDataUtils.cloneGameData(data, true);
        }
        finally {
            data.releaseReadLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AggregateResults calculate(GameData data, PlayerID attacker, PlayerID defender, Territory location, Collection<Unit> attacking, Collection<Unit> defending, Collection<Unit> bombarding, int runCount) {
        this.m_attacker = s_dataForSimulation.getPlayerList().getPlayerID(attacker.getName());
        this.m_defender = s_dataForSimulation.getPlayerList().getPlayerID(defender.getName());
        this.m_location = s_dataForSimulation.getMap().getTerritory(location.getName());
        if (this.m_attacker == null) {
            this.m_attacker = PlayerID.NULL_PLAYERID;
        }
        if (this.m_defender == null) {
            this.m_defender = PlayerID.NULL_PLAYERID;
        }
        data.acquireReadLock();
        try {
            this.m_attackingUnits = (Collection)GameDataUtils.translateIntoOtherGameData(attacking, s_dataForSimulation);
            this.m_defendingUnits = (Collection)GameDataUtils.translateIntoOtherGameData(defending, s_dataForSimulation);
            this.m_bombardingUnits = (Collection)GameDataUtils.translateIntoOtherGameData(bombarding, s_dataForSimulation);
        }
        finally {
            data.releaseReadLock();
        }
        new ChangePerformer(s_dataForSimulation).perform(ChangeFactory.removeUnits(this.m_location, this.m_location.getUnits().getUnits()));
        new ChangePerformer(s_dataForSimulation).perform(ChangeFactory.addUnits(this.m_location, this.m_attackingUnits));
        new ChangePerformer(s_dataForSimulation).perform(ChangeFactory.addUnits(this.m_location, this.m_defendingUnits));
        return this.calculate(runCount);
    }

    public void setKeepOneAttackingLandUnit(boolean aBool) {
        this.m_keepOneAttackingLandUnit = aBool;
    }

    public void setAmphibious(boolean aBool) {
        this.m_amphibious = aBool;
    }

    private AggregateResults calculate(int count) {
        long start = System.currentTimeMillis();
        AggregateResults rVal = new AggregateResults(count);
        BattleTracker battleTracker = new BattleTracker();
        BattleCalculator.EnableCasualtySortingCaching();
        Collection<TerritoryEffect> territoryEffects = TerritoryEffectHelper.getEffects(this.m_location);
        for (int i = 0; i < count && !this.m_cancelled; ++i) {
            CompositeChange allChanges = new CompositeChange();
            DummyDelegateBridge bridge1 = new DummyDelegateBridge(this.m_attacker, s_dataForSimulation, allChanges, this.m_keepOneAttackingLandUnit);
            TripleADelegateBridge bridge = new TripleADelegateBridge(bridge1);
            MustFightBattle battle = new MustFightBattle(this.m_location, this.m_attacker, s_dataForSimulation, battleTracker);
            battle.setHeadless(true);
            battle.setUnits(this.m_defendingUnits, this.m_attackingUnits, this.m_bombardingUnits, this.m_amphibious ? this.m_attackingUnits : new ArrayList<Unit>(), this.m_defender, territoryEffects);
            battle.fight(bridge);
            rVal.addResult(new BattleResults(battle, s_dataForSimulation));
            new ChangePerformer(s_dataForSimulation).perform(allChanges.invert());
            battleTracker.clear();
            battleTracker.clearBattleRecords();
        }
        BattleCalculator.DisableCasualtySortingCaching();
        rVal.setTime(System.currentTimeMillis() - start);
        return rVal;
    }

    public void cancel() {
        this.m_cancelled = true;
    }
}

