/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.triplea.ai.Dynamix_AI.Group;

import games.strategy.engine.data.GameData;
import games.strategy.engine.data.PlayerID;
import games.strategy.engine.data.Route;
import games.strategy.engine.data.Territory;
import games.strategy.engine.data.Unit;
import games.strategy.triplea.ai.Dynamix_AI.CommandCenter.CachedInstanceCenter;
import games.strategy.triplea.ai.Dynamix_AI.CommandCenter.GlobalCenter;
import games.strategy.triplea.ai.Dynamix_AI.CommandCenter.TacticalCenter;
import games.strategy.triplea.ai.Dynamix_AI.DMatches;
import games.strategy.triplea.ai.Dynamix_AI.DUtils;
import games.strategy.triplea.attatchments.UnitAttachment;
import games.strategy.triplea.delegate.Matches;
import games.strategy.triplea.delegate.remote.IMoveDelegate;
import games.strategy.util.CompositeMatchAnd;
import games.strategy.util.Match;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UnitGroup {
    private Collection<Unit> m_units = new ArrayList<Unit>();
    private Territory m_fromTer = null;
    private Territory m_movedTo = null;
    private Match<Territory> m_cmRouteMatch = null;
    private HashMap<Match<Territory>, Integer> m_ncmCRouteMatches = null;
    private GameData m_data = null;
    private int m_moveIndex = -1;
    public static int movesCount = 0;
    private static boolean s_isBufferring = false;
    private static HashMap<Route, List<UnitGroup>> s_bufferedMoves = new HashMap();

    public static void clearCachedInstances() {
        movesCount = 0;
        s_isBufferring = false;
        s_bufferedMoves = new HashMap();
    }

    public UnitGroup(Unit unit, Territory startTer, GameData data) {
        this(Collections.singleton(unit), startTer, data);
    }

    public UnitGroup(Collection<Unit> units, Territory startTer, GameData data) {
        TacticalCenter.get((GameData)data, (PlayerID)GlobalCenter.CurrentPlayer).AllDelegateUnitGroups.add(this);
        for (Unit unit : units) {
            TacticalCenter.get(data, GlobalCenter.CurrentPlayer).SetUnitStartLocation_IfNotAlreadySet(unit, startTer);
        }
        this.m_units = units;
        this.m_fromTer = startTer;
        this.m_data = data;
        this.GenerateRouteMatches();
    }

    public int hashCode() {
        String hashString = ((Object)this.m_units).hashCode() + "" + this.m_fromTer.getName();
        return hashString.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        UnitGroup other = (UnitGroup)obj;
        if (!(this.m_units == other.m_units || this.m_units != null && ((Object)this.m_units).equals(other.m_units))) {
            return false;
        }
        return this.m_fromTer == other.m_fromTer || this.m_fromTer != null && this.m_fromTer.equals(other.m_fromTer);
    }

    private void GenerateRouteMatches() {
        PlayerID player = null;
        boolean land = false;
        boolean air = false;
        boolean sea = false;
        for (Unit unit : this.m_units) {
            player = unit.getOwner();
            UnitAttachment ua = UnitAttachment.get(unit.getUnitType());
            if (ua.getIsAir()) {
                air = true;
                continue;
            }
            if (ua.getIsSea()) {
                sea = true;
                continue;
            }
            land = true;
        }
        if (player == null || player.isNull()) {
            player = GlobalCenter.CurrentPlayer;
        }
        this.m_cmRouteMatch = air ? new CompositeMatchAnd<Territory>(Matches.TerritoryIsPassableAndNotRestricted(player, this.m_data)) : (sea ? new CompositeMatchAnd<Territory>(Matches.TerritoryIsWater, DMatches.territoryIsWaterAndPassableTo(player, this.m_data)) : new CompositeMatchAnd<Territory>(Matches.TerritoryIsLand));
        if (air) {
            this.m_ncmCRouteMatches = new HashMap();
            this.m_ncmCRouteMatches.put(DUtils.CompMatchAnd(Matches.TerritoryIsNotImpassable, DUtils.CompMatchOr(DMatches.territoryIsOwnedByXOrAlly(this.m_data, player), Matches.territoryHasUnitsThatMatch(Matches.unitIsEnemyAAforAnything(player, this.m_data)).invert())), 1);
            this.m_ncmCRouteMatches.put(Matches.TerritoryIsNotImpassable, 2);
        } else if (sea) {
            this.m_ncmCRouteMatches = new HashMap();
            this.m_ncmCRouteMatches.put(new CompositeMatchAnd(Matches.TerritoryIsWater, DMatches.territoryIsWaterAndPassableTo(player, this.m_data), Matches.territoryHasUnitsOwnedBy(player)), 10);
            this.m_ncmCRouteMatches.put(new CompositeMatchAnd(Matches.TerritoryIsWater, DMatches.territoryIsWaterAndPassableTo(player, this.m_data), Matches.territoryHasUnitsThatMatch(Matches.unitIsEnemyOf(this.m_data, player).invert())), 15);
            this.m_ncmCRouteMatches.put(new CompositeMatchAnd(Matches.TerritoryIsWater, DMatches.territoryIsWaterAndPassableTo(player, this.m_data), Matches.territoryHasNoEnemyUnits(player, this.m_data)), 20);
            this.m_ncmCRouteMatches.put(new CompositeMatchAnd(Matches.TerritoryIsWater, DMatches.territoryIsWaterAndPassableTo(player, this.m_data)), 100);
            this.m_ncmCRouteMatches.put(Matches.TerritoryIsWater, 1000000);
        } else {
            this.m_ncmCRouteMatches = new HashMap();
            this.m_ncmCRouteMatches.put(new CompositeMatchAnd(Matches.TerritoryIsLand, DMatches.territoryIsOwnedBy(player)), 10);
            this.m_ncmCRouteMatches.put(new CompositeMatchAnd(Matches.TerritoryIsLand, DMatches.territoryIsOwnedByXOrAlly(this.m_data, player)), 11);
            this.m_ncmCRouteMatches.put(new CompositeMatchAnd(Matches.TerritoryIsLand, Matches.TerritoryIsPassableAndNotRestricted(player, this.m_data)), 15);
            this.m_ncmCRouteMatches.put(new CompositeMatchAnd(Matches.TerritoryIsLand), 1000);
        }
    }

    public Collection<Unit> GetUnits() {
        return this.m_units;
    }

    public List<Unit> GetUnitsAsList() {
        return new ArrayList<Unit>(this.m_units);
    }

    public Territory GetFromTerritory() {
        return this.m_fromTer;
    }

    public Unit GetFirstUnit() {
        return (Unit)this.m_units.toArray()[0];
    }

    public Route GetCMRoute(Territory target) {
        Route route = this.m_data.getMap().getRoute_IgnoreEnd(this.m_fromTer, target, this.m_cmRouteMatch);
        if (route == null || route.getTerritories().size() < 2 || route.getStart().getName().equals(route.getEnd().getName())) {
            return null;
        }
        int slowest = DUtils.GetSlowestMovementUnitInList(new ArrayList<Unit>(this.m_units));
        if (slowest < 1) {
            return null;
        }
        route = UnitAttachment.get(this.GetFirstUnit().getUnitType()).getIsAir() ? DUtils.TrimRoute_ToLength(route, slowest, this.GetFirstUnit().getOwner(), this.m_data) : (UnitAttachment.get(this.GetFirstUnit().getUnitType()).getIsSea() ? DUtils.TrimRoute_AtFirstTerWithEnemyUnits(route, slowest, this.GetFirstUnit().getOwner(), this.m_data) : DUtils.TrimRoute_AtFirstTerWithEnemyUnits(route, slowest, this.GetFirstUnit().getOwner(), this.m_data));
        if (route == null) {
            return null;
        }
        if (route.getTerritories().size() < 2 || route.getStart().getName().equals(route.getEnd().getName())) {
            return null;
        }
        if (route.getTerritories().size() < 2 || route.getStart().getName().equals(route.getEnd().getName())) {
            return null;
        }
        return route;
    }

    public Route GetNCMRoute(Territory target) {
        return this.GetNCMRoute(target, false);
    }

    public Route GetNCMRoute(Territory target, boolean extraChecks) {
        Route route = this.m_data.getMap().getCompositeRoute_IgnoreEnd(this.m_fromTer, target, this.m_ncmCRouteMatches);
        if (route == null || route.getTerritories() == null || route.getTerritories().size() < 2 || route.getStart().getName().equals(route.getEnd().getName())) {
            return null;
        }
        int slowest = DUtils.GetSlowestMovementUnitInList(new ArrayList<Unit>(this.m_units));
        if (slowest < 1) {
            return null;
        }
        route = UnitAttachment.get(this.GetFirstUnit().getUnitType()).getIsAir() ? DUtils.TrimRoute_ToLength(route, slowest, this.GetFirstUnit().getOwner(), this.m_data) : (UnitAttachment.get(this.GetFirstUnit().getUnitType()).getIsSea() ? DUtils.TrimRoute_BeforeFirstTerWithEnemyUnits(route, slowest, this.GetFirstUnit().getOwner(), this.m_data) : DUtils.TrimRoute_AtLastFriendlyTer(route, slowest, this.GetFirstUnit().getOwner(), this.m_data));
        if (route == null || route.getTerritories().size() < 2 || route.getStart().getName().equals(route.getEnd().getName())) {
            return null;
        }
        if (extraChecks && DMatches.territoryIsConsideredSafeToNCMInto(GlobalCenter.CurrentPlayer, this.m_data).invert().match(route.getEnd())) {
            route = DUtils.TrimRoute_BeforeFirstTerMatching(route, slowest, GlobalCenter.CurrentPlayer, this.m_data, DMatches.territoryIsConsideredSafeToNCMInto(GlobalCenter.CurrentPlayer, this.m_data).invert());
        }
        if (route == null || route.getTerritories().size() < 2 || route.getStart().getName().equals(route.getEnd().getName())) {
            return null;
        }
        return route;
    }

    public String MoveAsFarTo_CM(Territory target, IMoveDelegate mover) {
        Route route = null;
        if (this.GetFromTerritory().equals(target)) {
            return null;
        }
        if (this.m_movedTo != null) {
            return "Cannot move unit group that has already moved somewhere";
        }
        route = this.GetCMRoute(target);
        if (route == null) {
            return "Error calculating CM route...";
        }
        if (s_isBufferring) {
            Route key = route;
            DUtils.AddObjToListValueForKeyInMap(s_bufferedMoves, key, this);
            return null;
        }
        String moveError = UnitGroup.MoveUnitsInternal(mover, route, new ArrayList<Unit>(this.m_units));
        if (moveError != null) {
            return moveError;
        }
        this.NotifySuccessfulMove(this.m_movedTo);
        return null;
    }

    public String MoveAsFarTo_NCM(Territory target, IMoveDelegate mover) {
        return this.MoveAsFarTo_NCM(target, mover, false);
    }

    public String MoveAsFarTo_NCM(Territory target, IMoveDelegate mover, boolean extraChecks) {
        Route route = null;
        if (this.GetFromTerritory().equals(target)) {
            return null;
        }
        if (this.m_movedTo != null) {
            return "Cannot move unit group that has already moved somewhere";
        }
        route = this.GetNCMRoute(target, extraChecks);
        if (route == null) {
            return "Error calculating NCM route...";
        }
        if (s_isBufferring) {
            Route key = route;
            DUtils.AddObjToListValueForKeyInMap(s_bufferedMoves, key, this);
            return null;
        }
        String moveError = UnitGroup.MoveUnitsInternal(mover, route, new ArrayList<Unit>(this.m_units));
        if (moveError != null) {
            return moveError;
        }
        this.NotifySuccessfulMove(this.m_movedTo);
        return null;
    }

    public String MoveAsFarAlongRoute_NCM(IMoveDelegate mover, Route fullRoute) {
        return this.MoveAsFarAlongRoute_NCM(mover, fullRoute, false);
    }

    public String MoveAsFarAlongRoute_NCM(IMoveDelegate mover, Route fullRoute, boolean extraChecks) {
        Route route = fullRoute;
        if (fullRoute != null && this.GetFromTerritory().equals(fullRoute.getEnd())) {
            return null;
        }
        if (this.m_movedTo != null) {
            return "Cannot move unit group that has already moved somewhere";
        }
        int slowest = DUtils.GetSlowestMovementUnitInList(new ArrayList<Unit>(this.m_units));
        if (route == null || route.getTerritories().size() < 2) {
            return "The route given is either null or too short(no actual route)";
        }
        if (slowest < 1) {
            return "Some of the units in this unit group don't have any movement left";
        }
        route = UnitAttachment.get(this.GetFirstUnit().getUnitType()).getIsAir() ? DUtils.TrimRoute_ToLength(route, slowest, this.GetFirstUnit().getOwner(), this.m_data) : (UnitAttachment.get(this.GetFirstUnit().getUnitType()).getIsSea() ? DUtils.TrimRoute_BeforeFirstTerWithEnemyUnits(route, slowest, this.GetFirstUnit().getOwner(), this.m_data) : DUtils.TrimRoute_AtLastFriendlyTer(route, slowest, this.GetFirstUnit().getOwner(), this.m_data));
        if (route == null || route.getTerritories().size() < 2) {
            return "After trimming, the route given is either null or too short(no actual route)";
        }
        if (extraChecks && DMatches.territoryIsConsideredSafeToNCMInto(GlobalCenter.CurrentPlayer, this.m_data).invert().match(route.getEnd())) {
            route = DUtils.TrimRoute_BeforeFirstTerMatching(route, slowest, GlobalCenter.CurrentPlayer, this.m_data, DMatches.territoryIsConsideredSafeToNCMInto(GlobalCenter.CurrentPlayer, this.m_data).invert());
        }
        if (route == null || route.getTerritories().size() < 2) {
            return "After secondary trimming, the route given is either null or too short(no actual route)";
        }
        if (s_isBufferring) {
            Route key = route;
            DUtils.AddObjToListValueForKeyInMap(s_bufferedMoves, key, this);
            return null;
        }
        String moveError = UnitGroup.MoveUnitsInternal(mover, route, new ArrayList<Unit>(this.m_units));
        if (moveError != null) {
            return moveError;
        }
        this.NotifySuccessfulMove(this.m_movedTo);
        return null;
    }

    private static String MoveUnitsInternal(IMoveDelegate mover, Route route, Collection<Unit> units) {
        ArrayList<Unit> unitsToMove = new ArrayList<Unit>(units);
        ArrayList<Unit> frozenOnes = new ArrayList<Unit>(unitsToMove);
        frozenOnes.retainAll(TacticalCenter.get(CachedInstanceCenter.CachedGameData, GlobalCenter.CurrentPlayer).GetFrozenUnits());
        unitsToMove.removeAll(frozenOnes);
        if (unitsToMove.isEmpty()) {
            return "Move prepared, though there are no un-frozen units to move!";
        }
        List<Unit> tUnits = route.getEnd().getUnits().getMatches(DUtils.CompMatchAnd(Matches.UnitIsSea, Matches.UnitIsTransport, Matches.unitHasEnoughTransportSpaceLeft(1), Matches.unitIsOwnedBy(GlobalCenter.CurrentPlayer)));
        String moveError = mover.move(unitsToMove, route, tUnits);
        if (moveError != null) {
            moveError = mover.move(unitsToMove, route);
        }
        if (moveError != null) {
            return moveError;
        }
        if (!route.getEnd().getUnits().containsAll(unitsToMove)) {
            return DUtils.Format("Move failed(units are not at destination), though no errors occurred. Route: {0} Units: {1}", route, DUtils.UnitList_ToString(units));
        }
        DUtils.Log(Level.FINER, "          Performed move on route: {0} Units: {1}", route, DUtils.UnitList_ToString(unitsToMove));
        return null;
    }

    private void NotifySuccessfulMove(Territory movedTo) {
        this.m_moveIndex = movesCount++;
        this.m_movedTo = movedTo;
    }

    private void NotifySuccessfulBufferedMove(Territory movedTo, int moveIndex) {
        this.m_moveIndex = moveIndex;
        this.m_movedTo = movedTo;
    }

    public Territory GetMovedTo() {
        return this.m_movedTo;
    }

    public void ClearMovedTo() {
        this.m_movedTo = null;
    }

    public static void UndoMove_NotifyAllUGs(IMoveDelegate mover, int moveIndex) {
        if (moveIndex == -1) {
            return;
        }
        ArrayList<UnitGroup> ugsMovedByThisMove = new ArrayList<UnitGroup>();
        for (UnitGroup ug : TacticalCenter.get((GameData)CachedInstanceCenter.CachedGameData, (PlayerID)GlobalCenter.CurrentPlayer).AllDelegateUnitGroups) {
            if (ug.GetMovedTo() == null || ug.GetMoveIndex() != moveIndex) continue;
            ugsMovedByThisMove.add(ug);
        }
        if (ugsMovedByThisMove.isEmpty()) {
            return;
        }
        mover.undoMove(moveIndex);
        --movesCount;
        Territory target = null;
        ArrayList<Unit> unitsMoved = new ArrayList<Unit>();
        ArrayList<Territory> fromTers = new ArrayList<Territory>();
        for (UnitGroup ug : ugsMovedByThisMove) {
            target = ug.GetMovedTo();
            unitsMoved.addAll(ug.GetUnits());
            if (fromTers.contains(ug.GetFromTerritory())) continue;
            fromTers.add(ug.GetFromTerritory());
        }
        for (UnitGroup ug : TacticalCenter.get((GameData)CachedInstanceCenter.CachedGameData, (PlayerID)GlobalCenter.CurrentPlayer).AllDelegateUnitGroups) {
            ug.NotifyMoveUndo(moveIndex);
        }
        DUtils.Log(Level.FINER, "          Move undone. Initial Locations: {0} Target: {1} Units: {2}", fromTers, target, unitsMoved);
    }

    public int GetMoveIndex() {
        return this.m_moveIndex;
    }

    public void SetMoveIndex(int moveIndex) {
        this.m_moveIndex = moveIndex;
    }

    public void NotifyMoveUndo(int undoneMoveIndex) {
        if (this.GetMoveIndex() > undoneMoveIndex) {
            --this.m_moveIndex;
        } else if (this.m_movedTo != null && this.m_moveIndex == undoneMoveIndex) {
            this.m_movedTo = null;
            this.m_moveIndex = -1;
        }
    }

    public Match<Territory> GetRouteMatch() {
        return this.m_cmRouteMatch;
    }

    public static boolean IsBufferringMoves() {
        return s_isBufferring;
    }

    public static void EnableMoveBuffering() {
        s_isBufferring = true;
    }

    public static void ClearBufferedMoves() {
        s_bufferedMoves.clear();
    }

    public static String PerformBufferedMovesAndDisableMoveBufferring(IMoveDelegate mover) {
        String errors = UnitGroup.performBufferedMoves(s_bufferedMoves, mover);
        s_bufferedMoves.clear();
        s_isBufferring = false;
        TacticalCenter.get(CachedInstanceCenter.CachedGameData, GlobalCenter.CurrentPlayer).PerformBufferedFreezes();
        return errors;
    }

    private static String performBufferedMoves(HashMap<Route, List<UnitGroup>> moves, IMoveDelegate mover) {
        StringBuilder errors = new StringBuilder();
        Iterator<Route> i$ = moves.keySet().iterator();
        while (i$.hasNext()) {
            Route key;
            Route route = key = i$.next();
            List<UnitGroup> ugs = moves.get(key);
            ArrayList<Unit> units = new ArrayList<Unit>();
            for (UnitGroup ug : ugs) {
                units.addAll(ug.GetUnits());
            }
            String moveError = UnitGroup.MoveUnitsInternal(mover, route, units);
            if (moveError != null) {
                errors.append(moveError).append("\r\n");
                continue;
            }
            for (UnitGroup ug : ugs) {
                ug.NotifySuccessfulBufferedMove(route.getEnd(), movesCount);
            }
            ++movesCount;
        }
        if (errors.length() == 0) {
            return null;
        }
        return errors.toString().substring(0, errors.length() - 2);
    }

    public String toString() {
        return DUtils.UnitGroupList_ToString(Collections.singletonList(this));
    }
}

