/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.triplea.ai.Dynamix_AI.Others;

import games.strategy.engine.data.GameData;
import games.strategy.engine.data.PlayerID;
import games.strategy.engine.data.Route;
import games.strategy.engine.data.Territory;
import games.strategy.engine.data.Unit;
import games.strategy.triplea.Properties;
import games.strategy.triplea.TripleAUnit;
import games.strategy.triplea.ai.Dynamix_AI.CommandCenter.CachedCalculationCenter;
import games.strategy.triplea.ai.Dynamix_AI.CommandCenter.CachedInstanceCenter;
import games.strategy.triplea.ai.Dynamix_AI.CommandCenter.GlobalCenter;
import games.strategy.triplea.ai.Dynamix_AI.CommandCenter.ReconsiderSignalCenter;
import games.strategy.triplea.ai.Dynamix_AI.CommandCenter.StatusCenter;
import games.strategy.triplea.ai.Dynamix_AI.CommandCenter.StrategyCenter;
import games.strategy.triplea.ai.Dynamix_AI.CommandCenter.TacticalCenter;
import games.strategy.triplea.ai.Dynamix_AI.CommandCenter.ThreatInvalidationCenter;
import games.strategy.triplea.ai.Dynamix_AI.DMatches;
import games.strategy.triplea.ai.Dynamix_AI.DSettings;
import games.strategy.triplea.ai.Dynamix_AI.DSorting;
import games.strategy.triplea.ai.Dynamix_AI.DUtils;
import games.strategy.triplea.ai.Dynamix_AI.Dynamix_AI;
import games.strategy.triplea.ai.Dynamix_AI.Group.UnitGroup;
import games.strategy.triplea.ai.Dynamix_AI.Others.CM_TaskType;
import games.strategy.triplea.ai.Dynamix_AI.Others.StrategyType;
import games.strategy.triplea.attatchments.TerritoryAttachment;
import games.strategy.triplea.attatchments.UnitAttachment;
import games.strategy.triplea.delegate.Matches;
import games.strategy.triplea.delegate.remote.IMoveDelegate;
import games.strategy.triplea.oddsCalculator.ta.AggregateResults;
import games.strategy.triplea.oddsCalculator.ta.BattleResults;
import games.strategy.util.Match;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.logging.Level;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CM_Task {
    private Territory m_target = null;
    private CM_TaskType m_taskType = CM_TaskType.Empty;
    private float m_priority = 0.0f;
    private GameData m_data = null;
    private float m_minTakeoverChance = 0.0f;
    private float m_minSurvivalChance = 0.0f;
    private float m_minCounterAttackTradeScoreForBypass = 0.0f;
    private float m_attackTrade_tradeScoreRequired = 0.0f;
    private int m_attackTrade_leftoverLandUnits = 0;
    private float m_attackTrade_certaintyOfReachingLeftoverLUnitsGoalRequired = 0.0f;
    private List<UnitGroup> m_recruitedUnits = new ArrayList<UnitGroup>();
    private boolean m_disqualified = false;
    private boolean m_completed = false;

    public CM_Task(GameData data, Territory target, CM_TaskType type, float priority) {
        this.m_data = data;
        this.m_taskType = type;
        this.m_priority = priority;
        this.m_target = target;
    }

    public Territory GetTarget() {
        return this.m_target;
    }

    public CM_TaskType GetTaskType() {
        return this.m_taskType;
    }

    public float GetPriority() {
        return this.m_priority;
    }

    public void SetPriority(float priority) {
        this.m_priority = priority;
    }

    private List<UnitGroup> getSortedPossibleRecruits() {
        HashMap<Unit, Territory> unitLocations = new HashMap<Unit, Territory>();
        HashMap<Unit, Integer> possibles = new HashMap<Unit, Integer>();
        for (final Territory ter : this.m_data.getMap().getTerritories()) {
            if (DMatches.territoryContainsMultipleAlliances(this.m_data).match(ter)) continue;
            final HashSet recruitsAsHashSet = DUtils.ToHashSet(this.GetRecruitedUnitsAsUnitList());
            Match<Unit> unitMatch = new Match<Unit>(){

                @Override
                public boolean match(Unit unit) {
                    UnitAttachment ua = UnitAttachment.get(unit.getUnitType());
                    if (!Matches.unitIsOwnedBy(GlobalCenter.CurrentPlayer).match(unit)) {
                        return false;
                    }
                    if (Matches.UnitIsInfrastructure.match(unit) && ua.getAttack(unit.getOwner()) <= 0) {
                        return false;
                    }
                    if (Matches.UnitCanProduceUnits.match(unit) && ua.getAttack(unit.getOwner()) <= 0) {
                        return false;
                    }
                    if (Matches.UnitCanNotMoveDuringCombatMove.match(unit)) {
                        return false;
                    }
                    if (recruitsAsHashSet.contains(unit)) {
                        return false;
                    }
                    return DUtils.CanUnitReachTer(CM_Task.this.m_data, ter, unit, CM_Task.this.m_target);
                }
            };
            List<Unit> units = Match.getMatches(DUtils.ToList(ter.getUnits().getUnits()), unitMatch);
            if (units.isEmpty()) continue;
            for (Unit unit : units) {
                int suitability = DUtils.HowWellIsUnitSuitedToTask(this.m_data, this, ter, unit);
                if (suitability == Integer.MIN_VALUE) continue;
                possibles.put(unit, suitability);
                unitLocations.put(unit, ter);
            }
        }
        if (possibles.isEmpty()) {
            return new ArrayList<UnitGroup>();
        }
        List sortedPossibles = DUtils.ToList(possibles.keySet());
        sortedPossibles = DSorting.SortListByScores_HashMap_D(sortedPossibles, possibles);
        if (this.m_taskType.equals((Object)CM_TaskType.Land_LandGrab) && sortedPossibles.size() > 0) {
            return DUtils.CreateUnitGroupsForUnits(Collections.singletonList(sortedPossibles.get(0)), (Territory)unitLocations.get(sortedPossibles.get(0)), this.m_data);
        }
        ArrayList<UnitGroup> result = new ArrayList<UnitGroup>();
        for (Unit unit : sortedPossibles) {
            result.add(DUtils.CreateUnitGroupForUnits(Collections.singletonList(unit), (Territory)unitLocations.get(unit), this.m_data));
        }
        return result;
    }

    public void CalculateTaskRequirements() {
        if (this.m_taskType.equals((Object)CM_TaskType.Land_LandGrab)) {
            return;
        }
        if (this.m_taskType == CM_TaskType.Land_Attack_Offensive) {
            if (this.m_target.getOwner().isNull()) {
                this.m_minTakeoverChance = DUtils.ToFloat(DSettings.LoadSettings().TR_attackOffensive_Neutrals_takeoverChanceRequired);
                this.m_minSurvivalChance = DUtils.ToFloat(DSettings.LoadSettings().TR_attackOffensive_Neutrals_counterAttackSurvivalChanceRequired);
                this.m_minCounterAttackTradeScoreForBypass = DSettings.LoadSettings().TR_attackOffensive_Neutrals_counterAttackTradeScoreRequiredToBypassSurvivalRequirement;
            } else if (DUtils.GetAllEnemyCaps_ThatAreOwnedByOriginalOwner(this.m_data, GlobalCenter.CurrentPlayer).contains(this.m_target)) {
                this.m_minTakeoverChance = DUtils.ToFloat(DSettings.LoadSettings().TR_attackOffensive_Capitals_takeoverChanceRequired);
                this.m_minSurvivalChance = DUtils.ToFloat(DSettings.LoadSettings().TR_attackOffensive_Capitals_counterAttackSurvivalChanceRequired);
                this.m_minCounterAttackTradeScoreForBypass = DSettings.LoadSettings().TR_attackOffensive_Capitals_counterAttackTradeScoreRequiredToBypassSurvivalRequirement;
            } else {
                this.m_minTakeoverChance = DUtils.ToFloat(DSettings.LoadSettings().TR_attackOffensive_takeoverChanceRequired);
                this.m_minSurvivalChance = DUtils.ToFloat(DSettings.LoadSettings().TR_attackOffensive_counterAttackSurvivalChanceRequired);
                this.m_minCounterAttackTradeScoreForBypass = DSettings.LoadSettings().TR_attackOffensive_counterAttackTradeScoreRequiredToBypassSurvivalRequirement;
            }
        } else if (this.m_taskType == CM_TaskType.Land_Attack_Stabilize) {
            if (!this.m_target.getOwner().isNull() && !DUtils.GetAllEnemyCaps_ThatAreOwnedByOriginalOwner(this.m_data, GlobalCenter.CurrentPlayer).contains(this.m_target)) {
                this.m_minTakeoverChance = DUtils.ToFloat(DSettings.LoadSettings().TR_attackStabalize_takeoverChanceRequired);
                this.m_minSurvivalChance = DUtils.ToFloat(DSettings.LoadSettings().TR_attackStabalize_counterAttackSurvivalChanceRequired);
                this.m_minCounterAttackTradeScoreForBypass = DSettings.LoadSettings().TR_attackStabalize_counterAttackTradeScoreRequiredToBypassSurvivalRequirement;
            }
        } else if (this.m_taskType == CM_TaskType.Land_Attack_Trade) {
            if (this.m_target.getOwner().isNull()) {
                this.m_attackTrade_tradeScoreRequired = DSettings.LoadSettings().TR_attackTrade_totalTradeScoreRequired;
                this.m_attackTrade_leftoverLandUnits = 2;
                this.m_attackTrade_certaintyOfReachingLeftoverLUnitsGoalRequired = DUtils.ToFloat(DSettings.LoadSettings().TR_attackTrade_certaintyOfReachingDesiredNumberOfLeftoverLandUnitsRequired);
            } else if (DUtils.GetAllEnemyCaps_ThatAreOwnedByOriginalOwner(this.m_data, GlobalCenter.CurrentPlayer).contains(this.m_target)) {
                this.m_attackTrade_tradeScoreRequired = DSettings.LoadSettings().TR_attackTrade_totalTradeScoreRequired;
                this.m_attackTrade_leftoverLandUnits = 3;
                this.m_attackTrade_certaintyOfReachingLeftoverLUnitsGoalRequired = DUtils.ToFloat(DSettings.LoadSettings().TR_attackTrade_certaintyOfReachingDesiredNumberOfLeftoverLandUnitsRequired);
            } else {
                this.m_attackTrade_tradeScoreRequired = DSettings.LoadSettings().TR_attackTrade_totalTradeScoreRequired;
                this.m_attackTrade_leftoverLandUnits = 2;
                this.m_attackTrade_certaintyOfReachingLeftoverLUnitsGoalRequired = DUtils.ToFloat(DSettings.LoadSettings().TR_attackTrade_certaintyOfReachingDesiredNumberOfLeftoverLandUnitsRequired);
            }
        }
    }

    private float getMeetingOfMinTakeoverChance(AggregateResults simulatedAttack, float minTakeoverChance) {
        if (this.m_taskType.equals((Object)CM_TaskType.Land_LandGrab)) {
            if (this.m_recruitedUnits.size() > 0) {
                return 1.0f;
            }
            return 0.0f;
        }
        return DUtils.Divide_SL((float)simulatedAttack.getAttackerWinPercent(), minTakeoverChance);
    }

    private float getMeetingOfMinSurvivalChance(AggregateResults simulatedResponse, float minSurvivalChance) {
        if (this.m_taskType.equals((Object)CM_TaskType.Land_LandGrab)) {
            if (this.m_recruitedUnits.size() > 0) {
                return 1.0f;
            }
            return 0.0f;
        }
        return DUtils.Divide_SL((float)simulatedResponse.getDefenderWinPercent(), minSurvivalChance);
    }

    private float getMeetingOfMaxBattleVolleysScore(AggregateResults simulatedAttack, int maxBattleVolleys) {
        if (this.m_taskType.equals((Object)CM_TaskType.Land_LandGrab)) {
            if (this.m_recruitedUnits.size() > 0) {
                return 1.0f;
            }
            return 0.0f;
        }
        return DUtils.Divide_SL(maxBattleVolleys, (float)simulatedAttack.getAverageBattleRoundsFought());
    }

    public void RecruitUnits() {
        if (this.m_taskType.equals((Object)CM_TaskType.Land_Attack_Trade)) {
            this.recruitEnoughUnitsForTradeTask(this.m_attackTrade_certaintyOfReachingLeftoverLUnitsGoalRequired, false);
            return;
        }
        this.recruitEnoughUnitsToMeetXYZ(this.m_minTakeoverChance, this.m_minSurvivalChance, 100);
    }

    public void RecruitUnits2() {
        float minSurvivalChance;
        float minTakeoverChance;
        if (this.m_taskType.equals((Object)CM_TaskType.Land_LandGrab) && this.m_recruitedUnits.size() > 0) {
            return;
        }
        if (this.m_taskType.equals((Object)CM_TaskType.Land_Attack_Trade)) {
            return;
        }
        int maxBattleVolleys = 5;
        if (this.m_taskType == CM_TaskType.Land_Attack_Offensive) {
            minTakeoverChance = 0.85f;
            minSurvivalChance = 0.65f;
        } else {
            minTakeoverChance = 0.85f;
            minSurvivalChance = 0.65f;
        }
        this.recruitEnoughUnitsToMeetXYZ(minTakeoverChance, minSurvivalChance, 5);
    }

    public void RecruitUnits3() {
        float minSurvivalChance;
        float minTakeoverChance;
        if (this.m_taskType.equals((Object)CM_TaskType.Land_LandGrab) && this.m_recruitedUnits.size() > 0) {
            return;
        }
        if (this.m_taskType.equals((Object)CM_TaskType.Land_Attack_Trade)) {
            return;
        }
        int maxBattleVolleys = 3;
        if (this.m_taskType == CM_TaskType.Land_Attack_Offensive) {
            minTakeoverChance = 0.95f;
            minSurvivalChance = 0.75f;
        } else {
            minTakeoverChance = 0.95f;
            minSurvivalChance = 0.75f;
        }
        this.recruitEnoughUnitsToMeetXYZ(minTakeoverChance, minSurvivalChance, 3);
    }

    public void RecruitUnits4() {
        if (this.m_taskType.equals((Object)CM_TaskType.Land_LandGrab) && this.m_recruitedUnits.size() > 0) {
            return;
        }
        if (this.m_taskType.equals((Object)CM_TaskType.Land_Attack_Trade)) {
            this.recruitEnoughUnitsForTradeTask(this.m_attackTrade_certaintyOfReachingLeftoverLUnitsGoalRequired, true);
            return;
        }
        this.recruitEnoughUnitsToMeetXYZ(1.0f, 0.85f, 1);
    }

    private void recruitEnoughUnitsToMeetXYZ(float minTakeoverChance, float minSurvivalChance, int maxBattleVolleys) {
        float howCloseToMeetingBattleVolleyMax;
        float howCloseToMeetingMinSurvivalChance;
        float howCloseToMeetingMinTakeoverChance;
        AggregateResults simulatedResponse;
        List<Unit> responseDefenders;
        List<Unit> responseAttackers;
        AggregateResults simulatedAttack;
        List<UnitGroup> sortedPossibles = this.getSortedPossibleRecruits();
        if (sortedPossibles.isEmpty()) {
            return;
        }
        for (UnitGroup ug : sortedPossibles) {
            if (this.m_recruitedUnits.contains(ug)) continue;
            simulatedAttack = DUtils.GetBattleResults(this.GetRecruitedUnitsAsUnitList(), DUtils.ToList(this.m_target.getUnits().getMatches(Matches.unitIsEnemyOf(this.m_data, GlobalCenter.CurrentPlayer))), this.m_target, this.m_data, 1, true);
            responseAttackers = DUtils.DetermineResponseAttackers(this.m_data, GlobalCenter.CurrentPlayer, this.m_target, simulatedAttack);
            responseDefenders = Match.getMatches(simulatedAttack.GetAverageAttackingUnitsRemaining(), Matches.UnitIsNotAir);
            simulatedResponse = DUtils.GetBattleResults(responseAttackers, responseDefenders, this.m_target, this.m_data, 1, true);
            howCloseToMeetingMinTakeoverChance = this.getMeetingOfMinTakeoverChance(simulatedAttack, minTakeoverChance);
            if (howCloseToMeetingMinTakeoverChance < 1.0f) {
                this.m_recruitedUnits.add(ug);
                continue;
            }
            howCloseToMeetingMinSurvivalChance = this.getMeetingOfMinSurvivalChance(simulatedResponse, minSurvivalChance);
            if (howCloseToMeetingMinSurvivalChance < 1.0f) {
                this.m_recruitedUnits.add(ug);
                continue;
            }
            howCloseToMeetingBattleVolleyMax = this.getMeetingOfMaxBattleVolleysScore(simulatedAttack, maxBattleVolleys);
            if (!(howCloseToMeetingBattleVolleyMax < 1.0f)) break;
            this.m_recruitedUnits.add(ug);
        }
        this.m_recruitedUnits = DUtils.TrimRecruits_NonMovedOnes(this.m_recruitedUnits, 7);
        for (UnitGroup ug : sortedPossibles) {
            if (this.m_recruitedUnits.contains(ug)) continue;
            simulatedAttack = DUtils.GetBattleResults(this.GetRecruitedUnitsAsUnitList(), DUtils.ToList(this.m_target.getUnits().getMatches(Matches.unitIsEnemyOf(this.m_data, GlobalCenter.CurrentPlayer))), this.m_target, this.m_data, DSettings.LoadSettings().CA_CMNCM_determinesIfTasksRequirementsAreMetEnoughForRecruitingStop, true);
            responseAttackers = DUtils.DetermineResponseAttackers(this.m_data, GlobalCenter.CurrentPlayer, this.m_target, simulatedAttack);
            responseDefenders = Match.getMatches(simulatedAttack.GetAverageAttackingUnitsRemaining(), Matches.UnitIsNotAir);
            simulatedResponse = DUtils.GetBattleResults(responseAttackers, responseDefenders, this.m_target, this.m_data, DSettings.LoadSettings().CA_CMNCM_determinesIfTasksRequirementsAreMetEnoughForRecruitingStop, true);
            howCloseToMeetingMinTakeoverChance = this.getMeetingOfMinTakeoverChance(simulatedAttack, minTakeoverChance);
            if (howCloseToMeetingMinTakeoverChance < 1.0f) {
                this.m_recruitedUnits.add(ug);
                continue;
            }
            howCloseToMeetingMinSurvivalChance = this.getMeetingOfMinSurvivalChance(simulatedResponse, minSurvivalChance);
            if (howCloseToMeetingMinSurvivalChance < 1.0f) {
                this.m_recruitedUnits.add(ug);
                continue;
            }
            howCloseToMeetingBattleVolleyMax = this.getMeetingOfMaxBattleVolleysScore(simulatedAttack, maxBattleVolleys);
            if (!(howCloseToMeetingBattleVolleyMax < 1.0f)) break;
            this.m_recruitedUnits.add(ug);
        }
    }

    private void recruitEnoughUnitsForTradeTask(float certaintyOfReachingLeftoverLUnitsGoalRequired, boolean recruitTillTUVStartsDropping) {
        float certaintyOfReachingLUnitsCount;
        int timesWeReachLeftoverLUnitsGoal;
        int tradeScore;
        List defenders;
        List<Unit> attackers;
        AggregateResults simulatedResponse;
        List<Unit> responseDefenders;
        List<Unit> responseAttackers;
        AggregateResults simulatedAttack;
        List<UnitGroup> sortedPossibles = this.getSortedPossibleRecruits();
        if (sortedPossibles.isEmpty()) {
            return;
        }
        int highestTUVSwing = Integer.MIN_VALUE;
        int successiveNonIncreases = 0;
        for (UnitGroup ug : sortedPossibles) {
            if (this.m_recruitedUnits.contains(ug)) continue;
            simulatedAttack = DUtils.GetBattleResults(this.GetRecruitedUnitsAsUnitList(), DUtils.ToList(this.m_target.getUnits().getMatches(Matches.unitIsEnemyOf(this.m_data, GlobalCenter.CurrentPlayer))), this.m_target, this.m_data, 1, true);
            responseAttackers = DUtils.DetermineResponseAttackers(this.m_data, GlobalCenter.CurrentPlayer, this.m_target, simulatedAttack);
            responseDefenders = Match.getMatches(simulatedAttack.GetAverageAttackingUnitsRemaining(), Matches.UnitIsNotAir);
            simulatedResponse = DUtils.GetBattleResults(responseAttackers, responseDefenders, this.m_target, this.m_data, 1, true);
            attackers = this.GetRecruitedUnitsAsUnitList();
            tradeScore = DUtils.GetTaskTradeScore(this.m_data, this.m_target, attackers, defenders = DUtils.ToList(this.m_target.getUnits().getMatches(Matches.unitIsEnemyOf(this.m_data, GlobalCenter.CurrentPlayer))), simulatedAttack, responseAttackers, responseDefenders, simulatedResponse);
            if ((float)tradeScore < this.m_attackTrade_tradeScoreRequired) {
                this.m_recruitedUnits.add(ug);
                continue;
            }
            timesWeReachLeftoverLUnitsGoal = 0;
            for (BattleResults result : simulatedAttack.m_results) {
                if (Match.getMatches(result.getRemainingAttackingUnits(), Matches.UnitIsLand).size() < this.m_attackTrade_leftoverLandUnits) continue;
                ++timesWeReachLeftoverLUnitsGoal;
            }
            certaintyOfReachingLUnitsCount = (float)timesWeReachLeftoverLUnitsGoal / (float)simulatedAttack.m_results.size();
            if (certaintyOfReachingLUnitsCount < certaintyOfReachingLeftoverLUnitsGoalRequired) {
                this.m_recruitedUnits.add(ug);
                continue;
            }
            if (!recruitTillTUVStartsDropping) break;
            successiveNonIncreases = (highestTUVSwing = Math.max(tradeScore, highestTUVSwing)) > tradeScore ? ++successiveNonIncreases : 0;
            this.m_recruitedUnits.add(ug);
        }
        this.m_recruitedUnits = DUtils.TrimRecruits_NonMovedOnes(this.m_recruitedUnits, 5);
        highestTUVSwing = Integer.MIN_VALUE;
        successiveNonIncreases = 0;
        for (UnitGroup ug : sortedPossibles) {
            if (this.m_recruitedUnits.contains(ug)) continue;
            simulatedAttack = DUtils.GetBattleResults(this.GetRecruitedUnitsAsUnitList(), DUtils.ToList(this.m_target.getUnits().getMatches(Matches.unitIsEnemyOf(this.m_data, GlobalCenter.CurrentPlayer))), this.m_target, this.m_data, DSettings.LoadSettings().CA_CM_determinesIfTradeTasksRequirementsAreMetEnoughForRecruitingStop, true);
            responseAttackers = DUtils.DetermineResponseAttackers(this.m_data, GlobalCenter.CurrentPlayer, this.m_target, simulatedAttack);
            responseDefenders = Match.getMatches(simulatedAttack.GetAverageAttackingUnitsRemaining(), Matches.UnitIsNotAir);
            simulatedResponse = DUtils.GetBattleResults(responseAttackers, responseDefenders, this.m_target, this.m_data, DSettings.LoadSettings().CA_CM_determinesIfTradeTasksRequirementsAreMetEnoughForRecruitingStop, true);
            attackers = this.GetRecruitedUnitsAsUnitList();
            tradeScore = DUtils.GetTaskTradeScore(this.m_data, this.m_target, attackers, defenders = DUtils.ToList(this.m_target.getUnits().getMatches(Matches.unitIsEnemyOf(this.m_data, GlobalCenter.CurrentPlayer))), simulatedAttack, responseAttackers, responseDefenders, simulatedResponse);
            if ((float)tradeScore < this.m_attackTrade_tradeScoreRequired) {
                this.m_recruitedUnits.add(ug);
                continue;
            }
            timesWeReachLeftoverLUnitsGoal = 0;
            for (BattleResults result : simulatedAttack.m_results) {
                if (Match.getMatches(result.getRemainingAttackingUnits(), Matches.UnitIsLand).size() < this.m_attackTrade_leftoverLandUnits) continue;
                ++timesWeReachLeftoverLUnitsGoal;
            }
            certaintyOfReachingLUnitsCount = (float)timesWeReachLeftoverLUnitsGoal / (float)simulatedAttack.m_results.size();
            if (certaintyOfReachingLUnitsCount < certaintyOfReachingLeftoverLUnitsGoalRequired) {
                this.m_recruitedUnits.add(ug);
                continue;
            }
            if (!recruitTillTUVStartsDropping) break;
            successiveNonIncreases = (highestTUVSwing = Math.max(tradeScore, highestTUVSwing)) > tradeScore ? ++successiveNonIncreases : 0;
            this.m_recruitedUnits.add(ug);
        }
        this.m_recruitedUnits = DUtils.TrimRecruits_NonMovedOnes(this.m_recruitedUnits, successiveNonIncreases);
    }

    public List<UnitGroup> GetRecruitedUnits() {
        return this.m_recruitedUnits;
    }

    public List<Unit> GetRecruitedUnitsAsUnitList() {
        ArrayList<Unit> result = new ArrayList<Unit>();
        for (UnitGroup ug : this.m_recruitedUnits) {
            result.addAll(ug.GetUnits());
        }
        return result;
    }

    public boolean IsPlannedAttackWorthwhile(List<CM_Task> allTasks) {
        GameData data;
        Territory closestToTargetEnemyCap;
        PlayerID player = GlobalCenter.CurrentPlayer;
        DUtils.Log(Level.FINEST, "      Determining if cm task is worthwhile. Target: {0} Recruits Size: {1}", this.m_target, this.m_recruitedUnits.size());
        if (this.m_target.getOwner().isNull() && DUtils.GetTerritoriesWithinXDistanceOfYMatchingZAndHavingRouteMatchingA(this.m_data, this.m_target, Integer.MAX_VALUE, DMatches.territoryIsOwnedByNNEnemy(this.m_data, player), Matches.TerritoryIsLand).size() >= 3) {
            if (GlobalCenter.IsFFAGame && this.m_target.getUnits().getMatches(Matches.unitHasDefenseThatIsMoreThanOrEqualTo(1)).size() > 0 && Math.random() < (double)0.95f) {
                return false;
            }
            if (TerritoryAttachment.get(this.m_target) == null || Properties.getNeutralCharge(this.m_data) > TerritoryAttachment.get(this.m_target).getProduction() && Math.random() < 0.75) {
                return false;
            }
            if (TerritoryAttachment.get(this.m_target) == null || Properties.getNeutralCharge(this.m_data) > TerritoryAttachment.get(this.m_target).getProduction() * 3) {
                return false;
            }
        }
        if ((this.m_taskType == CM_TaskType.Land_Attack_Offensive || this.m_taskType == CM_TaskType.Land_Attack_Trade) && (closestToTargetEnemyCap = DUtils.GetClosestTerInList(data = this.m_target.getData(), DUtils.GetAllEnemyCaps_ThatAreOwnedByOriginalOwner(data, player), this.m_target)) != null) {
            boolean targetIsCloserToCapThanFromLocations = true;
            Route targetToEnemyCapRoute = CachedCalculationCenter.GetPassableLandRoute(data, this.m_target, closestToTargetEnemyCap);
            for (Territory recruitFromLoc : DUtils.GetUnitLocations(data, this.GetRecruitedUnitsAsUnitList())) {
                Route routeToEnemyCap = CachedCalculationCenter.GetPassableLandRoute(data, recruitFromLoc, closestToTargetEnemyCap);
                if (routeToEnemyCap == null || targetToEnemyCapRoute == null || routeToEnemyCap.getLength() > targetToEnemyCapRoute.getLength()) continue;
                targetIsCloserToCapThanFromLocations = false;
                break;
            }
            boolean targetIsTooCloseToCap = false;
            Territory ourClosestCap = DUtils.GetClosestTerInList(data, DUtils.GetAllOurCaps(data, player), this.m_target);
            Route routeToClosestCap = CachedCalculationCenter.GetPassableLandRoute(data, this.m_target, ourClosestCap);
            if (ourClosestCap != null && routeToClosestCap != null && (float)routeToClosestCap.getLength() <= 3.0f * GlobalCenter.MapTerCountScale) {
                targetIsTooCloseToCap = true;
            }
            StrategyType strategyType = StrategyCenter.get(this.m_data, player).GetCalculatedStrategyAssignments().get(closestToTargetEnemyCap.getOwner());
            if (!targetIsTooCloseToCap && strategyType == StrategyType.Enemy_Defensive && targetIsCloserToCapThanFromLocations) {
                List<Unit> ourUnitsInArea = DUtils.GetUnitsMatchingXInTerritories(DUtils.GetTerritoriesWithinXDistanceOfYMatchingZAndHavingRouteMatchingA(this.m_data, this.m_target, 2, Matches.TerritoryIsLand, Matches.TerritoryIsLand), Matches.unitIsOwnedBy(player));
                if (this.m_recruitedUnits.size() >= ourUnitsInArea.size() / 2) {
                    return false;
                }
            }
        }
        if (this.m_recruitedUnits.isEmpty()) {
            return false;
        }
        List<Territory> ourCaps = DUtils.GetAllOurCaps(this.m_data, player);
        if (!this.m_taskType.equals((Object)CM_TaskType.Land_LandGrab)) {
            ArrayList<Territory> capsAndNeighbors = new ArrayList<Territory>();
            for (Territory cap : ourCaps) {
                capsAndNeighbors.addAll(DUtils.GetTerritoriesWithinXDistanceOfY(this.m_data, cap, 1));
            }
            HashSet capsAndNeighborsUnits = DUtils.ToHashSet(DUtils.GetUnitsInTerritories(capsAndNeighbors));
            boolean areRecruitsFromCapsOrNeighbors = false;
            for (Unit recruit : this.GetRecruitedUnitsAsUnitList()) {
                if (!capsAndNeighborsUnits.contains(recruit)) continue;
                areRecruitsFromCapsOrNeighbors = true;
                break;
            }
            if (areRecruitsFromCapsOrNeighbors && !ourCaps.contains(this.m_target)) {
                Territory ourClosestCap = DUtils.GetOurClosestCap(this.m_data, player, this.m_target);
                ThreatInvalidationCenter.get(this.m_data, player).SuspendThreatInvalidation();
                List<Float> capTakeoverChances = DUtils.GetTerTakeoverChanceBeforeAndAfterMove(this.m_data, player, ourClosestCap, this.m_target, this.GetRecruitedUnitsAsUnitList(), DSettings.LoadSettings().CA_CMNCM_determinesIfTaskEndangersCap);
                ThreatInvalidationCenter.get(this.m_data, player).ResumeThreatInvalidation();
                if (capTakeoverChances.get(1).floatValue() > 0.1f && (capTakeoverChances.get(1).floatValue() - capTakeoverChances.get(0).floatValue() > 0.01f || capTakeoverChances.get(3).floatValue() - capTakeoverChances.get(2).floatValue() > 1.0f)) {
                    DUtils.Log(Level.FINEST, "        Performing task would endanger capital, so canceling.", new Object[0]);
                    return false;
                }
            }
        }
        List<Unit> attackers = this.GetRecruitedUnitsAsUnitList();
        attackers.removeAll(this.m_target.getUnits().getUnits());
        attackers.addAll(this.m_target.getUnits().getMatches(Matches.unitIsOwnedBy(GlobalCenter.CurrentPlayer)));
        List defenders = DUtils.ToList(this.m_target.getUnits().getMatches(Matches.unitIsEnemyOf(this.m_data, GlobalCenter.CurrentPlayer)));
        AggregateResults simulatedAttack = DUtils.GetBattleResults(attackers, defenders, this.m_target, this.m_data, DSettings.LoadSettings().CA_CM_determinesAttackResultsToSeeIfTaskWorthwhile, true);
        List<Unit> responseAttackers = DUtils.DetermineResponseAttackers(this.m_data, GlobalCenter.CurrentPlayer, this.m_target, simulatedAttack);
        List<Unit> responseDefenders = Match.getMatches(simulatedAttack.GetAverageAttackingUnitsRemaining(), Matches.UnitIsNotAir);
        AggregateResults simulatedResponse = DUtils.GetBattleResults(responseAttackers, responseDefenders, this.m_target, this.m_data, DSettings.LoadSettings().CA_CMNCM_determinesResponseResultsToSeeIfTaskWorthwhile, true);
        DUtils.Log(Level.FINEST, "        Attack simulated. Attackers Size: {0} Defenders Size: {1} Takeover Chance: {2}", attackers.size(), defenders.size(), simulatedAttack.getAttackerWinPercent());
        DUtils.Log(Level.FINEST, "        Counter attack simulated. Attackers Size: {0} Defenders Size: {1} Takeover Chance: {2}", responseAttackers.size(), responseDefenders.size(), simulatedResponse.getAttackerWinPercent());
        if (this.m_taskType == CM_TaskType.Land_Attack_Offensive) {
            float howCloseToMeetingTakeoverChanceMin = this.getMeetingOfMinTakeoverChance(simulatedAttack, this.m_minTakeoverChance);
            DUtils.Log(Level.FINEST, "        How close to meeting takeover chance min: {0} Needed: {1}", Float.valueOf(howCloseToMeetingTakeoverChanceMin), Float.valueOf(0.98f));
            if (howCloseToMeetingTakeoverChanceMin < 0.98f) {
                return false;
            }
            float howCloseToMeetingMinSurvivalChance = this.getMeetingOfMinSurvivalChance(simulatedResponse, this.m_minSurvivalChance);
            DUtils.Log(Level.FINEST, "        How close to meeting survival chance min: {0} Needed: {1}", Float.valueOf(howCloseToMeetingMinSurvivalChance), Float.valueOf(0.98f));
            if (howCloseToMeetingMinSurvivalChance < 0.98f) {
                simulatedResponse = DUtils.GetBattleResults(responseAttackers, responseDefenders, this.m_target, this.m_data, DSettings.LoadSettings().CA_CMNCM_determinesResponseResultsToSeeIfTaskWorthwhile, false);
                int tradeScoreIfAttacked = -DUtils.GetTaskTradeScore(this.m_data, this.m_target, responseAttackers, responseDefenders, simulatedResponse, new ArrayList<Unit>(), new ArrayList<Unit>(), null);
                DUtils.Log(Level.FINEST, "        Trade score if attacked: {0} Required for bypass: {1}", tradeScoreIfAttacked, Float.valueOf(this.m_minCounterAttackTradeScoreForBypass));
                return (float)tradeScoreIfAttacked >= this.m_minCounterAttackTradeScoreForBypass;
            }
            return true;
        }
        if (this.m_taskType.equals((Object)CM_TaskType.Land_Attack_Stabilize)) {
            float howCloseToMeetingTakeoverChanceMin = this.getMeetingOfMinTakeoverChance(simulatedAttack, this.m_minTakeoverChance);
            DUtils.Log(Level.FINEST, "        How close to meeting takeover chance min: {0} Needed: {1}", Float.valueOf(0.98f));
            if (howCloseToMeetingTakeoverChanceMin < 0.98f) {
                return false;
            }
            float howCloseToMeetingMinSurvivalChance = this.getMeetingOfMinSurvivalChance(simulatedResponse, this.m_minSurvivalChance);
            DUtils.Log(Level.FINEST, "        How close to meeting survival chance min: {0} Needed: {1}", Float.valueOf(howCloseToMeetingMinSurvivalChance), Float.valueOf(0.98f));
            if (howCloseToMeetingMinSurvivalChance < 0.98f) {
                simulatedResponse = DUtils.GetBattleResults(responseAttackers, responseDefenders, this.m_target, this.m_data, DSettings.LoadSettings().CA_CMNCM_determinesResponseResultsToSeeIfTaskWorthwhile, false);
                int tradeScoreIfAttacked = -DUtils.GetTaskTradeScore(this.m_data, this.m_target, responseAttackers, responseDefenders, simulatedResponse, new ArrayList<Unit>(), new ArrayList<Unit>(), null);
                DUtils.Log(Level.FINEST, "        Trade score if attacked: {0} Required for bypass: {1}", tradeScoreIfAttacked, Float.valueOf(this.m_minCounterAttackTradeScoreForBypass));
                return (float)tradeScoreIfAttacked >= this.m_minCounterAttackTradeScoreForBypass;
            }
            return true;
        }
        if (this.m_taskType == CM_TaskType.Land_Attack_Trade) {
            if (StatusCenter.get(this.m_data, player).GetStatusOfTerritory(this.m_target).WasAttacked()) {
                return false;
            }
            simulatedResponse = DUtils.GetBattleResults(responseAttackers, responseDefenders, this.m_target, this.m_data, DSettings.LoadSettings().CA_CMNCM_determinesResponseResultsToSeeIfTaskWorthwhile, false);
            int tradeScore = DUtils.GetTaskTradeScore(this.m_data, this.m_target, attackers, defenders, simulatedAttack, responseAttackers, responseDefenders, simulatedResponse);
            DUtils.Log(Level.FINEST, "        Task trade score: {0} Needed: {1}", tradeScore, Float.valueOf(this.m_attackTrade_tradeScoreRequired));
            if ((float)tradeScore < this.m_attackTrade_tradeScoreRequired) {
                return false;
            }
            int timesWeReachLeftoverLUnitsGoal = 0;
            for (BattleResults result : simulatedAttack.m_results) {
                if (Match.getMatches(result.getRemainingAttackingUnits(), Matches.UnitIsLand).size() < this.m_attackTrade_leftoverLandUnits) continue;
                ++timesWeReachLeftoverLUnitsGoal;
            }
            float certaintyOfReachingLUnitsCount = (float)timesWeReachLeftoverLUnitsGoal / (float)simulatedAttack.m_results.size();
            DUtils.Log(Level.FINEST, "        Certainty of reaching leftover land units goal({0}): {1} Needed: {2}", this.m_attackTrade_leftoverLandUnits, Float.valueOf(certaintyOfReachingLUnitsCount), Float.valueOf(this.m_attackTrade_certaintyOfReachingLeftoverLUnitsGoalRequired));
            return !(certaintyOfReachingLUnitsCount < this.m_attackTrade_certaintyOfReachingLeftoverLUnitsGoalRequired);
        }
        if (CachedInstanceCenter.CachedBattleTracker.wasConquered(this.m_target)) {
            this.m_completed = true;
            this.m_recruitedUnits = new ArrayList<UnitGroup>();
            DUtils.Log(Level.FINEST, "        Territory to-grab was already grabbed, so not doing moving, but marking task as completed.", new Object[0]);
            StatusCenter.get(this.m_data, player).GetStatusOfTerritory(this.m_target).NotifyTaskPerform(this);
            return true;
        }
        Territory startTer = TacticalCenter.get(this.m_data, player).GetUnitLocationAtStartOfTurn(this.m_recruitedUnits.get(0).GetFirstUnit());
        Route route = this.m_data.getMap().getRoute(startTer, this.m_target, Matches.TerritoryIsLand);
        boolean canUnitsGetBack = false;
        for (Unit unit : this.GetRecruitedUnitsAsUnitList()) {
            TripleAUnit ta = TripleAUnit.get(unit);
            if (ta.getMovementLeft() < route.getLength() * 2) continue;
            canUnitsGetBack = true;
        }
        if (canUnitsGetBack) {
            return true;
        }
        int unitCost = DUtils.GetTUVOfUnits(this.GetRecruitedUnitsAsUnitList(), GlobalCenter.GetPUResource());
        TerritoryAttachment ta = TerritoryAttachment.get(this.m_target);
        List<Unit> landAttackers = DUtils.GetNNEnemyLUnitsThatCanReach(this.m_data, this.m_target, GlobalCenter.CurrentPlayer, Matches.TerritoryIsLandOrWater);
        int cheapestLAttacker = 0;
        if (landAttackers.size() > 0) {
            cheapestLAttacker = DUtils.GetTUVOfUnit(DUtils.GetCheapestUnitInList(landAttackers), GlobalCenter.GetPUResource());
        }
        float chanceOfHittingCheapestLAttacker = (float)UnitAttachment.get(this.GetRecruitedUnitsAsUnitList().get(0).getUnitType()).getDefense(player) / 6.0f;
        float averageTuvLossOfAttackerIfAttacked = chanceOfHittingCheapestLAttacker * (float)cheapestLAttacker;
        float tuvSwing = averageTuvLossOfAttackerIfAttacked - (float)unitCost;
        if (landAttackers.isEmpty()) {
            tuvSwing = 0.0f;
        }
        return tuvSwing + (float)ta.getProduction() > 0.0f;
    }

    public boolean IsTaskWithAdditionalRecruitsWorthwhile() {
        DUtils.Log(Level.FINEST, "      Determining if cm task with additional recruits is worthwhile. Target: {0} Recruits Size: {1}", this.m_target, this.m_recruitedUnits.size());
        if (this.m_recruitedUnits.isEmpty()) {
            return false;
        }
        PlayerID player = GlobalCenter.CurrentPlayer;
        List<Territory> ourCaps = DUtils.GetAllOurCaps(this.m_data, player);
        if (!this.m_taskType.equals((Object)CM_TaskType.Land_LandGrab)) {
            ArrayList<Territory> capsAndNeighbors = new ArrayList<Territory>();
            for (Territory cap : ourCaps) {
                capsAndNeighbors.addAll(DUtils.GetTerritoriesWithinXDistanceOfY(this.m_data, cap, 1));
            }
            HashSet capsAndNeighborsUnits = DUtils.ToHashSet(DUtils.GetUnitsInTerritories(capsAndNeighbors));
            boolean areRecruitsFromCapsOrNeighbors = false;
            for (Unit recruit : this.GetRecruitedUnitsAsUnitList()) {
                if (!capsAndNeighborsUnits.contains(recruit)) continue;
                areRecruitsFromCapsOrNeighbors = true;
                break;
            }
            if (areRecruitsFromCapsOrNeighbors && !ourCaps.contains(this.m_target)) {
                Territory ourClosestCap = DUtils.GetOurClosestCap(this.m_data, player, this.m_target);
                ThreatInvalidationCenter.get(this.m_data, player).SuspendThreatInvalidation();
                List<Float> capTakeoverChances = DUtils.GetTerTakeoverChanceBeforeAndAfterMove(this.m_data, player, ourClosestCap, this.m_target, this.GetRecruitedUnitsAsUnitList(), DSettings.LoadSettings().CA_CMNCM_determinesIfTaskEndangersCap);
                ThreatInvalidationCenter.get(this.m_data, player).ResumeThreatInvalidation();
                if (capTakeoverChances.get(1).floatValue() > 0.1f && (capTakeoverChances.get(1).floatValue() - capTakeoverChances.get(0).floatValue() > 0.01f || capTakeoverChances.get(3).floatValue() - capTakeoverChances.get(2).floatValue() > 1.0f)) {
                    DUtils.Log(Level.FINEST, "      Performing task with additional recruits would endanger capital, so canceling.", new Object[0]);
                    return false;
                }
            }
        }
        return true;
    }

    public boolean IsDisqualified() {
        return this.m_disqualified;
    }

    public void Disqualify() {
        this.m_disqualified = true;
    }

    public void InvalidateThreatsThisTaskResists() {
        PlayerID player = GlobalCenter.CurrentPlayer;
        if (this.m_taskType == CM_TaskType.Land_Attack_Offensive) {
            ThreatInvalidationCenter.get(this.m_data, player).SuspendThreatInvalidation();
            AggregateResults simulatedAttack = DUtils.GetBattleResults(this.GetRecruitedUnitsAsUnitList(), DUtils.ToList(this.m_target.getUnits().getMatches(Matches.unitIsEnemyOf(this.m_data, GlobalCenter.CurrentPlayer))), this.m_target, this.m_data, 250, true);
            List<Unit> threats = DUtils.DetermineResponseAttackers(this.m_data, GlobalCenter.CurrentPlayer, this.m_target, simulatedAttack);
            if (threats.isEmpty()) {
                return;
            }
            List<Unit> responseDefenders = Match.getMatches(simulatedAttack.GetAverageAttackingUnitsRemaining(), Matches.UnitIsNotAir);
            AggregateResults simulatedResponse = DUtils.GetBattleResults(threats, responseDefenders, this.m_target, this.m_data, DSettings.LoadSettings().CA_CMNCM_determinesSurvivalChanceAfterTaskToSeeIfToInvalidateAttackers, true);
            if (simulatedResponse.getDefenderWinPercent() > (double)0.4f) {
                ThreatInvalidationCenter.get(this.m_data, player).InvalidateThreats(threats, this.m_target);
            }
            ThreatInvalidationCenter.get(this.m_data, player).ResumeThreatInvalidation();
        } else if (this.m_taskType == CM_TaskType.Land_Attack_Stabilize) {
            ThreatInvalidationCenter.get(this.m_data, player).SuspendThreatInvalidation();
            AggregateResults simulatedAttack = DUtils.GetBattleResults(this.GetRecruitedUnitsAsUnitList(), DUtils.ToList(this.m_target.getUnits().getMatches(Matches.unitIsEnemyOf(this.m_data, GlobalCenter.CurrentPlayer))), this.m_target, this.m_data, 250, true);
            List<Unit> threats = DUtils.DetermineResponseAttackers(this.m_data, GlobalCenter.CurrentPlayer, this.m_target, simulatedAttack);
            if (threats.isEmpty()) {
                return;
            }
            List<Unit> responseDefenders = Match.getMatches(simulatedAttack.GetAverageAttackingUnitsRemaining(), Matches.UnitIsNotAir);
            AggregateResults simulatedResponse = DUtils.GetBattleResults(threats, responseDefenders, this.m_target, this.m_data, DSettings.LoadSettings().CA_CMNCM_determinesSurvivalChanceAfterTaskToSeeIfToInvalidateAttackers, true);
            if (simulatedResponse.getDefenderWinPercent() > (double)0.4f) {
                ThreatInvalidationCenter.get(this.m_data, player).InvalidateThreats(threats, this.m_target);
            }
            ThreatInvalidationCenter.get(this.m_data, player).ResumeThreatInvalidation();
        }
    }

    public void Reset() {
        DUtils.Log(Level.FINER, "        Resetting task. Target: {0} Task Type: {1} Priority: {2} Recruit Size: {3}", new Object[]{this.m_target, this.m_taskType, Float.valueOf(this.m_priority), this.m_recruitedUnits.size()});
        this.m_completed = false;
        this.m_disqualified = false;
        this.m_recruitedUnits = new ArrayList<UnitGroup>();
    }

    public boolean IsCompleted() {
        return this.m_completed;
    }

    public void PerformTask(IMoveDelegate mover) {
        String errors;
        if (this.m_recruitedUnits.isEmpty()) {
            DUtils.Log(Level.FINER, "      Task is called to perform, but there are no recruits! Target: {0} Task Type: {1} Priority: {2}", new Object[]{this.m_target, this.m_taskType, Float.valueOf(this.m_priority)});
            this.m_completed = true;
            return;
        }
        UnitGroup.EnableMoveBuffering();
        boolean anythingMoved = false;
        for (UnitGroup ug : this.m_recruitedUnits) {
            if (ug.GetMovedTo() != null) continue;
            String error = ug.MoveAsFarTo_CM(this.m_target, mover);
            if (error != null) {
                DUtils.Log(Level.FINER, "        CM task perfoming move failed, reason: {0}", error);
                continue;
            }
            anythingMoved = true;
        }
        if (!anythingMoved) {
            this.m_disqualified = true;
            return;
        }
        if (!this.m_completed) {
            Dynamix_AI.Pause();
        }
        if ((errors = UnitGroup.PerformBufferedMovesAndDisableMoveBufferring(mover)) != null) {
            DUtils.Log(Level.FINER, "      Some errors occurred while performing moves: {0}", errors);
            this.m_disqualified = true;
            return;
        }
        ReconsiderSignalCenter.get((GameData)this.m_data, (PlayerID)GlobalCenter.CurrentPlayer).ObjectsToReconsider.addAll(CachedInstanceCenter.CachedGameData.getMap().getNeighbors(this.m_target));
        this.m_completed = true;
        if (this.m_taskType.equals((Object)CM_TaskType.Land_Attack_Offensive) || this.m_taskType.equals((Object)CM_TaskType.Land_Attack_Stabilize)) {
            TacticalCenter.get((GameData)this.m_data, (PlayerID)GlobalCenter.CurrentPlayer).BattleRetreatChanceAssignments.put(this.m_target, Float.valueOf(this.m_minTakeoverChance));
        }
        StatusCenter.get(this.m_data, GlobalCenter.CurrentPlayer).GetStatusOfTerritory(this.m_target).NotifyTaskPerform(this);
    }
}

