/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.triplea.ai.Dynamix_AI.Others;

import games.strategy.engine.data.GameData;
import games.strategy.engine.data.PlayerID;
import games.strategy.engine.data.Route;
import games.strategy.engine.data.Territory;
import games.strategy.engine.data.Unit;
import games.strategy.triplea.ai.Dynamix_AI.CommandCenter.CachedCalculationCenter;
import games.strategy.triplea.ai.Dynamix_AI.CommandCenter.CachedInstanceCenter;
import games.strategy.triplea.ai.Dynamix_AI.CommandCenter.GlobalCenter;
import games.strategy.triplea.ai.Dynamix_AI.CommandCenter.ReconsiderSignalCenter;
import games.strategy.triplea.ai.Dynamix_AI.CommandCenter.StatusCenter;
import games.strategy.triplea.ai.Dynamix_AI.CommandCenter.TacticalCenter;
import games.strategy.triplea.ai.Dynamix_AI.CommandCenter.ThreatInvalidationCenter;
import games.strategy.triplea.ai.Dynamix_AI.DMatches;
import games.strategy.triplea.ai.Dynamix_AI.DSettings;
import games.strategy.triplea.ai.Dynamix_AI.DSorting;
import games.strategy.triplea.ai.Dynamix_AI.DUtils;
import games.strategy.triplea.ai.Dynamix_AI.Dynamix_AI;
import games.strategy.triplea.ai.Dynamix_AI.Group.UnitGroup;
import games.strategy.triplea.ai.Dynamix_AI.Others.NCM_TaskType;
import games.strategy.triplea.attatchments.TerritoryAttachment;
import games.strategy.triplea.attatchments.UnitAttachment;
import games.strategy.triplea.delegate.Matches;
import games.strategy.triplea.delegate.remote.IMoveDelegate;
import games.strategy.triplea.oddsCalculator.ta.AggregateResults;
import games.strategy.util.CompositeMatchOr;
import games.strategy.util.Match;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.logging.Level;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NCM_Task {
    private Territory m_target = null;
    private NCM_TaskType m_taskType = NCM_TaskType.Empty;
    private float m_priority = 0.0f;
    private GameData m_data = null;
    private float m_minSurvivalChance = 0.0f;
    private List<UnitGroup> m_recruitedUnits = new ArrayList<UnitGroup>();
    private boolean m_disqualified = false;
    private boolean m_completed = false;

    public NCM_Task(GameData data, Territory target, NCM_TaskType type, float priority) {
        this.m_data = data;
        this.m_taskType = type;
        this.m_priority = priority;
        this.m_target = target;
    }

    public Territory GetTarget() {
        return this.m_target;
    }

    public NCM_TaskType GetTaskType() {
        return this.m_taskType;
    }

    public float GetPriority() {
        return this.m_priority;
    }

    public void SetPriority(float priority) {
        this.m_priority = priority;
    }

    private List<UnitGroup> getSortedPossibleRecruits() {
        HashMap<Unit, Territory> unitLocations = new HashMap<Unit, Territory>();
        HashMap<Unit, Integer> possibles = new HashMap<Unit, Integer>();
        boolean addedAA = false;
        for (final Territory ter : this.m_data.getMap().getTerritories()) {
            if (DMatches.territoryContainsMultipleAlliances(this.m_data).match(ter)) continue;
            final HashSet recruitsAsHashSet = DUtils.ToHashSet(this.GetRecruitedUnitsAsUnitList());
            Match<Unit> unitMatch = new Match<Unit>(){

                @Override
                public boolean match(Unit unit) {
                    UnitAttachment ua = UnitAttachment.get(unit.getUnitType());
                    if (!Matches.unitIsOwnedBy(GlobalCenter.CurrentPlayer).match(unit)) {
                        return false;
                    }
                    if (Matches.UnitIsInfrastructure.match(unit) && ua.getDefense(unit.getOwner()) <= 0) {
                        return false;
                    }
                    if (Matches.UnitCanProduceUnits.match(unit) && ua.getDefense(unit.getOwner()) <= 0) {
                        return false;
                    }
                    if (recruitsAsHashSet.contains(unit)) {
                        return false;
                    }
                    return DUtils.CanUnitReachTer(NCM_Task.this.m_data, ter, unit, NCM_Task.this.m_target);
                }
            };
            List<Unit> units = Match.getMatches(DUtils.ToList(ter.getUnits().getUnits()), unitMatch);
            if (units.isEmpty()) continue;
            for (Unit unit : units) {
                int suitability;
                if (Matches.UnitIsAAforAnything.match(unit) || (suitability = DUtils.HowWellIsUnitSuitedToTask(this.m_data, this, ter, unit)) == Integer.MIN_VALUE) continue;
                possibles.put(unit, suitability);
                unitLocations.put(unit, ter);
            }
        }
        List sortedPossibles = DUtils.ToList(possibles.keySet());
        sortedPossibles = DSorting.SortListByScores_List_D(sortedPossibles, possibles.values());
        ArrayList<UnitGroup> result = new ArrayList<UnitGroup>();
        for (Unit unit : sortedPossibles) {
            result.add(DUtils.CreateUnitGroupForUnits(Collections.singletonList(unit), (Territory)unitLocations.get(unit), this.m_data));
        }
        return result;
    }

    public void CalculateTaskRequirements() {
        if (this.m_taskType.equals((Object)NCM_TaskType.Land_Reinforce_Block)) {
            return;
        }
        if (this.m_taskType == NCM_TaskType.Land_Reinforce_FrontLine) {
            this.m_minSurvivalChance = DUtils.ToFloat(DSettings.LoadSettings().TR_reinforceFrontLine_enemyAttackSurvivalChanceRequired);
        } else if (this.m_taskType.equals((Object)NCM_TaskType.Land_Reinforce_Stabilize)) {
            this.m_minSurvivalChance = DUtils.ToFloat(DSettings.LoadSettings().TR_reinforceStabalize_enemyAttackSurvivalChanceRequired);
        }
    }

    public void SetTaskRequirements(float minSurvivalChance) {
        this.m_minSurvivalChance = minSurvivalChance;
    }

    private float getMeetingOfMinSurvivalChanceScore(AggregateResults simulatedAttack, float minSurvivalChance) {
        if (this.m_taskType.equals((Object)NCM_TaskType.Land_Reinforce_Block)) {
            if (this.m_recruitedUnits.size() > 0) {
                return 1.0f;
            }
            return 0.0f;
        }
        return DUtils.Divide_SL((float)simulatedAttack.getDefenderWinPercent(), minSurvivalChance);
    }

    private float getMeetingOfMaxBattleVolleysScore(AggregateResults simulatedAttack, int maxBattleVolleys) {
        if (this.m_taskType.equals((Object)NCM_TaskType.Land_Reinforce_Block)) {
            if (this.m_recruitedUnits.size() > 0) {
                return 1.0f;
            }
            return 0.0f;
        }
        return DUtils.Divide_SL(maxBattleVolleys, (float)simulatedAttack.getAverageBattleRoundsFought());
    }

    public void RecruitUnits() {
        this.recruitEnoughUnitsToMeetXYZ(this.m_minSurvivalChance, 100);
    }

    public void RecruitUnits2() {
        if (this.m_taskType.equals((Object)NCM_TaskType.Land_Reinforce_Block) && this.m_recruitedUnits.size() > 0) {
            return;
        }
        float minSurvivalChance = 0.8f;
        int maxBattleVolleys = 5;
        this.recruitEnoughUnitsToMeetXYZ(0.8f, 5);
    }

    public void RecruitUnits3() {
        if (this.m_taskType.equals((Object)NCM_TaskType.Land_Reinforce_Block) && this.m_recruitedUnits.size() > 0) {
            return;
        }
        float minSurvivalChance = 0.9f;
        int maxBattleVolleys = 3;
        this.recruitEnoughUnitsToMeetXYZ(0.9f, 3);
    }

    public void RecruitUnits4() {
        if (this.m_taskType.equals((Object)NCM_TaskType.Land_Reinforce_Block) && this.m_recruitedUnits.size() > 0) {
            return;
        }
        float minSurvivalChance = 1.0f;
        boolean maxBattleVolleys = true;
        this.recruitEnoughUnitsToMeetXYZ(1.0f, 1);
    }

    private void recruitEnoughUnitsToMeetXYZ(float minSurvivalChance, int maxBattleVolleys) {
        float howCloseToMeetingBattleVolleyMax;
        AggregateResults simulatedAttack;
        float howCloseToMeetingMinSurvivalChance;
        List<Unit> defenders;
        List<Unit> attackers;
        List<UnitGroup> sortedPossibles = this.getSortedPossibleRecruits();
        if (sortedPossibles.isEmpty()) {
            return;
        }
        for (UnitGroup ug : sortedPossibles) {
            if (this.m_recruitedUnits.contains(ug)) continue;
            attackers = DUtils.GetSPNNEnemyUnitsThatCanReach(this.m_data, this.m_target, GlobalCenter.CurrentPlayer, Matches.TerritoryIsLandOrWater);
            defenders = this.GetRecruitedUnitsAsUnitList();
            defenders.addAll(DUtils.GetUnitsGoingToBePlacedAtX(this.m_data, GlobalCenter.CurrentPlayer, this.m_target));
            if (!DSettings.LoadSettings().AA_ignoreAlliedUnitsAsDefenses) {
                defenders.removeAll(this.m_target.getUnits().getUnits());
                defenders.addAll(this.m_target.getUnits().getUnits());
            }
            if ((howCloseToMeetingMinSurvivalChance = this.getMeetingOfMinSurvivalChanceScore(simulatedAttack = DUtils.GetBattleResults(attackers, defenders, this.m_target, this.m_data, 1, true), minSurvivalChance)) < 1.0f) {
                this.m_recruitedUnits.add(ug);
                continue;
            }
            howCloseToMeetingBattleVolleyMax = this.getMeetingOfMaxBattleVolleysScore(simulatedAttack, maxBattleVolleys);
            if (!(howCloseToMeetingBattleVolleyMax < 1.0f)) break;
            this.m_recruitedUnits.add(ug);
        }
        this.m_recruitedUnits = DUtils.TrimRecruits_NonMovedOnes(this.m_recruitedUnits, 7);
        for (UnitGroup ug : sortedPossibles) {
            if (this.m_recruitedUnits.contains(ug)) continue;
            attackers = DUtils.GetSPNNEnemyUnitsThatCanReach(this.m_data, this.m_target, GlobalCenter.CurrentPlayer, Matches.TerritoryIsLandOrWater);
            defenders = this.GetRecruitedUnitsAsUnitList();
            defenders.addAll(DUtils.GetUnitsGoingToBePlacedAtX(this.m_data, GlobalCenter.CurrentPlayer, this.m_target));
            if (!DSettings.LoadSettings().AA_ignoreAlliedUnitsAsDefenses) {
                defenders.removeAll(this.m_target.getUnits().getUnits());
                defenders.addAll(this.m_target.getUnits().getUnits());
            }
            if ((howCloseToMeetingMinSurvivalChance = this.getMeetingOfMinSurvivalChanceScore(simulatedAttack = DUtils.GetBattleResults(attackers, defenders, this.m_target, this.m_data, DSettings.LoadSettings().CA_CMNCM_determinesIfTasksRequirementsAreMetEnoughForRecruitingStop, true), minSurvivalChance)) < 1.0f) {
                this.m_recruitedUnits.add(ug);
                continue;
            }
            howCloseToMeetingBattleVolleyMax = this.getMeetingOfMaxBattleVolleysScore(simulatedAttack, maxBattleVolleys);
            if (!(howCloseToMeetingBattleVolleyMax < 1.0f)) break;
            this.m_recruitedUnits.add(ug);
        }
    }

    public List<UnitGroup> GetRecruitedUnits() {
        return this.m_recruitedUnits;
    }

    public List<Unit> GetRecruitedUnitsAsUnitList() {
        ArrayList<Unit> result = new ArrayList<Unit>();
        for (UnitGroup ug : this.m_recruitedUnits) {
            result.addAll(ug.GetUnits());
        }
        return result;
    }

    public boolean IsPlannedMoveWorthwhile(List<NCM_Task> allTasks) {
        DUtils.Log(Level.FINEST, "      Determining if ncm task is worthwhile. Target: {0} Recruits Size: {1}", this.m_target, this.m_recruitedUnits.size());
        PlayerID player = GlobalCenter.CurrentPlayer;
        List<Territory> ourCaps = DUtils.GetAllOurCaps(this.m_data, player);
        ArrayList<Territory> capsAndNeighbors = new ArrayList<Territory>();
        for (Territory cap : ourCaps) {
            capsAndNeighbors.addAll(DUtils.GetTerritoriesWithinXDistanceOfY(this.m_data, cap, 1));
        }
        HashSet capsAndNeighborsUnits = DUtils.ToHashSet(DUtils.GetUnitsInTerritories(capsAndNeighbors));
        boolean areRecruitsFromCapsOrNeighbors = false;
        for (Unit recruit : this.GetRecruitedUnitsAsUnitList()) {
            if (!capsAndNeighborsUnits.contains(recruit)) continue;
            areRecruitsFromCapsOrNeighbors = true;
            break;
        }
        if (areRecruitsFromCapsOrNeighbors && !ourCaps.contains(this.m_target)) {
            Territory ourClosestCap = DUtils.GetOurClosestCap(this.m_data, player, this.m_target);
            ThreatInvalidationCenter.get(this.m_data, player).SuspendThreatInvalidation();
            List recruits = DUtils.CombineCollections(this.GetRecruitedUnitsAsUnitList(), DUtils.GetUnitsGoingToBePlacedAtX(this.m_data, player, this.m_target));
            List<Float> capTakeoverChances = DUtils.GetTerTakeoverChanceBeforeAndAfterMove(this.m_data, player, ourClosestCap, this.m_target, recruits, DSettings.LoadSettings().CA_CMNCM_determinesIfTaskEndangersCap);
            ThreatInvalidationCenter.get(this.m_data, player).ResumeThreatInvalidation();
            if (capTakeoverChances.get(1).floatValue() > 0.1f && (capTakeoverChances.get(1).floatValue() - capTakeoverChances.get(0).floatValue() > 0.01f || capTakeoverChances.get(3).floatValue() - capTakeoverChances.get(2).floatValue() > 1.0f)) {
                DUtils.Log(Level.FINEST, "      Performing task would endanger capital, so canceling.", new Object[0]);
                return false;
            }
        }
        List<Unit> attackers = DUtils.GetSPNNEnemyUnitsThatCanReach(this.m_data, this.m_target, GlobalCenter.CurrentPlayer, Matches.TerritoryIsLandOrWater);
        List<Unit> defenders = this.GetRecruitedUnitsAsUnitList();
        defenders.addAll(DUtils.GetUnitsGoingToBePlacedAtX(this.m_data, GlobalCenter.CurrentPlayer, this.m_target));
        if (!DSettings.LoadSettings().AA_ignoreAlliedUnitsAsDefenses) {
            defenders.removeAll(this.m_target.getUnits().getUnits());
            defenders.addAll(this.m_target.getUnits().getUnits());
        }
        AggregateResults simulatedAttack = DUtils.GetBattleResults(attackers, defenders, this.m_target, this.m_data, DSettings.LoadSettings().CA_CMNCM_determinesResponseResultsToSeeIfTaskWorthwhile, true);
        DUtils.Log(Level.FINEST, "        Enemy attack simulated. Attackers Size: {0} Defenders Size: {1} Takeover Chance: {2}", attackers.size(), defenders.size(), simulatedAttack.getAttackerWinPercent());
        if (this.m_taskType.equals((Object)NCM_TaskType.Land_Reinforce_Block)) {
            if (this.m_recruitedUnits.isEmpty()) {
                return false;
            }
            int unitCost = DUtils.GetTUVOfUnits(this.GetRecruitedUnitsAsUnitList(), GlobalCenter.GetPUResource());
            TerritoryAttachment ta = TerritoryAttachment.get(this.m_target);
            return ta.getProduction() >= unitCost - 1 || attackers.size() <= 0;
        }
        if (this.m_taskType.equals((Object)NCM_TaskType.Land_Reinforce_FrontLine)) {
            float howCloseToMeetingMinSurvivalChance = this.getMeetingOfMinSurvivalChanceScore(simulatedAttack, this.m_minSurvivalChance);
            if (StatusCenter.get((GameData)this.m_data, (PlayerID)player).GetStatusOfTerritory((Territory)this.m_target).WasAttacked_Stabalize || StatusCenter.get((GameData)this.m_data, (PlayerID)player).GetStatusOfTerritory((Territory)this.m_target).WasAttacked_Offensive) {
                howCloseToMeetingMinSurvivalChance = 9.98789f;
            }
            DUtils.Log(Level.FINEST, "        How close to meeting min survival chance: {0} Needed: {1}", Float.valueOf(howCloseToMeetingMinSurvivalChance), Float.valueOf(0.98f));
            if (howCloseToMeetingMinSurvivalChance < 0.98f) {
                int tradeScoreIfAttacked = -DUtils.GetTaskTradeScore(this.m_data, this.m_target, attackers, defenders, simulatedAttack, new ArrayList<Unit>(), new ArrayList<Unit>(), null);
                DUtils.Log(Level.FINEST, "        Trade score if attacked: {0} Required for bypass: {1}", tradeScoreIfAttacked, DSettings.LoadSettings().TR_reinforceFrontline_enemyAttackTradeScoreRequiredToBypassRequirements);
                return tradeScoreIfAttacked >= DSettings.LoadSettings().TR_reinforceFrontline_enemyAttackTradeScoreRequiredToBypassRequirements;
            }
            return true;
        }
        if (this.m_taskType.equals((Object)NCM_TaskType.Land_Reinforce_Stabilize)) {
            float howCloseToMeetingMinSurvivalChance = this.getMeetingOfMinSurvivalChanceScore(simulatedAttack, this.m_minSurvivalChance);
            DUtils.Log(Level.FINEST, "        How close to meeting min survival chance: {0} Needed: {1}", Float.valueOf(howCloseToMeetingMinSurvivalChance), Float.valueOf(0.98f));
            if (howCloseToMeetingMinSurvivalChance < 0.98f) {
                return false;
            }
            if (ourCaps.contains(this.m_target)) {
                DUtils.Log(Level.FINEST, "        This is our cap, we want to reinforce it, even though the requirements aren't met (this shouldn't happen)", new Object[0]);
                return true;
            }
            return true;
        }
        return false;
    }

    public boolean IsTaskWithAdditionalRecruitsWorthwhile() {
        DUtils.Log(Level.FINEST, "      Determining if ncm task with additional recruits is worthwhile. Target: {0} Recruits Size: {1}", this.m_target, this.m_recruitedUnits.size());
        if (this.m_recruitedUnits.isEmpty()) {
            return false;
        }
        PlayerID player = GlobalCenter.CurrentPlayer;
        List<Territory> ourCaps = DUtils.GetAllOurCaps(this.m_data, player);
        ArrayList<Territory> capsAndNeighbors = new ArrayList<Territory>();
        for (Territory cap : ourCaps) {
            capsAndNeighbors.addAll(DUtils.GetTerritoriesWithinXDistanceOfY(this.m_data, cap, 1));
        }
        HashSet capsAndNeighborsUnits = DUtils.ToHashSet(DUtils.GetUnitsInTerritories(capsAndNeighbors));
        boolean areRecruitsFromCapsOrNeighbors = false;
        for (Unit recruit : this.GetRecruitedUnitsAsUnitList()) {
            if (!capsAndNeighborsUnits.contains(recruit)) continue;
            areRecruitsFromCapsOrNeighbors = true;
            break;
        }
        if (areRecruitsFromCapsOrNeighbors && !ourCaps.contains(this.m_target)) {
            Territory ourClosestCap = DUtils.GetOurClosestCap(this.m_data, player, this.m_target);
            ThreatInvalidationCenter.get(this.m_data, player).SuspendThreatInvalidation();
            List<Float> capTakeoverChances = DUtils.GetTerTakeoverChanceBeforeAndAfterMove(this.m_data, player, ourClosestCap, this.m_target, this.GetRecruitedUnitsAsUnitList(), DSettings.LoadSettings().CA_CMNCM_determinesIfTaskEndangersCap);
            ThreatInvalidationCenter.get(this.m_data, player).ResumeThreatInvalidation();
            if (capTakeoverChances.get(1).floatValue() > 0.1f && (capTakeoverChances.get(1).floatValue() - capTakeoverChances.get(0).floatValue() > 0.01f || capTakeoverChances.get(3).floatValue() - capTakeoverChances.get(2).floatValue() > 1.0f)) {
                DUtils.Log(Level.FINEST, "      Performing task with additional recruits would endanger capital, so canceling.", new Object[0]);
                return false;
            }
        }
        return true;
    }

    public boolean IsDisqualified() {
        return this.m_disqualified;
    }

    public void Disqualify() {
        this.m_disqualified = true;
    }

    public void PerformTargetRetreat(List<NCM_Task> allTasks, IMoveDelegate mover) {
        DUtils.Log(Level.FINER, "      Attemping to perform target retreat for task. Target: {0} Recruits: {1}", this.m_target, DUtils.UnitGroupList_ToString(this.m_recruitedUnits));
        PlayerID player = GlobalCenter.CurrentPlayer;
        ArrayList<UnitGroup> retreatUnits = new ArrayList<UnitGroup>();
        retreatUnits.addAll(DUtils.CreateUnitGroupsForUnits(Match.getMatches(this.m_target.getUnits().getUnits(), DUtils.CompMatchAnd(Matches.unitIsOwnedBy(player), DMatches.UnitIsMoveableType, Matches.UnitIsNotAir)), this.m_target, this.m_data));
        if (retreatUnits.isEmpty()) {
            DUtils.Log(Level.FINER, "        No units to retreat for task. Target: {0}", this.m_target);
            return;
        }
        if (this.m_taskType.equals((Object)NCM_TaskType.Land_Reinforce_FrontLine)) {
            float score;
            AggregateResults results;
            List<Unit> defenders;
            List<Unit> possibleAttackers;
            Route ncmRoute;
            Territory bestRetreatTer = null;
            float bestRetreatTerScore = -2.1474836E9f;
            for (NCM_Task task : DUtils.ShuffleList(allTasks)) {
                if (!task.IsCompleted() || !task.GetTaskType().equals((Object)NCM_TaskType.Land_Reinforce_FrontLine) && !task.GetTaskType().equals((Object)NCM_TaskType.Land_Reinforce_Stabilize) || (ncmRoute = this.m_data.getMap().getLandRoute(this.m_target, task.GetTarget())) == null || !Match.allMatch(retreatUnits, DMatches.UnitGroupHasEnoughMovement_All(ncmRoute.getLength()))) continue;
                possibleAttackers = DUtils.GetSPNNEnemyUnitsThatCanReach(this.m_data, task.GetTarget(), GlobalCenter.CurrentPlayer, Matches.TerritoryIsLandOrWater);
                possibleAttackers = Match.getMatches(possibleAttackers, new CompositeMatchOr(Matches.UnitIsLand, Matches.UnitIsAir));
                defenders = DUtils.GetTerUnitsAtEndOfTurn(this.m_data, player, task.GetTarget());
                defenders.retainAll(TacticalCenter.get(this.m_data, player).GetFrozenUnits());
                defenders.removeAll(DUtils.ToUnitList(retreatUnits));
                defenders.addAll(DUtils.ToUnitList(retreatUnits));
                results = DUtils.GetBattleResults(possibleAttackers, defenders, task.GetTarget(), this.m_data, 500, true);
                score = 0.0f;
                score = (float)((double)score - results.getAttackerWinPercent());
                score -= DUtils.GetDefenseScoreOfUnits(results.GetAverageAttackingUnitsRemaining()) * 0.01f;
                if (!((score += DUtils.GetValueOfLandTer(task.GetTarget(), this.m_data, player)) > bestRetreatTerScore)) continue;
                bestRetreatTer = task.GetTarget();
                bestRetreatTerScore = score;
            }
            if (bestRetreatTer == null) {
                for (Territory ter : DUtils.ShuffleList(DUtils.GetTerritoriesWithinXDistanceOfY(this.m_data, this.m_target, GlobalCenter.FastestUnitMovement))) {
                    if (ter.isWater() || !DMatches.territoryIsOwnedByXOrAlly(this.m_data, GlobalCenter.CurrentPlayer).match(ter) || (ncmRoute = this.m_data.getMap().getLandRoute(this.m_target, ter)) == null || !Match.allMatch(retreatUnits, DMatches.UnitGroupHasEnoughMovement_All(ncmRoute.getLength()))) continue;
                    possibleAttackers = DUtils.GetSPNNEnemyUnitsThatCanReach_CountXAsPassthroughs(this.m_data, ter, GlobalCenter.CurrentPlayer, Matches.TerritoryIsLandOrWater, Collections.singletonList(this.m_target));
                    possibleAttackers = Match.getMatches(possibleAttackers, new CompositeMatchOr(Matches.UnitIsLand, Matches.UnitIsAir));
                    defenders = DUtils.GetTerUnitsAtEndOfTurn(this.m_data, player, ter);
                    defenders.retainAll(TacticalCenter.get(this.m_data, player).GetFrozenUnits());
                    defenders.removeAll(DUtils.ToUnitList(retreatUnits));
                    defenders.addAll(DUtils.ToUnitList(retreatUnits));
                    results = DUtils.GetBattleResults(possibleAttackers, defenders, ter, this.m_data, 500, true);
                    score = 0.0f;
                    score = (float)((double)score - results.getAttackerWinPercent() * 1000.0);
                    score -= (float)results.GetAverageAttackingUnitsRemaining().size();
                    score -= DUtils.GetDefenseScoreOfUnits(results.GetAverageAttackingUnitsRemaining());
                    if (!((score += DUtils.GetValueOfLandTer(ter, this.m_data, player)) > bestRetreatTerScore)) continue;
                    bestRetreatTer = ter;
                    bestRetreatTerScore = score;
                }
            }
            if (bestRetreatTer != null) {
                List<Territory> ourCaps = DUtils.GetAllOurCaps(this.m_data, player);
                ArrayList<Territory> capsNeighbors = new ArrayList<Territory>();
                for (Territory cap : ourCaps) {
                    capsNeighbors.addAll(DUtils.GetTerritoriesWithinXDistanceOfY(this.m_data, cap, 1));
                }
                capsNeighbors.removeAll(ourCaps);
                if (capsNeighbors.contains(this.m_target)) {
                    Territory ourClosestCap = DUtils.GetOurClosestCap(this.m_data, player, this.m_target);
                    ThreatInvalidationCenter.get(this.m_data, player).SuspendThreatInvalidation();
                    List<Float> capTakeoverChances = DUtils.GetTerTakeoverChanceBeforeAndAfterMove(this.m_data, player, ourClosestCap, this.m_target, this.GetRecruitedUnitsAsUnitList(), DSettings.LoadSettings().CA_CMNCM_determinesIfTaskEndangersCap);
                    ThreatInvalidationCenter.get(this.m_data, player).ResumeThreatInvalidation();
                    if (capTakeoverChances.get(1).floatValue() > 0.1f && (capTakeoverChances.get(1).floatValue() - capTakeoverChances.get(0).floatValue() > 0.01f || capTakeoverChances.get(3).floatValue() - capTakeoverChances.get(2).floatValue() > 1.0f)) {
                        DUtils.Log(Level.FINEST, "      Retreating units would endanger capital, so leaving one behind.", new Object[0]);
                        UnitGroup cheapestUG = null;
                        int cheapestCost = Integer.MAX_VALUE;
                        for (UnitGroup ug : retreatUnits) {
                            int cost = DUtils.GetTUVOfUnit(ug.GetFirstUnit(), GlobalCenter.GetPUResource());
                            if (cost >= cheapestCost) continue;
                            cheapestUG = ug;
                            cheapestCost = cost;
                        }
                        retreatUnits.remove(cheapestUG);
                    }
                }
                DUtils.Log(Level.FINER, "      Attempting to perform target retreat. Target: {0} Retreat To: {1} Retreat Units: {2}", this.m_target, bestRetreatTer, DUtils.UnitGroupList_ToString(retreatUnits));
                Dynamix_AI.Pause();
                UnitGroup.EnableMoveBuffering();
                for (UnitGroup ug : retreatUnits) {
                    String error = ug.MoveAsFarTo_NCM(bestRetreatTer, mover);
                    if (error == null) {
                        TacticalCenter.get(this.m_data, GlobalCenter.CurrentPlayer).FreezeUnits(ug.GetUnitsAsList());
                        continue;
                    }
                    DUtils.Log(Level.FINER, "        NCM move failed, reason: {0}", error);
                }
                String errors = UnitGroup.PerformBufferedMovesAndDisableMoveBufferring(mover);
                if (errors != null) {
                    DUtils.Log(Level.FINER, "      Some errors occurred while performing moves: {0}", errors);
                }
            } else {
                DUtils.Log(Level.FINER, "      No retreat to ter found for for task. Target: {0} Recruits: {1} Retreat Units: {2}", this.m_target, this.m_recruitedUnits, DUtils.UnitGroupList_ToString(retreatUnits));
            }
        } else if (this.m_taskType.equals((Object)NCM_TaskType.Land_Reinforce_Stabilize)) {
            Territory bestRetreatTer = null;
            float bestRetreatTerScore = -2.1474836E9f;
            List<Territory> ourCaps = DUtils.GetAllOurCaps(this.m_data, player);
            ArrayList<Territory> capsAndNeighbors = new ArrayList<Territory>();
            for (Territory cap : ourCaps) {
                capsAndNeighbors.addAll(DUtils.GetTerritoriesWithinXDistanceOfY(this.m_data, cap, 1));
            }
            if (capsAndNeighbors.contains(this.m_target)) {
                bestRetreatTer = DUtils.GetOurClosestCap(this.m_data, player, this.m_target);
            }
            if (bestRetreatTer == null) {
                for (Territory ter : DUtils.ShuffleList(DUtils.GetTerritoriesWithinXDistanceOfY(this.m_data, this.m_target, GlobalCenter.FastestUnitMovement))) {
                    Route ncmRoute;
                    if (ter.isWater() || !DMatches.territoryIsOwnedByXOrAlly(this.m_data, GlobalCenter.CurrentPlayer).match(ter) || (ncmRoute = CachedCalculationCenter.GetPassableLandRoute(this.m_data, this.m_target, ter)) == null || !Match.allMatch(retreatUnits, DMatches.UnitGroupHasEnoughMovement_All(ncmRoute.getLength()))) continue;
                    List<Unit> possibleAttackers = DUtils.GetSPNNEnemyUnitsThatCanReach_CountXAsPassthroughs(this.m_data, ter, GlobalCenter.CurrentPlayer, Matches.TerritoryIsLandOrWater, Collections.singletonList(this.m_target));
                    possibleAttackers = Match.getMatches(possibleAttackers, new CompositeMatchOr(Matches.UnitIsLand, Matches.UnitIsAir));
                    List<Unit> defenders = DUtils.GetTerUnitsAtEndOfTurn(this.m_data, player, ter);
                    defenders.retainAll(TacticalCenter.get(this.m_data, player).GetFrozenUnits());
                    defenders.removeAll(DUtils.ToUnitList(retreatUnits));
                    defenders.addAll(DUtils.ToUnitList(retreatUnits));
                    AggregateResults results = DUtils.GetBattleResults(possibleAttackers, defenders, ter, this.m_data, 500, true);
                    float score = 0.0f;
                    score = (float)((double)score - results.getAttackerWinPercent() * 1000.0);
                    score -= (float)results.GetAverageAttackingUnitsRemaining().size();
                    score -= DUtils.GetDefenseScoreOfUnits(results.GetAverageAttackingUnitsRemaining());
                    if (!((score += DUtils.GetValueOfLandTer(ter, this.m_data, player)) > bestRetreatTerScore)) continue;
                    bestRetreatTer = ter;
                    bestRetreatTerScore = score;
                }
            }
            if (bestRetreatTer != null) {
                ArrayList<Territory> capsNeighbors = new ArrayList<Territory>();
                for (Territory cap : ourCaps) {
                    capsNeighbors.addAll(DUtils.GetTerritoriesWithinXDistanceOfY(this.m_data, cap, 1));
                }
                capsNeighbors.removeAll(ourCaps);
                if (capsNeighbors.contains(this.m_target)) {
                    Territory ourClosestCap = DUtils.GetOurClosestCap(this.m_data, player, this.m_target);
                    ThreatInvalidationCenter.get(this.m_data, player).SuspendThreatInvalidation();
                    List<Float> capTakeoverChances = DUtils.GetTerTakeoverChanceBeforeAndAfterMove(this.m_data, player, ourClosestCap, this.m_target, this.GetRecruitedUnitsAsUnitList(), DSettings.LoadSettings().CA_CMNCM_determinesIfTaskEndangersCap);
                    ThreatInvalidationCenter.get(this.m_data, player).ResumeThreatInvalidation();
                    if (capTakeoverChances.get(1).floatValue() > 0.1f && (capTakeoverChances.get(1).floatValue() - capTakeoverChances.get(0).floatValue() > 0.01f || capTakeoverChances.get(3).floatValue() - capTakeoverChances.get(2).floatValue() > 1.0f)) {
                        DUtils.Log(Level.FINEST, "      Retreating units would endanger capital, so leaving one behind.", new Object[0]);
                        UnitGroup cheapestUG = null;
                        int cheapestCost = Integer.MAX_VALUE;
                        for (UnitGroup ug : retreatUnits) {
                            int cost = DUtils.GetTUVOfUnit(ug.GetFirstUnit(), GlobalCenter.GetPUResource());
                            if (cost >= cheapestCost) continue;
                            cheapestUG = ug;
                            cheapestCost = cost;
                        }
                        retreatUnits.remove(cheapestUG);
                    }
                }
                DUtils.Log(Level.FINER, "      Attempting to perform target retreat. Target: {0} Retreat To: {1} Retreat Units: {2}", this.m_target, bestRetreatTer, DUtils.UnitGroupList_ToString(retreatUnits));
                Dynamix_AI.Pause();
                UnitGroup.EnableMoveBuffering();
                for (UnitGroup ug : retreatUnits) {
                    String error = ug.MoveAsFarTo_NCM(bestRetreatTer, mover);
                    if (error == null) {
                        TacticalCenter.get(this.m_data, GlobalCenter.CurrentPlayer).FreezeUnits(ug.GetUnitsAsList());
                        continue;
                    }
                    DUtils.Log(Level.FINEST, "        NCM move failed, reason: {0}", error);
                }
                String errors = UnitGroup.PerformBufferedMovesAndDisableMoveBufferring(mover);
                if (errors != null) {
                    DUtils.Log(Level.FINER, "      Some errors occurred while performing moves: {0}", errors);
                }
            } else {
                DUtils.Log(Level.FINER, "      No retreat to ter found for for task. Target: {0} Recruits: {1} Retreat Units: {2}", this.m_target, this.m_recruitedUnits, DUtils.UnitGroupList_ToString(retreatUnits));
            }
        }
    }

    public void InvalidateThreatsThisTaskResists() {
        PlayerID player = GlobalCenter.CurrentPlayer;
        List<Territory> ourCaps = DUtils.GetAllOurCaps(this.m_data, player);
        if (ourCaps.contains(this.m_target)) {
            return;
        }
        if (this.m_target.getUnits().getMatches(Matches.UnitCanProduceUnits).size() > 0) {
            return;
        }
        if (this.m_taskType == NCM_TaskType.Land_Reinforce_FrontLine) {
            List<Unit> threats = DUtils.GetSPNNEnemyUnitsThatCanReach(this.m_data, this.m_target, GlobalCenter.CurrentPlayer, Matches.TerritoryIsLandOrWater);
            if (threats.isEmpty()) {
                return;
            }
            List<Unit> defenders = this.GetRecruitedUnitsAsUnitList();
            AggregateResults simulatedAttack = DUtils.GetBattleResults(threats, defenders, this.m_target, this.m_data, DSettings.LoadSettings().CA_CMNCM_determinesSurvivalChanceAfterTaskToSeeIfToInvalidateAttackers, true);
            if (simulatedAttack.getDefenderWinPercent() > (double)0.4f) {
                ThreatInvalidationCenter.get(this.m_data, player).InvalidateThreats(threats, this.m_target);
            }
        } else if (this.m_taskType == NCM_TaskType.Land_Reinforce_Stabilize) {
            List<Unit> threats = DUtils.GetSPNNEnemyUnitsThatCanReach(this.m_data, this.m_target, GlobalCenter.CurrentPlayer, Matches.TerritoryIsLandOrWater);
            if (threats.isEmpty()) {
                return;
            }
            List<Unit> defenders = this.GetRecruitedUnitsAsUnitList();
            AggregateResults simulatedAttack = DUtils.GetBattleResults(threats, defenders, this.m_target, this.m_data, DSettings.LoadSettings().CA_CMNCM_determinesSurvivalChanceAfterTaskToSeeIfToInvalidateAttackers, true);
            if (simulatedAttack.getDefenderWinPercent() > (double)0.4f) {
                ThreatInvalidationCenter.get(this.m_data, player).InvalidateThreats(threats, this.m_target);
            }
        }
    }

    public void Reset() {
        DUtils.Log(Level.FINER, "        Resetting task. Target: {0} Task Type: {1} Priority: {2} Recruit Size: {3}", new Object[]{this.m_target, this.m_taskType, Float.valueOf(this.m_priority), this.m_recruitedUnits.size()});
        this.m_completed = false;
        this.m_disqualified = false;
        this.m_recruitedUnits = new ArrayList<UnitGroup>();
    }

    public boolean IsCompleted() {
        return this.m_completed;
    }

    public void PerformTask(IMoveDelegate mover) {
        String errors;
        if (this.m_recruitedUnits.isEmpty()) {
            DUtils.Log(Level.FINER, "      Task is called to perform, but there are no recruits! Target: {0} Task Type: {1} Priority: {2}", new Object[]{this.m_target, this.m_taskType, Float.valueOf(this.m_priority)});
            this.m_completed = true;
            return;
        }
        UnitGroup.EnableMoveBuffering();
        boolean anythingMoved = false;
        for (UnitGroup ug : this.m_recruitedUnits) {
            if (ug.GetMovedTo() != null) continue;
            String error = ug.MoveAsFarTo_NCM(this.m_target, mover);
            if (error != null) {
                DUtils.Log(Level.FINER, "        NCM task perfoming move failed, reason: {0}", error);
                continue;
            }
            TacticalCenter.get(this.m_data, GlobalCenter.CurrentPlayer).FreezeUnits(ug.GetUnitsAsList());
            anythingMoved = true;
        }
        if (!anythingMoved) {
            this.m_disqualified = true;
            return;
        }
        if (!this.m_completed) {
            Dynamix_AI.Pause();
        }
        if ((errors = UnitGroup.PerformBufferedMovesAndDisableMoveBufferring(mover)) != null) {
            DUtils.Log(Level.FINER, "      Some errors occurred while performing moves: {0}", errors);
            this.m_disqualified = true;
            return;
        }
        ReconsiderSignalCenter.get((GameData)this.m_data, (PlayerID)GlobalCenter.CurrentPlayer).ObjectsToReconsider.addAll(CachedInstanceCenter.CachedGameData.getMap().getNeighbors(this.m_target));
        this.m_completed = true;
        StatusCenter.get(this.m_data, GlobalCenter.CurrentPlayer).GetStatusOfTerritory(this.m_target).NotifyTaskPerform(this);
    }
}

