/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.triplea.ai.strongAI;

import games.strategy.engine.data.GameData;
import games.strategy.engine.data.PlayerID;
import games.strategy.engine.data.ProductionRule;
import games.strategy.engine.data.Resource;
import games.strategy.engine.data.Route;
import games.strategy.engine.data.Territory;
import games.strategy.engine.data.Unit;
import games.strategy.engine.data.UnitType;
import games.strategy.triplea.Properties;
import games.strategy.triplea.TripleAUnit;
import games.strategy.triplea.ai.strongAI.StrongAI;
import games.strategy.triplea.attatchments.TerritoryAttachment;
import games.strategy.triplea.attatchments.UnitAttachment;
import games.strategy.triplea.delegate.BattleCalculator;
import games.strategy.triplea.delegate.BattleDelegate;
import games.strategy.triplea.delegate.DelegateFinder;
import games.strategy.triplea.delegate.Matches;
import games.strategy.triplea.delegate.MoveValidator;
import games.strategy.triplea.delegate.TransportTracker;
import games.strategy.util.CompositeMatch;
import games.strategy.util.CompositeMatchAnd;
import games.strategy.util.CompositeMatchOr;
import games.strategy.util.IntegerMap;
import games.strategy.util.InverseMatch;
import games.strategy.util.Match;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SUtils {
    private static final int PURCHASE_LOOP_MAX_TIME_MILLIS = 150000;
    private static final Logger s_logger = Logger.getLogger(StrongAI.class.getName());
    public static final List<Territory> EMPTY_LIST = Collections.unmodifiableList(new ArrayList());

    public static boolean threatToAlliedCapitals(GameData data, PlayerID player, List<Territory> threats, boolean tFirst) {
        ArrayList<Territory> alliedCapitols = new ArrayList<Territory>();
        for (PlayerID otherPlayer : data.getPlayerList().getPlayers()) {
            Territory capitol;
            if (otherPlayer == player || (capitol = TerritoryAttachment.getCapital(otherPlayer, data)) == null || !data.getRelationshipTracker().isAllied(player, capitol.getOwner())) continue;
            alliedCapitols.add(capitol);
        }
        for (Territory cap : alliedCapitols) {
            float landThreat = SUtils.getStrengthOfPotentialAttackers(cap, data, player, tFirst, true, null);
            float capStrength = SUtils.strength(cap.getUnits().getMatches(Matches.alliedUnit(player, data)), false, false, tFirst) + 5.0f;
            if (!(capStrength * 1.05f < landThreat)) continue;
            threats.add(cap);
        }
        return threats.size() > 0;
    }

    public static List<Territory> stripLandLockedTerr(GameData data, List<Territory> allTerr) {
        ArrayList<Territory> waterTerrs = new ArrayList<Territory>(allTerr);
        Iterator wFIter = waterTerrs.iterator();
        while (wFIter.hasNext()) {
            Territory waterFact = (Territory)wFIter.next();
            if (!Matches.territoryHasWaterNeighbor(data).invert().match(waterFact)) continue;
            wFIter.remove();
        }
        return waterTerrs;
    }

    public static List<Territory> onlyWaterTerr(GameData data, List<Territory> allTerr) {
        ArrayList<Territory> water = new ArrayList<Territory>(allTerr);
        Iterator wFIter = water.iterator();
        while (wFIter.hasNext()) {
            Territory waterFact = (Territory)wFIter.next();
            if (Matches.TerritoryIsWater.match(waterFact)) continue;
            wFIter.remove();
        }
        return water;
    }

    public static Collection<Territory> bomberTerrInList(List<Collection<Unit>> units, List<Route> routes) {
        ArrayList<Territory> bTerrs = new ArrayList<Territory>();
        for (int i = 0; i < units.size(); ++i) {
            Collection<Unit> checkUnits = units.get(i);
            Route checkRoute = routes.get(i);
            if (checkRoute == null || checkRoute.getEnd() == null) continue;
            Territory endTerr = checkRoute.getEnd();
            if (!Match.someMatch(checkUnits, Matches.UnitIsStrategicBomber)) continue;
            bTerrs.add(endTerr);
        }
        return bTerrs;
    }

    public static Territory landAttackMap(GameData data, PlayerID player, HashMap<Territory, Float> enemyMap) {
        Territory largestTerr = null;
        List<Territory> enemyTerrs = SUtils.allEnemyTerritories(data, player);
        if (enemyTerrs.isEmpty()) {
            return null;
        }
        Iterator<Territory> eTIter = enemyTerrs.iterator();
        while (eTIter.hasNext()) {
            Territory eTerr = eTIter.next();
            if (Matches.TerritoryIsWater.match(eTerr) || Matches.TerritoryIsImpassable.match(eTerr)) {
                eTIter.remove();
                continue;
            }
            float eStrength = SUtils.strength(eTerr.getUnits().getMatches(Matches.enemyUnit(player, data)), true, false, true);
            enemyMap.put(eTerr, Float.valueOf(eStrength));
        }
        SUtils.reorder(enemyTerrs, enemyMap, true);
        if (enemyTerrs.isEmpty()) {
            return null;
        }
        largestTerr = enemyTerrs.get(0);
        return largestTerr;
    }

    public static Match<Territory> TerritoryIsImpassableToAirUnits(GameData data) {
        return new Match<Territory>(){

            @Override
            public boolean match(Territory t) {
                return Matches.TerritoryIsLand.match(t) && Matches.TerritoryIsImpassable.match(t);
            }
        };
    }

    public static final Match<Territory> TerritoryIsNotImpassableToAirUnits(GameData data) {
        return new InverseMatch<Territory>(SUtils.TerritoryIsImpassableToAirUnits(data));
    }

    public static void continentAlliedUnitTerr(GameData data, PlayerID player, Territory startTerr, List<Territory> contiguousTerr, List<Territory> ignoreTerr) {
        Set<Territory> neighbor1 = data.getMap().getNeighbors(startTerr, Matches.TerritoryIsNotImpassableToLandUnits(player, data));
        neighbor1.removeAll(contiguousTerr);
        neighbor1.removeAll(ignoreTerr);
        for (Territory n1 : neighbor1) {
            if (Matches.isTerritoryAllied(player, data).match(n1)) {
                contiguousTerr.add(n1);
            } else {
                ignoreTerr.add(n1);
            }
            SUtils.continentAlliedUnitTerr(data, player, n1, contiguousTerr, ignoreTerr);
        }
        if (!contiguousTerr.contains(startTerr) && !ignoreTerr.contains(startTerr)) {
            contiguousTerr.add(startTerr);
        }
    }

    public static float strengthOnContinent(GameData data, PlayerID player, Territory continentTerr) {
        boolean island;
        float continentStrength = 0.0f;
        boolean bl = island = !SUtils.doesLandExistAt(continentTerr, data, false);
        if (island) {
            if (Matches.isTerritoryAllied(player, data).match(continentTerr)) {
                continentStrength += SUtils.strength(continentTerr.getUnits().getMatches(Matches.alliedUnit(player, data)), true, false, false);
                continentStrength += 5.0f;
            }
            return continentStrength;
        }
        ArrayList<Territory> allContinentTerr = new ArrayList<Territory>();
        ArrayList<Territory> ignoreTerr = new ArrayList<Territory>();
        SUtils.continentAlliedUnitTerr(data, player, continentTerr, allContinentTerr, ignoreTerr);
        for (Territory cTerr : allContinentTerr) {
            continentStrength += SUtils.strength(cTerr.getUnits().getMatches(Matches.alliedUnit(player, data)), true, false, false);
        }
        return continentStrength;
    }

    public static void removeUnthreatenedTerritories(GameData data, PlayerID player, List<Territory> terrList) {
        Iterator<Territory> tIter = terrList.iterator();
        while (tIter.hasNext()) {
            Territory checkTerr = tIter.next();
            if (Matches.isTerritoryEnemy(player, data).match(checkTerr)) {
                tIter.remove();
                continue;
            }
            float eStrength = SUtils.getStrengthOfPotentialAttackers(checkTerr, data, player, false, false, null);
            if (eStrength != 0.0f || !Matches.territoryHasEnemyLandNeighbor(data, player).invert().match(checkTerr)) continue;
            tIter.remove();
        }
    }

    public static void breakUnitsBySpeed(List<Collection<Unit>> returnUnits, GameData data, PlayerID player, List<Unit> units) {
        if (units.isEmpty()) {
            return;
        }
        int maxSpeed = MoveValidator.getMaxMovement(units);
        ArrayList<Unit> copyOfUnits = new ArrayList<Unit>(units);
        for (int i = maxSpeed; i >= 0; --i) {
            ArrayList<Unit> newUnits = new ArrayList<Unit>();
            Iterator unitIter = copyOfUnits.iterator();
            while (unitIter.hasNext()) {
                Unit unit1 = (Unit)unitIter.next();
                if (!MoveValidator.hasEnoughMovement(unit1, i)) continue;
                newUnits.add(unit1);
                unitIter.remove();
            }
            if (newUnits.isEmpty()) continue;
            returnUnits.add(newUnits);
        }
    }

    public static IntegerMap<Territory> targetTerritories(GameData data, PlayerID player, int tDistance) {
        CompositeMatchAnd<Unit> enemyFactory = new CompositeMatchAnd<Unit>(Matches.enemyUnit(player, data), Matches.UnitCanProduceUnits);
        List<Territory> playerFactories = SUtils.findUnitTerr(data, player, enemyFactory);
        IntegerMap<Territory> targetMap = new IntegerMap<Territory>();
        int checkDist = tDistance - 1;
        for (Territory mT : playerFactories) {
            Set<Territory> initialGroup = data.getMap().getNeighbors(mT, tDistance);
            for (Territory checkTerr : initialGroup) {
                int cDist;
                if (!Matches.isTerritoryEnemy(player, data).match(checkTerr) || !Matches.TerritoryIsLand.match(checkTerr) || !Matches.TerritoryIsNotImpassable.match(checkTerr) || (cDist = data.getMap().getDistance(mT, checkTerr)) >= checkDist && (cDist < checkDist || SUtils.doesLandExistAt(checkTerr, data, false))) continue;
                int terrProduction = TerritoryAttachment.get(checkTerr).getProduction();
                targetMap.put(checkTerr, terrProduction);
            }
        }
        return targetMap;
    }

    public static List<Unit> sortTransportUnits(List<Unit> transUnits) {
        ArrayList<Unit> sorted = new ArrayList<Unit>();
        ArrayList<Unit> infantry = new ArrayList<Unit>();
        ArrayList<Unit> artillery = new ArrayList<Unit>();
        ArrayList<Unit> armor = new ArrayList<Unit>();
        ArrayList<Unit> others = new ArrayList<Unit>();
        for (Unit x : transUnits) {
            if (Matches.UnitIsArtillerySupportable.match(x)) {
                infantry.add(x);
                continue;
            }
            if (Matches.UnitIsArtillery.match(x)) {
                artillery.add(x);
                continue;
            }
            if (Matches.UnitCanBlitz.match(x)) {
                armor.add(x);
                continue;
            }
            others.add(x);
        }
        int artilleryCount = artillery.size();
        int armorCount = armor.size();
        int infCount = infantry.size();
        int othersCount = others.size();
        for (int j = 0; j < infCount; ++j) {
            sorted.add((Unit)infantry.get(j));
            if (armorCount > 0) {
                sorted.add((Unit)armor.get(armorCount - 1));
                --armorCount;
                continue;
            }
            if (artilleryCount > 0) {
                sorted.add((Unit)artillery.get(artilleryCount - 1));
                --artilleryCount;
                continue;
            }
            if (othersCount <= 0) continue;
            sorted.add((Unit)others.get(othersCount - 1));
            --othersCount;
        }
        if (artilleryCount > 0) {
            for (int j2 = 0; j2 < artilleryCount; ++j2) {
                sorted.add((Unit)artillery.get(j2));
            }
        }
        if (othersCount > 0) {
            for (int j4 = 0; j4 < othersCount; ++j4) {
                sorted.add((Unit)others.get(j4));
            }
        }
        if (armorCount > 0) {
            for (int j3 = 0; j3 < armorCount; ++j3) {
                sorted.add((Unit)armor.get(j3));
            }
        }
        return sorted;
    }

    public static HashMap<PlayerID, IntegerMap<UnitType>> getPlayerCostMap(GameData data) {
        HashMap<PlayerID, IntegerMap<UnitType>> costMap = new HashMap<PlayerID, IntegerMap<UnitType>>();
        Collection<PlayerID> playerList = data.getPlayerList().getPlayers();
        for (PlayerID cPlayer : playerList) {
            IntegerMap<UnitType> playerCostMap = BattleCalculator.getCostsForTUV(cPlayer, data);
            costMap.put(cPlayer, playerCostMap);
        }
        return costMap;
    }

    public static void trimTerritoryList(List<Territory> xTerrList, int maxNum) {
        int totNum = xTerrList.size();
        if (maxNum >= totNum) {
            return;
        }
        Iterator<Territory> xIter = xTerrList.iterator();
        int maxCount = 0;
        while (xIter.hasNext()) {
            if (maxCount > maxNum) {
                xIter.remove();
            }
            ++maxCount;
        }
    }

    public static Route TrimRoute_BeforeFirstTerWithEnemyUnits(Route route, int newRouteJumpCount, PlayerID player, GameData data) {
        ArrayList<Territory> newTers = new ArrayList<Territory>();
        int i = 0;
        for (Territory ter : route.getTerritories()) {
            if (ter.getUnits().getMatches(new CompositeMatchAnd<Unit>(Matches.unitHasDefenseThatIsMoreThanOrEqualTo(1), Matches.unitIsEnemyOf(data, player))).size() > 0) break;
            newTers.add(ter);
            if (++i <= newRouteJumpCount) continue;
            break;
        }
        return new Route(newTers);
    }

    public static int evaluateNonCombat(int numMoves, int evalDistance, HashMap<Integer, HashMap<Territory, Float>> reinforcedTerrList, HashMap<Integer, IntegerMap<Territory>> unitCountList, PlayerID player, GameData data, boolean tFirst) {
        if (evalDistance > 10) {
            return -1;
        }
        CompositeMatchAnd<Unit> enemyFactory = new CompositeMatchAnd<Unit>(Matches.UnitCanProduceUnits, Matches.enemyUnit(player, data));
        int bestFit = -1;
        float maxScore = 0.0f;
        List<Territory> enemyCaps = SUtils.getEnemyCapitals(data, player);
        List<Territory> enemyFactories = SUtils.findUnitTerr(data, player, enemyFactory);
        List<Territory> allEnemyTerr = SUtils.allEnemyTerritories(data, player);
        IntegerMap<Territory> productionMap = new IntegerMap<Territory>();
        for (Territory enemy : allEnemyTerr) {
            int prodValue = TerritoryAttachment.get(enemy).getProduction();
            if (enemyCaps.contains(enemy)) {
                ++prodValue;
            }
            if (enemyFactories.contains(enemy)) {
                ++prodValue;
            }
            productionMap.put(enemy, ++prodValue);
        }
        Set<Integer> keySet = reinforcedTerrList.keySet();
        s_logger.fine("Moves Available for: " + keySet);
        Integer i = 0;
        while (i <= numMoves - 1) {
            HashMap<Territory, Float> reinforcedTerr = reinforcedTerrList.get(i);
            Set<Territory> goTerr = reinforcedTerr.keySet();
            float score = 0.0f;
            for (Territory eTerr : allEnemyTerr) {
                ArrayList<Territory> eNeighbors = new ArrayList<Territory>();
                for (int j = evalDistance; j > 0; --j) {
                    eNeighbors.addAll(SUtils.getExactNeighbors(eTerr, j, player, data, false));
                    for (Territory eN : eNeighbors) {
                        if (!goTerr.contains(eN)) continue;
                        score = (float)((double)score + (double)reinforcedTerr.get(eN).floatValue() * (1.0 - (double)(j - 1) * 0.2) * (double)productionMap.getInt(eTerr));
                    }
                    eNeighbors.clear();
                }
            }
            if (score > maxScore) {
                maxScore = score;
                bestFit = i;
            }
            Integer n = i;
            Integer n2 = i = Integer.valueOf(i + 1);
        }
        return bestFit;
    }

    public static IntegerMap<PlayerID> getPlayerTUV(GameData data) {
        Collection<PlayerID> playerList = data.getPlayerList().getPlayers();
        IntegerMap<PlayerID> TUVMap = new IntegerMap<PlayerID>();
        for (PlayerID qSet : playerList) {
            TUVMap.put(qSet, 0);
        }
        HashMap<PlayerID, IntegerMap<UnitType>> costMap = SUtils.getPlayerCostMap(data);
        for (Territory allTerr : data.getMap().getTerritories()) {
            for (PlayerID onePlayer : playerList) {
                CompositeMatchAnd<Unit> nonSeaUnit = new CompositeMatchAnd<Unit>(Matches.unitIsOwnedBy(onePlayer), Matches.UnitIsNotSea);
                List<Unit> playerUnits = allTerr.getUnits().getMatches(nonSeaUnit);
                IntegerMap<UnitType> uMap = SUtils.convertListToMap(playerUnits);
                int tuv = TUVMap.getInt(onePlayer);
                TUVMap.put(onePlayer, tuv += SUtils.determineTUV(uMap, costMap.get(onePlayer)));
            }
        }
        return TUVMap;
    }

    public static Collection<Territory> islandCapitalTerritories(Territory startTerr, Territory targetTerr, GameData data) {
        ArrayList<Territory> goTerrs = new ArrayList<Territory>();
        int maxDistance = data.getMap().getDistance(startTerr, targetTerr) + 1;
        Set<Territory> allTerrs = data.getMap().getNeighbors(targetTerr, 5);
        for (Territory xTerr : allTerrs) {
            int xDistance = data.getMap().getDistance(startTerr, xTerr);
            if (!Matches.TerritoryIsLand.match(xTerr) || !Matches.TerritoryIsNotImpassable.match(xTerr) || xDistance > maxDistance) continue;
            goTerrs.add(xTerr);
        }
        return goTerrs;
    }

    public static Territory closestAmphibAlliedTerritory(Territory startTerr, Territory targetTerr, List<Territory> contiguousTerritories, GameData data, PlayerID player, boolean tFirst) {
        ArrayList<Territory> ignoreTerr = new ArrayList<Territory>();
        SUtils.continentAlliedUnitTerr(data, player, targetTerr, contiguousTerritories, ignoreTerr);
        if (contiguousTerritories.isEmpty()) {
            s_logger.fine("Player: " + player.getName() + "; Territory must be an island: " + targetTerr.getName());
            return null;
        }
        IntegerMap<Territory> unitMap = new IntegerMap<Territory>();
        IntegerMap<Territory> distanceMap = new IntegerMap<Territory>();
        Iterator<Territory> cIter = contiguousTerritories.iterator();
        while (cIter.hasNext()) {
            Territory checkTerr = cIter.next();
            if (Matches.territoryHasWaterNeighbor(data).match(checkTerr)) {
                int checkDist = data.getMap().getDistance(startTerr, checkTerr) + data.getMap().getLandDistance(checkTerr, targetTerr);
                int unitCount = checkTerr.getUnits().countMatches(Matches.alliedUnit(player, data));
                unitMap.put(checkTerr, unitCount);
                distanceMap.put(checkTerr, checkDist);
                continue;
            }
            cIter.remove();
        }
        SUtils.reorder(contiguousTerritories, distanceMap, false);
        SUtils.trimTerritoryList(contiguousTerritories, 3);
        boolean isWaterNeighbor = false;
        Territory goTerr = null;
        Iterator<Territory> checkIter = contiguousTerritories.iterator();
        while (checkIter.hasNext() && !isWaterNeighbor) {
            Territory checkTerr2 = checkIter.next();
            Set<Territory> waterNeighbors = data.getMap().getNeighbors(checkTerr2, Matches.TerritoryIsWater);
            isWaterNeighbor = waterNeighbors.contains(startTerr);
            if (!isWaterNeighbor) continue;
            goTerr = checkTerr2;
        }
        if (goTerr == null) {
            SUtils.reorder(contiguousTerritories, unitMap, true);
            if (!contiguousTerritories.isEmpty()) {
                goTerr = contiguousTerritories.get(0);
            }
        }
        return goTerr;
    }

    public static Territory closestEnemyCapital(Territory startTerr, GameData data, PlayerID player) {
        List<Territory> eCapitols = SUtils.getEnemyCapitals(data, player);
        int maxDistance = 100;
        Territory goCap = null;
        if (eCapitols.isEmpty()) {
            return goCap;
        }
        for (Territory eCap : eCapitols) {
            int newDist = data.getMap().getDistance(startTerr, eCap);
            if (newDist > maxDistance) continue;
            goCap = eCap;
            maxDistance = newDist;
        }
        return goCap;
    }

    public static boolean calculateTUVDifference(Territory eTerr, Collection<Unit> invasionUnits, Collection<Unit> defenderUnits, HashMap<PlayerID, IntegerMap<UnitType>> costMap, PlayerID player, GameData data, boolean aggressive, boolean subRestricted, boolean tFirst) {
        int evaluationFactor = -5;
        if (aggressive) {
            evaluationFactor = -2;
        }
        IntegerMap<UnitType> myCostMap = costMap.get(player);
        PlayerID ePlayer = eTerr.getOwner();
        IntegerMap<UnitType> playerCostMap = costMap.get(ePlayer);
        int eTUV = Matches.TerritoryIsNeutralButNotWater.match(eTerr) ? 0 : BattleCalculator.getTUV(defenderUnits, ePlayer, playerCostMap, data);
        int myTUV = BattleCalculator.getTUV(invasionUnits, myCostMap);
        IntegerMap<UnitType> myAttackUnits = SUtils.convertListToMap(invasionUnits);
        IntegerMap<UnitType> defenseUnits = SUtils.convertListToMap(defenderUnits);
        s_logger.fine("Territory: " + eTerr.getName() + "; myTUV: " + myTUV + "; EnemyTUV: " + eTUV);
        boolean weWin = SUtils.quickBattleEstimator(myAttackUnits, defenseUnits, player, ePlayer, false, subRestricted);
        int myNewTUV = SUtils.determineTUV(myAttackUnits, myCostMap);
        IntegerMap<UnitType> eCostMap = costMap.get(ePlayer);
        int eNewTUV = Matches.TerritoryIsNeutralButNotWater.match(eTerr) ? 0 : SUtils.determineTUV(defenseUnits, eCostMap);
        int production = TerritoryAttachment.get(eTerr).getProduction();
        if (Matches.TerritoryIsNeutralButNotWater.match(eTerr)) {
            production *= 3;
        }
        int myTUVLost = myTUV - myNewTUV - (weWin ? production : 0);
        int eTUVLost = eTUV - eNewTUV;
        s_logger.fine("Territory: " + eTerr.getName() + "; myTUV: " + myNewTUV + "; EnemyTUV: " + eNewTUV + "; My TUV Lost: " + myTUVLost + "; Enemy TUV Lost: " + eTUVLost);
        s_logger.fine("Aggressive: " + aggressive + "; Evaluation Factor: " + evaluationFactor);
        if (weWin && (eTUV == 0 || SUtils.strength(defenderUnits, false, eTerr.isWater(), tFirst) * 5.0f + 10.0f < SUtils.strength(invasionUnits, true, eTerr.isWater(), tFirst))) {
            return true;
        }
        if (weWin && myTUVLost <= eTUVLost + (7 + evaluationFactor)) {
            return true;
        }
        return myTUVLost < eTUVLost + evaluationFactor;
    }

    public static int determineTUV(IntegerMap<UnitType> unitList, IntegerMap<UnitType> unitCost) {
        int totalValue = 0;
        Set<UnitType> uTypes = unitList.keySet();
        for (UnitType uType : uTypes) {
            totalValue += unitList.getInt(uType) * unitCost.getInt(uType);
        }
        return totalValue;
    }

    public static List<Territory> getNeighboringEnemyLandTerritories(GameData data, PlayerID player) {
        ArrayList<Territory> rVal = new ArrayList<Territory>();
        for (Territory t : data.getMap()) {
            if (!Matches.isTerritoryEnemy(player, data).match(t) || !Matches.TerritoryIsLand.match(t) || !Matches.TerritoryIsNotImpassable.match(t) || data.getMap().getNeighbors(t, Matches.isTerritoryOwnedBy(player)).isEmpty()) continue;
            rVal.add(t);
        }
        return rVal;
    }

    public static List<Territory> getTerritoriesWithEnemyNeighbor(GameData data, PlayerID player, boolean allied, boolean neutral) {
        ArrayList<Territory> ourTerr = new ArrayList<Territory>();
        List<Territory> enemyLandTerr = SUtils.allEnemyTerritories(data, player);
        if (!neutral) {
            Iterator<Territory> eIter = enemyLandTerr.iterator();
            while (eIter.hasNext()) {
                Territory checkTerr = eIter.next();
                if (!Matches.TerritoryIsNeutralButNotWater.match(checkTerr)) continue;
                eIter.remove();
            }
        }
        for (Territory enemy : enemyLandTerr) {
            if (!SUtils.doesLandExistAt(enemy, data, false)) continue;
            ArrayList<Territory> newTerrs = new ArrayList<Territory>();
            if (allied) {
                newTerrs.addAll(SUtils.getNeighboringLandTerritories(data, player, enemy));
            } else {
                newTerrs.addAll(data.getMap().getNeighbors(enemy, Matches.isTerritoryOwnedBy(player)));
            }
            for (Territory nT : newTerrs) {
                if (ourTerr.contains(nT)) continue;
                ourTerr.add(nT);
            }
        }
        return ourTerr;
    }

    public static List<Territory> getNeighboringEnemyLandTerritories(GameData data, PlayerID player, boolean allied) {
        ArrayList<Territory> rVal = new ArrayList<Territory>();
        CompositeMatchAnd<Territory> enemyLand = new CompositeMatchAnd<Territory>(Matches.isTerritoryEnemy(player, data), Matches.TerritoryIsNotImpassable, Matches.TerritoryIsLand);
        for (Territory t : data.getMap().getTerritories()) {
            if (!((Match)enemyLand).match(t)) continue;
            if (allied) {
                if (data.getMap().getNeighbors(t, Matches.isTerritoryAllied(player, data)).isEmpty()) continue;
                rVal.add(t);
                continue;
            }
            if (data.getMap().getNeighbors(t, Matches.isTerritoryOwnedBy(player)).isEmpty()) continue;
            rVal.add(t);
        }
        return rVal;
    }

    public static List<Territory> getNeighboringNeutralLandTerritories(GameData data, PlayerID player, boolean allied) {
        ArrayList<Territory> rVal = new ArrayList<Territory>();
        for (Territory t : data.getMap()) {
            TerritoryAttachment ta;
            if (!Matches.isTerritoryFreeNeutral(data).match(t) || t.isWater() || (ta = TerritoryAttachment.get(t)) == null || ta.getProduction() == 0 || ta.getIsImpassible()) continue;
            if (allied && !data.getMap().getNeighbors(t, Matches.isTerritoryAllied(player, data)).isEmpty()) {
                rVal.add(t);
                continue;
            }
            if (data.getMap().getNeighbors(t, Matches.isTerritoryOwnedBy(player)).isEmpty()) continue;
            rVal.add(t);
        }
        return rVal;
    }

    public static Territory getClosestWaterTerr(Territory target, Territory source, GameData data, PlayerID player, boolean allowEnemy) {
        CompositeMatchAnd<Territory> waterCond = null;
        waterCond = allowEnemy ? new CompositeMatchAnd<Territory>(Matches.TerritoryIsWater) : new CompositeMatchAnd(Matches.TerritoryIsWater, Matches.territoryHasNoEnemyUnits(player, data));
        Set<Territory> waterTerr = data.getMap().getNeighbors(target, waterCond);
        Territory result = null;
        int minDist = 0;
        if (waterTerr.size() == 0) {
            minDist = 0;
            return result;
        }
        if (waterTerr.contains(source)) {
            minDist = 0;
            return source;
        }
        minDist = 100;
        int thisDist = 100;
        for (Territory checkTerr : waterTerr) {
            thisDist = data.getMap().getWaterDistance(source, checkTerr);
            if (thisDist >= minDist) continue;
            minDist = thisDist;
            result = checkTerr;
        }
        return result;
    }

    public static Territory getSafestWaterTerr(Territory target, Territory source, List<Territory> ignoreTerr, GameData data, PlayerID player, boolean allowEnemy, boolean tFirst) {
        CompositeMatchAnd<Territory> waterCond = null;
        CompositeMatchAnd<Unit> alliedSeaUnit = new CompositeMatchAnd<Unit>(Matches.UnitIsNotLand, Matches.alliedUnit(player, data));
        waterCond = allowEnemy ? new CompositeMatchAnd<Territory>(Matches.TerritoryIsWater) : new CompositeMatchAnd(Matches.TerritoryIsWater, Matches.territoryHasNoEnemyUnits(player, data));
        Set<Territory> waterTerr = data.getMap().getNeighbors(target, waterCond);
        Territory result = null;
        if (waterTerr.size() == 0) {
            return result;
        }
        HashMap<Territory, Float> waterStrength = new HashMap<Territory, Float>();
        float eStrength = 0.0f;
        for (Territory xWaterTerr : waterTerr) {
            eStrength = SUtils.getStrengthOfPotentialAttackers(xWaterTerr, data, player, tFirst, false, ignoreTerr);
            if (ignoreTerr == null || !ignoreTerr.contains(xWaterTerr)) {
                eStrength += SUtils.strength(xWaterTerr.getUnits().getMatches(Matches.enemyUnit(player, data)), true, true, tFirst);
            }
            eStrength -= SUtils.strength(xWaterTerr.getUnits().getMatches(alliedSeaUnit), false, true, tFirst);
            if (xWaterTerr == source && eStrength <= 0.0f) {
                return xWaterTerr;
            }
            waterStrength.put(xWaterTerr, Float.valueOf(-eStrength));
        }
        ArrayList<Territory> waterTerrList = new ArrayList<Territory>(waterTerr);
        SUtils.reorder(waterTerrList, waterStrength, true);
        float maxStrength = -10000.0f;
        ArrayList<Territory> safeTerrList = new ArrayList<Territory>();
        for (Territory checkTerr : waterTerrList) {
            eStrength = ((Float)waterStrength.get(checkTerr)).floatValue();
            if (eStrength >= 0.0f) {
                safeTerrList.add(checkTerr);
            }
            if (!(eStrength > maxStrength)) continue;
            maxStrength = eStrength;
            result = checkTerr;
        }
        if (safeTerrList.size() > 1 && source != null) {
            int minDist = 0;
            for (Territory safeTerr : safeTerrList) {
                int thisDist = data.getMap().getWaterDistance(source, safeTerr);
                if (thisDist >= minDist) continue;
                minDist = thisDist;
                result = safeTerr;
            }
        }
        if (source == null && result != null && ((Float)waterStrength.get(result)).floatValue() < 0.0f) {
            return null;
        }
        return result;
    }

    public static List<Territory> possibleBlitzTerritories(Territory checkTerr, GameData data, PlayerID player) {
        CompositeMatchAnd<Unit> blitzUnit = new CompositeMatchAnd<Unit>(Matches.UnitCanBlitz, Matches.enemyUnit(player, data));
        ArrayList<Territory> blitzTerr = new ArrayList<Territory>();
        List<Territory> twoTerr = SUtils.getExactNeighbors(checkTerr, 2, player, data, false);
        List<Territory> oneTerr = SUtils.getExactNeighbors(checkTerr, 1, player, data, false);
        for (Territory blitzFrom : twoTerr) {
            List<Unit> blitzUnits = blitzFrom.getUnits().getMatches(blitzUnit);
            if (blitzUnits.isEmpty()) continue;
            List<Territory> blitzNeighbors = SUtils.getExactNeighbors(blitzFrom, 1, player, data, false);
            for (Territory blitzCheck : blitzNeighbors) {
                if (!oneTerr.contains(blitzCheck)) continue;
                blitzTerr.add(blitzCheck);
            }
        }
        return blitzTerr;
    }

    public static List<Territory> getNeighboringEnemyLandTerritories(GameData data, PlayerID player, Territory check) {
        ArrayList<Territory> rVal = new ArrayList<Territory>();
        List<Territory> checkList = SUtils.getExactNeighbors(check, 1, player, data, false);
        for (Territory t : checkList) {
            if (!Matches.isTerritoryEnemy(player, data).match(t) || !Matches.TerritoryIsNotImpassable.match(t) || !Matches.TerritoryIsLand.match(t)) continue;
            rVal.add(t);
        }
        return rVal;
    }

    public static List<Territory> getNeighboringLandTerritories(GameData data, PlayerID player, Territory check) {
        ArrayList<Territory> rVal = new ArrayList<Territory>();
        List<Territory> checkList = SUtils.getExactNeighbors(check, 1, player, data, false);
        for (Territory t : checkList) {
            if (!Matches.isTerritoryAllied(player, data).match(t) || !Matches.TerritoryIsNotImpassableToLandUnits(player, data).match(t)) continue;
            rVal.add(t);
        }
        return rVal;
    }

    public static boolean doesLandExistAt(Territory t, GameData data, boolean neutral) {
        boolean isLand = false;
        Set<Territory> checkList = data.getMap().getNeighbors(t, Matches.TerritoryIsLand);
        if (!neutral) {
            Iterator<Territory> nIter = checkList.iterator();
            while (nIter.hasNext()) {
                Territory nTerr = nIter.next();
                if (!Matches.TerritoryIsNeutralButNotWater.match(nTerr)) continue;
                nIter.remove();
            }
        }
        for (Territory checkNeutral : checkList) {
            if (!Matches.TerritoryIsNotImpassable.match(checkNeutral)) continue;
            isLand = true;
        }
        return isLand;
    }

    public static int distanceToEnemy(Territory t, GameData data, PlayerID player, boolean sea) {
        Match<Territory> routeCondition;
        CompositeMatchAnd<Territory> endCondition;
        if (Matches.TerritoryIsImpassable.match(t)) {
            return 0;
        }
        if (sea) {
            endCondition = new CompositeMatchAnd<Territory>(Matches.TerritoryIsWater, Matches.territoryHasEnemyUnits(player, data));
            routeCondition = Matches.TerritoryIsWater;
        } else {
            endCondition = new CompositeMatchAnd(Matches.isTerritoryEnemy(player, data), Matches.TerritoryIsNotImpassable, Matches.TerritoryIsLand);
            routeCondition = new CompositeMatchAnd<Territory>(Matches.isTerritoryAllied(player, data), Matches.TerritoryIsNotImpassable, Matches.TerritoryIsLand);
        }
        Route r = SUtils.findNearest(t, endCondition, routeCondition, data);
        if (r == null) {
            return 0;
        }
        return r.getLength();
    }

    public static List<Territory> getEnemyCapitals(GameData data, PlayerID player) {
        ArrayList<Territory> enemyCapitals = new ArrayList<Territory>();
        List<PlayerID> ePlayers = SUtils.getEnemyPlayers(data, player);
        for (PlayerID otherPlayer : ePlayers) {
            Territory capitol = TerritoryAttachment.getCapital(otherPlayer, data);
            if (capitol == null || !Matches.TerritoryIsNotImpassable.match(capitol)) continue;
            enemyCapitals.add(capitol);
        }
        return enemyCapitals;
    }

    public static List<Territory> getLiveEnemyCapitals(GameData data, PlayerID player) {
        ArrayList<Territory> enemyCapitals = new ArrayList<Territory>();
        List<PlayerID> ePlayers = SUtils.getEnemyPlayers(data, player);
        for (PlayerID otherPlayer : ePlayers) {
            enemyCapitals.addAll(TerritoryAttachment.getAllCurrentlyOwnedCapitals(otherPlayer, data));
        }
        enemyCapitals.retainAll(Match.getMatches(enemyCapitals, Matches.TerritoryIsNotImpassableToLandUnits(player, data)));
        return enemyCapitals;
    }

    public static List<PlayerID> getEnemyPlayers(GameData data, PlayerID player) {
        ArrayList<PlayerID> enemyPlayers = new ArrayList<PlayerID>();
        for (PlayerID players : data.getPlayerList().getPlayers()) {
            if (data.getRelationshipTracker().isAllied(player, players)) continue;
            enemyPlayers.add(players);
        }
        return enemyPlayers;
    }

    public static Territory getAlliedLandTerrNextToEnemyCapital(int minDist, Territory capTerr, Territory fromTerr, GameData data, PlayerID player) {
        minDist = 100;
        Territory capWaterTerr = null;
        List<Territory> enemyCapitals = SUtils.getEnemyCapitals(data, player);
        if (enemyCapitals.size() > 0) {
            for (Territory badCapital : enemyCapitals) {
                List<Territory> areaTerritories = SUtils.getNeighboringLandTerritories(data, player, badCapital);
                if (areaTerritories.size() == 0) continue;
                for (Territory nextToCapital : areaTerritories) {
                    int capDist = 100;
                    Territory tcapTerr = null;
                    for (Territory tmpCapTerr : data.getMap().getNeighbors(nextToCapital, Matches.TerritoryIsWater)) {
                        int tDist = data.getMap().getWaterDistance(fromTerr, tmpCapTerr);
                        if (tDist >= capDist) continue;
                        capDist = tDist;
                        tcapTerr = tmpCapTerr;
                    }
                    if (tcapTerr == null || capDist >= minDist) continue;
                    capWaterTerr = nextToCapital;
                    minDist = capDist;
                }
            }
        }
        return capWaterTerr;
    }

    public static boolean landRouteToEnemyCapital(Territory thisTerr, Route goRoute, GameData data, PlayerID player) {
        Route route = null;
        for (PlayerID otherPlayer : data.getPlayerList().getPlayers()) {
            Territory capitol;
            if (data.getRelationshipTracker().isAllied(player, otherPlayer) || (capitol = TerritoryAttachment.getCapital(otherPlayer, data)) == null || (route = data.getMap().getRoute(thisTerr, capitol, Matches.TerritoryIsNotImpassableToLandUnits(player, data))) == null) continue;
            return true;
        }
        return false;
    }

    public static List<Unit> getUnitsUpToStrength(double maxStrength, Collection<Unit> units, boolean attacking, boolean sea) {
        if ((double)SUtils.strength(units, attacking, sea, false) < maxStrength) {
            return new ArrayList<Unit>(units);
        }
        ArrayList<Unit> rVal = new ArrayList<Unit>();
        for (Unit u : units) {
            rVal.add(u);
            if (!((double)SUtils.strength(rVal, attacking, sea, false) > maxStrength)) continue;
            return rVal;
        }
        return rVal;
    }

    public static List<Territory> TerritoryOnlyPlanes(GameData data, PlayerID player) {
        List<Object> airUnits = new ArrayList();
        List<Object> landUnits = new ArrayList();
        ArrayList<Territory> returnTerr = new ArrayList<Territory>();
        int aUnit = 0;
        int lUnit = 0;
        CompositeMatchAnd<Unit> airUnit = new CompositeMatchAnd<Unit>(Matches.unitIsOwnedBy(player), Matches.UnitIsAir);
        CompositeMatchAnd<Unit> landUnit = new CompositeMatchAnd<Unit>(Matches.isUnitAllied(player, data), Matches.UnitIsLand, Matches.UnitIsNotInfrastructure);
        List<Territory> owned = SUtils.allOurTerritories(data, player);
        for (Territory t : owned) {
            airUnits = t.getUnits().getMatches(airUnit);
            landUnits = t.getUnits().getMatches(landUnit);
            aUnit = airUnits.size();
            if (!(aUnit > 0 & (lUnit = landUnits.size()) == 0)) continue;
            returnTerr.add(t);
        }
        return returnTerr;
    }

    public static Territory findNearestMaxUnits(PlayerID player, GameData data, Territory t, boolean friendly) {
        CompositeMatchAnd landUnit = new CompositeMatchAnd(Matches.UnitIsLand, Matches.UnitIsNotInfrastructure);
        CompositeMatchAnd<Unit> enemyLandUnit = new CompositeMatchAnd<Unit>(Matches.enemyUnit(player, data), landUnit);
        CompositeMatchAnd<Unit> ourLandUnit = new CompositeMatchAnd<Unit>(Matches.unitIsOwnedBy(player), landUnit);
        int totUnit = 0;
        int maxUnit = 0;
        Territory maxTerr = null;
        Set<Territory> nearNeighbors = data.getMap().getNeighbors(t, 3);
        nearNeighbors.remove(t);
        for (Territory t2 : nearNeighbors) {
            if (t2.isWater() || TerritoryAttachment.get(t2).getIsImpassible()) continue;
            if (friendly) {
                List<Unit> ourGuys = t2.getUnits().getMatches(ourLandUnit);
                totUnit = ourGuys.size();
                if (totUnit <= maxUnit) continue;
                maxUnit = totUnit;
                maxTerr = t2;
                continue;
            }
            List<Unit> theirGuys = t2.getUnits().getMatches(enemyLandUnit);
            totUnit = theirGuys.size();
            if (totUnit <= maxUnit) continue;
            maxUnit = totUnit;
            maxTerr = t2;
        }
        if (maxTerr == null) {
            maxTerr = t;
        }
        return maxTerr;
    }

    public static Collection<Unit> whatPlanesNeedToLand(boolean doBombers, Territory thisTerritory, PlayerID player) {
        ArrayList<Unit> ourPlanes = new ArrayList<Unit>();
        ArrayList<Unit> fighters = new ArrayList<Unit>();
        CompositeMatchAnd<Unit> fighterUnit = new CompositeMatchAnd<Unit>(Matches.UnitCanLandOnCarrier, Matches.unitIsOwnedBy(player));
        CompositeMatchAnd<Unit> bomberUnit = new CompositeMatchAnd<Unit>(Matches.UnitIsStrategicBomber, Matches.unitIsOwnedBy(player));
        CompositeMatchAnd<Unit> alliedFighter = new CompositeMatchAnd<Unit>(Matches.UnitCanLandOnCarrier);
        fighters.addAll(thisTerritory.getUnits().getMatches(fighterUnit));
        List<Unit> bombers = thisTerritory.getUnits().getMatches(bomberUnit);
        if (thisTerritory.isWater()) {
            List<Unit> carriers = thisTerritory.getUnits().getMatches(Matches.UnitIsCarrier);
            List<Unit> otherfighters = thisTerritory.getUnits().getMatches(alliedFighter);
            otherfighters.removeAll(fighters);
            int numAlliedFighters = otherfighters.size();
            int carrierCapacity = carriers.size() * 2 - (numAlliedFighters + 1);
            for (int i = 0; i <= carrierCapacity; ++i) {
                fighters.remove((Object)i);
            }
        }
        if (!doBombers) {
            ourPlanes.addAll(fighters);
        } else {
            ourPlanes.addAll(bombers);
        }
        return ourPlanes;
    }

    public static float getStrengthOfPotentialAttackers(Territory location, GameData data, PlayerID player, boolean tFirst, boolean ignoreOnlyPlanes, List<Territory> ignoreTerr) {
        TransportTracker tracker = DelegateFinder.moveDelegate(data).getTransportTracker();
        PlayerID ePlayer = null;
        List<PlayerID> qID = SUtils.getEnemyPlayers(data, player);
        HashMap<PlayerID, Float> ePAttackMap = new HashMap<PlayerID, Float>();
        Iterator<PlayerID> playerIter = qID.iterator();
        if (location == null) {
            return -1000.0f;
        }
        boolean nonTransportsInAttack = false;
        boolean onWater = location.isWater();
        if (!onWater) {
            nonTransportsInAttack = true;
        }
        Set<Territory> waterTerr = data.getMap().getNeighbors(location, Matches.TerritoryIsWater);
        while (playerIter.hasNext()) {
            float seaStrength = 0.0f;
            float firstStrength = 0.0f;
            float secondStrength = 0.0f;
            float blitzStrength = 0.0f;
            float strength = 0.0f;
            float airStrength = 0.0f;
            ePlayer = playerIter.next();
            CompositeMatchAnd<Unit> enemyPlane = new CompositeMatchAnd<Unit>(Matches.UnitIsAir, Matches.unitIsOwnedBy(ePlayer), Matches.UnitCanMove);
            CompositeMatchAnd<Unit> enemyTransport = new CompositeMatchAnd<Unit>(Matches.unitIsOwnedBy(ePlayer), Matches.UnitIsSea, Matches.UnitIsTransport, Matches.UnitCanMove);
            CompositeMatchAnd<Unit> enemyShip = new CompositeMatchAnd<Unit>(Matches.unitIsOwnedBy(ePlayer), Matches.UnitIsSea, Matches.UnitCanMove);
            CompositeMatchAnd<Unit> enemyTransportable = new CompositeMatchAnd<Unit>(Matches.unitIsOwnedBy(ePlayer), Matches.UnitCanBeTransported, Matches.UnitIsNotAA, Matches.UnitCanMove);
            CompositeMatchAnd<Unit> aTransport = new CompositeMatchAnd<Unit>(Matches.UnitIsSea, Matches.UnitIsTransport, Matches.UnitCanMove);
            List<Territory> eFTerrs = SUtils.findUnitTerr(data, ePlayer, enemyPlane);
            int maxFighterDistance = 0;
            int maxBomberDistance = 0;
            for (Territory eFTerr : eFTerrs) {
                List<Unit> eFUnits = eFTerr.getUnits().getMatches(enemyPlane);
                maxFighterDistance = Math.max(maxFighterDistance, MoveValidator.getMaxMovement(eFUnits));
            }
            if (--maxFighterDistance < 0) {
                maxFighterDistance = 0;
            }
            if (--maxBomberDistance < 0) {
                maxBomberDistance = 0;
            }
            List<Territory> eTTerrs = SUtils.findUnitTerr(data, ePlayer, aTransport);
            int maxTransportDistance = 0;
            for (Territory eTTerr : eTTerrs) {
                List<Unit> eTUnits = eTTerr.getUnits().getMatches(aTransport);
                maxTransportDistance = Math.max(maxTransportDistance, MoveValidator.getMaxMovement(eTUnits));
            }
            ArrayList<Unit> alreadyLoaded = new ArrayList<Unit>();
            ArrayList<Route> blitzTerrRoutes = new ArrayList<Route>();
            ArrayList<Territory> checked = new ArrayList<Territory>();
            ArrayList<Unit> enemyWaterUnits = new ArrayList<Unit>();
            for (Territory t : data.getMap().getNeighbors(location, onWater ? Matches.TerritoryIsWater : Matches.TerritoryIsLand)) {
                if (ignoreTerr != null && ignoreTerr.contains(t)) continue;
                List<Unit> enemies = t.getUnits().getMatches(Matches.unitIsOwnedBy(ePlayer));
                enemyWaterUnits.addAll(enemies);
                firstStrength += SUtils.strength(enemies, true, onWater, tFirst);
                checked.add(t);
            }
            if (Matches.TerritoryIsLand.match(location)) {
                blitzStrength = SUtils.determineEnemyBlitzStrength(location, blitzTerrRoutes, null, data, ePlayer);
            } else {
                HashSet<Integer> ignore = new HashSet<Integer>();
                ignore.add(1);
                ArrayList<Route> r = new ArrayList<Route>();
                List<Unit> ships = SUtils.findAttackers(location, 3, ignore, ePlayer, data, enemyShip, Matches.territoryIsBlockedSea(ePlayer, data), ignoreTerr, r, true);
                secondStrength = SUtils.strength(ships, true, true, tFirst);
                enemyWaterUnits.addAll(ships);
            }
            List<Unit> attackPlanes = SUtils.findPlaneAttackersThatCanLand(location, maxFighterDistance, ePlayer, data, ignoreTerr, checked);
            airStrength += SUtils.allairstrength(attackPlanes, true);
            if (Matches.territoryHasWaterNeighbor(data).match(location) && Matches.TerritoryIsLand.match(location)) {
                for (Territory t4 : data.getMap().getNeighbors(location, maxTransportDistance)) {
                    if (!t4.isWater()) continue;
                    boolean transportsCounted = false;
                    Iterator<Territory> iterTerr = waterTerr.iterator();
                    while (!transportsCounted && iterTerr.hasNext()) {
                        Route seaRoute;
                        List<Unit> transports;
                        Territory waterCheck = iterTerr.next();
                        if (ePlayer == null || (transports = t4.getUnits().getMatches(enemyTransport)).isEmpty() || !t4.equals(waterCheck) && ((seaRoute = SUtils.getMaxSeaRoute(data, t4, waterCheck, ePlayer, true, maxTransportDistance)) == null || seaRoute.getEnd() == null || seaRoute.getEnd() != waterCheck)) continue;
                        ArrayList<Unit> loadedUnits = new ArrayList<Unit>();
                        int availInf = 0;
                        int availOther = 0;
                        for (Unit xTrans : transports) {
                            Collection<Unit> thisTransUnits = tracker.transporting(xTrans);
                            if (thisTransUnits == null) {
                                availInf += 2;
                                ++availOther;
                                continue;
                            }
                            int Inf = 2;
                            int Other = 1;
                            for (Unit checkUnit : thisTransUnits) {
                                if (Matches.UnitIsInfantry.match(checkUnit)) {
                                    --Inf;
                                }
                                if (Matches.UnitIsNotInfantry.match(checkUnit)) {
                                    --Inf;
                                    --Other;
                                }
                                loadedUnits.add(checkUnit);
                            }
                            availInf += Inf;
                            availOther += Other;
                        }
                        Set<Territory> transNeighbors = data.getMap().getNeighbors(t4, Matches.isTerritoryAllied(ePlayer, data));
                        for (Territory xN : transNeighbors) {
                            List<Unit> aTransUnits = xN.getUnits().getMatches(enemyTransportable);
                            aTransUnits.removeAll(alreadyLoaded);
                            List<Unit> availTransUnits = SUtils.sortTransportUnits(aTransUnits);
                            for (Unit aTUnit : availTransUnits) {
                                if (availInf > 0 && Matches.UnitIsInfantry.match(aTUnit)) {
                                    --availInf;
                                    loadedUnits.add(aTUnit);
                                    alreadyLoaded.add(aTUnit);
                                }
                                if (availInf <= 0 || availOther <= 0 || !Matches.UnitIsNotInfantry.match(aTUnit)) continue;
                                --availInf;
                                --availOther;
                                loadedUnits.add(aTUnit);
                                alreadyLoaded.add(aTUnit);
                            }
                        }
                        seaStrength += SUtils.strength(loadedUnits, true, false, tFirst);
                        transportsCounted = true;
                    }
                }
            }
            strength = seaStrength + blitzStrength + firstStrength + secondStrength;
            if (!ignoreOnlyPlanes || strength > 0.0f) {
                strength += airStrength;
            }
            if (onWater) {
                Iterator eWaterIter = enemyWaterUnits.iterator();
                while (eWaterIter.hasNext() && !nonTransportsInAttack) {
                    if (!Matches.UnitIsNotTransport.match((Unit)eWaterIter.next())) continue;
                    nonTransportsInAttack = true;
                }
            }
            if (!nonTransportsInAttack) {
                strength = 0.0f;
            }
            ePAttackMap.put(ePlayer, Float.valueOf(strength));
        }
        float maxStrength = 0.0f;
        for (PlayerID xP : qID) {
            if (!(((Float)ePAttackMap.get(xP)).floatValue() > maxStrength)) continue;
            ePlayer = xP;
            maxStrength = ((Float)ePAttackMap.get(xP)).floatValue();
        }
        for (PlayerID xP : qID) {
            if (ePlayer == xP) continue;
            maxStrength += ((Float)ePAttackMap.get(xP)).floatValue() * 0.4f;
        }
        return maxStrength;
    }

    public static List<Territory> findOurShips(Territory t, GameData data, PlayerID player) {
        ArrayList<Territory> shipTerr = new ArrayList<Territory>();
        Set<Territory> tNeighbors = data.getMap().getNeighbors(t, 4);
        for (Territory t2 : tNeighbors) {
            if (!t2.getUnits().someMatch(Matches.isUnitAllied(player, data))) continue;
            shipTerr.add(t2);
        }
        return shipTerr;
    }

    public static List<Territory> findOurShips(Territory t, GameData data, PlayerID player, Match<Unit> unitCondition) {
        CompositeMatchAnd<Unit> limitShips = new CompositeMatchAnd<Unit>(unitCondition, Matches.isUnitAllied(player, data));
        ArrayList<Territory> shipTerr = new ArrayList<Territory>();
        Set<Territory> tNeighbors = data.getMap().getNeighbors(t, 3);
        for (Territory t2 : tNeighbors) {
            if (!t2.getUnits().someMatch(limitShips)) continue;
            shipTerr.add(t2);
        }
        return shipTerr;
    }

    public static List<Territory> findOnlyMyShips(Territory t, GameData data, PlayerID player, Match<Unit> unitCondition) {
        CompositeMatchAnd<Unit> limitShips = new CompositeMatchAnd<Unit>(unitCondition, Matches.unitIsOwnedBy(player));
        ArrayList<Territory> shipTerr = new ArrayList<Territory>();
        Set<Territory> tNeighbors = data.getMap().getNeighbors(t, 3);
        for (Territory t2 : tNeighbors) {
            if (!t2.getUnits().someMatch(limitShips)) continue;
            shipTerr.add(t2);
        }
        return shipTerr;
    }

    public static List<Territory> findTersWithUnitsMatching(GameData data, PlayerID player, Match<Unit> unitCondition) {
        CompositeMatchAnd<Unit> unitMatch = new CompositeMatchAnd<Unit>(unitCondition, Matches.unitIsOwnedBy(player));
        ArrayList<Territory> result = new ArrayList<Territory>();
        Collection<Territory> allTers = data.getMap().getTerritories();
        for (Territory ter : allTers) {
            if (!ter.getUnits().someMatch(unitMatch)) continue;
            result.add(ter);
        }
        return result;
    }

    public static int findNumberOfUnitsMatching(GameData data, PlayerID player, Match<Unit> unitCondition) {
        int total = 0;
        Collection<Territory> allTers = data.getMap().getTerritories();
        for (Territory ter : allTers) {
            total += Match.countMatches(ter.getUnits().getUnits(), unitCondition);
        }
        return total;
    }

    public static List<Territory> findUnitTerr(GameData data, PlayerID player, Match<Unit> unitCondition) {
        CompositeMatchAnd<Unit> limitShips = new CompositeMatchAnd<Unit>(unitCondition);
        ArrayList<Territory> shipTerr = new ArrayList<Territory>();
        Collection<Territory> tNeighbors = data.getMap().getTerritories();
        for (Territory t2 : tNeighbors) {
            if (!t2.getUnits().someMatch(limitShips)) continue;
            shipTerr.add(t2);
        }
        return shipTerr;
    }

    public static List<Territory> findOurPlanes(Territory t, GameData data, PlayerID player) {
        CompositeMatchAnd<Unit> ownedAndAir = new CompositeMatchAnd<Unit>(Matches.UnitIsAir, Matches.unitIsOwnedBy(player));
        ArrayList<Territory> airTerr = new ArrayList<Territory>();
        Set<Territory> tNeighbors = data.getMap().getNeighbors(t, 4);
        for (Territory t2 : tNeighbors) {
            if (!t2.getUnits().someMatch(ownedAndAir)) continue;
            airTerr.add(t2);
        }
        return airTerr;
    }

    public static List<Territory> findUnits(Territory t, GameData data, Match<Unit> unitCondition, int maxDist) {
        ArrayList<Territory> anyTerr = new ArrayList<Territory>();
        Set<Territory> tNeighbors = data.getMap().getNeighbors(t, maxDist);
        for (Territory t2 : tNeighbors) {
            if (!t2.getUnits().someMatch(unitCondition)) continue;
            anyTerr.add(t2);
        }
        return anyTerr;
    }

    public static List<Territory> allOurTerritories(GameData data, PlayerID player) {
        Collection<Territory> ours = data.getMap().getTerritoriesOwnedBy(player);
        ArrayList<Territory> ours2 = new ArrayList<Territory>();
        ours2.addAll(ours);
        return ours2;
    }

    public static List<Territory> allAlliedTerritories(GameData data, PlayerID player) {
        ArrayList<Territory> ours = new ArrayList<Territory>();
        for (Territory t : data.getMap().getTerritories()) {
            if (!Matches.isTerritoryAllied(player, data).match(t)) continue;
            ours.add(t);
        }
        return ours;
    }

    public static List<Territory> allEnemyTerritories(GameData data, PlayerID player) {
        ArrayList<Territory> badGuys = new ArrayList<Territory>();
        for (Territory t : data.getMap().getTerritories()) {
            if (!Matches.isTerritoryEnemyAndNotUnownedWaterOrImpassibleOrRestricted(player, data).match(t)) continue;
            badGuys.add(t);
        }
        return badGuys;
    }

    public static List<Unit> findAttackers(Territory start, int maxDistance, HashSet<Integer> ignoreDistance, PlayerID player, GameData data, Match<Unit> unitCondition, Match<Territory> routeCondition, List<Territory> blocked, List<Route> routes, boolean sea) {
        Route r;
        IntegerMap<Territory> distance = new IntegerMap<Territory>();
        HashMap<Territory, Territory> visited = new HashMap<Territory, Territory>();
        ArrayList<Unit> units = new ArrayList<Unit>();
        LinkedList<Territory> q = new LinkedList<Territory>();
        q.add(start);
        Territory current = null;
        distance.put(start, 0);
        visited.put(start, null);
        while (!q.isEmpty() && distance.getInt(current = (Territory)q.remove()) != maxDistance) {
            for (Territory neighbor : data.getMap().getNeighbors(current)) {
                if (distance.keySet().contains(neighbor) || !neighbor.getUnits().someMatch(unitCondition) && !routeCondition.match(neighbor)) continue;
                if (sea) {
                    r = new Route();
                    r.setStart(neighbor);
                    r.add(current);
                    if (MoveValidator.validateCanal(r, null, player, data) != null) continue;
                }
                distance.put(neighbor, distance.getInt(current) + 1);
                visited.put(neighbor, current);
                if (blocked != null && blocked.contains(neighbor)) continue;
                q.add(neighbor);
                Integer dist = distance.getInt(neighbor);
                if (ignoreDistance.contains(dist)) continue;
                for (Unit u : neighbor.getUnits()) {
                    if (!unitCondition.match(u) || !MoveValidator.hasEnoughMovement(u, (int)dist)) continue;
                    units.add(u);
                }
            }
        }
        for (Territory t : visited.keySet()) {
            r = new Route();
            Territory t2 = t;
            r.setStart(t);
            while (t2 != null) {
                if ((t2 = (Territory)visited.get(t2)) == null) continue;
                r.add(t2);
            }
            routes.add(r);
        }
        return units;
    }

    public static List<Unit> findPlaneAttackersThatCanLand(Territory start, int maxDistance, PlayerID player, GameData data, List<Territory> ignore, List<Territory> checked) {
        IntegerMap<Territory> distance = new IntegerMap<Territory>();
        IntegerMap<Unit> unitDistance = new IntegerMap<Unit>();
        ArrayList<Unit> units = new ArrayList<Unit>();
        LinkedList<Territory> q = new LinkedList<Territory>();
        Territory lz = null;
        Territory ac = null;
        CompositeMatchAnd<Unit> enemyPlane = new CompositeMatchAnd<Unit>(Matches.UnitIsAir, Matches.unitIsOwnedBy(player), Matches.UnitCanMove);
        CompositeMatchAnd<Unit> enemyCarrier = new CompositeMatchAnd<Unit>(Matches.UnitIsCarrier, Matches.unitIsOwnedBy(player), Matches.UnitCanMove);
        q.add(start);
        Territory current = null;
        distance.put(start, 0);
        while (!q.isEmpty() && distance.getInt(current = (Territory)q.remove()) != maxDistance) {
            for (Territory neighbor : data.getMap().getNeighbors(current, SUtils.TerritoryIsNotImpassableToAirUnits(data))) {
                if (distance.keySet().contains(neighbor)) continue;
                q.add(neighbor);
                distance.put(neighbor, distance.getInt(current) + 1);
                if (lz == null && Matches.isTerritoryAllied(player, data).match(neighbor) && !neighbor.isWater()) {
                    lz = neighbor;
                }
                if (ignore != null && ignore.contains(neighbor) || checked != null && checked.contains(neighbor)) {
                    for (Unit u : neighbor.getUnits()) {
                        if (ac != null || !((Match)enemyCarrier).match(u)) continue;
                        ac = neighbor;
                    }
                    continue;
                }
                for (Unit u : neighbor.getUnits()) {
                    if (ac == null && ((Match)enemyCarrier).match(u)) {
                        ac = neighbor;
                    }
                    if (!((Match)enemyPlane).match(u)) continue;
                    unitDistance.put(u, distance.getInt(neighbor));
                }
            }
        }
        for (Unit u : unitDistance.keySet()) {
            if (lz != null && MoveValidator.hasEnoughMovement(u, unitDistance.getInt(u) + distance.getInt(lz))) {
                units.add(u);
                continue;
            }
            if (ac == null || !Matches.UnitCanLandOnCarrier.match(u) || !MoveValidator.hasEnoughMovement(u, unitDistance.getInt(u) + distance.getInt(ac))) continue;
            units.add(u);
        }
        return units;
    }

    public static IntegerMap<Unit> findAllUnits(Territory start, int maxDistance, Match<Territory> routeCondition, Match<Unit> unitCondition, GameData data) {
        IntegerMap<Territory> distance = new IntegerMap<Territory>();
        IntegerMap<Unit> unitDistance = new IntegerMap<Unit>();
        LinkedList<Territory> q = new LinkedList<Territory>();
        q.add(start);
        Territory current = null;
        distance.put(start, 0);
        while (!q.isEmpty() && distance.getInt(current = (Territory)q.remove()) != maxDistance) {
            for (Territory neighbor : data.getMap().getNeighbors(current, routeCondition)) {
                if (distance.keySet().contains(neighbor)) continue;
                q.add(neighbor);
                distance.put(neighbor, distance.getInt(current) + 1);
                for (Unit u : neighbor.getUnits()) {
                    if (!unitCondition.match(u)) continue;
                    unitDistance.put(u, distance.getInt(neighbor));
                }
            }
        }
        return unitDistance;
    }

    public static Route findNearest(Territory start, Match<Territory> endCondition, Match<Territory> routeCondition, GameData data) {
        CompositeMatchOr<Territory> canGo = new CompositeMatchOr<Territory>(endCondition, routeCondition);
        HashMap<Territory, Territory> visited = new HashMap<Territory, Territory>();
        LinkedList<Territory> q = new LinkedList<Territory>();
        ArrayList<Territory> route = new ArrayList<Territory>();
        q.addAll(data.getMap().getNeighbors(start, canGo));
        Territory current = null;
        visited.put(start, null);
        for (Territory t : q) {
            visited.put(t, start);
        }
        while (!q.isEmpty() && !endCondition.match(current = (Territory)q.remove())) {
            for (Territory neighbor : data.getMap().getNeighbors(current, canGo)) {
                if (visited.containsKey(neighbor)) continue;
                q.add(neighbor);
                visited.put(neighbor, current);
            }
        }
        if (current == null || !endCondition.match(current)) {
            return null;
        }
        Territory t = current;
        while (t != null) {
            route.add(t);
            t = (Territory)visited.get(t);
        }
        Collections.reverse(route);
        return new Route(route);
    }

    public static List<Territory> findFontier(Territory start, Match<Territory> endCondition, Match<Territory> routeCondition, int distance, GameData data) {
        CompositeMatchOr<Territory> canGo = new CompositeMatchOr<Territory>(endCondition, routeCondition);
        IntegerMap<Territory> visited = new IntegerMap<Territory>();
        LinkedList<Territory> q = new LinkedList<Territory>();
        ArrayList<Territory> frontier = new ArrayList<Territory>();
        q.addAll(data.getMap().getNeighbors(start, canGo));
        Territory current = null;
        visited.put(start, 0);
        for (Territory t : q) {
            visited.put(t, 1);
            if (1 != distance || !endCondition.match(t)) continue;
            frontier.add(t);
        }
        while (!q.isEmpty() && visited.getInt(current = (Territory)q.remove()) != distance) {
            for (Territory neighbor : data.getMap().getNeighbors(current, canGo)) {
                if (visited.keySet().contains(neighbor)) continue;
                q.add(neighbor);
                int dist = visited.getInt(current) + 1;
                visited.put(neighbor, dist);
                if (dist != distance || !endCondition.match(neighbor)) continue;
                frontier.add(neighbor);
            }
        }
        return frontier;
    }

    public static Route findNearestMaxContaining(Territory start, Match<Territory> endCondition, Match<Territory> routeCondition, final Match<Unit> unitCondition, final int maxUnits, GameData data) {
        Match<Territory> condition = new Match<Territory>(){

            @Override
            public boolean match(Territory t) {
                return t.getUnits().getMatches(unitCondition).size() > maxUnits;
            }
        };
        return SUtils.findNearest(start, new CompositeMatchAnd<Territory>(endCondition, condition), routeCondition, data);
    }

    public static Route findNearestNotEmpty(Territory start, Match<Territory> endCondition, Match<Territory> routeCondition, GameData data) {
        Route r = SUtils.findNearest(start, new CompositeMatchAnd<Territory>(endCondition, Matches.TerritoryIsEmpty.invert()), routeCondition, data);
        if (r == null) {
            r = SUtils.findNearest(start, endCondition, routeCondition, data);
        }
        return r;
    }

    public static boolean hasLandRouteToEnemyOwnedCapitol(Territory t, PlayerID player, GameData data) {
        for (PlayerID ePlayer : data.getPlayerList().getPlayers()) {
            Territory capitol = TerritoryAttachment.getCapital(ePlayer, data);
            if (capitol == null || data.getRelationshipTracker().isAllied(player, capitol.getOwner()) || data.getMap().getDistance(t, capitol, Matches.TerritoryIsNotImpassableToLandUnits(player, data)) == -1) continue;
            return true;
        }
        return false;
    }

    public static boolean airUnitIsLandableOnCarrier(Unit u, Territory source, Territory target, PlayerID player, GameData data) {
        if (!Matches.UnitCanLandOnCarrier.match(u)) {
            return false;
        }
        final CompositeMatchAnd ownedCarrier = new CompositeMatchAnd(Matches.UnitIsCarrier, Matches.unitIsOwnedBy(player));
        Match<Territory> condition = new Match<Territory>(){

            @Override
            public boolean match(Territory t) {
                return t.getUnits().someMatch(ownedCarrier);
            }
        };
        int rDist = data.getMap().getDistance(source, target, SUtils.TerritoryIsNotImpassableToAirUnits(data));
        boolean landable = false;
        if (MoveValidator.hasEnoughMovement(u, rDist)) {
            Route r = SUtils.findNearest(target, condition, SUtils.TerritoryIsNotImpassableToAirUnits(data), data);
            if (r == null) {
                return false;
            }
            int rDist2 = r.getLength();
            if (MoveValidator.hasEnoughMovement(u, rDist + rDist2)) {
                landable = true;
            }
        }
        return landable;
    }

    public static boolean airUnitIsLandable(Unit u, Territory source, Territory target, final PlayerID owner, final GameData data) {
        Route r;
        Match<Territory> condition = new Match<Territory>(){

            @Override
            public boolean match(Territory t) {
                return Matches.isTerritoryAllied(owner, data).match(t) && !t.isWater();
            }
        };
        int rDist = data.getMap().getDistance(source, target, SUtils.TerritoryIsNotImpassableToAirUnits(data));
        boolean landable = false;
        if (MoveValidator.hasEnoughMovement(u, rDist)) {
            // empty if block
        }
        if ((r = SUtils.findNearest(target, condition, SUtils.TerritoryIsNotImpassableToAirUnits(data), data)) == null) {
            return false;
        }
        int rDist2 = r.getLength();
        if (MoveValidator.hasEnoughMovement(u, rDist + rDist2)) {
            landable = true;
        }
        return landable;
    }

    public static List<Territory> ACTerritory(PlayerID player, GameData data) {
        ArrayList<Territory> carriers = new ArrayList<Territory>();
        CompositeMatchAnd<Unit> ourCarrier = new CompositeMatchAnd<Unit>(Matches.UnitIsCarrier, Matches.unitIsOwnedBy(player));
        for (Territory t : data.getMap().getTerritories()) {
            if (!t.getUnits().someMatch(ourCarrier)) continue;
            carriers.add(t);
        }
        return carriers;
    }

    public static void addUnitCollection(List<Collection<Unit>> aUnits, Collection<Unit> bUnits) {
        ArrayList<Unit> cUnits = new ArrayList<Unit>();
        cUnits.addAll(bUnits);
        aUnits.add(cUnits);
    }

    public static float airstrength(Unit airunit, boolean attacking) {
        float airstrength = 0.0f;
        Unit u = airunit;
        UnitAttachment unitAttachment = UnitAttachment.get(u.getType());
        if (unitAttachment.getIsAir()) {
            airstrength += 1.0f;
            airstrength = attacking ? (airstrength += (float)unitAttachment.getAttack(u.getOwner())) : (airstrength += (float)unitAttachment.getDefense(u.getOwner()));
        }
        return airstrength;
    }

    public static float allairstrength(Collection<Unit> units, boolean attacking) {
        float airstrength = 0.0f;
        for (Unit u : units) {
            UnitAttachment unitAttachment = UnitAttachment.get(u.getType());
            airstrength += 1.0f;
            if (attacking) {
                airstrength += (float)unitAttachment.getAttack(u.getOwner());
                continue;
            }
            airstrength += (float)unitAttachment.getDefense(u.getOwner());
        }
        return airstrength;
    }

    public static float uStrength(Unit units, boolean attacking, boolean sea, boolean transportsFirst) {
        float strength = 0.0f;
        Unit u = units;
        UnitAttachment unitAttachment = UnitAttachment.get(u.getType());
        if (!unitAttachment.getIsInfrastructure()) {
            if (unitAttachment.getIsSea() == sea) {
                strength += 1.0f;
                strength = attacking ? (strength += (float)(unitAttachment.getAttack(u.getOwner()) * (unitAttachment.getIsTwoHit() ? 2 : 1) * unitAttachment.getAttackRolls(u.getOwner()))) : (strength += (float)(unitAttachment.getDefense(u.getOwner()) * (unitAttachment.getIsTwoHit() ? 2 : 1)));
                if (attacking && unitAttachment.getAttack(u.getOwner()) == 0) {
                    strength -= 0.5f;
                }
                if (unitAttachment.getTransportCapacity() > 0 && !transportsFirst) {
                    strength -= 0.5f;
                }
            } else if (unitAttachment.getIsAir() & sea) {
                strength += 1.0f;
                strength = attacking ? (strength += (float)(unitAttachment.getAttack(u.getOwner()) * unitAttachment.getAttackRolls(u.getOwner()))) : (strength += (float)unitAttachment.getDefense(u.getOwner()));
            }
        }
        return strength;
    }

    public static float strength(Collection<Unit> units, boolean attacking, boolean sea, boolean transportsFirst) {
        float strength = 0.0f;
        if (units.isEmpty()) {
            return strength;
        }
        if (attacking && Match.noneMatch(units, Matches.unitHasAttackValueOfAtLeast(1))) {
            return strength;
        }
        if (!attacking && Match.noneMatch(units, Matches.unitHasDefendValueOfAtLeast(1))) {
            return strength;
        }
        for (Unit u : units) {
            UnitAttachment unitAttachment = UnitAttachment.get(u.getType());
            if (unitAttachment.getIsInfrastructure()) continue;
            if (unitAttachment.getIsSea() == sea) {
                int unitAttack = unitAttachment.getAttack(u.getOwner());
                strength += 1.0f;
                strength = attacking ? (strength += (float)(unitAttack * (unitAttachment.getIsTwoHit() ? 2 : 1))) : (strength += (float)(unitAttachment.getDefense(u.getOwner()) * (unitAttachment.getIsTwoHit() ? 2 : 1)));
                if (attacking && unitAttack == 0) {
                    strength -= 0.5f;
                }
                if (unitAttack != 0 || unitAttachment.getTransportCapacity() <= 0 || transportsFirst) continue;
                strength -= 0.5f;
                continue;
            }
            if (unitAttachment.getIsAir() != sea) continue;
            strength += 1.0f;
            if (attacking) {
                strength += (float)(unitAttachment.getAttack(u.getOwner()) * unitAttachment.getAttackRolls(u.getOwner()));
                continue;
            }
            strength += (float)unitAttachment.getDefense(u.getOwner());
        }
        if (attacking && !sea) {
            int art = Match.countMatches(units, Matches.UnitIsArtillery);
            int artSupport = Match.countMatches(units, Matches.UnitIsArtillerySupportable);
            strength += (float)Math.min(art, artSupport);
        }
        return strength;
    }

    public static Territory findFactoryTerritory(GameData data, PlayerID player, float risk, boolean buyfactory, boolean onWater) {
        BattleDelegate delegate = DelegateFinder.battleDelegate(data);
        CompositeMatchAnd<Territory> enemyNoWater = new CompositeMatchAnd<Territory>(Matches.TerritoryIsNotImpassableToLandUnits(player, data), Matches.isTerritoryEnemyAndNotUnownedWaterOrImpassibleOrRestricted(player, data));
        CompositeMatchAnd<Territory> alliedNoWater = new CompositeMatchAnd<Territory>(Matches.TerritoryIsNotImpassableToLandUnits(player, data), Matches.isTerritoryAllied(player, data));
        CompositeMatchAnd<Territory> endConditionEnemyLand = new CompositeMatchAnd<Territory>(Matches.isTerritoryEnemy(player, data), Matches.TerritoryIsNotImpassable, Matches.TerritoryIsLand);
        CompositeMatchAnd<Territory> routeConditionLand = new CompositeMatchAnd<Territory>(Matches.isTerritoryAllied(player, data), Matches.TerritoryIsNotImpassable, Matches.TerritoryIsLand);
        List<Territory> owned = SUtils.allOurTerritories(data, player);
        List<Territory> existingFactories = SUtils.findTersWithUnitsMatching(data, player, Matches.UnitCanProduceUnits);
        owned.removeAll(existingFactories);
        List<Territory> isWaterConvoy = SUtils.onlyWaterTerr(data, owned);
        owned.removeAll(isWaterConvoy);
        ArrayList<Territory> cloneFactTerritories = new ArrayList<Territory>(owned);
        for (Territory deleteBad : cloneFactTerritories) {
            if (!delegate.getBattleTracker().wasConquered(deleteBad)) continue;
            owned.remove(deleteBad);
        }
        Collections.shuffle(owned);
        if (onWater) {
            List<Territory> waterOwned = SUtils.stripLandLockedTerr(data, owned);
            owned.retainAll(waterOwned);
            if (owned.isEmpty()) {
                return null;
            }
            IntegerMap<Territory> terrProd = new IntegerMap<Territory>();
            for (Territory prodTerr : owned) {
                Route r;
                int territoryValue = 0;
                if (SUtils.hasLandRouteToEnemyOwnedCapitol(prodTerr, player, data)) {
                    territoryValue += 2;
                }
                if (SUtils.findNearest(prodTerr, Matches.territoryIsEnemyNonNeutralAndHasEnemyUnitMatching(data, player, Matches.UnitCanProduceUnits), Matches.TerritoryIsNotImpassableToLandUnits(player, data), data) != null) {
                    territoryValue += 2;
                }
                territoryValue = (r = SUtils.findNearest(prodTerr, endConditionEnemyLand, routeConditionLand, data)) != null ? (territoryValue += 10 - r.getLength()) : ((r = SUtils.findNearest(prodTerr, endConditionEnemyLand, Matches.TerritoryIsWater, data)) != null ? (territoryValue += 8 - r.getLength()) : (territoryValue -= 115));
                territoryValue += 4 * TerritoryAttachment.get(prodTerr).getProduction();
                List<Territory> weOwnAll = SUtils.getNeighboringEnemyLandTerritories(data, player, prodTerr);
                List<Territory> isWater = SUtils.onlyWaterTerr(data, weOwnAll);
                weOwnAll.removeAll(isWater);
                Iterator<Territory> weOwnAllIter = weOwnAll.iterator();
                while (weOwnAllIter.hasNext()) {
                    Territory tempFact = weOwnAllIter.next();
                    if (!Matches.TerritoryIsNeutralButNotWater.match(tempFact) && !Matches.TerritoryIsImpassable.match(tempFact)) continue;
                    weOwnAllIter.remove();
                }
                territoryValue -= 15 * weOwnAll.size();
                if (TerritoryAttachment.get(prodTerr).getProduction() < 2 || Matches.TerritoryIsImpassable.match(prodTerr)) {
                    territoryValue -= 100;
                }
                if (TerritoryAttachment.get(prodTerr).getProduction() < 1 || Matches.TerritoryIsImpassable.match(prodTerr)) {
                    territoryValue -= 100;
                }
                terrProd.put(prodTerr, territoryValue);
            }
            SUtils.reorder(owned, terrProd, true);
            return owned.get(0);
        }
        IntegerMap<Territory> terrProd = new IntegerMap<Territory>();
        for (Territory prodTerr : owned) {
            int dist;
            int territoryValue = 0;
            if (SUtils.hasLandRouteToEnemyOwnedCapitol(prodTerr, player, data)) {
                territoryValue += 3;
            }
            if (SUtils.findNearest(prodTerr, Matches.territoryIsEnemyNonNeutralAndHasEnemyUnitMatching(data, player, Matches.UnitCanProduceUnits), Matches.TerritoryIsNotImpassableToLandUnits(player, data), data) != null) {
                ++territoryValue;
            }
            if ((dist = SUtils.distanceToEnemy(prodTerr, data, player, false)) != 0) {
                territoryValue += 10 - dist;
            } else {
                dist = SUtils.distanceToEnemy(prodTerr, data, player, true);
                territoryValue += 5 - dist;
            }
            terrProd.put(prodTerr, territoryValue += 4 * TerritoryAttachment.get(prodTerr).getProduction());
        }
        SUtils.reorder(owned, terrProd, true);
        Territory minTerr = null;
        IntegerMap<Territory> prodMap = new IntegerMap<Territory>();
        for (Territory factTerr : existingFactories) {
            prodMap.put(factTerr, TerritoryAttachment.get(factTerr).getProduction());
        }
        for (Territory t : owned) {
            int puValue = TerritoryAttachment.get(t).getProduction();
            if (puValue < 2 || Matches.territoryIsOwnedAndHasOwnedUnitMatching(data, player, Matches.UnitCanProduceUnits).match(t)) continue;
            List<Territory> weOwnAll = SUtils.getNeighboringEnemyLandTerritories(data, player, t);
            List<Territory> isWater = SUtils.onlyWaterTerr(data, weOwnAll);
            weOwnAll.removeAll(isWater);
            Iterator<Territory> weOwnAllIter = weOwnAll.iterator();
            while (weOwnAllIter.hasNext()) {
                Territory tempFact = weOwnAllIter.next();
                if (!Matches.TerritoryIsNeutralButNotWater.match(tempFact) && !Matches.TerritoryIsImpassable.match(tempFact)) continue;
                weOwnAllIter.remove();
            }
            if (weOwnAll.size() > 0) continue;
            List<Territory> twoAway = SUtils.getExactNeighbors(t, 2, player, data, false);
            List<Territory> threeAway = SUtils.getExactNeighbors(t, 3, player, data, false);
            List<Territory> closeAllies = SUtils.getNeighboringLandTerritories(data, player, t);
            float tStrength = SUtils.strength(t.getUnits().getMatches(Matches.unitIsOwnedBy(player)), false, false, false);
            for (Territory cA : closeAllies) {
                tStrength += SUtils.strength(cA.getUnits().getMatches(Matches.alliedUnit(player, data)), false, false, false);
            }
            boolean badIdea = false;
            float twoCheckStrength = 0.0f;
            float threeCheckStrength = 0.0f;
            for (Territory twoCheck : twoAway) {
                if (!Matches.territoryHasEnemyUnits(player, data).match(twoCheck)) continue;
                twoCheckStrength += SUtils.strength(twoCheck.getUnits().getMatches(Matches.enemyUnit(player, data)), true, false, false);
            }
            if (twoCheckStrength > (float)puValue * 3.0f + tStrength) {
                badIdea = true;
            }
            for (Territory threeCheck : threeAway) {
                if (!Matches.territoryHasEnemyUnits(player, data).match(threeCheck)) continue;
                threeCheckStrength += SUtils.strength(threeCheck.getUnits().getMatches(Matches.enemyUnit(player, data)), true, false, false);
            }
            if (twoCheckStrength + threeCheckStrength > ((float)puValue * 8.0f + tStrength) * 4.0f) {
                badIdea = true;
            }
            if (badIdea) continue;
            Route nearEnemyRoute = SUtils.findNearest(t, enemyNoWater, alliedNoWater, data);
            Route factoryRoute = SUtils.findNearest(t, Matches.territoryIsEnemyNonNeutralAndHasEnemyUnitMatching(data, player, Matches.UnitCanProduceUnits), Matches.TerritoryIsNotImpassableToLandUnits(player, data), data);
            if (nearEnemyRoute == null || factoryRoute == null) continue;
            int factoryLength = factoryRoute.getLength();
            if (!buyfactory || !SUtils.hasLandRouteToEnemyOwnedCapitol(t, player, data) || factoryLength > 8) continue;
            minTerr = t;
            return minTerr;
        }
        buyfactory = false;
        return minTerr;
    }

    public static List<Territory> getExactNeighbors(Territory territory, int distance, PlayerID player, GameData data, boolean neutral) {
        CompositeMatchAnd<Territory> endCond = new CompositeMatchAnd<Territory>(Matches.TerritoryIsImpassable.invert());
        if (!neutral || Properties.getNeutralsImpassable(data)) {
            endCond.add(Matches.TerritoryIsNeutralButNotWater.invert());
        }
        return SUtils.findFontier(territory, endCond, Match.ALWAYS_MATCH, distance, data);
    }

    public static boolean RouteHasNoWater(Route testRoute) {
        int routeLength = testRoute.getLength();
        boolean nowater = true;
        for (int i = 0; i < routeLength; ++i) {
            Territory t = testRoute.getTerritories().get(i);
            if (!t.isWater()) continue;
            nowater = false;
        }
        return nowater;
    }

    public static Territory findASeaTerritoryToPlaceOn(Territory landTerr, GameData data, PlayerID player, boolean tFirst) {
        float ourStrength;
        CompositeMatchAnd<Territory> ourSeaTerr = new CompositeMatchAnd<Territory>(Matches.TerritoryIsWater, Matches.territoryHasUnitsOwnedBy(player));
        CompositeMatchAnd seaUnit = new CompositeMatchAnd(Matches.unitIsOwnedBy(player), Matches.UnitIsSea);
        CompositeMatchAnd airUnit = new CompositeMatchAnd(Matches.unitIsOwnedBy(player), Matches.UnitIsAir);
        CompositeMatchOr<Unit> seaAirUnit = new CompositeMatchOr<Unit>(seaUnit, airUnit);
        Territory seaPlaceAt = null;
        Territory bestSeaPlaceAt = null;
        Territory xPlace = null;
        if (landTerr == null) {
            return seaPlaceAt;
        }
        Set<Territory> seaNeighbors = data.getMap().getNeighbors(landTerr, ourSeaTerr);
        float minStrength = 1000.0f;
        float maxStrength = -1000.0f;
        for (Territory t : seaNeighbors) {
            float enemyStrength = SUtils.getStrengthOfPotentialAttackers(t, data, player, tFirst, true, null);
            float extraEnemy = SUtils.strength(t.getUnits().getMatches(Matches.enemyUnit(player, data)), true, true, tFirst);
            enemyStrength += extraEnemy;
            ourStrength = SUtils.strength(t.getUnits().getMatches(seaAirUnit), false, true, tFirst);
            float existingStrength = SUtils.strength(t.getUnits().getMatches(Matches.alliedUnit(player, data)), false, true, tFirst);
            float strengthDiff = enemyStrength - (ourStrength += existingStrength);
            if (strengthDiff < minStrength && ourStrength > 0.0f) {
                seaPlaceAt = t;
                minStrength = strengthDiff;
            }
            if (!(strengthDiff > maxStrength) || !(strengthDiff < 3.0f) || !(ourStrength > 0.0f) && !(existingStrength > 0.0f)) continue;
            bestSeaPlaceAt = t;
            maxStrength = strengthDiff;
        }
        if (seaPlaceAt == null && bestSeaPlaceAt == null) {
            Set<Territory> seaNeighbors2 = data.getMap().getNeighbors(landTerr, Matches.TerritoryIsWater);
            for (Territory t : seaNeighbors2) {
                float enemyStrength = SUtils.getStrengthOfPotentialAttackers(t, data, player, tFirst, true, null);
                ourStrength = SUtils.strength(t.getUnits().getMatches(seaAirUnit), false, true, tFirst);
                if (t.getUnits().someMatch(Matches.enemyUnit(player, data))) {
                    xPlace = t;
                    continue;
                }
                if (!(enemyStrength - ourStrength < minStrength)) continue;
                seaPlaceAt = t;
                minStrength = enemyStrength - ourStrength;
            }
        }
        if (seaPlaceAt == null && bestSeaPlaceAt == null && xPlace != null) {
            seaPlaceAt = xPlace;
        }
        if (bestSeaPlaceAt == null) {
            return seaPlaceAt;
        }
        return bestSeaPlaceAt;
    }

    public static float inviteBBEscort(Territory goTerr, float remainingStrengthNeeded, Collection<Unit> unitsAlreadyMoved, List<Collection<Unit>> moveUnits, List<Route> moveRoutes, GameData data, PlayerID player) {
        CompositeMatchAnd<Unit> BBUnit = new CompositeMatchAnd<Unit>(Matches.unitIsOwnedBy(player), Matches.unitCanBombard(player), Matches.UnitCanMove, Matches.unitHasMovementLeft);
        float BBStrength = 0.0f;
        List<Territory> BBTerr = SUtils.findOurShips(goTerr, data, player, BBUnit);
        for (Territory BBT : BBTerr) {
            List<Unit> BBUnits = BBT.getUnits().getMatches(BBUnit);
            BBUnits.removeAll(unitsAlreadyMoved);
            if (BBUnits.isEmpty()) continue;
            ArrayList<Unit> BBAddUnits = new ArrayList<Unit>();
            if (BBT == goTerr) {
                Iterator<Unit> BBIter = BBUnits.iterator();
                while (BBIter.hasNext() && BBStrength < remainingStrengthNeeded) {
                    Unit BB = BBIter.next();
                    UnitAttachment ua = UnitAttachment.get(BB.getType());
                    BBStrength += (float)(ua.getAttack(player) * ua.getAttackRolls(player));
                    unitsAlreadyMoved.add(BB);
                }
                continue;
            }
            int BBDistance = MoveValidator.getLeastMovement(BBUnits);
            Route BBRoute = SUtils.getMaxSeaRoute(data, BBT, goTerr, player, true, BBDistance);
            if (BBRoute == null || BBRoute.getEnd() == null || BBRoute.getEnd() != goTerr) continue;
            Iterator<Unit> BBIter = BBUnits.iterator();
            while (BBIter.hasNext() && BBStrength < remainingStrengthNeeded) {
                Unit BB = BBIter.next();
                UnitAttachment ua = UnitAttachment.get(BB.getType());
                BBStrength += (float)(ua.getAttack(player) * ua.getAttackRolls(player));
                BBAddUnits.add(BB);
            }
            if (BBAddUnits.size() <= 0) continue;
            moveUnits.add(BBAddUnits);
            moveRoutes.add(BBRoute);
            unitsAlreadyMoved.addAll(BBAddUnits);
        }
        return BBStrength;
    }

    public static float inviteShipAttack(Territory eTerr, float remainingStrengthNeeded, Collection<Unit> unitsAlreadyMoved, List<Collection<Unit>> moveUnits, List<Route> moveRoutes, GameData data, PlayerID player, boolean attacking, boolean tFirst, boolean includeTransports) {
        return SUtils.inviteShipAttack(eTerr, remainingStrengthNeeded, unitsAlreadyMoved, moveUnits, moveRoutes, data, player, attacking, tFirst, includeTransports, null);
    }

    public static float inviteShipAttack(Territory eTerr, float remainingStrengthNeeded, Collection<Unit> unitsAlreadyMoved, List<Collection<Unit>> moveUnits, List<Route> moveRoutes, GameData data, PlayerID player, boolean attacking, boolean tFirst, boolean includeTransports, Match<Unit> types) {
        BattleDelegate battleD = DelegateFinder.battleDelegate(data);
        CompositeMatchAnd<Unit> ownedSeaUnit = new CompositeMatchAnd<Unit>(Matches.unitIsOwnedBy(player), Matches.UnitIsSea, Matches.UnitCanMove, Matches.unitHasMovementLeft);
        CompositeMatchAnd ownedAirUnit = new CompositeMatchAnd(Matches.unitIsOwnedBy(player), Matches.UnitIsAir, Matches.UnitCanLandOnCarrier, Matches.UnitCanMove, Matches.unitHasMovementLeft);
        if (types != null) {
            ownedSeaUnit = new CompositeMatchAnd(types, ownedSeaUnit);
            ownedAirUnit = new CompositeMatchAnd(types, ownedAirUnit);
        }
        CompositeMatchAnd carrierUnit = new CompositeMatchAnd(ownedSeaUnit, Matches.UnitIsCarrier, Matches.UnitCanMove, Matches.unitHasMovementLeft);
        CompositeMatchOr<Unit> carrierAndFighters = new CompositeMatchOr<Unit>(carrierUnit, ownedAirUnit);
        CompositeMatchAnd<Unit> ownedSeaUnitSansTransports = new CompositeMatchAnd<Unit>(ownedSeaUnit, Matches.UnitIsNotTransport, Matches.UnitCanMove, Matches.unitHasMovementLeft);
        if (types != null) {
            ownedSeaUnit = new CompositeMatchAnd(types, ownedSeaUnit);
        }
        HashMap<Territory, Float> attackShipMap = new HashMap<Territory, Float>();
        HashMap<Territory, ArrayList<Unit>> attackUnitMap = new HashMap<Territory, ArrayList<Unit>>();
        HashMap<Territory, ArrayList<Unit>> carrierUnitMap = new HashMap<Territory, ArrayList<Unit>>();
        List<Territory> possibleShipTerr = SUtils.findTersWithUnitsMatching(data, player, ownedSeaUnit);
        Iterator<Territory> pSIter = possibleShipTerr.iterator();
        while (pSIter.hasNext()) {
            Territory countX = pSIter.next();
            if (!Matches.TerritoryIsLand.match(countX) && !battleD.getBattleTracker().wasBattleFought(countX)) continue;
            pSIter.remove();
        }
        Iterator<Territory> pSIter2 = possibleShipTerr.iterator();
        while (pSIter2.hasNext()) {
            Territory shipTerr = pSIter2.next();
            float terrStrength = 0.0f;
            ArrayList<Unit> attackShips = new ArrayList<Unit>();
            ArrayList<Unit> carrierShips = new ArrayList<Unit>();
            if (includeTransports) {
                attackShips.addAll(shipTerr.getUnits().getMatches(ownedSeaUnit));
            } else {
                attackShips.addAll(shipTerr.getUnits().getMatches(ownedSeaUnitSansTransports));
            }
            int maxShipDistance = 0;
            attackShips.removeAll(unitsAlreadyMoved);
            carrierShips.addAll(shipTerr.getUnits().getMatches(carrierAndFighters));
            carrierShips.removeAll(unitsAlreadyMoved);
            attackShips.removeAll(carrierShips);
            if (attackShips.isEmpty() && carrierShips.isEmpty()) {
                pSIter2.remove();
                continue;
            }
            maxShipDistance = !attackShips.isEmpty() ? MoveValidator.getMaxMovement(attackShips) : MoveValidator.getMaxMovement(carrierShips);
            Route thisRoute = SUtils.getMaxSeaRoute(data, shipTerr, eTerr, player, attacking, maxShipDistance);
            if (thisRoute == null || thisRoute.getEnd() != eTerr) {
                pSIter2.remove();
                continue;
            }
            if (carrierShips.size() > 0 && MoveValidator.hasEnoughMovement(carrierShips, thisRoute)) {
                terrStrength += SUtils.strength(carrierShips, attacking, true, tFirst);
            }
            Iterator aSIter = attackShips.iterator();
            while (aSIter.hasNext()) {
                Unit attackShip = (Unit)aSIter.next();
                if (MoveValidator.hasEnoughMovement(attackShip, thisRoute)) {
                    terrStrength += SUtils.uStrength(attackShip, attacking, true, tFirst);
                    continue;
                }
                aSIter.remove();
            }
            carrierUnitMap.put(shipTerr, carrierShips);
            attackUnitMap.put(shipTerr, attackShips);
            attackShipMap.put(shipTerr, Float.valueOf(terrStrength));
        }
        SUtils.reorder(possibleShipTerr, attackShipMap, false);
        float unitStrength = 0.0f;
        for (Territory addShipTerr : possibleShipTerr) {
            List theseUnits = (List)attackUnitMap.get(addShipTerr);
            List otherUnits = (List)carrierUnitMap.get(addShipTerr);
            if (theseUnits.isEmpty() && otherUnits.isEmpty()) continue;
            int maxUnitDistance = 0;
            maxUnitDistance = !theseUnits.isEmpty() ? MoveValidator.getMaxMovement(theseUnits) : MoveValidator.getMaxMovement(otherUnits);
            Route newRoute = SUtils.getMaxSeaRoute(data, addShipTerr, eTerr, player, attacking, maxUnitDistance);
            if (newRoute == null || newRoute.getEnd() == null || newRoute.getEnd() != eTerr || !(remainingStrengthNeeded > unitStrength)) continue;
            if (!theseUnits.isEmpty()) {
                moveUnits.add(theseUnits);
                moveRoutes.add(newRoute);
                unitsAlreadyMoved.addAll(theseUnits);
                unitStrength += SUtils.strength(theseUnits, attacking, true, tFirst);
            }
            if (!(remainingStrengthNeeded > unitStrength) || otherUnits.isEmpty()) continue;
            moveUnits.add(otherUnits);
            moveRoutes.add(newRoute);
            unitsAlreadyMoved.addAll(otherUnits);
            unitStrength += SUtils.strength(otherUnits, attacking, true, tFirst);
        }
        return unitStrength;
    }

    public static float inviteTransports(boolean noncombat, Territory target, float remainingStrengthNeeded, Collection<Unit> unitsAlreadyMoved, List<Collection<Unit>> moveUnits, List<Route> moveRoutes, GameData data, PlayerID player, boolean tFirst, boolean allowEnemy, List<Territory> seaTerrAttacked) {
        TransportTracker tracker = DelegateFinder.moveDelegate(data).getTransportTracker();
        CompositeMatchAnd airUnits = new CompositeMatchAnd(Matches.UnitCanLandOnCarrier, Matches.unitIsOwnedBy(player), Matches.UnitCanMove, Matches.unitHasMovementLeft);
        CompositeMatchAnd escortShip = new CompositeMatchAnd(Matches.UnitIsSea, Matches.UnitIsNotTransport, Matches.unitIsOwnedBy(player), Matches.UnitCanMove, Matches.unitHasMovementLeft);
        CompositeMatchOr<Unit> escortUnit = new CompositeMatchOr<Unit>(airUnits, escortShip);
        CompositeMatchAnd<Unit> transportingUnitWithLoad = new CompositeMatchAnd<Unit>(Matches.UnitIsTransport, Matches.unitIsOwnedBy(player), Matches.UnitCanMove, Matches.unitHasMovementLeft, Matches.transportIsTransporting());
        Set<Territory> tCopy = data.getMap().getNeighbors(target, 3);
        ArrayList<Territory> testCapNeighbors = new ArrayList<Territory>(tCopy);
        ArrayList<Territory> waterNeighbors = new ArrayList<Territory>();
        ArrayList<Territory> alreadyMovedFrom = new ArrayList<Territory>();
        List<Territory> myFactories = SUtils.findTersWithUnitsMatching(data, player, Matches.UnitCanProduceUnits);
        ArrayList<Territory> waterFactoryNeighbors = new ArrayList<Territory>();
        for (Territory myFactory : myFactories) {
            Set<Territory> wFN = data.getMap().getNeighbors(myFactory, Matches.TerritoryIsWater);
            waterFactoryNeighbors.addAll(wFN);
        }
        for (Territory firstWaterCheck : tCopy) {
            if (!firstWaterCheck.isWater()) {
                testCapNeighbors.remove(firstWaterCheck);
                continue;
            }
            if (data.getMap().getDistance(target, firstWaterCheck) != 1) continue;
            waterNeighbors.add(firstWaterCheck);
            testCapNeighbors.remove(firstWaterCheck);
        }
        int waterSize = waterNeighbors.size();
        for (int i = 0; i < waterSize - 1; ++i) {
            for (int j = i + 1; j < waterSize; ++j) {
                Territory iTerr = (Territory)waterNeighbors.get(i);
                Territory jTerr = (Territory)waterNeighbors.get(j);
                if (waterFactoryNeighbors.contains(iTerr) || !waterFactoryNeighbors.contains(jTerr)) continue;
                waterNeighbors.remove(jTerr);
                waterNeighbors.remove(iTerr);
                waterNeighbors.add(i, jTerr);
                waterNeighbors.add(j, iTerr);
            }
        }
        float unitStrength = 0.0f;
        for (Territory waterCheck : waterNeighbors) {
            float strengthAtTarget = SUtils.getStrengthOfPotentialAttackers(waterCheck, data, player, tFirst, false, seaTerrAttacked);
            float shipStrength = 0.0f;
            if (Matches.territoryHasOwnedTransportingUnits(player).match(waterCheck)) {
                ArrayList<Unit> tUnits = new ArrayList<Unit>();
                List<Unit> tranUnits = waterCheck.getUnits().getMatches(transportingUnitWithLoad);
                tranUnits.removeAll(unitsAlreadyMoved);
                List<Unit> escorts = waterCheck.getUnits().getMatches(escortUnit);
                escorts.removeAll(unitsAlreadyMoved);
                for (Unit xTran : tranUnits) {
                    if (!(remainingStrengthNeeded > unitStrength)) continue;
                    Collection<Unit> loadOne = tracker.transporting(xTran);
                    unitStrength += SUtils.strength(loadOne, true, false, false);
                    tUnits.add(xTran);
                }
                if (tFirst) {
                    shipStrength += SUtils.strength(tUnits, false, true, tFirst);
                }
                if (shipStrength < strengthAtTarget) {
                    for (Unit testEscort : escorts) {
                        if (!(shipStrength < strengthAtTarget)) continue;
                        shipStrength += SUtils.uStrength(testEscort, false, true, tFirst);
                        tUnits.add(testEscort);
                    }
                }
                if (tUnits.size() > 0) {
                    unitsAlreadyMoved.addAll(tUnits);
                }
            }
            for (Territory otherSource : testCapNeighbors) {
                int maxDistance;
                Route sRoute;
                if (alreadyMovedFrom.contains(otherSource)) continue;
                alreadyMovedFrom.add(otherSource);
                List<Unit> tranUnits = otherSource.getUnits().getMatches(transportingUnitWithLoad);
                tranUnits.removeAll(unitsAlreadyMoved);
                if (tranUnits.isEmpty() || (sRoute = SUtils.getMaxSeaRoute(data, otherSource, waterCheck, player, allowEnemy, maxDistance = MoveValidator.getMaxMovement(tranUnits))) == null || sRoute.getEnd() != waterCheck) continue;
                int newDist = sRoute.getLength();
                Iterator<Unit> tranIter = tranUnits.iterator();
                while (tranIter.hasNext()) {
                    Unit thisTran = tranIter.next();
                    TripleAUnit ta = TripleAUnit.get(thisTran);
                    if (ta.getMovementLeft() < newDist) {
                        tranIter.remove();
                        continue;
                    }
                    if (tracker.isTransporting(thisTran)) continue;
                    tranIter.remove();
                }
                List<Unit> escorts = otherSource.getUnits().getMatches(escortUnit);
                escorts.removeAll(unitsAlreadyMoved);
                Iterator<Unit> escortIter = escorts.iterator();
                while (escortIter.hasNext()) {
                    Unit thisEscort = escortIter.next();
                    if (!Matches.unitHasMoved.match(thisEscort)) continue;
                    escortIter.remove();
                }
                ArrayList<Unit> allUnits = new ArrayList<Unit>();
                for (Unit xTran : tranUnits) {
                    if (!(remainingStrengthNeeded > unitStrength)) continue;
                    Collection<Unit> loadOne = tracker.transporting(xTran);
                    unitStrength += SUtils.strength(loadOne, true, false, false);
                    allUnits.add(xTran);
                    allUnits.addAll(loadOne);
                    if (!tFirst) continue;
                    shipStrength += SUtils.uStrength(xTran, false, true, tFirst);
                }
                if (shipStrength < strengthAtTarget) {
                    for (Unit eUnit : escorts) {
                        if (!(shipStrength < strengthAtTarget)) continue;
                        shipStrength += SUtils.uStrength(eUnit, false, true, tFirst);
                        allUnits.add(eUnit);
                    }
                }
                if (allUnits.size() <= 0) continue;
                moveUnits.add(allUnits);
                moveRoutes.add(sRoute);
                unitsAlreadyMoved.addAll(allUnits);
            }
        }
        return unitStrength;
    }

    public static float invitePlaneAttack(boolean noncombat, boolean fightersOnly, Territory target, float remainingStrengthNeeded, Collection<Unit> unitsAlreadyMoved, List<Collection<Unit>> moveUnits, List<Route> moveRoutes, GameData data, PlayerID player) {
        boolean canLand;
        List<Object> allAirUnits;
        int rDist;
        Route thisRoute;
        ArrayList<Unit> tmpUnits2;
        CompositeMatchAnd<Unit> airUnit = new CompositeMatchAnd<Unit>(Matches.unitIsOwnedBy(player), Matches.UnitIsAir, Matches.UnitCanMove, Matches.unitHasMovementLeft);
        CompositeMatchAnd<Unit> fighterUnit = new CompositeMatchAnd<Unit>(Matches.unitIsOwnedBy(player), Matches.UnitCanLandOnCarrier, Matches.UnitCanMove, Matches.unitHasMovementLeft);
        CompositeMatchAnd<Unit> carrierUnit = new CompositeMatchAnd<Unit>(Matches.unitIsOwnedBy(player), Matches.UnitIsCarrier, Matches.UnitCanMove, Matches.unitHasMovementLeft);
        List<Territory> planeTerr = SUtils.findOurPlanes(target, data, player);
        ArrayList<Territory> planeOnWater = new ArrayList<Territory>(planeTerr);
        for (Territory qP : planeTerr) {
            if (!Matches.TerritoryIsLand.match(qP)) continue;
            planeOnWater.remove(qP);
        }
        int availSpace = 0;
        List<Unit> ACUnits = target.getUnits().getMatches(carrierUnit);
        List<Unit> fightersOnAC = target.getUnits().getMatches(fighterUnit);
        boolean isWater = target.isWater();
        float committedStrength = 0.0f;
        if (isWater) {
            if (noncombat) {
                availSpace = ACUnits.size() * 2 - fightersOnAC.size();
            }
            for (Territory owned : planeOnWater) {
                if (noncombat && availSpace <= 0) continue;
                tmpUnits2 = new ArrayList();
                if (!(remainingStrengthNeeded > committedStrength) || Matches.territoryHasEnemyUnits(player, data).match(owned) && !noncombat || (thisRoute = data.getMap().getRoute(owned, target, Matches.TerritoryIsNotImpassable)) == null) continue;
                rDist = thisRoute.getLength();
                allAirUnits = owned.getUnits().getMatches(fighterUnit);
                for (Unit unit : allAirUnits) {
                    if (unit == null || noncombat != availSpace > 0 || !MoveValidator.hasEnoughMovement(unit, rDist) || unitsAlreadyMoved.contains(unit) || !(remainingStrengthNeeded > committedStrength)) continue;
                    canLand = SUtils.airUnitIsLandable(unit, owned, target, player, data);
                    if (noncombat && fightersOnly && availSpace > 0) {
                        canLand = true;
                    }
                    if (!canLand) continue;
                    committedStrength += SUtils.airstrength(unit, true);
                    tmpUnits2.add(unit);
                    if (!noncombat) continue;
                    --availSpace;
                }
                if (tmpUnits2.size() <= 0) continue;
                moveRoutes.add(thisRoute);
                moveUnits.add(tmpUnits2);
                unitsAlreadyMoved.addAll(tmpUnits2);
            }
            planeTerr.removeAll(planeOnWater);
        }
        for (Territory owned : planeTerr) {
            if (noncombat && isWater && availSpace <= 0) continue;
            tmpUnits2 = new ArrayList<Unit>();
            if (!(remainingStrengthNeeded > committedStrength) || Matches.territoryHasEnemyUnits(player, data).match(owned) || (thisRoute = data.getMap().getRoute(owned, target, Matches.TerritoryIsNotImpassable)) == null) continue;
            rDist = thisRoute.getLength();
            allAirUnits = new ArrayList();
            if (fightersOnly) {
                allAirUnits.addAll(owned.getUnits().getMatches(fighterUnit));
            } else {
                allAirUnits = owned.getUnits().getMatches(airUnit);
            }
            for (Unit unit : allAirUnits) {
                if (unit == null || !MoveValidator.hasEnoughMovement(unit, rDist) || unitsAlreadyMoved.contains(unit)) continue;
                canLand = SUtils.airUnitIsLandable(unit, owned, target, player, data);
                if (noncombat && !isWater) {
                    canLand = true;
                } else if (noncombat && fightersOnly && availSpace > 0) {
                    canLand = true;
                }
                if (!canLand || !(remainingStrengthNeeded > committedStrength)) continue;
                committedStrength += SUtils.airstrength(unit, true);
                tmpUnits2.add(unit);
                if (!noncombat || !fightersOnly || !isWater) continue;
                --availSpace;
            }
            if (tmpUnits2.size() <= 0) continue;
            moveRoutes.add(thisRoute);
            moveUnits.add(tmpUnits2);
            unitsAlreadyMoved.addAll(tmpUnits2);
        }
        remainingStrengthNeeded -= committedStrength;
        return committedStrength;
    }

    public static float inviteLandAttack(boolean nonCombat, Territory enemy, float remainingStrengthNeeded, Collection<Unit> unitsAlreadyMoved, List<Collection<Unit>> moveUnits, List<Route> moveRoutes, GameData data, PlayerID player, boolean attacking, boolean forced, List<Territory> alreadyAttacked) {
        CompositeMatchAnd<Unit> landUnit = new CompositeMatchAnd<Unit>(Matches.unitIsOwnedBy(player), Matches.UnitIsLand, Matches.UnitIsNotAA, Matches.UnitCanMove, Matches.UnitIsNotInfrastructure, Matches.unitHasMovementLeft, Matches.UnitCanNotMoveDuringCombatMove.invert());
        List<Territory> ourLandNeighbors = SUtils.getNeighboringLandTerritories(data, player, enemy);
        float totStrength = 0.0f;
        int totList = ourLandNeighbors.size();
        for (int i = 0; i < totList - 1; ++i) {
            for (int j = i + 1; j < totList; ++j) {
                Territory iTerr = ourLandNeighbors.get(i);
                Territory jTerr = ourLandNeighbors.get(j);
                int jUnits = 0;
                int iUnits = 0;
                Set<Territory> jTerrNeighbors = data.getMap().getNeighbors(jTerr, Matches.territoryHasEnemyUnits(player, data));
                jTerrNeighbors.removeAll(alreadyAttacked);
                Set<Territory> iTerrNeighbors = data.getMap().getNeighbors(iTerr, Matches.territoryHasEnemyUnits(player, data));
                iTerrNeighbors.removeAll(alreadyAttacked);
                for (Territory jT : jTerrNeighbors) {
                    jUnits += jT.getUnits().countMatches(Matches.enemyUnit(player, data));
                }
                for (Territory iT : iTerrNeighbors) {
                    iUnits += iT.getUnits().countMatches(Matches.enemyUnit(player, data));
                }
                if (jUnits >= iUnits) continue;
                ourLandNeighbors.remove(j);
                ourLandNeighbors.remove(i);
                ourLandNeighbors.add(i, jTerr);
                ourLandNeighbors.add(j, iTerr);
            }
        }
        for (Territory invadeFrom : ourLandNeighbors) {
            List<Unit> ourAttackUnits = invadeFrom.getUnits().getMatches(landUnit);
            ourAttackUnits.removeAll(unitsAlreadyMoved);
            List<Unit> ourSortedUnits = SUtils.sortTransportUnits(ourAttackUnits);
            ArrayList<Unit> attackUnits = new ArrayList<Unit>();
            Route attackRoute = data.getMap().getLandRoute(invadeFrom, enemy);
            if (attackRoute == null) continue;
            Iterator<Unit> sortIter = ourSortedUnits.iterator();
            while (sortIter.hasNext() && remainingStrengthNeeded > totStrength) {
                float aStrength = 0.0f;
                Unit attackUnit = sortIter.next();
                if (Matches.UnitTypeIsInfantry.match(attackUnit.getType()) && sortIter.hasNext()) {
                    Unit attackUnit2 = sortIter.next();
                    ArrayList<Unit> twoUnits = new ArrayList<Unit>();
                    twoUnits.add(attackUnit);
                    twoUnits.add(attackUnit2);
                    aStrength = SUtils.strength(twoUnits, attacking, false, false);
                    totStrength += aStrength;
                    attackUnits.addAll(twoUnits);
                    continue;
                }
                aStrength = SUtils.uStrength(attackUnit, attacking, false, false);
                totStrength += aStrength;
                attackUnits.add(attackUnit);
            }
            if (attackUnits.isEmpty()) continue;
            moveUnits.add(attackUnits);
            moveRoutes.add(attackRoute);
            unitsAlreadyMoved.addAll(attackUnits);
        }
        return totStrength;
    }

    public static float inviteBlitzAttack(boolean nonCombat, Territory enemy, float remainingStrengthNeeded, Collection<Unit> unitsAlreadyMoved, List<Collection<Unit>> moveUnits, List<Route> moveRoutes, GameData data, PlayerID player, boolean attacking, boolean forced) {
        CompositeMatchAnd<Unit> blitzUnit = new CompositeMatchAnd<Unit>(Matches.unitIsOwnedBy(player), Matches.UnitCanBlitz, Matches.UnitCanMove, Matches.unitHasMovementLeft);
        CompositeMatchAnd<Territory> alliedAndNotWater = new CompositeMatchAnd<Territory>(Matches.isTerritoryAllied(player, data), Matches.TerritoryIsNotImpassableToLandUnits(player, data));
        CompositeMatchAnd<Territory> noEnemyUnitsAndNotWater = new CompositeMatchAnd<Territory>(Matches.territoryHasNoEnemyUnits(player, data), Matches.TerritoryIsNotImpassableToLandUnits(player, data));
        List<Territory> blitzFrom = SUtils.getExactNeighbors(enemy, 2, player, data, false);
        ArrayList<Territory> blitzCopy = new ArrayList<Territory>(blitzFrom);
        Route tRoute = null;
        float totStrength = 0.0f;
        for (Territory t : blitzCopy) {
            tRoute = nonCombat ? SUtils.getTwoRoute(t, enemy, alliedAndNotWater, null, data) : SUtils.getTwoRoute(t, enemy, noEnemyUnitsAndNotWater, null, data);
            if (tRoute != null && tRoute.getLength() <= 2) continue;
            blitzFrom.remove(t);
        }
        ArrayList<Unit> blitzUnits = new ArrayList<Unit>();
        float bStrength = 0.0f;
        if (forced) {
            for (Territory blitzTerr : blitzFrom) {
                blitzUnits.clear();
                ArrayList<Unit> tmpBlitz = new ArrayList<Unit>();
                blitzUnits.addAll(blitzTerr.getUnits().getMatches(blitzUnit));
                if (blitzUnits.isEmpty()) continue;
                Route blitzRoute = SUtils.getTwoRoute(blitzTerr, enemy, noEnemyUnitsAndNotWater, null, data);
                if (blitzRoute != null) {
                    for (Unit blitzer : blitzUnits) {
                        if (!(remainingStrengthNeeded > totStrength)) continue;
                        bStrength = SUtils.uStrength(blitzer, attacking, false, false);
                        totStrength += bStrength;
                        tmpBlitz.add(blitzer);
                    }
                    if (tmpBlitz.isEmpty()) continue;
                    moveUnits.add(tmpBlitz);
                    moveRoutes.add(blitzRoute);
                    unitsAlreadyMoved.addAll(tmpBlitz);
                }
                blitzUnits.clear();
            }
        } else {
            for (Territory blitzTerr : blitzFrom) {
                blitzUnits.clear();
                Set<Territory> badTerr = data.getMap().getNeighbors(blitzTerr, Matches.territoryHasEnemyLandUnits(player, data));
                if (!badTerr.isEmpty()) continue;
                blitzUnits.addAll(blitzTerr.getUnits().getMatches(blitzUnit));
                if (blitzUnits.isEmpty()) continue;
                ArrayList<Unit> tmpBlitz = new ArrayList<Unit>();
                Route blitzRoute = SUtils.getTwoRoute(blitzTerr, enemy, noEnemyUnitsAndNotWater, null, data);
                if (blitzRoute == null) continue;
                for (Unit blitzer : blitzUnits) {
                    if (!(remainingStrengthNeeded > totStrength) || unitsAlreadyMoved.contains(blitzer)) continue;
                    tmpBlitz.add(blitzer);
                    bStrength = SUtils.uStrength(blitzer, attacking, false, false);
                    totStrength += bStrength;
                }
                if (tmpBlitz.isEmpty()) continue;
                moveRoutes.add(blitzRoute);
                moveUnits.add(tmpBlitz);
                unitsAlreadyMoved.addAll(tmpBlitz);
                blitzUnits.clear();
            }
        }
        return totStrength;
    }

    public static Territory closestToEnemyCapital(List<Territory> ourTerr, GameData data, PlayerID player, boolean byLand) {
        List<Territory> enemyCap = SUtils.getEnemyCapitals(data, player);
        int thisDist = 0;
        int capDist = 100;
        Territory returnTerr = null;
        for (Territory checkTerr : ourTerr) {
            for (Territory eCap : enemyCap) {
                thisDist = byLand ? data.getMap().getDistance(checkTerr, eCap, Matches.TerritoryIsNotImpassableToLandUnits(player, data)) : data.getMap().getDistance(checkTerr, eCap);
                if (thisDist == -1 || thisDist >= capDist) continue;
                capDist = thisDist;
                returnTerr = checkTerr;
            }
        }
        return returnTerr;
    }

    public static Route getTwoRoute(Territory t1, Territory t2, Match<Territory> condition, List<Territory> blockedTerr, GameData data) {
        if (t1.equals(t2)) {
            return null;
        }
        Route r = new Route();
        r.setStart(t1);
        Set<Territory> circleMatch = data.getMap().getNeighbors(t1, condition);
        if (circleMatch.contains(t2)) {
            return null;
        }
        Set<Territory> checkTerr = data.getMap().getNeighbors(t2, condition);
        circleMatch.retainAll(checkTerr);
        boolean routeCompleted = false;
        Iterator<Territory> circleIter = circleMatch.iterator();
        while (circleIter.hasNext() && !routeCompleted) {
            Territory t3 = circleIter.next();
            if (blockedTerr != null && blockedTerr.contains(t3)) continue;
            r.add(t3);
            r.add(t2);
            routeCompleted = true;
        }
        if (r.getLength() != 2) {
            r = null;
        }
        return r;
    }

    public static float determineEnemyBlitzStrength(Territory blitzHere, List<Route> blitzTerrRoutes, List<Territory> blockTerr, GameData data, PlayerID ePlayer) {
        HashSet<Integer> ignore = new HashSet<Integer>();
        ignore.add(1);
        CompositeMatchAnd<Unit> blitzUnit = new CompositeMatchAnd<Unit>(Matches.unitIsOwnedBy(ePlayer), Matches.UnitCanBlitz, Matches.UnitCanMove);
        CompositeMatchAnd<Territory> validBlitzRoute = new CompositeMatchAnd<Territory>(Matches.territoryHasNoEnemyUnits(ePlayer, data), Matches.TerritoryIsNotImpassableToLandUnits(ePlayer, data));
        ArrayList<Route> routes = new ArrayList<Route>();
        List<Unit> blitzUnits = SUtils.findAttackers(blitzHere, 2, ignore, ePlayer, data, blitzUnit, validBlitzRoute, blockTerr, routes, false);
        for (Route r : routes) {
            if (r.getLength() != 2) continue;
            blitzTerrRoutes.add(r);
        }
        return SUtils.strength(blitzUnits, true, false, true);
    }

    public static boolean ListContainsOtherThanTransports(List<Unit> unitList) {
        Iterator<Unit> unitIter = unitList.iterator();
        boolean hasNonTransport = false;
        while (unitIter.hasNext() && !hasNonTransport) {
            Unit unit = unitIter.next();
            hasNonTransport = Matches.UnitIsNotTransport.match(unit);
        }
        return hasNonTransport;
    }

    public static void verifyMoves(List<Collection<Unit>> moveUnits, List<Route> moveRoutes, GameData data, PlayerID player) {
        Serializable thisRoute;
        ArrayList alreadyMoved = new ArrayList();
        Iterator<Collection<Unit>> moveIter = moveUnits.iterator();
        Iterator<Route> routeIter = moveRoutes.iterator();
        HashMap attackMap = new HashMap();
        HashMap<Integer, Territory> routeMap = new HashMap<Integer, Territory>();
        HashMap<Integer, Route> insertRoutes = new HashMap<Integer, Route>();
        int listCount = 0;
        while (moveIter.hasNext() && routeIter.hasNext()) {
            ++listCount;
            Collection<Unit> attackUnit = moveIter.next();
            Route attackRoute = routeIter.next();
            if (attackRoute == null || attackRoute.getEnd() == null) {
                moveIter.remove();
                routeIter.remove();
                continue;
            }
            Route newRoute = SUtils.repairRoute(attackUnit, attackRoute, data, player);
            if (newRoute == null) continue;
            routeIter.remove();
            insertRoutes.put(listCount, newRoute);
        }
        if (insertRoutes.size() > 0) {
            Set placeValues = insertRoutes.keySet();
            for (Integer thisone : placeValues) {
                thisRoute = (Route)insertRoutes.get(thisone);
                moveRoutes.add(thisone, (Route)thisRoute);
            }
        }
        Iterator<Collection<Unit>> moveIter2 = moveUnits.iterator();
        Iterator<Route> routeIter2 = moveRoutes.iterator();
        Integer routeCounter = 0;
        while (moveIter2.hasNext() && routeIter2.hasNext()) {
            Collection addUnits;
            thisRoute = routeCounter;
            Integer n = routeCounter = Integer.valueOf(routeCounter + 1);
            ArrayList<Unit> currentUnits = new ArrayList<Unit>();
            Collection<Unit> theseUnits = moveIter2.next();
            Route thisRoute2 = routeIter2.next();
            Territory target = thisRoute2.getEnd();
            if (attackMap.containsKey(target) && !(addUnits = (Collection)attackMap.get(target)).isEmpty()) {
                currentUnits.addAll(addUnits);
            }
            currentUnits.addAll(theseUnits);
            attackMap.put(target, currentUnits);
            routeMap.put(routeCounter, target);
        }
        Set targetTerrs = attackMap.keySet();
        for (Territory targetTerr : targetTerrs) {
            List<Unit> enemyUnits = targetTerr.getUnits().getMatches(Matches.enemyUnit(player, data));
            Collection ourUnits = (Collection)attackMap.get(targetTerr);
            boolean enemyUnitsExist = enemyUnits.size() > 0;
            if (!enemyUnitsExist || !targetTerr.isWater()) continue;
            Iterator unitIter = ourUnits.iterator();
            boolean nonTransport = false;
            while (unitIter.hasNext() && !nonTransport) {
                Unit thisUnit = (Unit)unitIter.next();
                if (alreadyMoved.contains(thisUnit) || !Matches.UnitIsNotTransport.match(thisUnit)) continue;
                nonTransport = true;
            }
            if (!nonTransport || ourUnits.isEmpty()) {
                int routeCounter2 = 0;
                ArrayList<Integer> deleteValues = new ArrayList<Integer>();
                for (Route xRoute : moveRoutes) {
                    if (xRoute.getEnd() == targetTerr) {
                        deleteValues.add(routeCounter2);
                    }
                    ++routeCounter2;
                }
                Iterator<Route> i$ = deleteValues.iterator();
                while (i$.hasNext()) {
                    int delOne = (Integer)((Object)i$.next());
                    moveUnits.remove(delOne);
                    moveRoutes.remove(delOne);
                }
                continue;
            }
            alreadyMoved.addAll(ourUnits);
        }
    }

    public static Route repairRoute(Collection<Unit> moveUnits, Route moveRoute, GameData data, PlayerID player) {
        boolean canMove = MoveValidator.hasEnoughMovement(moveUnits, moveRoute);
        if (!canMove) {
            Route newRoute = new Route();
            Iterator<Territory> routeIter = moveRoute.iterator();
            newRoute.setStart(routeIter.next());
            boolean routeDone = false;
            while (routeIter.hasNext()) {
                Territory nextTerr = routeIter.next();
                Route oldRoute = newRoute;
                newRoute.add(nextTerr);
                if (MoveValidator.hasEnoughMovement(moveUnits, newRoute)) {
                    if (MoveValidator.noEnemyUnitsOnPathMiddleSteps(newRoute, player, data)) continue;
                    return newRoute;
                }
                return oldRoute;
            }
        }
        return null;
    }

    public static boolean isWaterAt(Territory checkTerr, GameData data) {
        boolean Water = Matches.territoryHasWaterNeighbor(data).match(checkTerr);
        return Water;
    }

    public static IntegerMap<UnitType> convertListToMap(Collection<Unit> units) {
        IntegerMap<UnitType> ourList = new IntegerMap<UnitType>();
        for (Unit u : units) {
            UnitType uT = u.getType();
            ourList.put(uT, 0);
        }
        Set ourTypeList = ourList.keySet();
        for (UnitType u2 : ourTypeList) {
            int count = 0;
            for (Unit u3 : units) {
                if (u3.getType() != u2) continue;
                ++count;
            }
            ourList.put(u2, count);
        }
        return ourList;
    }

    public static boolean quickBattleEstimator(IntegerMap<UnitType> attacker, IntegerMap<UnitType> defender, PlayerID aPlayer, PlayerID dPlayer, boolean sea, boolean subRestricted) {
        try {
            return SUtils.quickBattleEstimatorInternal(attacker, defender, aPlayer, dPlayer, sea, subRestricted);
        }
        catch (StackOverflowError e) {
            e.printStackTrace(System.out);
            return false;
        }
    }

    private static boolean quickBattleEstimatorInternal(IntegerMap<UnitType> attacker, IntegerMap<UnitType> defender, PlayerID aPlayer, PlayerID dPlayer, boolean sea, boolean subRestricted) {
        UnitAttachment ua;
        int totAttack = 0;
        int totDefend = 0;
        int deadA = 0;
        int deadD = 0;
        int deadModA = 0;
        int deadModD = 0;
        int countInf = 0;
        int countArt = 0;
        int planeAttack = 0;
        int subDefend = 0;
        boolean planesOnly = true;
        boolean destroyerPresent = false;
        boolean subsOnly = true;
        Set<UnitType> attackingUnits = attacker.keySet();
        Set<UnitType> defendingUnits = defender.keySet();
        for (UnitType aUnit : attackingUnits) {
            ua = UnitAttachment.get(aUnit);
            totAttack += ua.getAttackRolls(aPlayer) * ua.getAttack(aPlayer) * attacker.getInt(aUnit);
            countInf += Matches.UnitTypeIsInfantry.match(aUnit) ? 1 : 0;
            countArt += Matches.UnitTypeIsArtillery.match(aUnit) ? 1 : 0;
            if (Matches.UnitTypeIsNotAir.match(aUnit)) {
                planesOnly = false;
            } else {
                planeAttack = ua.getAttackRolls(aPlayer) * ua.getAttack(aPlayer) * attacker.getInt(aUnit);
            }
            if (!Matches.UnitTypeIsDestroyer.match(aUnit)) continue;
            destroyerPresent = true;
        }
        deadD = (totAttack += Math.min(countInf, countArt)) / 6;
        deadModA = totAttack % 6;
        for (UnitType dUnit : defendingUnits) {
            ua = UnitAttachment.get(dUnit);
            totDefend += ua.getDefenseRolls(dPlayer) * ua.getDefense(dPlayer) * defender.getInt(dUnit);
            if (Matches.UnitTypeIsSub.match(dUnit) && planesOnly) {
                totDefend -= ua.getDefenseRolls(dPlayer) * ua.getDefense(dPlayer) * defender.getInt(dUnit);
            }
            if (Matches.UnitTypeIsSub.invert().match(dUnit)) {
                subsOnly = false;
                continue;
            }
            subDefend += ua.getDefenseRolls(dPlayer) * ua.getDefense(dPlayer) * defender.getInt(dUnit);
        }
        if (subRestricted && subsOnly && !destroyerPresent) {
            totAttack -= planeAttack;
        }
        if (planesOnly) {
            totDefend -= subDefend;
        }
        deadA = totDefend / 6;
        deadModD = totDefend % 6;
        if (deadD == 0 && deadA == 0 && deadModA <= 2 && deadModD <= 2 && deadModA == deadModD) {
            deadA = 1;
            deadD = 1;
        } else {
            int testD = 0;
            int testA = 0;
            while (testD == 0 && testA == 0 && (deadModD > 0 || deadModA > 0)) {
                for (int i = 1; i <= 6; ++i) {
                    testD += (double)(deadModD * 100) >= Math.random() * 600.0 ? 1 : 0;
                    testA += i > 1 && (double)(deadModA * 100) >= Math.random() * 600.0 ? 1 : 0;
                }
            }
            deadA += testD >= 4 ? 1 : 0;
            deadD += testA >= 4 ? 1 : 0;
        }
        IntegerMap<UnitType> newAttacker = SUtils.removeUnits(attacker, true, deadA, aPlayer, sea);
        IntegerMap<UnitType> newDefender = SUtils.removeUnits(defender, false, deadD, dPlayer, sea);
        if (newAttacker.totalValues() > 0 && newDefender.totalValues() > 0) {
            SUtils.quickBattleEstimatorInternal(newAttacker, newDefender, aPlayer, dPlayer, sea, subRestricted);
        }
        for (UnitType nA : attackingUnits) {
            attacker.put(nA, newAttacker.getInt(nA));
        }
        for (UnitType nD : defendingUnits) {
            defender.put(nD, newDefender.getInt(nD));
        }
        boolean weWin = false;
        for (UnitType AA : attackingUnits) {
            if (!Matches.UnitTypeIsNotAir.match(AA) || newAttacker.getInt(AA) <= 0) continue;
            weWin = true;
        }
        return sea ? newAttacker.totalValues() > 0 : weWin;
    }

    public static float strengthOfTerritory(GameData data, Territory thisTerr, PlayerID player, boolean attacking, boolean sea, boolean tFirst, boolean allied) {
        ArrayList<Unit> theUnits = new ArrayList<Unit>();
        if (allied) {
            theUnits.addAll(thisTerr.getUnits().getMatches(Matches.alliedUnit(player, data)));
        } else {
            theUnits.addAll(thisTerr.getUnits().getMatches(Matches.unitIsOwnedBy(player)));
        }
        float theStrength = SUtils.strength(theUnits, attacking, sea, tFirst);
        return theStrength;
    }

    public static float verifyPlaneAttack(GameData data, List<Collection<Unit>> xMoveUnits, List<Route> xMoveRoutes, PlayerID player, List<Territory> alreadyAttacked) {
        Iterator<Collection<Unit>> xMoveIter = xMoveUnits.iterator();
        boolean routeNo = false;
        HashMap<Territory, List> badRouteMap = new HashMap<Territory, List>();
        HashMap<Territory, Float> strengthDiffMap = new HashMap<Territory, Float>();
        ArrayList emptyList = new ArrayList();
        for (Territory alliedTerr : SUtils.allAlliedTerritories(data, player)) {
            float eStrength = SUtils.getStrengthOfPotentialAttackers(alliedTerr, data, player, false, false, alreadyAttacked);
            float ourStrength = SUtils.strengthOfTerritory(data, alliedTerr, player, false, false, false, true);
            if (Matches.territoryIsAlliedAndHasAlliedUnitMatching(data, player, Matches.UnitCanProduceUnits).match(alliedTerr)) {
                ourStrength += ourStrength * 0.25f;
            }
            if (ourStrength > 3.0f) {
                strengthDiffMap.put(alliedTerr, Float.valueOf(eStrength * 0.85f - ourStrength));
            } else if (eStrength > 3.0f) {
                strengthDiffMap.put(alliedTerr, Float.valueOf(eStrength * 1.25f + 3.0f - ourStrength));
            } else if (eStrength < 3.0f) {
                strengthDiffMap.put(alliedTerr, Float.valueOf(-ourStrength - 3.0f));
            } else {
                strengthDiffMap.put(alliedTerr, Float.valueOf(eStrength - ourStrength));
            }
            badRouteMap.put(alliedTerr, emptyList);
        }
        while (xMoveIter.hasNext()) {
            Collection<Unit> xMoves = xMoveIter.next();
            Route goRoute = xMoveRoutes.get(0);
            int routeLength = goRoute.getLength();
            Territory endTerr = goRoute.getEnd();
            for (Unit plane : xMoves) {
                boolean safePlane = false;
                if (!Matches.UnitIsAir.match(plane)) continue;
                int moveAvailable = TripleAUnit.get(plane).getMovementLeft();
                ArrayList<Territory> endNeighbors = new ArrayList<Territory>(data.getMap().getNeighbors(endTerr, moveAvailable -= routeLength));
                Iterator eIter = endNeighbors.iterator();
                while (eIter.hasNext()) {
                    Territory newTerr = (Territory)eIter.next();
                    if (!Matches.TerritoryIsWater.match(newTerr) && !Matches.isTerritoryAllied(player, data).invert().match(newTerr)) continue;
                    eIter.remove();
                }
                SUtils.reorder(endNeighbors, strengthDiffMap, false);
                Iterator eIter2 = endNeighbors.iterator();
                while (eIter.hasNext() && !safePlane) {
                    Territory newTerr = (Territory)eIter2.next();
                    if (!strengthDiffMap.containsKey(newTerr)) continue;
                    float strengthDiff = ((Float)strengthDiffMap.get(newTerr)).floatValue() - SUtils.uStrength(plane, false, false, false);
                    strengthDiffMap.put(newTerr, Float.valueOf(strengthDiff));
                    if (strengthDiff <= 0.0f) {
                        safePlane = true;
                        continue;
                    }
                    List RouteNos = (List)badRouteMap.get(newTerr);
                    RouteNos.add(0);
                    badRouteMap.put(newTerr, RouteNos);
                }
            }
        }
        ArrayList badMoveTerrs = new ArrayList(badRouteMap.keySet());
        float strengthEliminated = 0.0f;
        for (Territory checkTerr : badMoveTerrs) {
            float strengthDiff = ((Float)strengthDiffMap.get(checkTerr)).floatValue();
            if (strengthDiff > 0.0f) continue;
            List routeNumber = (List)badRouteMap.get(checkTerr);
            for (Integer killRoute : routeNumber) {
                Collection<Unit> killUnits = xMoveUnits.get(killRoute);
                strengthEliminated += SUtils.strength(killUnits, true, false, false);
                xMoveUnits.remove(killRoute);
                xMoveRoutes.remove(killRoute);
            }
        }
        return strengthEliminated;
    }

    public static IntegerMap<UnitType> removeUnits(IntegerMap<UnitType> units, boolean attacking, int killNum, PlayerID player, boolean sea) {
        IntegerMap<UnitType> finalList = new IntegerMap<UnitType>();
        Set<UnitType> unitList = units.keySet();
        ArrayList<UnitType> orderedUnitList = new ArrayList<UnitType>(unitList);
        for (int i = 0; i < orderedUnitList.size(); ++i) {
            UnitType unit1 = (UnitType)orderedUnitList.get(i);
            boolean isInf1 = Matches.UnitTypeIsInfantry.match(unit1);
            boolean isArt1 = Matches.UnitTypeIsArtillery.match(unit1);
            boolean isTank1 = UnitAttachment.get(unit1).getCanBlitz(player);
            if (!sea && Matches.unitTypeCanBombard(player).match(unit1)) {
                orderedUnitList.remove(i);
                --i;
                continue;
            }
            int ipip = 0;
            UnitAttachment ua = UnitAttachment.get(unit1);
            ipip = attacking ? ua.getAttack(player) : ua.getDefense(player);
            for (int j = i + 1; j < orderedUnitList.size(); ++j) {
                UnitType unit2 = (UnitType)orderedUnitList.get(j);
                boolean isInf2 = Matches.UnitTypeIsInfantry.match(unit2);
                boolean isArt2 = Matches.UnitTypeIsArtillery.match(unit2);
                boolean isTank2 = UnitAttachment.get(unit2).getCanBlitz(player);
                UnitAttachment ua2 = UnitAttachment.get(unit2);
                int ipip2 = 0;
                ipip2 = attacking ? ua2.getAttack(player) : ua2.getDefense(player);
                if (ipip <= ipip2 && (ipip != ipip2 || (!isInf1 && !isArt1 || isInf2 && isArt2) && (!isTank1 || isInf2 || isArt2 || isTank2))) continue;
                UnitType itemp = (UnitType)orderedUnitList.get(i);
                UnitType itemp2 = (UnitType)orderedUnitList.get(j);
                orderedUnitList.remove(i);
                orderedUnitList.remove(j - 1);
                orderedUnitList.add(i, itemp2);
                orderedUnitList.add(j, itemp);
            }
        }
        for (UnitType unitKill : orderedUnitList) {
            int minusNum = Math.min(units.getInt(unitKill), killNum);
            finalList.put(unitKill, units.getInt(unitKill) - minusNum);
            killNum -= minusNum;
        }
        return finalList;
    }

    public static int shipThreatToTerr(Territory checkTerr, GameData data, PlayerID player, boolean tFirst) {
        CompositeMatchAnd enemyUnit = new CompositeMatchAnd(Matches.enemyUnit(player, data));
        CompositeMatchAnd<Unit> enemySeaUnit = new CompositeMatchAnd<Unit>(enemyUnit, Matches.UnitIsSea, Matches.UnitIsNotTransport);
        CompositeMatchAnd<Unit> enemyAirUnit = new CompositeMatchAnd<Unit>(enemyUnit, Matches.UnitIsAir);
        CompositeMatchAnd<Unit> enemyBBUnit = new CompositeMatchAnd<Unit>(enemyUnit, Matches.UnitIsBB);
        CompositeMatchAnd<Unit> enemyTransportUnit = new CompositeMatchAnd<Unit>(enemyUnit, Matches.UnitIsTransport);
        CompositeMatchAnd<Unit> alliedSeaUnit = new CompositeMatchAnd<Unit>(Matches.alliedUnit(player, data), Matches.UnitIsSea, Matches.UnitIsNotTransport);
        CompositeMatchAnd<Unit> alliedTransport = new CompositeMatchAnd<Unit>(Matches.alliedUnit(player, data), Matches.UnitIsTransport);
        CompositeMatchAnd<Unit> alliedAirUnit = new CompositeMatchAnd<Unit>(Matches.alliedUnit(player, data), Matches.UnitCanLandOnCarrier);
        CompositeMatchAnd<Unit> alliedBBUnit = new CompositeMatchAnd<Unit>(Matches.alliedUnit(player, data), Matches.UnitIsBB);
        boolean isWater = SUtils.isWaterAt(checkTerr, data);
        if (!isWater) {
            return -1;
        }
        Set<Territory> waterNeighbors = data.getMap().getNeighbors(checkTerr, Matches.TerritoryIsWater);
        Set<Territory> shipNeighbors = data.getMap().getNeighbors(checkTerr, 4);
        int totAttackCount = 0;
        int totTransCount = 0;
        ArrayList<Territory> checkThese = new ArrayList<Territory>();
        ArrayList<Territory> checkThese2 = new ArrayList<Territory>();
        PlayerID ePlayer = null;
        List<PlayerID> ePlayers = SUtils.getEnemyPlayers(data, player);
        if (!ePlayers.isEmpty()) {
            ePlayer = ePlayers.get(0);
        }
        for (Territory shipTerr : shipNeighbors) {
            List<Unit> allShips = shipTerr.getUnits().getMatches(Matches.UnitIsSea);
            if (allShips.isEmpty()) continue;
            int shipDistance = MoveValidator.getLeastMovement(allShips);
            for (Territory waterTerr : waterNeighbors) {
                int testLength;
                Route testERoute = SUtils.getMaxSeaRoute(data, shipTerr, waterTerr, ePlayer, true, shipDistance);
                Route testARoute = SUtils.getMaxSeaRoute(data, shipTerr, waterTerr, player, true, shipDistance);
                if (testERoute != null) {
                    testLength = testERoute.getLength();
                    if (shipTerr.isWater() && testLength <= shipDistance + 1) {
                        checkThese.add(shipTerr);
                    }
                }
                if (testARoute == null) continue;
                testLength = testARoute.getLength();
                if (!shipTerr.isWater() || testLength > shipDistance + 1) continue;
                checkThese2.add(shipTerr);
            }
        }
        if (checkTerr.isWater()) {
            checkThese.add(checkTerr);
            checkThese2.add(checkTerr);
        }
        for (Territory sT : checkThese) {
            totAttackCount += sT.getUnits().countMatches(enemySeaUnit) + sT.getUnits().countMatches(enemyAirUnit);
            totAttackCount += sT.getUnits().countMatches(enemyBBUnit);
            totTransCount += sT.getUnits().countMatches(enemyTransportUnit);
        }
        for (Territory sT : checkThese2) {
            totAttackCount -= sT.getUnits().countMatches(alliedSeaUnit) - sT.getUnits().countMatches(alliedAirUnit);
            totAttackCount -= sT.getUnits().countMatches(alliedBBUnit);
            totTransCount -= sT.getUnits().countMatches(alliedTransport);
        }
        if (tFirst) {
            totAttackCount += totTransCount / 2;
        }
        return totAttackCount;
    }

    public static void removeNonAmphibTerritories(List<Territory> territories, GameData data) {
        if (territories.isEmpty()) {
            return;
        }
        Iterator<Territory> tIter = territories.iterator();
        while (tIter.hasNext()) {
            Territory checkTerr = tIter.next();
            if (!Matches.territoryHasWaterNeighbor(data).invert().match(checkTerr)) continue;
            tIter.remove();
        }
    }

    public static void reorder(List<?> reorder, final IntegerMap map, final boolean greaterThan) {
        if (!map.keySet().containsAll(reorder)) {
            throw new IllegalArgumentException("Not all of:" + reorder + " in:" + map.keySet());
        }
        Collections.sort(reorder, new Comparator<Object>(){

            @Override
            public int compare(Object o1, Object o2) {
                int v1 = map.getInt(o1);
                int v2 = map.getInt(o2);
                if (greaterThan) {
                    int t = v1;
                    v1 = v2;
                    v2 = t;
                }
                if (v1 > v2) {
                    return 1;
                }
                if (v1 == v2) {
                    return 0;
                }
                return -1;
            }
        });
    }

    public static void reorder(List<?> reorder, final Map<?, ? extends Number> map, final boolean greaterThan) {
        Collections.sort(reorder, new Comparator<Object>(){

            @Override
            public int compare(Object o1, Object o2) {
                double v1 = this.safeGet(map, o1);
                double v2 = this.safeGet(map, o2);
                if (greaterThan) {
                    double t = v1;
                    v1 = v2;
                    v2 = t;
                }
                if (v1 > v2) {
                    return 1;
                }
                if (v1 == v2) {
                    return 0;
                }
                return -1;
            }

            private double safeGet(Map<?, ? extends Number> map2, Object o1) {
                if (!map2.containsKey(o1)) {
                    return 0.0;
                }
                return map2.get(o1).doubleValue();
            }
        });
    }

    public static boolean findPurchaseMix(IntegerMap<ProductionRule> bestAttack, IntegerMap<ProductionRule> bestDefense, IntegerMap<ProductionRule> bestTransport, IntegerMap<ProductionRule> bestMaxUnits, IntegerMap<ProductionRule> bestMobileAttack, List<ProductionRule> rules, int totPU, int maxUnits, GameData data, PlayerID player, int fighters) {
        IntegerMap<String> parameters = new IntegerMap<String>();
        parameters.put("attack", 0);
        parameters.put("defense", 0);
        parameters.put("maxAttack", 0);
        parameters.put("maxDefense", 0);
        parameters.put("maxUnitAttack", 0);
        parameters.put("maxTransAttack", 0);
        parameters.put("maxMobileAttack", 0);
        parameters.put("maxTransCost", 100000);
        parameters.put("maxAttackCost", 100000);
        parameters.put("maxUnitCount", 0);
        parameters.put("maxDefenseCost", 100000);
        parameters.put("maxUnitCost", 100000);
        parameters.put("totcost", 0);
        parameters.put("totUnit", 0);
        parameters.put("totMovement", 0);
        parameters.put("maxMovement", 0);
        parameters.put("maxUnits", maxUnits);
        parameters.put("maxCost", totPU);
        parameters.put("infantry", 0);
        parameters.put("nonInfantry", 0);
        HashMap<ProductionRule, Boolean> infMap = new HashMap<ProductionRule, Boolean>();
        HashMap<ProductionRule, Boolean> nonInfMap = new HashMap<ProductionRule, Boolean>();
        HashMap<ProductionRule, Boolean> supportableInfMap = new HashMap<ProductionRule, Boolean>();
        Iterator<ProductionRule> prodIter = rules.iterator();
        HashMap<ProductionRule, Boolean> transportMap = new HashMap<ProductionRule, Boolean>();
        while (prodIter.hasNext()) {
            ProductionRule rule = prodIter.next();
            bestAttack.put(rule, 0);
            bestDefense.put(rule, 0);
            bestMaxUnits.put(rule, 0);
            bestTransport.put(rule, 0);
            UnitType x = (UnitType)rule.getResults().keySet().iterator().next();
            supportableInfMap.put(rule, UnitAttachment.get(x).getArtillerySupportable());
            transportMap.put(rule, Matches.UnitTypeCanBeTransported.match(x));
            infMap.put(rule, Matches.UnitTypeIsInfantry.match(x));
            nonInfMap.put(rule, Matches.UnitTypeCanBeTransported.match(x) && Matches.UnitTypeIsInfantry.invert().match(x) && Matches.UnitTypeIsAAforAnything.invert().match(x));
        }
        boolean countNum = true;
        int goodLoop = SUtils.purchaseLoop(parameters, 1, bestAttack, bestDefense, bestTransport, bestMaxUnits, bestMobileAttack, transportMap, infMap, nonInfMap, supportableInfMap, data, player, fighters);
        return goodLoop > 0 && bestAttack.size() > 0 && bestDefense.size() > 0;
    }

    public static int purchaseLoop(IntegerMap<String> parameters, int ruleNum, IntegerMap<ProductionRule> bestAttack, IntegerMap<ProductionRule> bestDefense, IntegerMap<ProductionRule> bestTransport, IntegerMap<ProductionRule> bestMaxUnits, IntegerMap<ProductionRule> bestMobileAttack, HashMap<ProductionRule, Boolean> transportMap, HashMap<ProductionRule, Boolean> infMap, HashMap<ProductionRule, Boolean> nonInfMap, HashMap<ProductionRule, Boolean> supportableInfMap, GameData data, PlayerID player, int fighters) {
        int counter;
        long start = System.currentTimeMillis();
        Resource key = data.getResourceList().getResource("PUs");
        Set<ProductionRule> ruleCheck = bestAttack.keySet();
        Iterator<ProductionRule> ruleIter = ruleCheck.iterator();
        ProductionRule rule = null;
        for (counter = 1; counter <= ruleNum && ruleIter.hasNext(); ++counter) {
            rule = ruleIter.next();
        }
        if (rule == null) {
            return 0;
        }
        Integer totAttack = parameters.getInt("attack");
        Integer totDefense = parameters.getInt("defense");
        Integer totCost = parameters.getInt("totcost");
        Integer totMovement = parameters.getInt("totMovement");
        Integer maxCost = parameters.getInt("maxCost");
        Integer maxUnits = parameters.getInt("maxUnits");
        Integer totUnits = parameters.getInt("totUnits");
        Integer maxAttack = parameters.getInt("maxAttack");
        Integer maxDefense = parameters.getInt("maxDefense");
        Integer maxTransAttack = parameters.getInt("maxTransAttack");
        Integer maxTransCost = parameters.getInt("maxTransCost");
        Integer maxAttackCost = parameters.getInt("maxAttackCost");
        Integer maxDefenseCost = parameters.getInt("maxDefenseCost");
        Integer maxUnitAttack = parameters.getInt("maxUnitAttack");
        Integer maxUnitCost = parameters.getInt("maxUnitCost");
        Integer maxUnitCount = parameters.getInt("maxUnitCount");
        Integer maxMobileAttack = parameters.getInt("maxMobileAttack");
        Integer maxMovement = parameters.getInt("maxMovement");
        Integer supportableInfCount = parameters.getInt("supportableInfCount");
        Integer infCount = parameters.getInt("infantry");
        Integer nonInfCount = parameters.getInt("nonInfantry");
        int parametersChanged = 0;
        int thisParametersChanged = 0;
        UnitType x = (UnitType)rule.getResults().keySet().iterator().next();
        UnitAttachment u = UnitAttachment.get(x);
        boolean thisIsSupportableInf = supportableInfMap.get(rule);
        boolean thisIsInf = infMap.get(rule);
        boolean thisIsNonInf = nonInfMap.get(rule);
        boolean thisIsArt = u.getArtillery();
        int uMovement = u.getMovement(player);
        int uAttack = u.getAttack(player);
        int uDefense = u.getDefense(player);
        int aRolls = u.getAttackRolls(player);
        int cost = rule.getCosts().getInt(key);
        boolean thisIsSub = u.getIsSub();
        if (thisIsSub && uAttack >= 1) {
            --uAttack;
        } else if (thisIsSub && uDefense >= 1) {
            --uDefense;
        }
        if (u.getMovement(player) == 0) {
            uAttack = 0;
        }
        if ((u.getAttack(player) == 0 || u.getDefense(player) - u.getAttack(player) >= 4) && u.getDefense(player) >= 1) {
            --uDefense;
            if (u.getDefense(player) - u.getAttack(player) >= 4) {
                --uDefense;
            }
        }
        if ((u.getDefense(player) == 0 || u.getAttack(player) - u.getDefense(player) >= 4) && u.getAttack(player) >= 1) {
            --uAttack;
            if (u.getAttack(player) - u.getDefense(player) >= 4) {
                --uAttack;
            }
        }
        int fightersremaining = fighters;
        int usableMaxUnits = maxUnits;
        if (usableMaxUnits * ruleCheck.size() > 1000 && Math.random() <= 0.5) {
            usableMaxUnits /= 2;
        }
        for (int i = 0; i <= usableMaxUnits - totUnits; ++i) {
            int countThis;
            if (i > 0) {
                int carrierLoad;
                Integer n;
                Integer n2;
                if ((totCost = Integer.valueOf(totCost + cost)) > maxCost) continue;
                if (thisIsInf) {
                    n2 = infCount;
                    n = infCount = Integer.valueOf(infCount + 1);
                } else if (thisIsNonInf) {
                    Integer n3 = nonInfCount;
                    Integer n4 = nonInfCount = Integer.valueOf(nonInfCount + 1);
                }
                if (thisIsSupportableInf) {
                    n2 = supportableInfCount;
                    n = supportableInfCount = Integer.valueOf(supportableInfCount + 1);
                }
                if ((carrierLoad = Math.min(u.getCarrierCapacity(), fightersremaining)) < 0) {
                    carrierLoad = 0;
                }
                int bonusAttack = (u.getIsTwoHit() ? uAttack : 0) + (uAttack > 0 && i % 2 == 0 ? 1 : 0) + carrierLoad * 3;
                if (thisIsArt && i <= supportableInfCount) {
                    ++bonusAttack;
                }
                int bonusDefense = (u.getIsTwoHit() ? uDefense : 0) + (uDefense > 0 && i % 2 == 0 ? 1 : 0) + carrierLoad * 4;
                fightersremaining -= carrierLoad;
                Integer n5 = totUnits;
                Integer n6 = totUnits = Integer.valueOf(totUnits + 1);
                totAttack = totAttack + (uAttack * aRolls + bonusAttack);
                totDefense = totDefense + (uDefense * aRolls + bonusDefense);
                totMovement = totMovement + uMovement;
            }
            if (totUnits <= maxUnits && ruleIter.hasNext()) {
                parameters.put("attack", totAttack);
                parameters.put("defense", totDefense);
                parameters.put("totcost", totCost);
                parameters.put("totUnits", totUnits);
                parameters.put("totMovement", totMovement);
                parameters.put("infantry", infCount);
                parameters.put("nonInfantry", nonInfCount);
                parameters.put("supportableInfCount", supportableInfCount);
                parametersChanged = SUtils.purchaseLoop(parameters, counter, bestAttack, bestDefense, bestTransport, bestMaxUnits, bestMobileAttack, transportMap, infMap, nonInfMap, supportableInfMap, data, player, fighters);
                maxAttack = parameters.getInt("maxAttack");
                maxTransAttack = parameters.getInt("maxTransAttack");
                maxTransCost = parameters.getInt("maxTransCost");
                maxDefense = parameters.getInt("maxDefense");
                maxAttackCost = parameters.getInt("maxAttackCost");
                maxDefenseCost = parameters.getInt("maxDefenseCost");
                maxUnitCost = parameters.getInt("maxUnitCost");
                maxUnitAttack = parameters.getInt("maxUnitAttack");
                maxMobileAttack = parameters.getInt("maxMobileAttack");
                maxMovement = parameters.getInt("maxMovement");
                if (System.currentTimeMillis() - start > 150000L) break;
            }
            if (totCost == 0) continue;
            if (parametersChanged > 0) {
                if ((parametersChanged - 3) % 4 == 0) {
                    bestAttack.put(rule, i);
                    bestDefense.put(rule, i);
                    thisParametersChanged = 3;
                    parametersChanged -= 3;
                } else if ((parametersChanged - 1) % 4 == 0) {
                    bestAttack.put(rule, i);
                    if (thisParametersChanged % 2 == 0) {
                        ++thisParametersChanged;
                    }
                    --parametersChanged;
                } else if ((parametersChanged - 2) % 4 == 0) {
                    bestDefense.put(rule, i);
                    if ((thisParametersChanged + 2) % 4 != 0 && (thisParametersChanged + 1) % 4 != 0) {
                        thisParametersChanged += 2;
                    }
                    parametersChanged -= 2;
                }
                if (parametersChanged > 0 && (parametersChanged - 4) % 8 == 0) {
                    bestMaxUnits.put(rule, i);
                    if (thisParametersChanged == 0 || (thisParametersChanged - 4) % 8 != 0) {
                        thisParametersChanged += 4;
                    }
                    parametersChanged -= 4;
                }
                if ((parametersChanged - 8) % 16 == 0) {
                    bestTransport.put(rule, i);
                    if (thisParametersChanged == 0 || (thisParametersChanged - 8) % 16 != 0) {
                        thisParametersChanged += 8;
                    }
                }
                if (parametersChanged >= 16) {
                    bestMobileAttack.put(rule, i);
                    if (thisParametersChanged < 16) {
                        thisParametersChanged += 16;
                    }
                }
                parametersChanged = 0;
                continue;
            }
            if (totAttack > maxAttack || totAttack == maxAttack && Math.random() < 0.5) {
                maxAttack = totAttack;
                maxAttackCost = totCost;
                parameters.put("maxAttack", maxAttack);
                parameters.put("maxAttackCost", maxAttackCost);
                bestAttack.put(rule, i);
                if (thisParametersChanged % 2 == 0) {
                    ++thisParametersChanged;
                }
                Iterator<ProductionRule> changeIter = ruleCheck.iterator();
                ProductionRule changeThis = null;
                countThis = 1;
                while (changeIter.hasNext()) {
                    changeThis = changeIter.next();
                    if (countThis >= counter) {
                        bestAttack.put(changeThis, 0);
                    }
                    ++countThis;
                }
            }
            if (totDefense > maxDefense || totDefense == maxDefense && Math.random() < 0.5) {
                maxDefense = totDefense;
                maxDefenseCost = totCost;
                parameters.put("maxDefense", maxDefense);
                parameters.put("maxDefenseCost", maxDefenseCost);
                bestDefense.put(rule, i);
                if ((thisParametersChanged + 2) % 4 != 0 && (thisParametersChanged + 1) % 4 != 0) {
                    thisParametersChanged += 2;
                }
                Iterator<ProductionRule> changeIter = ruleCheck.iterator();
                ProductionRule changeThis = null;
                countThis = 1;
                while (changeIter.hasNext()) {
                    changeThis = changeIter.next();
                    if (countThis >= counter) {
                        bestDefense.put(changeThis, 0);
                    }
                    ++countThis;
                }
            }
            if (totAttack > maxUnitAttack && totUnits >= maxUnitCount) {
                maxUnitAttack = totAttack;
                maxUnitCount = totUnits;
                maxUnitCost = totCost;
                parameters.put("maxUnitAttack", maxUnitAttack);
                parameters.put("maxUnitCount", maxUnitCount);
                parameters.put("maxUnitCost", maxUnitCost);
                bestMaxUnits.put(rule, i);
                if ((thisParametersChanged + 4) % 8 != 0) {
                    thisParametersChanged += 4;
                }
                Iterator<ProductionRule> changeIter = ruleCheck.iterator();
                ProductionRule changeThis = null;
                countThis = 1;
                while (changeIter.hasNext()) {
                    changeThis = changeIter.next();
                    if (countThis >= counter) {
                        bestMaxUnits.put(changeThis, 0);
                    }
                    ++countThis;
                }
            }
            if (totAttack > maxTransAttack && infCount <= nonInfCount + 1 && infCount >= nonInfCount - 1) {
                maxTransAttack = totAttack;
                maxTransCost = totCost;
                parameters.put("maxTransAttack", totAttack);
                parameters.put("maxTransCost", maxTransCost);
                bestTransport.put(rule, i);
                if ((thisParametersChanged + 8) % 16 != 0) {
                    thisParametersChanged += 8;
                }
                Iterator<ProductionRule> changeIter = ruleCheck.iterator();
                ProductionRule changeThis = null;
                countThis = 1;
                while (changeIter.hasNext()) {
                    changeThis = changeIter.next();
                    if (countThis >= counter) {
                        bestTransport.put(changeThis, 0);
                    }
                    ++countThis;
                }
            }
            if ((totAttack < maxMobileAttack || totMovement <= maxMovement) && (totAttack <= maxMobileAttack || totMovement < maxMovement)) continue;
            maxMobileAttack = totAttack;
            maxMovement = totMovement;
            parameters.put("maxMobileAttack", maxMobileAttack);
            parameters.put("maxMovement", maxMovement);
            bestMobileAttack.put(rule, i);
            if (thisParametersChanged < 16) {
                thisParametersChanged += 16;
            }
            Iterator<ProductionRule> changeIter = ruleCheck.iterator();
            ProductionRule changeThis = null;
            countThis = 1;
            while (changeIter.hasNext()) {
                changeThis = changeIter.next();
                if (countThis >= counter) {
                    bestMobileAttack.put(changeThis, 0);
                }
                ++countThis;
            }
        }
        return thisParametersChanged;
    }

    public static List<PlayerID> getAlliedPlayers(GameData data, PlayerID player) {
        Collection<PlayerID> playerList = data.getPlayerList().getPlayers();
        ArrayList<PlayerID> aPlayers = new ArrayList<PlayerID>(playerList);
        List<PlayerID> ePlayers = SUtils.getEnemyPlayers(data, player);
        aPlayers.removeAll(ePlayers);
        return aPlayers;
    }

    public static boolean determineAggressiveAttack(GameData data, PlayerID player, float aggressiveFactor) {
        int enemyTUV;
        int alliedTUV = SUtils.getAlliedEnemyTUV(data, player, true);
        return (float)(alliedTUV * 100) > (float)((enemyTUV = SUtils.getAlliedEnemyTUV(data, player, false)) * 100) * aggressiveFactor;
    }

    public static int getAlliedEnemyTUV(GameData data, PlayerID player, boolean allied) {
        IntegerMap<PlayerID> unitMap = SUtils.getPlayerTUV(data);
        int TUV = 0;
        if (allied) {
            List<PlayerID> aPlayers = SUtils.getAlliedPlayers(data, player);
            for (PlayerID aP : aPlayers) {
                TUV += unitMap.getInt(aP);
            }
        } else {
            List<PlayerID> ePlayers = SUtils.getEnemyPlayers(data, player);
            for (PlayerID eP : ePlayers) {
                TUV += unitMap.getInt(eP);
            }
        }
        return TUV;
    }

    public static Route getMaxSeaRoute(GameData data, Territory start, Territory destination, PlayerID player, boolean attacking, int maxDistance) {
        if (start == null || destination == null || !start.isWater() || !destination.isWater()) {
            return null;
        }
        CompositeMatchAnd<Unit> ignore = new CompositeMatchAnd<Unit>(Matches.UnitIsInfrastructure.invert(), Matches.alliedUnit(player, data).invert());
        CompositeMatchAnd sub = new CompositeMatchAnd(Matches.UnitIsSub.invert());
        CompositeMatchAnd transport = new CompositeMatchAnd(Matches.UnitIsTransport.invert(), Matches.UnitIsLand.invert());
        CompositeMatchAnd<Unit> unitCond = ignore;
        if (Properties.getIgnoreTransportInMovement(data)) {
            unitCond.add(transport);
        }
        if (Properties.getIgnoreSubInMovement(data)) {
            unitCond.add(sub);
        }
        CompositeMatchAnd<Territory> routeCond = new CompositeMatchAnd<Territory>(Matches.territoryHasUnitsThatMatch(unitCond).invert(), Matches.TerritoryIsWater);
        CompositeMatch routeCondition = attacking ? new CompositeMatchOr(Matches.territoryIs(destination), routeCond) : routeCond;
        Route r = data.getMap().getRoute(start, destination, routeCondition);
        if (r == null || r.getEnd() == null) {
            return null;
        }
        if (MoveValidator.validateCanal(r, null, player, data) != null) {
            r = data.getMap().getRoute(start, destination, new CompositeMatchAnd<Territory>(routeCondition, Matches.territoryHasNonAllowedCanal(player, null, data).invert()));
        }
        if (r == null || r.getEnd() == null) {
            return null;
        }
        int rDist = r.getLength();
        Route route2 = new Route();
        if (rDist <= maxDistance) {
            route2 = r;
        } else {
            route2.setStart(start);
            for (int i = 1; i <= maxDistance; ++i) {
                route2.add(r.getTerritories().get(i));
            }
        }
        return route2;
    }

    public static int getLeftToSpend(GameData data, PlayerID player) {
        Resource pus = data.getResourceList().getResource("PUs");
        return player.getResources().getQuantity(pus);
    }

    public static boolean territoryHasThreatenedAlliedFactoryNeighbor(GameData data, Territory eTerr, PlayerID player) {
        if (Matches.territoryHasAlliedNeighborWithAlliedUnitMatching(data, player, Matches.UnitCanProduceUnits).invert().match(eTerr)) {
            return false;
        }
        Set<Territory> aNeighbors = data.getMap().getNeighbors(eTerr);
        ArrayList<Territory> factTerr = new ArrayList<Territory>();
        for (Territory checkTerr : aNeighbors) {
            if (!Matches.territoryIsAlliedAndHasAlliedUnitMatching(data, player, Matches.UnitCanProduceUnits).match(checkTerr)) continue;
            factTerr.add(checkTerr);
        }
        boolean isThreatened = false;
        for (Territory factory : factTerr) {
            float myStrength;
            float eStrength;
            if ((eStrength += eStrength * 1.15f + ((eStrength = SUtils.getStrengthOfPotentialAttackers(factory, data, player, false, true, null)) > 2.0f ? 3.0f : 0.0f)) > (myStrength = SUtils.strength(factory.getUnits().getUnits(), false, false, false))) {
                Set<Territory> factNeighbors = data.getMap().getNeighbors(factory, Matches.isTerritoryAllied(player, data));
                float addStrength = 0.0f;
                for (Territory fNTerr : factNeighbors) {
                    addStrength += SUtils.strengthOfTerritory(data, fNTerr, player, false, false, false, true);
                }
                myStrength += addStrength * 0.5f;
            }
            if (!(eStrength > myStrength)) continue;
            isThreatened = true;
        }
        return isThreatened;
    }

    public static HashMap<Territory, Float> rankTerritories(GameData data, List<Territory> ourFriendlyTerr, List<Territory> ourEnemyTerr, List<Territory> ignoreTerr, PlayerID player, boolean tFirst, boolean waterBased, boolean nonCombat) {
        long last;
        long start = last = System.currentTimeMillis();
        HashMap<Territory, Float> landRankMap = new HashMap<Territory, Float>();
        HashMap<Territory, Float> landStrengthMap = new HashMap<Territory, Float>();
        CompositeMatchAnd<Territory> noEnemyOrWater = new CompositeMatchAnd<Territory>(Matches.TerritoryIsNotImpassableToLandUnits(player, data), Matches.isTerritoryAllied(player, data));
        CompositeMatchAnd<Territory> enemyAndNoWater = new CompositeMatchAnd<Territory>(Matches.TerritoryIsNotImpassableToLandUnits(player, data), Matches.isTerritoryEnemyAndNotUnownedWaterOrImpassibleOrRestricted(player, data));
        List<PlayerID> ePlayers = SUtils.getEnemyPlayers(data, player);
        PlayerID ePlayer = ePlayers.get(0);
        List<Territory> enemyCapitals = SUtils.getEnemyCapitals(data, player);
        Territory myCapital = TerritoryAttachment.getCapital(player, data);
        int minDist = 1000;
        int playerPUs = SUtils.getLeftToSpend(data, player);
        Iterator<Territory> eCapsIter = enemyCapitals.iterator();
        while (eCapsIter.hasNext()) {
            Territory eCap = eCapsIter.next();
            if (Matches.isTerritoryFriendly(player, data).match(eCap) && Matches.territoryHasAlliedUnits(player, data).match(eCap) && !Matches.territoryHasEnemyLandNeighbor(data, player).match(eCap)) {
                eCapsIter.remove();
                continue;
            }
            int dist = data.getMap().getDistance(myCapital, eCap);
            minDist = Math.min(minDist, dist);
        }
        List<Territory> alliedFactories = SUtils.getEnemyCapitals(data, ePlayer);
        Iterator<Territory> aFIter = alliedFactories.iterator();
        while (aFIter.hasNext()) {
            float alliedStrength;
            Territory aFTerr = aFIter.next();
            float aFPotential = SUtils.getStrengthOfPotentialAttackers(aFTerr, data, player, tFirst, true, null);
            if (!(aFPotential < (alliedStrength = SUtils.strengthOfTerritory(data, aFTerr, player, false, false, tFirst, true)) * 0.75f) && !(aFPotential < 1.0f) && Matches.TerritoryIsPassableAndNotRestricted(player, data).match(aFTerr) && (!Matches.isTerritoryEnemyAndNotUnownedWaterOrImpassibleOrRestricted(player, data).match(aFTerr) || !Matches.territoryHasEnemyLandNeighbor(data, player).match(aFTerr))) continue;
            aFIter.remove();
        }
        ArrayList<Territory> aFNeighbors = new ArrayList<Territory>();
        for (Territory aF : alliedFactories) {
            aFNeighbors.addAll(data.getMap().getNeighbors(aF, Matches.isTerritoryAllied(player, data)));
        }
        for (Territory eTerr : data.getMap().getTerritories()) {
            Route testERoute;
            Route eCapRoute;
            if (eTerr.isWater() || Matches.TerritoryIsImpassable.match(eTerr) || !Matches.TerritoryIsPassableAndNotRestricted(player, data).match(eTerr)) continue;
            float alliedPotential = SUtils.getStrengthOfPotentialAttackers(eTerr, data, ePlayer, tFirst, true, null);
            float rankStrength = SUtils.getStrengthOfPotentialAttackers(eTerr, data, player, tFirst, true, ignoreTerr);
            float productionValue = TerritoryAttachment.get(eTerr).getProduction();
            float eTerrValue = 0.0f;
            boolean island = !SUtils.doesLandExistAt(eTerr, data, false);
            eTerrValue += Matches.TerritoryIsVictoryCity.match(eTerr) ? 2.0f : 0.0f;
            boolean lRCap = SUtils.hasLandRouteToEnemyOwnedCapitol(eTerr, player, data);
            eTerrValue += lRCap ? 16.0f : 0.0f;
            if (lRCap && !Matches.territoryIsEnemyNonNeutralAndHasEnemyUnitMatching(data, player, Matches.UnitCanProduceUnits).match(eTerr) && !Matches.territoryIsAlliedAndHasAlliedUnitMatching(data, player, Matches.UnitCanProduceUnits).match(eTerr) && (eCapRoute = SUtils.findNearest(eTerr, Matches.territoryIsEnemyNonNeutralAndHasEnemyUnitMatching(data, player, Matches.UnitCanProduceUnits), Matches.TerritoryIsNotImpassableToLandUnits(player, data), data)) != null) {
                eTerrValue = Math.max(eTerrValue - 8.0f, eTerrValue - (float)(eCapRoute.getLength() - 1));
            }
            eTerrValue += Matches.territoryHasEnemyNonNeutralNeighborWithEnemyUnitMatching(data, player, Matches.UnitCanProduceUnits).match(eTerr) ? 3.0f : 0.0f;
            int eMinDist = 1000;
            for (Territory eTerrCap : enemyCapitals) {
                int eDist = data.getMap().getDistance(eTerr, eTerrCap, Matches.TerritoryIsNotImpassable);
                eMinDist = Math.min(eMinDist, eDist);
            }
            eTerrValue -= (float)(eMinDist - 1);
            if (Matches.TerritoryIsLand.match(eTerr) && Matches.isTerritoryEnemyAndNotUnownedWaterOrImpassibleOrRestricted(player, data).match(eTerr)) {
                ourEnemyTerr.add(eTerr);
                eTerrValue += productionValue * 2.0f;
                float eTerrStrength = SUtils.strength(eTerr.getUnits().getMatches(Matches.enemyUnit(player, data)), false, false, tFirst);
                eTerrValue += alliedPotential > rankStrength + eTerrStrength ? productionValue : 0.0f;
                if (island) {
                    eTerrValue += 5.0f;
                }
                eTerrValue += (float)(eTerr.getUnits().countMatches(Matches.UnitIsAir) * 2);
                eTerrValue += Matches.territoryIsEnemyNonNeutralAndHasEnemyUnitMatching(data, player, Matches.UnitCanProduceUnits).match(eTerr) ? 4.0f : 0.0f;
                eTerrValue += Matches.territoryHasAlliedNeighborWithAlliedUnitMatching(data, player, Matches.UnitCanProduceUnits).match(eTerr) ? 8.0f : 0.0f;
                float f = Matches.territoryHasEnemyLandNeighbor(data, player).invert().match(eTerr) ? productionValue + 1.0f : 0.0f;
                float netStrength = eTerrStrength - alliedPotential + 0.5f * rankStrength;
                landStrengthMap.put(eTerr, Float.valueOf(netStrength));
                landRankMap.put(eTerr, Float.valueOf((eTerrValue += f) + netStrength * 0.25f));
                continue;
            }
            if (Matches.isTerritoryAllied(player, data).match(eTerr) && Matches.TerritoryIsNotNeutralButCouldBeWater.match(eTerr)) {
                boolean hasENeighbors = Matches.territoryHasEnemyLandNeighbor(data, player).match(eTerr);
                testERoute = SUtils.findNearest(eTerr, enemyAndNoWater, noEnemyOrWater, data);
                if (island) {
                    eTerrValue += -5.0f;
                }
                eTerrValue += hasENeighbors ? 2.0f : -2.0f;
                eTerrValue += aFNeighbors.contains(eTerr) ? 8.0f : 0.0f;
                eTerrValue += testERoute == null ? -20.0f : Math.max(-10.0f, (float)(-(testERoute.getLength() - 2)));
                eTerrValue += testERoute != null ? productionValue : 0.0f;
                float aTerrStrength = SUtils.strength(eTerr.getUnits().getMatches(Matches.alliedUnit(player, data)), false, false, tFirst);
                boolean hasAlliedFactory = Matches.territoryIsAlliedAndHasAlliedUnitMatching(data, player, Matches.UnitCanProduceUnits).match(eTerr);
                if (hasAlliedFactory) {
                    eTerrValue += 4.0f + (hasENeighbors && rankStrength > 5.0f ? 3.0f : 0.0f);
                    alliedFactories.add(eTerr);
                }
                float netStrength = rankStrength - aTerrStrength - 0.5f * alliedPotential;
                landStrengthMap.put(eTerr, Float.valueOf(netStrength));
                landRankMap.put(eTerr, Float.valueOf(eTerrValue + netStrength * 0.5f));
                if (!(netStrength > -15.0f && rankStrength > 2.0f || hasENeighbors) && testERoute == null) continue;
                ourFriendlyTerr.add(eTerr);
                continue;
            }
            if (!Matches.TerritoryIsNeutralButNotWater.match(eTerr) || !Matches.TerritoryIsNotImpassable.match(eTerr) || !Matches.isTerritoryFreeNeutral(data).match(eTerr) && Properties.getNeutralCharge(data) > playerPUs) continue;
            eTerrValue += -100.0f;
            boolean hasENeighbors = Matches.territoryHasEnemyLandNeighbor(data, player).match(eTerr);
            testERoute = SUtils.findNearest(eTerr, enemyAndNoWater, noEnemyOrWater, data);
            eTerrValue += hasENeighbors ? 1.0f : -1.0f;
            eTerrValue += testERoute == null ? -1.0f : (float)(-(testERoute.getLength() - 1));
            float f = productionValue > 0.0f ? productionValue : -5.0f;
            float netStrength = rankStrength - 0.5f * alliedPotential;
            landStrengthMap.put(eTerr, Float.valueOf(netStrength));
            landRankMap.put(eTerr, Float.valueOf((eTerrValue += f) + netStrength * 0.5f));
        }
        if (nonCombat) {
            CompositeMatchAnd<Territory> alliedLandTerr = new CompositeMatchAnd<Territory>(Matches.isTerritoryAllied(player, data), Matches.TerritoryIsLand, Matches.TerritoryIsNotImpassable);
            for (Territory terr1 : alliedFactories) {
                if (!landRankMap.containsKey(terr1)) continue;
                float landRank = landRankMap.get(terr1).floatValue();
                if (!Matches.territoryHasEnemyLandNeighbor(data, player).match(terr1)) continue;
                for (Territory neighbor : data.getMap().getNeighbors(terr1, alliedLandTerr)) {
                    if (!landRankMap.containsKey(neighbor)) continue;
                    float thisRank = landRankMap.get(neighbor).floatValue();
                    landRank = Math.max(landRank, thisRank);
                }
                landRankMap.put(terr1, Float.valueOf(landRank += 1.0f));
            }
        }
        long now = System.currentTimeMillis();
        s_logger.finest("Time Takenrank " + (now - start));
        return landRankMap;
    }

    public static float twoAwayStrengthNotCounted(GameData data, PlayerID player, Territory eTerr) {
        List<Territory> blitzers = SUtils.possibleBlitzTerritories(eTerr, data, player);
        float nonBlitzStrength = 0.0f;
        ArrayList<Territory> checkTerrs = new ArrayList<Territory>();
        for (Territory bTerr : blitzers) {
            ArrayList<Territory> bTNeighbors = new ArrayList<Territory>(data.getMap().getNeighbors(bTerr));
            bTNeighbors.removeAll(blitzers);
            bTNeighbors.remove(eTerr);
            for (Territory bT : bTNeighbors) {
                if (checkTerrs.contains(bT)) continue;
                checkTerrs.add(bT);
            }
        }
        CompositeMatchAnd<Territory> landPassable = new CompositeMatchAnd<Territory>(Matches.TerritoryIsLand, Matches.TerritoryIsNotImpassable);
        for (Territory newBTerr : checkTerrs) {
            Set<Territory> newBNeighbors = data.getMap().getNeighbors(newBTerr, landPassable);
            boolean blitzCounted = false;
            Iterator<Territory> newBNIter = newBNeighbors.iterator();
            while (!blitzCounted && newBNIter.hasNext()) {
                Territory bCheck = newBNIter.next();
                if (!blitzers.contains(bCheck) || !bCheck.getUnits().getMatches(Matches.alliedUnit(player, data)).isEmpty()) continue;
                blitzCounted = true;
            }
            if (blitzCounted || !Matches.isTerritoryEnemyAndNotUnownedWaterOrImpassibleOrRestricted(player, data).match(newBTerr)) continue;
            nonBlitzStrength += SUtils.strength(newBTerr.getUnits().getMatches(Matches.enemyUnit(player, data)), true, false, false);
        }
        return nonBlitzStrength;
    }

    public static HashMap<Territory, Float> rankAmphibReinforcementTerritories(GameData data, List<Territory> ignoreTerr, PlayerID player, boolean tFirst) {
        HashMap<Territory, Float> landRankMap = new HashMap<Territory, Float>();
        HashMap<Territory, Float> landStrengthMap = new HashMap<Territory, Float>();
        CompositeMatchAnd<Territory> noEnemyOrWater = new CompositeMatchAnd<Territory>(Matches.TerritoryIsNotImpassableToLandUnits(player, data), Matches.isTerritoryAllied(player, data));
        CompositeMatchAnd<Territory> enemyAndNoWater = new CompositeMatchAnd<Territory>(Matches.TerritoryIsNotImpassableToLandUnits(player, data), Matches.isTerritoryEnemyAndNotUnownedWaterOrImpassibleOrRestricted(player, data));
        List<PlayerID> ePlayers = SUtils.getEnemyPlayers(data, player);
        PlayerID ePlayer = ePlayers.get(0);
        List<Territory> enemyCapitals = SUtils.getEnemyCapitals(data, player);
        Territory myCapital = TerritoryAttachment.getCapital(player, data);
        int minDist = 1000;
        Territory targetCap = null;
        for (Territory eCapTerr : enemyCapitals) {
            int dist = data.getMap().getDistance(myCapital, eCapTerr);
            if (minDist <= dist) continue;
            minDist = dist;
            targetCap = eCapTerr;
        }
        CompositeMatchAnd<Territory> continentTerr = new CompositeMatchAnd<Territory>(Matches.isTerritoryAllied(player, data), Matches.territoryHasValidLandRouteTo(data, targetCap));
        ArrayList<Territory> alliedFactories = new ArrayList<Territory>();
        for (Territory aTerr : data.getMap().getTerritories()) {
            if (!((Match)continentTerr).match(aTerr) || Matches.isTerritoryEnemy(player, data).match(aTerr) || Matches.TerritoryIsImpassable.match(aTerr) || Matches.territoryHasWaterNeighbor(data).invert().match(aTerr)) continue;
            float alliedPotential = SUtils.getStrengthOfPotentialAttackers(aTerr, data, ePlayer, tFirst, true, null);
            float localStrength = SUtils.strength(aTerr.getUnits().getUnits(), false, false, tFirst);
            float rankStrength = SUtils.getStrengthOfPotentialAttackers(aTerr, data, player, tFirst, true, ignoreTerr);
            float productionValue = TerritoryAttachment.get(aTerr).getProduction();
            float aTerrValue = 0.0f;
            aTerrValue += Matches.TerritoryIsVictoryCity.match(aTerr) ? 2.0f : 0.0f;
            aTerrValue += Matches.territoryHasEnemyNonNeutralNeighborWithEnemyUnitMatching(data, player, Matches.UnitCanProduceUnits).match(aTerr) ? 2.0f : 0.0f;
            aTerrValue -= (float)(data.getMap().getDistance(aTerr, targetCap, Matches.TerritoryIsNotImpassable) - 1);
            Territory capTerr = aTerr;
            if (Matches.territoryHasAlliedNeighborWithAlliedUnitMatching(data, player, Matches.UnitCanProduceUnits).match(capTerr)) {
                float addCapValue;
                float f = addCapValue = aTerr.equals(capTerr) ? 5.0f : 0.0f;
                if (rankStrength > alliedPotential + localStrength) {
                    aTerrValue += 10.0f + addCapValue;
                } else {
                    float xValue = SUtils.twoAwayStrengthNotCounted(data, player, aTerr);
                    if (rankStrength + xValue > (alliedPotential + localStrength) * 1.05f) {
                        aTerrValue += 10.0f + addCapValue;
                    }
                }
            }
            boolean hasENeighbors = Matches.territoryHasEnemyLandNeighbor(data, player).match(aTerr);
            Route testERoute = SUtils.findNearest(aTerr, enemyAndNoWater, noEnemyOrWater, data);
            aTerrValue += hasENeighbors ? 1.0f : -1.0f;
            aTerrValue += hasENeighbors && Matches.territoryHasAlliedNeighborWithAlliedUnitMatching(data, player, Matches.UnitCanProduceUnits).match(aTerr) ? 5.0f : 0.0f;
            aTerrValue += testERoute == null ? -1.0f : (float)(-(testERoute.getLength() - 1));
            aTerrValue += testERoute != null ? productionValue : 0.0f;
            float aTerrStrength = SUtils.strength(aTerr.getUnits().getMatches(Matches.alliedUnit(player, data)), false, false, tFirst);
            boolean hasAlliedFactory = Matches.territoryIsAlliedAndHasAlliedUnitMatching(data, player, Matches.UnitCanProduceUnits).match(aTerr);
            if (hasAlliedFactory) {
                aTerrValue += 4.0f + (hasENeighbors && rankStrength > 5.0f ? 3.0f : 0.0f);
                alliedFactories.add(aTerr);
            }
            boolean worthTroopDrop = aTerrStrength + alliedPotential > (rankStrength - 3.0f) * 0.8f;
            worthTroopDrop = worthTroopDrop && aTerrStrength + 0.8f * alliedPotential < 1.25f * (rankStrength + 3.0f);
            float f = worthTroopDrop ? 5.0f : -2.0f;
            float netStrength = rankStrength - aTerrStrength - 0.8f * alliedPotential;
            landStrengthMap.put(aTerr, Float.valueOf(netStrength));
            landRankMap.put(aTerr, Float.valueOf(aTerrValue += f));
        }
        return landRankMap;
    }
}

