/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.triplea.ai.strongAI;

import games.strategy.engine.data.GameData;
import games.strategy.engine.data.PlayerID;
import games.strategy.engine.data.Territory;
import games.strategy.engine.data.Unit;
import games.strategy.triplea.ai.strongAI.SUtils;
import games.strategy.triplea.delegate.Matches;
import games.strategy.util.CompositeMatchAnd;
import java.util.ArrayList;
import java.util.Set;

public class StrengthEvaluator {
    private float m_alliedNeighborStrength = 0.0f;
    private float m_alliedStrengthInRange = 0.0f;
    private float m_enemyNeighborStrength = 0.0f;
    private float m_enemyStrengthInRange = 0.0f;

    public float getAlliedNeighborStrength() {
        return this.m_alliedNeighborStrength;
    }

    public float getAlliedStrengthInRange() {
        return this.m_alliedStrengthInRange;
    }

    public float getEnemyNeighborStrength() {
        return this.m_enemyNeighborStrength;
    }

    public float getEnemyStrengthInRange() {
        return this.m_enemyStrengthInRange;
    }

    public boolean inDanger(float dangerFactor) {
        return this.strengthMissing(dangerFactor) <= 0.0f;
    }

    public float strengthMissing(float dangerFactor) {
        return this.m_enemyStrengthInRange - (this.m_alliedStrengthInRange * dangerFactor - 3.0f);
    }

    public void evalStrength(GameData data, PlayerID player, Territory ourTerr, boolean sea, boolean contiguous, boolean tFirst, boolean includeAllies, boolean allied) {
        ArrayList<Unit> seaUnits = new ArrayList();
        ArrayList<Unit> airUnits = new ArrayList();
        ArrayList<Unit> landUnits = new ArrayList();
        int rDist = 0;
        int r = 2;
        float inRangeStrength = 0.0f;
        float thisStrength = 0.0f;
        float inRangeAirStrength = 0.0f;
        float thisAirStrength = 0.0f;
        if (!ourTerr.isWater() && sea) {
            r = 3;
        }
        ArrayList<Territory> nearNeighbors = new ArrayList<Territory>();
        Set<Territory> nN = data.getMap().getNeighbors(ourTerr, r);
        nearNeighbors.addAll(nN);
        if (ourTerr.isWater() == sea) {
            nearNeighbors.add(ourTerr);
        }
        CompositeMatchAnd owned = new CompositeMatchAnd(Matches.unitIsOwnedBy(player));
        CompositeMatchAnd<Unit> seaUnit = new CompositeMatchAnd<Unit>(owned, Matches.UnitIsSea);
        CompositeMatchAnd<Unit> airUnit = new CompositeMatchAnd<Unit>(owned, Matches.UnitIsAir);
        CompositeMatchAnd<Unit> landUnit = new CompositeMatchAnd<Unit>(owned, Matches.UnitIsLand);
        if (includeAllies) {
            seaUnit = new CompositeMatchAnd(Matches.alliedUnit(player, data), Matches.UnitIsSea);
            airUnit = new CompositeMatchAnd(Matches.alliedUnit(player, data), Matches.UnitIsAir);
            landUnit = new CompositeMatchAnd(Matches.alliedUnit(player, data), Matches.UnitIsLand);
        }
        if (!allied) {
            seaUnit = new CompositeMatchAnd(Matches.enemyUnit(player, data), Matches.UnitIsSea);
            airUnit = new CompositeMatchAnd(Matches.enemyUnit(player, data), Matches.UnitIsAir);
            landUnit = new CompositeMatchAnd(Matches.enemyUnit(player, data), Matches.UnitIsLand);
            this.m_enemyNeighborStrength = 0.0f;
            this.m_enemyStrengthInRange = 0.0f;
        } else {
            this.m_alliedNeighborStrength = 0.0f;
            this.m_alliedStrengthInRange = 0.0f;
        }
        for (Territory t : nearNeighbors) {
            float xLandStrength;
            float airStrength;
            float seaStrength;
            boolean isLand = Matches.TerritoryIsLand.match(t);
            if (contiguous) {
                if (!isLand && sea) {
                    rDist = data.getMap().getWaterDistance(ourTerr, t);
                    seaUnits = t.getUnits().getMatches(seaUnit);
                    airUnits = t.getUnits().getMatches(airUnit);
                    seaStrength = SUtils.strength(seaUnits, false, true, tFirst);
                    airStrength = SUtils.allairstrength(airUnits, false);
                    if (rDist == 0 || rDist == 1) {
                        thisStrength += seaStrength;
                        thisAirStrength += airStrength;
                    }
                    if (rDist >= 0 && rDist <= 3) {
                        inRangeStrength += seaStrength;
                        inRangeAirStrength += airStrength;
                    }
                } else {
                    if (!isLand || sea || Matches.TerritoryIsNotNeutralButCouldBeWater.match(t)) continue;
                    rDist = data.getMap().getLandDistance(ourTerr, t);
                    landUnits = t.getUnits().getMatches(landUnit);
                    airUnits = t.getUnits().getMatches(airUnit);
                    xLandStrength = SUtils.strength(landUnits, false, false, tFirst);
                    airStrength = SUtils.allairstrength(airUnits, false);
                    if (rDist == 0 || rDist == 1) {
                        thisStrength += xLandStrength;
                        thisAirStrength += airStrength;
                    }
                    if (rDist >= 0 && rDist <= 3) {
                        inRangeStrength += xLandStrength;
                        inRangeAirStrength += airStrength;
                    }
                }
            } else {
                rDist = data.getMap().getDistance(ourTerr, t);
                if (!isLand && sea) {
                    seaUnits = t.getUnits().getMatches(seaUnit);
                    airUnits = t.getUnits().getMatches(airUnit);
                    seaStrength = SUtils.strength(seaUnits, false, true, tFirst);
                    airStrength = SUtils.allairstrength(airUnits, false);
                    if (rDist == 0 || rDist == 1) {
                        thisStrength += seaStrength;
                        thisAirStrength += airStrength;
                    }
                    if (rDist >= 0 && rDist <= 3) {
                        inRangeStrength += seaStrength;
                        inRangeAirStrength += airStrength;
                    }
                } else if (isLand && !sea && Matches.TerritoryIsNotNeutralButCouldBeWater.match(t)) {
                    landUnits = t.getUnits().getMatches(landUnit);
                    airUnits = t.getUnits().getMatches(airUnit);
                    xLandStrength = SUtils.strength(landUnits, false, false, tFirst);
                    airStrength = SUtils.allairstrength(airUnits, false);
                    if (rDist == 0 || rDist == 1) {
                        thisStrength += xLandStrength;
                        thisAirStrength += airStrength;
                    }
                    if (rDist >= 0 && rDist <= 2) {
                        inRangeStrength += xLandStrength;
                        inRangeAirStrength += airStrength;
                    }
                }
            }
            thisStrength = 0.0f;
            rDist = 0;
        }
        if (Matches.TerritoryIsLand.match(ourTerr) && thisStrength > 0.0f) {
            if (allied) {
                this.m_alliedNeighborStrength += thisStrength + thisAirStrength;
                this.m_alliedStrengthInRange += inRangeStrength + inRangeAirStrength;
            } else {
                this.m_enemyNeighborStrength += thisStrength + thisAirStrength;
                this.m_enemyStrengthInRange += inRangeStrength + inRangeAirStrength;
            }
        } else if (allied) {
            this.m_alliedNeighborStrength += thisStrength + thisAirStrength;
            this.m_alliedStrengthInRange += inRangeStrength + inRangeAirStrength;
        } else {
            this.m_enemyNeighborStrength += thisStrength + thisAirStrength;
            this.m_enemyStrengthInRange += inRangeStrength + inRangeAirStrength;
        }
    }

    public static StrengthEvaluator evalStrengthAt(GameData data, PlayerID player, Territory ourTerr, boolean sea, boolean contiguous, boolean tFirst, boolean includeAllies) {
        StrengthEvaluator strEval = new StrengthEvaluator();
        strEval.evalStrength(data, player, ourTerr, sea, contiguous, tFirst, includeAllies, true);
        strEval.evalStrength(data, player, ourTerr, sea, contiguous, tFirst, false, false);
        return strEval;
    }
}

