/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.triplea.attatchments;

import games.strategy.engine.data.Attachable;
import games.strategy.engine.data.DefaultAttachment;
import games.strategy.engine.data.GameData;
import games.strategy.engine.data.GameParseException;
import games.strategy.engine.data.PlayerID;
import games.strategy.engine.data.annotations.GameProperty;
import games.strategy.engine.delegate.IDelegateBridge;
import games.strategy.triplea.attatchments.ICondition;
import games.strategy.triplea.attatchments.RulesAttachment;
import games.strategy.util.Match;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractConditionsAttachment
extends DefaultAttachment
implements ICondition {
    private static final long serialVersionUID = -9008441256118867078L;
    private static final String AND = "AND";
    private static final String OR = "OR";
    private static final String XOR = "XOR";
    private static final String DEFAULT_CHANCE = "1:1";
    protected ArrayList<RulesAttachment> m_conditions = new ArrayList();
    protected String m_conditionType = "AND";
    protected boolean m_invert = false;
    protected String m_chance = "1:1";

    public AbstractConditionsAttachment(String name, Attachable attachable, GameData gameData) {
        super(name, attachable, gameData);
    }

    @Override
    @GameProperty(xmlProperty=true, gameProperty=true, adds=true)
    public void setConditions(String conditions) throws GameParseException {
        Collection<PlayerID> playerIDs = this.getData().getPlayerList().getPlayers();
        for (String subString : conditions.split(":")) {
            PlayerID p;
            RulesAttachment condition = null;
            Iterator<PlayerID> i$ = playerIDs.iterator();
            while (i$.hasNext() && (condition = (RulesAttachment)(p = i$.next()).getAttachment(subString)) == null) {
            }
            if (condition == null) {
                throw new GameParseException("Could not find rule. name:" + subString + this.thisErrorMsg());
            }
            if (this.m_conditions == null) {
                this.m_conditions = new ArrayList();
            }
            this.m_conditions.add(condition);
        }
    }

    @GameProperty(xmlProperty=true, gameProperty=true, adds=false)
    public void setConditions(ArrayList<RulesAttachment> value) {
        this.m_conditions = value;
    }

    public ArrayList<RulesAttachment> getConditions() {
        return this.m_conditions;
    }

    @Override
    public void clearConditions() {
        this.m_conditions.clear();
    }

    @Override
    public void resetConditions() {
        this.m_conditions = new ArrayList();
    }

    @Override
    @GameProperty(xmlProperty=true, gameProperty=true, adds=false)
    public void setInvert(String s) {
        this.m_invert = AbstractConditionsAttachment.getBool(s);
    }

    @GameProperty(xmlProperty=true, gameProperty=true, adds=false)
    public void setInvert(Boolean s) {
        this.m_invert = s;
    }

    @Override
    public boolean getInvert() {
        return this.m_invert;
    }

    @Override
    public void resetInvert() {
        this.m_invert = false;
    }

    @Override
    @GameProperty(xmlProperty=true, gameProperty=true, adds=false)
    public void setConditionType(String value) throws GameParseException {
        String s = value;
        if (s.equalsIgnoreCase(AND)) {
            s = AND;
        } else if (s.equalsIgnoreCase(OR)) {
            s = OR;
        } else if (s.equalsIgnoreCase(XOR)) {
            s = XOR;
        } else {
            String[] nums = s.split("-");
            if (nums.length == 1) {
                if (Integer.parseInt(nums[0]) < 0) {
                    throw new GameParseException("conditionType must be equal to 'AND' or 'OR' or 'XOR' or 'y' or 'y-z' where Y and Z are valid positive integers and Z is greater than Y" + this.thisErrorMsg());
                }
            } else if (nums.length == 2) {
                if (Integer.parseInt(nums[0]) < 0 || Integer.parseInt(nums[1]) < 0 || Integer.parseInt(nums[0]) >= Integer.parseInt(nums[1])) {
                    throw new GameParseException("conditionType must be equal to 'AND' or 'OR' or 'XOR' or 'y' or 'y-z' where Y and Z are valid positive integers and Z is greater than Y" + this.thisErrorMsg());
                }
            } else {
                throw new GameParseException("conditionType must be equal to 'AND' or 'OR' or 'XOR' or 'y' or 'y-z' where Y and Z are valid positive integers and Z is greater than Y" + this.thisErrorMsg());
            }
        }
        this.m_conditionType = s;
    }

    @Override
    public String getConditionType() {
        return this.m_conditionType;
    }

    @Override
    public void resetConditionType() {
        this.m_conditionType = AND;
    }

    @Override
    public boolean isSatisfied(HashMap<ICondition, Boolean> testedConditions) {
        return this.isSatisfied(testedConditions, null);
    }

    @Override
    public boolean isSatisfied(HashMap<ICondition, Boolean> testedConditions, IDelegateBridge aBridge) {
        if (testedConditions == null) {
            throw new IllegalStateException("testedCondititions can not be null");
        }
        if (testedConditions.containsKey(this)) {
            return testedConditions.get(this);
        }
        return AbstractConditionsAttachment.areConditionsMet(new ArrayList<ICondition>(this.getConditions()), testedConditions, this.getConditionType()) != this.getInvert();
    }

    public static Match<AbstractConditionsAttachment> isSatisfiedAbstractConditionsAttachmentMatch(final HashMap<ICondition, Boolean> testedConditions) {
        return new Match<AbstractConditionsAttachment>(){

            @Override
            public boolean match(AbstractConditionsAttachment ca) {
                return ca.isSatisfied(testedConditions);
            }
        };
    }

    public static HashSet<ICondition> getAllConditionsRecursive(HashSet<ICondition> startingListOfConditions, HashSet<ICondition> allConditionsNeededSoFar) {
        if (allConditionsNeededSoFar == null) {
            allConditionsNeededSoFar = new HashSet();
        }
        allConditionsNeededSoFar.addAll(startingListOfConditions);
        for (ICondition condition : startingListOfConditions) {
            for (RulesAttachment subCondition : condition.getConditions()) {
                if (allConditionsNeededSoFar.contains(subCondition)) continue;
                allConditionsNeededSoFar.addAll(AbstractConditionsAttachment.getAllConditionsRecursive(new HashSet<ICondition>(Collections.singleton(subCondition)), allConditionsNeededSoFar));
            }
        }
        return allConditionsNeededSoFar;
    }

    public static HashMap<ICondition, Boolean> testAllConditionsRecursive(HashSet<ICondition> rules, HashMap<ICondition, Boolean> allConditionsTestedSoFar, IDelegateBridge aBridge) {
        if (allConditionsTestedSoFar == null) {
            allConditionsTestedSoFar = new HashMap();
        }
        for (ICondition c : rules) {
            if (allConditionsTestedSoFar.containsKey(c)) continue;
            AbstractConditionsAttachment.testAllConditionsRecursive(new HashSet<ICondition>(c.getConditions()), allConditionsTestedSoFar, aBridge);
            allConditionsTestedSoFar.put(c, c.isSatisfied(allConditionsTestedSoFar, aBridge));
        }
        return allConditionsTestedSoFar;
    }

    public static boolean areConditionsMet(List<ICondition> rulesToTest, HashMap<ICondition, Boolean> testedConditions, String conditionType) {
        boolean met = false;
        if (conditionType.equals(AND)) {
            ICondition c;
            Iterator<ICondition> i$ = rulesToTest.iterator();
            while (i$.hasNext() && (met = testedConditions.get(c = i$.next()).booleanValue())) {
            }
        } else if (conditionType.equals(OR)) {
            ICondition c;
            Iterator<ICondition> i$ = rulesToTest.iterator();
            while (i$.hasNext() && !(met = testedConditions.get(c = i$.next()).booleanValue())) {
            }
        } else if (conditionType.equals(XOR)) {
            boolean isOneTrue = false;
            for (ICondition c : rulesToTest) {
                met = testedConditions.get(c);
                if (isOneTrue && met) {
                    isOneTrue = false;
                    break;
                }
                if (!met) continue;
                isOneTrue = true;
            }
            met = isOneTrue;
        } else {
            String[] nums = conditionType.split("-");
            if (nums.length == 1) {
                int start = Integer.parseInt(nums[0]);
                int count = 0;
                for (ICondition c : rulesToTest) {
                    met = testedConditions.get(c);
                    if (!met) continue;
                    ++count;
                }
                met = count == start;
            } else if (nums.length == 2) {
                int start = Integer.parseInt(nums[0]);
                int end = Integer.parseInt(nums[1]);
                int count = 0;
                for (ICondition c : rulesToTest) {
                    met = testedConditions.get(c);
                    if (!met) continue;
                    ++count;
                }
                met = count >= start && count <= end;
            }
        }
        return met;
    }

    @GameProperty(xmlProperty=true, gameProperty=true, adds=false)
    public void setChance(String chance) throws GameParseException {
        String[] s = chance.split(":");
        try {
            int i = AbstractConditionsAttachment.getInt(s[0]);
            int j = AbstractConditionsAttachment.getInt(s[1]);
            if (i > j || i < 1 || j < 1 || i > 120 || j > 120) {
                throw new GameParseException("chance should have a format of \"x:y\" where x is <= y and both x and y are >=1 and <=120" + this.thisErrorMsg());
            }
        }
        catch (IllegalArgumentException iae) {
            throw new GameParseException("Invalid chance declaration: " + chance + " format: \"1:10\" for 10% chance" + this.thisErrorMsg());
        }
        this.m_chance = chance;
    }

    public String getChance() {
        return this.m_chance;
    }

    public void resetChance() {
        this.m_chance = DEFAULT_CHANCE;
    }

    @Override
    public void validate(GameData data) throws GameParseException {
    }
}

