/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.triplea.delegate;

import games.strategy.engine.data.GameData;
import games.strategy.engine.data.GameMap;
import games.strategy.engine.data.PlayerID;
import games.strategy.engine.data.Route;
import games.strategy.engine.data.Territory;
import games.strategy.engine.data.Unit;
import games.strategy.triplea.Properties;
import games.strategy.triplea.TripleAUnit;
import games.strategy.triplea.attatchments.UnitAttachment;
import games.strategy.triplea.delegate.AirThatCantLandUtil;
import games.strategy.triplea.delegate.EditDelegate;
import games.strategy.triplea.delegate.Matches;
import games.strategy.triplea.delegate.MoveDelegate;
import games.strategy.triplea.delegate.MoveValidator;
import games.strategy.triplea.delegate.UnitComparator;
import games.strategy.triplea.delegate.dataObjects.MoveValidationResult;
import games.strategy.util.CompositeMatchAnd;
import games.strategy.util.IntegerMap;
import games.strategy.util.Match;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AirMovementValidator {
    public static final String NOT_ALL_AIR_UNITS_CAN_LAND = "Not all air units can land";

    public static MoveValidationResult validateAirCanLand(GameData data, Collection<Unit> units, Route route, PlayerID player, MoveValidationResult result) {
        if (AirMovementValidator.getEditMode(data) || !Match.someMatch(units, Matches.UnitIsAir) || route.hasNoSteps() || Matches.airCanLandOnThisAlliedNonConqueredLandTerritory(player, data).match(route.getEnd()) || AirMovementValidator.isKamikazeAircraft(data)) {
            return result;
        }
        Collection<Unit> ownedAirThatMustLandOnCarriers = AirMovementValidator.getAirThatMustLandOnCarriers(data, AirMovementValidator.getAirUnitsToValidate(units, route, player), route, result, player);
        if (ownedAirThatMustLandOnCarriers.isEmpty()) {
            return result;
        }
        Territory routeEnd = route.getEnd();
        Territory routeStart = route.getStart();
        CompositeMatchAnd airAlliedNotOwned = new CompositeMatchAnd(Matches.unitIsOwnedBy(player).invert(), Matches.isUnitAllied(player, data), Matches.UnitIsAir, Matches.UnitCanLandOnCarrier);
        LinkedHashSet<Unit> airThatMustLandOnCarriers = new LinkedHashSet<Unit>();
        airThatMustLandOnCarriers.addAll(Match.getMatches(routeEnd.getUnits().getUnits(), airAlliedNotOwned));
        airThatMustLandOnCarriers.addAll(Match.getMatches(units, airAlliedNotOwned));
        List<Unit> movingCarriersAtStartLocationBeingMoved = Match.getMatches(units, Matches.UnitIsCarrier);
        if (!movingCarriersAtStartLocationBeingMoved.isEmpty()) {
            Map<Unit, Collection<Unit>> carrierToAlliedCargo = MoveValidator.carrierMustMoveWith(units, routeStart, data, player);
            for (Collection<Unit> alliedAirOnCarrier : carrierToAlliedCargo.values()) {
                airThatMustLandOnCarriers.addAll(alliedAirOnCarrier);
            }
        }
        airThatMustLandOnCarriers.addAll(ownedAirThatMustLandOnCarriers);
        List<Unit> carriersAtEnd = Match.getMatches(AirMovementValidator.getFriendly(routeEnd, player, data), Matches.UnitIsCarrier);
        carriersAtEnd.addAll(movingCarriersAtStartLocationBeingMoved);
        HashMap<Unit, Collection<Unit>> movedCarriersAndTheirFighters = new HashMap<Unit, Collection<Unit>>();
        for (Unit carrier : carriersAtEnd) {
            movedCarriersAndTheirFighters.put(carrier, new ArrayList());
        }
        ArrayList<Unit> airNotToConsiderBecauseWeAreValidatingThem = new ArrayList<Unit>(airThatMustLandOnCarriers);
        airThatMustLandOnCarriers.removeAll(AirMovementValidator.whatAirCanLandOnTheseCarriers(carriersAtEnd, airThatMustLandOnCarriers, routeEnd));
        if (airThatMustLandOnCarriers.isEmpty()) {
            return result;
        }
        int maxMovementLeftForTheseAirUnitsBeingValidated = AirMovementValidator.maxMovementLeftForTheseAirUnitsBeingValidated(airThatMustLandOnCarriers, route, player);
        int maxMovementLeftForAllOwnedCarriers = AirMovementValidator.maxMovementLeftForAllOwnedCarriers(player, data);
        ArrayList<Territory> landingSpots = new ArrayList<Territory>(data.getMap().getNeighbors(routeEnd, maxMovementLeftForTheseAirUnitsBeingValidated, Matches.seaCanMoveOver(player, data)));
        landingSpots.add(routeEnd);
        Collections.sort(landingSpots, AirMovementValidator.getLowestToHighestDistance(routeEnd, Matches.seaCanMoveOver(player, data)));
        List<Territory> potentialCarrierOrigins = new ArrayList<Territory>(data.getMap().getNeighbors(routeEnd, maxMovementLeftForTheseAirUnitsBeingValidated + maxMovementLeftForAllOwnedCarriers, Matches.seaCanMoveOver(player, data)));
        potentialCarrierOrigins.remove(routeEnd);
        potentialCarrierOrigins = Match.getMatches(potentialCarrierOrigins, Matches.TerritoryHasOwnedCarrier(player));
        AirMovementValidator.validateAirCaughtByMovingCarriersAndOwnedAndAlliedAir(result, landingSpots, potentialCarrierOrigins, movedCarriersAndTheirFighters, airThatMustLandOnCarriers, airNotToConsiderBecauseWeAreValidatingThem, player, route, data);
        return result;
    }

    private static LinkedHashMap<Unit, Integer> getMovementLeftForValidatingAir(Collection<Unit> airBeingValidated, PlayerID player, Route route) {
        LinkedHashMap<Unit, Integer> map = new LinkedHashMap<Unit, Integer>();
        for (Unit unit : airBeingValidated) {
            Territory routeEnd = route.getEnd();
            int movementLeft = Matches.unitIsOwnedBy(player).match(unit) ? (routeEnd.getUnits().getUnits().contains(unit) ? new Route(routeEnd, new Territory[0]).getMovementLeft(unit) : route.getMovementLeft(unit)) : 0;
            map.put(unit, movementLeft);
        }
        return map;
    }

    private static IntegerMap<Territory> populateStaticAlliedAndBuildingCarrierCapacity(List<Territory> landingSpots, Map<Unit, Collection<Unit>> movedCarriersAndTheirFighters, PlayerID player, GameData data) {
        IntegerMap<Territory> startingSpace = new IntegerMap<Territory>();
        CompositeMatchAnd<Unit> carrierAlliedNotOwned = new CompositeMatchAnd<Unit>(Matches.unitIsOwnedBy(player).invert(), Matches.isUnitAllied(player, data), Matches.UnitIsCarrier);
        boolean landAirOnNewCarriers = AirThatCantLandUtil.isLHTRCarrierProduction(data) || AirThatCantLandUtil.isLandExistingFightersOnNewCarriers(data);
        List<Unit> carriersInProductionQueue = player.getUnits().getMatches(Matches.UnitIsCarrier);
        for (Territory t : landingSpots) {
            if (landAirOnNewCarriers && !carriersInProductionQueue.isEmpty() && Matches.TerritoryIsWater.match(t) && Matches.territoryHasOwnedAtBeginningOfTurnIsFactoryOrCanProduceUnitsNeighbor(data, player).match(t)) {
                int producedCarrierCapacity = AirMovementValidator.carrierCapacity(carriersInProductionQueue, t);
                startingSpace.add(t, producedCarrierCapacity);
                carriersInProductionQueue.clear();
            }
            List<Unit> alliedCarriers = t.getUnits().getMatches(carrierAlliedNotOwned);
            alliedCarriers.removeAll(movedCarriersAndTheirFighters.keySet());
            int alliedCarrierCapacity = AirMovementValidator.carrierCapacity(alliedCarriers, t);
            startingSpace.add(t, alliedCarrierCapacity);
        }
        return startingSpace;
    }

    private static void validateAirCaughtByMovingCarriersAndOwnedAndAlliedAir(MoveValidationResult result, List<Territory> landingSpots, List<Territory> potentialCarrierOrigins, Map<Unit, Collection<Unit>> movedCarriersAndTheirFighters, Collection<Unit> airThatMustLandOnCarriers, Collection<Unit> airNotToConsider, PlayerID player, Route route, GameData data) {
        CompositeMatchAnd ownedCarrierMatch = new CompositeMatchAnd(Matches.unitIsOwnedBy(player), Matches.UnitIsCarrier);
        CompositeMatchAnd ownedAirMatch = new CompositeMatchAnd(Matches.unitIsOwnedBy(player), Matches.UnitIsAir, Matches.UnitCanLandOnCarrier);
        CompositeMatchAnd alliedNotOwnedAirMatch = new CompositeMatchAnd(Matches.unitIsOwnedBy(player).invert(), Matches.isUnitAllied(player, data), Matches.UnitIsAir, Matches.UnitCanLandOnCarrier);
        CompositeMatchAnd<Unit> alliedNotOwnedCarrierMatch = new CompositeMatchAnd<Unit>(Matches.unitIsOwnedBy(player).invert(), Matches.isUnitAllied(player, data), Matches.UnitIsCarrier);
        Territory routeEnd = route.getEnd();
        boolean areNeutralsPassableByAir = AirMovementValidator.areNeutralsPassableByAir(data);
        IntegerMap<Territory> landingSpotsWithCarrierCapacity = AirMovementValidator.populateStaticAlliedAndBuildingCarrierCapacity(landingSpots, movedCarriersAndTheirFighters, player, data);
        LinkedHashMap<Unit, Integer> movementLeftForAirToValidate = AirMovementValidator.getMovementLeftForValidatingAir(airThatMustLandOnCarriers, player, route);
        for (Territory landingSpot : landingSpots) {
            potentialCarrierOrigins.remove(landingSpot);
            ArrayList<Unit> airCanReach = new ArrayList<Unit>();
            for (Unit air : airThatMustLandOnCarriers) {
                if (!AirMovementValidator.canAirReachThisSpot(data, player, air, routeEnd, movementLeftForAirToValidate.get(air), landingSpot, areNeutralsPassableByAir)) continue;
                airCanReach.add(air);
            }
            if (airCanReach.isEmpty()) continue;
            Collection<Unit> unitsInLandingSpot = landingSpot.getUnits().getUnits();
            unitsInLandingSpot.removeAll(movedCarriersAndTheirFighters.keySet());
            unitsInLandingSpot.removeAll(airNotToConsider);
            for (Collection<Unit> ftrs : movedCarriersAndTheirFighters.values()) {
                unitsInLandingSpot.removeAll(ftrs);
            }
            List<Unit> ownedCarriersInLandingSpot = Match.getMatches(unitsInLandingSpot, ownedCarrierMatch);
            List<Unit> airInLandingSpot = Match.getMatches(Match.getMatches(unitsInLandingSpot, ownedAirMatch), AirMovementValidator.UnitCanFindLand(data, landingSpot).invert());
            airInLandingSpot.addAll(Match.getMatches(unitsInLandingSpot, alliedNotOwnedAirMatch));
            int landingSpotCapacity = landingSpotsWithCarrierCapacity.getInt(landingSpot);
            landingSpotCapacity += AirMovementValidator.carrierCapacity(ownedCarriersInLandingSpot, landingSpot);
            landingSpotCapacity -= AirMovementValidator.carrierCost(airInLandingSpot);
            if (!airCanReach.isEmpty()) {
                Iterator airIter = airCanReach.iterator();
                while (airIter.hasNext()) {
                    Unit air = (Unit)airIter.next();
                    int carrierCost = AirMovementValidator.carrierCost(air);
                    if (landingSpotCapacity < carrierCost) continue;
                    landingSpotCapacity -= carrierCost;
                    airThatMustLandOnCarriers.remove(air);
                    airIter.remove();
                }
            }
            if (airThatMustLandOnCarriers.isEmpty()) {
                return;
            }
            Iterator<Territory> iter = potentialCarrierOrigins.iterator();
            while (iter.hasNext()) {
                List<Unit> carrierCanReach;
                Route toLandingSpot;
                Territory carrierSpot = iter.next();
                Collection<Unit> unitsInCarrierSpot = carrierSpot.getUnits().getUnits();
                unitsInCarrierSpot.removeAll(movedCarriersAndTheirFighters.keySet());
                unitsInCarrierSpot.removeAll(airNotToConsider);
                for (Collection<Unit> ftrs : movedCarriersAndTheirFighters.values()) {
                    unitsInCarrierSpot.removeAll(ftrs);
                }
                List<Unit> ownedCarriersInCarrierSpot = Match.getMatches(unitsInCarrierSpot, ownedCarrierMatch);
                if (ownedCarriersInCarrierSpot.isEmpty()) {
                    iter.remove();
                    continue;
                }
                List<Unit> ownedAirInCarrierSpot = Match.getMatches(Match.getMatches(unitsInCarrierSpot, ownedAirMatch), AirMovementValidator.UnitCanFindLand(data, carrierSpot).invert());
                List<Unit> alliedNotOwnedAirInCarrierSpot = Match.getMatches(unitsInCarrierSpot, alliedNotOwnedAirMatch);
                Map<Unit, Collection<Unit>> mustMoveWithMap = MoveValidator.carrierMustMoveWith(ownedCarriersInCarrierSpot, carrierSpot, data, player);
                int carrierSpotCapacity = landingSpotsWithCarrierCapacity.getInt(carrierSpot);
                if (!landingSpotsWithCarrierCapacity.containsKey(carrierSpot)) {
                    carrierSpotCapacity = AirMovementValidator.carrierCapacity(carrierSpot.getUnits().getMatches(alliedNotOwnedCarrierMatch), carrierSpot);
                    landingSpotsWithCarrierCapacity.put(carrierSpot, carrierSpotCapacity);
                }
                if (!alliedNotOwnedAirInCarrierSpot.isEmpty() || !mustMoveWithMap.isEmpty()) {
                    if (mustMoveWithMap.isEmpty()) {
                        airNotToConsider.addAll(alliedNotOwnedAirInCarrierSpot);
                        if ((carrierSpotCapacity -= AirMovementValidator.carrierCost(alliedNotOwnedAirInCarrierSpot)) > 0) {
                            Iterator ownedIter = ownedAirInCarrierSpot.iterator();
                            while (ownedIter.hasNext()) {
                                Unit air = (Unit)ownedIter.next();
                                int carrierCost = AirMovementValidator.carrierCost(air);
                                if (carrierSpotCapacity < carrierCost) continue;
                                carrierSpotCapacity -= carrierCost;
                                airNotToConsider.add(air);
                                ownedIter.remove();
                            }
                        }
                        landingSpotsWithCarrierCapacity.put(carrierSpot, carrierSpotCapacity);
                    } else {
                        for (Collection<Unit> airMovingWith : mustMoveWithMap.values()) {
                            for (Collection<Unit> ftrs : movedCarriersAndTheirFighters.values()) {
                                airMovingWith.removeAll(ftrs);
                            }
                        }
                        for (Collection<Unit> airMovingWith : mustMoveWithMap.values()) {
                            alliedNotOwnedAirInCarrierSpot.removeAll(airMovingWith);
                        }
                        airNotToConsider.addAll(alliedNotOwnedAirInCarrierSpot);
                        landingSpotsWithCarrierCapacity.put(carrierSpot, carrierSpotCapacity -= AirMovementValidator.carrierCost(alliedNotOwnedAirInCarrierSpot));
                    }
                }
                if ((toLandingSpot = data.getMap().getRoute(carrierSpot, landingSpot, Matches.seaCanMoveOver(player, data))) == null || (carrierCanReach = Match.getMatches(ownedCarriersInCarrierSpot, Matches.UnitHasEnoughMovementForRoute(toLandingSpot))).isEmpty()) continue;
                ArrayList<Unit> carrierNotReach = new ArrayList<Unit>(ownedCarriersInCarrierSpot);
                carrierNotReach.removeAll(carrierCanReach);
                ArrayList<Unit> allCarriers = new ArrayList<Unit>(carrierNotReach);
                allCarriers.addAll(carrierCanReach);
                HashMap<Unit, ArrayList<Unit>> carriersToMove = new HashMap<Unit, ArrayList<Unit>>();
                ArrayList<Unit> carrierFull = new ArrayList<Unit>();
                for (Unit carrier : allCarriers) {
                    ArrayList<Unit> airMovingWith = new ArrayList<Unit>();
                    Collection<Unit> alliedMovingWith = mustMoveWithMap.get(carrier);
                    if (alliedMovingWith != null) {
                        airMovingWith.addAll(alliedMovingWith);
                    }
                    int carrierCapacity = AirMovementValidator.carrierCapacity(carrier, carrierSpot);
                    carrierCapacity -= AirMovementValidator.carrierCost(airMovingWith);
                    Iterator ownedIter = ownedAirInCarrierSpot.iterator();
                    while (ownedIter.hasNext()) {
                        Unit air = (Unit)ownedIter.next();
                        int carrierCost = AirMovementValidator.carrierCost(air);
                        if (carrierCapacity < carrierCost) continue;
                        carrierCapacity -= carrierCost;
                        airMovingWith.add(air);
                        ownedIter.remove();
                    }
                    carriersToMove.put(carrier, airMovingWith);
                    if (carrierCapacity > 0) continue;
                    carrierFull.add(carrier);
                }
                if (carrierFull.containsAll(allCarriers)) {
                    iter.remove();
                    continue;
                }
                if (carrierFull.containsAll(carrierNotReach)) {
                    iter.remove();
                }
                for (Unit carrier : carrierCanReach) {
                    movedCarriersAndTheirFighters.put(carrier, (Collection<Unit>)carriersToMove.get(carrier));
                    landingSpotCapacity += AirMovementValidator.carrierCapacity(carrier, carrierSpot);
                    landingSpotCapacity -= AirMovementValidator.carrierCost((Collection)carriersToMove.get(carrier));
                }
                Iterator reachIter = airCanReach.iterator();
                while (reachIter.hasNext()) {
                    Unit air = (Unit)reachIter.next();
                    int carrierCost = AirMovementValidator.carrierCost(air);
                    if (landingSpotCapacity < carrierCost) continue;
                    landingSpotCapacity -= carrierCost;
                    airThatMustLandOnCarriers.remove(air);
                    reachIter.remove();
                }
                if (!airThatMustLandOnCarriers.isEmpty()) continue;
                return;
            }
        }
        for (Unit air : airThatMustLandOnCarriers) {
            result.addDisallowedUnit(NOT_ALL_AIR_UNITS_CAN_LAND, air);
        }
    }

    private static Comparator<Territory> getLowestToHighestDistance(final Territory territoryWeMeasureDistanceFrom, final Match<Territory> condition) {
        return new Comparator<Territory>(){

            @Override
            public int compare(Territory t1, Territory t2) {
                int distance2;
                if (t1.equals(t2)) {
                    return 0;
                }
                GameMap map = t1.getData().getMap();
                int distance1 = map.getDistance(territoryWeMeasureDistanceFrom, t1, condition);
                if (distance1 == (distance2 = map.getDistance(territoryWeMeasureDistanceFrom, t2, condition))) {
                    return 0;
                }
                if (distance1 < 0) {
                    return 1;
                }
                if (distance2 < 0) {
                    return -1;
                }
                if (distance1 < distance2) {
                    return -1;
                }
                return 1;
            }
        };
    }

    private static int maxMovementLeftForAllOwnedCarriers(PlayerID player, GameData data) {
        int max = 0;
        CompositeMatchAnd<Unit> ownedCarrier = new CompositeMatchAnd<Unit>(Matches.UnitIsCarrier, Matches.unitIsOwnedBy(player));
        for (Territory t : data.getMap().getTerritories()) {
            for (Unit carrier : t.getUnits().getMatches(ownedCarrier)) {
                max = Math.max(max, ((TripleAUnit)carrier).getMovementLeft());
            }
        }
        return max;
    }

    private static int maxMovementLeftForTheseAirUnitsBeingValidated(Set<Unit> airUnits, Route route, PlayerID player) {
        int max = 0;
        for (Unit u : airUnits) {
            Territory currentSpot;
            int movementLeft;
            if (!Matches.unitIsOwnedBy(player).match(u) || (movementLeft = (currentSpot = route.getEnd()).getUnits().getUnits().contains(u) ? new Route(currentSpot, new Territory[0]).getMovementLeft(u) : route.getMovementLeft(u)) <= max) continue;
            max = movementLeft;
        }
        return max;
    }

    private static Collection<Unit> whatAirCanLandOnTheseCarriers(Collection<Unit> carriers, Set<Unit> airUnits, Territory territoryUnitsAreIn) {
        ArrayList<Unit> airThatCanLandOnThem = new ArrayList<Unit>();
        for (Unit carrier : carriers) {
            int carrierCapacity = AirMovementValidator.carrierCapacity(carrier, territoryUnitsAreIn);
            for (Unit air : airUnits) {
                int airCost;
                if (airThatCanLandOnThem.contains(air) || carrierCapacity < (airCost = AirMovementValidator.carrierCost(air))) continue;
                carrierCapacity -= airCost;
                airThatCanLandOnThem.add(air);
            }
        }
        return airThatCanLandOnThem;
    }

    private static List<Unit> getAirUnitsToValidate(Collection<Unit> units, Route route, PlayerID player) {
        CompositeMatchAnd ownedAirMatch = new CompositeMatchAnd(Matches.UnitIsAir, Matches.unitOwnedBy(player), Matches.UnitIsKamikaze.invert());
        ArrayList<Unit> ownedAir = new ArrayList<Unit>();
        ownedAir.addAll(Match.getMatches(route.getEnd().getUnits().getUnits(), ownedAirMatch));
        ownedAir.addAll(Match.getMatches(units, ownedAirMatch));
        Collections.sort(ownedAir, UnitComparator.getIncreasingMovementComparator());
        return ownedAir;
    }

    public static boolean canAirReachThisSpot(GameData data, PlayerID player, Unit unit, Territory currentSpot, int movementLeft, Territory landingSpot, boolean areNeutralsPassableByAir) {
        if (areNeutralsPassableByAir) {
            Route neutralViolatingRoute = data.getMap().getRoute(currentSpot, landingSpot, Matches.airCanFlyOver(player, data, areNeutralsPassableByAir));
            return neutralViolatingRoute != null && neutralViolatingRoute.getMovementCost(unit) <= movementLeft && AirMovementValidator.getNeutralCharge(data, neutralViolatingRoute) <= player.getResources().getQuantity("PUs");
        }
        Route noNeutralRoute = data.getMap().getRoute(currentSpot, landingSpot, Matches.airCanFlyOver(player, data, areNeutralsPassableByAir));
        return noNeutralRoute != null && noNeutralRoute.getMovementCost(unit) <= movementLeft;
    }

    private static boolean canFindLand(GameData data, Unit unit, Route route) {
        Territory routeEnd = route.getEnd();
        int movementLeft = routeEnd.getUnits().getUnits().contains(unit) ? new Route(routeEnd, new Territory[0]).getMovementLeft(unit) : route.getMovementLeft(unit);
        return AirMovementValidator.canFindLand(data, unit, routeEnd, movementLeft);
    }

    private static boolean canFindLand(GameData data, Unit unit, Territory current) {
        int movementLeft = ((TripleAUnit)unit).getMovementLeft();
        return AirMovementValidator.canFindLand(data, unit, current, movementLeft);
    }

    private static boolean canFindLand(GameData data, Unit unit, Territory current, int movementLeft) {
        if (movementLeft <= 0) {
            return false;
        }
        boolean areNeutralsPassableByAir = AirMovementValidator.areNeutralsPassableByAir(data);
        PlayerID player = unit.getOwner();
        List<Territory> possibleSpots = Match.getMatches(data.getMap().getNeighbors(current, movementLeft), Matches.airCanLandOnThisAlliedNonConqueredLandTerritory(player, data));
        for (Territory landingSpot : possibleSpots) {
            if (!AirMovementValidator.canAirReachThisSpot(data, player, unit, current, movementLeft, landingSpot, areNeutralsPassableByAir)) continue;
            return true;
        }
        return false;
    }

    public static Match<Unit> UnitCanFindLand(final GameData data, final Territory current) {
        return new Match<Unit>(){

            @Override
            public boolean match(Unit u) {
                return AirMovementValidator.canFindLand(data, u, current);
            }
        };
    }

    public static boolean canLand(Collection<Unit> airUnits, Territory territory, PlayerID player, GameData data) {
        if (!Match.allMatch(airUnits, Matches.UnitIsAir)) {
            throw new IllegalArgumentException("can only test if air will land");
        }
        if (!territory.isWater() && MoveDelegate.getBattleTracker(data).wasConquered(territory)) {
            return false;
        }
        if (territory.isWater()) {
            if (!Match.allMatch(airUnits, Matches.UnitCanLandOnCarrier)) {
                return false;
            }
            HashSet<Unit> friendly = new HashSet<Unit>();
            friendly.addAll(AirMovementValidator.getFriendly(territory, player, data));
            friendly.addAll(airUnits);
            int capacity = AirMovementValidator.carrierCapacity(friendly, territory);
            int cost = AirMovementValidator.carrierCost(friendly);
            return capacity >= cost;
        }
        return data.getRelationshipTracker().canLandAirUnitsOnOwnedLand(player, territory.getOwner());
    }

    private static Collection<Unit> getAirThatMustLandOnCarriers(GameData data, Collection<Unit> ownedAir, Route route, MoveValidationResult result, PlayerID player) {
        ArrayList<Unit> airThatMustLandOnCarriers = new ArrayList<Unit>();
        Match<Unit> canLandOnCarriers = Matches.UnitCanLandOnCarrier;
        for (Unit unit : ownedAir) {
            if (AirMovementValidator.canFindLand(data, unit, route)) continue;
            if (canLandOnCarriers.match(unit)) {
                airThatMustLandOnCarriers.add(unit);
                continue;
            }
            result.addDisallowedUnit(NOT_ALL_AIR_UNITS_CAN_LAND, unit);
        }
        return airThatMustLandOnCarriers;
    }

    public static int carrierCapacity(Collection<Unit> units, Territory territoryUnitsAreCurrentlyIn) {
        int sum = 0;
        for (Unit unit : units) {
            sum += AirMovementValidator.carrierCapacity(unit, territoryUnitsAreCurrentlyIn);
        }
        return sum;
    }

    public static int carrierCapacity(Unit unit, Territory territoryUnitsAreCurrentlyIn) {
        if (Matches.UnitIsCarrier.match(unit)) {
            if (Matches.UnitHasWhenCombatDamagedEffect("unitsMayNotLandOnCarrier").match(unit)) {
                if (Matches.UnitHasWhenCombatDamagedEffect("unitsMayNotLeaveAlliedCarrier").match(unit)) {
                    int cargo = 0;
                    List<Unit> airCargo = territoryUnitsAreCurrentlyIn.getUnits().getMatches(new CompositeMatchAnd<Unit>(Matches.UnitIsAir, Matches.UnitCanLandOnCarrier));
                    for (Unit airUnit : airCargo) {
                        TripleAUnit taUnit = (TripleAUnit)airUnit;
                        if (taUnit.getTransportedBy() == null || !taUnit.getTransportedBy().equals(unit)) continue;
                        cargo += UnitAttachment.get(taUnit.getType()).getCarrierCost();
                    }
                    return cargo;
                }
                return 0;
            }
            UnitAttachment ua = UnitAttachment.get(unit.getType());
            return ua.getCarrierCapacity();
        }
        return 0;
    }

    public static int carrierCost(Collection<Unit> units) {
        int sum = 0;
        for (Unit unit : units) {
            sum += AirMovementValidator.carrierCost(unit);
        }
        return sum;
    }

    public static int carrierCost(Unit unit) {
        if (Matches.UnitCanLandOnCarrier.match(unit)) {
            return UnitAttachment.get(unit.getType()).getCarrierCost();
        }
        return 0;
    }

    private static boolean getEditMode(GameData data) {
        return EditDelegate.getEditMode(data);
    }

    public static Collection<Unit> getFriendly(Territory territory, PlayerID player, GameData data) {
        return territory.getUnits().getMatches(Matches.alliedUnit(player, data));
    }

    private static boolean isKamikazeAircraft(GameData data) {
        return Properties.getKamikaze_Airplanes(data);
    }

    private static boolean areNeutralsPassableByAir(GameData data) {
        return Properties.getNeutralFlyoverAllowed(data) && !AirMovementValidator.isNeutralsImpassable(data);
    }

    private static boolean isNeutralsImpassable(GameData data) {
        return Properties.getNeutralsImpassable(data);
    }

    private static int getNeutralCharge(GameData data, Route route) {
        return AirMovementValidator.getNeutralCharge(data, MoveDelegate.getEmptyNeutral(route).size());
    }

    private static int getNeutralCharge(GameData data, int numberOfTerritories) {
        return numberOfTerritories * Properties.getNeutralCharge(data);
    }
}

