/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.triplea.delegate;

import games.strategy.engine.data.GameData;
import games.strategy.engine.data.PlayerID;
import games.strategy.engine.data.ProductionFrontier;
import games.strategy.engine.data.ProductionRule;
import games.strategy.engine.data.Resource;
import games.strategy.engine.data.Territory;
import games.strategy.engine.data.TerritoryEffect;
import games.strategy.engine.data.Unit;
import games.strategy.engine.data.UnitType;
import games.strategy.engine.delegate.IDelegateBridge;
import games.strategy.engine.random.IRandomStats;
import games.strategy.net.GUID;
import games.strategy.triplea.Properties;
import games.strategy.triplea.ai.weakAI.WeakAI;
import games.strategy.triplea.attatchments.UnitAttachment;
import games.strategy.triplea.attatchments.UnitSupportAttachment;
import games.strategy.triplea.delegate.DiceRoll;
import games.strategy.triplea.delegate.Die;
import games.strategy.triplea.delegate.EditDelegate;
import games.strategy.triplea.delegate.Matches;
import games.strategy.triplea.delegate.TerritoryEffectHelper;
import games.strategy.triplea.delegate.TransportTracker;
import games.strategy.triplea.delegate.UnitBattleComparator;
import games.strategy.triplea.delegate.UnitComparator;
import games.strategy.triplea.delegate.dataObjects.CasualtyDetails;
import games.strategy.triplea.delegate.dataObjects.CasualtyList;
import games.strategy.triplea.player.ITripleaPlayer;
import games.strategy.triplea.util.UnitCategory;
import games.strategy.triplea.util.UnitSeperator;
import games.strategy.util.CompositeMatchAnd;
import games.strategy.util.IntegerMap;
import games.strategy.util.Match;
import games.strategy.util.Triple;
import games.strategy.util.Tuple;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BattleCalculator {
    private static boolean s_enableCasualtySortingCaching = false;
    private static HashMap<Integer, List<Unit>> s_cachedSortedCasualties = new HashMap();
    private static final Object s_cachedLock = new Object();

    public static void sortPreBattle(List<Unit> units, GameData data) {
        Comparator<Unit> comparator = new Comparator<Unit>(){

            @Override
            public int compare(Unit u1, Unit u2) {
                if (u1.getUnitType().equals(u2.getUnitType())) {
                    return UnitComparator.getDecreasingMovementComparator().compare(u1, u2);
                }
                return u1.getUnitType().getName().compareTo(u2.getUnitType().getName());
            }
        };
        Collections.sort(units, comparator);
    }

    public static int getTotalHitpoints(Collection<Unit> units) {
        if (units == null || units.isEmpty()) {
            return 0;
        }
        int rVal = 0;
        for (Unit u : units) {
            ++rVal;
            UnitAttachment ua = UnitAttachment.get(u.getType());
            if (!ua.getIsTwoHit() || u.getHits() != 0) continue;
            ++rVal;
        }
        return rVal;
    }

    public static int getAAHits(Collection<Unit> units, IDelegateBridge bridge, int[] dice) {
        int attackingAirCount = Match.countMatches(units, Matches.UnitIsAir);
        int hitCount = 0;
        for (int i = 0; i < attackingAirCount; ++i) {
            if (1 <= dice[i]) continue;
            ++hitCount;
        }
        return hitCount;
    }

    public static Collection<Unit> getAACasualties(Collection<Unit> planes, Collection<Unit> defendingAA, DiceRoll dice, IDelegateBridge bridge, PlayerID defender, PlayerID attacker, GUID battleID, Territory terr) {
        GameData data = bridge.getData();
        if (Properties.getLow_Luck(data) || Properties.getLL_AA_ONLY(data)) {
            if (BattleCalculator.isChooseAA(data)) {
                return BattleCalculator.chooseAACasualties(planes, dice, bridge, attacker, battleID, terr);
            }
            return BattleCalculator.getLowLuckAACasualties(planes, defendingAA, dice, terr, bridge);
        }
        if (BattleCalculator.isChooseAA(data)) {
            return BattleCalculator.chooseAACasualties(planes, dice, bridge, attacker, battleID, terr);
        }
        if (BattleCalculator.isRollAAIndividually(data)) {
            return BattleCalculator.IndividuallyFiredAACasualties(planes, defendingAA, dice, terr, bridge);
        }
        if (BattleCalculator.isRandomAACasualties(data)) {
            return BattleCalculator.RandomAACasualties(planes, dice, bridge);
        }
        return BattleCalculator.IndividuallyFiredAACasualties(planes, defendingAA, dice, terr, bridge);
    }

    private static Collection<Unit> chooseAACasualties(Collection<Unit> planes, DiceRoll dice, IDelegateBridge bridge, PlayerID attacker, GUID battleID, Territory terr) {
        String text = "Select " + dice.getHits() + " casualties from aa fire in " + terr.getName();
        CasualtyDetails casualtyMsg = BattleCalculator.selectCasualties(attacker, planes, bridge, text, dice, false, battleID);
        return casualtyMsg.getKilled();
    }

    public static Tuple<List<List<Unit>>, List<Unit>> categorizeLowLuckAirUnits(Collection<Unit> units, Territory location, int diceSides, int groupSize) {
        Set<UnitCategory> categorizedAir = UnitSeperator.categorize(units, null, false, true);
        ArrayList<ArrayList<Unit>> groupsOfSize = new ArrayList<ArrayList<Unit>>();
        ArrayList<Unit> toRoll = new ArrayList<Unit>();
        for (UnitCategory uc : categorizedAir) {
            int remainder = uc.getUnits().size() % groupSize;
            int splitPosition = uc.getUnits().size() - remainder;
            ArrayList<Unit> group = new ArrayList<Unit>(uc.getUnits().subList(0, splitPosition));
            if (!group.isEmpty()) {
                for (int i = 0; i < splitPosition; i += groupSize) {
                    ArrayList<Unit> miniGroup = new ArrayList<Unit>(uc.getUnits().subList(i, i + groupSize));
                    if (miniGroup.isEmpty()) continue;
                    groupsOfSize.add(miniGroup);
                }
            }
            toRoll.addAll(uc.getUnits().subList(splitPosition, uc.getUnits().size()));
        }
        return new Tuple<List<List<Unit>>, List<Unit>>(groupsOfSize, toRoll);
    }

    private static Collection<Unit> getLowLuckAACasualties(Collection<Unit> planes, Collection<Unit> defendingAA, DiceRoll dice, Territory location, IDelegateBridge bridge) {
        boolean tooManyHitsToDoGroups;
        ArrayList<Unit> hitUnits = new ArrayList<Unit>();
        int hitsLeft = dice.getHits();
        if (hitsLeft <= 0) {
            return hitUnits;
        }
        GameData data = bridge.getData();
        Tuple<Integer, Integer> attackThenDiceSides = DiceRoll.getAAattackAndMaxDiceSides(defendingAA, data);
        int highestAttack = attackThenDiceSides.getFirst();
        if (highestAttack < 1) {
            return hitUnits;
        }
        int chosenDiceSize = attackThenDiceSides.getSecond();
        Triple<Integer, Integer, Boolean> triple = DiceRoll.getTotalAAPowerThenHitsAndFillSortedDiceThenIfAllUseSameAttack(null, null, defendingAA, planes, data, false);
        boolean allSameAttackPower = triple.getThird();
        int groupSize = allSameAttackPower ? chosenDiceSize / highestAttack : chosenDiceSize;
        int numberOfGroupsByDiceSides = planes.size() / groupSize;
        if (planes.size() % groupSize > 0) {
            ++numberOfGroupsByDiceSides;
        }
        boolean bl = tooManyHitsToDoGroups = hitsLeft > numberOfGroupsByDiceSides;
        if (allSameAttackPower && !tooManyHitsToDoGroups) {
            Tuple<List<List<Unit>>, List<Unit>> airSplit = BattleCalculator.categorizeLowLuckAirUnits(planes, location, chosenDiceSize, groupSize);
            if (hitsLeft < airSplit.getFirst().size() || hitsLeft == airSplit.getFirst().size() && airSplit.getSecond().size() >= groupSize) {
                ArrayList<Unit> tempPossibleHitUnits = new ArrayList<Unit>();
                for (List<Unit> group : airSplit.getFirst()) {
                    tempPossibleHitUnits.add(group.get(0));
                }
                if (airSplit.getSecond().size() > 0) {
                    ArrayList remainders = new ArrayList(airSplit.getSecond());
                    int numberOfRemainderGroups = remainders.size() / groupSize;
                    if (remainders.size() % groupSize > 0) {
                        ++numberOfRemainderGroups;
                    }
                    int[] randomRemainder = bridge.getRandom(remainders.size(), numberOfRemainderGroups, null, IRandomStats.DiceType.ENGINE, "Deciding which planes should die due to AA fire");
                    int pos2 = 0;
                    for (int i = 0; i < randomRemainder.length; ++i) {
                        tempPossibleHitUnits.add((Unit)remainders.remove((pos2 += randomRemainder[i]) % remainders.size()));
                    }
                }
                int[] hitRandom = bridge.getRandom(tempPossibleHitUnits.size(), hitsLeft, null, IRandomStats.DiceType.ENGINE, "Deciding which planes should die due to AA fire");
                int pos = 0;
                for (int i = 0; i < hitRandom.length; ++i) {
                    hitUnits.add((Unit)tempPossibleHitUnits.remove((pos += hitRandom[i]) % tempPossibleHitUnits.size()));
                }
                hitsLeft = 0;
            } else {
                for (List<Unit> group : airSplit.getFirst()) {
                    hitUnits.add(group.get(0));
                    --hitsLeft;
                }
            }
            if (hitsLeft == airSplit.getSecond().size()) {
                hitUnits.addAll((Collection<Unit>)airSplit.getSecond());
                hitsLeft = 0;
            } else if (hitsLeft != 0) {
                int[] hitRandom = bridge.getRandom(airSplit.getSecond().size(), hitsLeft, null, IRandomStats.DiceType.ENGINE, "Deciding which planes should die due to AA fire");
                int pos = 0;
                for (int i = 0; i < hitRandom.length; ++i) {
                    hitUnits.add(airSplit.getSecond().remove((pos += hitRandom[i]) % airSplit.getSecond().size()));
                }
                hitsLeft = 0;
            }
        } else {
            hitUnits.addAll(BattleCalculator.RandomAACasualties(planes, dice, bridge));
        }
        if (hitUnits.size() != dice.getHits()) {
            throw new IllegalStateException("wrong number of casulaties, expected:" + dice + " but hit:" + hitUnits);
        }
        return hitUnits;
    }

    public static Collection<Unit> RandomAACasualties(Collection<Unit> planes, DiceRoll dice, IDelegateBridge bridge) {
        ArrayList<Unit> casualties = new ArrayList<Unit>();
        int hitsLeft = dice.getHits();
        if (hitsLeft <= 0) {
            return casualties;
        }
        ArrayList<Unit> planesList = new ArrayList<Unit>(planes);
        if (hitsLeft < planesList.size()) {
            int[] hitRandom = bridge.getRandom(planesList.size(), hitsLeft, null, IRandomStats.DiceType.ENGINE, "Deciding which planes should die due to AA fire");
            int pos = 0;
            for (int i = 0; i < hitRandom.length; ++i) {
                casualties.add((Unit)planesList.remove((pos += hitRandom[i]) % planesList.size()));
            }
        } else {
            casualties.addAll(planesList);
        }
        return casualties;
    }

    public static Collection<Unit> IndividuallyFiredAACasualties(Collection<Unit> planes, Collection<Unit> defendingAA, DiceRoll dice, Territory location, IDelegateBridge bridge) {
        ArrayList<Unit> planesList;
        if (DiceRoll.getTotalAAattacks(defendingAA, planes, bridge.getData()) != planes.size()) {
            return BattleCalculator.RandomAACasualties(planes, dice, bridge);
        }
        Triple<Integer, Integer, Boolean> triple = DiceRoll.getTotalAAPowerThenHitsAndFillSortedDiceThenIfAllUseSameAttack(null, null, defendingAA, planes, bridge.getData(), false);
        boolean allSameAttackPower = triple.getThird();
        if (!allSameAttackPower) {
            return BattleCalculator.RandomAACasualties(planes, dice, bridge);
        }
        Tuple<Integer, Integer> attackThenDiceSides = DiceRoll.getAAattackAndMaxDiceSides(defendingAA, bridge.getData());
        int highestAttack = attackThenDiceSides.getFirst();
        ArrayList<Unit> casualties = new ArrayList<Unit>();
        int hits = dice.getHits();
        if (hits < (planesList = new ArrayList<Unit>(planes)).size()) {
            List<Die> rolls = dice.getRolls(highestAttack);
            for (int i = 0; i < rolls.size(); ++i) {
                Die die = rolls.get(i);
                if (die.getType() != Die.DieType.HIT) continue;
                Unit unit = (Unit)planesList.get(i);
                casualties.add(unit);
            }
            planesList.removeAll(casualties);
        } else {
            casualties.addAll(planesList);
        }
        return casualties;
    }

    public static CasualtyDetails selectCasualties(PlayerID player, Collection<Unit> targets, IDelegateBridge bridge, String text, DiceRoll dice, boolean defending, GUID battleID) {
        return BattleCalculator.selectCasualties(null, player, targets, bridge, text, dice, defending, battleID, false, dice.getHits());
    }

    public static CasualtyDetails selectCasualties(String step, PlayerID player, Collection<Unit> targets, IDelegateBridge bridge, String text, DiceRoll dice, boolean defending, GUID battleID, boolean headLess, int extraHits) {
        GameData data = bridge.getData();
        boolean isEditMode = EditDelegate.getEditMode(data);
        ITripleaPlayer tripleaPlayer = player.isNull() ? new WeakAI(player.getName(), "E.Z. Fodder (AI)") : (ITripleaPlayer)bridge.getRemote(player);
        Map<Object, Object> dependents = headLess ? Collections.emptyMap() : BattleCalculator.getDependents(targets, data);
        if (isEditMode) {
            CasualtyDetails editSelection = tripleaPlayer.selectCasualties(targets, dependents, 0, text, dice, player, new CasualtyList(), battleID);
            List<Unit> killed = editSelection.getKilled();
            if (BattleCalculator.isPartialAmphibiousRetreat(data)) {
                killed = BattleCalculator.killAmphibiousFirst(killed, targets);
            }
            return editSelection;
        }
        if (dice.getHits() == 0) {
            return new CasualtyDetails(Collections.<Unit>emptyList(), Collections.<Unit>emptyList(), true);
        }
        int hitsRemaining = dice.getHits();
        if (BattleCalculator.isTransportCasualtiesRestricted(data)) {
            hitsRemaining = extraHits;
        }
        if (!isEditMode && BattleCalculator.allTargetsOneTypeNotTwoHit(targets, dependents)) {
            ArrayList<Unit> killed = new ArrayList<Unit>();
            Iterator<Unit> iter = targets.iterator();
            for (int i = 0; i < hitsRemaining && i < targets.size(); ++i) {
                killed.add(iter.next());
            }
            return new CasualtyDetails(killed, Collections.<Unit>emptyList(), true);
        }
        IntegerMap<UnitType> costs = BattleCalculator.getCostsForTUV(player, data);
        CasualtyList defaultCasualties = BattleCalculator.getDefaultCasualties(targets, hitsRemaining, defending, player, costs, data);
        int totalHitpoints = BattleCalculator.getTotalHitpoints(targets);
        CasualtyDetails casualtySelection = hitsRemaining >= totalHitpoints ? new CasualtyDetails(defaultCasualties, true) : tripleaPlayer.selectCasualties(targets, dependents, hitsRemaining, text, dice, player, defaultCasualties, battleID);
        List<Unit> killed = casualtySelection.getKilled();
        if (BattleCalculator.isPartialAmphibiousRetreat(data)) {
            killed = BattleCalculator.killAmphibiousFirst(killed, targets);
        }
        List<Unit> damaged = casualtySelection.getDamaged();
        int numhits = killed.size();
        for (Unit unit : killed) {
            UnitAttachment ua = UnitAttachment.get(unit.getType());
            if (!ua.getIsTwoHit() || unit.getHits() != 0) continue;
            ++numhits;
            damaged.remove(unit);
        }
        if (!isEditMode && numhits + damaged.size() != (hitsRemaining > totalHitpoints ? totalHitpoints : hitsRemaining)) {
            tripleaPlayer.reportError("Wrong number of casualties selected");
            return BattleCalculator.selectCasualties(player, targets, bridge, text, dice, defending, battleID);
        }
        if (!targets.containsAll(killed) || !targets.containsAll(damaged)) {
            tripleaPlayer.reportError("Cannot remove enough units of those types");
            return BattleCalculator.selectCasualties(player, targets, bridge, text, dice, defending, battleID);
        }
        return casualtySelection;
    }

    private static List<Unit> killAmphibiousFirst(List<Unit> killed, Collection<Unit> targets) {
        ArrayList<Unit> allAmphibUnits = new ArrayList<Unit>();
        ArrayList<Unit> killedNonAmphibUnits = new ArrayList<Unit>();
        ArrayList<UnitType> amphibTypes = new ArrayList<UnitType>();
        CompositeMatchAnd aMatch = new CompositeMatchAnd(Matches.UnitIsLand, Matches.UnitWasNotAmphibious);
        killedNonAmphibUnits.addAll(Match.getMatches(killed, aMatch));
        if (killedNonAmphibUnits.isEmpty()) {
            return killed;
        }
        allAmphibUnits.addAll(Match.getMatches(targets, Matches.UnitWasAmphibious));
        allAmphibUnits.removeAll(Match.getMatches(killed, Matches.UnitWasAmphibious));
        for (Unit unit : allAmphibUnits) {
            UnitType ut = unit.getType();
            if (amphibTypes.contains(ut)) continue;
            amphibTypes.add(ut);
        }
        for (Unit unit : killedNonAmphibUnits) {
            if (!amphibTypes.contains(unit.getType())) continue;
            List<Unit> oneAmphibUnit = Match.getNMatches(allAmphibUnits, 1, Matches.unitIsOfType(unit.getType()));
            if (oneAmphibUnit.size() > 0) {
                Unit amphibUnit = oneAmphibUnit.iterator().next();
                killed.remove(unit);
                killed.add(amphibUnit);
                allAmphibUnits.remove(amphibUnit);
                continue;
            }
            amphibTypes.remove(unit.getType());
        }
        return killed;
    }

    public static void EnableCasualtySortingCaching() {
        s_enableCasualtySortingCaching = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void DisableCasualtySortingCaching() {
        s_enableCasualtySortingCaching = false;
        Object object = s_cachedLock;
        synchronized (object) {
            s_cachedSortedCasualties.clear();
        }
    }

    private static CasualtyList getDefaultCasualties(Collection<Unit> targets, int hits, boolean defending, PlayerID player, IntegerMap<UnitType> costs, GameData data) {
        CasualtyList defaultCasualtySelection = new CasualtyList();
        int numSelectedCasualties = 0;
        Iterator<Unit> targetsIter = targets.iterator();
        while (targetsIter.hasNext()) {
            if (numSelectedCasualties >= hits) {
                return defaultCasualtySelection;
            }
            Unit unit = targetsIter.next();
            UnitAttachment ua = UnitAttachment.get(unit.getType());
            if (!ua.getIsTwoHit() || unit.getHits() != 0) continue;
            ++numSelectedCasualties;
            defaultCasualtySelection.addToDamaged(unit);
        }
        ArrayList<Unit> sorted = new ArrayList<Unit>(BattleCalculator.sortUnitsForCasualtiesWithSupport(targets, defending, player, costs, data, false));
        Iterator sortedIter = sorted.iterator();
        while (sortedIter.hasNext()) {
            if (numSelectedCasualties >= hits) {
                return defaultCasualtySelection;
            }
            Unit unit = (Unit)sortedIter.next();
            defaultCasualtySelection.addToKilled(unit);
            ++numSelectedCasualties;
        }
        return defaultCasualtySelection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Collection<Unit> sortUnitsForCasualtiesWithSupport(Collection<Unit> targets, boolean defending, PlayerID player, IntegerMap<UnitType> costs, GameData data, boolean bonus) {
        if (s_enableCasualtySortingCaching) {
            Object object = s_cachedLock;
            synchronized (object) {
                if (s_cachedSortedCasualties.containsKey(((Object)targets).hashCode())) {
                    return s_cachedSortedCasualties.get(((Object)targets).hashCode());
                }
            }
        }
        ArrayList<Unit> sortedUnitsList = new ArrayList<Unit>(targets);
        Collections.sort(sortedUnitsList, new UnitBattleComparator(defending, costs, data, bonus));
        ArrayList<Unit> perfectlySortedUnitsList = new ArrayList<Unit>();
        int artillerySupportAvailable = DiceRoll.getArtillerySupportAvailable(sortedUnitsList, defending, player);
        int supportableAvailable = DiceRoll.getSupportableAvailable(sortedUnitsList, defending, player);
        if (artillerySupportAvailable == 0 || supportableAvailable == 0) {
            return sortedUnitsList;
        }
        artillerySupportAvailable = 0;
        supportableAvailable = 0;
        ArrayList unitsByPowerAll = new ArrayList();
        ArrayList unitsByPowerBoth = new ArrayList();
        ArrayList unitsByPowerGives = new ArrayList();
        ArrayList unitsByPowerReceives = new ArrayList();
        ArrayList unitsByPowerNone = new ArrayList();
        int maxDiceTimesRolls = 1 + 2 * data.getDiceSides();
        int maxPower = Math.max(0, Math.min(BattleCalculator.getUnitPowerForSorting((Unit)sortedUnitsList.get(sortedUnitsList.size() - 1), defending, data), maxDiceTimesRolls));
        for (int i = 0; i <= maxPower; ++i) {
            unitsByPowerAll.add(new ArrayList());
            unitsByPowerBoth.add(new ArrayList());
            unitsByPowerGives.add(new ArrayList());
            unitsByPowerReceives.add(new ArrayList());
            unitsByPowerNone.add(new ArrayList());
        }
        for (Unit current : sortedUnitsList) {
            int unitPower = BattleCalculator.getUnitPowerForSorting(current, defending, data);
            unitPower = Math.max(0, Math.min(unitPower, maxPower));
            ((List)unitsByPowerAll.get(unitPower)).add(current);
            if (UnitAttachment.get(current.getType()).getArtillery() && UnitAttachment.get(current.getType()).getArtillerySupportable()) {
                ((List)unitsByPowerBoth.get(unitPower)).add(current);
                continue;
            }
            if (UnitAttachment.get(current.getType()).getArtillery()) {
                ((List)unitsByPowerGives.get(unitPower)).add(current);
                artillerySupportAvailable += DiceRoll.getArtillerySupportAvailable(current, defending, player);
                continue;
            }
            if (UnitAttachment.get(current.getType()).getArtillerySupportable()) {
                ((List)unitsByPowerReceives.get(unitPower)).add(current);
                supportableAvailable += DiceRoll.getSupportableAvailable(current, defending, player);
                continue;
            }
            ((List)unitsByPowerNone.get(unitPower)).add(current);
        }
        ArrayList tempList1 = new ArrayList();
        ArrayList tempList2 = new ArrayList();
        for (int i = 0; i <= maxPower; ++i) {
            int iArtillery = DiceRoll.getArtillerySupportAvailable((List)unitsByPowerGives.get(i), defending, player);
            int aboveArtillery = artillerySupportAvailable - iArtillery;
            artillerySupportAvailable -= iArtillery;
            int iSupportable = DiceRoll.getSupportableAvailable((List)unitsByPowerReceives.get(i), defending, player);
            int aboveSupportable = supportableAvailable - iSupportable;
            supportableAvailable -= iSupportable;
            if (iArtillery == 0 && iSupportable == 0 || iArtillery == 0 && aboveSupportable >= aboveArtillery || (iSupportable == 0 || iArtillery == 0) && aboveSupportable == aboveArtillery || iSupportable == 0 && aboveSupportable <= aboveArtillery || i == maxDiceTimesRolls) {
                perfectlySortedUnitsList.addAll((Collection)unitsByPowerAll.get(i));
                continue;
            }
            int count = 0;
            while (0 < ((List)unitsByPowerBoth.get(i)).size() || 0 < ((List)unitsByPowerGives.get(i)).size() || 0 < ((List)unitsByPowerReceives.get(i)).size() || 0 < ((List)unitsByPowerNone.get(i)).size()) {
                if (++count > 100000) {
                    throw new IllegalStateException("Infinite loop in sortUnitsForCasualtiesWithSupport.");
                }
                tempList1.clear();
                tempList2.clear();
                if (iArtillery == 0 && aboveArtillery - aboveSupportable > 0 && ((List)unitsByPowerReceives.get(i)).size() > 0) {
                    while (aboveArtillery - aboveSupportable > 0 && ((List)unitsByPowerReceives.get(i)).size() > 0) {
                        int last = ((List)unitsByPowerReceives.get(i)).size() - 1;
                        tempList2.add(((List)unitsByPowerReceives.get(i)).get(last));
                        aboveSupportable += DiceRoll.getSupportableAvailable((Unit)((List)unitsByPowerReceives.get(i)).get(last), defending, player);
                        ((List)unitsByPowerReceives.get(i)).remove(last);
                    }
                    tempList1.addAll((Collection)unitsByPowerNone.get(i));
                    tempList1.addAll((Collection)unitsByPowerGives.get(i));
                    tempList1.addAll((Collection)unitsByPowerReceives.get(i));
                    tempList1.addAll((Collection)unitsByPowerBoth.get(i));
                    ((List)unitsByPowerNone.get(i)).clear();
                    ((List)unitsByPowerGives.get(i)).clear();
                    ((List)unitsByPowerReceives.get(i)).clear();
                    ((List)unitsByPowerBoth.get(i)).clear();
                    Collections.sort(tempList1, new UnitBattleComparator(defending, costs, data, bonus));
                    Collections.sort(tempList2, new UnitBattleComparator(defending, costs, data, bonus));
                    perfectlySortedUnitsList.addAll(tempList1);
                    perfectlySortedUnitsList.addAll(tempList2);
                    continue;
                }
                if (iSupportable == 0 && aboveSupportable - aboveArtillery > 0 && ((List)unitsByPowerGives.get(i)).size() > 0) {
                    while (aboveSupportable - aboveArtillery > 0 && ((List)unitsByPowerGives.get(i)).size() > 0) {
                        int last = ((List)unitsByPowerGives.get(i)).size() - 1;
                        tempList2.add(((List)unitsByPowerGives.get(i)).get(last));
                        aboveArtillery += DiceRoll.getArtillerySupportAvailable((Unit)((List)unitsByPowerGives.get(i)).get(last), defending, player);
                        ((List)unitsByPowerGives.get(i)).remove(last);
                    }
                    tempList1.addAll((Collection)unitsByPowerNone.get(i));
                    tempList1.addAll((Collection)unitsByPowerGives.get(i));
                    tempList1.addAll((Collection)unitsByPowerReceives.get(i));
                    tempList1.addAll((Collection)unitsByPowerBoth.get(i));
                    ((List)unitsByPowerNone.get(i)).clear();
                    ((List)unitsByPowerGives.get(i)).clear();
                    ((List)unitsByPowerReceives.get(i)).clear();
                    ((List)unitsByPowerBoth.get(i)).clear();
                    Collections.sort(tempList1, new UnitBattleComparator(defending, costs, data, bonus));
                    Collections.sort(tempList2, new UnitBattleComparator(defending, costs, data, bonus));
                    perfectlySortedUnitsList.addAll(tempList1);
                    perfectlySortedUnitsList.addAll(tempList2);
                    continue;
                }
                if (iSupportable + aboveSupportable > iArtillery + aboveArtillery && ((List)unitsByPowerReceives.get(i)).size() > 0) {
                    while (iSupportable + aboveSupportable > iArtillery + aboveArtillery && ((List)unitsByPowerReceives.get(i)).size() > 0) {
                        boolean first = false;
                        tempList1.add(((List)unitsByPowerReceives.get(i)).get(0));
                        iSupportable -= DiceRoll.getSupportableAvailable((Unit)((List)unitsByPowerReceives.get(i)).get(0), defending, player);
                        ((List)unitsByPowerReceives.get(i)).remove(0);
                    }
                    tempList1.addAll((Collection)unitsByPowerNone.get(i));
                    tempList1.addAll((Collection)unitsByPowerBoth.get(i));
                    ((List)unitsByPowerNone.get(i)).clear();
                    ((List)unitsByPowerBoth.get(i)).clear();
                    Collections.sort(tempList1, new UnitBattleComparator(defending, costs, data, bonus));
                    perfectlySortedUnitsList.addAll(tempList1);
                    continue;
                }
                if (iSupportable + aboveSupportable < iArtillery + aboveArtillery) {
                    while (iSupportable + aboveSupportable < iArtillery + aboveArtillery && ((List)unitsByPowerGives.get(i)).size() > 0) {
                        boolean first = false;
                        tempList1.add(((List)unitsByPowerGives.get(i)).get(0));
                        iArtillery -= DiceRoll.getArtillerySupportAvailable((Unit)((List)unitsByPowerGives.get(i)).get(0), defending, player);
                        ((List)unitsByPowerGives.get(i)).remove(0);
                    }
                    tempList1.addAll((Collection)unitsByPowerNone.get(i));
                    tempList1.addAll((Collection)unitsByPowerBoth.get(i));
                    ((List)unitsByPowerNone.get(i)).clear();
                    ((List)unitsByPowerBoth.get(i)).clear();
                    Collections.sort(tempList1, new UnitBattleComparator(defending, costs, data, bonus));
                    perfectlySortedUnitsList.addAll(tempList1);
                    continue;
                }
                if (iSupportable + aboveSupportable == iArtillery + aboveArtillery) {
                    tempList1.addAll((Collection)unitsByPowerNone.get(i));
                    tempList1.addAll((Collection)unitsByPowerBoth.get(i));
                    ((List)unitsByPowerNone.get(i)).clear();
                    ((List)unitsByPowerBoth.get(i)).clear();
                    if (!((List)unitsByPowerGives.get(i)).isEmpty()) {
                        tempList2.add(((List)unitsByPowerGives.get(i)).get(0));
                    }
                    if (!((List)unitsByPowerReceives.get(i)).isEmpty()) {
                        tempList2.add(((List)unitsByPowerReceives.get(i)).get(0));
                    }
                    Collections.sort(tempList2, new UnitBattleComparator(defending, costs, data, bonus));
                    Unit u = (Unit)tempList2.get(0);
                    tempList1.add(u);
                    UnitAttachment ua = UnitAttachment.get(u.getType());
                    if (ua.getArtillery()) {
                        ((List)unitsByPowerGives.get(i)).remove(0);
                        iArtillery -= DiceRoll.getArtillerySupportAvailable(u, defending, player);
                    } else {
                        ((List)unitsByPowerReceives.get(i)).remove(0);
                        iSupportable -= DiceRoll.getSupportableAvailable(u, defending, player);
                    }
                    Collections.sort(tempList1, new UnitBattleComparator(defending, costs, data, bonus));
                    perfectlySortedUnitsList.addAll(tempList1);
                    continue;
                }
                throw new IllegalStateException("Possibility not accounted for in sortUnitsForCasualtiesWithSupport.");
            }
        }
        if (perfectlySortedUnitsList.isEmpty() || !perfectlySortedUnitsList.containsAll(sortedUnitsList) || !sortedUnitsList.containsAll(perfectlySortedUnitsList) || perfectlySortedUnitsList.size() != sortedUnitsList.size()) {
            throw new IllegalStateException("Possibility not accounted for in sortUnitsForCasualtiesWithSupport.");
        }
        if (s_enableCasualtySortingCaching) {
            Object object = s_cachedLock;
            synchronized (object) {
                if (!s_cachedSortedCasualties.containsKey(((Object)targets).hashCode())) {
                    s_cachedSortedCasualties.put(((Object)targets).hashCode(), perfectlySortedUnitsList);
                }
            }
        }
        return perfectlySortedUnitsList;
    }

    public static Map<Unit, Collection<Unit>> getDependents(Collection<Unit> targets, GameData data) {
        TransportTracker tracker = new TransportTracker();
        HashMap<Unit, Collection<Unit>> dependents = new HashMap<Unit, Collection<Unit>>();
        for (Unit target : targets) {
            dependents.put(target, tracker.transportingAndUnloaded(target));
        }
        return dependents;
    }

    public static IntegerMap<UnitType> getCostsForTUV(PlayerID player, GameData data) {
        data.acquireReadLock();
        Resource PUS = data.getResourceList().getResource("PUs");
        data.releaseReadLock();
        IntegerMap<UnitType> costs = new IntegerMap<UnitType>();
        ProductionFrontier frontier = player.getProductionFrontier();
        if (frontier == null) {
            return BattleCalculator.getCostsForTuvForAllPlayersMergedAndAveraged(data);
        }
        for (ProductionRule rule : frontier.getRules()) {
            int costPerGroup = rule.getCosts().getInt(PUS);
            UnitType type = (UnitType)rule.getResults().keySet().iterator().next();
            int numberProduced = rule.getResults().getInt(type);
            int roundedCostPerSingle = (int)Math.ceil((double)costPerGroup / (double)numberProduced);
            costs.put(type, roundedCostPerSingle);
        }
        IntegerMap<UnitType> costsAll = BattleCalculator.getCostsForTuvForAllPlayersMergedAndAveraged(data);
        for (UnitType ut : costsAll.keySet()) {
            if (costs.keySet().contains(ut)) continue;
            costs.put(ut, costsAll.getInt(ut));
        }
        return costs;
    }

    public static IntegerMap<UnitType> getCostsForTuvForAllPlayersMergedAndAveraged(GameData data) {
        data.acquireReadLock();
        Resource PUS = data.getResourceList().getResource("PUs");
        data.releaseReadLock();
        IntegerMap<UnitType> costs = new IntegerMap<UnitType>();
        HashMap differentCosts = new HashMap();
        for (ProductionRule rule : data.getProductionRuleList().getProductionRules()) {
            UnitType ut = (UnitType)rule.getResults().keySet().iterator().next();
            int numberProduced = rule.getResults().getInt(ut);
            int costPerGroup = rule.getCosts().getInt(PUS);
            int roundedCostPerSingle = (int)Math.ceil((double)costPerGroup / (double)numberProduced);
            if (differentCosts.containsKey(ut)) {
                ((List)differentCosts.get(ut)).add(roundedCostPerSingle);
                continue;
            }
            ArrayList<Integer> listTemp = new ArrayList<Integer>();
            listTemp.add(roundedCostPerSingle);
            differentCosts.put(ut, listTemp);
        }
        for (UnitType ut : differentCosts.keySet()) {
            int totalCosts = 0;
            List costsForType = (List)differentCosts.get(ut);
            Iterator i$ = costsForType.iterator();
            while (i$.hasNext()) {
                int cost = (Integer)i$.next();
                totalCosts += cost;
            }
            int averagedCost = (int)Math.round((double)totalCosts / (double)costsForType.size());
            costs.put(ut, averagedCost);
        }
        return costs;
    }

    public static int getTUV(Collection<Unit> units, IntegerMap<UnitType> costs) {
        int tuv = 0;
        for (Unit u : units) {
            int unitValue = costs.getInt(u.getType());
            tuv += unitValue;
        }
        return tuv;
    }

    public static int getTUV(Collection<Unit> units, PlayerID player, IntegerMap<UnitType> costs, GameData data) {
        List<Unit> playerUnits = Match.getMatches(units, Matches.alliedUnit(player, data));
        return BattleCalculator.getTUV(playerUnits, costs);
    }

    private static boolean allTargetsOneTypeNotTwoHit(Collection<Unit> targets, Map<Unit, Collection<Unit>> dependents) {
        UnitCategory unitCategory;
        Set<UnitCategory> categorized = UnitSeperator.categorize(targets, dependents, false, false);
        return categorized.size() == 1 && (!(unitCategory = categorized.iterator().next()).isTwoHit() || unitCategory.getDamaged());
    }

    public static int getRolls(Collection<Unit> units, Territory location, PlayerID id, boolean defend, Set<List<UnitSupportAttachment>> supportRulesCopy, IntegerMap<UnitSupportAttachment> supportLeftCopy, Collection<TerritoryEffect> territoryEffects) {
        int count = 0;
        for (Unit unit : units) {
            int unitRoll = BattleCalculator.getRolls(unit, location, id, defend, supportRulesCopy, supportLeftCopy, territoryEffects);
            count += unitRoll;
        }
        return count;
    }

    public static int getRolls(Collection<Unit> units, Territory location, PlayerID id, boolean defend, Collection<TerritoryEffect> territoryEffects) {
        return BattleCalculator.getRolls(units, location, id, defend, new HashSet<List<UnitSupportAttachment>>(), new IntegerMap<UnitSupportAttachment>(), territoryEffects);
    }

    public static int getRolls(Unit unit, Territory location, PlayerID id, boolean defend, Set<List<UnitSupportAttachment>> supportRulesCopy, IntegerMap<UnitSupportAttachment> supportLeftCopy, Collection<TerritoryEffect> territoryEffects) {
        UnitAttachment unitAttachment = UnitAttachment.get(unit.getType());
        int rolls = 0;
        rolls = defend ? unitAttachment.getDefenseRolls(id) : unitAttachment.getAttackRolls(id);
        if (rolls == 0 && unitAttachment.getAttack(id) == 0 && DiceRoll.getSupport(unit.getType(), supportRulesCopy, supportLeftCopy) > 0) {
            ++rolls;
        }
        if (rolls == 0 && unitAttachment.getAttack(id) == 0 && TerritoryEffectHelper.getTerritoryCombatBonus(unit.getType(), territoryEffects, defend) > 0) {
            ++rolls;
        }
        return rolls;
    }

    public static int getRolls(Unit unit, Territory location, PlayerID id, boolean defend, Collection<TerritoryEffect> territoryEffects) {
        return BattleCalculator.getRolls(unit, location, id, defend, new HashSet<List<UnitSupportAttachment>>(), new IntegerMap<UnitSupportAttachment>(), territoryEffects);
    }

    private static boolean isTransportCasualtiesRestricted(GameData data) {
        return Properties.getTransportCasualtiesRestricted(data);
    }

    private static boolean isRandomAACasualties(GameData data) {
        return Properties.getRandomAACasualties(data);
    }

    private static boolean isRollAAIndividually(GameData data) {
        return Properties.getRollAAIndividually(data);
    }

    private static boolean isChooseAA(GameData data) {
        return Properties.getChoose_AA_Casualties(data);
    }

    private static boolean isPartialAmphibiousRetreat(GameData data) {
        return Properties.getPartialAmphibiousRetreat(data);
    }

    private BattleCalculator() {
    }

    public static int getUnitPowerForSorting(Unit current, boolean defending, GameData data) {
        boolean lhtrBombers = Properties.getLHTR_Heavy_Bombers(data);
        UnitAttachment ua = UnitAttachment.get(current.getType());
        int rolls = defending ? ua.getDefenseRolls(current.getOwner()) : ua.getAttackRolls(current.getOwner());
        int strengthWithoutSupport = 0;
        if (rolls > 1 && (lhtrBombers || ua.getChooseBestRoll())) {
            strengthWithoutSupport = defending ? ua.getDefense(current.getOwner()) : ua.getAttack(current.getOwner());
            strengthWithoutSupport = Math.min(Math.max(strengthWithoutSupport + 1, 0), data.getDiceSides());
        } else {
            for (int i = 0; i < rolls; ++i) {
                int tempStrength = defending ? ua.getDefense(current.getOwner()) : ua.getAttack(current.getOwner());
                if (defending) {
                    // empty if block
                }
                strengthWithoutSupport += Math.min(Math.max(tempStrength, 0), data.getDiceSides());
            }
        }
        return strengthWithoutSupport;
    }
}

