/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.triplea.delegate;

import games.strategy.engine.data.Change;
import games.strategy.engine.data.ChangeFactory;
import games.strategy.engine.data.CompositeChange;
import games.strategy.engine.data.GameData;
import games.strategy.engine.data.PlayerID;
import games.strategy.engine.data.Resource;
import games.strategy.engine.data.ResourceCollection;
import games.strategy.engine.data.Territory;
import games.strategy.engine.data.Unit;
import games.strategy.engine.data.UnitType;
import games.strategy.engine.delegate.AutoSave;
import games.strategy.engine.delegate.IDelegateBridge;
import games.strategy.triplea.Properties;
import games.strategy.triplea.attatchments.ICondition;
import games.strategy.triplea.attatchments.RulesAttachment;
import games.strategy.triplea.attatchments.TerritoryAttachment;
import games.strategy.triplea.attatchments.TriggerAttachment;
import games.strategy.triplea.attatchments.UnitAttachment;
import games.strategy.triplea.delegate.AbstractEndTurnDelegate;
import games.strategy.triplea.delegate.Matches;
import games.strategy.triplea.formatter.MyFormatter;
import games.strategy.util.CompositeMatchAnd;
import games.strategy.util.CompositeMatchOr;
import games.strategy.util.IntegerMap;
import games.strategy.util.Match;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@AutoSave(afterStepEnd=true)
public class EndTurnDelegate
extends AbstractEndTurnDelegate {
    private static Match<RulesAttachment> availableUses = new Match<RulesAttachment>(){

        @Override
        public boolean match(RulesAttachment ra) {
            return ra.getUses() != 0;
        }
    };

    @Override
    protected void doNationalObjectivesAndOtherEndTurnEffects(IDelegateBridge bridge) {
        if (this.isNationalObjectives()) {
            this.determineNationalObjectives(bridge);
        }
        this.createResources(bridge);
        this.createUnits(bridge);
    }

    private void createUnits(IDelegateBridge bridge) {
        GameData data = this.getData();
        PlayerID player = data.getSequence().getStep().getPlayerID();
        CompositeMatchAnd myCreatorsMatch = new CompositeMatchAnd(Matches.unitIsOwnedBy(player), Matches.UnitCreatesUnits);
        CompositeChange change = new CompositeChange();
        for (Territory t : data.getMap().getTerritories()) {
            Change place;
            String transcriptText;
            CompositeMatchAnd<Territory> myTerrs;
            List<Unit> myCreators = Match.getMatches(t.getUnits().getUnits(), myCreatorsMatch);
            if (myCreators == null || myCreators.isEmpty()) continue;
            ArrayList<Unit> toAdd = new ArrayList<Unit>();
            ArrayList<Unit> toAddSea = new ArrayList<Unit>();
            ArrayList<Unit> toAddLand = new ArrayList<Unit>();
            for (Unit u : myCreators) {
                UnitAttachment ua = UnitAttachment.get(u.getType());
                IntegerMap<UnitType> createsUnitsMap = ua.getCreatesUnitsList();
                Set<UnitType> willBeCreated = createsUnitsMap.keySet();
                for (UnitType ut : willBeCreated) {
                    if (UnitAttachment.get(ut).getIsSea() && Matches.TerritoryIsLand.match(t)) {
                        toAddSea.addAll(ut.create(createsUnitsMap.getInt(ut), player));
                        continue;
                    }
                    if (!UnitAttachment.get(ut).getIsSea() && !UnitAttachment.get(ut).getIsAir() && Matches.TerritoryIsWater.match(t)) {
                        toAddLand.addAll(ut.create(createsUnitsMap.getInt(ut), player));
                        continue;
                    }
                    toAdd.addAll(ut.create(createsUnitsMap.getInt(ut), player));
                }
            }
            if (!toAdd.isEmpty()) {
                String transcriptText2 = player.getName() + " creates " + MyFormatter.unitsToTextNoOwner(toAdd) + " in " + t.getName();
                bridge.getHistoryWriter().startEvent(transcriptText2, toAdd);
                Change place2 = ChangeFactory.addUnits(t, toAdd);
                change.add(place2);
            }
            if (!toAddSea.isEmpty()) {
                myTerrs = new CompositeMatchAnd<Territory>(Matches.TerritoryIsWater);
                Set<Territory> waterNeighbors = data.getMap().getNeighbors(t, myTerrs);
                if (waterNeighbors != null && !waterNeighbors.isEmpty()) {
                    Territory tw = (Territory)waterNeighbors.iterator().next();
                    transcriptText = player.getName() + " creates " + MyFormatter.unitsToTextNoOwner(toAddSea) + " in " + tw.getName();
                    bridge.getHistoryWriter().startEvent(transcriptText, toAddSea);
                    place = ChangeFactory.addUnits(tw, toAddSea);
                    change.add(place);
                }
            }
            if (toAddLand.isEmpty()) continue;
            myTerrs = new CompositeMatchAnd(Matches.isTerritoryOwnedBy(player), Matches.TerritoryIsLand);
            Set<Territory> landNeighbors = data.getMap().getNeighbors(t, myTerrs);
            if (landNeighbors == null || landNeighbors.isEmpty()) continue;
            Territory tl = (Territory)landNeighbors.iterator().next();
            transcriptText = player.getName() + " creates " + MyFormatter.unitsToTextNoOwner(toAddLand) + " in " + tl.getName();
            bridge.getHistoryWriter().startEvent(transcriptText, toAddLand);
            place = ChangeFactory.addUnits(tl, toAddLand);
            change.add(place);
        }
        if (!change.isEmpty()) {
            bridge.addChange(change);
        }
    }

    private void createResources(IDelegateBridge bridge) {
        GameData data = this.getData();
        PlayerID player = data.getSequence().getStep().getPlayerID();
        CompositeMatchAnd myCreatorsMatch = new CompositeMatchAnd(Matches.unitIsOwnedBy(player), Matches.UnitCreatesResources);
        for (Territory t : data.getMap().getTerritories()) {
            List<Unit> myCreators = Match.getMatches(t.getUnits().getUnits(), myCreatorsMatch);
            if (myCreators == null || myCreators.isEmpty()) continue;
            for (Unit u : myCreators) {
                CompositeChange change = new CompositeChange();
                UnitAttachment ua = UnitAttachment.get(u.getType());
                IntegerMap<Resource> createsResourcesMap = ua.getCreatesResourcesList();
                Set<Resource> willBeCreated = createsResourcesMap.keySet();
                for (Resource r : willBeCreated) {
                    int total;
                    int toAdd = createsResourcesMap.getInt(r);
                    if (r.getName().equals("PUs")) {
                        toAdd *= Properties.getPU_Multiplier(data).intValue();
                    }
                    if ((total = player.getResources().getQuantity(r) + toAdd) < 0) {
                        toAdd -= total;
                        total = 0;
                    }
                    String transcriptText = u.getUnitType().getName() + " in " + t.getName() + " creates " + toAdd + " " + r.getName() + "; " + player.getName() + " end with " + total + " " + r.getName();
                    bridge.getHistoryWriter().startEvent(transcriptText);
                    Change resources = ChangeFactory.changeResourcesChange(player, r, toAdd);
                    change.add(resources);
                }
                if (change.isEmpty()) continue;
                bridge.addChange(change);
            }
        }
    }

    private void determineNationalObjectives(IDelegateBridge bridge) {
        GameData data = this.getData();
        PlayerID player = data.getSequence().getStep().getPlayerID();
        HashSet<TriggerAttachment> toFirePossible = new HashSet<TriggerAttachment>();
        HashSet<ICondition> allConditionsNeeded = new HashSet<ICondition>();
        boolean useTriggers = Properties.getTriggers(data);
        if (useTriggers) {
            CompositeMatchAnd<TriggerAttachment> endTurnDelegateTriggerMatch = new CompositeMatchAnd<TriggerAttachment>(TriggerAttachment.availableUses, TriggerAttachment.whenOrDefaultMatch(null, null), new CompositeMatchOr(TriggerAttachment.resourceMatch()));
            toFirePossible.addAll(TriggerAttachment.collectForAllTriggersMatching(new HashSet<PlayerID>(Collections.singleton(player)), endTurnDelegateTriggerMatch, bridge));
            allConditionsNeeded.addAll(RulesAttachment.getAllConditionsRecursive(new HashSet<ICondition>(toFirePossible), null));
        }
        List<RulesAttachment> natObjs = Match.getMatches(RulesAttachment.getNationalObjectives(player, data), availableUses);
        allConditionsNeeded.addAll(RulesAttachment.getAllConditionsRecursive(new HashSet<ICondition>(natObjs), null));
        if (allConditionsNeeded.isEmpty()) {
            return;
        }
        HashMap<ICondition, Boolean> testedConditions = RulesAttachment.testAllConditionsRecursive(allConditionsNeeded, null, bridge);
        if (useTriggers && !toFirePossible.isEmpty()) {
            HashSet<TriggerAttachment> toFireTestedAndSatisfied = new HashSet<TriggerAttachment>(Match.getMatches(toFirePossible, TriggerAttachment.isSatisfiedMatch(testedConditions)));
            TriggerAttachment.triggerResourceChange(toFireTestedAndSatisfied, bridge, null, null, true, true, true, true);
        }
        for (RulesAttachment rule : natObjs) {
            int uses = rule.getUses();
            if (uses == 0 || !rule.isSatisfied(testedConditions)) continue;
            int toAdd = rule.getObjectiveValue();
            toAdd *= Properties.getPU_Multiplier(data).intValue();
            int total = player.getResources().getQuantity("PUs") + (toAdd *= rule.getEachMultiple());
            if (total < 0) {
                toAdd -= total;
                total = 0;
            }
            Change change = ChangeFactory.changeResourcesChange(player, data.getResourceList().getResource("PUs"), toAdd);
            bridge.addChange(change);
            if (uses > 0) {
                Change use = ChangeFactory.attachmentPropertyChange(rule, Integer.toString(--uses), "uses");
                bridge.addChange(use);
            }
            String PUMessage = MyFormatter.attachmentNameToText(rule.getName()) + ": " + player.getName() + " met a national objective for an additional " + toAdd + MyFormatter.pluralize(" PU", toAdd) + "; end with " + total + MyFormatter.pluralize(" PU", total);
            bridge.getHistoryWriter().startEvent(PUMessage);
        }
    }

    private boolean isNationalObjectives() {
        return Properties.getNationalObjectives(this.getData());
    }

    @Override
    protected void addOtherResources(IDelegateBridge aBridge) {
        GameData data = aBridge.getData();
        CompositeChange change = new CompositeChange();
        Collection<Territory> territories = data.getMap().getTerritoriesOwnedBy(this.m_player);
        ResourceCollection productionCollection = EndTurnDelegate.getResourceProduction(territories, data);
        IntegerMap<Resource> production = productionCollection.getResourcesCopy();
        for (Map.Entry<Resource, Integer> resource : production.entrySet()) {
            Resource r = resource.getKey();
            int toAdd = resource.getValue();
            int total = this.m_player.getResources().getQuantity(r) + toAdd;
            if (total < 0) {
                toAdd -= total;
                total = 0;
            }
            aBridge.getHistoryWriter().startEvent(this.m_player.getName() + " collects " + toAdd + " " + MyFormatter.pluralize(r.getName(), toAdd) + "; ends with " + total + " " + MyFormatter.pluralize(r.getName(), total) + " total");
            change.add(ChangeFactory.changeResourcesChange(this.m_player, r, toAdd));
        }
        if (!change.isEmpty()) {
            aBridge.addChange(change);
        }
    }

    public static ResourceCollection getResourceProduction(Collection<Territory> territories, GameData data) {
        ResourceCollection rVal = new ResourceCollection(data);
        for (Territory current : territories) {
            TerritoryAttachment attachment = (TerritoryAttachment)current.getAttachment("territoryAttatchment");
            if (attachment == null) {
                throw new IllegalStateException("No attachment for owned territory:" + current.getName());
            }
            ResourceCollection toAdd = attachment.getResources();
            if (toAdd == null || !Matches.territoryCanCollectIncomeFrom(current.getOwner(), data).match(current)) continue;
            rVal.add(toAdd);
        }
        return rVal;
    }
}

