/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.triplea.delegate;

import games.strategy.engine.data.GameData;
import games.strategy.engine.data.GameStep;
import games.strategy.engine.data.PlayerID;
import games.strategy.engine.data.RelationshipTracker;
import games.strategy.engine.data.RelationshipType;
import games.strategy.engine.data.Route;
import games.strategy.engine.data.Territory;
import games.strategy.engine.data.Unit;
import games.strategy.engine.data.UnitType;
import games.strategy.triplea.Properties;
import games.strategy.triplea.TripleAUnit;
import games.strategy.triplea.attatchments.ICondition;
import games.strategy.triplea.attatchments.PlayerAttachment;
import games.strategy.triplea.attatchments.PoliticalActionAttachment;
import games.strategy.triplea.attatchments.RulesAttachment;
import games.strategy.triplea.attatchments.TechAttachment;
import games.strategy.triplea.attatchments.TerritoryAttachment;
import games.strategy.triplea.attatchments.UnitAttachment;
import games.strategy.triplea.attatchments.UnitSupportAttachment;
import games.strategy.triplea.delegate.BattleTracker;
import games.strategy.triplea.delegate.IBattle;
import games.strategy.triplea.delegate.MoveDelegate;
import games.strategy.triplea.delegate.MoveValidator;
import games.strategy.triplea.delegate.OriginalOwnerTracker;
import games.strategy.triplea.delegate.TechTracker;
import games.strategy.triplea.delegate.TransportTracker;
import games.strategy.triplea.util.UnitCategory;
import games.strategy.triplea.util.UnitSeperator;
import games.strategy.util.CompositeMatch;
import games.strategy.util.CompositeMatchAnd;
import games.strategy.util.CompositeMatchOr;
import games.strategy.util.IntegerMap;
import games.strategy.util.InverseMatch;
import games.strategy.util.Match;
import games.strategy.util.Tuple;
import games.strategy.util.Util;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Matches {
    public static final Match<Object> IsTerritory = new Match<Object>(){

        @Override
        public boolean match(Object o) {
            return o != null && o instanceof Territory;
        }
    };
    public static final Match<Unit> UnitIsTwoHit = new Match<Unit>(){

        @Override
        public boolean match(Unit unit) {
            return UnitTypeIsTwoHit.match(unit.getType());
        }
    };
    public static final Match<UnitType> UnitTypeIsTwoHit = new Match<UnitType>(){

        @Override
        public boolean match(UnitType ut) {
            UnitAttachment ua = UnitAttachment.get(ut);
            return ua.getIsTwoHit();
        }
    };
    public static final Match<Unit> UnitIsDamaged = new Match<Unit>(){

        @Override
        public boolean match(Unit unit) {
            return unit.getHits() > 0;
        }
    };
    public static final Match<Unit> UnitIsNotDamaged = new InverseMatch<Unit>(UnitIsDamaged);
    public static final Match<Unit> UnitIsSea = new Match<Unit>(){

        @Override
        public boolean match(Unit unit) {
            UnitAttachment ua = UnitAttachment.get(unit.getType());
            return ua.getIsSea();
        }
    };
    public static final Match<Unit> UnitIsSub = new Match<Unit>(){

        @Override
        public boolean match(Unit unit) {
            UnitAttachment ua = UnitAttachment.get(unit.getType());
            return ua.getIsSub();
        }
    };
    public static final Match<Unit> UnitIsNotSub = new InverseMatch<Unit>(UnitIsSub);
    public static final Match<Unit> UnitIsCombatTransport = new Match<Unit>(){

        @Override
        public boolean match(Unit unit) {
            UnitAttachment ua = UnitAttachment.get(unit.getType());
            return ua.getIsCombatTransport() && ua.getIsSea();
        }
    };
    public static final Match<Unit> UnitIsNotCombatTransport = new InverseMatch<Unit>(UnitIsCombatTransport);
    public static final Match<Unit> UnitIsTransportButNotCombatTransport = new Match<Unit>(){

        @Override
        public boolean match(Unit unit) {
            UnitAttachment ua = UnitAttachment.get(unit.getType());
            return ua.getTransportCapacity() != -1 && ua.getIsSea() && !ua.getIsCombatTransport();
        }
    };
    public static final Match<Unit> UnitIsNotTransportButCouldBeCombatTransport = new Match<Unit>(){

        @Override
        public boolean match(Unit unit) {
            UnitAttachment ua = UnitAttachment.get(unit.getType());
            if (ua.getTransportCapacity() == -1) {
                return true;
            }
            return ua.getIsCombatTransport() && ua.getIsSea();
        }
    };
    public static final Match<Unit> UnitIsDestroyer = new Match<Unit>(){

        @Override
        public boolean match(Unit unit) {
            UnitAttachment ua = UnitAttachment.get(unit.getType());
            return ua.getIsDestroyer();
        }
    };
    public static final Match<UnitType> UnitTypeIsDestroyer = new Match<UnitType>(){

        @Override
        public boolean match(UnitType type) {
            UnitAttachment ua = UnitAttachment.get(type);
            return ua.getIsDestroyer();
        }
    };
    public static final Match<Unit> UnitIsBB = new Match<Unit>(){

        @Override
        public boolean match(Unit unit) {
            UnitAttachment ua = UnitAttachment.get(unit.getType());
            if (!ua.getIsSea()) {
                return false;
            }
            return ua.getIsTwoHit();
        }
    };
    public static final Match<Unit> UnitIsTransport = new Match<Unit>(){

        @Override
        public boolean match(Unit unit) {
            UnitAttachment ua = UnitAttachment.get(unit.getType());
            return ua.getTransportCapacity() != -1 && ua.getIsSea();
        }
    };
    public static final Match<Unit> UnitIsNotTransport = UnitIsTransport.invert();
    public static final Match<Unit> UnitIsTransportAndNotDestroyer = new Match<Unit>(){

        @Override
        public boolean match(Unit unit) {
            UnitAttachment ua = UnitAttachment.get(unit.getType());
            return !UnitIsDestroyer.match(unit) && ua.getTransportCapacity() != -1 && ua.getIsSea();
        }
    };
    public static final Match<UnitType> UnitTypeIsStrategicBomber = new Match<UnitType>(){

        @Override
        public boolean match(UnitType obj) {
            UnitAttachment ua = UnitAttachment.get(obj);
            if (ua == null) {
                return false;
            }
            return ua.getIsStrategicBomber();
        }
    };
    public static final Match<Unit> UnitIsStrategicBomber = new Match<Unit>(){

        @Override
        public boolean match(Unit obj) {
            return UnitTypeIsStrategicBomber.match(obj.getType());
        }
    };
    public static final Match<Unit> UnitIsNotStrategicBomber = new InverseMatch<Unit>(UnitIsStrategicBomber);
    public static final Match<UnitType> UnitTypeCanLandOnCarrier = new Match<UnitType>(){

        @Override
        public boolean match(UnitType obj) {
            UnitAttachment ua = UnitAttachment.get(obj);
            if (ua == null) {
                return false;
            }
            return ua.getCarrierCost() != -1;
        }
    };
    public static final Match<UnitType> UnitTypeCannotLandOnCarrier = new InverseMatch<UnitType>(UnitTypeCanLandOnCarrier);
    public static final Match<Unit> unitHasMoved = new Match<Unit>(){

        @Override
        public boolean match(Unit obj) {
            Unit unit = obj;
            return TripleAUnit.get(unit).getAlreadyMoved() > 0;
        }
    };
    public static final Match<Unit> unitHasNotMoved = new InverseMatch<Unit>(unitHasMoved);
    public static final Match<Unit> UnitIsNotSea = new Match<Unit>(){

        @Override
        public boolean match(Unit obj) {
            Unit unit = obj;
            UnitAttachment ua = UnitAttachment.get(unit.getType());
            return !ua.getIsSea();
        }
    };
    public static final Match<UnitType> UnitTypeIsSea = new Match<UnitType>(){

        @Override
        public boolean match(UnitType obj) {
            UnitAttachment ua = UnitAttachment.get(obj);
            return ua.getIsSea();
        }
    };
    public static final Match<UnitType> UnitTypeIsNotSea = new Match<UnitType>(){

        @Override
        public boolean match(UnitType type) {
            UnitAttachment ua = UnitAttachment.get(type);
            return !ua.getIsSea();
        }
    };
    public static final Match<UnitType> UnitTypeIsSeaOrAir = new Match<UnitType>(){

        @Override
        public boolean match(UnitType type) {
            UnitAttachment ua = UnitAttachment.get(type);
            return ua.getIsSea() || ua.getIsAir();
        }
    };
    public static final Match<UnitType> UnitTypeIsCarrier = new Match<UnitType>(){

        @Override
        public boolean match(UnitType type) {
            UnitAttachment ua = UnitAttachment.get(type);
            return ua.getCarrierCapacity() != -1;
        }
    };
    public static final Match<Unit> UnitIsAir = new Match<Unit>(){

        @Override
        public boolean match(Unit unit) {
            UnitAttachment ua = UnitAttachment.get(unit.getType());
            return ua.getIsAir();
        }
    };
    public static final Match<Unit> UnitIsNotAir = new Match<Unit>(){

        @Override
        public boolean match(Unit unit) {
            UnitAttachment ua = UnitAttachment.get(unit.getType());
            return !ua.getIsAir();
        }
    };
    public static final Match<Unit> UnitIsAirBase = new Match<Unit>(){

        @Override
        public boolean match(Unit unit) {
            UnitAttachment ua = UnitAttachment.get(unit.getType());
            return ua.getIsAirBase();
        }
    };
    public static final Match<Unit> UnitCanBeDamaged = new Match<Unit>(){

        @Override
        public boolean match(Unit unit) {
            return UnitTypeCanBeDamaged.match(unit.getType());
        }
    };
    public static final Match<UnitType> UnitTypeCanBeDamaged = new Match<UnitType>(){

        @Override
        public boolean match(UnitType ut) {
            UnitAttachment ua = UnitAttachment.get(ut);
            return ua.getCanBeDamaged();
        }
    };
    public static final Match<Unit> UnitCanDieFromReachingMaxDamage = new Match<Unit>(){

        @Override
        public boolean match(Unit unit) {
            UnitAttachment ua = UnitAttachment.get(unit.getType());
            if (!ua.getCanBeDamaged()) {
                return false;
            }
            return ua.getCanDieFromReachingMaxDamage();
        }
    };
    public static final Match<Unit> UnitIsInfrastructure = new Match<Unit>(){

        @Override
        public boolean match(Unit unit) {
            return UnitTypeIsInfrastructure.match(unit.getType());
        }
    };
    public static final Match<Unit> UnitIsNotInfrastructure = new InverseMatch<Unit>(UnitIsInfrastructure);
    public static final Match<UnitType> UnitTypeIsInfrastructure = new Match<UnitType>(){

        @Override
        public boolean match(UnitType ut) {
            UnitAttachment ua = UnitAttachment.get(ut);
            return ua.getIsInfrastructure();
        }
    };
    public static final Match<Unit> UnitCanScramble = new Match<Unit>(){

        @Override
        public boolean match(Unit unit) {
            UnitAttachment ua = UnitAttachment.get(unit.getType());
            return ua.getCanScramble();
        }
    };
    public static final Match<Unit> UnitWasScrambled = new Match<Unit>(){

        @Override
        public boolean match(Unit obj) {
            TripleAUnit taUnit = (TripleAUnit)obj;
            return taUnit.getWasScrambled();
        }
    };
    public static final Match<Unit> UnitWasInAirBattle = new Match<Unit>(){

        @Override
        public boolean match(Unit obj) {
            TripleAUnit taUnit = (TripleAUnit)obj;
            return taUnit.getWasInAirBattle();
        }
    };
    public static final Match<Territory> TerritoryIsIsland = new Match<Territory>(){

        @Override
        public boolean match(Territory t) {
            Set<Territory> neighbors = t.getData().getMap().getNeighbors(t);
            return neighbors.size() == 1 && TerritoryIsWater.match((Territory)neighbors.iterator().next());
        }
    };
    public static final Match<Unit> UnitCanBlitz = new Match<Unit>(){

        @Override
        public boolean match(Unit obj) {
            Unit unit = obj;
            UnitAttachment ua = UnitAttachment.get(unit.getType());
            return ua.getCanBlitz(obj.getOwner());
        }
    };
    public static final Match<Unit> UnitIsLandTransport = new Match<Unit>(){

        @Override
        public boolean match(Unit obj) {
            Unit unit = obj;
            UnitAttachment ua = UnitAttachment.get(unit.getType());
            return ua.getIsLandTransport();
        }
    };
    public static final Match<Unit> UnitIsSuicide = new Match<Unit>(){

        @Override
        public boolean match(Unit obj) {
            Unit unit = obj;
            UnitAttachment ua = UnitAttachment.get(unit.getType());
            return ua.getIsSuicide();
        }
    };
    public static final Match<Unit> UnitIsKamikaze = new Match<Unit>(){

        @Override
        public boolean match(Unit obj) {
            Unit unit = obj;
            UnitAttachment ua = UnitAttachment.get(unit.getType());
            return ua.getIsKamikaze();
        }
    };
    public static final Match<UnitType> UnitTypeIsAir = new Match<UnitType>(){

        @Override
        public boolean match(UnitType obj) {
            UnitType type = obj;
            UnitAttachment ua = UnitAttachment.get(type);
            return ua.getIsAir();
        }
    };
    public static final Match<UnitType> UnitTypeIsNotAir = new Match<UnitType>(){

        @Override
        public boolean match(UnitType obj) {
            UnitType type = obj;
            UnitAttachment ua = UnitAttachment.get(type);
            return !ua.getIsAir();
        }
    };
    public static final Match<Unit> UnitCanLandOnCarrier = new Match<Unit>(){

        @Override
        public boolean match(Unit obj) {
            Unit unit = obj;
            UnitAttachment ua = UnitAttachment.get(unit.getType());
            return ua.getCarrierCost() != -1;
        }
    };
    public static final Match<Unit> UnitIsCarrier = new Match<Unit>(){

        @Override
        public boolean match(Unit obj) {
            Unit unit = obj;
            UnitAttachment ua = UnitAttachment.get(unit.getType());
            return ua.getCarrierCapacity() != -1;
        }
    };
    public static final Match<Unit> UnitCanBeTransported = new Match<Unit>(){

        @Override
        public boolean match(Unit obj) {
            Unit unit = obj;
            UnitAttachment ua = UnitAttachment.get(unit.getType());
            return ua.getTransportCost() != -1;
        }
    };
    public static final Match<Unit> UnitCanNotBeTransported = new InverseMatch<Unit>(UnitCanBeTransported);
    public static final Match<Unit> UnitWasAmphibious = new Match<Unit>(){

        @Override
        public boolean match(Unit obj) {
            TripleAUnit taUnit = (TripleAUnit)obj;
            return taUnit.getWasAmphibious();
        }
    };
    public static final Match<Unit> UnitWasNotAmphibious = new InverseMatch<Unit>(UnitWasAmphibious);
    public static final Match<Unit> UnitWasInCombat = new Match<Unit>(){

        @Override
        public boolean match(Unit obj) {
            TripleAUnit taUnit = (TripleAUnit)obj;
            return taUnit.getWasInCombat();
        }
    };
    public static final Match<Unit> UnitWasUnloadedThisTurn = new Match<Unit>(){

        @Override
        public boolean match(Unit obj) {
            TripleAUnit taUnit = (TripleAUnit)obj;
            return taUnit.getUnloadedTo() != null;
        }
    };
    public static final Match<Unit> UnitWasLoadedThisTurn = new Match<Unit>(){

        @Override
        public boolean match(Unit obj) {
            TripleAUnit taUnit = (TripleAUnit)obj;
            return taUnit.getWasLoadedThisTurn();
        }
    };
    public static final Match<Unit> UnitWasNotLoadedThisTurn = new InverseMatch<Unit>(UnitWasLoadedThisTurn);
    public static final Match<Unit> UnitCanTransport = new Match<Unit>(){

        @Override
        public boolean match(Unit obj) {
            Unit unit = obj;
            UnitAttachment ua = UnitAttachment.get(unit.getType());
            return ua.getTransportCapacity() != -1;
        }
    };
    public static final Match<UnitType> UnitTypeCanTransport = new Match<UnitType>(){

        @Override
        public boolean match(UnitType obj) {
            UnitType type = obj;
            UnitAttachment ua = UnitAttachment.get(type);
            return ua.getTransportCapacity() != -1;
        }
    };
    public static final Match<UnitType> UnitTypeCanBeTransported = new Match<UnitType>(){

        @Override
        public boolean match(UnitType obj) {
            UnitType type = obj;
            UnitAttachment ua = UnitAttachment.get(type);
            return ua.getTransportCost() != -1;
        }
    };
    public static final Match<Unit> UnitCanProduceUnits = new Match<Unit>(){

        @Override
        public boolean match(Unit obj) {
            return UnitTypeCanProduceUnits.match(obj.getType());
        }
    };
    public static final Match<UnitType> UnitTypeCanProduceUnits = new Match<UnitType>(){

        @Override
        public boolean match(UnitType obj) {
            UnitAttachment ua = UnitAttachment.get(obj);
            return ua.getCanProduceUnits();
        }
    };
    public static final Match<Unit> UnitCanNotProduceUnits = new InverseMatch<Unit>(UnitCanProduceUnits);
    public static final Match<UnitType> UnitTypeIsInfrastructureButNotAAofAnyKind = new Match<UnitType>(){

        @Override
        public boolean match(UnitType type) {
            return UnitTypeIsInfrastructure.match(type) && !UnitTypeIsAAforAnything.match(type);
        }
    };
    public static final Match<UnitType> UnitTypeIsInfantry = new Match<UnitType>(){

        @Override
        public boolean match(UnitType obj) {
            UnitType type = obj;
            UnitAttachment ua = UnitAttachment.get(type);
            return ua.getIsInfantry();
        }
    };
    public static final Match<UnitType> UnitTypeIsArtillery = new Match<UnitType>(){

        @Override
        public boolean match(UnitType obj) {
            UnitType type = obj;
            UnitAttachment ua = UnitAttachment.get(type);
            return ua.getArtillery();
        }
    };
    public static final Match<Unit> UnitHasMaxBuildRestrictions = new Match<Unit>(){

        @Override
        public boolean match(Unit obj) {
            UnitType type = obj.getType();
            return UnitTypeHasMaxBuildRestrictions.match(type);
        }
    };
    public static final Match<UnitType> UnitTypeHasMaxBuildRestrictions = new Match<UnitType>(){

        @Override
        public boolean match(UnitType obj) {
            UnitType type = obj;
            UnitAttachment ua = UnitAttachment.get(type);
            return ua.getMaxBuiltPerPlayer() >= 0;
        }
    };
    public static final Match<Unit> UnitIsRocket = new Match<Unit>(){

        @Override
        public boolean match(Unit obj) {
            return UnitTypeIsRocket.match(obj.getType());
        }
    };
    public static final Match<UnitType> UnitTypeIsRocket = new Match<UnitType>(){

        @Override
        public boolean match(UnitType obj) {
            UnitAttachment ua = UnitAttachment.get(obj);
            return ua.getIsRocket();
        }
    };
    public static final Match<Unit> UnitHasPlacementLimit = new Match<Unit>(){

        @Override
        public boolean match(Unit obj) {
            UnitType type = obj.getUnitType();
            UnitAttachment ua = UnitAttachment.get(type);
            return ua.getPlacementLimit() != null;
        }
    };
    public static final Match<Unit> UnitHasMovementLimit = new Match<Unit>(){

        @Override
        public boolean match(Unit obj) {
            UnitType type = obj.getUnitType();
            UnitAttachment ua = UnitAttachment.get(type);
            return ua.getMovementLimit() != null;
        }
    };
    public static final Match<Unit> UnitHasAttackingLimit = new Match<Unit>(){

        @Override
        public boolean match(Unit obj) {
            UnitType type = obj.getUnitType();
            UnitAttachment ua = UnitAttachment.get(type);
            return ua.getAttackingLimit() != null;
        }
    };
    public static final Match<Unit> UnitCanNotMoveDuringCombatMove = new Match<Unit>(){

        @Override
        public boolean match(Unit obj) {
            return UnitTypeCanNotMoveDuringCombatMove.match(obj.getType());
        }
    };
    public static final Match<UnitType> UnitTypeCanNotMoveDuringCombatMove = new Match<UnitType>(){

        @Override
        public boolean match(UnitType type) {
            UnitAttachment ua = UnitAttachment.get(type);
            return ua.getCanNotMoveDuringCombatMove();
        }
    };
    public static final Match<Unit> UnitIsAAforCombatOnly = new Match<Unit>(){

        @Override
        public boolean match(Unit obj) {
            return UnitTypeIsAAforCombatOnly.match(obj.getType());
        }
    };
    public static final Match<UnitType> UnitTypeIsAAforCombatOnly = new Match<UnitType>(){

        @Override
        public boolean match(UnitType obj) {
            UnitAttachment ua = UnitAttachment.get(obj);
            return ua.getIsAAforCombatOnly();
        }
    };
    public static final Match<Unit> UnitIsAAforBombingThisUnitOnly = new Match<Unit>(){

        @Override
        public boolean match(Unit obj) {
            return UnitTypeIsAAforBombingThisUnitOnly.match(obj.getType());
        }
    };
    public static final Match<UnitType> UnitTypeIsAAforBombingThisUnitOnly = new Match<UnitType>(){

        @Override
        public boolean match(UnitType obj) {
            UnitAttachment ua = UnitAttachment.get(obj);
            return ua.getIsAAforBombingThisUnitOnly();
        }
    };
    public static final Match<Unit> UnitIsAAforFlyOverOnly = new Match<Unit>(){

        @Override
        public boolean match(Unit obj) {
            return UnitTypeIsAAforFlyOverOnly.match(obj.getType());
        }
    };
    public static final Match<UnitType> UnitTypeIsAAforFlyOverOnly = new Match<UnitType>(){

        @Override
        public boolean match(UnitType obj) {
            UnitAttachment ua = UnitAttachment.get(obj);
            return ua.getIsAAforFlyOverOnly();
        }
    };
    public static final Match<Unit> UnitIsAAforAnything = new Match<Unit>(){

        @Override
        public boolean match(Unit obj) {
            return UnitTypeIsAAforAnything.match(obj.getType());
        }
    };
    public static final Match<UnitType> UnitTypeIsAAforAnything = new Match<UnitType>(){

        @Override
        public boolean match(UnitType obj) {
            UnitAttachment ua = UnitAttachment.get(obj);
            return ua.getIsAAforBombingThisUnitOnly() || ua.getIsAAforCombatOnly() || ua.getIsAAforFlyOverOnly();
        }
    };
    public static final Match<Unit> UnitIsNotAA = new InverseMatch<Unit>(UnitIsAAforAnything);
    public static final Match<Unit> UnitMaxAAattacksIsInfinite = new Match<Unit>(){

        @Override
        public boolean match(Unit obj) {
            return UnitTypeMaxAAattacksIsInfinite.match(obj.getType());
        }
    };
    public static final Match<UnitType> UnitTypeMaxAAattacksIsInfinite = new Match<UnitType>(){

        @Override
        public boolean match(UnitType obj) {
            UnitAttachment ua = UnitAttachment.get(obj);
            return ua.getMaxAAattacks() == -1;
        }
    };
    public static final Match<Unit> UnitMayOverStackAA = new Match<Unit>(){

        @Override
        public boolean match(Unit obj) {
            return UnitTypeMayOverStackAA.match(obj.getType());
        }
    };
    public static final Match<UnitType> UnitTypeMayOverStackAA = new Match<UnitType>(){

        @Override
        public boolean match(UnitType obj) {
            UnitAttachment ua = UnitAttachment.get(obj);
            return ua.getMayOverStackAA();
        }
    };
    public static final Match<Unit> UnitAttackAAisGreaterThanZeroAndMaxAAattacksIsNotZero = new Match<Unit>(){

        @Override
        public boolean match(Unit obj) {
            UnitAttachment ua = UnitAttachment.get(obj.getType());
            return ua.getAttackAA(obj.getOwner()) > 0 && ua.getMaxAAattacks() != 0;
        }
    };
    public static final Match<Unit> UnitIsInfantry = new Match<Unit>(){

        @Override
        public boolean match(Unit obj) {
            UnitType type = obj.getUnitType();
            UnitAttachment ua = UnitAttachment.get(type);
            return ua.getIsInfantry();
        }
    };
    public static final Match<Unit> UnitIsNotInfantry = new InverseMatch<Unit>(UnitIsInfantry);
    public static final Match<Unit> UnitIsMarine = new Match<Unit>(){

        @Override
        public boolean match(Unit obj) {
            UnitType type = obj.getUnitType();
            UnitAttachment ua = UnitAttachment.get(type);
            return ua.getIsMarine();
        }
    };
    public static final Match<Unit> UnitIsNotMarine = new InverseMatch<Unit>(UnitIsMarine);
    public static final Match<Unit> UnitIsAirTransportable = new Match<Unit>(){

        @Override
        public boolean match(Unit obj) {
            TechAttachment ta = TechAttachment.get(obj.getOwner());
            if (ta == null || !ta.getParatroopers()) {
                return false;
            }
            UnitType type = obj.getUnitType();
            UnitAttachment ua = UnitAttachment.get(type);
            return ua.getIsAirTransportable();
        }
    };
    public static final Match<Unit> UnitIsNotAirTransportable = new InverseMatch<Unit>(UnitIsAirTransportable);
    public static final Match<Unit> UnitIsAirTransport = new Match<Unit>(){

        @Override
        public boolean match(Unit obj) {
            TechAttachment ta = TechAttachment.get(obj.getOwner());
            if (ta == null || !ta.getParatroopers()) {
                return false;
            }
            UnitType type = obj.getUnitType();
            UnitAttachment ua = UnitAttachment.get(type);
            return ua.getIsAirTransport();
        }
    };
    public static final Match<Unit> UnitIsNotAirTransport = new InverseMatch<Unit>(UnitIsAirTransport);
    public static final Match<Unit> UnitIsArtillery = new Match<Unit>(){

        @Override
        public boolean match(Unit obj) {
            UnitType type = obj.getUnitType();
            UnitAttachment ua = UnitAttachment.get(type);
            return ua.getArtillery();
        }
    };
    public static final Match<Unit> UnitIsArtillerySupportable = new Match<Unit>(){

        @Override
        public boolean match(Unit obj) {
            UnitType type = obj.getUnitType();
            UnitAttachment ua = UnitAttachment.get(type);
            return ua.getArtillerySupportable();
        }
    };
    public static final Match<Territory> TerritoryIsLandOrWater = new Match<Territory>(){

        @Override
        public boolean match(Territory t) {
            return t != null;
        }
    };
    public static final Match<Territory> TerritoryIsWater = new Match<Territory>(){

        @Override
        public boolean match(Territory t) {
            return t.isWater();
        }
    };
    public static final Match<Territory> TerritoryIsVictoryCity = new Match<Territory>(){

        @Override
        public boolean match(Territory t) {
            TerritoryAttachment ta = TerritoryAttachment.get(t);
            if (ta == null) {
                return false;
            }
            return ta.getVictoryCity();
        }
    };
    public static final Match<Territory> TerritoryHasSomeDamage = new Match<Territory>(){

        @Override
        public boolean match(Territory t) {
            TerritoryAttachment ta = TerritoryAttachment.get(t);
            if (ta == null) {
                return false;
            }
            return ta.getUnitProduction() < ta.getProduction();
        }
    };
    public static final Match<Territory> TerritoryIsLand = new InverseMatch<Territory>(TerritoryIsWater);
    public static final Match<Territory> TerritoryIsEmpty = new Match<Territory>(){

        @Override
        public boolean match(Territory t) {
            return t.getUnits().size() == 0;
        }
    };
    public static final Match<Territory> TerritoryIsNeutralButNotWater = new Match<Territory>(){

        @Override
        public boolean match(Territory t) {
            if (t.isWater()) {
                return false;
            }
            return t.getOwner().equals(PlayerID.NULL_PLAYERID);
        }
    };
    public static final Match<Territory> TerritoryIsNotNeutralButCouldBeWater = new InverseMatch<Territory>(TerritoryIsNeutralButNotWater);
    public static final Match<Territory> TerritoryIsImpassable = new Match<Territory>(){

        @Override
        public boolean match(Territory t) {
            if (t.isWater()) {
                return false;
            }
            return TerritoryAttachment.get(t).getIsImpassible();
        }
    };
    public static final Match<Territory> TerritoryIsNotImpassable = new InverseMatch<Territory>(TerritoryIsImpassable);
    public static final Match<IBattle> BattleIsEmpty = new Match<IBattle>(){

        @Override
        public boolean match(IBattle battle) {
            return battle.isEmpty();
        }
    };
    public static final Match<IBattle> BattleIsAmphibious = new Match<IBattle>(){

        @Override
        public boolean match(IBattle battle) {
            return battle.isAmphibious();
        }
    };
    public static final Match<Unit> unitHasMovementLeft = new Match<Unit>(){

        @Override
        public boolean match(Unit o) {
            return TripleAUnit.get(o).getMovementLeft() >= 1;
        }
    };
    public static final Match<Unit> UnitCanMove = new Match<Unit>(){

        @Override
        public boolean match(Unit u) {
            return Matches.UnitTypeCanMove(u.getOwner()).match(u.getType());
        }
    };
    public static final Match<Unit> UnitIsStatic = new InverseMatch<Unit>(UnitCanMove);
    public static final Match<Unit> UnitIsLand = new CompositeMatchAnd<Unit>(UnitIsNotSea, UnitIsNotAir);
    public static final Match<Unit> UnitIsNotLand = new InverseMatch<Unit>(UnitIsLand);
    public static final Match<UnitType> UnitTypeIsSub = new Match<UnitType>(){

        @Override
        public boolean match(UnitType obj) {
            UnitType type = obj;
            UnitAttachment ua = UnitAttachment.get(type);
            return ua.getIsSub();
        }
    };
    public static final Match<UnitType> UnitTypeIsBB = new Match<UnitType>(){

        @Override
        public boolean match(UnitType obj) {
            UnitType type = obj;
            UnitAttachment ua = UnitAttachment.get(type);
            return ua.getIsTwoHit();
        }
    };
    public static final Match<Unit> UnitCanRepairOthers = new Match<Unit>(){

        @Override
        public boolean match(Unit unit) {
            if (Matches.UnitIsDisabled().match(unit)) {
                return false;
            }
            UnitAttachment ua = UnitAttachment.get(unit.getType());
            if (ua.getRepairsUnits() == null) {
                return false;
            }
            return ua.getRepairsUnits().length > 0;
        }
    };
    public static final Match<Unit> UnitCanGiveBonusMovement = new Match<Unit>(){

        @Override
        public boolean match(Unit obj) {
            Unit unit = obj;
            UnitAttachment ua = UnitAttachment.get(unit.getType());
            if (ua == null) {
                return false;
            }
            return ua.getGivesMovement().size() > 0;
        }
    };
    public static final Match<Unit> UnitCreatesUnits = new Match<Unit>(){

        @Override
        public boolean match(Unit obj) {
            Unit unit = obj;
            UnitAttachment ua = UnitAttachment.get(unit.getType());
            if (ua == null) {
                return false;
            }
            return ua.getCreatesUnitsList() != null && ua.getCreatesUnitsList().size() > 0;
        }
    };
    public static final Match<Unit> UnitCreatesResources = new Match<Unit>(){

        @Override
        public boolean match(Unit obj) {
            Unit unit = obj;
            UnitAttachment ua = UnitAttachment.get(unit.getType());
            if (ua == null) {
                return false;
            }
            return ua.getCreatesResourcesList() != null && ua.getCreatesResourcesList().size() > 0;
        }
    };
    public static final Match<UnitType> UnitTypeConsumesUnitsOnCreation = new Match<UnitType>(){

        @Override
        public boolean match(UnitType obj) {
            UnitType unit = obj;
            UnitAttachment ua = UnitAttachment.get(unit);
            if (ua == null) {
                return false;
            }
            return ua.getConsumesUnits() != null && ua.getConsumesUnits().size() > 0;
        }
    };
    public static final Match<Unit> UnitConsumesUnitsOnCreation = new Match<Unit>(){

        @Override
        public boolean match(Unit obj) {
            Unit unit = obj;
            UnitAttachment ua = UnitAttachment.get(unit.getType());
            if (ua == null) {
                return false;
            }
            return ua.getConsumesUnits() != null && ua.getConsumesUnits().size() > 0;
        }
    };
    public static final Match<Unit> UnitRequiresUnitsOnCreation = new Match<Unit>(){

        @Override
        public boolean match(Unit obj) {
            Unit unit = obj;
            UnitAttachment ua = UnitAttachment.get(unit.getType());
            if (ua == null) {
                return false;
            }
            return ua.getRequiresUnits() != null && ua.getRequiresUnits().size() > 0;
        }
    };
    public static final Match<Territory> territoryIsBlockadeZone = new Match<Territory>(){

        @Override
        public boolean match(Territory t) {
            TerritoryAttachment ta = TerritoryAttachment.get(t);
            if (ta != null) {
                return ta.getBlockadeZone();
            }
            return false;
        }
    };
    public static final Match<Unit> UnitIsConstruction = new Match<Unit>(){

        @Override
        public boolean match(Unit obj) {
            return UnitTypeIsConstruction.match(obj.getType());
        }
    };
    public static final Match<UnitType> UnitTypeIsConstruction = new Match<UnitType>(){

        @Override
        public boolean match(UnitType type) {
            UnitAttachment ua = UnitAttachment.get(type);
            if (ua == null) {
                return false;
            }
            return ua.getIsConstruction();
        }
    };
    public static final Match<Unit> UnitIsNotConstruction = new InverseMatch<Unit>(UnitIsConstruction);
    public static final Match<Unit> UnitCanProduceUnitsAndIsConstruction = new CompositeMatchAnd<Unit>(UnitCanProduceUnits, UnitIsConstruction);
    public static final Match<UnitType> UnitTypeCanProduceUnitsAndIsConstruction = new CompositeMatchAnd<UnitType>(UnitTypeCanProduceUnits, UnitTypeIsConstruction);
    public static final Match<Unit> UnitCanProduceUnitsAndIsInfrastructure = new CompositeMatchAnd<Unit>(UnitCanProduceUnits, UnitIsInfrastructure);
    public static final Match<Unit> UnitCanProduceUnitsAndCanBeDamaged = new CompositeMatchAnd<Unit>(UnitCanProduceUnits, UnitCanBeDamaged);
    public static final Match<Unit> UnitCanInvade = new Match<Unit>(){

        @Override
        public boolean match(Unit unit) {
            Unit transport = TripleAUnit.get(unit).getTransportedBy();
            if (transport == null) {
                return true;
            }
            UnitAttachment ua = UnitAttachment.get(unit.getType());
            return ua.canInvadeFrom(transport.getUnitType().getName());
        }
    };
    public static final Match<RelationshipType> RelationshipTypeIsAllied = new Match<RelationshipType>(){

        @Override
        public boolean match(RelationshipType relationship) {
            return relationship.getRelationshipTypeAttachment().isAllied();
        }
    };
    public static final Match<RelationshipTracker.Relationship> RelationshipIsAllied = new Match<RelationshipTracker.Relationship>(){

        @Override
        public boolean match(RelationshipTracker.Relationship relationship) {
            return relationship.getRelationshipType().getRelationshipTypeAttachment().isAllied();
        }
    };
    public static final Match<RelationshipType> RelationshipTypeIsNeutral = new Match<RelationshipType>(){

        @Override
        public boolean match(RelationshipType relationship) {
            return relationship.getRelationshipTypeAttachment().isNeutral();
        }
    };
    public static final Match<RelationshipTracker.Relationship> RelationshipIsNeutral = new Match<RelationshipTracker.Relationship>(){

        @Override
        public boolean match(RelationshipTracker.Relationship relationship) {
            return relationship.getRelationshipType().getRelationshipTypeAttachment().isNeutral();
        }
    };
    public static final Match<RelationshipType> RelationshipTypeIsAtWar = new Match<RelationshipType>(){

        @Override
        public boolean match(RelationshipType relationship) {
            return relationship.getRelationshipTypeAttachment().isWar();
        }
    };
    public static final Match<RelationshipTracker.Relationship> RelationshipIsAtWar = new Match<RelationshipTracker.Relationship>(){

        @Override
        public boolean match(RelationshipTracker.Relationship relationship) {
            return relationship.getRelationshipType().getRelationshipTypeAttachment().isWar();
        }
    };
    public static final Match<RelationshipType> RelationshipTypeCanMoveLandUnitsOverOwnedLand = new Match<RelationshipType>(){

        @Override
        public boolean match(RelationshipType relationship) {
            return relationship.getRelationshipTypeAttachment().getCanMoveLandUnitsOverOwnedLand();
        }
    };
    public static final Match<RelationshipType> RelationshipTypeCanMoveAirUnitsOverOwnedLand = new Match<RelationshipType>(){

        @Override
        public boolean match(RelationshipType relationship) {
            return relationship.getRelationshipTypeAttachment().getCanMoveAirUnitsOverOwnedLand();
        }
    };
    public static final Match<RelationshipType> RelationshipTypeCanLandAirUnitsOnOwnedLand = new Match<RelationshipType>(){

        @Override
        public boolean match(RelationshipType relationship) {
            return relationship.getRelationshipTypeAttachment().getCanLandAirUnitsOnOwnedLand();
        }
    };
    public static final Match<RelationshipType> RelationshipTypeCanTakeOverOwnedTerritory = new Match<RelationshipType>(){

        @Override
        public boolean match(RelationshipType relationship) {
            return relationship.getRelationshipTypeAttachment().getCanTakeOverOwnedTerritory();
        }
    };
    public static final Match<RelationshipType> RelationshipTypeGivesBackOriginalTerritories = new Match<RelationshipType>(){

        @Override
        public boolean match(RelationshipType relationship) {
            return relationship.getRelationshipTypeAttachment().getGivesBackOriginalTerritories();
        }
    };
    public static final Match<RelationshipType> RelationshipTypeCanMoveIntoDuringCombatMove = new Match<RelationshipType>(){

        @Override
        public boolean match(RelationshipType relationship) {
            return relationship.getRelationshipTypeAttachment().getCanMoveIntoDuringCombatMove();
        }
    };
    public static final Match<RelationshipType> RelationshipTypeCanMoveThroughCanals = new Match<RelationshipType>(){

        @Override
        public boolean match(RelationshipType relationship) {
            return relationship.getRelationshipTypeAttachment().getCanMoveThroughCanals();
        }
    };
    public static final Match<RelationshipType> RelationshipTypeRocketsCanFlyOver = new Match<RelationshipType>(){

        @Override
        public boolean match(RelationshipType relationship) {
            return relationship.getRelationshipTypeAttachment().getRocketsCanFlyOver();
        }
    };
    public static final Match<Unit> UnitCanOnlyPlaceInOriginalTerritories = new Match<Unit>(){

        @Override
        public boolean match(Unit u) {
            UnitAttachment ua = UnitAttachment.get(u.getType());
            HashSet<String> specialOptions = ua.getSpecial();
            for (String option : specialOptions) {
                if (!option.equals("canOnlyPlaceInOriginalTerritories")) continue;
                return true;
            }
            return false;
        }
    };
    public static final Match<RelationshipType> RelationshipTypeIsAlliedAndAlliancesCanChainTogether = new Match<RelationshipType>(){

        @Override
        public boolean match(RelationshipType rt) {
            return RelationshipTypeIsAllied.match(rt) && rt.getRelationshipTypeAttachment().getAlliancesCanChainTogether();
        }
    };
    public static final Match<RelationshipType> RelationshipTypeIsDefaultWarPosition = new Match<RelationshipType>(){

        @Override
        public boolean match(RelationshipType rt) {
            return rt.getRelationshipTypeAttachment().getIsDefaultWarPosition();
        }
    };
    public static final Match<Unit> unitCanIntercept = new Match<Unit>(){

        @Override
        public boolean match(Unit u) {
            return UnitAttachment.get(u.getType()).getCanIntercept();
        }
    };
    public static final Match<Unit> unitCanEscort = new Match<Unit>(){

        @Override
        public boolean match(Unit u) {
            return UnitAttachment.get(u.getType()).getCanEscort();
        }
    };
    public static final Match<Unit> UnitIsAirborne = new Match<Unit>(){

        @Override
        public boolean match(Unit obj) {
            return ((TripleAUnit)obj).getAirborne();
        }
    };

    public static Match<Unit> unitCanAttack(final PlayerID id) {
        return new Match<Unit>(){

            @Override
            public boolean match(Unit unit) {
                UnitAttachment ua = UnitAttachment.get(unit.getType());
                if (ua.getMovement(id) <= 0) {
                    return false;
                }
                return ua.getAttack(id) > 0;
            }
        };
    }

    public static Match<UnitType> unitTypeCanAttack(final PlayerID id) {
        return new Match<UnitType>(){

            @Override
            public boolean match(UnitType uT) {
                UnitAttachment ua = UnitAttachment.get(uT);
                if (ua.getMovement(id) <= 0) {
                    return false;
                }
                return ua.getAttack(id) > 0;
            }
        };
    }

    public static Match<Unit> unitHasAttackValueOfAtLeast(final int attackValue) {
        return new Match<Unit>(){

            @Override
            public boolean match(Unit unit) {
                UnitAttachment ua = UnitAttachment.get(unit.getType());
                return ua.getAttack(unit.getOwner()) >= attackValue;
            }
        };
    }

    public static Match<Unit> unitHasDefendValueOfAtLeast(final int defendValue) {
        return new Match<Unit>(){

            @Override
            public boolean match(Unit unit) {
                UnitAttachment ua = UnitAttachment.get(unit.getType());
                return ua.getDefense(unit.getOwner()) >= defendValue;
            }
        };
    }

    public static Match<Unit> unitIsEnemyOf(final GameData data, final PlayerID player) {
        return new Match<Unit>(){

            @Override
            public boolean match(Unit u) {
                return data.getRelationshipTracker().isAtWar(u.getOwner(), player);
            }
        };
    }

    public static Match<UnitType> unitTypeCanBombard(final PlayerID id) {
        return new Match<UnitType>(){

            @Override
            public boolean match(UnitType type) {
                UnitAttachment ua = UnitAttachment.get(type);
                return ua.getCanBombard(id);
            }
        };
    }

    public static Match<Unit> UnitCanBeGivenByTerritoryTo(final PlayerID player) {
        return new Match<Unit>(){

            @Override
            public boolean match(Unit o) {
                Unit unit = o;
                UnitAttachment ua = UnitAttachment.get(unit.getType());
                return ua.getCanBeGivenByTerritoryTo().contains(player);
            }
        };
    }

    public static Match<Unit> UnitCanBeCapturedOnEnteringToInThisTerritory(final PlayerID player, final Territory terr, final GameData data) {
        return new Match<Unit>(){

            @Override
            public boolean match(Unit o) {
                if (!Properties.getCaptureUnitsOnEnteringTerritory(data)) {
                    return false;
                }
                Unit unit = o;
                PlayerID unitOwner = unit.getOwner();
                UnitAttachment ua = UnitAttachment.get(unit.getType());
                boolean unitCanBeCapturedByPlayer = ua.getCanBeCapturedOnEnteringBy().contains(player);
                TerritoryAttachment ta = TerritoryAttachment.get(terr);
                if (ta == null) {
                    return false;
                }
                if (ta.getCaptureUnitOnEnteringBy() == null) {
                    return false;
                }
                boolean territoryCanHaveUnitsThatCanBeCapturedByPlayer = ta.getCaptureUnitOnEnteringBy().contains(player);
                PlayerAttachment pa = PlayerAttachment.get(unitOwner);
                if (pa == null) {
                    return false;
                }
                if (pa.getCaptureUnitOnEnteringBy() == null) {
                    return false;
                }
                boolean unitOwnerCanLetUnitsBeCapturedByPlayer = pa.getCaptureUnitOnEnteringBy().contains(player);
                return unitCanBeCapturedByPlayer && territoryCanHaveUnitsThatCanBeCapturedByPlayer && unitOwnerCanLetUnitsBeCapturedByPlayer;
            }
        };
    }

    public static Match<Unit> UnitDestroyedWhenCapturedByOrFrom(final PlayerID playerBY) {
        return new Match<Unit>(){

            @Override
            public boolean match(Unit o) {
                CompositeMatchOr<Unit> byOrFrom = new CompositeMatchOr<Unit>(Matches.UnitDestroyedWhenCapturedBy(playerBY), Matches.UnitDestroyedWhenCapturedFrom());
                return ((Match)byOrFrom).match(o);
            }
        };
    }

    public static Match<Unit> UnitDestroyedWhenCapturedBy(final PlayerID playerBY) {
        return new Match<Unit>(){

            @Override
            public boolean match(Unit u) {
                UnitAttachment ua = UnitAttachment.get(u.getType());
                if (ua.getDestroyedWhenCapturedBy().isEmpty()) {
                    return false;
                }
                for (Tuple<String, PlayerID> tuple : ua.getDestroyedWhenCapturedBy()) {
                    if (!tuple.getFirst().equals("BY") || !tuple.getSecond().equals(playerBY)) continue;
                    return true;
                }
                return false;
            }
        };
    }

    public static Match<Unit> UnitDestroyedWhenCapturedFrom() {
        return new Match<Unit>(){

            @Override
            public boolean match(Unit u) {
                UnitAttachment ua = UnitAttachment.get(u.getType());
                if (ua.getDestroyedWhenCapturedBy().isEmpty()) {
                    return false;
                }
                for (Tuple<String, PlayerID> tuple : ua.getDestroyedWhenCapturedBy()) {
                    if (!tuple.getFirst().equals("FROM") || !tuple.getSecond().equals(u.getOwner())) continue;
                    return true;
                }
                return false;
            }
        };
    }

    public static Match<Unit> UnitIsAtMaxDamageOrNotCanBeDamaged(final Territory t) {
        return new Match<Unit>(){

            @Override
            public boolean match(Unit unit) {
                UnitAttachment ua = UnitAttachment.get(unit.getType());
                if (!ua.getCanBeDamaged()) {
                    return true;
                }
                if (Properties.getSBRAffectsUnitProduction(unit.getData())) {
                    TerritoryAttachment ta = TerritoryAttachment.get(t);
                    int currentDamage = ta.getProduction() - ta.getUnitProduction();
                    return currentDamage >= 2 * ta.getProduction();
                }
                if (Properties.getDamageFromBombingDoneToUnitsInsteadOfTerritories(unit.getData())) {
                    TripleAUnit taUnit = (TripleAUnit)unit;
                    return taUnit.getUnitDamage() >= taUnit.getHowMuchDamageCanThisUnitTakeTotal(unit, t);
                }
                return false;
            }
        };
    }

    public static Match<Unit> UnitIsLegalBombingTargetBy(final Unit bomberOrRocket) {
        return new Match<Unit>(){

            @Override
            public boolean match(Unit unit) {
                UnitAttachment ua = UnitAttachment.get(bomberOrRocket.getType());
                HashSet<UnitType> allowedTargets = ua.getBombingTargets(bomberOrRocket.getData());
                return allowedTargets == null || allowedTargets.contains(unit.getType());
            }
        };
    }

    public static Match<Unit> UnitHasSomeUnitDamage() {
        return new Match<Unit>(){

            @Override
            public boolean match(Unit unit) {
                TripleAUnit taUnit = (TripleAUnit)unit;
                return taUnit.getUnitDamage() > 0;
            }
        };
    }

    public static Match<Unit> UnitIsDisabled() {
        return new Match<Unit>(){

            @Override
            public boolean match(Unit unit) {
                if (!UnitCanBeDamaged.match(unit)) {
                    return false;
                }
                if (!Properties.getDamageFromBombingDoneToUnitsInsteadOfTerritories(unit.getData()) || Properties.getSBRAffectsUnitProduction(unit.getData())) {
                    return false;
                }
                UnitAttachment ua = UnitAttachment.get(unit.getType());
                TripleAUnit taUnit = (TripleAUnit)unit;
                if (ua.getMaxOperationalDamage() < 0) {
                    return false;
                }
                return taUnit.getUnitDamage() > ua.getMaxOperationalDamage();
            }
        };
    }

    public static final Match<Unit> UnitIsSupporterOrHasCombatAbility(final boolean attack, final GameData data) {
        return new Match<Unit>(){

            @Override
            public boolean match(Unit unit) {
                return Matches.UnitTypeIsSupporterOrHasCombatAbility(attack, unit.getOwner(), data).match(unit.getType());
            }
        };
    }

    public static final Match<UnitType> UnitTypeIsSupporterOrHasCombatAbility(final boolean attack, final PlayerID player, final GameData data) {
        return new Match<UnitType>(){

            @Override
            public boolean match(UnitType ut) {
                UnitAttachment ua = UnitAttachment.get(ut);
                if (attack && ua.getAttack(player) > 0) {
                    return true;
                }
                if (!attack && ua.getDefense(player) > 0) {
                    return true;
                }
                for (UnitSupportAttachment rule : UnitSupportAttachment.get(data)) {
                    if (!ut.equals(rule.getAttachedTo())) continue;
                    return true;
                }
                return false;
            }
        };
    }

    public static Match<Unit> unitCanBombard(final PlayerID id) {
        return new Match<Unit>(){

            @Override
            public boolean match(Unit unit) {
                UnitAttachment ua = UnitAttachment.get(unit.getType());
                return ua.getCanBombard(id);
            }
        };
    }

    public static final Match<Unit> UnitIsNotInfrastructureAndNotCapturedOnEntering(final PlayerID player, final Territory terr, final GameData data) {
        return new Match<Unit>(){

            @Override
            public boolean match(Unit obj) {
                Unit unit = obj;
                UnitAttachment ua = UnitAttachment.get(unit.getType());
                return !ua.getIsInfrastructure() && !Matches.UnitCanBeCapturedOnEnteringToInThisTerritory(player, terr, data).match(unit);
            }
        };
    }

    public static final Match<Territory> TerritoryHasOwnedCarrier(final PlayerID player) {
        return new Match<Territory>(){

            @Override
            public boolean match(Territory t) {
                return t.getUnits().someMatch(new CompositeMatchAnd<Unit>(Matches.unitIsOwnedBy(player), UnitIsCarrier));
            }
        };
    }

    public static final Match<Unit> UnitIsAlliedCarrier(final PlayerID player, final GameData data) {
        return new Match<Unit>(){

            @Override
            public boolean match(Unit obj) {
                Unit unit = obj;
                UnitAttachment ua = UnitAttachment.get(unit.getType());
                return ua.getCarrierCapacity() != -1 && data.getRelationshipTracker().isAllied(player, obj.getOwner());
            }
        };
    }

    public static final Match<Unit> UnitIsAAthatCanHitTheseUnits(final Collection<Unit> targets, final Match<Unit> typeOfAA, final HashMap<String, HashSet<UnitType>> airborneTechTargetsAllowed) {
        return new Match<Unit>(){

            @Override
            public boolean match(Unit obj) {
                if (!typeOfAA.match(obj)) {
                    return false;
                }
                UnitAttachment ua = UnitAttachment.get(obj.getType());
                HashSet<UnitType> targetsAA = ua.getTargetsAA(obj.getData());
                for (Unit u : targets) {
                    if (!targetsAA.contains(u.getType())) continue;
                    return true;
                }
                return Match.someMatch(targets, new CompositeMatchAnd(UnitIsAirborne, Matches.unitIsOfTypes((Set)airborneTechTargetsAllowed.get(ua.getTypeAA()))));
            }
        };
    }

    public static final Match<Unit> UnitIsAAofTypeAA(final String typeAA) {
        return new Match<Unit>(){

            @Override
            public boolean match(Unit obj) {
                return UnitAttachment.get(obj.getType()).getTypeAA().matches(typeAA);
            }
        };
    }

    public static final Match<Unit> UnitIsAAthatWillNotFireIfPresentEnemyUnits(final Collection<Unit> enemyUnitsPresent) {
        return new Match<Unit>(){

            @Override
            public boolean match(Unit obj) {
                for (Unit u : enemyUnitsPresent) {
                    if (!UnitAttachment.get(obj.getType()).getWillNotFireIfPresent().contains(u.getType())) continue;
                    return true;
                }
                return false;
            }
        };
    }

    public static final Match<Unit> UnitIsAAthatCanFire(Collection<Unit> unitsMovingOrAttacking, HashMap<String, HashSet<UnitType>> airborneTechTargetsAllowed, PlayerID playerMovingOrAttacking, Match<Unit> typeOfAA, GameData data) {
        return new CompositeMatchAnd<Unit>(Matches.enemyUnit(playerMovingOrAttacking, data), Matches.unitIsBeingTransported().invert(), Matches.UnitIsAAthatCanHitTheseUnits(unitsMovingOrAttacking, typeOfAA, airborneTechTargetsAllowed), Matches.UnitIsAAthatWillNotFireIfPresentEnemyUnits(unitsMovingOrAttacking).invert());
    }

    public static Match<Unit> unitIsInTerritoryThatHasTerritoryDamage(final Territory t) {
        return new Match<Unit>(){

            @Override
            public boolean match(Unit u) {
                return TerritoryHasSomeDamage.match(t);
            }
        };
    }

    public static Match<Territory> territoryCanCollectIncomeFrom(final PlayerID player, final GameData data) {
        return new Match<Territory>(){

            @Override
            public boolean match(Territory t) {
                TerritoryAttachment ta = TerritoryAttachment.get(t);
                if (ta == null) {
                    return false;
                }
                PlayerID origOwner = ta.getOccupiedTerrOf();
                if (origOwner == null) {
                    origOwner = OriginalOwnerTracker.getOriginalOwner(t);
                }
                if (t.isWater() && origOwner != null && origOwner != PlayerID.NULL_PLAYERID && origOwner != player) {
                    return false;
                }
                if (ta.getConvoyRoute() && !ta.getConvoyAttached().isEmpty()) {
                    boolean atLeastOne = false;
                    for (Territory convoy : ta.getConvoyAttached()) {
                        if (!data.getRelationshipTracker().isAllied(convoy.getOwner(), player) || !TerritoryAttachment.get(convoy).getConvoyRoute()) continue;
                        atLeastOne = true;
                    }
                    if (!atLeastOne) {
                        return false;
                    }
                }
                return true;
            }
        };
    }

    public static Match<Territory> territoryHasEnemyLandNeighbor(final GameData data, final PlayerID player) {
        return new Match<Territory>(){

            @Override
            public boolean match(Territory t) {
                CompositeMatchAnd<Territory> condition = new CompositeMatchAnd<Territory>(TerritoryIsLand, Matches.isTerritoryEnemyAndNotUnownedWaterOrImpassibleOrRestricted(player, data));
                return data.getMap().getNeighbors(t, condition).size() > 0;
            }
        };
    }

    public static Match<Territory> TerritoryHasOwnedDestroyer(final PlayerID player) {
        return new Match<Territory>(){

            @Override
            public boolean match(Territory t) {
                CompositeMatchAnd<Unit> destroyerUnit = new CompositeMatchAnd<Unit>(UnitIsDestroyer, Matches.unitIsOwnedBy(player));
                return TerritoryIsWater.match(t) && t.getUnits().someMatch(destroyerUnit);
            }
        };
    }

    public static Match<Territory> territoryHasAlliedNeighborWithAlliedUnitMatching(final GameData data, final PlayerID player, final Match<Unit> unitMatch) {
        return new Match<Territory>(){

            @Override
            public boolean match(Territory t) {
                return data.getMap().getNeighbors(t, Matches.territoryIsAlliedAndHasAlliedUnitMatching(data, player, unitMatch)).size() > 0;
            }
        };
    }

    public static Match<Territory> territoryHasValidLandRouteTo(final GameData data, final Territory goTerr) {
        return new Match<Territory>(){

            @Override
            public boolean match(Territory t) {
                CompositeMatchAnd<Territory> validLandRoute = new CompositeMatchAnd<Territory>(TerritoryIsLand, TerritoryIsNotImpassable);
                return data.getMap().getRoute(t, goTerr, validLandRoute) != null;
            }
        };
    }

    public static Match<Territory> territoryIsInList(final Collection<Territory> list) {
        return new Match<Territory>(){

            @Override
            public boolean match(Territory ter) {
                return list.contains(ter);
            }
        };
    }

    public static Match<Territory> territoryIsNotInList(final Collection<Territory> list) {
        return new Match<Territory>(){

            @Override
            public boolean match(Territory ter) {
                return !list.contains(ter);
            }
        };
    }

    public static Match<Territory> territoryHasRouteToEnemyCapital(final GameData data, final PlayerID player) {
        return new Match<Territory>(){

            @Override
            public boolean match(Territory t) {
                for (PlayerID ePlayer : data.getPlayerList().getPlayers()) {
                    ArrayList<Territory> capitalsListOwned = new ArrayList<Territory>(TerritoryAttachment.getAllCurrentlyOwnedCapitals(ePlayer, data));
                    for (Territory current : capitalsListOwned) {
                        if (!data.getRelationshipTracker().isAtWar(player, current.getOwner()) || data.getMap().getDistance(t, current, Matches.TerritoryIsPassableAndNotRestricted(player, data)) == -1) continue;
                        return true;
                    }
                }
                return false;
            }
        };
    }

    public static Match<Territory> territoryHasLandRouteToEnemyCapital(final GameData data, final PlayerID player) {
        return new Match<Territory>(){

            @Override
            public boolean match(Territory t) {
                for (PlayerID ePlayer : data.getPlayerList().getPlayers()) {
                    ArrayList<Territory> capitalsListOwned = new ArrayList<Territory>(TerritoryAttachment.getAllCurrentlyOwnedCapitals(ePlayer, data));
                    for (Territory current : capitalsListOwned) {
                        if (!data.getRelationshipTracker().isAtWar(player, current.getOwner()) || data.getMap().getDistance(t, current, Matches.TerritoryIsNotImpassableToLandUnits(player, data)) == -1) continue;
                        return true;
                    }
                }
                return false;
            }
        };
    }

    public static Match<Territory> territoryHasEnemyNonNeutralNeighborWithEnemyUnitMatching(final GameData data, final PlayerID player, final Match<Unit> unitMatch) {
        return new Match<Territory>(){

            @Override
            public boolean match(Territory t) {
                return data.getMap().getNeighbors(t, Matches.territoryIsEnemyNonNeutralAndHasEnemyUnitMatching(data, player, unitMatch)).size() > 0;
            }
        };
    }

    public static Match<Territory> territoryHasOwnedNeighborWithOwnedUnitMatching(final GameData data, final PlayerID player, final Match<Unit> unitMatch) {
        return new Match<Territory>(){

            @Override
            public boolean match(Territory t) {
                return data.getMap().getNeighbors(t, Matches.territoryIsOwnedAndHasOwnedUnitMatching(data, player, unitMatch)).size() > 0;
            }
        };
    }

    public static Match<Territory> territoryHasOwnedAtBeginningOfTurnIsFactoryOrCanProduceUnitsNeighbor(final GameData data, final PlayerID player) {
        return new Match<Territory>(){

            @Override
            public boolean match(Territory t) {
                return data.getMap().getNeighbors(t, Matches.territoryHasOwnedAtBeginningOfTurnIsFactoryOrCanProduceUnits(data, player)).size() > 0;
            }
        };
    }

    public static Match<Territory> territoryHasWaterNeighbor(final GameData data) {
        return new Match<Territory>(){

            @Override
            public boolean match(Territory t) {
                return data.getMap().getNeighbors(t, TerritoryIsWater).size() > 0;
            }
        };
    }

    public static Match<Territory> territoryIsAlliedAndHasAlliedUnitMatching(final GameData data, final PlayerID player, final Match<Unit> unitMatch) {
        return new Match<Territory>(){

            @Override
            public boolean match(Territory t) {
                if (!data.getRelationshipTracker().isAllied(t.getOwner(), player)) {
                    return false;
                }
                return t.getUnits().someMatch(new CompositeMatchAnd<Unit>(Matches.alliedUnit(player, data), unitMatch));
            }
        };
    }

    public static Match<Territory> territoryIsOwnedAndHasOwnedUnitMatching(GameData data, final PlayerID player, final Match<Unit> unitMatch) {
        return new Match<Territory>(){

            @Override
            public boolean match(Territory t) {
                if (!t.getOwner().equals(player)) {
                    return false;
                }
                return t.getUnits().someMatch(new CompositeMatchAnd<Unit>(Matches.unitIsOwnedBy(player), unitMatch));
            }
        };
    }

    public static Match<Territory> territoryHasOwnedIsFactoryOrCanProduceUnits(GameData data, final PlayerID player) {
        return new Match<Territory>(){

            @Override
            public boolean match(Territory t) {
                if (!t.getOwner().equals(player)) {
                    return false;
                }
                return t.getUnits().someMatch(UnitCanProduceUnits);
            }
        };
    }

    public static Match<Territory> territoryHasOwnedAtBeginningOfTurnIsFactoryOrCanProduceUnits(final GameData data, final PlayerID player) {
        return new Match<Territory>(){

            @Override
            public boolean match(Territory t) {
                if (!t.getOwner().equals(player)) {
                    return false;
                }
                if (!t.getUnits().someMatch(UnitCanProduceUnits)) {
                    return false;
                }
                BattleTracker bt = MoveDelegate.getBattleTracker(data);
                return bt != null && !bt.wasConquered(t);
            }
        };
    }

    public static Match<Territory> territoryHasAlliedIsFactoryOrCanProduceUnits(final GameData data, final PlayerID player) {
        return new Match<Territory>(){

            @Override
            public boolean match(Territory t) {
                if (!Matches.isTerritoryAllied(player, data).match(t)) {
                    return false;
                }
                return t.getUnits().someMatch(UnitCanProduceUnits);
            }
        };
    }

    public static Match<Territory> territoryIsEnemyNonNeutralAndHasEnemyUnitMatching(final GameData data, final PlayerID player, final Match<Unit> unitMatch) {
        return new Match<Territory>(){

            @Override
            public boolean match(Territory t) {
                if (!data.getRelationshipTracker().isAtWar(player, t.getOwner())) {
                    return false;
                }
                if (t.getOwner().isNull()) {
                    return false;
                }
                return t.getUnits().someMatch(new CompositeMatchAnd<Unit>(Matches.enemyUnit(player, data), unitMatch));
            }
        };
    }

    public static Match<Territory> territoryIsEmptyOfCombatUnits(final GameData data, final PlayerID player) {
        return new Match<Territory>(){

            @Override
            public boolean match(Territory t) {
                CompositeMatchOr<Unit> nonCom = new CompositeMatchOr<Unit>(new Match[0]);
                nonCom.add(UnitIsInfrastructure);
                nonCom.add(Matches.enemyUnit(player, data).invert());
                return t.getUnits().allMatch(nonCom);
            }
        };
    }

    public static Match<Territory> TerritoryHasProductionValueAtLeast(final int prodVal) {
        return new Match<Territory>(){

            @Override
            public boolean match(Territory t) {
                if (t.isWater()) {
                    return false;
                }
                int terrProd = TerritoryAttachment.get(t).getProduction();
                return terrProd >= prodVal;
            }
        };
    }

    public static final Match<Territory> TerritoryIsPassableAndNotRestricted(final PlayerID player, final GameData data) {
        return new Match<Territory>(){

            @Override
            public boolean match(Territory t) {
                if (TerritoryIsImpassable.match(t)) {
                    return false;
                }
                if (!Properties.getMovementByTerritoryRestricted(data)) {
                    return true;
                }
                RulesAttachment ra = (RulesAttachment)player.getAttachment("rulesAttatchment");
                if (ra == null || ra.getMovementRestrictionTerritories() == null) {
                    return true;
                }
                String movementRestrictionType = ra.getMovementRestrictionType();
                Set<Territory> listedTerritories = ra.getListedTerritories(ra.getMovementRestrictionTerritories());
                return movementRestrictionType.equals("allowed") == listedTerritories.contains(t);
            }
        };
    }

    public static final Match<Territory> TerritoryIsImpassableToLandUnits(final PlayerID player, final GameData data) {
        return new Match<Territory>(){

            @Override
            public boolean match(Territory t) {
                if (t.isWater()) {
                    return true;
                }
                return Matches.TerritoryIsPassableAndNotRestricted(player, data).invert().match(t);
            }
        };
    }

    public static final Match<Territory> TerritoryIsNotImpassableToLandUnits(final PlayerID player, final GameData data) {
        return new Match<Territory>(){

            @Override
            public boolean match(Territory t) {
                return Matches.TerritoryIsImpassableToLandUnits(player, data).invert().match(t);
            }
        };
    }

    @Deprecated
    public static Match<Unit> unitHasEnoughMovement(final int lowerLimit, final IntegerMap<Unit> movement) {
        return new Match<Unit>(){

            @Override
            public boolean match(Unit o) {
                return movement.getInt(o) >= lowerLimit;
            }
        };
    }

    @Deprecated
    public static Match<Unit> UnitHasEnoughMovement(final int minMovement) {
        return new Match<Unit>(){

            @Override
            public boolean match(Unit unit) {
                return TripleAUnit.get(unit).getMovementLeft() >= minMovement;
            }
        };
    }

    public static Match<Unit> UnitHasEnoughMovementForRoute(final Route route) {
        return new Match<Unit>(){

            @Override
            public boolean match(Unit unit) {
                int left = TripleAUnit.get(unit).getMovementLeft();
                int movementcost = route.getMovementCost(unit);
                UnitAttachment ua = UnitAttachment.get(unit.getType());
                PlayerID player = unit.getOwner();
                if (ua.getIsAir()) {
                    TerritoryAttachment taStart = null;
                    TerritoryAttachment taEnd = null;
                    if (route.getStart() != null) {
                        taStart = TerritoryAttachment.get(route.getStart());
                    }
                    if (route.getEnd() != null) {
                        taEnd = TerritoryAttachment.get(route.getEnd());
                    }
                    movementcost = route.getMovementCost(unit);
                    if (taStart != null && taStart.getAirBase()) {
                        ++left;
                    }
                    if (taEnd != null && taEnd.getAirBase()) {
                        ++left;
                    }
                }
                GameStep stepName = unit.getData().getSequence().getStep();
                if (ua.getIsSea() && stepName.getDisplayName().equals("Non Combat Move")) {
                    movementcost = route.getMovementCost(unit);
                    block0: for (Territory terrNext : unit.getData().getMap().getNeighbors(route.getStart(), 1)) {
                        TerritoryAttachment taNeighbor = TerritoryAttachment.get(terrNext);
                        if (taNeighbor == null || !taNeighbor.getNavalBase() || !unit.getData().getRelationshipTracker().isAllied(terrNext.getOwner(), player)) continue;
                        for (Territory terrEnd : unit.getData().getMap().getNeighbors(route.getEnd(), 1)) {
                            TerritoryAttachment taEndNeighbor = TerritoryAttachment.get(terrEnd);
                            if (taEndNeighbor == null || !taEndNeighbor.getNavalBase() || !unit.getData().getRelationshipTracker().isAllied(terrEnd.getOwner(), player)) continue;
                            ++left;
                            continue block0;
                        }
                    }
                }
                return left >= 0 && left >= movementcost;
            }
        };
    }

    public static final Match<UnitType> UnitTypeCanMove(final PlayerID player) {
        return new Match<UnitType>(){

            @Override
            public boolean match(UnitType obj) {
                return UnitAttachment.get(obj).getMovement(player) > 0;
            }
        };
    }

    public static Match<UnitType> UnitTypeIsStatic(final PlayerID id) {
        return new Match<UnitType>(){

            @Override
            public boolean match(UnitType uT) {
                return !Matches.UnitTypeCanMove(id).match(uT);
            }
        };
    }

    public static Match<Unit> unitIsLandAndOwnedBy(final PlayerID player) {
        return new Match<Unit>(){

            @Override
            public boolean match(Unit unit) {
                UnitAttachment ua = UnitAttachment.get(unit.getType());
                return !ua.getIsSea() && !ua.getIsAir() && unit.getOwner().equals(player);
            }
        };
    }

    public static Match<Unit> unitIsOwnedBy(final PlayerID player) {
        return new Match<Unit>(){

            @Override
            public boolean match(Unit unit) {
                return unit.getOwner().equals(player);
            }
        };
    }

    public static Match<Unit> unitIsOwnedByOfAnyOfThesePlayers(final Collection<PlayerID> players) {
        return new Match<Unit>(){

            @Override
            public boolean match(Unit unit) {
                return players.contains(unit.getOwner());
            }
        };
    }

    public static Match<Unit> unitHasDefenseThatIsMoreThanOrEqualTo(final int minDefense) {
        return new Match<Unit>(){

            @Override
            public boolean match(Unit unit) {
                UnitAttachment ua = UnitAttachment.get(unit.getType());
                return ua.getDefense(unit.getOwner()) >= minDefense;
            }
        };
    }

    public static Match<Unit> unitIsTransporting() {
        return new Match<Unit>(){

            @Override
            public boolean match(Unit unit) {
                List<Unit> transporting = TripleAUnit.get(unit).getTransporting();
                return transporting != null && !transporting.isEmpty();
            }
        };
    }

    public static Match<Unit> unitHasEnoughTransportSpaceLeft(final int spaceNeeded) {
        return new Match<Unit>(){

            @Override
            public boolean match(Unit unit) {
                UnitAttachment ua = UnitAttachment.get(unit.getUnitType());
                int loadCost = 0;
                for (Unit cargo : TripleAUnit.get(unit).getTransporting()) {
                    loadCost += UnitAttachment.get(cargo.getUnitType()).getTransportCost();
                }
                return ua.getTransportCapacity() - loadCost >= spaceNeeded;
            }
        };
    }

    public static Match<Unit> unitIsTransportingSomeCategories(Collection<Unit> units) {
        final Set<UnitCategory> unitCategories = UnitSeperator.categorize(units);
        return new Match<Unit>(){

            @Override
            public boolean match(Unit unit) {
                List<Unit> transporting = TripleAUnit.get(unit).getTransporting();
                if (transporting == null) {
                    return false;
                }
                return Util.someIntersect(UnitSeperator.categorize(transporting), unitCategories);
            }
        };
    }

    public static Match<Territory> isTerritoryAllied(final PlayerID player, final GameData data) {
        return new Match<Territory>(){

            @Override
            public boolean match(Territory t) {
                return data.getRelationshipTracker().isAllied(player, t.getOwner());
            }
        };
    }

    public static Match<Territory> isTerritoryOwnedBy(final PlayerID player) {
        return new Match<Territory>(){

            @Override
            public boolean match(Territory t) {
                return t.getOwner().equals(player);
            }
        };
    }

    public static Match<Territory> isTerritoryOwnedBy(final Collection<PlayerID> players) {
        return new Match<Territory>(){

            @Override
            public boolean match(Territory t) {
                for (PlayerID player : players) {
                    if (!t.getOwner().equals(player)) continue;
                    return true;
                }
                return false;
            }
        };
    }

    public static Match<Unit> isUnitAllied(final PlayerID player, final GameData data) {
        return new Match<Unit>(){

            @Override
            public boolean match(Unit t) {
                return data.getRelationshipTracker().isAllied(player, t.getOwner());
            }
        };
    }

    public static Match<Territory> isTerritoryFriendly(final PlayerID player, final GameData data) {
        return new Match<Territory>(){

            @Override
            public boolean match(Territory t) {
                if (t.isWater()) {
                    return true;
                }
                if (t.getOwner().equals(player)) {
                    return true;
                }
                return data.getRelationshipTracker().isAllied(player, t.getOwner());
            }
        };
    }

    public static Match<Unit> unitIsEnemyAAforAnything(PlayerID player, GameData data) {
        CompositeMatchAnd<Unit> comp = new CompositeMatchAnd<Unit>(new Match[0]);
        comp.add(UnitIsAAforAnything);
        comp.add(Matches.enemyUnit(player, data));
        return comp;
    }

    public static Match<Unit> unitIsEnemyAAforCombat(PlayerID player, GameData data) {
        CompositeMatchAnd<Unit> comp = new CompositeMatchAnd<Unit>(new Match[0]);
        comp.add(UnitIsAAforCombatOnly);
        comp.add(Matches.enemyUnit(player, data));
        return comp;
    }

    public static Match<Unit> unitIsEnemyAAforBombing(PlayerID player, GameData data) {
        CompositeMatchAnd<Unit> comp = new CompositeMatchAnd<Unit>(new Match[0]);
        comp.add(UnitIsAAforBombingThisUnitOnly);
        comp.add(Matches.enemyUnit(player, data));
        return comp;
    }

    public static Match<Unit> unitIsInTerritory(final Territory territory) {
        return new Match<Unit>(){

            @Override
            public boolean match(Unit o) {
                return territory.getUnits().getUnits().contains(o);
            }
        };
    }

    public static Match<Territory> isTerritoryEnemy(final PlayerID player, final GameData data) {
        return new Match<Territory>(){

            @Override
            public boolean match(Territory t) {
                if (t.getOwner().equals(player)) {
                    return false;
                }
                return data.getRelationshipTracker().isAtWar(player, t.getOwner());
            }
        };
    }

    public static Match<Territory> isTerritoryEnemyAndNotUnownedWater(final PlayerID player, final GameData data) {
        return new Match<Territory>(){

            @Override
            public boolean match(Territory t) {
                if (t.getOwner().equals(player)) {
                    return false;
                }
                if (t.getOwner().equals(PlayerID.NULL_PLAYERID) && t.isWater()) {
                    return false;
                }
                return data.getRelationshipTracker().isAtWar(player, t.getOwner());
            }
        };
    }

    public static Match<Territory> isTerritoryEnemyAndNotUnownedWaterOrImpassibleOrRestricted(final PlayerID player, final GameData data) {
        return new Match<Territory>(){

            @Override
            public boolean match(Territory t) {
                if (t.getOwner().equals(player)) {
                    return false;
                }
                if (t.getOwner().equals(PlayerID.NULL_PLAYERID) && t.isWater()) {
                    return false;
                }
                if (!Matches.TerritoryIsPassableAndNotRestricted(player, data).match(t)) {
                    return false;
                }
                return data.getRelationshipTracker().isAtWar(player, t.getOwner());
            }
        };
    }

    public static Match<Territory> TerritoryIsBlitzable(final PlayerID player, final GameData data) {
        return new Match<Territory>(){

            @Override
            public boolean match(Territory t) {
                if (t.isWater()) {
                    return false;
                }
                if (t.getOwner().equals(PlayerID.NULL_PLAYERID) && t.isWater() | !Properties.getNeutralsBlitzable(data)) {
                    return false;
                }
                if (MoveDelegate.getBattleTracker(data).wasConquered(t) && !MoveDelegate.getBattleTracker(data).wasBlitzed(t)) {
                    return false;
                }
                CompositeMatchOr<Unit> blitzableUnits = new CompositeMatchOr<Unit>(new Match[0]);
                blitzableUnits.add(Matches.enemyUnit(player, data).invert());
                if (!Properties.getWW2V2(data) && !Properties.getBlitzThroughFactoriesAndAARestricted(data)) {
                    blitzableUnits.add(UnitIsInfrastructure);
                }
                return t.getUnits().allMatch(blitzableUnits);
            }
        };
    }

    public static Match<Territory> isTerritoryFreeNeutral(final GameData data) {
        return new Match<Territory>(){

            @Override
            public boolean match(Territory t) {
                return t.getOwner().equals(PlayerID.NULL_PLAYERID) && Properties.getNeutralCharge(data) <= 0;
            }
        };
    }

    public static Match<Unit> enemyUnit(final PlayerID player, final GameData data) {
        return new Match<Unit>(){

            @Override
            public boolean match(Unit unit) {
                return data.getRelationshipTracker().isAtWar(player, unit.getOwner());
            }
        };
    }

    public static Match<Unit> enemyUnitOfAnyOfThesePlayers(final Collection<PlayerID> players, final GameData data) {
        return new Match<Unit>(){

            @Override
            public boolean match(Unit unit) {
                return data.getRelationshipTracker().isAtWarWithAnyOfThesePlayers(unit.getOwner(), players);
            }
        };
    }

    public static Match<Unit> unitOwnedBy(final PlayerID player) {
        return new Match<Unit>(){

            @Override
            public boolean match(Unit o) {
                Unit unit = o;
                return unit.getOwner().equals(player);
            }
        };
    }

    public static Match<Unit> carrierOwnedBy(PlayerID player) {
        return new CompositeMatchAnd<Unit>(Matches.unitOwnedBy(player), UnitIsCarrier);
    }

    public static Match<Unit> unitOwnedBy(final List<PlayerID> players) {
        return new Match<Unit>(){

            @Override
            public boolean match(Unit o) {
                for (PlayerID p : players) {
                    if (!o.getOwner().equals(p)) continue;
                    return true;
                }
                return false;
            }
        };
    }

    public static Match<Unit> alliedUnit(final PlayerID player, final GameData data) {
        return new Match<Unit>(){

            @Override
            public boolean match(Unit unit) {
                if (unit.getOwner().equals(player)) {
                    return true;
                }
                return data.getRelationshipTracker().isAllied(player, unit.getOwner());
            }
        };
    }

    public static Match<Unit> alliedUnitOfAnyOfThesePlayers(final Collection<PlayerID> players, final GameData data) {
        return new Match<Unit>(){

            @Override
            public boolean match(Unit unit) {
                if (Matches.unitIsOwnedByOfAnyOfThesePlayers(players).match(unit)) {
                    return true;
                }
                return data.getRelationshipTracker().isAlliedWithAnyOfThesePlayers(unit.getOwner(), players);
            }
        };
    }

    public static Match<Territory> territoryIs(final Territory test) {
        return new Match<Territory>(){

            @Override
            public boolean match(Territory t) {
                return t.equals(test);
            }
        };
    }

    public static Match<Territory> territoryHasLandUnitsOwnedBy(PlayerID player) {
        final CompositeMatchAnd unitOwnedBy = new CompositeMatchAnd(Matches.unitIsOwnedBy(player), UnitIsLand);
        return new Match<Territory>(){

            @Override
            public boolean match(Territory t) {
                return t.getUnits().someMatch(unitOwnedBy);
            }
        };
    }

    public static Match<Territory> territoryHasUnitsOwnedBy(PlayerID player) {
        final Match<Unit> unitOwnedBy = Matches.unitIsOwnedBy(player);
        return new Match<Territory>(){

            @Override
            public boolean match(Territory t) {
                return t.getUnits().someMatch(unitOwnedBy);
            }
        };
    }

    public static Match<Territory> territoryHasUnitsThatMatch(final Match<Unit> cond) {
        return new Match<Territory>(){

            @Override
            public boolean match(Territory t) {
                return t.getUnits().someMatch(cond);
            }
        };
    }

    public static Match<Territory> territoryHasEnemyAAforAnything(final PlayerID player, final GameData data) {
        return new Match<Territory>(){

            @Override
            public boolean match(Territory t) {
                return t.getUnits().someMatch(Matches.unitIsEnemyAAforAnything(player, data));
            }
        };
    }

    public static Match<Territory> territoryHasEnemyAAforCombatOnly(final PlayerID player, final GameData data) {
        return new Match<Territory>(){

            @Override
            public boolean match(Territory t) {
                return t.getUnits().someMatch(Matches.unitIsEnemyAAforCombat(player, data));
            }
        };
    }

    public static Match<Territory> territoryHasEnemyAAforBombing(final PlayerID player, final GameData data) {
        return new Match<Territory>(){

            @Override
            public boolean match(Territory t) {
                return t.getUnits().someMatch(Matches.unitIsEnemyAAforBombing(player, data));
            }
        };
    }

    public static Match<Territory> territoryHasNoEnemyUnits(final PlayerID player, final GameData data) {
        return new Match<Territory>(){

            @Override
            public boolean match(Territory t) {
                return !t.getUnits().someMatch(Matches.enemyUnit(player, data));
            }
        };
    }

    public static Match<Territory> territoryHasNoAlliedUnits(final PlayerID player, final GameData data) {
        return new Match<Territory>(){

            @Override
            public boolean match(Territory t) {
                return !t.getUnits().someMatch(Matches.alliedUnit(player, data));
            }
        };
    }

    public static Match<Territory> territoryHasAlliedUnits(final PlayerID player, final GameData data) {
        return new Match<Territory>(){

            @Override
            public boolean match(Territory t) {
                return t.getUnits().someMatch(Matches.alliedUnit(player, data));
            }
        };
    }

    public static Match<Territory> territoryHasNonSubmergedEnemyUnits(PlayerID player, GameData data) {
        final CompositeMatchAnd<Unit> match = new CompositeMatchAnd<Unit>(new Match[0]);
        match.add(Matches.enemyUnit(player, data));
        match.add(new InverseMatch<Unit>(Matches.unitIsSubmerged(data)));
        return new Match<Territory>(){

            @Override
            public boolean match(Territory t) {
                return t.getUnits().someMatch(match);
            }
        };
    }

    public static Match<Territory> territoryHasEnemyLandUnits(final PlayerID player, final GameData data) {
        return new Match<Territory>(){

            @Override
            public boolean match(Territory t) {
                return t.getUnits().someMatch(Matches.enemyUnit(player, data)) && t.getUnits().someMatch(UnitIsLand);
            }
        };
    }

    public static Match<Territory> territoryHasEnemyBlitzUnits(final PlayerID player, final GameData data) {
        return new Match<Territory>(){

            @Override
            public boolean match(Territory t) {
                return t.getUnits().someMatch(Matches.enemyUnit(player, data)) && t.getUnits().someMatch(UnitCanBlitz);
            }
        };
    }

    public static Match<Territory> territoryHasEnemyUnits(final PlayerID player, final GameData data) {
        return new Match<Territory>(){

            @Override
            public boolean match(Territory t) {
                return t.getUnits().someMatch(Matches.enemyUnit(player, data));
            }
        };
    }

    public static Match<Territory> territoryHasOwnedTransportingUnits(final PlayerID player) {
        return new Match<Territory>(){

            @Override
            public boolean match(Territory t) {
                CompositeMatchAnd<Unit> match = new CompositeMatchAnd<Unit>(new Match[0]);
                match.add(Matches.unitIsOwnedBy(player));
                match.add(Matches.transportIsTransporting());
                return t.getUnits().someMatch(match);
            }
        };
    }

    public static Match<Unit> transportCannotUnload(final Territory territory) {
        final TransportTracker transportTracker = new TransportTracker();
        return new Match<Unit>(){

            @Override
            public boolean match(Unit transport) {
                if (transportTracker.hasTransportUnloadedInPreviousPhase(transport)) {
                    return true;
                }
                if (transportTracker.isTransportUnloadRestrictedToAnotherTerritory(transport, territory)) {
                    return true;
                }
                return transportTracker.isTransportUnloadRestrictedInNonCombat(transport);
            }
        };
    }

    public static Match<Unit> transportIsNotTransporting() {
        final TransportTracker transportTracker = new TransportTracker();
        return new Match<Unit>(){

            @Override
            public boolean match(Unit transport) {
                return !transportTracker.isTransporting(transport);
            }
        };
    }

    public static Match<Unit> transportIsTransporting() {
        final TransportTracker transportTracker = new TransportTracker();
        return new Match<Unit>(){

            @Override
            public boolean match(Unit transport) {
                return transportTracker.isTransporting(transport);
            }
        };
    }

    public static Match<Unit> unitIsBeingTransported() {
        return new Match<Unit>(){

            @Override
            public boolean match(Unit dependent) {
                return ((TripleAUnit)dependent).getTransportedBy() != null;
            }
        };
    }

    public static Match<Unit> unitIsBeingTransportedByOrIsDependentOfSomeUnitInThisList(final Collection<Unit> units, final Route route, final PlayerID currentPlayer, final GameData data, final boolean forceLoadParatroopersIfPossible) {
        return new Match<Unit>(){

            @Override
            public boolean match(Unit dependent) {
                Unit transportedBy = ((TripleAUnit)dependent).getTransportedBy();
                if (transportedBy != null && units.contains(transportedBy)) {
                    return true;
                }
                Map<Unit, Collection<Unit>> carrierMustMoveWith = MoveValidator.carrierMustMoveWith((Collection<Unit>)units, units, data, currentPlayer);
                if (carrierMustMoveWith != null) {
                    for (Unit unit : carrierMustMoveWith.keySet()) {
                        if (!carrierMustMoveWith.get(unit).contains(dependent)) continue;
                        return true;
                    }
                }
                if (forceLoadParatroopersIfPossible) {
                    List<Unit> airTransports = Match.getMatches(units, UnitIsAirTransport);
                    List<Unit> paratroops = Match.getMatches(units, UnitIsAirTransportable);
                    if (!airTransports.isEmpty() && !paratroops.isEmpty() && MoveDelegate.mapAirTransports(route, paratroops, airTransports, true, currentPlayer).containsKey(dependent)) {
                        return true;
                    }
                }
                return false;
            }
        };
    }

    public static Match<Unit> unitIsOfType(final UnitType type) {
        return new Match<Unit>(){

            @Override
            public boolean match(Unit unit) {
                return unit.getType().equals(type);
            }
        };
    }

    public static Match<Unit> unitIsOfTypes(final Set<UnitType> types) {
        return new Match<Unit>(){

            @Override
            public boolean match(Unit unit) {
                if (types == null || types.isEmpty()) {
                    return false;
                }
                return types.contains(unit.getType());
            }
        };
    }

    public static Match<Territory> territoryWasFoughOver(final BattleTracker tracker) {
        return new Match<Territory>(){

            @Override
            public boolean match(Territory t) {
                return tracker.wasBattleFought(t) || tracker.wasBlitzed(t);
            }
        };
    }

    public static Match<Unit> unitIsSubmerged(GameData data) {
        return new Match<Unit>(){

            @Override
            public boolean match(Unit u) {
                return TripleAUnit.get(u).getSubmerged();
            }
        };
    }

    public static Match<Unit> unitIsNotSubmerged(GameData data) {
        return new Match<Unit>(){

            @Override
            public boolean match(Unit u) {
                return !TripleAUnit.get(u).getSubmerged();
            }
        };
    }

    public static Match<Unit> unitOwnerHasImprovedArtillerySupportTech() {
        return new Match<Unit>(){

            @Override
            public boolean match(Unit u) {
                return TechTracker.hasImprovedArtillerySupport(u.getOwner());
            }
        };
    }

    public static Match<Unit> unitIsNotInTerritories(final Collection<Territory> list) {
        return new Match<Unit>(){

            @Override
            public boolean match(Unit u) {
                if (u == null) {
                    return false;
                }
                if (list.isEmpty()) {
                    return true;
                }
                for (Territory t : list) {
                    if (!t.getUnits().getUnits().contains(u)) continue;
                    return false;
                }
                return true;
            }
        };
    }

    public static Match<Territory> territoryHasNonAllowedCanal(final PlayerID player, final Collection<Unit> unitsMoving, final GameData data) {
        return new Match<Territory>(){

            @Override
            public boolean match(Territory t) {
                return MoveValidator.validateCanal(t, null, unitsMoving, player, data) != null;
            }
        };
    }

    public static Match<Territory> territoryIsBlockedSea(PlayerID player, GameData data) {
        CompositeMatchAnd<Unit> ignore = new CompositeMatchAnd<Unit>(UnitIsInfrastructure.invert(), Matches.alliedUnit(player, data).invert());
        CompositeMatchAnd sub = new CompositeMatchAnd(UnitIsSub.invert());
        CompositeMatchAnd transport = new CompositeMatchAnd(UnitIsTransportButNotCombatTransport.invert(), UnitIsLand.invert());
        CompositeMatchAnd<Unit> unitCond = ignore;
        if (Properties.getIgnoreTransportInMovement(data)) {
            unitCond.add(transport);
        }
        if (Properties.getIgnoreSubInMovement(data)) {
            unitCond.add(sub);
        }
        CompositeMatchAnd<Territory> routeCondition = new CompositeMatchAnd<Territory>(Matches.territoryHasUnitsThatMatch(unitCond).invert(), TerritoryIsWater);
        return routeCondition;
    }

    public static Match<Unit> UnitCanRepairThisUnit(final Unit damagedUnit) {
        return new Match<Unit>(){

            @Override
            public boolean match(Unit unitCanRepair) {
                UnitType type = unitCanRepair.getUnitType();
                UnitAttachment ua = UnitAttachment.get(type);
                return ua.getRepairsUnits() != null && ua.getListedUnits(ua.getRepairsUnits()).contains(damagedUnit.getType());
            }
        };
    }

    public static Match<Unit> UnitCanBeRepairedByFacilitiesInItsTerritory(final Territory territory, final PlayerID player, final GameData data) {
        return new Match<Unit>(){

            @Override
            public boolean match(Unit damagedUnit) {
                CompositeMatchAnd<Unit> damaged = new CompositeMatchAnd<Unit>(UnitIsTwoHit, UnitIsDamaged);
                if (!((Match)damaged).match(damagedUnit)) {
                    return false;
                }
                CompositeMatchAnd repairUnit = new CompositeMatchAnd(Matches.alliedUnit(player, data), UnitCanRepairOthers, Matches.UnitCanRepairThisUnit(damagedUnit));
                if (Match.someMatch(territory.getUnits().getUnits(), repairUnit)) {
                    return true;
                }
                if (UnitIsSea.match(damagedUnit)) {
                    CompositeMatchAnd repairUnitLand = new CompositeMatchAnd(repairUnit, UnitIsLand);
                    ArrayList<Territory> neighbors = new ArrayList<Territory>(data.getMap().getNeighbors(territory, TerritoryIsLand));
                    for (Territory current : neighbors) {
                        if (!Match.someMatch(current.getUnits().getUnits(), repairUnitLand)) continue;
                        return true;
                    }
                }
                return false;
            }
        };
    }

    public static Match<Unit> UnitCanGiveBonusMovementToThisUnit(final Unit unitWhichWillGetBonus) {
        return new Match<Unit>(){

            @Override
            public boolean match(Unit unitCanGiveBonusMovement) {
                if (Matches.UnitIsDisabled().match(unitCanGiveBonusMovement)) {
                    return false;
                }
                UnitType type = unitCanGiveBonusMovement.getUnitType();
                UnitAttachment ua = UnitAttachment.get(type);
                return UnitCanGiveBonusMovement.match(unitCanGiveBonusMovement) && ua.getGivesMovement().getInt(unitWhichWillGetBonus.getType()) != 0;
            }
        };
    }

    public static Match<Unit> UnitCanBeGivenBonusMovementByFacilitiesInItsTerritory(final Territory territory, final PlayerID player, final GameData data) {
        return new Match<Unit>(){

            @Override
            public boolean match(Unit unitWhichWillGetBonus) {
                CompositeMatchAnd givesBonusUnit = new CompositeMatchAnd(Matches.alliedUnit(player, data), Matches.UnitCanGiveBonusMovementToThisUnit(unitWhichWillGetBonus));
                if (Match.someMatch(territory.getUnits().getUnits(), givesBonusUnit)) {
                    return true;
                }
                if (UnitIsSea.match(unitWhichWillGetBonus)) {
                    CompositeMatchAnd givesBonusUnitLand = new CompositeMatchAnd(givesBonusUnit, UnitIsLand);
                    ArrayList<Territory> neighbors = new ArrayList<Territory>(data.getMap().getNeighbors(territory, TerritoryIsLand));
                    for (Territory current : neighbors) {
                        if (!Match.someMatch(current.getUnits().getUnits(), givesBonusUnitLand)) continue;
                        return true;
                    }
                }
                return false;
            }
        };
    }

    public static Match<Unit> UnitWhichConsumesUnitsHasRequiredUnits(final Collection<Unit> unitsInTerritoryAtStartOfTurn, final Territory territory) {
        return new Match<Unit>(){

            @Override
            public boolean match(Unit unitWhichRequiresUnits) {
                if (!UnitConsumesUnitsOnCreation.match(unitWhichRequiresUnits)) {
                    return true;
                }
                UnitAttachment ua = UnitAttachment.get(unitWhichRequiresUnits.getType());
                IntegerMap<UnitType> requiredUnitsMap = ua.getConsumesUnits();
                Set<UnitType> requiredUnits = requiredUnitsMap.keySet();
                boolean canBuild = true;
                for (UnitType ut : requiredUnits) {
                    CompositeMatchAnd unitIsOwnedByAndOfTypeAndNotDamaged = new CompositeMatchAnd(Matches.unitIsOwnedBy(unitWhichRequiresUnits.getOwner()), Matches.unitIsOfType(ut), Matches.UnitHasSomeUnitDamage().invert(), UnitIsNotDamaged, Matches.UnitIsDisabled().invert(), Matches.unitIsInTerritoryThatHasTerritoryDamage(territory).invert());
                    int requiredNumber = requiredUnitsMap.getInt(ut);
                    int numberInTerritory = Match.countMatches(unitsInTerritoryAtStartOfTurn, unitIsOwnedByAndOfTypeAndNotDamaged);
                    if (numberInTerritory < requiredNumber) {
                        canBuild = false;
                    }
                    if (canBuild) continue;
                    break;
                }
                return canBuild;
            }
        };
    }

    public static Match<Unit> UnitWhichRequiresUnitsHasRequiredUnitsInList(final Collection<Unit> unitsInTerritoryAtStartOfTurn) {
        return new Match<Unit>(){

            @Override
            public boolean match(Unit unitWhichRequiresUnits) {
                if (!UnitRequiresUnitsOnCreation.match(unitWhichRequiresUnits)) {
                    return true;
                }
                CompositeMatchAnd unitIsOwnedByAndNotDisabled = new CompositeMatchAnd(Matches.unitIsOwnedBy(unitWhichRequiresUnits.getOwner()), Matches.UnitIsDisabled().invert());
                unitsInTerritoryAtStartOfTurn.retainAll(Match.getMatches(unitsInTerritoryAtStartOfTurn, unitIsOwnedByAndNotDisabled));
                boolean canBuild = false;
                UnitAttachment ua = UnitAttachment.get(unitWhichRequiresUnits.getType());
                ArrayList<String[]> unitComboPossibilities = ua.getRequiresUnits();
                for (String[] combo : unitComboPossibilities) {
                    if (combo != null) {
                        boolean haveAll = true;
                        Collection<UnitType> requiredUnits = ua.getListedUnits(combo);
                        for (UnitType ut : requiredUnits) {
                            if (Match.countMatches(unitsInTerritoryAtStartOfTurn, Matches.unitIsOfType(ut)) < 1) {
                                haveAll = false;
                            }
                            if (haveAll) continue;
                            break;
                        }
                        if (haveAll) {
                            canBuild = true;
                        }
                    }
                    if (!canBuild) continue;
                    break;
                }
                return canBuild;
            }
        };
    }

    public static final Match<Territory> TerritoryAllowsCanMoveLandUnitsOverOwnedLand(final PlayerID ownerOfUnitsMoving, final GameData data) {
        return new Match<Territory>(){

            @Override
            public boolean match(Territory t) {
                if (!TerritoryIsLand.match(t)) {
                    return true;
                }
                PlayerID tOwner = t.getOwner();
                if (tOwner == null) {
                    return true;
                }
                return data.getRelationshipTracker().canMoveLandUnitsOverOwnedLand(tOwner, ownerOfUnitsMoving);
            }
        };
    }

    public static final Match<Territory> TerritoryAllowsCanMoveAirUnitsOverOwnedLand(final PlayerID ownerOfUnitsMoving, final GameData data) {
        return new Match<Territory>(){

            @Override
            public boolean match(Territory t) {
                if (!TerritoryIsLand.match(t)) {
                    return true;
                }
                PlayerID tOwner = t.getOwner();
                if (tOwner == null) {
                    return true;
                }
                return data.getRelationshipTracker().canMoveAirUnitsOverOwnedLand(tOwner, ownerOfUnitsMoving);
            }
        };
    }

    public static final Match<String> isValidRelationshipName(final GameData data) {
        return new Match<String>(){

            @Override
            public boolean match(String relationshipName) {
                return data.getRelationshipTypeList().getRelationshipType(relationshipName) != null;
            }
        };
    }

    public static final Match<PlayerID> isAtWar(final PlayerID player, final GameData data) {
        return new Match<PlayerID>(){

            @Override
            public boolean match(PlayerID player2) {
                return RelationshipTypeIsAtWar.match(data.getRelationshipTracker().getRelationshipType(player, player2));
            }
        };
    }

    public static final Match<PlayerID> isAtWarWithAnyOfThesePlayers(final Collection<PlayerID> players, final GameData data) {
        return new Match<PlayerID>(){

            @Override
            public boolean match(PlayerID player2) {
                return data.getRelationshipTracker().isAtWarWithAnyOfThesePlayers(player2, players);
            }
        };
    }

    public static final Match<PlayerID> isAllied(final PlayerID player, final GameData data) {
        return new Match<PlayerID>(){

            @Override
            public boolean match(PlayerID player2) {
                return RelationshipTypeIsAllied.match(data.getRelationshipTracker().getRelationshipType(player, player2));
            }
        };
    }

    public static final Match<PlayerID> isAlliedWithAnyOfThesePlayers(final Collection<PlayerID> players, final GameData data) {
        return new Match<PlayerID>(){

            @Override
            public boolean match(PlayerID player2) {
                return data.getRelationshipTracker().isAlliedWithAnyOfThesePlayers(player2, players);
            }
        };
    }

    public static final Match<PlayerID> isNeutral(final PlayerID player, final GameData data) {
        return new Match<PlayerID>(){

            @Override
            public boolean match(PlayerID player2) {
                return RelationshipTypeIsNeutral.match(data.getRelationshipTracker().getRelationshipType(player, player2));
            }
        };
    }

    public static final Match<PlayerID> isNeutralWithAnyOfThesePlayers(final Collection<PlayerID> players, final GameData data) {
        return new Match<PlayerID>(){

            @Override
            public boolean match(PlayerID player2) {
                return data.getRelationshipTracker().isNeutralWithAnyOfThesePlayers(player2, players);
            }
        };
    }

    public static final Match<Unit> UnitIsOwnedAndIsFactoryOrCanProduceUnits(final PlayerID player) {
        return new Match<Unit>(){

            @Override
            public boolean match(Unit u) {
                return UnitCanProduceUnits.match(u) && Matches.unitIsOwnedBy(player).match(u);
            }
        };
    }

    public static final Match<Unit> UnitCanReceivesAbilityWhenWith() {
        return new Match<Unit>(){

            @Override
            public boolean match(Unit u) {
                return !UnitAttachment.get(u.getType()).getReceivesAbilityWhenWith().isEmpty();
            }
        };
    }

    public static final Match<Unit> UnitCanReceivesAbilityWhenWith(final String filterForAbility, final String filterForUnitType) {
        return new Match<Unit>(){

            @Override
            public boolean match(Unit u) {
                for (String receives : UnitAttachment.get(u.getType()).getReceivesAbilityWhenWith()) {
                    String[] s = receives.split(":");
                    if (!s[0].equals(filterForAbility) || !s[1].equals(filterForUnitType)) continue;
                    return true;
                }
                return false;
            }
        };
    }

    public static final Match<Unit> UnitHasWhenCombatDamagedEffect() {
        return new Match<Unit>(){

            @Override
            public boolean match(Unit u) {
                return !UnitAttachment.get(u.getType()).getWhenCombatDamaged().isEmpty();
            }
        };
    }

    public static final Match<Unit> UnitHasWhenCombatDamagedEffect(final String filterForEffect) {
        return new Match<Unit>(){

            @Override
            public boolean match(Unit u) {
                if (!Matches.UnitHasWhenCombatDamagedEffect().match(u)) {
                    return false;
                }
                TripleAUnit taUnit = (TripleAUnit)u;
                int currentDamage = taUnit.getHits();
                ArrayList<Tuple<Tuple<Integer, Integer>, Tuple<String, String>>> whenCombatDamagedList = UnitAttachment.get(u.getType()).getWhenCombatDamaged();
                for (Tuple<Tuple<Integer, Integer>, Tuple<String, String>> key : whenCombatDamagedList) {
                    String effect = key.getSecond().getFirst();
                    if (!effect.equals(filterForEffect)) continue;
                    int damagedFrom = key.getFirst().getFirst();
                    int damagedTo = key.getFirst().getSecond();
                    if (currentDamage < damagedFrom || currentDamage > damagedTo) continue;
                    return true;
                }
                return false;
            }
        };
    }

    public static final Match<Territory> TerritoryHasWhenCapturedByGoesTo() {
        return new Match<Territory>(){

            @Override
            public boolean match(Territory t) {
                TerritoryAttachment ta = TerritoryAttachment.get(t);
                if (ta == null) {
                    return false;
                }
                return !ta.getWhenCapturedByGoesTo().isEmpty();
            }
        };
    }

    public static final Match<Unit> UnitWhenCapturedChangesIntoDifferentUnitType() {
        return new Match<Unit>(){

            @Override
            public boolean match(Unit u) {
                return !UnitAttachment.get(u.getType()).getWhenCapturedChangesInto().isEmpty();
            }
        };
    }

    public static final Match<PoliticalActionAttachment> PoliticalActionCanBeAttempted(final HashMap<ICondition, Boolean> testedConditions) {
        return new Match<PoliticalActionAttachment>(){

            @Override
            public boolean match(PoliticalActionAttachment paa) {
                return paa.hasAttemptsLeft() && paa.canPerform(testedConditions);
            }
        };
    }

    public static final Match<PoliticalActionAttachment> PoliticalActionHasCostBetween(final int greaterThanEqualTo, final int lessThanEqualTo) {
        return new Match<PoliticalActionAttachment>(){

            @Override
            public boolean match(PoliticalActionAttachment paa) {
                return paa.getCostPU() >= greaterThanEqualTo && paa.getCostPU() <= lessThanEqualTo;
            }
        };
    }

    public static final Match<Territory> TerritoryIsOriginallyOwnedBy(final PlayerID player) {
        return new Match<Territory>(){

            @Override
            public boolean match(Territory t) {
                TerritoryAttachment ta = TerritoryAttachment.get(t);
                if (ta == null) {
                    return false;
                }
                PlayerID originalOwner = ta.getOriginalOwner();
                if (originalOwner == null && player != null || originalOwner != null && player == null) {
                    return false;
                }
                PlayerID occupiedTerrOf = ta.getOccupiedTerrOf();
                if (occupiedTerrOf == null) {
                    if (originalOwner == null) {
                        return player == null;
                    }
                    return originalOwner.equals(player);
                }
                return occupiedTerrOf.equals(player);
            }
        };
    }

    public static final Match<PlayerID> isAlliedAndAlliancesCanChainTogether(final PlayerID player, final GameData data) {
        return new Match<PlayerID>(){

            @Override
            public boolean match(PlayerID player2) {
                return RelationshipTypeIsAlliedAndAlliancesCanChainTogether.match(data.getRelationshipTracker().getRelationshipType(player, player2));
            }
        };
    }

    public static final Match<PoliticalActionAttachment> politicalActionIsRelationshipChangeOf(final PlayerID player, final Match<RelationshipType> currentRelation, final Match<RelationshipType> newRelation, final GameData data) {
        return new Match<PoliticalActionAttachment>(){

            @Override
            public boolean match(PoliticalActionAttachment paa) {
                for (String relationshipChangeString : paa.getRelationshipChange()) {
                    String[] relationshipChange = relationshipChangeString.split(":");
                    PlayerID p1 = data.getPlayerList().getPlayerID(relationshipChange[0]);
                    PlayerID p2 = data.getPlayerList().getPlayerID(relationshipChange[1]);
                    if (player != null && !p1.equals(player) && !p2.equals(player)) continue;
                    RelationshipType currentType = data.getRelationshipTracker().getRelationshipType(p1, p2);
                    RelationshipType newType = data.getRelationshipTypeList().getRelationshipType(relationshipChange[2]);
                    if (!currentRelation.match(currentType) || !newRelation.match(newType)) continue;
                    return true;
                }
                return false;
            }
        };
    }

    public static Match<PoliticalActionAttachment> politicalActionAffectsAtLeastOneAlivePlayer(final PlayerID currentPlayer, final GameData data) {
        return new Match<PoliticalActionAttachment>(){

            @Override
            public boolean match(PoliticalActionAttachment paa) {
                for (String relationshipChangeString : paa.getRelationshipChange()) {
                    String[] relationshipChange = relationshipChangeString.split(":");
                    PlayerID p1 = data.getPlayerList().getPlayerID(relationshipChange[0]);
                    PlayerID p2 = data.getPlayerList().getPlayerID(relationshipChange[1]);
                    if (!currentPlayer.equals(p1) && p1.amNotDeadYet(data)) {
                        return true;
                    }
                    if (currentPlayer.equals(p2) || !p2.amNotDeadYet(data)) continue;
                    return true;
                }
                return false;
            }
        };
    }

    public static Match<Territory> seaCanMoveOver(final PlayerID player, final GameData data) {
        return new Match<Territory>(){

            @Override
            public boolean match(Territory t) {
                if (!TerritoryIsWater.match(t)) {
                    return false;
                }
                return Matches.TerritoryIsPassableAndNotRestricted(player, data).match(t);
            }
        };
    }

    public static Match<Territory> airCanFlyOver(final PlayerID player, final GameData data, final boolean areNeutralsPassableByAir) {
        return new Match<Territory>(){

            @Override
            public boolean match(Territory t) {
                if (!areNeutralsPassableByAir && TerritoryIsNeutralButNotWater.match(t)) {
                    return false;
                }
                if (!Matches.TerritoryIsPassableAndNotRestricted(player, data).match(t)) {
                    return false;
                }
                return !TerritoryIsLand.match(t) || data.getRelationshipTracker().canMoveAirUnitsOverOwnedLand(player, t.getOwner());
            }
        };
    }

    public static Match<Territory> airCanLandOnThisAlliedNonConqueredLandTerritory(final PlayerID player, final GameData data) {
        return new Match<Territory>(){

            @Override
            public boolean match(Territory t) {
                if (!TerritoryIsLand.match(t)) {
                    return false;
                }
                BattleTracker bt = MoveDelegate.getBattleTracker(data);
                if (bt.wasConquered(t)) {
                    return false;
                }
                PlayerID owner = t.getOwner();
                if (owner == null || owner.isNull()) {
                    return false;
                }
                RelationshipTracker rt = data.getRelationshipTracker();
                return rt.canMoveAirUnitsOverOwnedLand(player, owner) && rt.canLandAirUnitsOnOwnedLand(player, owner);
            }
        };
    }

    public static Match<Territory> territoryAllowsRocketsCanFlyOver(final PlayerID player, final GameData data) {
        return new Match<Territory>(){

            @Override
            public boolean match(Territory t) {
                if (!TerritoryIsLand.match(t)) {
                    return true;
                }
                PlayerID owner = t.getOwner();
                if (owner == null || owner.isNull()) {
                    return true;
                }
                RelationshipTracker rt = data.getRelationshipTracker();
                return rt.rocketsCanFlyOver(player, owner);
            }
        };
    }

    public static Match<Unit> unitCanScrambleOnRouteDistance(final Route route) {
        return new Match<Unit>(){

            @Override
            public boolean match(Unit u) {
                return UnitAttachment.get(u.getType()).getMaxScrambleDistance() >= route.getMovementCost(u);
            }
        };
    }

    public static final Match<Territory> territoryIsOwnedByPlayerWhosRelationshipTypeCanTakeOverOwnedTerritoryAndPassableAndNotWater(final PlayerID attacker) {
        return new Match<Territory>(){

            @Override
            public boolean match(Territory t) {
                if (t.getOwner().equals(attacker)) {
                    return false;
                }
                if (t.getOwner().equals(PlayerID.NULL_PLAYERID) && t.isWater()) {
                    return false;
                }
                if (!Matches.TerritoryIsPassableAndNotRestricted(attacker, t.getData()).match(t)) {
                    return false;
                }
                return RelationshipTypeCanTakeOverOwnedTerritory.match(t.getData().getRelationshipTracker().getRelationshipType(attacker, t.getOwner()));
            }
        };
    }

    public static final Match<Territory> territoryOwnerRelationshipTypeCanMoveIntoDuringCombatMove(final PlayerID movingPlayer) {
        return new Match<Territory>(){

            @Override
            public boolean match(Territory t) {
                if (t.getOwner().equals(movingPlayer)) {
                    return true;
                }
                if (t.getOwner().equals(PlayerID.NULL_PLAYERID) && t.isWater()) {
                    return true;
                }
                return t.getData().getRelationshipTracker().canMoveIntoDuringCombatMove(movingPlayer, t.getOwner());
            }
        };
    }

    public static final Match<Unit> UnitCanBeInBattle(final boolean attack, final GameData data, final boolean includeAttackersThatCanNotMove, final boolean doNotIncludeAA) {
        return new Match<Unit>(){

            @Override
            public boolean match(Unit u) {
                PlayerID owner = u.getOwner();
                return Matches.UnitTypeCanBeInBattle(attack, owner, data, includeAttackersThatCanNotMove, doNotIncludeAA).match(u.getType());
            }
        };
    }

    public static final Match<UnitType> UnitTypeCanBeInBattle(final boolean attack, final PlayerID player, final GameData data, final boolean includeAttackersThatCanNotMove, final boolean doNotIncludeAA) {
        return new Match<UnitType>(){

            @Override
            public boolean match(UnitType ut) {
                CompositeMatch combat;
                CompositeMatchOr supporterOrNotInfrastructure = new CompositeMatchOr(UnitTypeIsInfrastructure.invert(), Matches.UnitTypeIsSupporterOrHasCombatAbility(attack, player, data));
                if (attack) {
                    CompositeMatchAnd attackMatch = new CompositeMatchAnd(new Match[0]);
                    attackMatch.add(supporterOrNotInfrastructure);
                    if (!includeAttackersThatCanNotMove) {
                        attackMatch.add(UnitTypeCanNotMoveDuringCombatMove.invert());
                        attackMatch.add(Matches.UnitTypeCanMove(player));
                    }
                    combat = attackMatch;
                } else {
                    CompositeMatchOr<UnitType> defenseMatch = new CompositeMatchOr<UnitType>(new Match[0]);
                    if (!doNotIncludeAA) {
                        defenseMatch.add(UnitTypeIsAAforCombatOnly);
                    }
                    defenseMatch.add(supporterOrNotInfrastructure);
                    combat = defenseMatch;
                }
                return combat.match(ut);
            }
        };
    }

    private Matches() {
    }
}

