/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.triplea.delegate;

import games.strategy.engine.data.Change;
import games.strategy.engine.data.ChangeFactory;
import games.strategy.engine.data.CompositeChange;
import games.strategy.engine.data.GameData;
import games.strategy.engine.data.PlayerID;
import games.strategy.engine.data.Route;
import games.strategy.engine.data.Territory;
import games.strategy.engine.data.Unit;
import games.strategy.engine.delegate.IDelegateBridge;
import games.strategy.triplea.Properties;
import games.strategy.triplea.TripleAUnit;
import games.strategy.triplea.attatchments.ICondition;
import games.strategy.triplea.attatchments.TriggerAttachment;
import games.strategy.triplea.attatchments.UnitAttachment;
import games.strategy.triplea.delegate.AAInMoveUtil;
import games.strategy.triplea.delegate.AbstractMoveDelegate;
import games.strategy.triplea.delegate.AirThatCantLandUtil;
import games.strategy.triplea.delegate.Matches;
import games.strategy.triplea.delegate.MoveExtendedDelegateState;
import games.strategy.triplea.delegate.MovePerformer;
import games.strategy.triplea.delegate.MoveValidator;
import games.strategy.triplea.delegate.MustFightBattle;
import games.strategy.triplea.delegate.RocketsFireHelper;
import games.strategy.triplea.delegate.TechTracker;
import games.strategy.triplea.delegate.TransportTracker;
import games.strategy.triplea.delegate.TripleADelegateBridge;
import games.strategy.triplea.delegate.UndoableMove;
import games.strategy.triplea.delegate.dataObjects.MoveValidationResult;
import games.strategy.triplea.delegate.remote.IMoveDelegate;
import games.strategy.triplea.formatter.MyFormatter;
import games.strategy.triplea.util.UnitCategory;
import games.strategy.triplea.util.UnitSeperator;
import games.strategy.util.CompositeMatchAnd;
import games.strategy.util.CompositeMatchOr;
import games.strategy.util.IntegerMap;
import games.strategy.util.Match;
import games.strategy.util.Util;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MoveDelegate
extends AbstractMoveDelegate
implements IMoveDelegate {
    public static String CLEANING_UP_AFTER_MOVEMENT_PHASES = "Cleaning up after movement phases";
    private boolean m_firstRun = true;
    private boolean m_needToInitialize = true;
    private boolean m_needToDoRockets = true;
    private IntegerMap<Territory> m_PUsLost = new IntegerMap();

    @Override
    public void start(IDelegateBridge aBridge) {
        super.start(new TripleADelegateBridge(aBridge));
        GameData data = this.getData();
        if (this.m_firstRun) {
            this.firstRun();
        }
        if (this.m_needToInitialize) {
            HashSet<TriggerAttachment> toFireAfterBonus;
            HashSet<TriggerAttachment> toFirePossible;
            HashMap<ICondition, Boolean> testedConditions = null;
            CompositeMatchAnd<TriggerAttachment> moveCombatDelegateBeforeBonusTriggerMatch = new CompositeMatchAnd<TriggerAttachment>(TriggerAttachment.availableUses, TriggerAttachment.whenOrDefaultMatch(null, null), new CompositeMatchOr(TriggerAttachment.notificationMatch(), TriggerAttachment.playerPropertyMatch(), TriggerAttachment.relationshipTypePropertyMatch(), TriggerAttachment.territoryPropertyMatch(), TriggerAttachment.territoryEffectPropertyMatch(), TriggerAttachment.removeUnitsMatch(), TriggerAttachment.changeOwnershipMatch()));
            CompositeMatchAnd<TriggerAttachment> moveCombatDelegateAfterBonusTriggerMatch = new CompositeMatchAnd<TriggerAttachment>(TriggerAttachment.availableUses, TriggerAttachment.whenOrDefaultMatch(null, null), new CompositeMatchOr(TriggerAttachment.placeMatch()));
            CompositeMatchOr<TriggerAttachment> moveCombatDelegateAllTriggerMatch = new CompositeMatchOr<TriggerAttachment>(moveCombatDelegateBeforeBonusTriggerMatch, moveCombatDelegateAfterBonusTriggerMatch);
            if (!this.m_nonCombat && Properties.getTriggers(data) && !(toFirePossible = TriggerAttachment.collectForAllTriggersMatching(new HashSet<PlayerID>(Collections.singleton(this.m_player)), moveCombatDelegateAllTriggerMatch, aBridge)).isEmpty()) {
                testedConditions = TriggerAttachment.collectTestsForAllTriggers(toFirePossible, aBridge);
                HashSet<TriggerAttachment> toFireBeforeBonus = TriggerAttachment.collectForAllTriggersMatching(new HashSet<PlayerID>(Collections.singleton(this.m_player)), moveCombatDelegateBeforeBonusTriggerMatch, aBridge);
                if (!toFireBeforeBonus.isEmpty()) {
                    HashSet<TriggerAttachment> toFireTestedAndSatisfied = new HashSet<TriggerAttachment>(Match.getMatches(toFireBeforeBonus, TriggerAttachment.isSatisfiedMatch(testedConditions)));
                    TriggerAttachment.triggerNotifications(toFireTestedAndSatisfied, aBridge, null, null, true, true, true, true);
                    TriggerAttachment.triggerPlayerPropertyChange(toFireTestedAndSatisfied, aBridge, null, null, true, true, true, true);
                    TriggerAttachment.triggerRelationshipTypePropertyChange(toFireTestedAndSatisfied, aBridge, null, null, true, true, true, true);
                    TriggerAttachment.triggerTerritoryPropertyChange(toFireTestedAndSatisfied, aBridge, null, null, true, true, true, true);
                    TriggerAttachment.triggerTerritoryEffectPropertyChange(toFireTestedAndSatisfied, aBridge, null, null, true, true, true, true);
                    TriggerAttachment.triggerChangeOwnership(toFireTestedAndSatisfied, aBridge, null, null, true, true, true, true);
                    TriggerAttachment.triggerUnitRemoval(toFireTestedAndSatisfied, aBridge, null, null, true, true, true, true);
                }
            }
            if (!this.m_nonCombat && Properties.getBattleshipsRepairAtBeginningOfRound(data)) {
                MoveDelegate.repairBattleShips(aBridge, this.m_player, true);
            }
            if (!this.m_nonCombat) {
                this.resetBonusMovement();
            }
            if (!this.m_nonCombat && Properties.getUnitsMayGiveBonusMovement(data)) {
                this.giveBonusMovement(aBridge, this.m_player);
            }
            if (!this.m_nonCombat) {
                this.removeMovementFromAirOnDamagedAlliedCarriers(aBridge, this.m_player);
            }
            if (!this.m_nonCombat && Properties.getTriggers(data) && !(toFireAfterBonus = TriggerAttachment.collectForAllTriggersMatching(new HashSet<PlayerID>(Collections.singleton(this.m_player)), moveCombatDelegateAfterBonusTriggerMatch, aBridge)).isEmpty()) {
                HashSet<TriggerAttachment> toFireTestedAndSatisfied = new HashSet<TriggerAttachment>(Match.getMatches(toFireAfterBonus, TriggerAttachment.isSatisfiedMatch(testedConditions)));
                TriggerAttachment.triggerUnitPlacement(toFireTestedAndSatisfied, aBridge, null, null, true, true, true, true);
            }
            this.m_needToInitialize = false;
        }
    }

    @Override
    public void end() {
        super.end();
        if (this.m_nonCombat) {
            this.removeAirThatCantLand();
        }
        if ((!this.m_nonCombat && this.isWW2V3() || this.m_nonCombat && !this.isWW2V2() && !this.isWW2V3() || !this.m_nonCombat && this.isWW2V2()) && this.m_needToDoRockets && TechTracker.hasRocket(this.m_bridge.getPlayerID())) {
            RocketsFireHelper helper = new RocketsFireHelper();
            helper.fireRockets(this.m_bridge, this.m_bridge.getPlayerID());
            this.m_needToDoRockets = false;
        }
        CompositeChange change = new CompositeChange();
        if (this.m_nonCombat) {
            GameData data = this.getData();
            for (Unit u : data.getUnits()) {
                if (TripleAUnit.get(u).getAlreadyMoved() != 0) {
                    change.add(ChangeFactory.unitPropertyChange(u, 0, "alreadyMoved"));
                }
                if (TripleAUnit.get(u).getBonusMovement() != 0) {
                    change.add(ChangeFactory.unitPropertyChange(u, 0, "bonusMovement"));
                }
                if (TripleAUnit.get(u).getSubmerged()) {
                    change.add(ChangeFactory.unitPropertyChange(u, false, "submerged"));
                }
                if (TripleAUnit.get(u).getAirborne()) {
                    change.add(ChangeFactory.unitPropertyChange(u, false, "airborne"));
                }
                if (TripleAUnit.get(u).getLaunched() == 0) continue;
                change.add(ChangeFactory.unitPropertyChange(u, 0, "launched"));
            }
            change.add(this.m_transportTracker.endOfRoundClearStateChange(data));
            this.m_PUsLost.clear();
        }
        if (!change.isEmpty()) {
            this.m_bridge.getHistoryWriter().startEvent(CLEANING_UP_AFTER_MOVEMENT_PHASES);
            this.m_bridge.addChange(change);
        }
        this.m_needToInitialize = true;
        this.m_needToDoRockets = true;
    }

    @Override
    public Serializable saveState() {
        return this.saveState(true);
    }

    private Serializable saveState(boolean saveUndo) {
        MoveExtendedDelegateState state = new MoveExtendedDelegateState();
        state.superState = super.saveState();
        state.m_firstRun = this.m_firstRun;
        state.m_needToInitialize = this.m_needToInitialize;
        state.m_needToDoRockets = this.m_needToDoRockets;
        state.m_PUsLost = this.m_PUsLost;
        return state;
    }

    @Override
    public void loadState(Serializable state) {
        MoveExtendedDelegateState s = (MoveExtendedDelegateState)state;
        super.loadState(s.superState);
        this.m_firstRun = s.m_firstRun;
        this.m_needToInitialize = s.m_needToInitialize;
        this.m_needToDoRockets = s.m_needToDoRockets;
        this.m_PUsLost = s.m_PUsLost;
    }

    private void firstRun() {
        this.m_firstRun = false;
        for (Territory current : this.getData().getMap().getTerritories()) {
            Collection<Unit> units;
            if (!current.isWater() || (units = current.getUnits().getUnits()).size() == 0 || !Match.someMatch(units, Matches.UnitIsLand)) continue;
            List<Unit> transports = Match.getMatches(units, Matches.UnitIsTransport);
            List<Unit> land = Match.getMatches(units, Matches.UnitIsLand);
            for (Unit toLoad : land) {
                UnitAttachment ua = UnitAttachment.get(toLoad.getType());
                int cost = ua.getTransportCost();
                if (cost == -1) {
                    throw new IllegalStateException("Non transportable unit in sea");
                }
                Iterator transportIter = transports.iterator();
                boolean found = false;
                while (transportIter.hasNext()) {
                    Unit transport = (Unit)transportIter.next();
                    int capacity = this.m_transportTracker.getAvailableCapacity(transport);
                    if (capacity < cost) continue;
                    this.m_bridge.addChange(this.m_transportTracker.loadTransportChange((TripleAUnit)transport, toLoad, this.m_player));
                    found = true;
                    break;
                }
                if (found) continue;
                throw new IllegalStateException("Cannot load all land units in sea transports. Please make sure you have enough transports. You may need to re-order the xml's placement of transports and land units, as the engine will try to fill them in the order they are given.");
            }
        }
    }

    private void resetBonusMovement() {
        GameData data = this.getData();
        CompositeChange change = new CompositeChange();
        for (Unit u : data.getUnits()) {
            if (TripleAUnit.get(u).getBonusMovement() == 0) continue;
            change.add(ChangeFactory.unitPropertyChange(u, 0, "bonusMovement"));
        }
        if (!change.isEmpty()) {
            this.m_bridge.getHistoryWriter().startEvent("Reseting Bonus Movement of Units");
            this.m_bridge.addChange(change);
        }
    }

    private void removeMovementFromAirOnDamagedAlliedCarriers(IDelegateBridge aBridge, PlayerID player) {
        GameData data = aBridge.getData();
        CompositeMatchAnd crippledAlliedCarriersMatch = new CompositeMatchAnd(Matches.isUnitAllied(player, data), Matches.unitIsOwnedBy(player).invert(), Matches.UnitIsCarrier, Matches.UnitHasWhenCombatDamagedEffect("unitsMayNotLeaveAlliedCarrier"));
        CompositeMatchAnd<Unit> ownedFightersMatch = new CompositeMatchAnd<Unit>(Matches.unitIsOwnedBy(player), Matches.UnitIsAir, Matches.UnitCanLandOnCarrier);
        CompositeChange change = new CompositeChange();
        for (Territory t : data.getMap().getTerritories()) {
            List<Unit> crippledAlliedCarriers;
            List<Unit> ownedFighters = t.getUnits().getMatches(ownedFightersMatch);
            if (ownedFighters.isEmpty() || (crippledAlliedCarriers = Match.getMatches(t.getUnits().getUnits(), crippledAlliedCarriersMatch)).isEmpty()) continue;
            for (Unit fighter : ownedFighters) {
                TripleAUnit taUnit = (TripleAUnit)fighter;
                if (taUnit.getTransportedBy() == null || !crippledAlliedCarriers.contains(taUnit.getTransportedBy())) continue;
                change.add(ChangeFactory.markNoMovementChange(fighter));
            }
        }
        if (!change.isEmpty()) {
            aBridge.addChange(change);
        }
    }

    private void giveBonusMovement(IDelegateBridge aBridge, PlayerID player) {
        GameData data = aBridge.getData();
        CompositeChange change = new CompositeChange();
        for (Territory t : data.getMap().getTerritories()) {
            for (Unit u : t.getUnits().getUnits()) {
                if (!Matches.UnitCanBeGivenBonusMovementByFacilitiesInItsTerritory(t, player, data).match(u) || !Matches.isUnitAllied(player, data).match(u)) continue;
                int bonusMovement = Integer.MIN_VALUE;
                ArrayList<Unit> givesBonusUnits = new ArrayList<Unit>();
                CompositeMatchAnd givesBonusUnit = new CompositeMatchAnd(Matches.alliedUnit(player, data), Matches.UnitCanGiveBonusMovementToThisUnit(u));
                givesBonusUnits.addAll(Match.getMatches(t.getUnits().getUnits(), givesBonusUnit));
                if (Matches.UnitIsSea.match(u)) {
                    CompositeMatchAnd givesBonusUnitLand = new CompositeMatchAnd(givesBonusUnit, Matches.UnitIsLand);
                    ArrayList<Territory> neighbors = new ArrayList<Territory>(data.getMap().getNeighbors(t, Matches.TerritoryIsLand));
                    for (Territory current : neighbors) {
                        givesBonusUnits.addAll(Match.getMatches(current.getUnits().getUnits(), givesBonusUnitLand));
                    }
                }
                for (Unit bonusGiver : givesBonusUnits) {
                    int tempBonus = UnitAttachment.get(bonusGiver.getType()).getGivesMovement().getInt(u.getType());
                    if (tempBonus <= bonusMovement) continue;
                    bonusMovement = tempBonus;
                }
                if (bonusMovement == Integer.MIN_VALUE || bonusMovement == 0) continue;
                bonusMovement = Math.max(bonusMovement, UnitAttachment.get(u.getType()).getMovement(player) * -1);
                change.add(ChangeFactory.unitPropertyChange(u, bonusMovement, "bonusMovement"));
            }
        }
        if (!change.isEmpty()) {
            aBridge.getHistoryWriter().startEvent("Giving bonus movement to units");
            aBridge.addChange(change);
        }
    }

    public static void repairBattleShips(IDelegateBridge aBridge, PlayerID player, boolean beforeTurn) {
        GameData data = aBridge.getData();
        CompositeMatchAnd<Unit> damagedBattleship = new CompositeMatchAnd<Unit>(Matches.UnitIsTwoHit, Matches.UnitIsDamaged);
        CompositeMatchAnd<Unit> damagedBattleshipOwned = new CompositeMatchAnd<Unit>(damagedBattleship, Matches.unitIsOwnedBy(player));
        ArrayList<Unit> damaged = new ArrayList<Unit>();
        for (Territory current : data.getMap().getTerritories()) {
            if (!Properties.getTwoHitPointUnitsRequireRepairFacilities(data)) {
                if (beforeTurn) {
                    damaged.addAll(current.getUnits().getMatches(damagedBattleshipOwned));
                    continue;
                }
                damaged.addAll(current.getUnits().getMatches(damagedBattleship));
                continue;
            }
            damaged.addAll(current.getUnits().getMatches(new CompositeMatchAnd<Unit>(damagedBattleshipOwned, Matches.UnitCanBeRepairedByFacilitiesInItsTerritory(current, player, data))));
        }
        if (damaged.size() == 0) {
            return;
        }
        List<Unit> damagedCarriers = Match.getMatches(damaged, Matches.UnitHasWhenCombatDamagedEffect("unitsMayNotLeaveAlliedCarrier"));
        IntegerMap<Unit> hits = new IntegerMap<Unit>();
        for (Unit unit : damaged) {
            hits.put(unit, 0);
        }
        aBridge.addChange(ChangeFactory.unitsHit(hits));
        aBridge.getHistoryWriter().startEvent(damaged.size() + " " + MyFormatter.pluralize("unit", damaged.size()) + " repaired.");
        CompositeChange clearAlliedAir = new CompositeChange();
        for (Unit carrier : damagedCarriers) {
            clearAlliedAir.add(MustFightBattle.clearTransportedByForAlliedAirOnCarrier(Collections.singleton(carrier), carrier.getTerritoryUnitIsIn(), carrier.getOwner(), data));
        }
        if (!clearAlliedAir.isEmpty()) {
            aBridge.addChange(clearAlliedAir);
        }
    }

    @Override
    public String move(Collection<Unit> units, Route route, Collection<Unit> transportsThatCanBeLoaded, Map<Unit, Collection<Unit>> newDependents) {
        String numErrorsMsg;
        GameData data = this.getData();
        PlayerID player = this.getUnitsOwner(units);
        MoveValidationResult result = MoveValidator.validateMove(units, route, player, transportsThatCanBeLoaded, newDependents, this.m_nonCombat, this.m_movesToUndo, data);
        StringBuilder errorMsg = new StringBuilder(100);
        int numProblems = result.getTotalWarningCount() - (result.hasError() ? 0 : 1);
        String string = numErrorsMsg = numProblems > 0 ? "; " + numProblems + " " + MyFormatter.pluralize("error", numProblems) + " not shown" : "";
        if (result.hasError()) {
            return errorMsg.append(result.getError()).append(numErrorsMsg).toString();
        }
        if (result.hasDisallowedUnits()) {
            return errorMsg.append(result.getDisallowedUnitWarning(0)).append(numErrorsMsg).toString();
        }
        boolean isKamikaze = false;
        boolean getKamikazeAir = Properties.getKamikaze_Airplanes(data);
        Collection<Object> kamikazeUnits = new ArrayList();
        if ((getKamikazeAir || Match.someMatch(units, Matches.UnitIsKamikaze)) && (kamikazeUnits = result.getUnresolvedUnits("Not all air units can land")).size() > 0 && this.getRemotePlayer().confirmMoveKamikaze()) {
            for (Unit unit : kamikazeUnits) {
                if (!getKamikazeAir && !Matches.UnitIsKamikaze.match(unit)) continue;
                result.removeUnresolvedUnit("Not all air units can land", unit);
                isKamikaze = true;
            }
        }
        if (result.hasUnresolvedUnits()) {
            return errorMsg.append(result.getUnresolvedUnitWarning(0)).append(numErrorsMsg).toString();
        }
        AAInMoveUtil aaInMoveUtil = new AAInMoveUtil();
        aaInMoveUtil.initialize(this.m_bridge);
        Collection<Territory> collection = aaInMoveUtil.getTerritoriesWhereAAWillFire(route, units);
        if (!collection.isEmpty() && !this.getRemotePlayer().confirmMoveInFaceOfAA(collection)) {
            return null;
        }
        UndoableMove currentMove = new UndoableMove(data, units, route);
        String transcriptText = MyFormatter.unitsToTextNoOwner(units) + " moved from " + route.getStart().getName() + " to " + route.getEnd().getName();
        this.m_bridge.getHistoryWriter().startEvent(transcriptText, currentMove.getDescriptionObject());
        if (isKamikaze) {
            this.m_bridge.getHistoryWriter().addChildToEvent("This was a kamikaze move, for at least some of the units", kamikazeUnits);
        }
        this.m_tempMovePerformer = new MovePerformer();
        this.m_tempMovePerformer.initialize(this);
        this.m_tempMovePerformer.moveUnits(units, route, player, transportsThatCanBeLoaded, newDependents, currentMove);
        this.m_tempMovePerformer = null;
        return null;
    }

    public static Collection<Territory> getEmptyNeutral(Route route) {
        CompositeMatchAnd<Territory> emptyNeutral = new CompositeMatchAnd<Territory>(Matches.TerritoryIsEmpty, Matches.TerritoryIsNeutralButNotWater);
        Collection<Territory> neutral = route.getMatches(emptyNeutral);
        return neutral;
    }

    public static Change ensureCanMoveOneSpaceChange(Unit unit) {
        int alreadyMoved = TripleAUnit.get(unit).getAlreadyMoved();
        int maxMovement = UnitAttachment.get(unit.getType()).getMovement(unit.getOwner());
        int bonusMovement = TripleAUnit.get(unit).getBonusMovement();
        return ChangeFactory.unitPropertyChange(unit, Math.min(alreadyMoved, maxMovement + bonusMovement - 1), "alreadyMoved");
    }

    private void removeAirThatCantLand() {
        GameData data = this.getData();
        boolean lhtrCarrierProd = AirThatCantLandUtil.isLHTRCarrierProduction(data) || AirThatCantLandUtil.isLandExistingFightersOnNewCarriers(data);
        boolean hasProducedCarriers = this.m_player.getUnits().someMatch(Matches.UnitIsCarrier);
        AirThatCantLandUtil util = new AirThatCantLandUtil(this.m_bridge);
        util.removeAirThatCantLand(this.m_player, lhtrCarrierProd && hasProducedCarriers);
        for (PlayerID player : data.getPlayerList()) {
            if (player.equals(this.m_player)) continue;
            util.removeAirThatCantLand(player, (player.getUnits().someMatch(Matches.UnitIsCarrier) || hasProducedCarriers) && lhtrCarrierProd);
        }
    }

    public static Map<Unit, Unit> mapTransports(Route route, Collection<Unit> units, Collection<Unit> transportsToLoad) {
        if (route.isLoad()) {
            return MoveDelegate.mapTransportsToLoad(units, transportsToLoad);
        }
        if (route.isUnload()) {
            return MoveDelegate.mapTransportsAlreadyLoaded(units, route.getStart().getUnits().getUnits());
        }
        return MoveDelegate.mapTransportsAlreadyLoaded(units, units);
    }

    public static Map<Unit, Unit> mapTransports(Route route, Collection<Unit> units, Collection<Unit> transportsToLoad, boolean isload, PlayerID player) {
        if (isload) {
            return MoveDelegate.mapTransportsToLoad(units, transportsToLoad);
        }
        if (route.isUnload()) {
            return MoveDelegate.mapTransportsAlreadyLoaded(units, route.getStart().getUnits().getUnits());
        }
        return MoveDelegate.mapTransportsAlreadyLoaded(units, units);
    }

    public static Map<Unit, Unit> mapAirTransports(Route route, Collection<Unit> units, Collection<Unit> transportsToLoad, boolean isload, PlayerID player) {
        return MoveDelegate.mapTransports(route, units, transportsToLoad, isload, player);
    }

    public static List<Unit> mapAirTransportPossibilities(Route route, Collection<Unit> units, Collection<Unit> transportsToLoad, boolean isload, PlayerID player) {
        return MoveDelegate.mapAirTransportsToLoad2(units, Match.getMatches(transportsToLoad, Matches.UnitIsAirTransport));
    }

    private static Map<Unit, Unit> mapTransportsAlreadyLoaded(Collection<Unit> units, Collection<Unit> transports) {
        List<Unit> canBeTransported = Match.getMatches(units, Matches.UnitCanBeTransported);
        List<Unit> canTransport = Match.getMatches(transports, Matches.UnitCanTransport);
        TransportTracker transportTracker = new TransportTracker();
        HashMap<Unit, Unit> mapping = new HashMap<Unit, Unit>();
        for (Unit currentTransported : canBeTransported) {
            Unit transport = transportTracker.transportedBy(currentTransported);
            if (transport == null || !canTransport.contains(transport)) continue;
            mapping.put(currentTransported, transport);
        }
        return mapping;
    }

    private static Map<Unit, Unit> mapTransportsToLoad(Collection<Unit> units, Collection<Unit> transports) {
        List<Unit> canBeTransported = Match.getMatches(units, Matches.UnitCanBeTransported);
        int transportIndex = 0;
        TransportTracker transportTracker = new TransportTracker();
        Comparator<Unit> c = new Comparator<Unit>(){

            @Override
            public int compare(Unit o1, Unit o2) {
                int cost1 = UnitAttachment.get(o1.getUnitType()).getTransportCost();
                int cost2 = UnitAttachment.get(o2.getUnitType()).getTransportCost();
                return cost2 - cost1;
            }
        };
        Collections.sort(canBeTransported, c);
        List<Unit> canTransport = Match.getMatches(transports, Matches.UnitCanTransport);
        HashMap<Unit, Unit> mapping = new HashMap<Unit, Unit>();
        IntegerMap<Unit> addedLoad = new IntegerMap<Unit>();
        Comparator<Unit> previouslyLoadedToLast = MoveDelegate.transportsThatPreviouslyUnloadedComeLast();
        for (Unit land : canBeTransported) {
            UnitAttachment landUA = UnitAttachment.get(land.getType());
            int cost = landUA.getTransportCost();
            boolean loaded = false;
            List<Unit> shiftedToEnd = Util.shiftElementsToEnd(canTransport, transportIndex);
            Collections.sort(shiftedToEnd, previouslyLoadedToLast);
            Iterator<Unit> transportIter = shiftedToEnd.iterator();
            while (transportIter.hasNext() && !loaded) {
                if (++transportIndex >= canTransport.size()) {
                    transportIndex = 0;
                }
                Unit transport = transportIter.next();
                int capacity = transportTracker.getAvailableCapacity(transport);
                if ((capacity -= addedLoad.getInt(transport)) < cost) continue;
                addedLoad.add(transport, cost);
                mapping.put(land, transport);
                loaded = true;
            }
        }
        return mapping;
    }

    private static Comparator<Unit> transportsThatPreviouslyUnloadedComeLast() {
        return new Comparator<Unit>(){
            private final TransportTracker m_tracker = new TransportTracker();

            @Override
            public int compare(Unit t1, Unit t2) {
                boolean t2previous;
                if (t1 == t2 || t1.equals(t2)) {
                    return 0;
                }
                boolean t1previous = this.m_tracker.hasTransportUnloadedInPreviousPhase(t1);
                if (t1previous == (t2previous = this.m_tracker.hasTransportUnloadedInPreviousPhase(t2))) {
                    return 0;
                }
                if (!t1previous) {
                    return -1;
                }
                return 1;
            }
        };
    }

    private static List<Unit> mapAirTransportsToLoad2(Collection<Unit> units, Collection<Unit> transports) {
        Comparator<Unit> c = new Comparator<Unit>(){

            @Override
            public int compare(Unit o1, Unit o2) {
                int cost1 = UnitAttachment.get(o1.getUnitType()).getTransportCost();
                int cost2 = UnitAttachment.get(o2.getUnitType()).getTransportCost();
                return cost2 - cost1;
            }
        };
        Collections.sort((List)units, c);
        ArrayList<Unit> totalLoad = new ArrayList<Unit>();
        Set<UnitCategory> unitTypes = UnitSeperator.categorize(units, null, false, true);
        Set<UnitCategory> transportTypes = UnitSeperator.categorize(transports, null, false, false);
        for (UnitCategory unitType : unitTypes) {
            int transportCost = unitType.getTransportCost();
            for (UnitCategory transportType : transportTypes) {
                int transportCapacity = UnitAttachment.get(transportType.getType()).getTransportCapacity();
                if (transportCost <= 0 || transportCapacity < transportCost) continue;
                int transportCount = Match.countMatches(transports, Matches.unitIsOfType(transportType.getType()));
                int ttlTransportCapacity = transportCount * (int)Math.floor(transportCapacity / transportCost);
                totalLoad.addAll(Match.getNMatches(units, ttlTransportCapacity, Matches.unitIsOfType(unitType.getType())));
            }
        }
        return totalLoad;
    }

    @Override
    public int PUsAlreadyLost(Territory t) {
        return this.m_PUsLost.getInt(t);
    }

    @Override
    public void PUsLost(Territory t, int amt) {
        this.m_PUsLost.add(t, amt);
    }
}

