/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.triplea.delegate;

import games.strategy.engine.data.Change;
import games.strategy.engine.data.ChangeFactory;
import games.strategy.engine.data.CompositeChange;
import games.strategy.engine.data.GameData;
import games.strategy.engine.data.PlayerID;
import games.strategy.engine.data.Resource;
import games.strategy.engine.data.Route;
import games.strategy.engine.data.Territory;
import games.strategy.engine.data.TerritoryEffect;
import games.strategy.engine.data.Unit;
import games.strategy.engine.data.UnitType;
import games.strategy.engine.delegate.IDelegateBridge;
import games.strategy.engine.random.IRandomStats;
import games.strategy.sound.ClipPlayer;
import games.strategy.triplea.Properties;
import games.strategy.triplea.TripleAUnit;
import games.strategy.triplea.attatchments.PlayerAttachment;
import games.strategy.triplea.attatchments.TechAbilityAttachment;
import games.strategy.triplea.attatchments.TerritoryAttachment;
import games.strategy.triplea.attatchments.UnitAttachment;
import games.strategy.triplea.delegate.AbstractBattle;
import games.strategy.triplea.delegate.BattleCalculator;
import games.strategy.triplea.delegate.BattleTracker;
import games.strategy.triplea.delegate.DelegateFinder;
import games.strategy.triplea.delegate.DiceRoll;
import games.strategy.triplea.delegate.Die;
import games.strategy.triplea.delegate.EditDelegate;
import games.strategy.triplea.delegate.ExecutionStack;
import games.strategy.triplea.delegate.IBattle;
import games.strategy.triplea.delegate.IExecutable;
import games.strategy.triplea.delegate.Matches;
import games.strategy.triplea.delegate.dataObjects.BattleRecord;
import games.strategy.triplea.delegate.dataObjects.CasualtyDetails;
import games.strategy.triplea.formatter.MyFormatter;
import games.strategy.triplea.oddsCalculator.ta.BattleResults;
import games.strategy.triplea.player.ITripleaPlayer;
import games.strategy.util.CompositeMatchAnd;
import games.strategy.util.CompositeMatchOr;
import games.strategy.util.IntegerMap;
import games.strategy.util.Match;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StrategicBombingRaidBattle
extends AbstractBattle {
    private static final long serialVersionUID = 8490171037606078890L;
    private static final String RAID = "Strategic bombing raid";
    private static final String FIRE_AA = "Fire AA";
    protected final HashMap<Unit, HashSet<Unit>> m_targets = new HashMap();
    protected final ExecutionStack m_stack = new ExecutionStack();
    protected List<String> m_steps;
    protected List<Unit> m_defendingAA;
    protected Set<String> m_AAtypes;
    private int m_bombingRaidTotal;
    private final IntegerMap<Unit> m_bombingRaidDamage = new IntegerMap();

    public StrategicBombingRaidBattle(Territory battleSite, GameData data, PlayerID attacker, BattleTracker battleTracker) {
        super(battleSite, attacker, battleTracker, true, IBattle.BattleType.BOMBING_RAID, data);
        this.m_isAmphibious = false;
        this.updateDefendingUnits();
    }

    protected void updateDefendingUnits() {
        HashMap<String, HashSet<UnitType>> airborneTechTargetsAllowed = TechAbilityAttachment.getAirborneTargettedByAA(this.m_attacker, this.m_data);
        CompositeMatchOr defenders = new CompositeMatchOr(Matches.UnitIsAtMaxDamageOrNotCanBeDamaged(this.m_battleSite).invert(), Matches.UnitIsAAthatCanFire(this.m_attackingUnits, airborneTechTargetsAllowed, this.m_attacker, Matches.UnitIsAAforBombingThisUnitOnly, this.m_data));
        if (this.m_targets.isEmpty()) {
            this.m_defendingUnits = Match.getMatches(this.m_battleSite.getUnits().getUnits(), defenders);
        } else {
            List<Unit> targets = Match.getMatches(this.m_battleSite.getUnits().getUnits(), Matches.UnitIsAAthatCanFire(this.m_attackingUnits, airborneTechTargetsAllowed, this.m_attacker, Matches.UnitIsAAforBombingThisUnitOnly, this.m_data));
            targets.addAll(this.m_targets.keySet());
            this.m_defendingUnits = targets;
        }
    }

    @Override
    public boolean isEmpty() {
        return this.m_attackingUnits.isEmpty();
    }

    @Override
    public void removeAttack(Route route, Collection<Unit> units) {
        this.removeAttackers(units, true);
    }

    private void removeAttackers(Collection<Unit> units, boolean removeTarget) {
        this.m_attackingUnits.removeAll(units);
        Iterator<Unit> targetIter = this.m_targets.keySet().iterator();
        while (targetIter.hasNext()) {
            HashSet<Unit> currentAttackers = this.m_targets.get(targetIter.next());
            currentAttackers.removeAll(units);
            if (!currentAttackers.isEmpty() || !removeTarget) continue;
            targetIter.remove();
        }
    }

    private Unit getTarget(Unit attacker) {
        for (Unit target : this.m_targets.keySet()) {
            if (!this.m_targets.get(target).contains(attacker)) continue;
            return target;
        }
        throw new IllegalStateException("Unit " + attacker.getType().getName() + " has no target");
    }

    @Override
    public Change addAttackChange(Route route, Collection<Unit> units, HashMap<Unit, HashSet<Unit>> targets) {
        this.m_attackingUnits.addAll(units);
        if (targets == null) {
            return ChangeFactory.EMPTY_CHANGE;
        }
        for (Unit target : targets.keySet()) {
            HashSet<Unit> currentAttackers = this.m_targets.get(target);
            if (currentAttackers == null) {
                currentAttackers = new HashSet();
            }
            currentAttackers.addAll((Collection<Unit>)targets.get(target));
            this.m_targets.put(target, currentAttackers);
        }
        return ChangeFactory.EMPTY_CHANGE;
    }

    @Override
    public void fight(IDelegateBridge bridge) {
        if (this.m_stack.isExecuting()) {
            this.showBattle(bridge);
            this.m_stack.execute(bridge);
            return;
        }
        this.updateDefendingUnits();
        bridge.getHistoryWriter().startEvent("Strategic bombing raid in " + this.m_battleSite, this.m_battleSite);
        BattleCalculator.sortPreBattle(this.m_attackingUnits, this.m_data);
        HashMap<String, HashSet<UnitType>> airborneTechTargetsAllowed = TechAbilityAttachment.getAirborneTargettedByAA(this.m_attacker, this.m_data);
        this.m_defendingAA = this.m_battleSite.getUnits().getMatches(Matches.UnitIsAAthatCanFire(this.m_attackingUnits, airborneTechTargetsAllowed, this.m_attacker, Matches.UnitIsAAforBombingThisUnitOnly, this.m_data));
        this.m_AAtypes = UnitAttachment.getAllOfTypeAAs(this.m_defendingAA);
        boolean hasAA = this.m_defendingAA.size() > 0;
        this.m_steps = new ArrayList<String>();
        if (hasAA) {
            for (int i = 0; i < UnitAttachment.getAllOfTypeAAs(this.m_defendingAA).size(); ++i) {
                this.m_steps.add(FIRE_AA);
            }
        }
        this.m_steps.add(RAID);
        this.showBattle(bridge);
        ArrayList<IExecutable> steps = new ArrayList<IExecutable>();
        if (hasAA) {
            steps.add(new FireAA());
        }
        steps.add(new ConductBombing());
        steps.add(new IExecutable(){
            private static final long serialVersionUID = 4299575008166316488L;

            public void execute(ExecutionStack stack, IDelegateBridge bridge) {
                IntegerMap<UnitType> costs;
                String transcriptText;
                PlayerAttachment pa;
                AbstractBattle.getDisplay(bridge).gotoBattleStep(StrategicBombingRaidBattle.this.m_battleID, StrategicBombingRaidBattle.RAID);
                if (StrategicBombingRaidBattle.this.isSBRAffectsUnitProduction()) {
                    bridge.getHistoryWriter().addChildToEvent("Bombing raid costs " + StrategicBombingRaidBattle.this.m_bombingRaidTotal + " " + " production in " + StrategicBombingRaidBattle.this.m_battleSite.getName());
                } else if (StrategicBombingRaidBattle.this.isDamageFromBombingDoneToUnitsInsteadOfTerritories()) {
                    bridge.getHistoryWriter().addChildToEvent("Bombing raid in " + StrategicBombingRaidBattle.this.m_battleSite.getName() + " causes " + StrategicBombingRaidBattle.this.m_bombingRaidTotal + " damage total. " + (StrategicBombingRaidBattle.this.m_bombingRaidDamage.size() > 1 ? " Damaged units is as follows: " + MyFormatter.integerUnitMapToString(StrategicBombingRaidBattle.this.m_bombingRaidDamage) : ""));
                } else {
                    bridge.getHistoryWriter().addChildToEvent("Bombing raid costs " + StrategicBombingRaidBattle.this.m_bombingRaidTotal + " " + MyFormatter.pluralize("PU", StrategicBombingRaidBattle.this.m_bombingRaidTotal));
                }
                if ((StrategicBombingRaidBattle.this.isPacificTheater() || StrategicBombingRaidBattle.this.isSBRVictoryPoints()) && StrategicBombingRaidBattle.this.m_defender.getName().equals("Japanese") && (pa = PlayerAttachment.get(StrategicBombingRaidBattle.this.m_defender)) != null) {
                    Change changeVP = ChangeFactory.attachmentPropertyChange(pa, -(StrategicBombingRaidBattle.this.m_bombingRaidTotal / 10) + pa.getVps(), "vps");
                    bridge.addChange(changeVP);
                    bridge.getHistoryWriter().addChildToEvent("Bombing raid costs " + StrategicBombingRaidBattle.this.m_bombingRaidTotal / 10 + " " + MyFormatter.pluralize("vp", StrategicBombingRaidBattle.this.m_bombingRaidTotal / 10));
                }
                if (Match.someMatch(StrategicBombingRaidBattle.this.m_attackingUnits, Matches.UnitIsSuicide)) {
                    List<Unit> suicideUnits = Match.getMatches(StrategicBombingRaidBattle.this.m_attackingUnits, Matches.UnitIsSuicide);
                    StrategicBombingRaidBattle.this.m_attackingUnits.removeAll(suicideUnits);
                    Change removeSuicide = ChangeFactory.removeUnits(StrategicBombingRaidBattle.this.m_battleSite, suicideUnits);
                    transcriptText = MyFormatter.unitsToText(suicideUnits) + " lost in " + StrategicBombingRaidBattle.this.m_battleSite.getName();
                    costs = BattleCalculator.getCostsForTUV(StrategicBombingRaidBattle.this.m_attacker, StrategicBombingRaidBattle.this.m_data);
                    int tuvLostAttacker = BattleCalculator.getTUV(suicideUnits, StrategicBombingRaidBattle.this.m_attacker, costs, StrategicBombingRaidBattle.this.m_data);
                    StrategicBombingRaidBattle.this.m_attackerLostTUV += tuvLostAttacker;
                    bridge.getHistoryWriter().addChildToEvent(transcriptText, suicideUnits);
                    bridge.addChange(removeSuicide);
                }
                if (Match.someMatch(StrategicBombingRaidBattle.this.m_targets.keySet(), Matches.UnitCanDieFromReachingMaxDamage)) {
                    List<Unit> unitsCanDie = Match.getMatches(StrategicBombingRaidBattle.this.m_targets.keySet(), Matches.UnitCanDieFromReachingMaxDamage);
                    unitsCanDie.retainAll(Match.getMatches(unitsCanDie, Matches.UnitIsAtMaxDamageOrNotCanBeDamaged(StrategicBombingRaidBattle.this.m_battleSite)));
                    if (!unitsCanDie.isEmpty()) {
                        Change removeDead = ChangeFactory.removeUnits(StrategicBombingRaidBattle.this.m_battleSite, unitsCanDie);
                        transcriptText = MyFormatter.unitsToText(unitsCanDie) + " lost in " + StrategicBombingRaidBattle.this.m_battleSite.getName();
                        costs = BattleCalculator.getCostsForTUV(StrategicBombingRaidBattle.this.m_defender, StrategicBombingRaidBattle.this.m_data);
                        int tuvLostDefender = BattleCalculator.getTUV(unitsCanDie, StrategicBombingRaidBattle.this.m_defender, costs, StrategicBombingRaidBattle.this.m_data);
                        StrategicBombingRaidBattle.this.m_defenderLostTUV += tuvLostDefender;
                        bridge.getHistoryWriter().addChildToEvent(transcriptText, unitsCanDie);
                        bridge.addChange(removeDead);
                    }
                }
            }
        });
        steps.add(new IExecutable(){
            private static final long serialVersionUID = -7649516174883172328L;

            public void execute(ExecutionStack stack, IDelegateBridge bridge) {
                StrategicBombingRaidBattle.this.end(bridge);
            }
        });
        Collections.reverse(steps);
        for (IExecutable executable : steps) {
            this.m_stack.push(executable);
        }
        this.m_stack.execute(bridge);
    }

    private void end(IDelegateBridge bridge) {
        if (this.isSBRAffectsUnitProduction()) {
            StrategicBombingRaidBattle.getDisplay(bridge).battleEnd(this.m_battleID, "Bombing raid cost " + this.m_bombingRaidTotal + " production.");
        } else if (this.isDamageFromBombingDoneToUnitsInsteadOfTerritories()) {
            StrategicBombingRaidBattle.getDisplay(bridge).battleEnd(this.m_battleID, "Raid causes " + this.m_bombingRaidTotal + " damage total." + (this.m_bombingRaidDamage.size() > 1 ? " To units: " + MyFormatter.integerUnitMapToString(this.m_bombingRaidDamage) : ""));
        } else {
            StrategicBombingRaidBattle.getDisplay(bridge).battleEnd(this.m_battleID, "Bombing raid cost " + this.m_bombingRaidTotal + " " + MyFormatter.pluralize("PU", this.m_bombingRaidTotal));
        }
        if (this.m_bombingRaidTotal > 0) {
            this.m_whoWon = IBattle.WhoWon.ATTACKER;
            this.m_battleResultDescription = BattleRecord.BattleResultDescription.BOMBED;
        } else {
            this.m_whoWon = IBattle.WhoWon.DEFENDER;
            this.m_battleResultDescription = BattleRecord.BattleResultDescription.LOST;
        }
        this.m_battleTracker.getBattleRecords(this.m_data).addResultToBattle(this.m_attacker, this.m_battleID, this.m_defender, this.m_attackerLostTUV, this.m_defenderLostTUV, this.m_battleResultDescription, new BattleResults(this, this.m_data), this.m_bombingRaidTotal);
        this.m_isOver = true;
        this.m_battleTracker.removeBattle(this);
    }

    private void showBattle(IDelegateBridge bridge) {
        String title = "Bombing raid in " + this.m_battleSite.getName();
        StrategicBombingRaidBattle.getDisplay(bridge).showBattle(this.m_battleID, this.m_battleSite, title, this.m_attackingUnits, this.m_defendingUnits, null, null, null, Collections.<Unit, Collection<Unit>>emptyMap(), this.m_attacker, this.m_defender, this.isAmphibious(), this.getBattleType());
        StrategicBombingRaidBattle.getDisplay(bridge).listBattleSteps(this.m_battleID, this.m_steps);
    }

    private boolean isSBRAffectsUnitProduction() {
        return Properties.getSBRAffectsUnitProduction(this.m_data);
    }

    private boolean isDamageFromBombingDoneToUnitsInsteadOfTerritories() {
        return Properties.getDamageFromBombingDoneToUnitsInsteadOfTerritories(this.m_data);
    }

    private boolean isWW2V2() {
        return Properties.getWW2V2(this.m_data);
    }

    private boolean isLimitSBRDamageToProduction() {
        return Properties.getLimitRocketAndSBRDamageToProduction(this.m_data);
    }

    private boolean isLimitSBRDamagePerTurn(GameData data) {
        return Properties.getLimitSBRDamagePerTurn(data);
    }

    private boolean isPUCap(GameData data) {
        return Properties.getPUCap(data);
    }

    private boolean isSBRVictoryPoints() {
        return Properties.getSBRVictoryPoint(this.m_data);
    }

    private boolean isPacificTheater() {
        return Properties.getPacificTheater(this.m_data);
    }

    private Collection<Unit> calculateCasualties(Collection<Unit> validAttackingUnitsForThisRoll, Collection<Unit> defendingAA, IDelegateBridge bridge, DiceRoll dice) {
        int totalExpectingHits;
        boolean isEditMode = EditDelegate.getEditMode(this.m_data);
        if (isEditMode) {
            String text = "AA guns fire";
            CasualtyDetails casualtySelection = BattleCalculator.selectCasualties(RAID, this.m_attacker, validAttackingUnitsForThisRoll, bridge, "AA guns fire", null, false, this.m_battleID, false, 0);
            return casualtySelection.getKilled();
        }
        Collection<Unit> casualties = BattleCalculator.getAACasualties(validAttackingUnitsForThisRoll, defendingAA, dice, bridge, this.m_defender, this.m_attacker, this.m_battleID, this.m_battleSite);
        int n = totalExpectingHits = dice.getHits() > validAttackingUnitsForThisRoll.size() ? validAttackingUnitsForThisRoll.size() : dice.getHits();
        if (casualties.size() != totalExpectingHits) {
            throw new IllegalStateException("Wrong number of casualties, expecting:" + totalExpectingHits + " but got:" + casualties.size());
        }
        return casualties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyAAHits(final IDelegateBridge bridge, DiceRoll dice, Collection<Unit> casualties) {
        StrategicBombingRaidBattle.getDisplay(bridge).casualtyNotification(this.m_battleID, FIRE_AA, dice, this.m_attacker, casualties, Collections.<Unit>emptyList(), Collections.<Unit, Collection<Unit>>emptyMap());
        Runnable r = new Runnable(){

            public void run() {
                ITripleaPlayer defender = (ITripleaPlayer)bridge.getRemote(StrategicBombingRaidBattle.this.m_defender);
                defender.confirmEnemyCasualties(StrategicBombingRaidBattle.this.m_battleID, "Press space to continue", StrategicBombingRaidBattle.this.m_attacker);
            }
        };
        Thread t = new Thread(r, "click to continue waiter");
        t.start();
        ITripleaPlayer attacker = (ITripleaPlayer)bridge.getRemote(this.m_attacker);
        attacker.confirmOwnCasualties(this.m_battleID, "Press space to continue");
        try {
            bridge.leaveDelegateExecution();
            t.join();
        }
        catch (InterruptedException e) {
        }
        finally {
            bridge.enterDelegateExecution();
        }
    }

    private void removeAAHits(IDelegateBridge bridge, DiceRoll dice, Collection<Unit> casualties) {
        if (!casualties.isEmpty()) {
            bridge.getHistoryWriter().addChildToEvent(MyFormatter.unitsToTextNoOwner(casualties) + " killed by AA guns", casualties);
        }
        IntegerMap<UnitType> costs = BattleCalculator.getCostsForTUV(this.m_attacker, this.m_data);
        int tuvLostAttacker = BattleCalculator.getTUV(casualties, this.m_attacker, costs, this.m_data);
        this.m_attackerLostTUV += tuvLostAttacker;
        this.removeAttackers(casualties, false);
        Change remove = ChangeFactory.removeUnits(this.m_battleSite, casualties);
        bridge.addChange(remove);
    }

    @Override
    public void unitsLostInPrecedingBattle(IBattle battle, Collection<Unit> units, IDelegateBridge bridge) {
        throw new IllegalStateException("StrategicBombingRaidBattle should not have any preceding battle with which to possibly remove dependents from");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class ConductBombing
    implements IExecutable {
        private static final long serialVersionUID = 5579796391988452213L;
        private int[] m_dice;

        ConductBombing() {
        }

        @Override
        public void execute(ExecutionStack stack, IDelegateBridge bridge) {
            IExecutable rollDice = new IExecutable(){
                private static final long serialVersionUID = -4097858758514452368L;

                public void execute(ExecutionStack stack, IDelegateBridge bridge) {
                    ConductBombing.this.rollDice(bridge);
                }
            };
            IExecutable findCost = new IExecutable(){
                private static final long serialVersionUID = 8573539936364094095L;

                public void execute(ExecutionStack stack, IDelegateBridge bridge) {
                    ConductBombing.this.findCost(bridge);
                }
            };
            StrategicBombingRaidBattle.this.m_stack.push(findCost);
            StrategicBombingRaidBattle.this.m_stack.push(rollDice);
        }

        private void rollDice(IDelegateBridge bridge) {
            int rollCount = BattleCalculator.getRolls(StrategicBombingRaidBattle.this.m_attackingUnits, StrategicBombingRaidBattle.this.m_battleSite, StrategicBombingRaidBattle.this.m_attacker, false, (Collection<TerritoryEffect>)StrategicBombingRaidBattle.this.m_territoryEffects);
            if (rollCount == 0) {
                this.m_dice = null;
                return;
            }
            this.m_dice = new int[rollCount];
            boolean isEditMode = EditDelegate.getEditMode(StrategicBombingRaidBattle.this.m_data);
            if (isEditMode) {
                String annotation = StrategicBombingRaidBattle.this.m_attacker.getName() + " fixing dice to allocate cost of strategic bombing raid against " + StrategicBombingRaidBattle.this.m_defender.getName() + " in " + StrategicBombingRaidBattle.this.m_battleSite.getName();
                ITripleaPlayer attacker = (ITripleaPlayer)bridge.getRemote(StrategicBombingRaidBattle.this.m_attacker);
                this.m_dice = attacker.selectFixedDice(rollCount, 0, true, annotation, StrategicBombingRaidBattle.this.m_data.getDiceSides());
            } else {
                boolean doNotUseBombingBonus = !Properties.getUseBombingMaxDiceSidesAndBonus(StrategicBombingRaidBattle.this.m_data);
                String annotation = StrategicBombingRaidBattle.this.m_attacker.getName() + " rolling to allocate cost of strategic bombing raid against " + StrategicBombingRaidBattle.this.m_defender.getName() + " in " + StrategicBombingRaidBattle.this.m_battleSite.getName();
                if (!Properties.getLL_DAMAGE_ONLY(StrategicBombingRaidBattle.this.m_data)) {
                    if (doNotUseBombingBonus) {
                        this.m_dice = bridge.getRandom(StrategicBombingRaidBattle.this.m_data.getDiceSides(), rollCount, StrategicBombingRaidBattle.this.m_attacker, IRandomStats.DiceType.BOMBING, annotation);
                    } else {
                        int i = 0;
                        int diceSides = StrategicBombingRaidBattle.this.m_data.getDiceSides();
                        for (Unit u : StrategicBombingRaidBattle.this.m_attackingUnits) {
                            int rolls = BattleCalculator.getRolls(u, StrategicBombingRaidBattle.this.m_battleSite, StrategicBombingRaidBattle.this.m_attacker, false, (Collection<TerritoryEffect>)StrategicBombingRaidBattle.this.m_territoryEffects);
                            if (rolls < 1) continue;
                            UnitAttachment ua = UnitAttachment.get(u.getType());
                            int maxDice = ua.getBombingMaxDieSides();
                            int bonus = ua.getBombingBonus();
                            if (maxDice < 0) {
                                maxDice = diceSides;
                            }
                            if (bonus < 0) {
                                bonus = 0;
                            }
                            if (maxDice > 0) {
                                int[] dicerolls;
                                for (int die : dicerolls = bridge.getRandom(maxDice, rolls, StrategicBombingRaidBattle.this.m_attacker, IRandomStats.DiceType.BOMBING, annotation)) {
                                    this.m_dice[i] = die + bonus;
                                    ++i;
                                }
                                continue;
                            }
                            for (int j = 0; j < rolls; ++j) {
                                this.m_dice[i] = bonus;
                                ++i;
                            }
                        }
                    }
                } else {
                    int i = 0;
                    int diceSides = StrategicBombingRaidBattle.this.m_data.getDiceSides();
                    for (Unit u : StrategicBombingRaidBattle.this.m_attackingUnits) {
                        int rolls = BattleCalculator.getRolls(u, StrategicBombingRaidBattle.this.m_battleSite, StrategicBombingRaidBattle.this.m_attacker, false, (Collection<TerritoryEffect>)StrategicBombingRaidBattle.this.m_territoryEffects);
                        if (rolls < 1) continue;
                        UnitAttachment ua = UnitAttachment.get(u.getType());
                        int maxDice = ua.getBombingMaxDieSides();
                        int bonus = ua.getBombingBonus();
                        if (maxDice < 0 || doNotUseBombingBonus) {
                            maxDice = diceSides;
                        }
                        if (bonus < 0 || doNotUseBombingBonus) {
                            bonus = 0;
                        }
                        if (maxDice >= 5) {
                            bonus += (maxDice + 1) / 3;
                            maxDice = (maxDice + 1) / 3;
                        }
                        if (maxDice > 0) {
                            int[] dicerolls;
                            for (int die : dicerolls = bridge.getRandom(maxDice, rolls, StrategicBombingRaidBattle.this.m_attacker, IRandomStats.DiceType.BOMBING, annotation)) {
                                this.m_dice[i] = die + bonus;
                                ++i;
                            }
                            continue;
                        }
                        for (int j = 0; j < rolls; ++j) {
                            this.m_dice[i] = bonus;
                            ++i;
                        }
                    }
                }
            }
        }

        private void addToTargetDiceMap(Unit attackerUnit, Die roll, HashMap<Unit, List<Die>> targetToDiceMap) {
            if (StrategicBombingRaidBattle.this.m_targets == null || StrategicBombingRaidBattle.this.m_targets.isEmpty()) {
                return;
            }
            Unit target = StrategicBombingRaidBattle.this.getTarget(attackerUnit);
            List<Die> current = targetToDiceMap.get(target);
            if (current == null) {
                current = new ArrayList<Die>();
            }
            current.add(roll);
            targetToDiceMap.put(target, current);
        }

        private void findCost(IDelegateBridge bridge) {
            if (StrategicBombingRaidBattle.this.m_attackingUnits.isEmpty()) {
                return;
            }
            TerritoryAttachment ta = TerritoryAttachment.get(StrategicBombingRaidBattle.this.m_battleSite);
            int cost = 0;
            boolean lhtrBombers = Properties.getLHTR_Heavy_Bombers(StrategicBombingRaidBattle.this.m_data);
            int damageLimit = ta.getProduction();
            int index = 0;
            Boolean limitDamage = StrategicBombingRaidBattle.this.isWW2V2() || StrategicBombingRaidBattle.this.isLimitSBRDamageToProduction();
            ArrayList<Die> dice = new ArrayList<Die>();
            HashMap<Unit, List<Die>> targetToDiceMap = new HashMap<Unit, List<Die>>();
            for (Unit attacker : StrategicBombingRaidBattle.this.m_attackingUnits) {
                UnitAttachment ua = UnitAttachment.get(attacker.getType());
                int rolls = BattleCalculator.getRolls(attacker, StrategicBombingRaidBattle.this.m_battleSite, StrategicBombingRaidBattle.this.m_attacker, false, (Collection<TerritoryEffect>)StrategicBombingRaidBattle.this.m_territoryEffects);
                int costThisUnit = 0;
                if (rolls > 1 && (lhtrBombers || ua.getChooseBestRoll())) {
                    int max = 0;
                    int maxIndex = index;
                    int startIndex = index;
                    for (int i = 0; i < rolls; ++i) {
                        if (this.m_dice[index] + 1 > max) {
                            max = this.m_dice[index] + 1;
                            maxIndex = index;
                        }
                        ++index;
                    }
                    costThisUnit = max;
                    Die best = new Die(this.m_dice[maxIndex]);
                    dice.add(best);
                    this.addToTargetDiceMap(attacker, best, targetToDiceMap);
                    for (int i = 0; i < rolls; ++i) {
                        if (startIndex != maxIndex) {
                            Die notBest = new Die(this.m_dice[startIndex], -1, Die.DieType.IGNORED);
                            dice.add(notBest);
                            this.addToTargetDiceMap(attacker, notBest, targetToDiceMap);
                        }
                        ++startIndex;
                    }
                } else {
                    for (int i = 0; i < rolls; ++i) {
                        costThisUnit += this.m_dice[index] + 1;
                        Die die = new Die(this.m_dice[index]);
                        dice.add(die);
                        this.addToTargetDiceMap(attacker, die, targetToDiceMap);
                        ++index;
                    }
                }
                costThisUnit = Math.max(0, costThisUnit + TechAbilityAttachment.getBombingBonus(attacker.getType(), attacker.getOwner(), StrategicBombingRaidBattle.this.m_data));
                if (limitDamage.booleanValue()) {
                    costThisUnit = Math.min(costThisUnit, damageLimit);
                }
                cost += costThisUnit;
                if (StrategicBombingRaidBattle.this.m_targets.isEmpty()) continue;
                StrategicBombingRaidBattle.this.m_bombingRaidDamage.add(StrategicBombingRaidBattle.this.getTarget(attacker), costThisUnit);
            }
            if (StrategicBombingRaidBattle.this.isPUCap(StrategicBombingRaidBattle.this.m_data) || StrategicBombingRaidBattle.this.isLimitSBRDamagePerTurn(StrategicBombingRaidBattle.this.m_data)) {
                int alreadyLost = DelegateFinder.moveDelegate(StrategicBombingRaidBattle.this.m_data).PUsAlreadyLost(StrategicBombingRaidBattle.this.m_battleSite);
                int limit = Math.max(0, damageLimit - alreadyLost);
                cost = Math.min(cost, limit);
                if (!StrategicBombingRaidBattle.this.m_targets.isEmpty()) {
                    for (Unit u : StrategicBombingRaidBattle.this.m_bombingRaidDamage.keySet()) {
                        if (StrategicBombingRaidBattle.this.m_bombingRaidDamage.getInt(u) <= limit) continue;
                        StrategicBombingRaidBattle.this.m_bombingRaidDamage.put(u, limit);
                    }
                }
            }
            if (StrategicBombingRaidBattle.this.isDamageFromBombingDoneToUnitsInsteadOfTerritories() && !StrategicBombingRaidBattle.this.isSBRAffectsUnitProduction()) {
                if (!StrategicBombingRaidBattle.this.m_targets.keySet().containsAll(StrategicBombingRaidBattle.this.m_bombingRaidDamage.keySet())) {
                    throw new IllegalStateException("targets should contain all damaged units");
                }
                for (Unit current : StrategicBombingRaidBattle.this.m_bombingRaidDamage.keySet()) {
                    int currentUnitCost = StrategicBombingRaidBattle.this.m_bombingRaidDamage.getInt(current);
                    TripleAUnit taUnit = (TripleAUnit)current;
                    damageLimit = taUnit.getHowMuchMoreDamageCanThisUnitTake(current, StrategicBombingRaidBattle.this.m_battleSite);
                    if (StrategicBombingRaidBattle.this.m_bombingRaidDamage.getInt(current) > damageLimit) {
                        StrategicBombingRaidBattle.this.m_bombingRaidDamage.put(current, damageLimit);
                        cost = cost - currentUnitCost + damageLimit;
                        currentUnitCost = StrategicBombingRaidBattle.this.m_bombingRaidDamage.getInt(current);
                    }
                    int totalDamage = taUnit.getUnitDamage() + currentUnitCost;
                    AbstractBattle.getDisplay(bridge).bombingResults(StrategicBombingRaidBattle.this.m_battleID, dice, currentUnitCost);
                    DelegateFinder.moveDelegate(StrategicBombingRaidBattle.this.m_data).PUsLost(StrategicBombingRaidBattle.this.m_battleSite, currentUnitCost);
                    IntegerMap<Unit> hits = new IntegerMap<Unit>();
                    CompositeChange change = new CompositeChange();
                    hits.put(current, 1);
                    change.add(ChangeFactory.unitPropertyChange(current, totalDamage, "unitDamage"));
                    bridge.addChange(ChangeFactory.unitsHit(hits));
                    bridge.addChange(change);
                    bridge.getHistoryWriter().addChildToEvent("Bombing raid in " + StrategicBombingRaidBattle.this.m_battleSite.getName() + " rolls: " + MyFormatter.asDice(targetToDiceMap.get(current)) + " and causes: " + currentUnitCost + " damage to unit: " + current.getType().getName());
                    AbstractBattle.getRemote(bridge).reportMessage("Bombing raid in " + StrategicBombingRaidBattle.this.m_battleSite.getName() + " rolls: " + MyFormatter.asDice(targetToDiceMap.get(current)) + " and causes: " + currentUnitCost + " damage to unit: " + current.getType().getName(), "Bombing raid causes " + currentUnitCost + " damage to " + current.getType().getName());
                }
            } else if (StrategicBombingRaidBattle.this.isSBRAffectsUnitProduction()) {
                int unitProduction = ta.getUnitProduction();
                int alreadyLost = damageLimit - unitProduction;
                int limit = 2 * damageLimit - alreadyLost;
                cost = Math.min(cost, limit);
                AbstractBattle.getDisplay(bridge).bombingResults(StrategicBombingRaidBattle.this.m_battleID, dice, cost);
                DelegateFinder.moveDelegate(StrategicBombingRaidBattle.this.m_data).PUsLost(StrategicBombingRaidBattle.this.m_battleSite, cost);
                List<Unit> damagedFactory = Match.getMatches(StrategicBombingRaidBattle.this.m_battleSite.getUnits().getUnits(), Matches.UnitCanBeDamaged);
                IntegerMap<Unit> hits = new IntegerMap<Unit>();
                for (Unit factory : damagedFactory) {
                    hits.put(factory, 1);
                }
                bridge.addChange(ChangeFactory.unitsHit(hits));
                Integer newProduction = unitProduction - cost;
                Change change = ChangeFactory.attachmentPropertyChange(ta, newProduction.toString(), "unitProduction");
                bridge.addChange(change);
                bridge.getHistoryWriter().addChildToEvent("Bombing raid in " + StrategicBombingRaidBattle.this.m_battleSite.getName() + " rolls: " + MyFormatter.asDice(this.m_dice) + " and costs: " + cost + " production.");
                AbstractBattle.getRemote(bridge).reportMessage("Bombing raid in " + StrategicBombingRaidBattle.this.m_battleSite.getName() + " rolls: " + MyFormatter.asDice(this.m_dice) + " and costs: " + cost + " production.", "Bombing raid in " + StrategicBombingRaidBattle.this.m_battleSite.getName() + " costs: " + cost + " production.");
            } else {
                DelegateFinder.moveDelegate(StrategicBombingRaidBattle.this.m_data).PUsLost(StrategicBombingRaidBattle.this.m_battleSite, cost);
                AbstractBattle.getDisplay(bridge).bombingResults(StrategicBombingRaidBattle.this.m_battleID, dice, cost *= Properties.getPU_Multiplier(StrategicBombingRaidBattle.this.m_data).intValue());
                Resource PUs = StrategicBombingRaidBattle.this.m_data.getResourceList().getResource("PUs");
                int have = StrategicBombingRaidBattle.this.m_defender.getResources().getQuantity(PUs);
                int toRemove = Math.min(cost, have);
                Change change = ChangeFactory.changeResourcesChange(StrategicBombingRaidBattle.this.m_defender, PUs, -toRemove);
                bridge.addChange(change);
                bridge.getHistoryWriter().addChildToEvent("Bombing raid in " + StrategicBombingRaidBattle.this.m_battleSite.getName() + " rolls: " + MyFormatter.asDice(this.m_dice) + " and costs: " + cost + " " + MyFormatter.pluralize("PU", cost) + ".");
            }
            StrategicBombingRaidBattle.this.m_bombingRaidTotal = cost;
        }
    }

    class FireAA
    implements IExecutable {
        private static final long serialVersionUID = -4667856856747597406L;
        DiceRoll m_dice;
        Collection<Unit> m_casualties;

        FireAA() {
        }

        public void execute(ExecutionStack stack, IDelegateBridge bridge) {
            boolean isEditMode = EditDelegate.getEditMode(bridge.getData());
            for (final String currentTypeAA : StrategicBombingRaidBattle.this.m_AAtypes) {
                final List<Unit> currentPossibleAA = Match.getMatches(StrategicBombingRaidBattle.this.m_defendingAA, Matches.UnitIsAAofTypeAA(currentTypeAA));
                HashSet<UnitType> targetUnitTypesForThisTypeAA = UnitAttachment.get(((Unit)currentPossibleAA.iterator().next()).getType()).getTargetsAA(StrategicBombingRaidBattle.this.m_data);
                Set airborneTypesTargettedToo = TechAbilityAttachment.getAirborneTargettedByAA(StrategicBombingRaidBattle.this.m_attacker, StrategicBombingRaidBattle.this.m_data).get(currentTypeAA);
                final List validAttackingUnitsForThisRoll = Match.getMatches(StrategicBombingRaidBattle.this.m_attackingUnits, new CompositeMatchOr(Matches.unitIsOfTypes(targetUnitTypesForThisTypeAA), new CompositeMatchAnd(Matches.UnitIsAirborne, Matches.unitIsOfTypes(airborneTypesTargettedToo))));
                IExecutable roll = new IExecutable(){
                    private static final long serialVersionUID = 379538344036513009L;

                    public void execute(ExecutionStack stack, IDelegateBridge bridge) {
                        FireAA.this.m_dice = DiceRoll.rollAA(validAttackingUnitsForThisRoll, currentPossibleAA, bridge, StrategicBombingRaidBattle.this.m_battleSite);
                        if (currentTypeAA.equals("AA")) {
                            if (FireAA.this.m_dice.getHits() > 0) {
                                ClipPlayer.play("battle_aa_hit", StrategicBombingRaidBattle.this.m_defender.getName());
                            } else {
                                ClipPlayer.play("battle_aa_miss", StrategicBombingRaidBattle.this.m_defender.getName());
                            }
                        }
                    }
                };
                IExecutable calculateCasualties = new IExecutable(){
                    private static final long serialVersionUID = -4658133491636765763L;

                    public void execute(ExecutionStack stack, IDelegateBridge bridge) {
                        FireAA.this.m_casualties = StrategicBombingRaidBattle.this.calculateCasualties(validAttackingUnitsForThisRoll, currentPossibleAA, bridge, FireAA.this.m_dice);
                    }
                };
                IExecutable notifyCasualties = new IExecutable(){
                    private static final long serialVersionUID = -4989154196975570919L;

                    public void execute(ExecutionStack stack, IDelegateBridge bridge) {
                        StrategicBombingRaidBattle.this.notifyAAHits(bridge, FireAA.this.m_dice, FireAA.this.m_casualties);
                    }
                };
                IExecutable removeHits = new IExecutable(){
                    private static final long serialVersionUID = -3673833177336068509L;

                    public void execute(ExecutionStack stack, IDelegateBridge bridge) {
                        StrategicBombingRaidBattle.this.removeAAHits(bridge, FireAA.this.m_dice, FireAA.this.m_casualties);
                    }
                };
                stack.push(removeHits);
                stack.push(notifyCasualties);
                stack.push(calculateCasualties);
                if (isEditMode) continue;
                stack.push(roll);
            }
        }
    }
}

