/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.triplea.delegate;

import games.strategy.engine.data.Territory;
import games.strategy.engine.data.TerritoryEffect;
import games.strategy.engine.data.Unit;
import games.strategy.engine.data.UnitType;
import games.strategy.triplea.attatchments.TerritoryAttachment;
import games.strategy.triplea.attatchments.TerritoryEffectAttachment;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TerritoryEffectHelper {
    public static Collection<TerritoryEffect> getEffects(Territory location) {
        TerritoryAttachment ta = TerritoryAttachment.get(location);
        if (ta != null) {
            return TerritoryAttachment.get(location).getTerritoryEffect();
        }
        return new ArrayList<TerritoryEffect>();
    }

    public static int getTerritoryCombatBonus(UnitType type, Collection<TerritoryEffect> effects, boolean defending) {
        if (type == null || effects == null || effects.isEmpty()) {
            return 0;
        }
        int combatBonus = 0;
        for (TerritoryEffect effect : effects) {
            combatBonus += TerritoryEffectAttachment.get(effect).getCombatEffect(type, defending);
        }
        return combatBonus;
    }

    public static boolean unitLoosesBlitz(Unit unit, Territory location) {
        return TerritoryEffectHelper.unitTypeLoosesBlitz(unit.getType(), location);
    }

    public static boolean unitTypeLoosesBlitz(UnitType type, Territory location) {
        if (location == null || type == null) {
            throw new IllegalStateException("Location and UnitType can not be null");
        }
        for (TerritoryEffect effect : TerritoryEffectHelper.getEffects(location)) {
            if (!TerritoryEffectAttachment.get(effect).getNoBlitz().contains(type)) continue;
            return true;
        }
        return false;
    }

    public static boolean unitKeepsBlitz(Unit unit, Territory location) {
        return TerritoryEffectHelper.unitTypeKeepsBlitz(unit.getType(), location);
    }

    public static boolean unitTypeKeepsBlitz(UnitType type, Territory location) {
        return !TerritoryEffectHelper.unitTypeLoosesBlitz(type, location);
    }

    public static Set<UnitType> getUnitTypesThatLostBlitz(Collection<Territory> steps) {
        HashSet<UnitType> rVal = new HashSet<UnitType>();
        for (Territory location : steps) {
            for (TerritoryEffect effect : TerritoryEffectHelper.getEffects(location)) {
                rVal.addAll(TerritoryEffectAttachment.get(effect).getNoBlitz());
            }
        }
        return rVal;
    }
}

