/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.triplea.delegate;

import games.strategy.engine.data.Change;
import games.strategy.engine.data.GameData;
import games.strategy.engine.data.PlayerID;
import games.strategy.engine.delegate.IDelegateBridge;
import games.strategy.engine.history.IDelegateHistoryWriter;
import games.strategy.engine.message.IChannelSubscribor;
import games.strategy.engine.message.IRemote;
import games.strategy.engine.random.IRandomStats;
import games.strategy.triplea.delegate.TripleADelegateHistoryWriter;
import java.util.Properties;

public class TripleADelegateBridge
implements IDelegateBridge {
    private final IDelegateBridge m_bridge;
    private final TripleADelegateHistoryWriter m_historyWriter;

    public TripleADelegateBridge(IDelegateBridge bridge) {
        this.m_bridge = bridge;
        this.m_historyWriter = new TripleADelegateHistoryWriter(this.m_bridge.getHistoryWriter(), this.getData());
    }

    public GameData getData() {
        return this.m_bridge.getData();
    }

    public IDelegateHistoryWriter getHistoryWriter() {
        return this.m_historyWriter;
    }

    public PlayerID getPlayerID() {
        return this.m_bridge.getPlayerID();
    }

    public int getRandom(int max, PlayerID player, IRandomStats.DiceType diceType, String annotation) {
        return this.m_bridge.getRandom(max, player, diceType, annotation);
    }

    public int[] getRandom(int max, int count, PlayerID player, IRandomStats.DiceType diceType, String annotation) {
        return this.m_bridge.getRandom(max, count, player, diceType, annotation);
    }

    public void addChange(Change aChange) {
        this.m_bridge.addChange(aChange);
    }

    public String getStepName() {
        return this.m_bridge.getStepName();
    }

    public IRemote getRemote() {
        return this.m_bridge.getRemote();
    }

    public IRemote getRemote(PlayerID id) {
        return this.m_bridge.getRemote(id);
    }

    public IChannelSubscribor getDisplayChannelBroadcaster() {
        return this.m_bridge.getDisplayChannelBroadcaster();
    }

    public Properties getStepProperties() {
        return this.m_bridge.getStepProperties();
    }

    public void leaveDelegateExecution() {
        this.m_bridge.leaveDelegateExecution();
    }

    public void enterDelegateExecution() {
        this.m_bridge.enterDelegateExecution();
    }

    public void stopGameSequence() {
        this.m_bridge.stopGameSequence();
    }
}

