/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.triplea.image;

import games.strategy.triplea.ResourceLoader;
import games.strategy.ui.Util;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.net.URL;
import javax.imageio.ImageIO;

public class MapImage {
    private BufferedImage m_smallMapImage;
    public static final Font MAP_FONT = new Font("Ariel", 1, 12);

    private static Image loadImage(ResourceLoader loader, String name) {
        URL mapFileUrl = loader.getResource(name);
        if (mapFileUrl == null) {
            throw new IllegalStateException("resource not found:" + name);
        }
        try {
            return ImageIO.read(mapFileUrl);
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new IllegalStateException(e.getMessage());
        }
    }

    public BufferedImage getSmallMapImage() {
        return this.m_smallMapImage;
    }

    public void loadMaps(ResourceLoader loader) {
        Image smallFromFile = MapImage.loadImage(loader, "smallMap.jpeg");
        this.m_smallMapImage = Util.createImage(smallFromFile.getWidth(null), smallFromFile.getHeight(null), false);
        Graphics g = this.m_smallMapImage.getGraphics();
        g.drawImage(smallFromFile, 0, 0, null);
        g.dispose();
        smallFromFile.flush();
    }
}

