/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.triplea.image;

import games.strategy.triplea.ResourceLoader;
import games.strategy.triplea.image.BlendComposite;
import games.strategy.triplea.image.ImageRef;
import games.strategy.triplea.util.Stopwatch;
import games.strategy.ui.Util;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.net.URL;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import javax.imageio.ImageIO;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class TileImageFactory {
    private final Object m_mutex = new Object();
    private static final String SHOW_RELIEF_IMAGES_PREFERENCE = "ShowRelief2";
    private static boolean s_showReliefImages = true;
    private static final String SHOW_MAP_BLENDS_PREFERENCE = "ShowBlends";
    private static boolean s_showMapBlends = false;
    private static final String SHOW_MAP_BLEND_MODE = "BlendMode";
    private static String s_showMapBlendMode = "normal";
    private static final String SHOW_MAP_BLEND_ALPHA = "BlendAlpha";
    private static float s_showMapBlendAlpha = 1.0f;
    private final Composite composite = AlphaComposite.Src;
    private static GraphicsConfiguration configuration = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration();
    private static final Logger s_logger = Logger.getLogger(TileImageFactory.class.getName());
    private double m_scale = 1.0;
    private HashMap<String, ImageRef> m_imageCache = new HashMap();
    private ResourceLoader m_resourceLoader;

    public static boolean getShowReliefImages() {
        return s_showReliefImages;
    }

    public static boolean getShowMapBlends() {
        return s_showMapBlends;
    }

    public static String getShowMapBlendMode() {
        return s_showMapBlendMode.toUpperCase();
    }

    public static float getShowMapBlendAlpha() {
        return s_showMapBlendAlpha;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setScale(double newScale) {
        if (newScale > 1.0) {
            throw new IllegalArgumentException("Wrong scale");
        }
        Object object = this.m_mutex;
        synchronized (object) {
            this.m_scale = newScale;
            this.getM_imageCache().clear();
        }
    }

    public static void setShowReliefImages(boolean aBool) {
        s_showReliefImages = aBool;
        Preferences prefs = Preferences.userNodeForPackage(TileImageFactory.class);
        prefs.putBoolean(SHOW_RELIEF_IMAGES_PREFERENCE, s_showReliefImages);
        try {
            prefs.flush();
        }
        catch (BackingStoreException ex) {
            ex.printStackTrace();
        }
    }

    public static void setShowMapBlends(boolean aBool) {
        s_showMapBlends = aBool;
        Preferences prefs = Preferences.userNodeForPackage(TileImageFactory.class);
        prefs.putBoolean(SHOW_MAP_BLENDS_PREFERENCE, s_showMapBlends);
        try {
            prefs.flush();
        }
        catch (BackingStoreException ex) {
            ex.printStackTrace();
        }
    }

    public static void setShowMapBlendMode(String aString) {
        s_showMapBlendMode = aString;
        Preferences prefs = Preferences.userNodeForPackage(TileImageFactory.class);
        prefs.put(SHOW_MAP_BLEND_MODE, s_showMapBlendMode);
        try {
            prefs.flush();
        }
        catch (BackingStoreException ex) {
            ex.printStackTrace();
        }
    }

    public static void setShowMapBlendAlpha(float aFloat) {
        s_showMapBlendAlpha = aFloat;
        Preferences prefs = Preferences.userNodeForPackage(TileImageFactory.class);
        prefs.putFloat(SHOW_MAP_BLEND_ALPHA, s_showMapBlendAlpha);
        try {
            prefs.flush();
        }
        catch (BackingStoreException ex) {
            ex.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMapDir(ResourceLoader loader) {
        this.m_resourceLoader = loader;
        Object object = this.m_mutex;
        synchronized (object) {
            for (ImageRef imageRef : this.getM_imageCache().values()) {
                imageRef.clear();
            }
            this.getM_imageCache().clear();
        }
    }

    private Image isImageLoaded(String fileName) {
        if (this.getM_imageCache().get(fileName) == null) {
            return null;
        }
        return this.getM_imageCache().get(fileName).getImage();
    }

    public Image getBaseTile(int x, int y) {
        String fileName = this.getBaseTileImageName(x, y);
        if (this.m_resourceLoader.getResource(fileName) == null) {
            return null;
        }
        return this.getImage(fileName, false);
    }

    public Image getUnscaledUncachedBaseTile(int x, int y) {
        String fileName = this.getBaseTileImageName(x, y);
        URL url = this.m_resourceLoader.getResource(fileName);
        if (url == null) {
            return null;
        }
        return this.loadImage(url, fileName, false, false, false);
    }

    private String getBaseTileImageName(int x, int y) {
        String fileName = "baseTiles/" + x + "_" + y + ".png";
        return fileName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Image getImage(String fileName, boolean transparent) {
        Object object = this.m_mutex;
        synchronized (object) {
            Image rVal = this.isImageLoaded(fileName);
            if (rVal != null) {
                return rVal;
            }
            URL url = this.m_resourceLoader.getResource(fileName);
            if (!(s_showMapBlends && s_showReliefImages && transparent || url != null)) {
                return null;
            }
            this.loadImage(url, fileName, transparent, true, true);
        }
        return this.getImage(fileName, transparent);
    }

    public Image getReliefTile(int a, int b) {
        String fileName = this.getReliefTileImageName(a, b);
        return this.getImage(fileName, true);
    }

    public Image getUnscaledUncachedReliefTile(int x, int y) {
        String fileName = this.getReliefTileImageName(x, y);
        URL url = this.m_resourceLoader.getResource(fileName);
        if (url == null) {
            return null;
        }
        return this.loadImage(url, fileName, true, false, false);
    }

    private String getReliefTileImageName(int x, int y) {
        String fileName = "reliefTiles/" + x + "_" + y + ".png";
        return fileName;
    }

    private static BufferedImage makeMissingBaseTile(BufferedImage input, Color baseColor) {
        BufferedImage compatibleImage = configuration.createCompatibleImage(input.getWidth(null), input.getHeight(null), 3);
        Graphics2D g2 = compatibleImage.createGraphics();
        g2.fillRect(0, 0, input.getWidth(null), input.getHeight(null));
        g2.drawImage((Image)compatibleImage, 0, 0, null);
        g2.dispose();
        return compatibleImage;
    }

    private Image loadImage(URL imageLocation, String fileName, boolean transparent, boolean cache, boolean scale) {
        if (s_showMapBlends && s_showReliefImages && transparent) {
            return this.loadBlendedImage(imageLocation, fileName, transparent, cache, scale);
        }
        return this.loadUnblendedImage(imageLocation, fileName, transparent, cache, scale);
    }

    private Image loadBlendedImage(URL imageLocation, String fileName, boolean transparent, boolean cache, boolean scale) {
        BufferedImage reliefFile = null;
        BufferedImage baseFile = null;
        String reliefFileName = fileName.replace("baseTiles", "reliefTiles");
        URL urlrelief = this.m_resourceLoader.getResource(reliefFileName);
        String baseFileName = fileName.replace("reliefTiles", "baseTiles");
        URL urlBase = this.m_resourceLoader.getResource(baseFileName);
        String blankReliefFileName = "reliefTiles/blank_relief.png";
        URL urlBlankRelief = this.m_resourceLoader.getResource("reliefTiles/blank_relief.png");
        try {
            Stopwatch loadingImages = new Stopwatch(s_logger, Level.FINE, "Loading images:" + urlrelief + " and " + urlBase);
            if (urlrelief != null) {
                reliefFile = TileImageFactory.loadCompatibleImage(urlrelief);
            }
            if (urlBase != null) {
                baseFile = TileImageFactory.loadCompatibleImage(urlBase);
            }
            loadingImages.done();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        float alpha = TileImageFactory.getShowMapBlendAlpha();
        boolean overX = false;
        boolean overY = false;
        if (reliefFile == null) {
            try {
                reliefFile = TileImageFactory.loadCompatibleImage(urlBlankRelief);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        if (baseFile == null) {
            Color baseColor = null;
            baseColor = Color.white;
            baseFile = TileImageFactory.makeMissingBaseTile(reliefFile, baseColor);
        }
        if (reliefFile != null) {
            Graphics2D g2 = reliefFile.createGraphics();
            if (scale && this.m_scale != 1.0) {
                AffineTransform transform = new AffineTransform();
                transform.scale(this.m_scale, this.m_scale);
                g2.setTransform(transform);
            }
            g2.drawImage((Image)reliefFile, 0, 0, null);
            BlendComposite.BlendingMode blendMode = BlendComposite.BlendingMode.valueOf(TileImageFactory.getShowMapBlendMode());
            BlendComposite blendComposite = BlendComposite.getInstance(blendMode).derive(alpha);
            g2.setComposite(blendComposite);
            g2.drawImage((Image)baseFile, 0, 0, null);
            ImageRef ref = new ImageRef(reliefFile);
            if (cache) {
                this.getM_imageCache().put(fileName, ref);
            }
            return reliefFile;
        }
        ImageRef ref = new ImageRef(baseFile);
        if (cache) {
            this.getM_imageCache().put(fileName, ref);
        }
        return baseFile;
    }

    private Image loadUnblendedImage(URL imageLocation, String fileName, boolean transparent, boolean cache, boolean scale) {
        BufferedImage image;
        try {
            Stopwatch loadingImages = new Stopwatch(s_logger, Level.FINE, "Loading image:" + imageLocation);
            BufferedImage fromFile = ImageIO.read(imageLocation);
            loadingImages.done();
            Stopwatch copyingImage = new Stopwatch(s_logger, Level.FINE, "Copying image:" + imageLocation);
            image = Util.createImage(fromFile.getWidth(null), fromFile.getHeight(null), transparent);
            Graphics2D g = (Graphics2D)((Image)image).getGraphics();
            if (scale && this.m_scale != 1.0) {
                AffineTransform transform = new AffineTransform();
                transform.scale(this.m_scale, this.m_scale);
                g.setTransform(transform);
            }
            g.drawImage((Image)fromFile, 0, 0, null);
            g.dispose();
            fromFile.flush();
            copyingImage.done();
        }
        catch (IOException e) {
            throw new IllegalStateException(e.getMessage());
        }
        ImageRef ref = new ImageRef(image);
        if (cache) {
            this.getM_imageCache().put(fileName, ref);
        }
        return image;
    }

    public Composite getComposite() {
        return this.composite;
    }

    public static BufferedImage loadCompatibleImage(URL resource) throws IOException {
        BufferedImage image = ImageIO.read(resource);
        return TileImageFactory.toCompatibleImage(image);
    }

    public static BufferedImage toCompatibleImage(BufferedImage image) {
        BufferedImage compatibleImage = configuration.createCompatibleImage(image.getWidth(), image.getHeight(), 3);
        Graphics g = compatibleImage.getGraphics();
        g.drawImage(image, 0, 0, null);
        g.dispose();
        return compatibleImage;
    }

    public static BufferedImage createCompatibleImage(int width, int height) {
        return configuration.createCompatibleImage(width, height);
    }

    public void setM_imageCache(HashMap<String, ImageRef> m_imageCache) {
        this.m_imageCache = m_imageCache;
    }

    public HashMap<String, ImageRef> getM_imageCache() {
        return this.m_imageCache;
    }

    static {
        Preferences prefs = Preferences.userNodeForPackage(TileImageFactory.class);
        s_showReliefImages = prefs.getBoolean(SHOW_RELIEF_IMAGES_PREFERENCE, true);
        s_showMapBlends = prefs.getBoolean(SHOW_MAP_BLENDS_PREFERENCE, false);
        s_showMapBlendMode = prefs.get(SHOW_MAP_BLEND_MODE, "normal");
        s_showMapBlendAlpha = prefs.getFloat(SHOW_MAP_BLEND_ALPHA, 1.0f);
    }
}

