/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.triplea.oddsCalculator.ta;

import games.strategy.engine.data.ChangeFactory;
import games.strategy.engine.data.ChangePerformer;
import games.strategy.engine.data.CompositeChange;
import games.strategy.engine.data.GameData;
import games.strategy.engine.data.PlayerID;
import games.strategy.engine.data.Territory;
import games.strategy.engine.data.TerritoryEffect;
import games.strategy.engine.data.Unit;
import games.strategy.engine.framework.GameDataUtils;
import games.strategy.triplea.delegate.BattleCalculator;
import games.strategy.triplea.delegate.BattleTracker;
import games.strategy.triplea.delegate.MustFightBattle;
import games.strategy.triplea.delegate.TripleADelegateBridge;
import games.strategy.triplea.oddsCalculator.ta.AggregateResults;
import games.strategy.triplea.oddsCalculator.ta.BattleResults;
import games.strategy.triplea.oddsCalculator.ta.DummyDelegateBridge;
import java.util.ArrayList;
import java.util.Collection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OddsCalculator {
    private PlayerID m_attacker;
    private PlayerID m_defender;
    private GameData m_data;
    private Territory m_location;
    private Collection<Unit> m_attackingUnits = new ArrayList<Unit>();
    private Collection<Unit> m_defendingUnits = new ArrayList<Unit>();
    private Collection<Unit> m_bombardingUnits = new ArrayList<Unit>();
    private Collection<TerritoryEffect> m_territoryEffects = new ArrayList<TerritoryEffect>();
    private boolean m_keepOneAttackingLandUnit = false;
    private boolean m_amphibious = false;
    private volatile boolean m_cancelled = false;

    public AggregateResults calculate(GameData data, PlayerID attacker, PlayerID defender, Territory location, Collection<Unit> attacking, Collection<Unit> defending, Collection<Unit> bombarding, Collection<TerritoryEffect> territoryEffects, int runCount) {
        this.m_data = GameDataUtils.cloneGameData(data, false);
        this.m_attacker = this.m_data.getPlayerList().getPlayerID(attacker.getName());
        this.m_defender = this.m_data.getPlayerList().getPlayerID(defender.getName());
        this.m_location = this.m_data.getMap().getTerritory(location.getName());
        this.m_territoryEffects = territoryEffects;
        this.m_attackingUnits = (Collection)GameDataUtils.translateIntoOtherGameData(attacking, this.m_data);
        this.m_defendingUnits = (Collection)GameDataUtils.translateIntoOtherGameData(defending, this.m_data);
        this.m_bombardingUnits = (Collection)GameDataUtils.translateIntoOtherGameData(bombarding, this.m_data);
        ChangePerformer changePerformer = new ChangePerformer(this.m_data);
        changePerformer.perform(ChangeFactory.removeUnits(this.m_location, this.m_location.getUnits().getUnits()));
        changePerformer.perform(ChangeFactory.addUnits(this.m_location, this.m_attackingUnits));
        changePerformer.perform(ChangeFactory.addUnits(this.m_location, this.m_defendingUnits));
        return this.calculate(runCount);
    }

    public void setKeepOneAttackingLandUnit(boolean aBool) {
        this.m_keepOneAttackingLandUnit = aBool;
    }

    public void setAmphibious(boolean aBool) {
        this.m_amphibious = aBool;
    }

    private AggregateResults calculate(int count) {
        long start = System.currentTimeMillis();
        AggregateResults rVal = new AggregateResults(count);
        BattleTracker battleTracker = new BattleTracker();
        BattleCalculator.EnableCasualtySortingCaching();
        for (int i = 0; i < count && !this.m_cancelled; ++i) {
            CompositeChange allChanges = new CompositeChange();
            DummyDelegateBridge bridge1 = new DummyDelegateBridge(this.m_attacker, this.m_data, allChanges, this.m_keepOneAttackingLandUnit);
            TripleADelegateBridge bridge = new TripleADelegateBridge(bridge1);
            MustFightBattle battle = new MustFightBattle(this.m_location, this.m_attacker, this.m_data, battleTracker);
            battle.setHeadless(true);
            battle.isAmphibious();
            battle.setUnits(this.m_defendingUnits, this.m_attackingUnits, this.m_bombardingUnits, this.m_amphibious ? this.m_attackingUnits : new ArrayList<Unit>(), this.m_defender, this.m_territoryEffects);
            battle.fight(bridge);
            rVal.addResult(new BattleResults(battle, this.m_data));
            new ChangePerformer(this.m_data).perform(allChanges.invert());
            battleTracker.clear();
            battleTracker.clearBattleRecords();
        }
        BattleCalculator.DisableCasualtySortingCaching();
        rVal.setTime(System.currentTimeMillis() - start);
        return rVal;
    }

    public void cancel() {
        this.m_cancelled = true;
    }
}

