/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.triplea.oddsCalculator.ta;

import games.strategy.engine.data.GameData;
import games.strategy.engine.data.PlayerID;
import games.strategy.engine.data.Territory;
import games.strategy.engine.data.TerritoryEffect;
import games.strategy.engine.data.Unit;
import games.strategy.engine.framework.ui.background.WaitDialog;
import games.strategy.triplea.Properties;
import games.strategy.triplea.delegate.Matches;
import games.strategy.triplea.delegate.TerritoryEffectHelper;
import games.strategy.triplea.oddsCalculator.ta.AggregateResults;
import games.strategy.triplea.oddsCalculator.ta.OddsCalculator;
import games.strategy.triplea.oddsCalculator.ta.PlayerUnitsPanel;
import games.strategy.triplea.ui.UIContext;
import games.strategy.ui.IntTextField;
import games.strategy.util.Match;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;
import java.util.concurrent.atomic.AtomicReference;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.DefaultListCellRenderer;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OddsCalculatorPanel
extends JPanel {
    private static final long serialVersionUID = -3559687618320469183L;
    private final Window m_parent;
    private JLabel m_attackerWin;
    private JLabel m_defenderWin;
    private JLabel m_draw;
    private JLabel m_defenderLeft;
    private JLabel m_attackerLeft;
    private JLabel m_count;
    private final UIContext m_context;
    private final GameData m_data;
    private JLabel m_numRunsLabel;
    private IntTextField m_numRuns;
    private JPanel m_resultsPanel;
    private JButton m_calculateButton;
    private JButton m_closeButton;
    private JButton m_SwapSidesButton;
    private PlayerUnitsPanel m_attackingUnitsPanel;
    private PlayerUnitsPanel m_defendingUnitsPanel;
    private JComboBox m_attackerCombo;
    private JComboBox m_defenderCombo;
    private JComboBox m_SwapSidesCombo;
    private JCheckBox m_keepOneAttackingLandUnitCombo;
    private JCheckBox m_amphibiousCombo;
    private JCheckBox m_landBattle;
    private JButton m_clearButton;
    private JLabel m_time;
    private Territory m_location = null;
    private JList m_territoryEffectsJList;
    private static final String NO_EFFECTS = "*None*";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OddsCalculatorPanel(GameData data, UIContext context, Territory location, Window parent) {
        this.m_data = data;
        this.m_context = context;
        this.m_location = location;
        this.createComponents();
        this.layoutComponents();
        this.setupListeners();
        this.m_parent = parent;
        if (location != null) {
            this.m_data.acquireReadLock();
            try {
                this.m_landBattle.setSelected(!location.isWater());
                if (this.m_data.getSequence().getStep().getPlayerID() != null && !this.m_data.getSequence().getStep().getPlayerID().isNull()) {
                    this.m_attackerCombo.setSelectedItem(this.m_data.getSequence().getStep().getPlayerID());
                }
                if (!location.isWater()) {
                    this.m_defenderCombo.setSelectedItem(location.getOwner());
                } else {
                    for (PlayerID player : location.getUnits().getPlayersWithUnits()) {
                        if (player == this.getAttacker() || this.m_data.getRelationshipTracker().isAllied(player, this.getAttacker())) continue;
                        this.m_defenderCombo.setSelectedItem(player);
                        break;
                    }
                }
                this.updateDefender(location.getUnits().getMatches(Matches.alliedUnit(this.getDefender(), data)));
                this.updateAttacker(location.getUnits().getMatches(Matches.alliedUnit(this.getAttacker(), data)));
            }
            finally {
                this.m_data.releaseReadLock();
            }
        } else {
            this.m_landBattle.setSelected(true);
            this.m_defenderCombo.setSelectedItem(data.getPlayerList().getPlayers().iterator().next());
            this.updateDefender(null);
            this.updateAttacker(null);
        }
        this.setWidgetActivation();
    }

    private PlayerID getDefender() {
        return (PlayerID)this.m_defenderCombo.getSelectedItem();
    }

    private PlayerID getAttacker() {
        return (PlayerID)this.m_attackerCombo.getSelectedItem();
    }

    private PlayerID getSwapSides() {
        return (PlayerID)this.m_SwapSidesCombo.getSelectedItem();
    }

    private void setupListeners() {
        this.m_defenderCombo.addActionListener(new ActionListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void actionPerformed(ActionEvent e) {
                OddsCalculatorPanel.this.m_data.acquireReadLock();
                try {
                    if (OddsCalculatorPanel.this.m_data.getRelationshipTracker().isAllied(OddsCalculatorPanel.this.getDefender(), OddsCalculatorPanel.this.getAttacker())) {
                        OddsCalculatorPanel.this.m_attackerCombo.setSelectedItem(OddsCalculatorPanel.this.getEnemy(OddsCalculatorPanel.this.getDefender()));
                    }
                }
                finally {
                    OddsCalculatorPanel.this.m_data.releaseReadLock();
                }
                OddsCalculatorPanel.this.updateDefender(null);
            }
        });
        this.m_attackerCombo.addActionListener(new ActionListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void actionPerformed(ActionEvent e) {
                OddsCalculatorPanel.this.m_data.acquireReadLock();
                try {
                    if (OddsCalculatorPanel.this.m_data.getRelationshipTracker().isAllied(OddsCalculatorPanel.this.getDefender(), OddsCalculatorPanel.this.getAttacker())) {
                        OddsCalculatorPanel.this.m_defenderCombo.setSelectedItem(OddsCalculatorPanel.this.getEnemy(OddsCalculatorPanel.this.getAttacker()));
                    }
                }
                finally {
                    OddsCalculatorPanel.this.m_data.releaseReadLock();
                }
                OddsCalculatorPanel.this.updateAttacker(null);
            }
        });
        this.m_landBattle.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                OddsCalculatorPanel.this.updateDefender(null);
                OddsCalculatorPanel.this.updateAttacker(null);
                OddsCalculatorPanel.this.setWidgetActivation();
            }
        });
        this.m_calculateButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                OddsCalculatorPanel.this.updateStats();
            }
        });
        this.m_closeButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                OddsCalculatorPanel.this.m_parent.setVisible(false);
            }
        });
        this.m_clearButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                OddsCalculatorPanel.this.m_defendingUnitsPanel.clear();
                OddsCalculatorPanel.this.m_attackingUnitsPanel.clear();
            }
        });
        this.m_SwapSidesButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ArrayList<Unit> getdefenders = new ArrayList();
                ArrayList<Unit> getattackers = new ArrayList();
                getdefenders = OddsCalculatorPanel.this.m_defendingUnitsPanel.getUnits();
                getattackers = OddsCalculatorPanel.this.m_attackingUnitsPanel.getUnits();
                OddsCalculatorPanel.this.m_SwapSidesCombo.setSelectedItem(OddsCalculatorPanel.this.getAttacker());
                OddsCalculatorPanel.this.m_attackerCombo.setSelectedItem(OddsCalculatorPanel.this.getDefender());
                OddsCalculatorPanel.this.m_defenderCombo.setSelectedItem(OddsCalculatorPanel.this.getSwapSides());
                OddsCalculatorPanel.this.m_attackingUnitsPanel.init(OddsCalculatorPanel.this.getAttacker(), getdefenders, OddsCalculatorPanel.this.isLand());
                OddsCalculatorPanel.this.m_defendingUnitsPanel.init(OddsCalculatorPanel.this.getDefender(), getattackers, OddsCalculatorPanel.this.isLand());
            }
        });
    }

    private void updateStats() {
        if (!SwingUtilities.isEventDispatchThread()) {
            throw new IllegalStateException("Wrong thread");
        }
        final AtomicReference results = new AtomicReference();
        final OddsCalculator calculator = new OddsCalculator();
        final WaitDialog dialog = new WaitDialog(this, "Calculating Odds", new AbstractAction(){
            private static final long serialVersionUID = -2148507015083214974L;

            public void actionPerformed(ActionEvent e) {
                calculator.cancel();
            }
        });
        dialog.pack();
        dialog.setLocationRelativeTo(this);
        Thread calcThread = new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                try {
                    Territory location = null;
                    if (OddsCalculatorPanel.this.m_location == null || OddsCalculatorPanel.this.m_location.isWater() == OddsCalculatorPanel.this.isLand()) {
                        for (Territory t : OddsCalculatorPanel.this.m_data.getMap()) {
                            if (t.isWater() != !OddsCalculatorPanel.this.isLand()) continue;
                            location = t;
                            break;
                        }
                    } else {
                        location = OddsCalculatorPanel.this.m_location;
                    }
                    if (location == null) {
                        throw new IllegalStateException("No territory found that is land:" + OddsCalculatorPanel.this.isLand());
                    }
                    List<Unit> defending = OddsCalculatorPanel.this.m_defendingUnitsPanel.getUnits();
                    List<Unit> attacking = OddsCalculatorPanel.this.m_attackingUnitsPanel.getUnits();
                    ArrayList<Unit> bombarding = new ArrayList();
                    if (OddsCalculatorPanel.this.isLand()) {
                        bombarding = Match.getMatches(attacking, Matches.unitCanBombard(OddsCalculatorPanel.this.getAttacker()));
                        attacking.removeAll(bombarding);
                    }
                    if (OddsCalculatorPanel.this.m_landBattle.isSelected() && OddsCalculatorPanel.this.m_keepOneAttackingLandUnitCombo.isSelected()) {
                        calculator.setKeepOneAttackingLandUnit(true);
                    } else {
                        calculator.setKeepOneAttackingLandUnit(false);
                    }
                    if (OddsCalculatorPanel.this.m_landBattle.isSelected() && OddsCalculatorPanel.this.m_amphibiousCombo.isSelected()) {
                        calculator.setAmphibious(true);
                    } else {
                        calculator.setAmphibious(false);
                    }
                    ArrayList<TerritoryEffect> territoryEffects = new ArrayList<TerritoryEffect>();
                    if (OddsCalculatorPanel.this.m_territoryEffectsJList != null) {
                        List<Object> selectedObjects = Arrays.asList(OddsCalculatorPanel.this.m_territoryEffectsJList.getSelectedValues());
                        ArrayList<String> selected = new ArrayList<String>();
                        for (Object obj : selectedObjects) {
                            selected.add((String)obj);
                        }
                        OddsCalculatorPanel.this.m_data.acquireReadLock();
                        try {
                            Hashtable<String, TerritoryEffect> allTerritoryEffects = OddsCalculatorPanel.this.m_data.getTerritoryEffectList();
                            for (String selection : selected) {
                                if (selection.equals(OddsCalculatorPanel.NO_EFFECTS)) {
                                    territoryEffects.clear();
                                    break;
                                }
                                territoryEffects.add(allTerritoryEffects.get(selection));
                            }
                        }
                        finally {
                            OddsCalculatorPanel.this.m_data.releaseReadLock();
                        }
                    }
                    results.set(calculator.calculate(OddsCalculatorPanel.this.m_data, OddsCalculatorPanel.this.getAttacker(), OddsCalculatorPanel.this.getDefender(), location, attacking, defending, bombarding, territoryEffects, OddsCalculatorPanel.this.m_numRuns.getValue()));
                }
                catch (Throwable throwable) {
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            dialog.setVisible(false);
                            dialog.dispose();
                        }
                    });
                    throw throwable;
                }
                SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
            }
        }, "Odds calc thread");
        calcThread.start();
        dialog.setVisible(true);
        this.m_attackerWin.setText(this.formatPercentage(((AggregateResults)results.get()).getAttackerWinPercent()));
        this.m_defenderWin.setText(this.formatPercentage(((AggregateResults)results.get()).getDefenderWinPercent()));
        this.m_draw.setText(this.formatPercentage(((AggregateResults)results.get()).getDrawPercent()));
        this.m_defenderLeft.setText(this.formatValue(((AggregateResults)results.get()).getAverageDefendingUnitsLeft()));
        this.m_attackerLeft.setText(this.formatValue(((AggregateResults)results.get()).getAverageAttackingUnitsLeft()));
        this.m_count.setText(((AggregateResults)results.get()).getRollCount() + "");
        this.m_time.setText(this.formatValue((double)((AggregateResults)results.get()).getTime() / 1000.0) + "s");
    }

    public String formatPercentage(double percentage) {
        DecimalFormat format = new DecimalFormat("%");
        return format.format(percentage);
    }

    public String formatValue(double value) {
        DecimalFormat format = new DecimalFormat("#0.##");
        return format.format(value);
    }

    private void updateDefender(List<Unit> units) {
        if (units == null) {
            units = Collections.emptyList();
        }
        units = Match.getMatches(units, Matches.UnitCanBeInBattle(false, this.m_data, false, false));
        this.m_defendingUnitsPanel.init(this.getDefender(), units, this.isLand());
    }

    private void updateAttacker(List<Unit> units) {
        if (units == null) {
            units = Collections.emptyList();
        }
        units = Match.getMatches(units, Matches.UnitCanBeInBattle(true, this.m_data, false, false));
        this.m_attackingUnitsPanel.init(this.getAttacker(), units, this.isLand());
    }

    private boolean isLand() {
        return this.m_landBattle.isSelected();
    }

    private PlayerID getEnemy(PlayerID player) {
        for (PlayerID id : this.m_data.getPlayerList()) {
            if (!this.m_data.getRelationshipTracker().isAtWar(player, id)) continue;
            return id;
        }
        for (PlayerID id : this.m_data.getPlayerList()) {
            if (this.m_data.getRelationshipTracker().isAllied(player, id)) continue;
            return id;
        }
        throw new IllegalStateException("No enemies or non-allies for :" + player);
    }

    private void layoutComponents() {
        this.setLayout(new BorderLayout());
        JPanel main = new JPanel();
        main.setBorder(BorderFactory.createEmptyBorder(10, 0, 10, 0));
        this.add((Component)main, "Center");
        main.setLayout(new BorderLayout());
        JPanel attackAndDefend = new JPanel();
        attackAndDefend.setLayout(new GridBagLayout());
        int gap = 20;
        attackAndDefend.add((Component)new JLabel("Attacker: "), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 20, 20, 0), 0, 0));
        attackAndDefend.add((Component)this.m_attackerCombo, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 20, 20), 0, 0));
        attackAndDefend.add((Component)new JLabel("Defender: "), new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 20, 20, 0), 0, 0));
        attackAndDefend.add((Component)this.m_defenderCombo, new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 20, 20), 0, 0));
        JScrollPane attackerScroll = new JScrollPane(this.m_attackingUnitsPanel);
        attackerScroll.setBorder(null);
        attackerScroll.getViewport().setBorder(null);
        JScrollPane defenderScroll = new JScrollPane(this.m_defendingUnitsPanel);
        defenderScroll.setBorder(null);
        defenderScroll.getViewport().setBorder(null);
        attackAndDefend.add((Component)attackerScroll, new GridBagConstraints(0, 1, 2, 1, 1.0, 1.0, 11, 1, new Insets(10, 20, 20, 20), 0, 0));
        attackAndDefend.add((Component)defenderScroll, new GridBagConstraints(2, 1, 2, 1, 1.0, 1.0, 11, 1, new Insets(10, 20, 20, 20), 0, 0));
        main.add((Component)attackAndDefend, "Center");
        JPanel resultsText = new JPanel();
        resultsText.setLayout(new GridBagLayout());
        resultsText.add((Component)new JLabel("Attacker Wins:"), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 0), 0, 0));
        resultsText.add((Component)new JLabel("Draw:"), new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 0), 0, 0));
        resultsText.add((Component)new JLabel("Defender Wins:"), new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 0), 0, 0));
        resultsText.add((Component)new JLabel("Defender Units Left:"), new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 0), 0, 0));
        resultsText.add((Component)new JLabel("Attacker Units Left:"), new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 0), 0, 0));
        resultsText.add((Component)new JLabel("Simulation Count:"), new GridBagConstraints(0, 5, 1, 1, 0.0, 0.0, 13, 0, new Insets(15, 0, 0, 0), 0, 0));
        resultsText.add((Component)new JLabel("Time:"), new GridBagConstraints(0, 6, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 0), 0, 0));
        resultsText.add((Component)this.m_attackerWin, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 5, 0, 0), 0, 0));
        resultsText.add((Component)this.m_draw, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 5, 0, 0), 0, 0));
        resultsText.add((Component)this.m_defenderWin, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 5, 0, 0), 0, 0));
        resultsText.add((Component)this.m_defenderLeft, new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 5, 0, 0), 0, 0));
        resultsText.add((Component)this.m_attackerLeft, new GridBagConstraints(1, 4, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 5, 0, 0), 0, 0));
        resultsText.add((Component)this.m_count, new GridBagConstraints(1, 5, 1, 1, 0.0, 0.0, 13, 0, new Insets(15, 5, 0, 0), 0, 0));
        resultsText.add((Component)this.m_time, new GridBagConstraints(1, 6, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 5, 0, 0), 0, 0));
        resultsText.add((Component)this.m_numRunsLabel, new GridBagConstraints(0, 7, 1, 1, 0.0, 0.0, 13, 0, new Insets(35, 0, 0, 0), 0, 0));
        resultsText.add((Component)this.m_numRuns, new GridBagConstraints(1, 7, 1, 1, 0.0, 0.0, 13, 0, new Insets(35, 5, 0, 0), 0, 0));
        int row = 8;
        resultsText.add((Component)this.m_keepOneAttackingLandUnitCombo, new GridBagConstraints(0, row++, 2, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
        resultsText.add((Component)this.m_amphibiousCombo, new GridBagConstraints(0, row++, 2, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
        resultsText.add((Component)this.m_landBattle, new GridBagConstraints(0, row++, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 5, 5, 5), 0, 0));
        if (this.m_territoryEffectsJList != null) {
            resultsText.add((Component)new JScrollPane(this.m_territoryEffectsJList), new GridBagConstraints(0, row++, 2, 1, 0.0, 0.0, 13, 0, new Insets(10, 5, 5, 5), 0, 0));
        }
        resultsText.add((Component)this.m_clearButton, new GridBagConstraints(0, row++, 2, 1, 0.0, 0.0, 13, 0, new Insets(25, 5, 5, 5), 0, 0));
        resultsText.add((Component)this.m_calculateButton, new GridBagConstraints(0, row++, 2, 1, 0.0, 0.0, 13, 0, new Insets(25, 5, 5, 5), 0, 0));
        resultsText.add((Component)this.m_SwapSidesButton, new GridBagConstraints(0, row++, 2, 1, 0.0, 0.0, 13, 0, new Insets(25, 5, 5, 5), 0, 0));
        this.m_resultsPanel.add(resultsText);
        main.add((Component)this.m_resultsPanel, "East");
        JPanel south = new JPanel();
        south.setLayout(new BorderLayout());
        JPanel buttons = new JPanel();
        buttons.setLayout(new FlowLayout(1));
        buttons.add(this.m_closeButton);
        south.add((Component)buttons, "South");
        this.add((Component)south, "South");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createComponents() {
        this.m_data.acquireReadLock();
        try {
            ArrayList<PlayerID> playerList = new ArrayList<PlayerID>(this.m_data.getPlayerList().getPlayers());
            if (OddsCalculatorPanel.doesPlayerHaveUnitsOnMap(PlayerID.NULL_PLAYERID, this.m_data)) {
                playerList.add(PlayerID.NULL_PLAYERID);
            }
            this.m_attackerCombo = new JComboBox<PlayerID>(new Vector<PlayerID>(playerList));
            this.m_defenderCombo = new JComboBox<PlayerID>(new Vector<PlayerID>(playerList));
            this.m_SwapSidesCombo = new JComboBox<PlayerID>(new Vector<PlayerID>(playerList));
            Hashtable<String, TerritoryEffect> allTerritoryEffects = this.m_data.getTerritoryEffectList();
            if (allTerritoryEffects == null || allTerritoryEffects.isEmpty()) {
                this.m_territoryEffectsJList = null;
            } else {
                Collection<TerritoryEffect> currentEffects;
                Vector<String> effectNames = new Vector<String>();
                effectNames.add(NO_EFFECTS);
                effectNames.addAll(allTerritoryEffects.keySet());
                this.m_territoryEffectsJList = new JList(effectNames);
                this.m_territoryEffectsJList.setSelectionMode(2);
                this.m_territoryEffectsJList.setLayoutOrientation(0);
                this.m_territoryEffectsJList.setVisibleRowCount(3);
                if (this.m_location != null && !(currentEffects = TerritoryEffectHelper.getEffects(this.m_location)).isEmpty()) {
                    int[] selectedIndexes = new int[currentEffects.size()];
                    int currentIndex = 0;
                    for (TerritoryEffect te : currentEffects) {
                        selectedIndexes[currentIndex] = effectNames.indexOf(te.getName());
                        ++currentIndex;
                    }
                    this.m_territoryEffectsJList.setSelectedIndices(selectedIndexes);
                }
            }
        }
        finally {
            this.m_data.releaseReadLock();
        }
        this.m_defenderCombo.setRenderer(new PlayerRenderer());
        this.m_attackerCombo.setRenderer(new PlayerRenderer());
        this.m_SwapSidesCombo.setRenderer(new PlayerRenderer());
        this.m_defendingUnitsPanel = new PlayerUnitsPanel(this.m_data, this.m_context, true);
        this.m_attackingUnitsPanel = new PlayerUnitsPanel(this.m_data, this.m_context, false);
        this.m_landBattle = new JCheckBox("Land Battle");
        this.m_numRunsLabel = new JLabel("Run Count:");
        this.m_numRuns = new IntTextField();
        this.m_numRuns.setColumns(4);
        this.m_numRuns.setMin(1);
        this.m_numRuns.setMax(20000);
        this.m_numRuns.setValue(Properties.getLow_Luck(this.m_data) ? 500 : 2000);
        this.m_calculateButton = new JButton("Calculate Odds");
        this.m_resultsPanel = new JPanel();
        String blank = "------";
        this.m_attackerWin = new JLabel("------");
        this.m_defenderWin = new JLabel("------");
        this.m_draw = new JLabel("------");
        this.m_defenderLeft = new JLabel("------");
        this.m_attackerLeft = new JLabel("------");
        this.m_count = new JLabel("------");
        this.m_time = new JLabel("------");
        this.m_closeButton = new JButton("Close");
        this.m_clearButton = new JButton("Clear");
        this.m_SwapSidesButton = new JButton("Swap Sides");
        this.m_keepOneAttackingLandUnitCombo = new JCheckBox("One attacking land must live");
        this.m_amphibiousCombo = new JCheckBox("Battle is Amphibious");
    }

    public void setWidgetActivation() {
        this.m_keepOneAttackingLandUnitCombo.setEnabled(this.m_landBattle.isSelected());
        this.m_amphibiousCombo.setEnabled(this.m_landBattle.isSelected());
    }

    public void selectCalculateButton() {
        this.m_calculateButton.requestFocus();
    }

    private static boolean doesPlayerHaveUnitsOnMap(PlayerID player, GameData data) {
        for (Territory t : data.getMap()) {
            for (Unit u : t.getUnits()) {
                if (!u.getOwner().equals(player)) continue;
                return true;
            }
        }
        return false;
    }

    class PlayerRenderer
    extends DefaultListCellRenderer {
        private static final long serialVersionUID = -7639128794342607309L;

        PlayerRenderer() {
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            PlayerID id = (PlayerID)value;
            this.setText(id.getName());
            this.setIcon(new ImageIcon(OddsCalculatorPanel.this.m_context.getFlagImageFactory().getSmallFlag(id)));
            return this;
        }
    }
}

