/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.triplea.oddsCalculator.zengland;

import games.strategy.engine.data.GameData;
import games.strategy.engine.data.PlayerID;
import games.strategy.engine.data.Territory;
import games.strategy.engine.data.Unit;
import games.strategy.triplea.Properties;
import games.strategy.triplea.attatchments.UnitAttachment;
import games.strategy.triplea.oddsCalculator.zengland.OCUnit;
import games.strategy.triplea.oddsCalculator.zengland.UnitGroup;
import games.strategy.triplea.util.UnitCategory;
import games.strategy.triplea.util.UnitSeperator;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OCBattle {
    public static final int TAKEN = 1;
    public static final String TAKENSTRING = "Taken";
    public static final int DEFENDED = 2;
    public static final String DEFENDEDSTRING = "Defended";
    public static final int CLEARED = 3;
    public static final String CLEAREDSTRING = "Cleared";
    public static final int INDECISIVE = 4;
    public static final String INDECISIVESTRING = "Indecisive";
    public static final int CLEAREDAIR = 5;
    public static final String CLEAREDAIRSTRING = "Cleared with air";
    private Vector<UnitGroup> attackers;
    private Vector<UnitGroup> defenders;
    private int rounds;
    private boolean preserveLand;
    private boolean aaPresent;
    private boolean landBattle;
    private Vector<String> attOOL = null;
    private Vector<String> defOOL = null;
    private int resultStatus = 4;
    private String resultStatusString = "Indecisive";
    private boolean rollAntiAirSep;
    private boolean isAmphib;
    private int battles = 0;
    private float controlPercent = 0.0f;
    private int controleds = 0;
    private float airWinPercent = 0.0f;
    private int airWins = 0;
    private float clearedPercent = 0.0f;
    private int cleareds = 0;
    private float indecisivePercent = 0.0f;
    private int indecisives = 0;
    private float lossPercent = 0.0f;
    private int losses = 0;
    private Vector<UnitGroup> locAttackers = new Vector();
    private Vector<UnitGroup> locDefenders = new Vector();
    private long remAtts = 0L;
    private int avgRemAtts = 0;
    private long remDefs = 0L;
    private int avgRemDefs = 0;

    public float getAirWinPercent() {
        return this.airWinPercent;
    }

    public int getAirWins() {
        return this.airWins;
    }

    public int getBattles() {
        return this.battles;
    }

    public float getClearedPercent() {
        return this.clearedPercent;
    }

    public int getCleareds() {
        return this.cleareds;
    }

    public int getControleds() {
        return this.controleds;
    }

    public float getControlPercent() {
        return this.controlPercent;
    }

    public float getIndecisivePercent() {
        return this.indecisivePercent;
    }

    public int getIndecisives() {
        return this.indecisives;
    }

    public int getLosses() {
        return this.losses;
    }

    public float getLossPercent() {
        return this.lossPercent;
    }

    private boolean isWW2V2(GameData data) {
        return Properties.getWW2V2(data);
    }

    public OCBattle(Vector<UnitGroup> attackers, Vector<UnitGroup> defenders, int rounds, boolean preserveLand, boolean aaPresent, boolean landBattle, boolean rollAntiAirSep, boolean isAmphib, Vector<String> ool) {
        this.setAttackers(attackers);
        this.setDefenders(defenders);
        this.rounds = rounds;
        this.preserveLand = preserveLand;
        this.aaPresent = aaPresent;
        this.landBattle = landBattle;
        this.rollAntiAirSep = rollAntiAirSep;
        this.attOOL = ool;
        this.defOOL = ool;
        this.setAmphib(isAmphib);
    }

    public OCBattle(Territory territory, GameData m_data) {
        Vector<UnitGroup> terrAttackers = new Vector<UnitGroup>(0);
        Vector<UnitGroup> terrDefenders = new Vector<UnitGroup>(0);
        boolean terrRounds = false;
        boolean terrPreserveLand = true;
        boolean terrAAPresent = false;
        boolean terrLandBattle = true;
        if (territory.isWater()) {
            terrLandBattle = false;
        }
        boolean terrRollAntiAirSep = false;
        boolean isAmphib = false;
        terrRollAntiAirSep = this.isWW2V2(m_data);
        Set<UnitCategory> units = UnitSeperator.categorize(territory.getUnits().getUnits());
        Iterator<UnitCategory> iter = units.iterator();
        PlayerID currentPlayer = null;
        while (iter.hasNext()) {
            UnitCategory item = iter.next();
            if (item.getOwner() != currentPlayer) {
                currentPlayer = item.getOwner();
            }
            List<Unit> unitList = item.getUnits();
            int numUnits = item.getUnits().size();
            Iterator<Unit> unitIterator = unitList.iterator();
            int unitCost = 3;
            int attackValue = 1;
            int defendValue = 2;
            int moveValue = 1;
            String name = "Infantry";
            boolean noRetal = false;
            int unitType = 1;
            boolean supportShot = false;
            boolean canHitAir = true;
            int maxHits = 1;
            int maxRolls = 1;
            int maxHp = 1;
            boolean blocksNoRetHit = false;
            boolean boostsInfAtt = false;
            boolean boostAmphib = false;
            UnitAttachment ua = null;
            while (unitIterator.hasNext()) {
                Unit current = unitIterator.next();
                ua = UnitAttachment.get(current.getType());
                attackValue = ua.getAttack(currentPlayer);
                defendValue = ua.getDefense(currentPlayer);
                moveValue = ua.getMovement(currentPlayer);
                name = current.getType().getName();
                noRetal = ua.getIsSub();
                unitType = ua.getIsAir() ? 2 : (ua.getIsAAforCombatOnly() ? 4 : (ua.getIsSea() ? 3 : 1));
                supportShot = ua.getCanBombard(currentPlayer);
                canHitAir = !ua.getIsSub();
                maxHits = ua.getAttackRolls(currentPlayer);
                maxRolls = 1;
                maxHp = ua.getIsTwoHit() ? 2 : 1;
                blocksNoRetHit = ua.getIsDestroyer() && this.isWW2V2(m_data);
                boostsInfAtt = ua.getArtillery();
                boostAmphib = ua.getIsMarine();
            }
            if (ua != null && ua.getIsAAforCombatOnly()) {
                terrAAPresent = true;
                continue;
            }
            OCUnit currUnit = new OCUnit(3, attackValue, defendValue, moveValue, name, noRetal, unitType, supportShot, canHitAir, maxHits, maxRolls, maxHp, blocksNoRetHit, boostsInfAtt, boostAmphib);
            UnitGroup currUnitGroup = new UnitGroup(currUnit, numUnits);
            PlayerID playerID = m_data.getSequence().getStep().getPlayerID();
            System.out.println(item);
            System.out.println(playerID);
            if (playerID != null && playerID.equals(item.getOwner())) {
                terrAttackers.add(currUnitGroup);
                continue;
            }
            terrDefenders.add(currUnitGroup);
        }
        this.setAttackers(terrAttackers);
        this.setDefenders(terrDefenders);
        this.rounds = 0;
        this.preserveLand = true;
        this.aaPresent = terrAAPresent;
        this.landBattle = terrLandBattle;
        this.rollAntiAirSep = terrRollAntiAirSep;
        this.attOOL = null;
        this.defOOL = null;
        this.setAmphib(false);
    }

    public boolean isAaPresent() {
        return this.aaPresent;
    }

    public void setAaPresent(boolean aaPresent) {
        this.aaPresent = aaPresent;
    }

    public Vector<UnitGroup> getAttackers() {
        return this.attackers;
    }

    public void setAttackers(Vector<UnitGroup> attackers) {
        this.attackers = attackers;
        int size = this.attackers.size();
        for (int i = size - 1; i >= 0; --i) {
            int curSize = this.attackers.elementAt(i).getNumUnits();
            if (curSize > 0) continue;
            this.attackers.removeElementAt(i);
        }
    }

    public Vector<UnitGroup> getDefenders() {
        return this.defenders;
    }

    public void setDefenders(Vector<UnitGroup> defenders) {
        this.defenders = defenders;
        int size = this.defenders.size();
        for (int i = size - 1; i >= 0; --i) {
            int curSize = this.defenders.elementAt(i).getNumUnits();
            if (curSize > 0) continue;
            this.defenders.removeElementAt(i);
        }
    }

    public boolean isPreserveLand() {
        return this.preserveLand;
    }

    public void setPreserveLand(boolean preserveLand) {
        this.preserveLand = preserveLand;
    }

    public int getRounds() {
        return this.rounds;
    }

    public void setRounds(int rounds) {
        this.rounds = rounds;
    }

    public boolean isLandBattle() {
        return this.landBattle;
    }

    public void setLandBattle(boolean landBattle) {
        this.landBattle = landBattle;
    }

    private void updateStats() {
        ++this.battles;
        if (this.getResultStatus() == 3) {
            ++this.cleareds;
        } else if (this.getResultStatus() == 1) {
            ++this.controleds;
        } else if (this.getResultStatus() == 2) {
            ++this.losses;
        } else if (this.getResultStatus() == 4) {
            ++this.indecisives;
        } else if (this.getResultStatus() == 5) {
            ++this.airWins;
        }
        this.controlPercent = (float)this.controleds / (float)this.battles * 100.0f;
        this.airWinPercent = (float)this.airWins / (float)this.battles * 100.0f;
        this.clearedPercent = (float)this.cleareds / (float)this.battles * 100.0f;
        this.indecisivePercent = (float)this.indecisives / (float)this.battles * 100.0f;
        this.lossPercent = (float)this.losses / (float)this.battles * 100.0f;
        this.remAtts += (long)this.getNumberOfUnits(this.locAttackers);
        this.remDefs += (long)this.getNumberOfUnits(this.locDefenders);
        this.avgRemAtts = (int)this.remAtts / this.battles;
        this.avgRemDefs = (int)this.remDefs / this.battles;
    }

    public void rollBattles(int numBattlesToRoll) {
        for (int i = 0; i < numBattlesToRoll; ++i) {
            this.rollBattle();
            this.updateStats();
        }
    }

    public void rollBattle() {
        Integer[] supportUnits;
        int hitVal;
        int i;
        this.locAttackers = this.cloneVector(this.attackers);
        this.locDefenders = this.cloneVector(this.defenders);
        if (!this.rollAntiAirSep) {
            int numberOfAir = this.getNumberOfAir(this.locAttackers);
            int numAAhits = 0;
            if (this.aaPresent && this.landBattle && numberOfAir > 0) {
                OCUnit aa = OCUnit.newAA();
                for (i = 0; i < numberOfAir; ++i) {
                    hitVal = aa.rollDefend();
                    if (hitVal > aa.getDefendValue()) continue;
                    ++numAAhits;
                }
                if (numAAhits > 0) {
                    for (i = 0; i < numAAhits; ++i) {
                        boolean removed = this.removeUnit("Bomber", this.locAttackers);
                        if (!removed) {
                            removed = this.removeUnit("Fighter", this.locAttackers);
                        }
                        removed = false;
                    }
                }
            }
        } else {
            int numFtrs = this.getNumberOfFighters(this.locAttackers);
            if (this.aaPresent && this.landBattle && numFtrs > 0) {
                OCUnit aa = OCUnit.newAA();
                for (int i2 = 0; i2 < numFtrs; ++i2) {
                    int hitVal2 = aa.rollDefend();
                    if (hitVal2 > aa.getDefendValue()) continue;
                    this.removeUnit("Fighter", this.locAttackers);
                }
            }
            int numBmbs = this.getNumberOfBombers(this.locAttackers);
            if (this.aaPresent && this.landBattle && numBmbs > 0) {
                OCUnit aa = OCUnit.newAA();
                for (i = 0; i < numBmbs; ++i) {
                    hitVal = aa.rollDefend();
                    if (hitVal > aa.getDefendValue()) continue;
                    this.removeUnit("Bomber", this.locAttackers);
                }
            }
        }
        if ((supportUnits = this.getSupportUnits(this.locAttackers)) != null && supportUnits.length > 0) {
            int supportHits = 0;
            for (int i3 = 0; i3 < supportUnits.length; ++i3) {
                UnitGroup curG = this.locAttackers.elementAt(supportUnits[i3]);
                supportHits += curG.rollUnitsAttack();
                this.locAttackers.removeElementAt(supportUnits[i3]);
            }
            this.removeUnits(supportHits, this.locDefenders, false);
        }
        this.removeIncorrectUnits(this.locAttackers);
        this.removeIncorrectUnits(this.locDefenders);
        for (int i4 = 1; this.hasUnits(this.locAttackers) && this.hasUnits(this.locDefenders) && (i4 <= this.rounds || this.rounds == 0); ++i4) {
            this.rollRound();
        }
        this.setResultStatus();
    }

    private Vector<UnitGroup> cloneVector(Vector<UnitGroup> units) {
        Vector<UnitGroup> copy = new Vector<UnitGroup>();
        int unitSize = units.size();
        for (int i = 0; i < unitSize; ++i) {
            copy.addElement((UnitGroup)units.elementAt(i).clone());
        }
        return copy;
    }

    private void removeIncorrectUnits(Vector<UnitGroup> units) {
        int size = units.size();
        for (int i = size - 1; i >= 0; --i) {
            UnitGroup ug = units.elementAt(i);
            OCUnit u = ug.getUnit();
            if (this.landBattle && u.getUnitType() == 3) {
                units.removeElementAt(i);
                continue;
            }
            if (this.landBattle || u.getUnitType() != 1) continue;
            units.removeElementAt(i);
        }
    }

    private void setResultStatus() {
        boolean hasA = this.hasUnits(this.locAttackers);
        boolean hasD = this.hasUnits(this.locDefenders);
        if (!hasD && !hasA) {
            this.resultStatus = 3;
            this.resultStatusString = CLEAREDSTRING;
        } else if (hasD && hasA) {
            this.resultStatus = 4;
            this.resultStatusString = INDECISIVESTRING;
        } else if (hasD) {
            this.resultStatus = 2;
            this.resultStatusString = DEFENDEDSTRING;
        } else if (hasA && this.allAir(this.attackers)) {
            this.resultStatus = 5;
            this.resultStatusString = CLEAREDAIRSTRING;
        } else if (hasA) {
            this.resultStatus = 1;
            this.resultStatusString = TAKENSTRING;
        }
    }

    private boolean hasUnits(Vector<UnitGroup> units) {
        boolean hasU = false;
        int size = units.size();
        for (int i = 0; i < size; ++i) {
            UnitGroup ug = units.elementAt(i);
            if (ug.getNumUnits() <= 0) continue;
            return true;
        }
        return false;
    }

    private boolean allAir(Vector<UnitGroup> units) {
        boolean allAir = true;
        int size = units.size();
        for (int i = 0; i < size; ++i) {
            UnitGroup ug = units.elementAt(i);
            OCUnit u = ug.getUnit();
            int numUnits = ug.getNumUnits();
            if (u.getUnitType() == 2 || numUnits <= 0) continue;
            return false;
        }
        return true;
    }

    private void removeUnits(int hits, Vector<UnitGroup> units, boolean attackers) {
        for (int i = 0; i < hits && units.size() > 0; ++i) {
            this.removeUnit(units, attackers);
        }
    }

    private void removeUnit(Vector<UnitGroup> units, boolean attackers) {
        UnitGroup ug = this.extraHp(units);
        if (ug != null) {
            ug.removeExtraHp();
            return;
        }
        Vector<String> localOOL = null;
        localOOL = attackers ? this.attOOL : this.defOOL;
        if (localOOL != null) {
            if (this.getNumberOfLand(units) == 1 && this.preserveLand) {
                UnitGroup last = this.getLastLand(units);
                localOOL.remove(last.getUnit().getName());
                localOOL.addElement(last.getUnit().getName());
            }
            for (int i = 0; i < localOOL.size(); ++i) {
                String curRem = localOOL.elementAt(i);
                boolean removed = this.removeUnit(curRem, units);
                if (!removed) continue;
                return;
            }
        } else {
            UnitGroup lowest = this.getLowestUnitGroup(units, attackers);
            boolean removed = this.removeUnit(lowest.getUnit().getName(), units);
            if (removed) {
                return;
            }
        }
    }

    private UnitGroup getLowestUnitGroup(Vector<UnitGroup> units, boolean attackers) {
        UnitGroup current = null;
        int unitSize = units.size();
        int lowest = 6;
        for (int i = 0; i < unitSize; ++i) {
            if (attackers) {
                if (units.elementAt(i).getUnit().getAttackValue() >= lowest || this.getNumberOfLand(units) == 1 && this.preserveLand && this.getNumberOfUnits(units) != 1 && units.elementAt(i).getUnit().getUnitType() == 1) continue;
                current = units.elementAt(i);
                lowest = units.elementAt(i).getUnit().getAttackValue();
                continue;
            }
            if (units.elementAt(i).getUnit().getDefendValue() >= lowest) continue;
            current = units.elementAt(i);
            lowest = units.elementAt(i).getUnit().getDefendValue();
        }
        return current;
    }

    private UnitGroup getLastLand(Vector<UnitGroup> units) {
        UnitGroup lastLand = null;
        int vectorSize = units.size();
        for (int i = 0; i < vectorSize; ++i) {
            UnitGroup ug = units.elementAt(i);
            if (ug.getUnit().getUnitType() != 1 || ug.getNumUnits() <= 0) continue;
            lastLand = ug;
        }
        return lastLand;
    }

    private int getNumberOfLand(Vector<UnitGroup> units) {
        int numLand = 0;
        int vectorSize = units.size();
        for (int i = 0; i < vectorSize; ++i) {
            UnitGroup ug = units.elementAt(i);
            if (ug.getUnit().getUnitType() != 1) continue;
            numLand += ug.getNumUnits();
        }
        return numLand;
    }

    private UnitGroup extraHp(Vector<UnitGroup> units) {
        UnitGroup ug = null;
        int size = units.size();
        for (int i = 0; i < size; ++i) {
            UnitGroup curG = units.elementAt(i);
            if (curG.getNumUnits() >= curG.getTotalHp()) continue;
            ug = curG;
            return ug;
        }
        return ug;
    }

    private boolean removeUnit(String curName, Vector<UnitGroup> units) {
        for (int j = units.size() - 1; j >= 0; --j) {
            UnitGroup ug = units.elementAt(j);
            OCUnit cur = ug.getUnit();
            if (!cur.getName().equals(curName)) continue;
            ug.removeUnit();
            if (ug.getNumUnits() == 0) {
                units.removeElementAt(j);
            }
            return true;
        }
        return false;
    }

    private Integer[] getSupportUnits(Vector<UnitGroup> units) {
        Integer[] suppArray = null;
        if (this.landBattle) {
            ArrayList<Integer> support = new ArrayList<Integer>();
            int aSize = units.size();
            for (int i = 0; i < aSize; ++i) {
                UnitGroup curG = units.elementAt(i);
                OCUnit cur = curG.getUnit();
                if (!cur.isSupportShot()) continue;
                support.add(i);
            }
            suppArray = support.toArray(new Integer[support.size()]);
        }
        return suppArray;
    }

    private int getNumberOfAir(Vector<UnitGroup> units) {
        int numAir = 0;
        int vectorSize = units.size();
        for (int i = 0; i < vectorSize; ++i) {
            UnitGroup ug = units.elementAt(i);
            if (ug.getUnit().getUnitType() != 2) continue;
            numAir += ug.getNumUnits();
        }
        return numAir;
    }

    private int getNumberOfFighters(Vector<UnitGroup> units) {
        int numFtrs = 0;
        int vectorSize = units.size();
        for (int i = 0; i < vectorSize; ++i) {
            UnitGroup ug = units.elementAt(i);
            if (!ug.getUnit().getName().equals("Fighter")) continue;
            numFtrs += ug.getNumUnits();
        }
        return numFtrs;
    }

    private int getNumberOfBombers(Vector<UnitGroup> units) {
        int numBmbs = 0;
        int vectorSize = units.size();
        for (int i = 0; i < vectorSize; ++i) {
            UnitGroup ug = units.elementAt(i);
            if (!ug.getUnit().getName().equals("Bomber")) continue;
            numBmbs += ug.getNumUnits();
        }
        return numBmbs;
    }

    public void rollRound() {
        int size = this.locAttackers.size();
        int attackerHits = 0;
        int specialHits = 0;
        boolean attAllAir = this.getNumberOfUnits(this.locAttackers) == this.getNumberOfAir(this.attackers);
        boolean defAllAir = this.getNumberOfUnits(this.locDefenders) == this.getNumberOfAir(this.defenders);
        boolean defBlockNoRet = this.hasBlockNoRet(this.locDefenders);
        int boostedInf = this.getBoosters(this.locAttackers);
        for (int i = 0; i < size; ++i) {
            UnitGroup curG = this.locAttackers.elementAt(i);
            OCUnit cur = curG.getUnit();
            if (!cur.isCanHitAir() && defAllAir) continue;
            int hits = 0;
            if (boostedInf > 0 && cur.getName().equals("Infantry")) {
                hits = curG.rollUnitsAttack(boostedInf);
            } else if (this.isAmphib && cur.isBoostAmphib()) {
                cur.setAttackValue(cur.getAttackValue() + 2);
                hits = curG.rollUnitsAttack();
                cur.setAttackValue(cur.getAttackValue() - 2);
            } else {
                hits = curG.rollUnitsAttack();
            }
            if (cur.isNoRetaliationHit() && !defBlockNoRet) {
                specialHits += hits;
                continue;
            }
            attackerHits += hits;
        }
        this.removeUnits(specialHits, this.locDefenders, false);
        size = this.locDefenders.size();
        int defenderHits = 0;
        for (int i = 0; i < size; ++i) {
            UnitGroup curG = this.locDefenders.elementAt(i);
            OCUnit cur = curG.getUnit();
            if (!cur.isCanHitAir() && attAllAir) continue;
            defenderHits += curG.rollUnitsDefend();
        }
        this.removeUnits(attackerHits, this.locDefenders, false);
        this.removeUnits(defenderHits, this.locAttackers, true);
    }

    protected int getNumberOfUnits(Vector<UnitGroup> units) {
        int numUnits = 0;
        int size = units.size();
        for (int i = 0; i < size; ++i) {
            UnitGroup ug = units.elementAt(i);
            numUnits += ug.getNumUnits();
        }
        return numUnits;
    }

    private int getBoosters(Vector<UnitGroup> units) {
        int boosters = 0;
        int size = units.size();
        for (int i = 0; i < size; ++i) {
            UnitGroup ug = units.elementAt(i);
            if (!ug.getUnit().isBoostsInfAtt()) continue;
            boosters += ug.getNumUnits();
        }
        return boosters;
    }

    private boolean hasBlockNoRet(Vector<UnitGroup> units) {
        boolean blocked = false;
        int size = units.size();
        for (int i = 0; i < size && !blocked; ++i) {
            UnitGroup ug = units.elementAt(i);
            if (!ug.getUnit().isBlockNoRetalHit()) continue;
            blocked = true;
        }
        return blocked;
    }

    public static void main(String[] args) {
    }

    public String toString() {
        String results = "";
        results = results + this.resultStatusString + " ";
        if (this.resultStatus != 3) {
            results = results + "with units:\nAttackers\n\t";
            results = results + this.unitVectorToString(this.attackers);
            results = results + "\nDefenders\n\t";
            results = results + this.unitVectorToString(this.defenders);
        }
        return results;
    }

    private String unitVectorToString(Vector<UnitGroup> units) {
        String res = "";
        if (units.size() == 0) {
            res = res + " none";
        } else {
            int size = units.size();
            for (int i = 0; i < size; ++i) {
                res = res + " " + units.elementAt(i).toString();
            }
        }
        return res;
    }

    public boolean isRollAntiAirSep() {
        return this.rollAntiAirSep;
    }

    public void setRollAntiAirSep(boolean rollAntiAirSep) {
        this.rollAntiAirSep = rollAntiAirSep;
    }

    public int getResultStatus() {
        return this.resultStatus;
    }

    public String getResultStatusString() {
        return this.resultStatusString;
    }

    public Vector<String> getAttOOL() {
        return this.attOOL;
    }

    public void setAttOOL(Vector<String> attOOL) {
        this.attOOL = attOOL;
    }

    public Vector<String> getDefOOL() {
        return this.defOOL;
    }

    public void setDefOOL(Vector<String> defOOL) {
        this.defOOL = defOOL;
    }

    public boolean isAmphib() {
        return this.isAmphib;
    }

    public void setAmphib(boolean isAmphib) {
        this.isAmphib = isAmphib;
    }

    public int getAvgRemAtts() {
        return this.avgRemAtts;
    }

    public int getAvgRemDefs() {
        return this.avgRemDefs;
    }
}

