/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.triplea.printgenerator;

import games.strategy.engine.data.GameData;
import games.strategy.engine.data.PlayerID;
import games.strategy.engine.data.Resource;
import games.strategy.triplea.printgenerator.PrintGenerationData;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class PUInfo {
    private GameData m_data;
    private final Map<PlayerID, Map<Resource, Integer>> m_infoMap = new HashMap<PlayerID, Map<Resource, Integer>>();
    private Iterator<PlayerID> m_playerIterator;
    private PrintGenerationData m_printData;

    protected void saveToFile(PrintGenerationData printData) {
        this.m_data = printData.getData();
        this.m_printData = printData;
        for (PlayerID currentPlayer : this.m_data.getPlayerList()) {
            Iterator<Resource> resourceIterator = this.m_data.getResourceList().getResources().iterator();
            HashMap<Resource, Integer> resourceMap = new HashMap<Resource, Integer>();
            while (resourceIterator.hasNext()) {
                Resource currentResource = resourceIterator.next();
                Integer amountOfResource = currentPlayer.getResources().getQuantity(currentResource);
                resourceMap.put(currentResource, amountOfResource);
            }
            this.m_infoMap.put(currentPlayer, resourceMap);
        }
        FileWriter resourceWriter = null;
        try {
            int i;
            File outFile = new File(this.m_printData.getOutDir(), "General Information.csv");
            resourceWriter = new FileWriter(outFile, true);
            int numResources = this.m_data.getResourceList().size();
            for (i = 0; i < numResources / 2 - 1 + numResources % 2; ++i) {
                resourceWriter.write(",");
            }
            resourceWriter.write("Resource Chart");
            for (i = 0; i < numResources / 2 - numResources % 2; ++i) {
                resourceWriter.write(",");
            }
            resourceWriter.write("\r\n");
            Iterator<Resource> resourceIterator = this.m_data.getResourceList().getResources().iterator();
            resourceWriter.write(",");
            while (resourceIterator.hasNext()) {
                Resource currentResource = resourceIterator.next();
                resourceWriter.write(currentResource.getName() + ",");
            }
            resourceWriter.write("\r\n");
            for (PlayerID currentPlayer : this.m_data.getPlayerList()) {
                resourceWriter.write(currentPlayer.getName());
                Map<Resource, Integer> resourceMap = this.m_infoMap.get(currentPlayer);
                for (Resource currentResource : resourceMap.keySet()) {
                    Integer amountResource = resourceMap.get(currentResource);
                    resourceWriter.write("," + amountResource);
                }
                resourceWriter.write("\r\n");
            }
            resourceWriter.write("\r\n");
            resourceWriter.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

