/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.triplea.ui;

import games.strategy.engine.data.GameData;
import games.strategy.engine.data.PlayerID;
import games.strategy.engine.gamePlayer.IPlayerBridge;
import games.strategy.engine.history.HistoryNode;
import games.strategy.engine.history.Round;
import games.strategy.engine.pbem.IEmailSender;
import games.strategy.engine.pbem.IForumPoster;
import games.strategy.engine.pbem.PBEMMessagePoster;
import games.strategy.engine.random.IRandomStats;
import games.strategy.triplea.ui.ActionPanel;
import games.strategy.triplea.ui.MapPanel;
import games.strategy.triplea.ui.TripleAFrame;
import games.strategy.triplea.ui.history.HistoryLog;
import games.strategy.ui.ProgressWindow;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import javax.swing.tree.TreeNode;

public abstract class AbstractForumPosterPanel
extends ActionPanel {
    private static final long serialVersionUID = -5084680807785728744L;
    protected JLabel m_actionLabel = new JLabel();
    protected IPlayerBridge m_bridge;
    protected PBEMMessagePoster m_poster;
    protected TripleAFrame m_frame;
    protected HistoryLog m_historyLog;
    protected JButton m_postButton;
    protected JCheckBox m_includeTerritoryCheckbox;
    protected JCheckBox m_includeProductionCheckbox;
    protected JCheckBox m_showDetailsCheckbox;
    protected JCheckBox m_showDiceStatisticsCheckbox;
    protected Action m_viewAction = new AbstractAction("View " + this.getTitle()){
        private static final long serialVersionUID = -2619980789206699839L;

        public void actionPerformed(ActionEvent event) {
            AbstractForumPosterPanel.this.m_historyLog.setVisible(true);
        }
    };
    protected Action m_postAction = new AbstractAction("Post " + this.getTitle()){
        private static final long serialVersionUID = 8317441736305744524L;

        public void actionPerformed(ActionEvent event) {
            IEmailSender emailSender;
            AbstractForumPosterPanel.this.updateHistoryLog();
            String message = "";
            IForumPoster turnSummaryMsgr = AbstractForumPosterPanel.this.m_poster.getForumPoster();
            StringBuilder sb = new StringBuilder();
            if (turnSummaryMsgr != null) {
                sb.append(message).append("Post " + AbstractForumPosterPanel.this.getTitle() + " ");
                if (turnSummaryMsgr.getIncludeSaveGame()) {
                    sb.append("and save game ");
                }
                sb.append("to ").append(turnSummaryMsgr.getDisplayName()).append("?\n");
            }
            if ((emailSender = AbstractForumPosterPanel.this.m_poster.getEmailSender()) != null) {
                sb.append("Send email to ").append(emailSender.getToAddress()).append("?\n");
            }
            message = sb.toString();
            int choice = JOptionPane.showConfirmDialog(AbstractForumPosterPanel.this.getTopLevelAncestor(), message, "Post " + AbstractForumPosterPanel.this.getTitle() + "?", 2, -1, null);
            if (choice != 0) {
                return;
            }
            AbstractForumPosterPanel.this.m_postButton.setEnabled(false);
            final ProgressWindow progressWindow = new ProgressWindow(AbstractForumPosterPanel.this.m_frame, "Posting " + AbstractForumPosterPanel.this.getTitle() + "...");
            progressWindow.setVisible(true);
            Runnable t = new Runnable(){

                public void run() {
                    boolean postOk = true;
                    File saveGameFile = null;
                    try {
                        saveGameFile = File.createTempFile("triplea", ".tsvg");
                        if (saveGameFile != null) {
                            AbstractForumPosterPanel.this.m_frame.getGame().saveGame(saveGameFile);
                            AbstractForumPosterPanel.this.m_poster.setSaveGame(saveGameFile);
                        }
                    }
                    catch (Exception e) {
                        postOk = false;
                        e.printStackTrace();
                    }
                    AbstractForumPosterPanel.this.m_poster.setTurnSummary(AbstractForumPosterPanel.this.m_historyLog.toString());
                    try {
                        if (!AbstractForumPosterPanel.this.postTurnSummary(AbstractForumPosterPanel.this.m_poster)) {
                            postOk = false;
                        }
                    }
                    catch (Exception e) {
                        postOk = false;
                        e.printStackTrace();
                    }
                    StringBuilder sb = new StringBuilder();
                    if (AbstractForumPosterPanel.this.m_poster.getForumPoster() != null) {
                        String saveGameRef = AbstractForumPosterPanel.this.m_poster.getSaveGameRef();
                        String turnSummaryRef = AbstractForumPosterPanel.this.m_poster.getTurnSummaryRef();
                        if (saveGameRef != null) {
                            sb.append("\nSave Game : ").append(saveGameRef);
                        }
                        if (turnSummaryRef != null) {
                            sb.append("\nSummary Text: ").append(turnSummaryRef);
                        }
                    }
                    if (AbstractForumPosterPanel.this.m_poster.getEmailSender() != null) {
                        sb.append("\nEmails: ").append(AbstractForumPosterPanel.this.m_poster.getEmailSendStatus());
                    }
                    AbstractForumPosterPanel.this.m_historyLog.getWriter().println(sb.toString());
                    if (AbstractForumPosterPanel.this.m_historyLog.isVisible()) {
                        AbstractForumPosterPanel.this.m_historyLog.setVisible(true);
                    }
                    try {
                        if (saveGameFile != null && !saveGameFile.delete()) {
                            System.err.println("couldn't delete " + saveGameFile.getCanonicalPath());
                        }
                    }
                    catch (IOException ioe) {
                        ioe.printStackTrace();
                    }
                    progressWindow.setVisible(false);
                    progressWindow.removeAll();
                    progressWindow.dispose();
                    AbstractForumPosterPanel.this.setHasPostedTurnSummary(postOk);
                    final boolean finalPostOk = postOk;
                    final String finalMessage = sb.toString();
                    Runnable runnable = new Runnable(){

                        public void run() {
                            AbstractForumPosterPanel.this.m_postButton.setEnabled(!finalPostOk);
                            if (finalPostOk) {
                                JOptionPane.showMessageDialog(AbstractForumPosterPanel.this.m_frame, finalMessage, AbstractForumPosterPanel.this.getTitle() + " Posted", 1);
                            } else {
                                JOptionPane.showMessageDialog(AbstractForumPosterPanel.this.m_frame, finalMessage, AbstractForumPosterPanel.this.getTitle() + " Posted", 0);
                            }
                        }
                    };
                    SwingUtilities.invokeLater(runnable);
                }
            };
            new Thread(t).start();
        }
    };
    protected Action m_includeTerritoryAction = new AbstractAction("Include territory summary"){
        private static final long serialVersionUID = 207279881318712095L;

        public void actionPerformed(ActionEvent event) {
            AbstractForumPosterPanel.this.updateHistoryLog();
        }
    };
    protected Action m_includeProductionAction = new AbstractAction("Include production summary"){
        private static final long serialVersionUID = 2298448099326090293L;

        public void actionPerformed(ActionEvent event) {
            AbstractForumPosterPanel.this.updateHistoryLog();
        }
    };
    protected Action m_showDetailsAction = new AbstractAction("Show dice/battle details"){
        private static final long serialVersionUID = -4248518090232071926L;

        public void actionPerformed(ActionEvent event) {
            AbstractForumPosterPanel.this.updateHistoryLog();
        }
    };
    protected Action m_showDiceStatisticsAction = new AbstractAction("Include overall dice statistics"){
        private static final long serialVersionUID = 1431745626173286692L;

        public void actionPerformed(ActionEvent event) {
            AbstractForumPosterPanel.this.updateHistoryLog();
        }
    };
    protected Action m_doneAction = new AbstractAction("Done"){
        private static final long serialVersionUID = -3658752576117043053L;

        public void actionPerformed(ActionEvent event) {
            AbstractForumPosterPanel.this.release();
        }
    };

    protected abstract String getTitle();

    public AbstractForumPosterPanel(GameData data, MapPanel map) {
        super(data, map);
        this.m_includeTerritoryCheckbox = new JCheckBox(this.m_includeTerritoryAction);
        this.m_includeProductionCheckbox = new JCheckBox(this.m_includeProductionAction);
        this.m_showDetailsCheckbox = new JCheckBox(this.m_showDetailsAction);
        this.m_showDiceStatisticsCheckbox = new JCheckBox(this.m_showDiceStatisticsAction);
    }

    private int getRound() {
        TreeNode[] pathFromRoot;
        int round = 0;
        for (TreeNode pathNode : pathFromRoot = this.getData().getHistory().getLastNode().getPath()) {
            HistoryNode curNode = (HistoryNode)pathNode;
            if (!(curNode instanceof Round)) continue;
            round = ((Round)curNode).getRoundNo();
            break;
        }
        return round;
    }

    public void display(final PlayerID id) {
        super.display(id);
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                AbstractForumPosterPanel.this.m_actionLabel.setText(id.getName() + " " + AbstractForumPosterPanel.this.getTitle());
            }
        });
    }

    protected abstract boolean allowIncludeTerritorySummary();

    protected abstract boolean allowIncludeProductionSummary();

    protected abstract boolean allowDiceBattleDetails();

    protected abstract boolean allowDiceStatistics();

    protected abstract boolean postTurnSummary(PBEMMessagePoster var1);

    public abstract String toString();

    private void updateHistoryLog() {
        HashSet<PlayerID> allowedIDs;
        String allowedPlayers = this.m_bridge.getStepProperties().getProperty("turnSummaryPlayers");
        if (allowedPlayers != null) {
            allowedIDs = new HashSet<PlayerID>();
            for (String p : allowedPlayers.split(":")) {
                PlayerID id = this.getData().getPlayerList().getPlayerID(p);
                if (id == null) {
                    System.err.println("gamePlay sequence step: " + this.m_bridge.getStepName() + " stepProperty: " + "turnSummaryPlayers" + " player: " + p + " DOES NOT EXIST");
                    continue;
                }
                allowedIDs.add(id);
            }
        } else {
            allowedIDs = null;
        }
        this.m_historyLog.clear();
        this.m_historyLog.printFullTurn(this.getData(), this.m_showDetailsCheckbox.isSelected(), allowedIDs);
        if (this.m_includeTerritoryCheckbox.isSelected()) {
            this.m_historyLog.printTerritorySummary(this.getData(), allowedIDs);
        }
        if (this.m_includeProductionCheckbox.isSelected()) {
            this.m_historyLog.printProductionSummary(this.getData());
        }
        if (this.m_showDiceStatisticsCheckbox.isSelected()) {
            this.m_historyLog.printDiceStatistics(this.getData(), (IRandomStats)this.m_frame.getGame().getRemoteMessenger().getRemote(IRandomStats.RANDOM_STATS_REMOTE_NAME));
        }
        this.m_historyLog.requestFocus();
    }

    protected abstract boolean getHasPostedTurnSummary();

    protected abstract void setHasPostedTurnSummary(boolean var1);

    protected abstract boolean skipPosting();

    protected void waitForDone(TripleAFrame frame, IPlayerBridge bridge) {
        this.m_frame = frame;
        this.m_bridge = bridge;
        this.m_poster = new PBEMMessagePoster(this.getData(), this.getCurrentPlayer(), this.getRound(), this.getTitle());
        if (!this.m_poster.hasMessengers()) {
            return;
        }
        if (this.skipPosting() || Boolean.parseBoolean(this.m_bridge.getStepProperties().getProperty("skipPosting", "false"))) {
            return;
        }
        final boolean hasPosted = this.getHasPostedTurnSummary();
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                AbstractForumPosterPanel.this.m_historyLog = new HistoryLog();
                AbstractForumPosterPanel.this.updateHistoryLog();
                AbstractForumPosterPanel.this.removeAll();
                AbstractForumPosterPanel.this.add(AbstractForumPosterPanel.this.m_actionLabel);
                if (AbstractForumPosterPanel.this.allowIncludeTerritorySummary()) {
                    AbstractForumPosterPanel.this.add(AbstractForumPosterPanel.this.m_includeTerritoryCheckbox);
                }
                if (AbstractForumPosterPanel.this.allowIncludeProductionSummary()) {
                    AbstractForumPosterPanel.this.add(AbstractForumPosterPanel.this.m_includeProductionCheckbox);
                }
                if (AbstractForumPosterPanel.this.allowDiceBattleDetails()) {
                    AbstractForumPosterPanel.this.add(AbstractForumPosterPanel.this.m_showDetailsCheckbox);
                }
                if (AbstractForumPosterPanel.this.allowDiceStatistics()) {
                    AbstractForumPosterPanel.this.add(AbstractForumPosterPanel.this.m_showDiceStatisticsCheckbox);
                }
                AbstractForumPosterPanel.this.add(new JButton(AbstractForumPosterPanel.this.m_viewAction));
                AbstractForumPosterPanel.this.m_postButton = new JButton(AbstractForumPosterPanel.this.m_postAction);
                AbstractForumPosterPanel.this.m_postButton.setEnabled(!hasPosted);
                AbstractForumPosterPanel.this.add(AbstractForumPosterPanel.this.m_postButton);
                AbstractForumPosterPanel.this.add(new JButton(AbstractForumPosterPanel.this.m_doneAction));
                AbstractForumPosterPanel.this.validate();
            }
        });
        this.waitForRelease();
    }
}

