/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.triplea.ui;

import games.strategy.engine.data.GameData;
import games.strategy.engine.data.PlayerID;
import games.strategy.engine.gamePlayer.IPlayerBridge;
import games.strategy.triplea.delegate.UndoableMove;
import games.strategy.triplea.delegate.dataObjects.MoveDescription;
import games.strategy.triplea.delegate.remote.IAbstractMoveDelegate;
import games.strategy.triplea.ui.AbstractUndoableMovesPanel;
import games.strategy.triplea.ui.ActionPanel;
import games.strategy.triplea.ui.MapPanel;
import games.strategy.triplea.ui.MovePanel;
import games.strategy.triplea.ui.TripleAFrame;
import games.strategy.triplea.ui.WeakAction;
import java.awt.event.ActionEvent;
import java.util.Collections;
import java.util.List;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JRootPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractMovePanel
extends ActionPanel {
    private static final long serialVersionUID = -4153574987414031433L;
    private static final String s_MOVE_PANEL_CANCEL = "movePanel.cancel";
    private static final Logger s_logger = Logger.getLogger(MovePanel.class.getName());
    private static final int s_entryPadding = 15;
    private final TripleAFrame m_frame;
    private boolean m_listening = false;
    private final JLabel m_actionLabel = new JLabel();
    protected MoveDescription m_moveMessage;
    protected List<UndoableMove> m_undoableMoves;
    protected AbstractAction m_doneMove = new AbstractAction("Done"){
        private static final long serialVersionUID = -6497408896615920650L;

        public void actionPerformed(ActionEvent e) {
            if (AbstractMovePanel.this.doneMoveAction()) {
                AbstractMovePanel.this.m_moveMessage = null;
                AbstractMovePanel.this.release();
            }
        }
    };
    private final Action m_DONE_MOVE_ACTION = new WeakAction("Done", this.m_doneMove);
    private final Action m_cancelMove = new AbstractAction("Cancel"){
        private static final long serialVersionUID = -257745862234175428L;

        public void actionPerformed(ActionEvent e) {
            AbstractMovePanel.this.cancelMoveAction();
            AbstractMovePanel.this.m_frame.clearStatusMessage();
            this.setEnabled(false);
            AbstractMovePanel.this.m_CANCEL_MOVE_ACTION.setEnabled(false);
        }
    };
    private final AbstractAction m_CANCEL_MOVE_ACTION = new WeakAction("Cancel", this.m_cancelMove);
    protected AbstractUndoableMovesPanel m_undoableMovesPanel;
    private IPlayerBridge m_bridge;

    protected abstract boolean doneMoveAction();

    protected abstract void cancelMoveAction();

    protected IPlayerBridge getPlayerBridge() {
        return this.m_bridge;
    }

    public AbstractMovePanel(GameData data, MapPanel map, TripleAFrame frame) {
        super(data, map);
        this.m_frame = frame;
        this.m_CANCEL_MOVE_ACTION.setEnabled(false);
        this.m_undoableMoves = Collections.emptyList();
    }

    protected final void clearStatusMessage() {
        this.m_frame.clearStatusMessage();
    }

    protected final void setStatusErrorMessage(String message) {
        this.m_frame.setStatusErrorMessage(message);
    }

    protected final void setStatusWarningMessage(String message) {
        this.m_frame.setStatusWarningMessage(message);
    }

    protected final boolean getListening() {
        return this.m_listening;
    }

    protected final void setMoveMessage(MoveDescription message) {
        this.m_moveMessage = message;
    }

    protected final List<UndoableMove> getUndoableMoves() {
        return this.m_undoableMoves;
    }

    protected final void enableCancelButton() {
        this.m_CANCEL_MOVE_ACTION.setEnabled(true);
    }

    protected final GameData getGameData() {
        return this.m_bridge.getGameData();
    }

    private IAbstractMoveDelegate getDelegate() {
        return (IAbstractMoveDelegate)this.m_bridge.getRemote();
    }

    protected final void updateMoves() {
        this.m_undoableMoves = this.getDelegate().getMovesMade();
        this.m_undoableMovesPanel.setMoves(this.m_undoableMoves);
    }

    public final void cancelMove() {
        this.m_CANCEL_MOVE_ACTION.actionPerformed(null);
    }

    public final String undoMove(int moveIndex) {
        this.m_CANCEL_MOVE_ACTION.actionPerformed(null);
        String error = this.getDelegate().undoMove(moveIndex);
        if (error != null) {
            JOptionPane.showMessageDialog(this.getTopLevelAncestor(), error, "Could not undo move", 0);
        } else {
            this.updateMoves();
        }
        this.undoMoveSpecific();
        return error;
    }

    protected abstract void undoMoveSpecific();

    protected final void cleanUp() {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                s_logger.fine("cleanup");
                if (!AbstractMovePanel.this.m_listening) {
                    throw new IllegalStateException("Not listening");
                }
                AbstractMovePanel.this.m_listening = false;
                AbstractMovePanel.this.cleanUpSpecific();
                AbstractMovePanel.this.m_bridge = null;
                AbstractMovePanel.this.m_CANCEL_MOVE_ACTION.setEnabled(false);
                JRootPane rootPane = AbstractMovePanel.this.getRootPane();
                if (rootPane != null) {
                    rootPane.getInputMap().put(KeyStroke.getKeyStroke(27, 0), null);
                }
                AbstractMovePanel.this.removeAll();
                AbstractMovePanel.this.REFRESH.run();
            }
        });
    }

    protected abstract void cleanUpSpecific();

    @Override
    public final void setActive(boolean active) {
        super.setActive(active);
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                AbstractMovePanel.this.m_CANCEL_MOVE_ACTION.actionPerformed(null);
            }
        });
    }

    protected final void display(final PlayerID id, final String actionLabel) {
        super.display(id);
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                AbstractMovePanel.this.removeAll();
                AbstractMovePanel.this.m_actionLabel.setText(id.getName() + actionLabel);
                AbstractMovePanel.this.add(AbstractMovePanel.this.leftBox(AbstractMovePanel.this.m_actionLabel));
                if (AbstractMovePanel.this.setCancelButton()) {
                    AbstractMovePanel.this.add(AbstractMovePanel.this.leftBox(new JButton(AbstractMovePanel.this.m_CANCEL_MOVE_ACTION)));
                }
                AbstractMovePanel.this.add(AbstractMovePanel.this.leftBox(new JButton(AbstractMovePanel.this.m_DONE_MOVE_ACTION)));
                AbstractMovePanel.this.addAdditionalButtons();
                AbstractMovePanel.this.add(Box.createVerticalStrut(15));
                AbstractMovePanel.this.add(AbstractMovePanel.this.m_undoableMovesPanel);
                AbstractMovePanel.this.add(Box.createGlue());
                SwingUtilities.invokeLater(AbstractMovePanel.this.REFRESH);
            }
        });
    }

    protected void addAdditionalButtons() {
    }

    protected abstract boolean setCancelButton();

    protected final JComponent leftBox(JComponent c) {
        Box b = new Box(0);
        b.add(c);
        b.add(Box.createHorizontalGlue());
        return b;
    }

    protected final void setUp(final IPlayerBridge bridge) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                s_logger.fine("setup");
                AbstractMovePanel.this.setUpSpecific();
                AbstractMovePanel.this.m_bridge = bridge;
                AbstractMovePanel.this.updateMoves();
                if (AbstractMovePanel.this.m_listening) {
                    throw new IllegalStateException("Not listening");
                }
                AbstractMovePanel.this.m_listening = true;
                String key = AbstractMovePanel.s_MOVE_PANEL_CANCEL;
                AbstractMovePanel.this.getRootPane().getActionMap().put(AbstractMovePanel.s_MOVE_PANEL_CANCEL, AbstractMovePanel.this.m_CANCEL_MOVE_ACTION);
                AbstractMovePanel.this.getRootPane().getInputMap(1).put(KeyStroke.getKeyStroke(27, 0), AbstractMovePanel.s_MOVE_PANEL_CANCEL);
            }
        });
    }

    protected abstract void setUpSpecific();

    protected void clearDependencies() {
    }

    public final MoveDescription waitForMove(IPlayerBridge bridge) {
        this.setUp(bridge);
        this.waitForRelease();
        this.cleanUp();
        MoveDescription rVal = this.m_moveMessage;
        this.m_moveMessage = null;
        this.clearDependencies();
        return rVal;
    }
}

