/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.triplea.ui;

import games.strategy.engine.data.GameData;
import games.strategy.triplea.delegate.Die;
import games.strategy.triplea.ui.UIContext;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class DiceChooser
extends JPanel {
    private static final long serialVersionUID = -3658408802544268998L;
    private final UIContext m_uiContext;
    private JPanel m_dicePanel;
    private final int[] m_random;
    private int m_diceCount = 0;
    private int m_numRolls = 0;
    private int m_hitAt = 0;
    private boolean m_hitOnlyIfEquals = false;
    private final Collection<JButton> m_buttons;
    private JButton m_undoButton;
    private JLabel m_diceCountLabel;
    private int m_diceSides = 6;

    public DiceChooser(UIContext uiContext, int numRolls, int hitAt, boolean hitOnlyIfEquals, int diceSides, GameData data) {
        this.m_uiContext = uiContext;
        this.m_numRolls = numRolls;
        this.m_diceSides = diceSides;
        this.m_hitAt = hitAt;
        this.m_hitOnlyIfEquals = hitOnlyIfEquals;
        this.m_buttons = new ArrayList<JButton>(diceSides);
        this.m_random = new int[numRolls];
        this.setLayout(new BoxLayout(this, 1));
        this.createComponents();
    }

    public void clear() {
        this.m_dicePanel.removeAll();
        for (int i = 0; i < this.m_diceCount; ++i) {
            this.m_random[i] = 0;
        }
        this.m_diceCount = 0;
    }

    public int[] getDice() {
        if (this.m_diceCount < this.m_numRolls) {
            return null;
        }
        return this.m_random;
    }

    private void addDie(int roll) {
        boolean hit = roll == this.m_hitAt || !this.m_hitOnlyIfEquals && this.m_hitAt > 0 && roll > this.m_hitAt;
        Die.DieType dieType = hit ? Die.DieType.HIT : Die.DieType.MISS;
        this.m_dicePanel.add(new JLabel(this.m_uiContext.getDiceImageFactory().getDieIcon(roll, dieType)));
        this.m_dicePanel.add(Box.createHorizontalStrut(2));
        this.m_random[this.m_diceCount++] = roll - 1;
        this.updateDiceCount();
        this.validate();
        this.invalidate();
        this.repaint();
    }

    private void removeLastDie() {
        int lastIndex = this.m_dicePanel.getComponentCount() - 1;
        this.m_dicePanel.remove(lastIndex);
        this.m_dicePanel.remove(lastIndex - 1);
        --this.m_diceCount;
        this.updateDiceCount();
        this.validate();
        this.invalidate();
        this.repaint();
    }

    private void updateDiceCount() {
        boolean showButtons = this.m_diceCount < this.m_numRolls;
        for (JButton button : this.m_buttons) {
            button.setEnabled(showButtons);
        }
        this.m_undoButton.setEnabled(this.m_diceCount > 0);
        this.m_diceCountLabel.setText("Dice remaining: " + (this.m_numRolls - this.m_diceCount));
    }

    private void createComponents() {
        JPanel diceButtonPanel = new JPanel();
        diceButtonPanel.setLayout(new BoxLayout(diceButtonPanel, 0));
        diceButtonPanel.add(Box.createHorizontalStrut(40));
        for (int roll = 1; roll <= this.m_diceSides; ++roll) {
            boolean hit = roll == this.m_hitAt || !this.m_hitOnlyIfEquals && this.m_hitAt > 0 && roll > this.m_hitAt;
            diceButtonPanel.add(Box.createHorizontalStrut(4));
            final int dieNum = roll;
            Die.DieType dieType = hit ? Die.DieType.HIT : Die.DieType.MISS;
            JButton button = new JButton(new AbstractAction(null, this.m_uiContext.getDiceImageFactory().getDieIcon(roll, dieType)){
                private static final long serialVersionUID = 8900816143434068634L;

                public void actionPerformed(ActionEvent event) {
                    DiceChooser.this.addDie(dieNum);
                }
            });
            this.m_buttons.add(button);
            button.setPreferredSize(new Dimension(this.m_uiContext.getDiceImageFactory().DIE_WIDTH + 4, this.m_uiContext.getDiceImageFactory().DIE_HEIGHT + 4));
            diceButtonPanel.add(button);
        }
        diceButtonPanel.add(Box.createHorizontalStrut(4));
        this.m_undoButton = new JButton(new AbstractAction("Undo"){
            private static final long serialVersionUID = 9096980607403511853L;

            public void actionPerformed(ActionEvent event) {
                DiceChooser.this.removeLastDie();
            }
        });
        diceButtonPanel.add(this.m_undoButton);
        diceButtonPanel.add(Box.createHorizontalStrut(40));
        this.m_diceCountLabel = new JLabel("Dice remaining:   ");
        JPanel labelPanel = new JPanel();
        labelPanel.setLayout(new BoxLayout(labelPanel, 0));
        labelPanel.add(this.m_diceCountLabel);
        this.m_dicePanel = new JPanel();
        this.m_dicePanel.setBorder(BorderFactory.createLoweredBevelBorder());
        this.m_dicePanel.setLayout(new BoxLayout(this.m_dicePanel, 0));
        JScrollPane scroll = new JScrollPane(this.m_dicePanel);
        scroll.setBorder(null);
        scroll.setVerticalScrollBarPolicy(21);
        scroll.setMinimumSize(new Dimension(scroll.getMinimumSize().width, this.m_uiContext.getDiceImageFactory().DIE_HEIGHT + 17));
        scroll.setMaximumSize(new Dimension(scroll.getMaximumSize().width, this.m_uiContext.getDiceImageFactory().DIE_HEIGHT + 17));
        scroll.setPreferredSize(new Dimension(scroll.getPreferredSize().width, this.m_uiContext.getDiceImageFactory().DIE_HEIGHT + 17));
        this.add(scroll);
        this.add(Box.createVerticalStrut(8));
        this.add(labelPanel);
        this.add(Box.createVerticalStrut(8));
        this.add(diceButtonPanel);
        this.updateDiceCount();
    }
}

