/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.triplea.ui;

import games.strategy.engine.data.GameData;
import games.strategy.engine.gamePlayer.IPlayerBridge;
import games.strategy.engine.pbem.PBEMMessagePoster;
import games.strategy.triplea.delegate.remote.IAbstractEndTurnDelegate;
import games.strategy.triplea.ui.AbstractForumPosterPanel;
import games.strategy.triplea.ui.MapPanel;
import games.strategy.triplea.ui.TripleAFrame;

public class EndTurnPanel
extends AbstractForumPosterPanel {
    private static final long serialVersionUID = -6282316384529504341L;

    public EndTurnPanel(GameData data, MapPanel map) {
        super(data, map);
    }

    protected String getTitle() {
        return "Turn Summary";
    }

    public String toString() {
        return "EndTurnPanel";
    }

    protected boolean allowIncludeTerritorySummary() {
        return true;
    }

    protected boolean allowIncludeProductionSummary() {
        return true;
    }

    protected boolean allowDiceBattleDetails() {
        return true;
    }

    protected boolean allowDiceStatistics() {
        return true;
    }

    protected boolean getHasPostedTurnSummary() {
        IAbstractEndTurnDelegate delegate = (IAbstractEndTurnDelegate)this.m_bridge.getRemote();
        return delegate.getHasPostedTurnSummary();
    }

    protected void setHasPostedTurnSummary(boolean posted) {
        IAbstractEndTurnDelegate delegate = (IAbstractEndTurnDelegate)this.m_bridge.getRemote();
        delegate.setHasPostedTurnSummary(posted);
    }

    public void waitForEndTurn(TripleAFrame frame, IPlayerBridge bridge) {
        super.waitForDone(frame, bridge);
    }

    protected boolean postTurnSummary(PBEMMessagePoster poster) {
        IAbstractEndTurnDelegate delegate = (IAbstractEndTurnDelegate)this.m_bridge.getRemote();
        return delegate.postTurnSummary(poster, this.getTitle());
    }

    protected boolean skipPosting() {
        return false;
    }
}

