/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.triplea.ui;

import games.strategy.engine.data.GameData;
import games.strategy.engine.data.Unit;
import games.strategy.triplea.ui.IndividualUnitPanel;
import games.strategy.triplea.ui.UIContext;
import games.strategy.ui.ScrollableTextField;
import games.strategy.ui.ScrollableTextFieldListener;
import games.strategy.util.IntegerMap;
import games.strategy.util.Tuple;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IndividualUnitPanelGrouped
extends JPanel {
    private static final long serialVersionUID = 3573683064535306664L;
    private int m_max = 0;
    private final boolean m_showMinAndMax;
    private final JTextArea m_title;
    private final GameData m_data;
    private final UIContext m_uiContext;
    private final Map<String, Collection<Unit>> m_unitsToChooseFrom;
    private final Collection<Tuple<String, IndividualUnitPanel>> m_entries = new ArrayList<Tuple<String, IndividualUnitPanel>>();
    private final JLabel m_leftToSelect = new JLabel();
    private JButton m_autoSelectButton;
    private JButton m_selectNoneButton;
    private final boolean m_showSelectAll;
    private final ScrollableTextFieldListener m_textFieldListener = new ScrollableTextFieldListener(){

        public void changedValue(ScrollableTextField field) {
            IndividualUnitPanelGrouped.this.updateLeft();
        }
    };

    public IndividualUnitPanelGrouped(Map<String, Collection<Unit>> unitsToChooseFrom, GameData data, UIContext context, String title, int maxTotal, boolean showMinAndMax, boolean showSelectAll) {
        this.m_data = data;
        this.m_uiContext = context;
        this.setMaxAndShowMaxButton(maxTotal);
        this.m_showMinAndMax = showMinAndMax;
        this.m_title = new JTextArea(title);
        this.m_title.setBackground(this.getBackground());
        this.m_title.setEditable(false);
        this.m_title.setWrapStyleWord(true);
        this.m_unitsToChooseFrom = unitsToChooseFrom;
        this.m_showSelectAll = showSelectAll;
        this.layoutEntries();
    }

    private void setMaxAndShowMaxButton(int max) {
        this.m_max = max;
        this.m_textFieldListener.changedValue(null);
    }

    public void setTitle(String title) {
        this.m_title.setText(title);
    }

    private void updateLeft() {
        if (this.m_max == -1) {
            return;
        }
        int selected = this.getSelectedCount();
        int newMax = this.m_max - selected;
        for (Tuple<String, IndividualUnitPanel> entry : this.m_entries) {
            int current = entry.getSecond().getSelectedCount();
            int maxForThis = current + newMax;
            if (entry.getSecond().getMax() == maxForThis) continue;
            entry.getSecond().setMaxAndUpdate(maxForThis);
        }
        this.m_leftToSelect.setText("Left to select:" + newMax);
    }

    protected int getSelectedCount() {
        int selected = 0;
        for (Tuple<String, IndividualUnitPanel> entry : this.m_entries) {
            selected += entry.getSecond().getSelectedCount();
        }
        return selected;
    }

    private void layoutEntries() {
        this.setLayout(new GridBagLayout());
        Insets nullInsets = new Insets(0, 0, 0, 0);
        Dimension buttonSize = new Dimension(80, 20);
        this.m_selectNoneButton = new JButton("None");
        this.m_selectNoneButton.setPreferredSize(buttonSize);
        this.m_autoSelectButton = new JButton("Max");
        this.m_autoSelectButton.setPreferredSize(buttonSize);
        this.add((Component)this.m_title, new GridBagConstraints(0, 0, 7, 1, 0.0, 0.5, 13, 2, nullInsets, 0, 0));
        this.m_selectNoneButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                IndividualUnitPanelGrouped.this.selectNone();
            }
        });
        this.m_autoSelectButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                IndividualUnitPanelGrouped.this.autoSelect();
            }
        });
        JPanel entries = new JPanel();
        entries.setLayout(new FlowLayout());
        entries.setBorder(BorderFactory.createEmptyBorder());
        for (Map.Entry<String, Collection<Unit>> entry : this.m_unitsToChooseFrom.entrySet()) {
            String miniTitle = entry.getKey();
            Collection<Unit> possibleTargets = entry.getValue();
            JPanel panelChooser = new JPanel();
            panelChooser.setLayout(new BoxLayout(panelChooser, 1));
            panelChooser.setBorder(BorderFactory.createLineBorder(this.getBackground()));
            JLabel chooserTitle = new JLabel("Choose Per Unit");
            chooserTitle.setHorizontalAlignment(2);
            chooserTitle.setFont(new Font("Arial", 1, 12));
            panelChooser.add(chooserTitle);
            panelChooser.add(new JLabel(" "));
            IndividualUnitPanel chooser = new IndividualUnitPanel(possibleTargets, miniTitle, this.m_data, this.m_uiContext, this.m_max, this.m_showMinAndMax, this.m_showSelectAll, this.m_textFieldListener);
            this.m_entries.add(new Tuple<String, IndividualUnitPanel>(miniTitle, chooser));
            panelChooser.add(chooser);
            JScrollPane chooserScrollPane = new JScrollPane(panelChooser);
            chooserScrollPane.setMaximumSize(new Dimension(220, 520));
            chooserScrollPane.setPreferredSize(new Dimension(chooserScrollPane.getPreferredSize().width > 220 ? 220 : (chooserScrollPane.getPreferredSize().height > 520 ? chooserScrollPane.getPreferredSize().width + 20 : chooserScrollPane.getPreferredSize().width), chooserScrollPane.getPreferredSize().height > 520 ? 520 : (chooserScrollPane.getPreferredSize().width > 220 ? chooserScrollPane.getPreferredSize().height + 20 : chooserScrollPane.getPreferredSize().height)));
            entries.add(chooserScrollPane);
        }
        int yIndex = 1;
        this.add((Component)entries, new GridBagConstraints(0, yIndex, 1, 1, 0.0, 0.0, 17, 2, nullInsets, 0, 0));
        ++yIndex;
        if (this.m_showSelectAll) {
            this.add((Component)this.m_autoSelectButton, new GridBagConstraints(0, 2, 7, 1, 0.0, 0.5, 10, 0, nullInsets, 0, 0));
            ++yIndex;
        }
        this.add((Component)this.m_leftToSelect, new GridBagConstraints(0, 3, 5, 2, 0.0, 0.5, 17, 2, nullInsets, 0, 0));
    }

    public Map<String, IntegerMap<Unit>> getSelected() {
        HashMap<String, IntegerMap<Unit>> selectedUnits = new HashMap<String, IntegerMap<Unit>>();
        for (Tuple<String, IndividualUnitPanel> entry : this.m_entries) {
            selectedUnits.put(entry.getFirst(), entry.getSecond().getSelected());
        }
        return selectedUnits;
    }

    protected void selectNone() {
        for (Tuple<String, IndividualUnitPanel> entry : this.m_entries) {
            entry.getSecond().selectNone();
        }
    }

    protected void autoSelect() {
        for (Tuple<String, IndividualUnitPanel> entry : this.m_entries) {
            entry.getSecond().autoSelect();
        }
    }
}

