/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.triplea.ui;

import games.strategy.engine.data.GameData;
import javax.swing.BoxLayout;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class NotesPanel
extends JPanel {
    private static final long serialVersionUID = 2746643868463714526L;
    protected static JEditorPane m_textArea = new JEditorPane();
    protected GameData m_data;

    public NotesPanel(GameData data) {
        this.m_data = data;
        this.initLayout();
    }

    protected void initLayout() {
        this.setLayout(new BoxLayout(this, 1));
        m_textArea.setEditable(false);
        m_textArea.setContentType("text/html");
        this.fillNotesPane();
        JScrollPane scroll = new JScrollPane(m_textArea);
        this.add(scroll);
    }

    private void fillNotesPane() {
        String notes = this.m_data.getProperties().get("notes", "");
        if (notes == null || notes.trim().length() <= 0) {
            m_textArea.setText("");
        } else {
            m_textArea.setText(notes);
        }
        m_textArea.setCaretPosition(0);
    }

    public boolean isEmpty() {
        return m_textArea == null || m_textArea.getText() == null || m_textArea.getText().length() <= 0;
    }
}

