/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.triplea.ui;

import games.strategy.engine.data.Change;
import games.strategy.engine.data.GameData;
import games.strategy.engine.data.PlayerID;
import games.strategy.engine.data.events.GameDataChangeListener;
import games.strategy.engine.delegate.IDelegateBridge;
import games.strategy.engine.framework.startup.mc.GameSelectorModel;
import games.strategy.triplea.attatchments.AbstractConditionsAttachment;
import games.strategy.triplea.attatchments.ICondition;
import games.strategy.triplea.attatchments.PoliticalActionAttachment;
import games.strategy.triplea.attatchments.RulesAttachment;
import games.strategy.triplea.attatchments.TriggerAttachment;
import games.strategy.triplea.ui.AbstractStatPanel;
import games.strategy.triplea.ui.ColorTableCellRenderer;
import games.strategy.triplea.ui.EditorPaneCellEditor;
import games.strategy.triplea.ui.EditorPaneTableCellRenderer;
import games.strategy.triplea.ui.ObjectivePanelDummyDelegateBridge;
import games.strategy.triplea.ui.ObjectiveProperties;
import games.strategy.triplea.ui.UIContext;
import games.strategy.util.IllegalCharacterRemover;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableColumn;

public class ObjectivePanel
extends AbstractStatPanel {
    private static final long serialVersionUID = 3759819236905645520L;
    private Map<String, Map<ICondition, String>> m_statsObjective;
    private ObjectiveTableModel m_objectiveModel;
    private IDelegateBridge m_dummyDelegate;

    public ObjectivePanel(GameData data) {
        super(data);
        this.m_dummyDelegate = new ObjectivePanelDummyDelegateBridge(data);
        this.initLayout();
    }

    public String getName() {
        return ObjectiveProperties.getInstance().getProperty("Objectives.Panel.Name", "Objectives");
    }

    public boolean isEmpty() {
        return this.m_statsObjective.isEmpty();
    }

    public void removeDataChangeListener() {
        this.m_objectiveModel.removeDataChangeListener();
    }

    protected void initLayout() {
        this.setLayout(new BoxLayout(this, 1));
        this.m_objectiveModel = new ObjectiveTableModel();
        final JTable table = new JTable(this.m_objectiveModel);
        table.getTableHeader().setReorderingAllowed(false);
        TableColumn column0 = table.getColumnModel().getColumn(0);
        column0.setPreferredWidth(34);
        column0.setWidth(34);
        column0.setMaxWidth(34);
        column0.setCellRenderer(new ColorTableCellRenderer());
        TableColumn column1 = table.getColumnModel().getColumn(1);
        column1.setCellEditor(new EditorPaneCellEditor());
        column1.setCellRenderer(new EditorPaneTableCellRenderer());
        JScrollPane scroll = new JScrollPane(table);
        JButton refresh = new JButton("Refresh Objectives");
        refresh.setAlignmentY(0.5f);
        refresh.addActionListener(new AbstractAction("Refresh Objectives"){
            private static final long serialVersionUID = -5217040341132623172L;

            public void actionPerformed(ActionEvent e) {
                ObjectivePanel.this.m_objectiveModel.loadData();
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        table.repaint();
                    }
                });
            }
        });
        this.add(Box.createVerticalStrut(6));
        this.add(refresh);
        this.add(Box.createVerticalStrut(6));
        this.add(scroll);
    }

    public void setGameData(GameData data) {
        this.m_dummyDelegate = new ObjectivePanelDummyDelegateBridge(data);
        this.m_data = data;
        this.m_objectiveModel.setGameData(data);
        this.m_objectiveModel.gameDataChanged(null);
    }

    public static void main(String[] args) {
        JFrame f = new JFrame();
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 1));
        GameSelectorModel model = new GameSelectorModel();
        model.loadDefaultGame(f);
        GameData data = model.getGameData();
        UIContext uiContext = new UIContext();
        uiContext.setDefaultMapDir(data);
        uiContext.getMapData().verify(data);
        ObjectivePanel panelObj = new ObjectivePanel(data);
        panel.add(panelObj);
        f.getContentPane().add(panel);
        f.setDefaultCloseOperation(3);
        f.pack();
        f.setVisible(true);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class ObjectiveTableModel
    extends AbstractTableModel
    implements GameDataChangeListener {
        private static final long serialVersionUID = 2259315408905271333L;
        private static final int COLUMNS_TOTAL = 2;
        private boolean m_isDirty = true;
        private String[][] m_collectedData;
        final Map<String, List<String>> m_sections = new LinkedHashMap<String, List<String>>();
        private long m_timestamp = 0L;

        public ObjectiveTableModel() {
            this.setObjectiveStats();
            ObjectivePanel.this.m_data.addDataChangeListener(this);
            this.m_isDirty = true;
        }

        public void removeDataChangeListener() {
            ObjectivePanel.this.m_data.removeDataChangeListener(this);
        }

        private void setObjectiveStats() {
            String value;
            String[] key;
            String fileKey;
            ObjectivePanel.this.m_statsObjective = new LinkedHashMap();
            ObjectiveProperties op = ObjectiveProperties.getInstance();
            Collection<PlayerID> allPlayers = ObjectivePanel.this.m_data.getPlayerList().getPlayers();
            String gameName = IllegalCharacterRemover.replaceIllegalCharacter(ObjectivePanel.this.m_data.getGameName(), '_').replaceAll(" ", "_").concat(".");
            HashMap<String, List<String>> sectionsUnsorted = new HashMap<String, List<String>>();
            ArrayList<String> sectionsSorters = new ArrayList<String>();
            HashMap<String, Map> statsObjectiveUnsorted = new HashMap<String, Map>();
            for (Map.Entry<Object, Object> entry : op.entrySet()) {
                fileKey = (String)entry.getKey();
                if (!fileKey.startsWith(gameName)) continue;
                key = fileKey.substring(gameName.length(), fileKey.length()).split(";");
                value = (String)entry.getValue();
                if (key.length != 2) {
                    System.err.println("objective.properties keys must be 2 parts: <game_name>.TABLEGROUP.<#>;player  OR  <game_name>.player;attachmentName");
                    continue;
                }
                if (!key[0].startsWith("TABLEGROUP")) continue;
                String[] sorter = key[0].split("\\.");
                if (sorter.length != 2) {
                    System.err.println("objective.properties TABLEGROUPmust have .<sorter> after it: " + key[0]);
                    continue;
                }
                sectionsSorters.add(sorter[1] + ";" + key[1]);
                sectionsUnsorted.put(key[1], Arrays.asList(value.split(";")));
            }
            Collections.sort(sectionsSorters);
            for (String string : sectionsSorters) {
                String key2 = string.split(";")[1];
                this.m_sections.put(key2, (List<String>)sectionsUnsorted.get(key2));
                ObjectivePanel.this.m_statsObjective.put(key2, new LinkedHashMap());
                statsObjectiveUnsorted.put(key2, new HashMap());
            }
            block4: for (Map.Entry<Object, Object> entry : op.entrySet()) {
                AbstractConditionsAttachment attachment;
                PlayerID player;
                block21: {
                    fileKey = (String)entry.getKey();
                    if (!fileKey.startsWith(gameName)) continue;
                    key = fileKey.substring(gameName.length(), fileKey.length()).split(";");
                    value = (String)entry.getValue();
                    if (key.length != 2) {
                        System.err.println("objective.properties keys must be 2 parts: <game_name>.TABLEGROUP.<#>;player  OR  <game_name>.player;attachmentName");
                        continue;
                    }
                    if (key[0].startsWith("TABLEGROUP")) continue;
                    player = ObjectivePanel.this.m_data.getPlayerList().getPlayerID(key[0]);
                    if (player == null) {
                        System.err.println("objective.properties player does not exist: " + key[0]);
                        continue;
                    }
                    attachment = null;
                    try {
                        if (key[1].indexOf("objectiveAttachment") != -1 || key[1].indexOf("conditionAttachment") != -1) {
                            attachment = RulesAttachment.get(player, key[1], allPlayers);
                            break block21;
                        }
                        if (key[1].indexOf("triggerAttachment") != -1) {
                            attachment = TriggerAttachment.get(player, key[1], allPlayers);
                            break block21;
                        }
                        if (key[1].indexOf("politicalActionAttachment") != -1) {
                            attachment = PoliticalActionAttachment.get(player, key[1], allPlayers);
                            break block21;
                        }
                        System.err.println("objective.properties objective must begin with: objectiveAttachment or conditionAttachment or triggerAttachment or politicalActionAttachment");
                    }
                    catch (Exception e) {
                        System.err.println(e.getMessage());
                    }
                    continue;
                }
                if (attachment == null) {
                    System.err.println("objective.properties attachment does not exist: " + key[1]);
                    continue;
                }
                if (!ICondition.class.isAssignableFrom(attachment.getClass())) {
                    throw new IllegalStateException("(wtf??) attachment is not an ICondition: " + attachment.getName());
                }
                boolean found = false;
                if (this.m_sections.containsKey(player.getName()) && this.m_sections.get(player.getName()).contains(key[1])) {
                    Map map = (Map)statsObjectiveUnsorted.get(player.getName());
                    if (map == null) {
                        throw new IllegalStateException("objective.properties group has nothing: " + player.getName());
                    }
                    map.put((ICondition)attachment, value);
                    statsObjectiveUnsorted.put(player.getName(), map);
                    found = true;
                }
                if (found) continue;
                for (Map.Entry<String, List<String>> sectionEntry : this.m_sections.entrySet()) {
                    if (!sectionEntry.getValue().contains(key[1])) continue;
                    Map map = (Map)statsObjectiveUnsorted.get(sectionEntry.getKey());
                    if (map == null) {
                        throw new IllegalStateException("objective.properties group has nothing: " + sectionEntry.getKey());
                    }
                    map.put((ICondition)attachment, value);
                    statsObjectiveUnsorted.put(sectionEntry.getKey(), map);
                    continue block4;
                }
            }
            for (Map.Entry<Object, Object> entry : ObjectivePanel.this.m_statsObjective.entrySet()) {
                Map mapUnsorted = (Map)statsObjectiveUnsorted.get(entry.getKey());
                Map mapSorted = (Map)entry.getValue();
                block7: for (String conditionString : this.m_sections.get(entry.getKey())) {
                    Iterator conditionIter = mapUnsorted.keySet().iterator();
                    while (conditionIter.hasNext()) {
                        ICondition condition = (ICondition)conditionIter.next();
                        if (!conditionString.equals(condition.getName())) continue;
                        mapSorted.put(condition, mapUnsorted.get(condition));
                        conditionIter.remove();
                        continue block7;
                    }
                }
            }
        }

        @Override
        public synchronized Object getValueAt(int row, int col) {
            if (this.m_isDirty && Calendar.getInstance().getTimeInMillis() > this.m_timestamp + 10000L) {
                this.loadData();
                this.m_isDirty = false;
                this.m_timestamp = Calendar.getInstance().getTimeInMillis();
            }
            return this.m_collectedData[row][col];
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private synchronized void loadData() {
            ObjectivePanel.this.m_data.acquireReadLock();
            try {
                HashMap<ICondition, String> conditions = this.getConditionComment(this.getTestedConditions());
                this.m_collectedData = new String[this.getRowTotal()][2];
                int row = 0;
                for (Map.Entry mapEntry : ObjectivePanel.this.m_statsObjective.entrySet()) {
                    this.m_collectedData[row][1] = "<html><span style=\"font-size:140%\"><b><em>" + (String)mapEntry.getKey() + "</em></b></span></html>";
                    for (Map.Entry attachmentEntry : ((Map)mapEntry.getValue()).entrySet()) {
                        this.m_collectedData[++row][0] = conditions.get(attachmentEntry.getKey());
                        this.m_collectedData[row][1] = "<html>" + (String)attachmentEntry.getValue() + "</html>";
                    }
                    this.m_collectedData[++row][1] = "--------------------";
                    ++row;
                }
            }
            finally {
                ObjectivePanel.this.m_data.releaseReadLock();
            }
        }

        public HashMap<ICondition, String> getConditionComment(HashMap<ICondition, Boolean> testedConditions) {
            HashMap<ICondition, String> conditionsComments = new HashMap<ICondition, String>(testedConditions.size());
            for (Map.Entry<ICondition, Boolean> entry : testedConditions.entrySet()) {
                String comment;
                int uses;
                int each;
                boolean satisfied = entry.getValue();
                if (entry.getKey() instanceof TriggerAttachment) {
                    TriggerAttachment ta = (TriggerAttachment)entry.getKey();
                    each = TriggerAttachment.getEachMultiple(ta);
                    uses = ta.getUses();
                    if (uses < 0) {
                        comment = satisfied ? (each > 1 ? "T" + each : "T") : "F";
                        conditionsComments.put(entry.getKey(), comment);
                        continue;
                    }
                    if (uses == 0) {
                        comment = satisfied ? "Used" : "used";
                        conditionsComments.put(entry.getKey(), comment);
                        continue;
                    }
                    comment = uses + "" + (satisfied ? (each > 1 ? "T" + each : "T") : "F");
                    conditionsComments.put(entry.getKey(), comment);
                    continue;
                }
                if (entry.getKey() instanceof RulesAttachment) {
                    RulesAttachment ra = (RulesAttachment)entry.getKey();
                    each = ra.getEachMultiple();
                    uses = ra.getUses();
                    if (uses < 0) {
                        comment = satisfied ? (each > 1 ? "T" + each : "T") : "F";
                        conditionsComments.put(entry.getKey(), comment);
                        continue;
                    }
                    if (uses == 0) {
                        comment = satisfied ? "Used" : "used";
                        conditionsComments.put(entry.getKey(), comment);
                        continue;
                    }
                    comment = uses + "" + (satisfied ? (each > 1 ? "T" + each : "T") : "F");
                    conditionsComments.put(entry.getKey(), comment);
                    continue;
                }
                conditionsComments.put(entry.getKey(), entry.getValue().toString());
            }
            return conditionsComments;
        }

        public HashMap<ICondition, Boolean> getTestedConditions() {
            HashSet<ICondition> myConditions = new HashSet<ICondition>();
            for (Map map : ObjectivePanel.this.m_statsObjective.values()) {
                myConditions.addAll(map.keySet());
            }
            HashSet<ICondition> allConditionsNeeded = RulesAttachment.getAllConditionsRecursive(myConditions, null);
            return RulesAttachment.testAllConditionsRecursive(allConditionsNeeded, null, ObjectivePanel.this.m_dummyDelegate);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void gameDataChanged(Change aChange) {
            ObjectiveTableModel objectiveTableModel = this;
            synchronized (objectiveTableModel) {
                this.m_isDirty = true;
            }
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    ObjectivePanel.this.repaint();
                }
            });
        }

        @Override
        public String getColumnName(int col) {
            if (col == 0) {
                return "Done";
            }
            return "Objective Name";
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public synchronized int getRowCount() {
            if (!this.m_isDirty) {
                return this.m_collectedData.length;
            }
            ObjectivePanel.this.m_data.acquireReadLock();
            try {
                int n = this.getRowTotal();
                return n;
            }
            finally {
                ObjectivePanel.this.m_data.releaseReadLock();
            }
        }

        private int getRowTotal() {
            int rowsTotal = this.m_sections.size() * 2;
            for (Map map : ObjectivePanel.this.m_statsObjective.values()) {
                rowsTotal += map.size();
            }
            return rowsTotal;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized void setGameData(GameData data) {
            ObjectiveTableModel objectiveTableModel = this;
            synchronized (objectiveTableModel) {
                ObjectivePanel.this.m_data.removeDataChangeListener(this);
                ObjectivePanel.this.m_data = data;
                this.setObjectiveStats();
                ObjectivePanel.this.m_data.addDataChangeListener(this);
                this.m_isDirty = true;
            }
            ObjectivePanel.this.repaint();
        }
    }
}

