/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.triplea.ui;

import games.strategy.engine.data.GameData;
import games.strategy.engine.data.PlayerID;
import games.strategy.engine.data.PlayerManager;
import games.strategy.engine.framework.IGame;
import games.strategy.triplea.ui.UIContext;
import java.awt.Component;
import java.awt.Image;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;

public class PlayersPanel
extends JPanel {
    private static final long serialVersionUID = 9177417134839960231L;
    private final PlayerManager m_players;
    private final UIContext m_uiContext;

    public PlayersPanel(PlayerManager players, UIContext uiContext, GameData data) {
        this.m_players = players;
        this.m_uiContext = uiContext;
        this.setLayout(new BoxLayout(this, 1));
        for (String player : this.m_players.getPlayers()) {
            PlayerID playerID = data.getPlayerList().getPlayerID(player);
            Image img = this.m_uiContext.getFlagImageFactory().getFlag(playerID);
            this.add(new JLabel(this.m_players.getNode(player).getName(), new ImageIcon(img), 4));
        }
    }

    public static void showPlayers(IGame game, UIContext context, Component parent) {
        PlayersPanel panel = new PlayersPanel(game.getPlayerManager(), context, game.getData());
        JOptionPane.showMessageDialog(JOptionPane.getFrameForComponent(parent), panel, "Players", -1);
    }
}

