/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.triplea.ui;

import games.strategy.engine.data.GameData;
import games.strategy.engine.data.PlayerID;
import games.strategy.sound.ClipPlayer;
import games.strategy.triplea.attatchments.PoliticalActionAttachment;
import games.strategy.triplea.delegate.remote.IPoliticsDelegate;
import games.strategy.triplea.ui.ActionPanel;
import games.strategy.triplea.ui.MapPanel;
import games.strategy.triplea.ui.PoliticalActionComparator;
import games.strategy.triplea.ui.PoliticalStateOverview;
import games.strategy.triplea.ui.PoliticsText;
import games.strategy.triplea.ui.TripleAFrame;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.SwingUtilities;

public class PoliticsPanel
extends ActionPanel {
    private static final long serialVersionUID = -4661479948450261578L;
    private final JLabel m_actionLabel = new JLabel();
    private JButton m_selectPoliticalActionButton = null;
    private JButton m_doneButton = null;
    private PoliticalActionAttachment m_choice = null;
    private final TripleAFrame m_parent;
    private boolean m_firstRun = true;
    protected List<PoliticalActionAttachment> m_validPoliticalActions = null;
    private final Action SelectPoliticalActionAction = new AbstractAction("Do Politics..."){
        private static final long serialVersionUID = 3906101150281154032L;

        public void actionPerformed(ActionEvent event) {
            Dimension screenResolution = Toolkit.getDefaultToolkit().getScreenSize();
            int availHeight = screenResolution.height - 96;
            int availWidth = screenResolution.width - 30;
            int availHeightOverview = (int)((float)availHeight * 2.0f / 3.0f);
            int availHeightChoice = (int)((float)availHeight / 3.0f);
            final JDialog politicalChoiceDialog = new JDialog(PoliticsPanel.this.m_parent, "Political Actions", true);
            Insets insets = new Insets(1, 1, 1, 1);
            int row = 0;
            JPanel politicalChoicePanel = new JPanel();
            politicalChoicePanel.setLayout(new GridBagLayout());
            PoliticalStateOverview overview = new PoliticalStateOverview(PoliticsPanel.this.getData(), PoliticsPanel.this.getMap().getUIContext());
            JScrollPane overviewScroll = new JScrollPane(overview);
            overviewScroll.setBorder(BorderFactory.createEmptyBorder());
            overviewScroll.setPreferredSize(new Dimension(overviewScroll.getPreferredSize().width > availWidth ? availWidth : overviewScroll.getPreferredSize().width + (overviewScroll.getPreferredSize().height > availHeightOverview ? 20 : 0), overviewScroll.getPreferredSize().height > availHeightOverview ? availHeightOverview : overviewScroll.getPreferredSize().height + (PoliticsPanel.this.m_validPoliticalActions.isEmpty() ? 26 : 0) + (overviewScroll.getPreferredSize().width > availWidth ? 20 : 0)));
            JScrollPane choiceScroll = new JScrollPane(PoliticsPanel.this.PoliticalActionButtonPanel(politicalChoiceDialog));
            choiceScroll.setBorder(BorderFactory.createEmptyBorder());
            choiceScroll.setPreferredSize(new Dimension(choiceScroll.getPreferredSize().width > availWidth ? availWidth : choiceScroll.getPreferredSize().width + (choiceScroll.getPreferredSize().height > availHeightChoice ? 20 : 0), choiceScroll.getPreferredSize().height > availHeightChoice ? availHeightChoice : choiceScroll.getPreferredSize().height + (choiceScroll.getPreferredSize().width > availWidth ? 20 : 0)));
            JSplitPane splitPane = new JSplitPane(0, overviewScroll, choiceScroll);
            splitPane.setOneTouchExpandable(true);
            splitPane.setDividerSize(8);
            politicalChoicePanel.add((Component)splitPane, new GridBagConstraints(0, row++, 1, 1, 100.0, 100.0, 10, 1, insets, 0, 0));
            final JButton noActionButton = new JButton(new AbstractAction("No Actions"){
                private static final long serialVersionUID = -5979922310580413800L;

                public void actionPerformed(ActionEvent arg0) {
                    politicalChoiceDialog.setVisible(false);
                }
            });
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    noActionButton.requestFocusInWindow();
                }
            });
            politicalChoicePanel.add((Component)noActionButton, new GridBagConstraints(0, row, 20, 1, 1.0, 1.0, 13, 0, insets, 0, 0));
            politicalChoiceDialog.add(politicalChoicePanel);
            politicalChoiceDialog.pack();
            politicalChoiceDialog.setLocationRelativeTo(PoliticsPanel.this.m_parent);
            politicalChoiceDialog.setVisible(true);
            politicalChoiceDialog.dispose();
        }
    };
    private final Action DontBotherAction = new AbstractAction("Done"){
        private static final long serialVersionUID = 5975405674090929150L;

        public void actionPerformed(ActionEvent event) {
            if (!PoliticsPanel.this.m_firstRun || this.youSureDoNothing()) {
                PoliticsPanel.this.m_choice = null;
                PoliticsPanel.this.release();
            }
        }

        private boolean youSureDoNothing() {
            int rVal = JOptionPane.showConfirmDialog(JOptionPane.getFrameForComponent(PoliticsPanel.this), "Are you sure you dont want to do anything?", "End Politics", 0);
            return rVal == 0;
        }
    };

    public PoliticsPanel(GameData data, MapPanel map, TripleAFrame parent) {
        super(data, map);
        this.m_parent = parent;
    }

    public String toString() {
        return "Politics Panel";
    }

    public void display(final PlayerID id) {
        super.display(id);
        this.m_choice = null;
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                PoliticsPanel.this.removeAll();
                PoliticsPanel.this.m_actionLabel.setText(id.getName() + " Politics");
                PoliticsPanel.this.add(PoliticsPanel.this.m_actionLabel);
                PoliticsPanel.this.m_selectPoliticalActionButton = new JButton(PoliticsPanel.this.SelectPoliticalActionAction);
                PoliticsPanel.this.m_selectPoliticalActionButton.setEnabled(false);
                PoliticsPanel.this.add(PoliticsPanel.this.m_selectPoliticalActionButton);
                PoliticsPanel.this.m_doneButton = new JButton(PoliticsPanel.this.DontBotherAction);
                PoliticsPanel.this.m_doneButton.setEnabled(false);
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        PoliticsPanel.this.m_doneButton.requestFocusInWindow();
                    }
                });
                PoliticsPanel.this.add(PoliticsPanel.this.m_doneButton);
            }
        });
    }

    public PoliticalActionAttachment waitForPoliticalAction(boolean firstRun, IPoliticsDelegate iPoliticsDelegate) {
        this.m_firstRun = firstRun;
        this.m_validPoliticalActions = new ArrayList<PoliticalActionAttachment>(iPoliticsDelegate.getValidActions());
        Collections.sort(this.m_validPoliticalActions, new PoliticalActionComparator(this.getCurrentPlayer(), this.getData()));
        if (this.m_firstRun && this.m_validPoliticalActions.isEmpty()) {
            return null;
        }
        if (this.m_firstRun) {
            ClipPlayer.play("phase_politics", this.getCurrentPlayer().getName());
        }
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                PoliticsPanel.this.m_selectPoliticalActionButton.setEnabled(true);
                PoliticsPanel.this.m_doneButton.setEnabled(true);
                PoliticsPanel.this.SelectPoliticalActionAction.actionPerformed(null);
            }
        });
        this.waitForRelease();
        return this.m_choice;
    }

    private JPanel PoliticalActionButtonPanel(final JDialog parent) {
        JPanel politicalActionButtonPanel = new JPanel();
        politicalActionButtonPanel.setLayout(new GridBagLayout());
        int row = 0;
        Insets insets = new Insets(1, 1, 1, 1);
        for (final PoliticalActionAttachment paa : this.m_validPoliticalActions) {
            politicalActionButtonPanel.add((Component)this.getOtherPlayerFlags(paa), new GridBagConstraints(0, row, 1, 1, 1.0, 1.0, 17, 1, insets, 0, 0));
            JButton button = new JButton(this.getActionButtonText(paa));
            button.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent ae) {
                    PoliticsPanel.this.m_selectPoliticalActionButton.setEnabled(false);
                    PoliticsPanel.this.m_doneButton.setEnabled(false);
                    PoliticsPanel.this.m_validPoliticalActions = null;
                    PoliticsPanel.this.m_choice = paa;
                    parent.setVisible(false);
                    PoliticsPanel.this.release();
                }
            });
            politicalActionButtonPanel.add((Component)button, new GridBagConstraints(1, row, 1, 1, 1.0, 1.0, 17, 2, insets, 0, 0));
            politicalActionButtonPanel.add((Component)this.getActionDescriptionLabel(paa), new GridBagConstraints(2, row, 1, 1, 5.0, 1.0, 17, 1, insets, 0, 0));
            ++row;
        }
        return politicalActionButtonPanel;
    }

    private JPanel getOtherPlayerFlags(PoliticalActionAttachment paa) {
        JPanel panel = new JPanel();
        for (PlayerID p : paa.getOtherPlayers()) {
            panel.add(new JLabel(new ImageIcon(this.getMap().getUIContext().getFlagImageFactory().getFlag(p))));
        }
        return panel;
    }

    private String getActionButtonText(PoliticalActionAttachment paa) {
        String costString = paa.getCostPU() == 0 ? "" : "[" + paa.getCostPU() + " PU] ";
        return costString + PoliticsText.getInstance().getButtonText(paa.getText());
    }

    private JLabel getActionDescriptionLabel(PoliticalActionAttachment paa) {
        String chanceString = paa.toHit() == paa.diceSides() ? "" : "[" + paa.toHit() + "/" + paa.diceSides() + "] ";
        return new JLabel(chanceString + PoliticsText.getInstance().getDescription(paa.getText()));
    }
}

