/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.triplea.ui;

import games.strategy.engine.data.GameData;
import games.strategy.engine.data.PlayerID;
import games.strategy.engine.data.ProductionRule;
import games.strategy.engine.data.ResourceCollection;
import games.strategy.engine.data.UnitType;
import games.strategy.triplea.attatchments.UnitAttachment;
import games.strategy.triplea.ui.ProductionPanel;
import games.strategy.triplea.ui.ProductionTabsProperties;
import games.strategy.triplea.ui.UIContext;
import games.strategy.util.IntegerMap;
import games.strategy.util.Tuple;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TabbedProductionPanel
extends ProductionPanel {
    private static final long serialVersionUID = 3481282212500641144L;
    private int m_rows;
    private int m_columns;

    protected TabbedProductionPanel(UIContext uiContext) {
        super(uiContext);
    }

    public static IntegerMap<ProductionRule> getProduction(PlayerID id, JFrame parent, GameData data, boolean bid, IntegerMap<ProductionRule> initialPurchase, UIContext context) {
        return new TabbedProductionPanel(context).show(id, parent, data, bid, initialPurchase);
    }

    @Override
    protected void initLayout(PlayerID id) {
        this.removeAll();
        this.setLayout(new GridBagLayout());
        ResourceCollection totalWithoutTechTokensOrVPs = new ResourceCollection(this.getResources());
        this.m_data.acquireReadLock();
        totalWithoutTechTokensOrVPs.removeAllOfResource(this.m_data.getResourceList().getResource("VPs"));
        totalWithoutTechTokensOrVPs.removeAllOfResource(this.m_data.getResourceList().getResource("techTokens"));
        this.m_data.releaseReadLock();
        this.add((Component)new JLabel("<html>Attack/Defense/Movement. &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; (Total Resources: " + totalWithoutTechTokensOrVPs.toString() + ")</html>"), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 13, 2, new Insets(8, 8, 8, 0), 0, 0));
        JTabbedPane tabs = new JTabbedPane();
        this.add((Component)tabs, new GridBagConstraints(0, 1, 1, 1, 100.0, 100.0, 13, 1, new Insets(8, 8, 8, 0), 0, 0));
        ProductionTabsProperties properties = ProductionTabsProperties.getInstance(this.m_id, this.m_rules);
        List<Tuple<String, List<ProductionPanel.Rule>>> ruleLists = this.getRuleLists(properties);
        this.calculateXY(properties, this.largestList(ruleLists));
        for (Tuple<String, List<ProductionPanel.Rule>> ruleList : ruleLists) {
            if (ruleList.getSecond().size() <= 0) continue;
            tabs.addTab(ruleList.getFirst(), new JScrollPane(this.getRulesPanel(ruleList.getSecond())));
        }
        this.add((Component)this.m_left, new GridBagConstraints(0, 2, 1, 1, 1.0, 1.0, 17, 0, new Insets(8, 8, 0, 12), 0, 0));
        this.m_done = new JButton(this.m_done_action);
        this.add((Component)this.m_done, new GridBagConstraints(0, 3, 1, 1, 1.0, 1.0, 10, 0, new Insets(0, 0, 8, 0), 0, 0));
        Dimension dtab = tabs.getPreferredSize();
        Dimension dthis = this.getPreferredSize();
        if (dtab != null && dthis != null) {
            tabs.setPreferredSize(new Dimension(dtab.width + 4, dtab.height + 4));
            this.setPreferredSize(new Dimension(dthis.width + 8, dthis.height + 24));
        }
        tabs.validate();
        this.validate();
    }

    private void calculateXY(ProductionTabsProperties properties, int largestList) {
        if (properties == null || properties.getRows() == 0 || properties.getColumns() == 0 || properties.getRows() * properties.getColumns() < largestList) {
            int m_maxColumns = largestList <= 36 ? Math.max(8, Math.min(12, new BigDecimal(largestList).divide(new BigDecimal(3), 0).intValue())) : (largestList <= 64 ? Math.max(8, Math.min(16, new BigDecimal(largestList).divide(new BigDecimal(4), 0).intValue())) : Math.max(8, Math.min(16, new BigDecimal(largestList).divide(new BigDecimal(5), 0).intValue())));
            this.m_rows = Math.max(2, new BigDecimal(largestList).divide(new BigDecimal(m_maxColumns), 0).intValue());
            this.m_columns = Math.max(3, new BigDecimal(largestList).divide(new BigDecimal(this.m_rows), 0).intValue());
        } else {
            this.m_rows = Math.max(2, properties.getRows());
            this.m_columns = Math.max(3, properties.getColumns());
        }
    }

    private int largestList(List<Tuple<String, List<ProductionPanel.Rule>>> ruleLists) {
        int largestList = 0;
        for (Tuple<String, List<ProductionPanel.Rule>> tuple : ruleLists) {
            if (largestList >= tuple.getSecond().size()) continue;
            largestList = tuple.getSecond().size();
        }
        return largestList;
    }

    private void checkLists(List<Tuple<String, List<ProductionPanel.Rule>>> ruleLists) {
        ArrayList rulesCopy = new ArrayList(this.m_rules);
        for (Tuple<String, List<ProductionPanel.Rule>> tuple : ruleLists) {
            for (ProductionPanel.Rule rule : tuple.getSecond()) {
                rulesCopy.remove(rule);
            }
        }
        if (rulesCopy.size() > 0) {
            throw new IllegalStateException("production_tabs: must include all player production rules/units");
        }
    }

    private List<Tuple<String, List<ProductionPanel.Rule>>> getRuleLists(ProductionTabsProperties properties) {
        if (properties != null && !properties.useDefaultTabs()) {
            List<Tuple<String, List<ProductionPanel.Rule>>> ruleLists = properties.getRuleLists();
            this.checkLists(ruleLists);
            return ruleLists;
        }
        return this.getDefaultRuleLists();
    }

    private List<Tuple<String, List<ProductionPanel.Rule>>> getDefaultRuleLists() {
        ArrayList<Tuple<String, List<ProductionPanel.Rule>>> ruleLists = new ArrayList<Tuple<String, List<ProductionPanel.Rule>>>();
        ArrayList<ProductionPanel.Rule> allRules = new ArrayList<ProductionPanel.Rule>();
        ArrayList<ProductionPanel.Rule> landRules = new ArrayList<ProductionPanel.Rule>();
        ArrayList<ProductionPanel.Rule> airRules = new ArrayList<ProductionPanel.Rule>();
        ArrayList<ProductionPanel.Rule> seaRules = new ArrayList<ProductionPanel.Rule>();
        ArrayList<ProductionPanel.Rule> constructRules = new ArrayList<ProductionPanel.Rule>();
        ArrayList<ProductionPanel.Rule> upgradeConsumesRules = new ArrayList<ProductionPanel.Rule>();
        for (ProductionPanel.Rule rule : this.m_rules) {
            UnitType type = (UnitType)rule.getProductionRule().getResults().keySet().iterator().next();
            UnitAttachment attach = UnitAttachment.get(type);
            allRules.add(rule);
            if (attach.getConsumesUnits() != null && attach.getConsumesUnits().totalValues() >= 1) {
                upgradeConsumesRules.add(rule);
            }
            if (attach.getIsConstruction()) {
                constructRules.add(rule);
                continue;
            }
            if (attach.getIsSea()) {
                seaRules.add(rule);
                continue;
            }
            if (attach.getIsAir()) {
                airRules.add(rule);
                continue;
            }
            landRules.add(rule);
        }
        ruleLists.add(new Tuple("All", allRules));
        ruleLists.add(new Tuple("Land", landRules));
        ruleLists.add(new Tuple("Air", airRules));
        ruleLists.add(new Tuple("Sea", seaRules));
        ruleLists.add(new Tuple("Construction", constructRules));
        ruleLists.add(new Tuple("Upgrades/Consumes", upgradeConsumesRules));
        return ruleLists;
    }

    private JPanel getRulesPanel(List<ProductionPanel.Rule> rules) {
        JPanel panel = new JPanel();
        panel.setLayout(new GridLayout(this.m_rows, this.m_columns));
        JPanel[][] panelHolder = new JPanel[this.m_rows][this.m_columns];
        for (int m = 0; m < this.m_rows; ++m) {
            for (int n = 0; n < this.m_columns; ++n) {
                panelHolder[m][n] = new JPanel(new BorderLayout());
                panel.add(panelHolder[m][n]);
            }
        }
        for (int x = 0; x < this.m_columns * this.m_rows; ++x) {
            if (x >= rules.size()) continue;
            panelHolder[x % this.m_rows][x / this.m_rows].add(rules.get(x).getPanelComponent());
        }
        return panel;
    }
}

