/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.triplea.ui;

import games.strategy.common.ui.MacWrapper;
import games.strategy.common.ui.MainGameFrame;
import games.strategy.engine.chat.ChatPanel;
import games.strategy.engine.chat.PlayerChatRenderer;
import games.strategy.engine.data.Change;
import games.strategy.engine.data.ChangeFactory;
import games.strategy.engine.data.GameData;
import games.strategy.engine.data.PlayerID;
import games.strategy.engine.data.ProductionRule;
import games.strategy.engine.data.RepairRule;
import games.strategy.engine.data.Resource;
import games.strategy.engine.data.ResourceCollection;
import games.strategy.engine.data.Route;
import games.strategy.engine.data.Territory;
import games.strategy.engine.data.TerritoryEffect;
import games.strategy.engine.data.Unit;
import games.strategy.engine.data.events.GameDataChangeListener;
import games.strategy.engine.data.events.GameStepListener;
import games.strategy.engine.framework.ClientGame;
import games.strategy.engine.framework.GameDataUtils;
import games.strategy.engine.framework.GameRunner;
import games.strategy.engine.framework.HistorySynchronizer;
import games.strategy.engine.framework.IGame;
import games.strategy.engine.framework.ServerGame;
import games.strategy.engine.framework.startup.ui.MainFrame;
import games.strategy.engine.framework.ui.SaveGameFileChooser;
import games.strategy.engine.gamePlayer.IGamePlayer;
import games.strategy.engine.gamePlayer.IPlayerBridge;
import games.strategy.engine.history.HistoryNode;
import games.strategy.engine.history.Renderable;
import games.strategy.engine.history.Round;
import games.strategy.engine.history.Step;
import games.strategy.sound.ClipPlayer;
import games.strategy.triplea.Properties;
import games.strategy.triplea.TripleAPlayer;
import games.strategy.triplea.attatchments.PoliticalActionAttachment;
import games.strategy.triplea.attatchments.TerritoryAttachment;
import games.strategy.triplea.attatchments.UnitAttachment;
import games.strategy.triplea.delegate.AirThatCantLandUtil;
import games.strategy.triplea.delegate.BattleCalculator;
import games.strategy.triplea.delegate.BattleDelegate;
import games.strategy.triplea.delegate.EditDelegate;
import games.strategy.triplea.delegate.Matches;
import games.strategy.triplea.delegate.UnitBattleComparator;
import games.strategy.triplea.delegate.dataObjects.FightBattleDetails;
import games.strategy.triplea.delegate.dataObjects.MoveDescription;
import games.strategy.triplea.delegate.dataObjects.TechResults;
import games.strategy.triplea.delegate.dataObjects.TechRoll;
import games.strategy.triplea.delegate.remote.IEditDelegate;
import games.strategy.triplea.delegate.remote.IPoliticsDelegate;
import games.strategy.triplea.formatter.MyFormatter;
import games.strategy.triplea.image.TileImageFactory;
import games.strategy.triplea.ui.AbstractMovePanel;
import games.strategy.triplea.ui.ActionButtons;
import games.strategy.triplea.ui.BattlePanel;
import games.strategy.triplea.ui.CommentPanel;
import games.strategy.triplea.ui.DefaultMapSelectionListener;
import games.strategy.triplea.ui.DiceChooser;
import games.strategy.triplea.ui.EconomyPanel;
import games.strategy.triplea.ui.EditPanel;
import games.strategy.triplea.ui.IndividualUnitPanelGrouped;
import games.strategy.triplea.ui.MapPanel;
import games.strategy.triplea.ui.MapPanelSmallView;
import games.strategy.triplea.ui.MapSelectionListener;
import games.strategy.triplea.ui.MouseDetails;
import games.strategy.triplea.ui.MouseOverUnitListener;
import games.strategy.triplea.ui.NotesPanel;
import games.strategy.triplea.ui.ObjectivePanel;
import games.strategy.triplea.ui.PlaceData;
import games.strategy.triplea.ui.PlacePanel;
import games.strategy.triplea.ui.PurchasePanel;
import games.strategy.triplea.ui.StatPanel;
import games.strategy.triplea.ui.TechPanel;
import games.strategy.triplea.ui.TechResultsDisplay;
import games.strategy.triplea.ui.TerritoryDetailPanel;
import games.strategy.triplea.ui.TripleaMenu;
import games.strategy.triplea.ui.UIContext;
import games.strategy.triplea.ui.UnitChooser;
import games.strategy.triplea.ui.history.HistoryDetailsPanel;
import games.strategy.triplea.ui.history.HistoryLog;
import games.strategy.triplea.ui.history.HistoryPanel;
import games.strategy.ui.ImageScrollModel;
import games.strategy.ui.ScrollableTextField;
import games.strategy.ui.Util;
import games.strategy.util.EventThreadJOptionPane;
import games.strategy.util.IntegerMap;
import games.strategy.util.Tuple;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicReference;
import javax.imageio.ImageIO;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ButtonModel;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JToggleButton;
import javax.swing.JToolTip;
import javax.swing.KeyStroke;
import javax.swing.Popup;
import javax.swing.PopupFactory;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import javax.swing.border.EtchedBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import javax.swing.tree.TreeNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TripleAFrame
extends MainGameFrame {
    private static final long serialVersionUID = 7640069668264418976L;
    private GameData m_data;
    private IGame m_game;
    private MapPanel m_mapPanel;
    private MapPanelSmallView m_smallView;
    private JLabel m_message = new JLabel("No selection");
    private JLabel m_status = new JLabel("");
    private JLabel m_step = new JLabel("xxxxxx");
    private JLabel m_round = new JLabel("xxxxxx");
    private JLabel m_player = new JLabel("xxxxxx");
    private ActionButtons m_actionButtons;
    private Set<IGamePlayer> m_localPlayers;
    private JPanel m_gameMainPanel = new JPanel();
    private JPanel m_rightHandSidePanel = new JPanel();
    private JTabbedPane m_tabsPanel = new JTabbedPane();
    private StatPanel m_statsPanel;
    private EconomyPanel m_economyPanel;
    private ObjectivePanel m_objectivePanel;
    private NotesPanel m_notesPanel;
    private TerritoryDetailPanel m_details;
    private JPanel m_historyComponent = new JPanel();
    private JPanel m_gameSouthPanel;
    private HistoryPanel m_historyPanel;
    private boolean m_inHistory = false;
    private boolean m_inGame = true;
    private HistorySynchronizer m_historySyncher;
    private UIContext m_uiContext;
    private JPanel m_mapAndChatPanel;
    private ChatPanel m_chatPanel;
    private CommentPanel m_commentPanel;
    private JSplitPane m_chatSplit;
    private JSplitPane m_commentSplit;
    private EditPanel m_editPanel;
    private final ButtonModel m_editModeButtonModel;
    private final ButtonModel m_showCommentLogButtonModel;
    private IEditDelegate m_editDelegate;
    private JSplitPane m_gameCenterPanel;
    private Territory m_territoryLastEntered;
    private List<Unit> m_unitsBeingMousedOver;
    private PlayerID m_lastStepPlayer;
    private WindowListener WINDOW_LISTENER = new WindowAdapter(){

        public void windowClosing(WindowEvent e) {
            TripleAFrame.this.leaveGame();
        }
    };
    private final MouseOverUnitListener MOUSE_OVER_UNIT_LISTENER = new MouseOverUnitListener(){

        @Override
        public void mouseEnter(List<Unit> units, Territory territory, MouseDetails me) {
            TripleAFrame.this.m_unitsBeingMousedOver = units;
        }
    };
    public MapSelectionListener MAP_SELECTION_LISTENER = new DefaultMapSelectionListener(){

        public void mouseEntered(Territory territory) {
            TripleAFrame.this.m_territoryLastEntered = territory;
            this.refresh();
        }

        void refresh() {
            TerritoryAttachment ta;
            StringBuilder buf = new StringBuilder(" ");
            buf.append(TripleAFrame.this.m_territoryLastEntered == null ? "none" : TripleAFrame.this.m_territoryLastEntered.getName());
            if (TripleAFrame.this.m_territoryLastEntered != null && (ta = TerritoryAttachment.get(TripleAFrame.this.m_territoryLastEntered)) != null) {
                Iterator<TerritoryEffect> iter = ta.getTerritoryEffect().iterator();
                if (iter.hasNext()) {
                    buf.append(" (");
                }
                while (iter.hasNext()) {
                    buf.append(iter.next().getName());
                    if (iter.hasNext()) {
                        buf.append(", ");
                        continue;
                    }
                    buf.append(")");
                }
                int production = ta.getProduction();
                int unitProduction = ta.getUnitProduction();
                ResourceCollection resource = ta.getResources();
                if (unitProduction > 0 && unitProduction != production) {
                    buf.append(", UnitProd: " + unitProduction);
                }
                if (production > 0 || resource != null && resource.toString().length() > 0) {
                    buf.append(", Prod: ");
                    if (production > 0) {
                        buf.append(production + " PUs");
                        if (resource != null && resource.toString().length() > 0) {
                            buf.append(", ");
                        }
                    }
                    if (resource != null) {
                        buf.append(resource.toString());
                    }
                }
            }
            TripleAFrame.this.m_message.setText(buf.toString());
        }
    };
    GameStepListener m_stepListener = new GameStepListener(){

        public void gameStepChanged(String stepName, String delegateName, PlayerID player, int round, String stepDisplayName) {
            TripleAFrame.this.updateStep();
        }
    };
    GameDataChangeListener m_dataChangeListener = new GameDataChangeListener(){

        public void gameDataChanged(Change change) {
            try {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        if (TripleAFrame.this.m_uiContext == null) {
                            return;
                        }
                        if (TripleAFrame.this.getEditMode()) {
                            if (TripleAFrame.this.m_tabsPanel.indexOfComponent(TripleAFrame.this.m_editPanel) == -1) {
                                TripleAFrame.this.showEditMode();
                            }
                        } else if (TripleAFrame.this.m_tabsPanel.indexOfComponent(TripleAFrame.this.m_editPanel) != -1) {
                            TripleAFrame.this.hideEditMode();
                        }
                        if (TripleAFrame.this.m_uiContext.getShowMapOnly()) {
                            Object details;
                            TripleAFrame.this.hideRightHandSidePanel();
                            HistoryNode node = TripleAFrame.this.m_data.getHistory().getLastNode();
                            if (node instanceof Renderable && (details = ((Renderable)((Object)node)).getRenderingData()) instanceof MoveDescription) {
                                MoveDescription moveMessage = (MoveDescription)details;
                                Route route = moveMessage.getRoute();
                                TripleAFrame.this.m_mapPanel.setRoute(null);
                                TripleAFrame.this.m_mapPanel.setRoute(route);
                                Territory terr = route.getEnd();
                                if (!TripleAFrame.this.m_mapPanel.isShowing(terr)) {
                                    TripleAFrame.this.m_mapPanel.centerOn(terr);
                                }
                            }
                        } else {
                            TripleAFrame.this.showRightHandSidePanel();
                        }
                    }
                });
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    };
    final KeyListener m_arrowKeyActionListener = new KeyListener(){
        final int diffPixel = 50;

        public void keyPressed(KeyEvent e) {
            int x = TripleAFrame.this.m_mapPanel.getXOffset();
            int y = TripleAFrame.this.m_mapPanel.getYOffset();
            int keyCode = e.getKeyCode();
            if (keyCode == 39 || keyCode == 68) {
                TripleAFrame.this.getMapPanel().setTopLeft(x + 50, y);
            } else if (keyCode == 37 || keyCode == 65) {
                TripleAFrame.this.getMapPanel().setTopLeft(x - 50, y);
            } else if (keyCode == 40 || keyCode == 83) {
                TripleAFrame.this.getMapPanel().setTopLeft(x, y + 50);
            } else if (keyCode == 38 || keyCode == 87) {
                TripleAFrame.this.getMapPanel().setTopLeft(x, y - 50);
            }
            if (keyCode == 73) {
                Unit unit;
                UnitAttachment ua;
                String unitInfo = "";
                if (TripleAFrame.this.m_unitsBeingMousedOver != null && !TripleAFrame.this.m_unitsBeingMousedOver.isEmpty() && (ua = UnitAttachment.get((unit = (Unit)TripleAFrame.this.m_unitsBeingMousedOver.get(0)).getType())) != null) {
                    unitInfo = "<b>Unit:</b><br>" + unit.getType().getName() + ": " + ua.toStringShortAndOnlyImportantDifferences(unit.getOwner(), true, false);
                }
                String terrInfo = "";
                if (TripleAFrame.this.m_territoryLastEntered != null) {
                    TerritoryAttachment ta = TerritoryAttachment.get(TripleAFrame.this.m_territoryLastEntered);
                    terrInfo = ta != null ? "<b>Territory:</b><br>" + ta.toStringForInfo(true, true) + "<br>" : "<b>Territory:</b><br>" + TripleAFrame.this.m_territoryLastEntered.getName() + "<br>Water Territory";
                }
                String tipText = unitInfo;
                if (unitInfo.length() > 0 && terrInfo.length() > 0) {
                    tipText = tipText + "<br><br><br><br><br>";
                }
                if ((tipText = tipText + terrInfo).length() > 0) {
                    Point currentPoint = MouseInfo.getPointerInfo().getLocation();
                    PopupFactory popupFactory = PopupFactory.getSharedInstance();
                    JToolTip info = new JToolTip();
                    info.setTipText("<html>" + tipText + "</html>");
                    final Popup popup = popupFactory.getPopup(TripleAFrame.this.m_mapPanel, info, currentPoint.x, currentPoint.y);
                    popup.show();
                    Runnable disposePopup = new Runnable(){

                        public void run() {
                            try {
                                Thread.sleep(5000L);
                            }
                            catch (InterruptedException interruptedException) {
                                // empty catch block
                            }
                            popup.hide();
                        }
                    };
                    new Thread(disposePopup, "popup waiter").start();
                }
            }
            TripleAFrame.this.m_actionButtons.keyPressed(e);
        }

        public void keyTyped(KeyEvent e) {
        }

        public void keyReleased(KeyEvent e) {
        }
    };
    private AbstractAction m_showCommentLogAction = new AbstractAction(){
        private static final long serialVersionUID = 3964381772343872268L;

        public void actionPerformed(ActionEvent ae) {
            if (((ButtonModel)ae.getSource()).isSelected()) {
                this.showCommentLog();
            } else {
                this.hideCommentLog();
            }
        }

        private void hideCommentLog() {
            if (TripleAFrame.this.m_chatPanel != null) {
                TripleAFrame.this.m_commentSplit.setBottomComponent(null);
                TripleAFrame.this.m_chatSplit.setBottomComponent(TripleAFrame.this.m_chatPanel);
                TripleAFrame.this.m_chatSplit.validate();
            } else {
                TripleAFrame.this.m_mapAndChatPanel.removeAll();
                TripleAFrame.this.m_chatSplit.setTopComponent(null);
                TripleAFrame.this.m_chatSplit.setBottomComponent(null);
                TripleAFrame.this.m_mapAndChatPanel.add((Component)TripleAFrame.this.m_mapPanel, "Center");
                TripleAFrame.this.m_mapAndChatPanel.validate();
            }
        }

        private void showCommentLog() {
            if (TripleAFrame.this.m_chatPanel != null) {
                TripleAFrame.this.m_commentSplit.setBottomComponent(TripleAFrame.this.m_chatPanel);
                TripleAFrame.this.m_chatSplit.setBottomComponent(TripleAFrame.this.m_commentSplit);
                TripleAFrame.this.m_chatSplit.validate();
            } else {
                TripleAFrame.this.m_mapAndChatPanel.removeAll();
                TripleAFrame.this.m_chatSplit.setTopComponent(TripleAFrame.this.m_mapPanel);
                TripleAFrame.this.m_chatSplit.setBottomComponent(TripleAFrame.this.m_commentPanel);
                TripleAFrame.this.m_mapAndChatPanel.add((Component)TripleAFrame.this.m_chatSplit, "Center");
                TripleAFrame.this.m_mapAndChatPanel.validate();
            }
        }
    };
    private AbstractAction m_showHistoryAction = new AbstractAction("Show history"){
        private static final long serialVersionUID = -3960551522512897374L;

        public void actionPerformed(ActionEvent e) {
            TripleAFrame.this.showHistory();
            TripleAFrame.this.m_dataChangeListener.gameDataChanged(ChangeFactory.EMPTY_CHANGE);
        }
    };
    private AbstractAction m_showGameAction = new AbstractAction("Show current game"){
        private static final long serialVersionUID = -7551760679570164254L;
        {
            this.setEnabled(false);
        }

        public void actionPerformed(ActionEvent e) {
            TripleAFrame.this.showGame();
            TripleAFrame.this.m_dataChangeListener.gameDataChanged(ChangeFactory.EMPTY_CHANGE);
        }
    };
    private AbstractAction m_showMapOnlyAction = new AbstractAction("Show map only"){
        private static final long serialVersionUID = -6621157075878333141L;

        public void actionPerformed(ActionEvent e) {
            TripleAFrame.this.showMapOnly();
            TripleAFrame.this.m_dataChangeListener.gameDataChanged(ChangeFactory.EMPTY_CHANGE);
        }
    };
    private final AbstractAction m_saveScreenshotAction = new AbstractAction("Export Screenshot..."){
        private static final long serialVersionUID = -5908032486008953815L;

        public void actionPerformed(ActionEvent e) {
            HistoryNode curNode = null;
            curNode = TripleAFrame.this.m_historyPanel == null ? TripleAFrame.this.m_data.getHistory().getLastNode() : TripleAFrame.this.m_historyPanel.getCurrentNode();
            TripleAFrame.this.saveScreenshot(curNode);
        }
    };

    public TripleAFrame(IGame game, Set<IGamePlayer> players) throws IOException {
        super("TripleA - " + game.getData().getGameName());
        this.setIconImage(GameRunner.getGameIcon(this));
        this.m_game = game;
        this.m_data = game.getData();
        this.m_localPlayers = players;
        this.addZoomKeyboardShortcuts();
        this.setDefaultCloseOperation(0);
        this.addWindowListener(this.WINDOW_LISTENER);
        this.m_uiContext = new UIContext();
        this.m_uiContext.setDefaultMapDir(game.getData());
        this.m_uiContext.getMapData().verify(this.m_data);
        this.m_uiContext.setPlayerList(players);
        this.setCursor(this.m_uiContext.getCursor());
        this.m_editModeButtonModel = new JToggleButton.ToggleButtonModel();
        this.m_editModeButtonModel.setEnabled(false);
        this.m_showCommentLogButtonModel = new JToggleButton.ToggleButtonModel();
        this.m_showCommentLogButtonModel.addActionListener(this.m_showCommentLogAction);
        this.m_showCommentLogButtonModel.setSelected(false);
        this.createMenuBar();
        ImageScrollModel model = new ImageScrollModel();
        model.setScrollX(this.m_uiContext.getMapData().scrollWrapX());
        model.setScrollY(this.m_uiContext.getMapData().scrollWrapY());
        model.setMaxBounds(this.m_uiContext.getMapData().getMapDimensions().width, this.m_uiContext.getMapData().getMapDimensions().height);
        BufferedImage small = this.m_uiContext.getMapImage().getSmallMapImage();
        this.m_smallView = new MapPanelSmallView(small, model);
        this.m_mapPanel = new MapPanel(this.m_data, this.m_smallView, this.m_uiContext, model);
        this.m_mapPanel.addMapSelectionListener(this.MAP_SELECTION_LISTENER);
        this.m_mapPanel.addMouseOverUnitListener(this.MOUSE_OVER_UNIT_LISTENER);
        this.addKeyListener(this.m_arrowKeyActionListener);
        this.m_mapPanel.addKeyListener(this.m_arrowKeyActionListener);
        this.m_mapPanel.initSmallMap();
        this.m_mapAndChatPanel = new JPanel();
        this.m_mapAndChatPanel.setLayout(new BorderLayout());
        this.m_commentPanel = new CommentPanel(this, this.m_data);
        this.m_chatSplit = new JSplitPane();
        this.m_chatSplit.setOrientation(0);
        this.m_chatSplit.setOneTouchExpandable(true);
        this.m_chatSplit.setDividerSize(8);
        this.m_chatSplit.setResizeWeight(0.95);
        if (MainFrame.getInstance().getChat() != null) {
            this.m_commentSplit = new JSplitPane();
            this.m_commentSplit.setOrientation(0);
            this.m_commentSplit.setOneTouchExpandable(true);
            this.m_commentSplit.setDividerSize(8);
            this.m_commentSplit.setResizeWeight(0.5);
            this.m_commentSplit.setTopComponent(this.m_commentPanel);
            this.m_commentSplit.setBottomComponent(null);
            this.m_chatPanel = new ChatPanel(MainFrame.getInstance().getChat());
            this.m_chatPanel.setPlayerRenderer(new PlayerChatRenderer(this.m_game, this.m_uiContext));
            Dimension chatPrefSize = new Dimension((int)this.m_chatPanel.getPreferredSize().getWidth(), 95);
            this.m_chatPanel.setPreferredSize(chatPrefSize);
            this.m_chatSplit.setTopComponent(this.m_mapPanel);
            this.m_chatSplit.setBottomComponent(this.m_chatPanel);
            this.m_mapAndChatPanel.add((Component)this.m_chatSplit, "Center");
        } else {
            this.m_mapAndChatPanel.add((Component)this.m_mapPanel, "Center");
        }
        this.m_gameMainPanel.setLayout(new BorderLayout());
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)this.m_gameMainPanel, "Center");
        this.m_gameSouthPanel = new JPanel();
        this.m_gameSouthPanel.setLayout(new BorderLayout());
        this.m_gameSouthPanel.add((Component)this.m_message, "West");
        this.m_message.setBorder(new EtchedBorder(0));
        this.m_message.setText("some text to set a reasonable preferred size");
        this.m_message.setPreferredSize(this.m_message.getPreferredSize());
        this.m_message.setText("");
        this.m_gameSouthPanel.add((Component)this.m_status, "Center");
        this.m_status.setBorder(new EtchedBorder(0));
        JPanel stepPanel = new JPanel();
        stepPanel.setLayout(new GridBagLayout());
        stepPanel.add((Component)this.m_step, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 13, 1, new Insets(0, 0, 0, 0), 0, 0));
        stepPanel.add((Component)this.m_player, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 1, new Insets(0, 0, 0, 0), 0, 0));
        stepPanel.add((Component)this.m_round, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 13, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.m_step.setBorder(new EtchedBorder(0));
        this.m_round.setBorder(new EtchedBorder(0));
        this.m_player.setBorder(new EtchedBorder(0));
        this.m_step.setHorizontalTextPosition(10);
        this.m_gameSouthPanel.add((Component)stepPanel, "East");
        this.m_gameMainPanel.add((Component)this.m_gameSouthPanel, "South");
        this.m_rightHandSidePanel.setLayout(new BorderLayout());
        FocusAdapter focusToMapPanelFocusListener = new FocusAdapter(){

            public void focusGained(FocusEvent e) {
                TripleAFrame.this.m_mapPanel.requestFocusInWindow();
            }
        };
        this.m_smallView.addFocusListener(focusToMapPanelFocusListener);
        this.m_tabsPanel.addFocusListener(focusToMapPanelFocusListener);
        this.m_rightHandSidePanel.add((Component)this.m_smallView, "North");
        this.m_tabsPanel.setBorder(null);
        this.m_rightHandSidePanel.add((Component)this.m_tabsPanel, "Center");
        this.m_actionButtons = new ActionButtons(this.m_data, this.m_mapPanel, this);
        this.m_tabsPanel.addTab("Actions", this.m_actionButtons);
        this.m_actionButtons.setBorder(null);
        this.m_statsPanel = new StatPanel(this.m_data, this.m_uiContext);
        this.m_tabsPanel.addTab("Stats", this.m_statsPanel);
        this.m_economyPanel = new EconomyPanel(this.m_data);
        this.m_tabsPanel.addTab("Economy", this.m_economyPanel);
        this.m_objectivePanel = new ObjectivePanel(this.m_data);
        if (this.m_objectivePanel.isEmpty()) {
            this.m_objectivePanel.removeDataChangeListener();
            this.m_objectivePanel = null;
        } else {
            this.m_tabsPanel.addTab(this.m_objectivePanel.getName(), this.m_objectivePanel);
        }
        this.m_notesPanel = new NotesPanel(this.m_data);
        this.m_tabsPanel.addTab("Notes", this.m_notesPanel);
        this.m_details = new TerritoryDetailPanel(this.m_mapPanel, this.m_data, this.m_uiContext, this);
        this.m_tabsPanel.addTab("Territory", this.m_details);
        this.m_editPanel = new EditPanel(this.m_data, this.m_mapPanel, this);
        this.m_tabsPanel.addChangeListener(new ChangeListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void stateChanged(ChangeEvent evt) {
                JTabbedPane pane = (JTabbedPane)evt.getSource();
                int sel = pane.getSelectedIndex();
                if (sel == -1) {
                    return;
                }
                if (pane.getComponentAt(sel).equals(TripleAFrame.this.m_editPanel)) {
                    PlayerID player = null;
                    TripleAFrame.this.m_data.acquireReadLock();
                    try {
                        player = TripleAFrame.this.m_data.getSequence().getStep().getPlayerID();
                    }
                    finally {
                        TripleAFrame.this.m_data.releaseReadLock();
                    }
                    TripleAFrame.this.m_actionButtons.getCurrent().setActive(false);
                    TripleAFrame.this.m_editPanel.display(player);
                } else {
                    TripleAFrame.this.m_actionButtons.getCurrent().setActive(true);
                    TripleAFrame.this.m_editPanel.setActive(false);
                }
            }
        });
        this.m_rightHandSidePanel.setPreferredSize(new Dimension((int)this.m_smallView.getPreferredSize().getWidth(), (int)this.m_mapPanel.getPreferredSize().getHeight()));
        this.m_gameCenterPanel = new JSplitPane(1, this.m_mapAndChatPanel, this.m_rightHandSidePanel);
        this.m_gameCenterPanel.setOneTouchExpandable(true);
        this.m_gameCenterPanel.setDividerSize(8);
        this.m_gameCenterPanel.setResizeWeight(1.0);
        this.m_gameMainPanel.add((Component)this.m_gameCenterPanel, "Center");
        this.m_gameCenterPanel.resetToPreferredSizes();
        this.setGlassPane(new JComponent(){
            private static final long serialVersionUID = 6724687534214427291L;

            protected void paintComponent(Graphics g) {
                g.setFont(new Font("Ariel", 1, 50));
                g.setColor(new Color(255, 255, 255, 175));
                Dimension size = TripleAFrame.this.m_mapPanel.getSize();
                g.drawString("Edit Mode", (int)((size.getWidth() - 200.0) / 2.0), (int)((size.getHeight() - 100.0) / 2.0));
            }
        });
        this.m_dataChangeListener.gameDataChanged(ChangeFactory.EMPTY_CHANGE);
        this.m_data.addDataChangeListener(this.m_dataChangeListener);
        game.addGameStepListener(this.m_stepListener);
        this.updateStep();
        this.m_uiContext.addShutdownWindow(this);
    }

    private void addZoomKeyboardShortcuts() {
        String zoom_map_in = "zoom_map_in";
        ((JComponent)this.getContentPane()).getInputMap(2).put(KeyStroke.getKeyStroke(43, 4), "zoom_map_in");
        ((JComponent)this.getContentPane()).getInputMap(2).put(KeyStroke.getKeyStroke(43, 2), "zoom_map_in");
        ((JComponent)this.getContentPane()).getInputMap(2).put(KeyStroke.getKeyStroke(61, 4), "zoom_map_in");
        ((JComponent)this.getContentPane()).getInputMap(2).put(KeyStroke.getKeyStroke(61, 2), "zoom_map_in");
        ((JComponent)this.getContentPane()).getActionMap().put("zoom_map_in", new AbstractAction("zoom_map_in"){
            private static final long serialVersionUID = -7565304172320049817L;

            public void actionPerformed(ActionEvent e) {
                if (TripleAFrame.this.getScale() < 100.0) {
                    TripleAFrame.this.setScale(TripleAFrame.this.getScale() + 10.0);
                }
            }
        });
        String zoom_map_out = "zoom_map_out";
        ((JComponent)this.getContentPane()).getInputMap(2).put(KeyStroke.getKeyStroke(45, 4), "zoom_map_out");
        ((JComponent)this.getContentPane()).getInputMap(2).put(KeyStroke.getKeyStroke(45, 2), "zoom_map_out");
        ((JComponent)this.getContentPane()).getActionMap().put("zoom_map_out", new AbstractAction("zoom_map_out"){
            private static final long serialVersionUID = 7677111833274819304L;

            public void actionPerformed(ActionEvent e) {
                if (TripleAFrame.this.getScale() > 16.0) {
                    TripleAFrame.this.setScale(TripleAFrame.this.getScale() - 10.0);
                }
            }
        });
    }

    void setScale(double value) {
        this.getMapPanel().setScale(value / 100.0);
    }

    private double getScale() {
        return this.getMapPanel().getScale() * 100.0;
    }

    public void stopGame() {
        if (this.m_uiContext == null) {
            return;
        }
        if (GameRunner.isMac()) {
            MacWrapper.unregisterShutdownHandler();
        }
        this.m_uiContext.shutDown();
        if (this.m_chatPanel != null) {
            this.m_chatPanel.setPlayerRenderer(null);
            this.m_chatPanel.setChat(null);
        }
        if (this.m_historySyncher != null) {
            this.m_historySyncher.deactivate();
            this.m_historySyncher = null;
        }
        this.m_game.removeGameStepListener(this.m_stepListener);
        this.m_game = null;
        this.m_uiContext = null;
        if (this.m_data != null) {
            this.m_data.clearAllListeners();
        }
        this.m_data = null;
        this.m_tabsPanel.removeAll();
        this.m_commentPanel.cleanUp();
        this.MAP_SELECTION_LISTENER = null;
        this.m_actionButtons = null;
        this.m_chatPanel = null;
        this.m_chatSplit = null;
        this.m_commentSplit = null;
        this.m_commentPanel = null;
        this.m_details = null;
        this.m_gameMainPanel = null;
        this.m_stepListener = null;
        this.m_gameSouthPanel = null;
        this.m_historyPanel = null;
        this.m_historyComponent = null;
        this.m_mapPanel = null;
        this.m_mapAndChatPanel = null;
        this.m_message = null;
        this.m_status = null;
        this.m_rightHandSidePanel = null;
        this.m_smallView = null;
        this.m_statsPanel = null;
        this.m_economyPanel = null;
        this.m_objectivePanel = null;
        this.m_notesPanel = null;
        this.m_step = null;
        this.m_round = null;
        this.m_player = null;
        this.m_tabsPanel = null;
        this.m_showGameAction = null;
        this.m_showHistoryAction = null;
        this.m_showMapOnlyAction = null;
        this.m_showCommentLogAction = null;
        this.m_localPlayers = null;
        this.m_editPanel = null;
        this.removeWindowListener(this.WINDOW_LISTENER);
        this.WINDOW_LISTENER = null;
    }

    @Override
    public void shutdown() {
        int rVal = EventThreadJOptionPane.showConfirmDialog(this, "Are you sure you want to exit?\nUnsaved game data will be lost.", "Exit", 0);
        if (rVal != 0) {
            return;
        }
        System.exit(0);
    }

    @Override
    public void leaveGame() {
        int rVal = EventThreadJOptionPane.showConfirmDialog(this, "Are you sure you want to leave?\nUnsaved game data will be lost.", "Exit", 0);
        if (rVal != 0) {
            return;
        }
        if (this.m_game instanceof ServerGame) {
            ((ServerGame)this.m_game).stopGame();
        } else {
            this.m_game.getMessenger().shutDown();
            ((ClientGame)this.m_game).shutDown();
            MainFrame.getInstance().clientLeftGame();
        }
    }

    private void createMenuBar() {
        TripleaMenu menu = new TripleaMenu(this);
        this.setJMenuBar(menu);
    }

    public void clearStatusMessage() {
        this.m_status.setText("");
        this.m_status.setIcon(null);
    }

    public void setStatusErrorMessage(String msg) {
        this.m_status.setText(msg);
        if (!msg.equals("")) {
            this.m_status.setIcon(new ImageIcon(this.m_mapPanel.getErrorImage()));
        } else {
            this.m_status.setIcon(null);
        }
    }

    public void setStatusWarningMessage(String msg) {
        this.m_status.setText(msg);
        if (!msg.equals("")) {
            this.m_status.setIcon(new ImageIcon(this.m_mapPanel.getWarningImage()));
        } else {
            this.m_status.setIcon(null);
        }
    }

    public void setStatusInfoMessage(String msg) {
        this.m_status.setText(msg);
        if (!msg.equals("")) {
            this.m_status.setIcon(new ImageIcon(this.m_mapPanel.getInfoImage()));
        } else {
            this.m_status.setIcon(null);
        }
    }

    public IntegerMap<ProductionRule> getProduction(PlayerID player, boolean bid) {
        this.m_actionButtons.changeToProduce(player);
        return this.m_actionButtons.waitForPurchase(bid);
    }

    public HashMap<Unit, IntegerMap<RepairRule>> getRepair(PlayerID player, boolean bid) {
        this.m_actionButtons.changeToRepair(player);
        return this.m_actionButtons.waitForRepair(bid);
    }

    public MoveDescription getMove(PlayerID player, IPlayerBridge bridge, boolean nonCombat, String stepName) {
        this.m_actionButtons.changeToMove(player, nonCombat, stepName);
        if (!this.getBattlePanel().getBattleFrame().isVisible()) {
            if (!SwingUtilities.isEventDispatchThread()) {
                try {
                    SwingUtilities.invokeAndWait(new Runnable(){

                        public void run() {
                            TripleAFrame.this.requestFocusInWindow();
                            TripleAFrame.this.transferFocus();
                        }
                    });
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            } else {
                this.requestFocusInWindow();
                this.transferFocus();
            }
        }
        return this.m_actionButtons.waitForMove(bridge);
    }

    public PlaceData waitForPlace(PlayerID player, boolean bid, IPlayerBridge bridge) {
        this.m_actionButtons.changeToPlace(player);
        return this.m_actionButtons.waitForPlace(bid, bridge);
    }

    public void waitForMoveForumPoster(PlayerID player, IPlayerBridge bridge) {
        this.m_actionButtons.changeToMoveForumPosterPanel(player);
        this.m_actionButtons.waitForMoveForumPosterPanel(this, bridge);
    }

    public void waitForEndTurn(PlayerID player, IPlayerBridge bridge) {
        this.m_actionButtons.changeToEndTurn(player);
        this.m_actionButtons.waitForEndTurn(this, bridge);
    }

    public FightBattleDetails getBattle(PlayerID player, Collection<Territory> battles, Collection<Territory> bombingRaids) {
        this.m_actionButtons.changeToBattle(player, battles, bombingRaids);
        return this.m_actionButtons.waitForBattleSelection();
    }

    @Override
    public void notifyError(String message) {
        EventThreadJOptionPane.showMessageDialog((Component)this, (Object)message, "Error", 0, true);
    }

    public void notifyMessage(String message, String title) {
        EventThreadJOptionPane.showMessageDialog((Component)this, (Object)message, title, 1, true);
    }

    public void notification(String message) {
        EventThreadJOptionPane.showMessageDialog((Component)this, (Object)message, "Notification", 1, true);
    }

    public boolean getOKToLetAirDie(PlayerID m_id, String message, boolean movePhase) {
        boolean canProduceCarriersUnderFighter;
        boolean lhtrProd = AirThatCantLandUtil.isLHTRCarrierProduction(this.m_data) || AirThatCantLandUtil.isLandExistingFightersOnNewCarriers(this.m_data);
        int carrierCount = m_id.getUnits().getMatches(Matches.UnitIsCarrier).size();
        boolean bl = canProduceCarriersUnderFighter = lhtrProd && carrierCount != 0;
        if (canProduceCarriersUnderFighter && carrierCount > 0) {
            message = message + "\nYou have " + carrierCount + " " + MyFormatter.pluralize("carrier", carrierCount) + " on which planes can land";
        }
        String ok = movePhase ? "End Move Phase" : "Kill Planes";
        String cancel = movePhase ? "Keep Moving" : "Change Placement";
        Object[] options = new String[]{cancel, ok};
        int choice = EventThreadJOptionPane.showOptionDialog(this, message, "Air cannot land", 0, 2, null, options, cancel);
        return choice == 1;
    }

    public boolean getOKToLetUnitsDie(PlayerID m_id, String message, boolean movePhase) {
        String ok = movePhase ? "Done Moving" : "Kill Units";
        String cancel = movePhase ? "Keep Moving" : "Change Placement";
        Object[] options = new String[]{cancel, ok};
        int choice = EventThreadJOptionPane.showOptionDialog(this, message, "Units cannot fight", 0, 2, null, options, cancel);
        return choice == 1;
    }

    public boolean acceptPoliticalAction(String acceptanceQuestion) {
        int choice = EventThreadJOptionPane.showConfirmDialog(this, acceptanceQuestion, "Accept Political Proposal?", 0);
        return choice == 0;
    }

    public boolean getOK(String message) {
        int choice = EventThreadJOptionPane.showConfirmDialog(this, message, message, 2);
        return choice == 0;
    }

    public void notifyTechResults(final TechResults msg) {
        final AtomicReference displayRef = new AtomicReference();
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                public void run() {
                    TechResultsDisplay display = new TechResultsDisplay(msg, TripleAFrame.this.m_uiContext, TripleAFrame.this.m_data);
                    displayRef.set(display);
                }
            });
        }
        catch (InterruptedException e) {
            throw new IllegalStateException();
        }
        catch (InvocationTargetException e) {
            throw new IllegalStateException();
        }
        EventThreadJOptionPane.showOptionDialog(this, displayRef.get(), "Tech roll", 0, -1, null, new String[]{"OK"}, "OK");
    }

    public boolean getStrategicBombingRaid(Territory location) {
        String message = (Properties.getRaidsMayBePreceededByAirBattles(this.m_data) ? "Bomb/Escort" : "Bomb") + " in " + location.getName();
        String bomb = Properties.getRaidsMayBePreceededByAirBattles(this.m_data) ? "Bomb/Escort" : "Bomb";
        String normal = "Attack";
        Object[] choices = new String[]{bomb, "Attack"};
        int choice = EventThreadJOptionPane.showOptionDialog(this, message, "Bomb?", 2, 1, null, choices, bomb);
        return choice == 0;
    }

    public Unit getStrategicBombingRaidTarget(Territory territory, final Collection<Unit> potentialTargets, final Collection<Unit> bombers) {
        if (potentialTargets == null || potentialTargets.size() == 0) {
            return null;
        }
        if (potentialTargets.size() == 1) {
            return potentialTargets.iterator().next();
        }
        AtomicReference<Unit> selected = new AtomicReference<Unit>();
        String message = "Select bombing target in " + territory.getName();
        Tuple<JPanel, JList> comps = Util.runInSwingEventThread(new Util.Task<Tuple<JPanel, JList>>(){

            @Override
            public Tuple<JPanel, JList> run() {
                JList list = new JList(new Vector(potentialTargets));
                list.setSelectionMode(0);
                list.setSelectedIndex(0);
                JPanel panel = new JPanel();
                panel.setLayout(new BorderLayout());
                if (bombers != null) {
                    panel.add((Component)new JLabel("For Units: " + MyFormatter.unitsToTextNoOwner(bombers)), "North");
                }
                JScrollPane scroll = new JScrollPane(list);
                panel.add((Component)scroll, "Center");
                return new Tuple<JPanel, JList>(panel, list);
            }
        });
        JPanel panel = comps.getFirst();
        JList list = comps.getSecond();
        Object[] options = new String[]{"OK", "Cancel"};
        int selection = EventThreadJOptionPane.showOptionDialog(this, panel, message, 2, -1, null, options, null);
        if (selection == 0) {
            selected.set((Unit)list.getSelectedValue());
        }
        return (Unit)selected.get();
    }

    public int[] selectFixedDice(final int numDice, final int hitAt, final boolean hitOnlyIfEquals, String title, final int diceSides) {
        DiceChooser chooser = Util.runInSwingEventThread(new Util.Task<DiceChooser>(){

            @Override
            public DiceChooser run() {
                return new DiceChooser(TripleAFrame.this.getUIContext(), numDice, hitAt, hitOnlyIfEquals, diceSides, TripleAFrame.this.m_data);
            }
        });
        do {
            EventThreadJOptionPane.showMessageDialog(null, chooser, title, -1);
        } while (chooser.getDice() == null);
        return chooser.getDice();
    }

    public Territory selectTerritoryForAirToLand(final Collection<Territory> candidates, final Territory currentTerritory, final String unitMessage) {
        Tuple<JPanel, JList> comps = Util.runInSwingEventThread(new Util.Task<Tuple<JPanel, JList>>(){

            @Override
            public Tuple<JPanel, JList> run() {
                TripleAFrame.this.m_mapPanel.centerOn(currentTerritory);
                JList list = new JList(new Vector(candidates));
                list.setSelectionMode(0);
                list.setSelectedIndex(0);
                JPanel panel = new JPanel();
                panel.setLayout(new BorderLayout());
                JScrollPane scroll = new JScrollPane(list);
                JTextArea text = new JTextArea(unitMessage, 8, 30);
                text.setLineWrap(true);
                text.setEditable(false);
                text.setWrapStyleWord(true);
                panel.add((Component)text, "North");
                panel.add((Component)scroll, "Center");
                return new Tuple<JPanel, JList>(panel, list);
            }
        });
        JPanel panel = comps.getFirst();
        JList list = comps.getSecond();
        Object[] options = new String[]{"OK"};
        String title = "Select territory for air units to land, current territory is " + currentTerritory.getName();
        EventThreadJOptionPane.showOptionDialog(this, panel, title, 2, -1, null, options, null);
        Territory selected = (Territory)list.getSelectedValue();
        return selected;
    }

    public HashMap<Territory, IntegerMap<Unit>> selectKamikazeSuicideAttacks(final HashMap<Territory, Collection<Unit>> possibleUnitsToAttack, final Resource attackResourceToken, final int maxNumberOfAttacksAllowed) {
        if (SwingUtilities.isEventDispatchThread()) {
            throw new IllegalStateException("Should not be called from dispatch thread");
        }
        final CountDownLatch continueLatch = new CountDownLatch(1);
        final HashMap<Territory, IntegerMap<Unit>> selection = new HashMap<Territory, IntegerMap<Unit>>();
        if (possibleUnitsToAttack == null || possibleUnitsToAttack.isEmpty() || attackResourceToken == null || maxNumberOfAttacksAllowed <= 0) {
            return selection;
        }
        final ArrayList unitPanels = new ArrayList();
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                HashMap<String, Collection<Unit>> possibleUnitsToAttackStringForm = new HashMap<String, Collection<Unit>>();
                for (Map.Entry entry : possibleUnitsToAttack.entrySet()) {
                    ArrayList units = new ArrayList((Collection)entry.getValue());
                    Collections.sort(units, new UnitBattleComparator(false, BattleCalculator.getCostsForTuvForAllPlayersMergedAndAveraged(TripleAFrame.this.m_data), TripleAFrame.this.m_data, false));
                    Collections.reverse(units);
                    possibleUnitsToAttackStringForm.put(((Territory)entry.getKey()).getName(), units);
                }
                TripleAFrame.this.m_mapPanel.centerOn(TripleAFrame.this.m_data.getMap().getTerritory((String)possibleUnitsToAttackStringForm.keySet().iterator().next()));
                IndividualUnitPanelGrouped unitPanel = new IndividualUnitPanelGrouped(possibleUnitsToAttackStringForm, TripleAFrame.this.m_data, TripleAFrame.this.m_uiContext, "Select Units to Suicide Attack using " + attackResourceToken.getName(), maxNumberOfAttacksAllowed, true, false);
                unitPanels.add(unitPanel);
                String optionAttack = "Attack";
                String optionNone = "None";
                String optionWait = "Wait";
                Object[] options = new Object[]{"Attack", "None", "Wait"};
                final JOptionPane optionPane = new JOptionPane(unitPanel, -1, 1, null, options, options[2]);
                final JDialog dialog = new JDialog((Frame)TripleAFrame.this.getParent(), "Select units to Suicide Attack using " + attackResourceToken.getName());
                dialog.setContentPane(optionPane);
                dialog.setDefaultCloseOperation(0);
                dialog.setLocationRelativeTo(TripleAFrame.this.getParent());
                dialog.setAlwaysOnTop(true);
                dialog.pack();
                dialog.setVisible(true);
                dialog.requestFocusInWindow();
                optionPane.addPropertyChangeListener(new PropertyChangeListener(){

                    public void propertyChange(PropertyChangeEvent e) {
                        if (!dialog.isVisible()) {
                            return;
                        }
                        String option = (String)optionPane.getValue();
                        if (option.equals("None")) {
                            unitPanels.clear();
                            selection.clear();
                            dialog.setVisible(false);
                            dialog.removeAll();
                            dialog.dispose();
                            continueLatch.countDown();
                            return;
                        }
                        if (option.equals("Attack")) {
                            if (unitPanels.size() != 1) {
                                throw new IllegalStateException("unitPanels should only contain 1 entry");
                            }
                            for (IndividualUnitPanelGrouped terrChooser : unitPanels) {
                                for (Map.Entry<String, IntegerMap<Unit>> entry : terrChooser.getSelected().entrySet()) {
                                    selection.put(TripleAFrame.this.m_data.getMap().getTerritory(entry.getKey()), entry.getValue());
                                }
                            }
                            dialog.setVisible(false);
                            dialog.removeAll();
                            dialog.dispose();
                            continueLatch.countDown();
                        } else {
                            unitPanels.clear();
                            selection.clear();
                            dialog.setVisible(false);
                            dialog.removeAll();
                            dialog.dispose();
                            try {
                                Thread.sleep(500L);
                            }
                            catch (InterruptedException e2) {
                                e2.printStackTrace();
                            }
                            this.run();
                        }
                    }
                });
            }
        });
        try {
            continueLatch.await();
        }
        catch (InterruptedException ex) {
            ex.printStackTrace();
        }
        return selection;
    }

    public HashMap<Territory, Collection<Unit>> scrambleUnitsQuery(final Territory scrambleTo, final Map<Territory, Tuple<Collection<Unit>, Collection<Unit>>> possibleScramblers) {
        if (SwingUtilities.isEventDispatchThread()) {
            throw new IllegalStateException("Should not be called from dispatch thread");
        }
        final CountDownLatch continueLatch = new CountDownLatch(1);
        final HashMap<Territory, Collection<Unit>> selection = new HashMap<Territory, Collection<Unit>>();
        final ArrayList choosers = new ArrayList();
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                TripleAFrame.this.m_mapPanel.centerOn(scrambleTo);
                JPanel panel = new JPanel();
                panel.setLayout(new BorderLayout());
                JLabel whereTo = new JLabel("Scramble To: " + scrambleTo.getName());
                whereTo.setFont(new Font("Arial", 2, 12));
                panel.add((Component)whereTo, "North");
                JPanel panel2 = new JPanel();
                panel2.setBorder(BorderFactory.createEmptyBorder());
                panel2.setLayout(new FlowLayout());
                for (Territory from : possibleScramblers.keySet()) {
                    JPanel panelChooser = new JPanel();
                    panelChooser.setLayout(new BoxLayout(panelChooser, 1));
                    panelChooser.setBorder(BorderFactory.createLineBorder(TripleAFrame.this.getBackground()));
                    JLabel whereFrom = new JLabel("From: " + from.getName());
                    whereFrom.setHorizontalAlignment(2);
                    whereFrom.setFont(new Font("Arial", 1, 12));
                    panelChooser.add(whereFrom);
                    panelChooser.add(new JLabel(" "));
                    Collection possible = (Collection)((Tuple)possibleScramblers.get(from)).getSecond();
                    int maxAllowed = Math.min(BattleDelegate.getMaxScrambleCount((Collection)((Tuple)possibleScramblers.get(from)).getFirst()), possible.size());
                    UnitChooser chooser = new UnitChooser(possible, Collections.<Unit, Collection<Unit>>emptyMap(), TripleAFrame.this.m_data, false, TripleAFrame.this.m_uiContext);
                    chooser.setMaxAndShowMaxButton(maxAllowed);
                    choosers.add(new Tuple<Territory, UnitChooser>(from, chooser));
                    panelChooser.add(chooser);
                    JScrollPane chooserScrollPane = new JScrollPane(panelChooser);
                    panel2.add(chooserScrollPane);
                }
                panel.add((Component)panel2, "Center");
                String optionScramble = "Scramble";
                String optionNone = "None";
                String optionWait = "Wait";
                Object[] options = new Object[]{"Scramble", "None", "Wait"};
                final JOptionPane optionPane = new JOptionPane(panel, -1, 1, null, options, options[2]);
                final JDialog dialog = new JDialog((Frame)TripleAFrame.this.getParent(), "Select units to scramble to " + scrambleTo.getName());
                dialog.setContentPane(optionPane);
                dialog.setDefaultCloseOperation(0);
                dialog.setLocationRelativeTo(TripleAFrame.this.getParent());
                dialog.setAlwaysOnTop(true);
                dialog.pack();
                dialog.setVisible(true);
                dialog.requestFocusInWindow();
                optionPane.addPropertyChangeListener(new PropertyChangeListener(){

                    public void propertyChange(PropertyChangeEvent e) {
                        if (!dialog.isVisible()) {
                            return;
                        }
                        String option = (String)optionPane.getValue();
                        if (option.equals("None")) {
                            choosers.clear();
                            selection.clear();
                            dialog.setVisible(false);
                            dialog.removeAll();
                            dialog.dispose();
                            continueLatch.countDown();
                            return;
                        }
                        if (option.equals("Scramble")) {
                            for (Tuple terrChooser : choosers) {
                                selection.put(terrChooser.getFirst(), ((UnitChooser)terrChooser.getSecond()).getSelected());
                            }
                            dialog.setVisible(false);
                            dialog.removeAll();
                            dialog.dispose();
                            continueLatch.countDown();
                        } else {
                            choosers.clear();
                            selection.clear();
                            dialog.setVisible(false);
                            dialog.removeAll();
                            dialog.dispose();
                            try {
                                Thread.sleep(500L);
                            }
                            catch (InterruptedException e2) {
                                e2.printStackTrace();
                            }
                            this.run();
                        }
                    }
                });
            }
        });
        try {
            continueLatch.await();
        }
        catch (InterruptedException ex) {
            ex.printStackTrace();
        }
        return selection;
    }

    public Collection<Unit> selectUnitsQuery(final Territory current, final Collection<Unit> possible, final String message) {
        if (SwingUtilities.isEventDispatchThread()) {
            throw new IllegalStateException("Should not be called from dispatch thread");
        }
        final CountDownLatch continueLatch = new CountDownLatch(1);
        final ArrayList<Unit> selection = new ArrayList<Unit>();
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                TripleAFrame.this.m_mapPanel.centerOn(current);
                JPanel panel = new JPanel();
                panel.setLayout(new BorderLayout());
                JLabel messageLabel = new JLabel(message);
                messageLabel.setFont(new Font("Arial", 2, 12));
                panel.add((Component)messageLabel, "North");
                JPanel panelChooser = new JPanel();
                panelChooser.setLayout(new BoxLayout(panelChooser, 1));
                panelChooser.setBorder(BorderFactory.createLineBorder(TripleAFrame.this.getBackground()));
                JLabel whereFrom = new JLabel("From: " + current.getName());
                whereFrom.setHorizontalAlignment(2);
                whereFrom.setFont(new Font("Arial", 1, 12));
                panelChooser.add(whereFrom);
                panelChooser.add(new JLabel(" "));
                int maxAllowed = possible.size();
                final UnitChooser chooser = new UnitChooser(possible, Collections.<Unit, Collection<Unit>>emptyMap(), TripleAFrame.this.m_data, false, TripleAFrame.this.m_uiContext);
                chooser.setMaxAndShowMaxButton(maxAllowed);
                panelChooser.add(chooser);
                JScrollPane chooserScrollPane = new JScrollPane(panelChooser);
                panel.add((Component)chooserScrollPane, "Center");
                String optionSelect = "Select";
                String optionNone = "None";
                String optionWait = "Wait";
                Object[] options = new Object[]{"Select", "None", "Wait"};
                final JOptionPane optionPane = new JOptionPane(panel, -1, 1, null, options, options[2]);
                final JDialog dialog = new JDialog((Frame)TripleAFrame.this.getParent(), message);
                dialog.setContentPane(optionPane);
                dialog.setDefaultCloseOperation(0);
                dialog.setLocationRelativeTo(TripleAFrame.this.getParent());
                dialog.setAlwaysOnTop(true);
                dialog.pack();
                dialog.setVisible(true);
                dialog.requestFocusInWindow();
                optionPane.addPropertyChangeListener(new PropertyChangeListener(){

                    public void propertyChange(PropertyChangeEvent e) {
                        if (!dialog.isVisible()) {
                            return;
                        }
                        String option = (String)optionPane.getValue();
                        if (option.equals("None")) {
                            selection.clear();
                            dialog.setVisible(false);
                            dialog.removeAll();
                            dialog.dispose();
                            continueLatch.countDown();
                            return;
                        }
                        if (option.equals("Select")) {
                            selection.addAll(chooser.getSelected());
                            dialog.setVisible(false);
                            dialog.removeAll();
                            dialog.dispose();
                            continueLatch.countDown();
                        } else {
                            selection.clear();
                            dialog.setVisible(false);
                            dialog.removeAll();
                            dialog.dispose();
                            try {
                                Thread.sleep(500L);
                            }
                            catch (InterruptedException e2) {
                                e2.printStackTrace();
                            }
                            this.run();
                        }
                    }
                });
            }
        });
        try {
            continueLatch.await();
        }
        catch (InterruptedException ex) {
            ex.printStackTrace();
        }
        return selection;
    }

    public void notifyPoliticalMessage(String message) {
        EventThreadJOptionPane.showMessageDialog(this, message, "Political Alert", 1);
    }

    public PoliticalActionAttachment getPoliticalActionChoice(PlayerID player, boolean firstRun, IPoliticsDelegate iPoliticsDelegate) {
        this.m_actionButtons.changeToPolitics(player);
        if (!SwingUtilities.isEventDispatchThread()) {
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    public void run() {
                        TripleAFrame.this.requestFocusInWindow();
                        TripleAFrame.this.transferFocus();
                    }
                });
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            this.requestFocusInWindow();
            this.transferFocus();
        }
        return this.m_actionButtons.waitForPoliticalAction(firstRun, iPoliticsDelegate);
    }

    public TechRoll getTechRolls(PlayerID id) {
        this.m_actionButtons.changeToTech(id);
        if (!SwingUtilities.isEventDispatchThread()) {
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    public void run() {
                        TripleAFrame.this.requestFocusInWindow();
                        TripleAFrame.this.transferFocus();
                    }
                });
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            this.requestFocusInWindow();
            this.transferFocus();
        }
        return this.m_actionButtons.waitForTech();
    }

    public Territory getRocketAttack(final Collection<Territory> candidates, final Territory from) {
        final AtomicReference selected = new AtomicReference();
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                public void run() {
                    JList list = new JList(new Vector(candidates));
                    list.setSelectionMode(0);
                    list.setSelectedIndex(0);
                    JPanel panel = new JPanel();
                    panel.setLayout(new BorderLayout());
                    JScrollPane scroll = new JScrollPane(list);
                    panel.add((Component)scroll, "Center");
                    if (from != null) {
                        panel.add("North", new JLabel("Targets for rocket in " + from.getName()));
                    }
                    Object[] options = new String[]{"OK", "Dont attack"};
                    String message = "Select Rocket Target";
                    int selection = JOptionPane.showOptionDialog(TripleAFrame.this, panel, "Select Rocket Target", 2, -1, null, options, null);
                    if (selection == 0) {
                        selected.set((Territory)list.getSelectedValue());
                    }
                }
            });
        }
        catch (InterruptedException e) {
            throw new IllegalStateException(e);
        }
        catch (InvocationTargetException e) {
            throw new IllegalStateException(e);
        }
        return (Territory)selected.get();
    }

    public Set<IGamePlayer> GetLocalPlayers() {
        return this.m_localPlayers;
    }

    public boolean playing(PlayerID id) {
        if (id == null) {
            return false;
        }
        for (IGamePlayer gamePlayer : this.m_localPlayers) {
            if (!gamePlayer.getPlayerID().equals(id) || !(gamePlayer instanceof TripleAPlayer)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static int save(String filename, GameData m_data) {
        int n;
        FileOutputStream fos = null;
        ObjectOutputStream oos = null;
        try {
            fos = new FileOutputStream(filename);
            oos = new ObjectOutputStream(fos);
            oos.writeObject(m_data);
            n = 0;
        }
        catch (Throwable t) {
            try {
                System.err.println(t.getMessage());
                int n2 = -1;
                return n2;
            }
            catch (Throwable throwable) {
                throw throwable;
            }
            finally {
                try {
                    if (fos != null) {
                        fos.flush();
                    }
                }
                catch (Exception ignore) {}
                try {
                    if (oos != null) {
                        oos.close();
                    }
                }
                catch (Exception ignore) {}
            }
        }
        try {
            if (fos != null) {
                fos.flush();
            }
        }
        catch (Exception ignore) {
            // empty catch block
        }
        try {
            if (oos == null) return n;
            oos.close();
            return n;
        }
        catch (Exception ignore) {
            // empty catch block
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateStep() {
        PlayerID player;
        String stepDisplayName;
        int round;
        UIContext context = this.m_uiContext;
        if (context == null || context.isShutDown()) {
            return;
        }
        this.m_data.acquireReadLock();
        try {
            if (this.m_data.getSequence().getStep() == null) {
                return;
            }
        }
        finally {
            this.m_data.releaseReadLock();
        }
        if (!SwingUtilities.isEventDispatchThread()) {
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    public void run() {
                        TripleAFrame.this.updateStep();
                    }
                });
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            catch (InvocationTargetException e) {
                e.getCause().printStackTrace();
                throw new IllegalStateException(e.getCause().getMessage());
            }
            return;
        }
        this.m_data.acquireReadLock();
        try {
            round = this.m_data.getSequence().getRound();
            stepDisplayName = this.m_data.getSequence().getStep().getDisplayName();
            player = this.m_data.getSequence().getStep().getPlayerID();
        }
        finally {
            this.m_data.releaseReadLock();
        }
        this.m_round.setText("Round:" + round + " ");
        this.m_step.setText(stepDisplayName);
        boolean isPlaying = this.playing(player);
        if (player != null) {
            this.m_player.setText((isPlaying ? "" : "REMOTE: ") + player.getName());
        }
        if (player != null && !player.isNull()) {
            this.m_round.setIcon(new ImageIcon(this.m_uiContext.getFlagImageFactory().getFlag(player)));
        }
        if (!(player == null || player.isNull() || isPlaying || this.m_inHistory || this.m_uiContext.getShowMapOnly())) {
            if (!SwingUtilities.isEventDispatchThread()) {
                throw new IllegalStateException("We should be in dispatch thread");
            }
            this.showHistory();
        } else if (player != null && !player.isNull() && isPlaying && this.m_inHistory) {
            this.showGame();
            ClipPlayer.play("required_your_turn_series", player.getName());
        }
        if (player != null && isPlaying && !player.equals(this.m_lastStepPlayer)) {
            this.m_lastStepPlayer = player;
            this.m_data.acquireReadLock();
            try {
                this.m_mapPanel.centerOn(TerritoryAttachment.getCapital(player, this.m_data));
            }
            finally {
                this.m_data.releaseReadLock();
            }
        }
    }

    private void showEditMode() {
        this.m_tabsPanel.addTab("Edit", this.m_editPanel);
        if (this.m_editDelegate != null) {
            this.m_tabsPanel.setSelectedComponent(this.m_editPanel);
        }
        this.m_editModeButtonModel.setSelected(true);
        this.getGlassPane().setVisible(true);
    }

    private void hideEditMode() {
        if (this.m_tabsPanel.getSelectedComponent() == this.m_editPanel) {
            this.m_tabsPanel.setSelectedIndex(0);
        }
        this.m_tabsPanel.remove(this.m_editPanel);
        this.m_editModeButtonModel.setSelected(false);
        this.getGlassPane().setVisible(false);
    }

    public void showRightHandSidePanel() {
        this.m_rightHandSidePanel.setVisible(true);
    }

    public void hideRightHandSidePanel() {
        this.m_rightHandSidePanel.setVisible(false);
    }

    public HistoryPanel getHistoryPanel() {
        return this.m_historyPanel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void showHistory() {
        GameData clonedGameData;
        this.m_inHistory = true;
        this.m_inGame = false;
        this.setWidgetActivation();
        this.m_data.acquireReadLock();
        try {
            clonedGameData = GameDataUtils.cloneGameData(this.m_data);
            if (clonedGameData == null) {
                return;
            }
            this.m_data.removeDataChangeListener(this.m_dataChangeListener);
            clonedGameData.testLocksOnRead();
            if (this.m_historySyncher != null) {
                throw new IllegalStateException("Two history synchers?");
            }
            this.m_historySyncher = new HistorySynchronizer(clonedGameData, this.m_game);
            clonedGameData.addDataChangeListener(this.m_dataChangeListener);
        }
        finally {
            this.m_data.releaseReadLock();
        }
        this.m_statsPanel.setGameData(clonedGameData);
        this.m_economyPanel.setGameData(clonedGameData);
        if (this.m_objectivePanel != null && !this.m_objectivePanel.isEmpty()) {
            this.m_objectivePanel.setGameData(clonedGameData);
        }
        this.m_details.setGameData(clonedGameData);
        this.m_mapPanel.setGameData(clonedGameData);
        HistoryDetailsPanel historyDetailPanel = new HistoryDetailsPanel(clonedGameData, this.m_mapPanel);
        this.m_tabsPanel.removeAll();
        this.m_tabsPanel.add("History", historyDetailPanel);
        this.m_tabsPanel.add("Stats", this.m_statsPanel);
        this.m_tabsPanel.add("Economy", this.m_economyPanel);
        if (this.m_objectivePanel != null && !this.m_objectivePanel.isEmpty()) {
            this.m_tabsPanel.add(this.m_objectivePanel.getName(), this.m_objectivePanel);
        }
        this.m_tabsPanel.add("Notes", this.m_notesPanel);
        this.m_tabsPanel.add("Territory", this.m_details);
        if (this.getEditMode()) {
            this.m_tabsPanel.add("Edit", this.m_editPanel);
        }
        if (this.m_actionButtons.getCurrent() != null) {
            this.m_actionButtons.getCurrent().setActive(false);
        }
        this.m_historyComponent.removeAll();
        this.m_historyComponent.setLayout(new BorderLayout());
        JPopupMenu popup = new JPopupMenu();
        popup.add(new AbstractAction("Show Summary Log"){
            private static final long serialVersionUID = -6730966512179268157L;

            public void actionPerformed(ActionEvent ae) {
                HistoryLog historyLog = new HistoryLog();
                historyLog.printRemainingTurn(TripleAFrame.this.m_historyPanel.getCurrentPopupNode(), false, TripleAFrame.this.m_data.getDiceSides(), null);
                historyLog.printTerritorySummary(TripleAFrame.this.m_historyPanel.getCurrentPopupNode(), clonedGameData);
                historyLog.printProductionSummary(clonedGameData);
                TripleAFrame.this.m_historyPanel.clearCurrentPopupNode();
                historyLog.setVisible(true);
            }
        });
        popup.add(new AbstractAction("Show Detailed Log"){
            private static final long serialVersionUID = -8709762764495294671L;

            public void actionPerformed(ActionEvent ae) {
                HistoryLog historyLog = new HistoryLog();
                historyLog.printRemainingTurn(TripleAFrame.this.m_historyPanel.getCurrentPopupNode(), true, TripleAFrame.this.m_data.getDiceSides(), null);
                historyLog.printTerritorySummary(TripleAFrame.this.m_historyPanel.getCurrentPopupNode(), clonedGameData);
                historyLog.printProductionSummary(clonedGameData);
                TripleAFrame.this.m_historyPanel.clearCurrentPopupNode();
                historyLog.setVisible(true);
            }
        });
        popup.add(new AbstractAction("Save Screenshot"){
            private static final long serialVersionUID = 1222760138263428443L;

            public void actionPerformed(ActionEvent ae) {
                TripleAFrame.this.saveScreenshot(TripleAFrame.this.m_historyPanel.getCurrentPopupNode());
                TripleAFrame.this.m_historyPanel.clearCurrentPopupNode();
            }
        });
        JSplitPane split = new JSplitPane();
        split.setOneTouchExpandable(true);
        split.setDividerSize(8);
        this.m_historyPanel = new HistoryPanel(clonedGameData, historyDetailPanel, popup, this.m_uiContext);
        split.setLeftComponent(this.m_historyPanel);
        split.setRightComponent(this.m_gameCenterPanel);
        split.setDividerLocation(150);
        this.m_historyComponent.add((Component)split, "Center");
        this.m_historyComponent.add((Component)this.m_gameSouthPanel, "South");
        this.getContentPane().removeAll();
        this.getContentPane().add((Component)this.m_historyComponent, "Center");
        this.validate();
    }

    @Override
    public void show() {
        super.show();
    }

    public void showGame() {
        this.m_inGame = true;
        this.m_uiContext.setShowMapOnly(false);
        if (this.m_inHistory) {
            this.m_inHistory = false;
            if (this.m_historySyncher != null) {
                this.m_historySyncher.deactivate();
                this.m_historySyncher = null;
            }
            this.m_historyPanel.goToEnd();
            this.m_historyPanel = null;
            this.m_mapPanel.getData().removeDataChangeListener(this.m_dataChangeListener);
            this.m_statsPanel.setGameData(this.m_data);
            this.m_economyPanel.setGameData(this.m_data);
            if (this.m_objectivePanel != null && !this.m_objectivePanel.isEmpty()) {
                this.m_objectivePanel.setGameData(this.m_data);
            }
            this.m_details.setGameData(this.m_data);
            this.m_mapPanel.setGameData(this.m_data);
            this.m_data.addDataChangeListener(this.m_dataChangeListener);
            this.m_tabsPanel.removeAll();
        }
        this.setWidgetActivation();
        this.m_tabsPanel.add("Action", this.m_actionButtons);
        this.m_tabsPanel.add("Stats", this.m_statsPanel);
        this.m_tabsPanel.add("Economy", this.m_economyPanel);
        if (this.m_objectivePanel != null && !this.m_objectivePanel.isEmpty()) {
            this.m_tabsPanel.add(this.m_objectivePanel.getName(), this.m_objectivePanel);
        }
        this.m_tabsPanel.add("Notes", this.m_notesPanel);
        this.m_tabsPanel.add("Territory", this.m_details);
        if (this.getEditMode()) {
            this.m_tabsPanel.add("Edit", this.m_editPanel);
        }
        if (this.m_actionButtons.getCurrent() != null) {
            this.m_actionButtons.getCurrent().setActive(true);
        }
        this.m_gameMainPanel.removeAll();
        this.m_gameMainPanel.setLayout(new BorderLayout());
        this.m_gameMainPanel.add((Component)this.m_gameCenterPanel, "Center");
        this.m_gameMainPanel.add((Component)this.m_gameSouthPanel, "South");
        this.getContentPane().removeAll();
        this.getContentPane().add((Component)this.m_gameMainPanel, "Center");
        this.m_mapPanel.setRoute(null);
        this.validate();
    }

    public void showMapOnly() {
        if (this.m_inHistory) {
            this.m_inHistory = false;
            if (this.m_historySyncher != null) {
                this.m_historySyncher.deactivate();
                this.m_historySyncher = null;
            }
            this.m_historyPanel.goToEnd();
            this.m_historyPanel = null;
            this.m_mapPanel.getData().removeDataChangeListener(this.m_dataChangeListener);
            this.m_mapPanel.setGameData(this.m_data);
            this.m_data.addDataChangeListener(this.m_dataChangeListener);
            this.m_gameMainPanel.removeAll();
            this.m_gameMainPanel.setLayout(new BorderLayout());
            this.m_gameMainPanel.add((Component)this.m_mapAndChatPanel, "Center");
            this.m_gameMainPanel.add((Component)this.m_rightHandSidePanel, "East");
            this.m_gameMainPanel.add((Component)this.m_gameSouthPanel, "South");
            this.getContentPane().removeAll();
            this.getContentPane().add((Component)this.m_gameMainPanel, "Center");
            this.m_mapPanel.setRoute(null);
        } else {
            this.m_inGame = false;
        }
        this.m_uiContext.setShowMapOnly(true);
        this.setWidgetActivation();
        this.validate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean saveScreenshot(HistoryNode node, File file) {
        TreeNode[] pathFromRoot;
        MapPanel mapPanel = this.getMapPanel();
        boolean retval = true;
        int round = 0;
        String step = null;
        PlayerID player = null;
        for (TreeNode pathNode : pathFromRoot = node.getPath()) {
            HistoryNode curNode = (HistoryNode)pathNode;
            if (curNode instanceof Round) {
                round = ((Round)curNode).getRoundNo();
            }
            if (!(curNode instanceof Step)) continue;
            player = ((Step)curNode).getPlayerID();
            step = curNode.getTitle();
        }
        double scale = this.m_uiContext.getScale();
        BufferedImage mapImage = Util.createImage((int)(scale * (double)mapPanel.getImageWidth()), (int)(scale * (double)mapPanel.getImageHeight()), false);
        Graphics2D mapGraphics = mapImage.createGraphics();
        try {
            boolean stats_enabled;
            int title_size;
            int title_y;
            int title_x;
            GameData data = mapPanel.getData();
            data.acquireReadLock();
            try {
                int xOffset = mapPanel.getXOffset();
                int yOffset = mapPanel.getYOffset();
                mapPanel.setTopLeft(0, 0);
                mapPanel.print(mapGraphics);
                mapPanel.setTopLeft(xOffset, yOffset);
            }
            finally {
                data.releaseReadLock();
            }
            Color title_color = this.m_uiContext.getMapData().getColorProperty("screenshot.title.color");
            if (title_color == null) {
                title_color = Color.BLACK;
            }
            String s_title_x = this.m_uiContext.getMapData().getProperty("screenshot.title.x");
            String s_title_y = this.m_uiContext.getMapData().getProperty("screenshot.title.y");
            String s_title_size = this.m_uiContext.getMapData().getProperty("screenshot.title.font.size");
            try {
                title_x = (int)((double)Integer.parseInt(s_title_x) * scale);
                title_y = (int)((double)Integer.parseInt(s_title_y) * scale);
                title_size = Integer.parseInt(s_title_size);
            }
            catch (NumberFormatException nfe) {
                title_x = (int)(15.0 * scale);
                title_y = (int)(15.0 * scale);
                title_size = 15;
            }
            AffineTransform transform = new AffineTransform();
            transform.scale(scale, scale);
            mapGraphics.setTransform(transform);
            mapGraphics.setFont(new Font("Ariel", 1, title_size));
            mapGraphics.setColor(title_color);
            if (this.m_uiContext.getMapData().getBooleanProperty("screenshot.title.enabled")) {
                mapGraphics.drawString(data.getGameName() + " Round " + round, title_x, title_y);
            }
            if (stats_enabled = this.m_uiContext.getMapData().getBooleanProperty("screenshot.stats.enabled")) {
                int stats_y;
                int stats_x;
                Color stats_border_color;
                Color stats_text_color = this.m_uiContext.getMapData().getColorProperty("screenshot.stats.text.color");
                if (stats_text_color == null) {
                    stats_text_color = Color.BLACK;
                }
                if ((stats_border_color = this.m_uiContext.getMapData().getColorProperty("screenshot.stats.border.color")) == null) {
                    stats_border_color = Color.WHITE;
                }
                String s_stats_x = this.m_uiContext.getMapData().getProperty("screenshot.stats.x");
                String s_stats_y = this.m_uiContext.getMapData().getProperty("screenshot.stats.y");
                try {
                    stats_x = (int)((double)Integer.parseInt(s_stats_x) * scale);
                    stats_y = (int)((double)Integer.parseInt(s_stats_y) * scale);
                }
                catch (NumberFormatException nfe) {
                    stats_x = (int)(120.0 * scale);
                    stats_y = (int)(70.0 * scale);
                }
                JTable table = this.m_statsPanel.getStatsTable();
                TableCellRenderer oldRenderer = table.getDefaultRenderer(Object.class);
                Font oldTableFont = table.getFont();
                Font oldTableHeaderFont = table.getTableHeader().getFont();
                Dimension oldTableSize = table.getSize();
                Color oldTableFgColor = table.getForeground();
                Color oldTableSelFgColor = table.getSelectionForeground();
                int oldCol0Width = table.getColumnModel().getColumn(0).getPreferredWidth();
                int oldCol2Width = table.getColumnModel().getColumn(2).getPreferredWidth();
                table.setOpaque(false);
                table.setFont(new Font("Ariel", 1, 15));
                table.setForeground(stats_text_color);
                table.setSelectionForeground(table.getForeground());
                table.setGridColor(stats_border_color);
                table.getTableHeader().setFont(new Font("Ariel", 1, 15));
                table.getColumnModel().getColumn(0).setPreferredWidth(80);
                table.getColumnModel().getColumn(2).setPreferredWidth(90);
                table.setSize(table.getPreferredSize());
                table.doLayout();
                int tableWidth = table.getSize().width;
                int tableHeight = table.getSize().height;
                int hdrWidth = tableWidth;
                int hdrHeight = table.getTableHeader().getSize().height;
                BufferedImage tblHdrImage = Util.createImage(hdrWidth, hdrHeight, false);
                Graphics2D tblHdrGraphics = tblHdrImage.createGraphics();
                BufferedImage tblImage = Util.createImage(tableWidth, tableHeight, true);
                Graphics2D tblGraphics = tblImage.createGraphics();
                DefaultTableCellRenderer renderer = new DefaultTableCellRenderer(){
                    private static final long serialVersionUID = 1978774284876746635L;
                    {
                        this.setOpaque(false);
                    }
                };
                table.setDefaultRenderer(Object.class, renderer);
                table.getTableHeader().print(tblHdrGraphics);
                table.print(tblGraphics);
                mapGraphics.drawImage((Image)tblHdrImage, stats_x, stats_y, null);
                mapGraphics.drawImage((Image)tblImage, stats_x, stats_y + (int)((double)hdrHeight * scale), null);
                tblHdrGraphics.dispose();
                tblGraphics.dispose();
                this.m_statsPanel.setStatsBgImage(null);
                tblHdrImage.flush();
                tblImage.flush();
                table.setDefaultRenderer(Object.class, oldRenderer);
                table.setOpaque(true);
                table.setForeground(oldTableFgColor);
                table.setSelectionForeground(oldTableSelFgColor);
                table.setFont(oldTableFont);
                table.getTableHeader().setFont(oldTableHeaderFont);
                table.setSize(oldTableSize);
                table.getColumnModel().getColumn(0).setPreferredWidth(oldCol0Width);
                table.getColumnModel().getColumn(2).setPreferredWidth(oldCol2Width);
                table.doLayout();
            }
            try {
                ImageIO.write((RenderedImage)mapImage, "png", file);
            }
            catch (Exception e2) {
                e2.printStackTrace();
                JOptionPane.showMessageDialog(this, e2.getMessage(), "Error saving Screenshot", 0);
                retval = false;
            }
        }
        finally {
            mapImage.flush();
            mapGraphics.dispose();
        }
        return retval;
    }

    public void saveScreenshot(final HistoryNode node) {
        FileFilter pngFilter = new FileFilter(){

            public boolean accept(File f) {
                if (f.isDirectory()) {
                    return true;
                }
                return f.getName().endsWith(".png");
            }

            public String getDescription() {
                return "Saved Screenshots, *.png";
            }
        };
        SaveGameFileChooser fileChooser = new SaveGameFileChooser();
        fileChooser.setFileFilter(pngFilter);
        int rVal = fileChooser.showSaveDialog(this);
        if (rVal == 0) {
            int choice;
            File f = fileChooser.getSelectedFile();
            if (!f.getName().toLowerCase().endsWith(".png")) {
                f = new File(f.getParent(), f.getName() + ".png");
            }
            if (f.exists() && (choice = JOptionPane.showConfirmDialog(this, "A file by that name already exists. Do you wish to over write it?", "Over-write?", 0, 2)) != 0) {
                return;
            }
            final File file = f;
            Runnable t = new Runnable(){

                public void run() {
                    if (TripleAFrame.this.saveScreenshot(node, file)) {
                        JOptionPane.showMessageDialog(TripleAFrame.this, "Screenshot Saved", "Screenshot Saved", 1);
                    }
                }
            };
            if (!SwingUtilities.isEventDispatchThread()) {
                try {
                    SwingUtilities.invokeAndWait(t);
                }
                catch (Exception e2) {
                    e2.printStackTrace();
                }
            } else {
                t.run();
            }
        }
    }

    private void setWidgetActivation() {
        if (!SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    TripleAFrame.this.setWidgetActivation();
                }
            });
            return;
        }
        if (this.m_showHistoryAction != null) {
            this.m_showHistoryAction.setEnabled(!this.m_inHistory && !this.m_uiContext.getShowMapOnly());
        }
        if (this.m_showGameAction != null) {
            this.m_showGameAction.setEnabled(!this.m_inGame);
        }
        if (this.m_showMapOnlyAction != null) {
            boolean foundHuman = false;
            for (IGamePlayer gamePlayer : this.m_localPlayers) {
                if (!(gamePlayer instanceof TripleAPlayer)) continue;
                foundHuman = true;
            }
            if (!foundHuman) {
                this.m_showMapOnlyAction.setEnabled(this.m_inGame || this.m_inHistory);
            } else {
                this.m_showMapOnlyAction.setEnabled(false);
            }
        }
        if (this.m_editModeButtonModel != null) {
            if (this.m_editDelegate == null || this.m_uiContext.getShowMapOnly()) {
                this.m_editModeButtonModel.setEnabled(false);
            } else {
                this.m_editModeButtonModel.setEnabled(true);
            }
        }
    }

    public void setEditDelegate(IEditDelegate editDelegate) {
        this.m_editDelegate = editDelegate;
        this.m_dataChangeListener.gameDataChanged(ChangeFactory.EMPTY_CHANGE);
        this.setWidgetActivation();
    }

    public IEditDelegate getEditDelegate() {
        return this.m_editDelegate;
    }

    public ButtonModel getEditModeButtonModel() {
        return this.m_editModeButtonModel;
    }

    public ButtonModel getShowCommentLogButtonModel() {
        return this.m_showCommentLogButtonModel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean getEditMode() {
        boolean isEditMode = false;
        this.m_mapPanel.getData().acquireReadLock();
        try {
            isEditMode = EditDelegate.getEditMode(this.m_mapPanel.getData());
        }
        finally {
            this.m_mapPanel.getData().releaseReadLock();
        }
        return isEditMode;
    }

    public Collection<Unit> moveFightersToCarrier(final Collection<Unit> fighters, final Territory where) {
        final AtomicReference textRef = new AtomicReference();
        final AtomicReference panelRef = new AtomicReference();
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                public void run() {
                    JPanel panel = new JPanel();
                    panel.setLayout(new BorderLayout());
                    ScrollableTextField text = new ScrollableTextField(0, fighters.size());
                    text.setBorder(new EmptyBorder(8, 8, 8, 8));
                    panel.add((Component)text, "Center");
                    panel.add((Component)new JLabel("How many fighters do you want to move from " + where.getName() + " to new carrier?"), "North");
                    panelRef.set(panel);
                    textRef.set(text);
                    panelRef.set(panel);
                }
            });
        }
        catch (InterruptedException e) {
            throw new IllegalStateException(e);
        }
        catch (InvocationTargetException e) {
            throw new IllegalStateException(e);
        }
        int choice = EventThreadJOptionPane.showOptionDialog(this, panelRef.get(), "Place fighters on new carrier?", -1, 2, null, new String[]{"OK", "Cancel"}, "OK");
        if (choice == 0) {
            return new ArrayList<Unit>(new ArrayList<Unit>(fighters).subList(0, ((ScrollableTextField)textRef.get()).getValue()));
        }
        return new ArrayList<Unit>(0);
    }

    public BattlePanel getBattlePanel() {
        return this.m_actionButtons.getBattlePanel();
    }

    public AbstractMovePanel getMovePanel() {
        return this.m_actionButtons.getMovePanel();
    }

    public TechPanel getTechPanel() {
        return this.m_actionButtons.getTechPanel();
    }

    public PlacePanel getPlacePanel() {
        return this.m_actionButtons.getPlacePanel();
    }

    public PurchasePanel getPurchasePanel() {
        return this.m_actionButtons.getPurchasePanel();
    }

    Action getShowGameAction() {
        return this.m_showGameAction;
    }

    Action getShowHistoryAction() {
        return this.m_showHistoryAction;
    }

    Action getShowMapOnlyAction() {
        return this.m_showMapOnlyAction;
    }

    Action getSaveScreenshotAction() {
        return this.m_saveScreenshotAction;
    }

    public UIContext getUIContext() {
        return this.m_uiContext;
    }

    MapPanel getMapPanel() {
        return this.m_mapPanel;
    }

    @Override
    public JComponent getMainPanel() {
        return this.m_mapPanel;
    }

    void updateMap(String mapdir) throws IOException {
        this.m_uiContext.setMapDir(this.m_data, mapdir);
        if (this.m_uiContext.getMapData().getHasRelief()) {
            TileImageFactory.setShowReliefImages(true);
        }
        this.m_mapPanel.setGameData(this.m_data);
        this.m_mapPanel.changeImage(this.m_uiContext.getMapData().getMapDimensions());
        BufferedImage small = this.m_uiContext.getMapImage().getSmallMapImage();
        this.m_smallView.changeImage(small);
        this.m_mapPanel.changeSmallMapOffscreenMap();
        this.m_mapPanel.resetMap();
    }

    @Override
    public IGame getGame() {
        return this.m_game;
    }

    public StatPanel getStatPanel() {
        return this.m_statsPanel;
    }

    void setShowChatTime(boolean showTime) {
        this.m_chatPanel.setShowChatTime(showTime);
    }
}

