/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.triplea.ui;

import games.strategy.engine.data.GameData;
import games.strategy.engine.framework.GameRunner;
import games.strategy.engine.gamePlayer.IGamePlayer;
import games.strategy.sound.ClipPlayer;
import games.strategy.sound.SoundPath;
import games.strategy.triplea.ResourceLoader;
import games.strategy.triplea.image.DiceImageFactory;
import games.strategy.triplea.image.FlagIconImageFactory;
import games.strategy.triplea.image.MapImage;
import games.strategy.triplea.image.PUImageFactory;
import games.strategy.triplea.image.TileImageFactory;
import games.strategy.triplea.image.UnitImageFactory;
import games.strategy.triplea.ui.Active;
import games.strategy.triplea.ui.MapData;
import games.strategy.triplea.ui.screen.IDrawable;
import games.strategy.triplea.util.Stopwatch;
import java.awt.BorderLayout;
import java.awt.Cursor;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.image.BufferedImage;
import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import javax.imageio.ImageIO;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UIContext {
    private static final String UNIT_SCALE_PREF = "UnitScale";
    private static final String MAP_SKIN_PREF = "MapSkin";
    private static final String MAP_SCALE_PREF = "MapScale";
    private static final Logger s_logger = Logger.getLogger(UIContext.class.getName());
    private MapData m_mapData;
    private final TileImageFactory m_tileImageFactory = new TileImageFactory();
    private static String m_mapDir;
    private final UnitImageFactory m_unitImageFactory = new UnitImageFactory();
    private final MapImage m_mapImage;
    private final FlagIconImageFactory m_flagIconImageFactory = new FlagIconImageFactory();
    private DiceImageFactory m_diceImageFactory;
    private final PUImageFactory m_PUImageFactory = new PUImageFactory();
    private boolean m_isShutDown;
    private boolean m_drawUnits = true;
    private boolean m_drawTerritoryEffects = false;
    private boolean m_drawMapOnly = false;
    private IDrawable.OptionalExtraBorderLevel m_extraTerritoryBorderLevel = IDrawable.OptionalExtraBorderLevel.LOW;
    private final List<CountDownLatch> m_latchesToCloseOnShutdown = new ArrayList<CountDownLatch>();
    private final List<Window> m_windowsToCloseOnShutdown = new ArrayList<Window>();
    private final List<Active> m_activeToDeactivate = new ArrayList<Active>();
    private static final String LOCK_MAP = "LockMap";
    private static final String SHOW_BATTLES_BETWEEN_AIS = "ShowBattlesBetweenAIs";
    private static final String AI_PAUSE_DURATION = "AIPauseDuration";
    private Set<IGamePlayer> m_playerList;
    private double m_scale = 1.0;
    private static ResourceLoader m_resourceLoader;
    private Cursor m_cursor = Cursor.getDefaultCursor();

    public UIContext() {
        this.m_mapImage = new MapImage();
    }

    public static ResourceLoader getResourceLoader() {
        return m_resourceLoader;
    }

    public static int getAIPauseDuration() {
        Preferences prefs = Preferences.userNodeForPackage(UIContext.class);
        return prefs.getInt(AI_PAUSE_DURATION, 800);
    }

    public static void setAIPauseDuration(int value) {
        Preferences prefs = Preferences.userNodeForPackage(UIContext.class);
        prefs.putInt(AI_PAUSE_DURATION, value);
        try {
            prefs.flush();
        }
        catch (BackingStoreException ex) {
            ex.printStackTrace();
        }
    }

    public Cursor getCursor() {
        return this.m_cursor;
    }

    public double getScale() {
        return this.m_scale;
    }

    public void setScale(double scale) {
        this.m_scale = scale;
        this.m_tileImageFactory.setScale(scale);
        Preferences prefs = UIContext.getPreferencesMapOrSkin(UIContext.getMapDir());
        prefs.putDouble(MAP_SCALE_PREF, scale);
        try {
            prefs.flush();
        }
        catch (BackingStoreException e) {
            e.printStackTrace();
        }
    }

    private static Preferences getPreferencesForMap(String mapName) {
        return Preferences.userNodeForPackage(UIContext.class).node(mapName);
    }

    private static Preferences getPreferencesMapOrSkin(String mapDir) {
        return Preferences.userNodeForPackage(UIContext.class).node(mapDir);
    }

    private static String getDefaultMapDir(GameData data) {
        String mapName = (String)data.getProperties().get("mapName");
        if (mapName == null || mapName.trim().length() == 0) {
            throw new IllegalStateException("Map name property not set on game");
        }
        Preferences prefs = UIContext.getPreferencesForMap(mapName);
        String mapDir = prefs.get(MAP_SKIN_PREF, mapName);
        try {
            ResourceLoader.getMapResourceLoader(mapDir).close();
        }
        catch (RuntimeException re) {
            prefs.remove(MAP_SKIN_PREF);
            return mapName;
        }
        return mapDir;
    }

    public void setDefaultMapDir(GameData data) {
        this.internalSetMapDir(UIContext.getDefaultMapDir(data), data);
    }

    public void setMapDir(GameData data, String mapDir) {
        this.internalSetMapDir(mapDir, data);
        this.getMapData().verify(data);
        String mapName = (String)data.getProperties().get("mapName");
        Preferences prefs = UIContext.getPreferencesForMap(mapName);
        prefs.put(MAP_SKIN_PREF, mapDir);
        try {
            prefs.flush();
        }
        catch (BackingStoreException e) {
            e.printStackTrace();
        }
    }

    private void internalSetMapDir(String dir, final GameData data) {
        Stopwatch stopWatch = new Stopwatch(s_logger, Level.FINE, "Loading UI Context");
        m_resourceLoader = ResourceLoader.getMapResourceLoader(dir);
        if (this.m_mapData != null) {
            this.m_mapData.close();
        }
        this.m_mapData = new MapData(m_resourceLoader);
        this.m_diceImageFactory = new DiceImageFactory(m_resourceLoader, data.getDiceSides());
        double unitScale = UIContext.getPreferencesMapOrSkin(dir).getDouble(UNIT_SCALE_PREF, this.m_mapData.getDefaultUnitScale());
        this.m_scale = UIContext.getPreferencesMapOrSkin(dir).getDouble(MAP_SCALE_PREF, 1.0);
        if (this.m_scale < 1.0) {
            this.setDrawTerritoryBordersAgainToMedium();
        }
        this.m_unitImageFactory.setResourceLoader(m_resourceLoader, unitScale, this.m_mapData.getDefaultUnitWidth(), this.m_mapData.getDefaultUnitHeight(), this.m_mapData.getDefaultUnitCounterOffsetWidth(), this.m_mapData.getDefaultUnitCounterOffsetHeight());
        this.m_flagIconImageFactory.setResourceLoader(m_resourceLoader);
        this.m_PUImageFactory.setResourceLoader(m_resourceLoader);
        this.m_tileImageFactory.setMapDir(m_resourceLoader);
        this.m_tileImageFactory.setScale(this.m_scale);
        this.m_mapImage.loadMaps(m_resourceLoader);
        m_mapDir = dir;
        this.m_drawTerritoryEffects = this.m_mapData.useTerritoryEffectMarkers();
        Runnable loadSounds = new Runnable(){

            public void run() {
                ClipPlayer.getInstance(m_resourceLoader, data);
                SoundPath.preLoadSounds(SoundPath.SoundType.TRIPLEA);
            }
        };
        new Thread(loadSounds, "Triplea sound loader").start();
        this.m_cursor = Cursor.getDefaultCursor();
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        URL cursorURL = m_resourceLoader.getResource("misc" + File.separator + "cursor.gif");
        if (cursorURL != null) {
            try {
                BufferedImage image = ImageIO.read(cursorURL);
                if (image != null) {
                    Point hotSpot = new Point(this.m_mapData.getMapCursorHotspotX(), this.m_mapData.getMapCursorHotspotY());
                    this.m_cursor = toolkit.createCustomCursor(image, hotSpot, data.getGameName() + " Cursor");
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        stopWatch.done();
    }

    public MapData getMapData() {
        return this.m_mapData;
    }

    public static String getMapDir() {
        return m_mapDir;
    }

    public TileImageFactory getTileImageFactory() {
        return this.m_tileImageFactory;
    }

    public UnitImageFactory getUnitImageFactory() {
        return this.m_unitImageFactory;
    }

    public MapImage getMapImage() {
        return this.m_mapImage;
    }

    public FlagIconImageFactory getFlagImageFactory() {
        return this.m_flagIconImageFactory;
    }

    public PUImageFactory getPUImageFactory() {
        return this.m_PUImageFactory;
    }

    public DiceImageFactory getDiceImageFactory() {
        return this.m_diceImageFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addShutdownLatch(CountDownLatch latch) {
        UIContext uIContext = this;
        synchronized (uIContext) {
            if (this.m_isShutDown) {
                this.releaseLatch(latch);
                return;
            }
            this.m_latchesToCloseOnShutdown.add(latch);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeACtive(Active actor) {
        UIContext uIContext = this;
        synchronized (uIContext) {
            this.m_activeToDeactivate.remove(actor);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addActive(Active actor) {
        UIContext uIContext = this;
        synchronized (uIContext) {
            if (this.m_isShutDown) {
                this.closeActor(actor);
                return;
            }
            this.m_activeToDeactivate.add(actor);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeShutdownLatch(CountDownLatch latch) {
        UIContext uIContext = this;
        synchronized (uIContext) {
            this.m_latchesToCloseOnShutdown.remove(latch);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addShutdownWindow(Window window) {
        UIContext uIContext = this;
        synchronized (uIContext) {
            if (this.m_isShutDown) {
                UIContext.closeWindow(window);
                return;
            }
            this.m_windowsToCloseOnShutdown.add(window);
        }
    }

    private static void closeWindow(final Window window) {
        window.setVisible(false);
        window.dispose();
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                if (window instanceof JFrame) {
                    JFrame frame = (JFrame)window;
                    JMenuBar menu = frame.getJMenuBar();
                    if (menu != null) {
                        while (menu.getMenuCount() > 0) {
                            menu.remove(0);
                        }
                    }
                    frame.setMenuBar(null);
                    frame.setJMenuBar(null);
                    frame.getRootPane().removeAll();
                    frame.getRootPane().setJMenuBar(null);
                    frame.getContentPane().removeAll();
                    frame.getContentPane().setLayout(new BorderLayout());
                    frame.setContentPane(new JPanel());
                    frame.setIconImage(null);
                    UIContext.clearInputMap(frame.getRootPane());
                }
            }
        });
    }

    private static void clearInputMap(JComponent c) {
        c.getInputMap(2).clear();
        c.getInputMap(0).clear();
        c.getInputMap(1).clear();
        c.getActionMap().clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeShutdownWindow(Window window) {
        UIContext uIContext = this;
        synchronized (uIContext) {
            this.m_latchesToCloseOnShutdown.remove(window);
        }
    }

    private void releaseLatch(CountDownLatch latch) {
        while (latch.getCount() > 0L) {
            latch.countDown();
        }
    }

    public boolean isShutDown() {
        return this.m_isShutDown;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutDown() {
        UIContext uIContext = this;
        synchronized (uIContext) {
            if (this.m_isShutDown) {
                return;
            }
            this.m_isShutDown = true;
        }
        for (CountDownLatch latch : this.m_latchesToCloseOnShutdown) {
            this.releaseLatch(latch);
        }
        for (Window window : this.m_windowsToCloseOnShutdown) {
            UIContext.closeWindow(window);
        }
        for (Active actor : this.m_activeToDeactivate) {
            this.closeActor(actor);
        }
        this.m_activeToDeactivate.clear();
        this.m_windowsToCloseOnShutdown.clear();
        this.m_latchesToCloseOnShutdown.clear();
        this.m_mapData.close();
    }

    public static Map<String, String> getSkins(GameData data) {
        String mapName = data.getProperties().get("mapName").toString();
        LinkedHashMap<String, String> rVal = new LinkedHashMap<String, String>();
        rVal.put("Original", mapName);
        UIContext.getSkins(mapName, rVal, new File(GameRunner.getRootFolder(), "maps"));
        UIContext.getSkins(mapName, rVal, GameRunner.getUserMapsFolder());
        return rVal;
    }

    private static void getSkins(String mapName, Map<String, String> rVal, File root) {
        File[] files = root.listFiles();
        if (files == null) {
            return;
        }
        for (File f : files) {
            if (!f.isDirectory()) {
                if (!f.getName().endsWith(".zip") || !f.getName().startsWith(mapName + "-")) continue;
                String nameWithExtension = f.getName().substring(f.getName().indexOf(45) + 1);
                rVal.put(nameWithExtension.substring(0, nameWithExtension.length() - 4), f.getName().substring(0, f.getName().length() - 4));
                continue;
            }
            if (!f.getName().startsWith(mapName + "-")) continue;
            rVal.put(f.getName().substring(f.getName().indexOf(45) + 1), f.getName());
        }
    }

    private void closeActor(Active actor) {
        try {
            actor.deactivate();
        }
        catch (RuntimeException re) {
            re.printStackTrace();
        }
    }

    public boolean getShowUnits() {
        return this.m_drawUnits;
    }

    public void setShowUnits(boolean aBool) {
        this.m_drawUnits = aBool;
    }

    public IDrawable.OptionalExtraBorderLevel getDrawTerritoryBordersAgain() {
        return this.m_extraTerritoryBorderLevel;
    }

    public void setDrawTerritoryBordersAgain(IDrawable.OptionalExtraBorderLevel level) {
        this.m_extraTerritoryBorderLevel = level;
    }

    public void resetDrawTerritoryBordersAgain() {
        this.m_extraTerritoryBorderLevel = IDrawable.OptionalExtraBorderLevel.LOW;
    }

    public void setDrawTerritoryBordersAgainToMedium() {
        this.m_extraTerritoryBorderLevel = IDrawable.OptionalExtraBorderLevel.MEDIUM;
    }

    public void setShowTerritoryEffects(boolean aBool) {
        this.m_drawTerritoryEffects = aBool;
    }

    public boolean getShowTerritoryEffects() {
        return this.m_drawTerritoryEffects;
    }

    public boolean getShowMapOnly() {
        return this.m_drawMapOnly;
    }

    public void setShowMapOnly(boolean aBool) {
        this.m_drawMapOnly = aBool;
    }

    public boolean getLockMap() {
        Preferences prefs = Preferences.userNodeForPackage(UIContext.class);
        return prefs.getBoolean(LOCK_MAP, false);
    }

    public void setLockMap(boolean aBool) {
        Preferences prefs = Preferences.userNodeForPackage(UIContext.class);
        prefs.putBoolean(LOCK_MAP, aBool);
        try {
            prefs.flush();
        }
        catch (BackingStoreException ex) {
            ex.printStackTrace();
        }
    }

    public boolean getShowBattlesBetweenAIs() {
        Preferences prefs = Preferences.userNodeForPackage(UIContext.class);
        return prefs.getBoolean(SHOW_BATTLES_BETWEEN_AIS, true);
    }

    public void setShowBattlesBetweenAIs(boolean aBool) {
        Preferences prefs = Preferences.userNodeForPackage(UIContext.class);
        prefs.putBoolean(SHOW_BATTLES_BETWEEN_AIS, aBool);
        try {
            prefs.flush();
        }
        catch (BackingStoreException ex) {
            ex.printStackTrace();
        }
    }

    public Set<IGamePlayer> getPlayerList() {
        return this.m_playerList;
    }

    public void setPlayerList(Set<IGamePlayer> value) {
        this.m_playerList = value;
    }

    public void setUnitScaleFactor(double scaleFactor) {
        this.m_unitImageFactory.setScaleFactor(scaleFactor);
        Preferences prefs = UIContext.getPreferencesMapOrSkin(UIContext.getMapDir());
        prefs.putDouble(UNIT_SCALE_PREF, scaleFactor);
        try {
            prefs.flush();
        }
        catch (BackingStoreException e) {
            e.printStackTrace();
        }
    }
}

