/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.triplea.ui;

import games.strategy.engine.data.GameData;
import games.strategy.engine.data.Unit;
import games.strategy.triplea.delegate.dataObjects.CasualtyList;
import games.strategy.triplea.ui.ChooserEntry;
import games.strategy.triplea.ui.UIContext;
import games.strategy.triplea.util.UnitCategory;
import games.strategy.triplea.util.UnitSeperator;
import games.strategy.ui.ScrollableTextField;
import games.strategy.ui.ScrollableTextFieldListener;
import games.strategy.util.IntegerMap;
import games.strategy.util.Match;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UnitChooser
extends JPanel {
    private static final long serialVersionUID = -4667032237550267682L;
    private final List<ChooserEntry> m_entries = new ArrayList<ChooserEntry>();
    private final Map<Unit, Collection<Unit>> m_dependents;
    private JTextArea m_title;
    private int m_total = -1;
    private final JLabel m_leftToSelect = new JLabel();
    private final GameData m_data;
    private boolean m_allowTwoHit = false;
    private JButton m_autoSelectButton;
    private JButton m_selectNoneButton;
    private final UIContext m_uiContext;
    private final Match<Collection<Unit>> m_match;
    private final ScrollableTextFieldListener m_textFieldListener = new ScrollableTextFieldListener(){

        public void changedValue(ScrollableTextField field) {
            if (UnitChooser.this.m_match != null) {
                UnitChooser.this.checkMatches();
            } else {
                UnitChooser.this.updateLeft();
            }
        }
    };

    public UnitChooser(Collection<Unit> units, Map<Unit, Collection<Unit>> dependent, boolean categorizeMovement, boolean categorizeTransportCost, GameData data, UIContext context) {
        this.m_dependents = dependent;
        this.m_data = data;
        this.m_uiContext = context;
        this.m_match = null;
        this.createEntries(units, dependent, categorizeMovement, categorizeTransportCost, Collections.<Unit>emptyList());
        this.layoutEntries();
    }

    public UnitChooser(Collection<Unit> units, Map<Unit, Collection<Unit>> dependent, boolean categorizeMovement, boolean categorizeTransportCost, GameData data, UIContext context, Match<Collection<Unit>> match) {
        this.m_match = match;
        this.m_dependents = dependent;
        this.m_data = data;
        this.m_uiContext = context;
        this.createEntries(units, dependent, categorizeMovement, categorizeTransportCost, Collections.<Unit>emptyList());
        this.layoutEntries();
    }

    public UnitChooser(Collection<Unit> units, Map<Unit, Collection<Unit>> dependent, GameData data, boolean allowTwoHit, UIContext uiContext) {
        this(units, Collections.emptyList(), dependent, data, allowTwoHit, uiContext);
    }

    public UnitChooser(Collection<Unit> units, Collection<Unit> defaultSelections, Map<Unit, Collection<Unit>> dependent, GameData data, boolean allowTwoHit, UIContext uiContext) {
        this(units, defaultSelections, dependent, false, false, data, allowTwoHit, uiContext);
    }

    public UnitChooser(Collection<Unit> units, CasualtyList defaultSelections, Map<Unit, Collection<Unit>> dependent, GameData data, boolean allowTwoHit, UIContext uiContext) {
        this.m_dependents = dependent;
        this.m_data = data;
        this.m_allowTwoHit = allowTwoHit;
        this.m_uiContext = uiContext;
        this.m_match = null;
        List<Unit> combinedList = defaultSelections.getDamaged();
        combinedList.addAll(defaultSelections.getKilled());
        this.createEntries(units, dependent, false, false, combinedList);
        this.layoutEntries();
    }

    public UnitChooser(Collection<Unit> units, Collection<Unit> defaultSelections, Map<Unit, Collection<Unit>> dependent, boolean categorizeMovement, boolean categorizeTransportCost, GameData data, boolean allowTwoHit, UIContext uiContext) {
        this.m_dependents = dependent;
        this.m_data = data;
        this.m_allowTwoHit = allowTwoHit;
        this.m_uiContext = uiContext;
        this.m_match = null;
        this.createEntries(units, dependent, categorizeMovement, categorizeTransportCost, defaultSelections);
        this.layoutEntries();
    }

    public UnitChooser(Collection<Unit> units, Collection<Unit> defaultSelections, Map<Unit, Collection<Unit>> dependent, boolean categorizeMovement, boolean categorizeTransportCost, GameData data, boolean allowTwoHit, UIContext uiContext, Match<Collection<Unit>> match) {
        this.m_dependents = dependent;
        this.m_data = data;
        this.m_allowTwoHit = allowTwoHit;
        this.m_uiContext = uiContext;
        this.m_match = match;
        this.createEntries(units, dependent, categorizeMovement, categorizeTransportCost, defaultSelections);
        this.layoutEntries();
    }

    public UnitChooser(Collection<Unit> units, Collection<Unit> defaultSelections, Map<Unit, Collection<Unit>> dependent, boolean categorizeMovement, boolean categorizeTransportCost, boolean categorizeTerritories, GameData data, boolean allowTwoHit, UIContext uiContext, Match<Collection<Unit>> match) {
        this.m_dependents = dependent;
        this.m_data = data;
        this.m_allowTwoHit = allowTwoHit;
        this.m_uiContext = uiContext;
        this.m_match = match;
        this.createEntries(units, dependent, categorizeMovement, categorizeTransportCost, categorizeTerritories, defaultSelections);
        this.layoutEntries();
    }

    public void setMax(int max) {
        this.m_total = max;
        this.m_textFieldListener.changedValue(null);
        this.m_autoSelectButton.setVisible(false);
        this.m_selectNoneButton.setVisible(false);
    }

    public void setMaxAndShowMaxButton(int max) {
        this.m_total = max;
        this.m_textFieldListener.changedValue(null);
        this.m_autoSelectButton.setText("Max");
    }

    public void setTitle(String title) {
        this.m_title.setText(title);
    }

    private void updateLeft() {
        if (this.m_total == -1) {
            return;
        }
        int selected = this.getSelectedCount();
        this.m_leftToSelect.setText("Left to select:" + (this.m_total - selected));
        for (ChooserEntry entry : this.m_entries) {
            entry.setLeftToSelect(this.m_total - selected);
        }
        this.m_leftToSelect.setText("Left to select:" + (this.m_total - selected));
    }

    private void checkMatches() {
        ArrayList<Unit> allSelectedUnits = new ArrayList<Unit>();
        for (ChooserEntry entry : this.m_entries) {
            this.addToCollection(allSelectedUnits, entry, entry.getTotalHits(), false);
        }
        for (ChooserEntry entry : this.m_entries) {
            ArrayList<Unit> newSelectedUnits = new ArrayList<Unit>(allSelectedUnits);
            int totalHits = entry.getTotalHits();
            int totalUnits = entry.getCategory().getUnits().size();
            int leftToSelect = 0;
            Iterator<Unit> unitIter = entry.getCategory().getUnits().iterator();
            for (int i = 1; i <= totalUnits; ++i) {
                Unit unit = unitIter.next();
                if (i > totalHits) {
                    newSelectedUnits.add(unit);
                }
                if (i < totalHits) continue;
                if (!this.m_match.match(newSelectedUnits)) break;
                leftToSelect = i - totalHits;
            }
            entry.setLeftToSelect(leftToSelect);
        }
    }

    private int getSelectedCount() {
        int selected = 0;
        for (ChooserEntry entry : this.m_entries) {
            selected += entry.getTotalHits();
        }
        return selected;
    }

    private void createEntries(Collection<Unit> units, Map<Unit, Collection<Unit>> dependent, boolean categorizeMovement, boolean categorizeTransportCost, Collection<Unit> defaultSelections) {
        Set<UnitCategory> categories = UnitSeperator.categorize(units, dependent, categorizeMovement, categorizeTransportCost);
        Set<UnitCategory> defaultSelectionsCategorized = UnitSeperator.categorize(defaultSelections, dependent, categorizeMovement, categorizeTransportCost);
        IntegerMap<UnitCategory> defaultValues = this.createDefaultSelectionsMap(defaultSelectionsCategorized);
        for (UnitCategory category : categories) {
            this.addCategory(category, defaultValues.getInt(category));
        }
    }

    private void createEntries(Collection<Unit> units, Map<Unit, Collection<Unit>> dependent, boolean categorizeMovement, boolean categorizeTransportCost, boolean categorizeTerritories, Collection<Unit> defaultSelections) {
        Set<UnitCategory> categories = UnitSeperator.categorize(dependent, units, categorizeMovement, categorizeTransportCost, categorizeTerritories);
        Set<UnitCategory> defaultSelectionsCategorized = UnitSeperator.categorize(defaultSelections, dependent, categorizeMovement, categorizeTransportCost);
        IntegerMap<UnitCategory> defaultValues = this.createDefaultSelectionsMap(defaultSelectionsCategorized);
        for (UnitCategory category : categories) {
            this.addCategory(category, defaultValues.getInt(category));
        }
    }

    private IntegerMap<UnitCategory> createDefaultSelectionsMap(Collection<UnitCategory> categories) {
        IntegerMap<UnitCategory> defaultValues = new IntegerMap<UnitCategory>();
        for (UnitCategory category : categories) {
            int defaultValue = category.getUnits().size();
            defaultValues.put(category, defaultValue);
        }
        return defaultValues;
    }

    private void addCategory(UnitCategory category, int defaultValue) {
        ChooserEntry entry = new ChooserEntry(category, this.m_textFieldListener, this.m_data, this.m_allowTwoHit, defaultValue, this.m_uiContext);
        this.m_entries.add(entry);
    }

    private void layoutEntries() {
        this.setLayout(new GridBagLayout());
        this.m_title = new JTextArea("Choose units");
        this.m_title.setBackground(this.getBackground());
        this.m_title.setEditable(false);
        this.m_title.setWrapStyleWord(true);
        Insets nullInsets = new Insets(0, 0, 0, 0);
        Dimension buttonSize = new Dimension(80, 20);
        this.m_selectNoneButton = new JButton("None");
        this.m_selectNoneButton.setPreferredSize(buttonSize);
        this.m_autoSelectButton = new JButton("All");
        this.m_autoSelectButton.setPreferredSize(buttonSize);
        this.add((Component)this.m_title, new GridBagConstraints(0, 0, 7, 1, 0.0, 0.5, 13, 2, nullInsets, 0, 0));
        this.m_selectNoneButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                UnitChooser.this.selectNone();
            }
        });
        this.m_autoSelectButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                UnitChooser.this.autoSelect();
            }
        });
        int yIndex = 1;
        for (ChooserEntry entry : this.m_entries) {
            entry.createComponents(this, yIndex);
            ++yIndex;
        }
        this.add((Component)this.m_autoSelectButton, new GridBagConstraints(0, yIndex, 7, 1, 0.0, 0.5, 13, 0, nullInsets, 0, 0));
        this.add((Component)this.m_leftToSelect, new GridBagConstraints(0, ++yIndex, 5, 2, 0.0, 0.5, 17, 2, nullInsets, 0, 0));
        if (this.m_match != null) {
            this.m_autoSelectButton.setVisible(false);
            this.m_selectNoneButton.setVisible(false);
            this.checkMatches();
        }
    }

    public Collection<Unit> getSelected() {
        return this.getSelected(true);
    }

    public List<Unit> getSelected(boolean selectDependents) {
        ArrayList<Unit> selectedUnits = new ArrayList<Unit>();
        for (ChooserEntry entry : this.m_entries) {
            if (entry.isTwoHit()) {
                this.addToCollection(selectedUnits, entry, entry.getSecondHits(), selectDependents);
                continue;
            }
            this.addToCollection(selectedUnits, entry, entry.getFirstHits(), selectDependents);
        }
        return selectedUnits;
    }

    public List<Unit> getSelectedFirstHit() {
        ArrayList<Unit> selectedUnits = new ArrayList<Unit>();
        for (ChooserEntry chooserEntry : this.m_entries) {
            if (!chooserEntry.isTwoHit()) continue;
            this.addToCollection(selectedUnits, chooserEntry, chooserEntry.getFirstHits(), false);
        }
        return selectedUnits;
    }

    private void selectNone() {
        for (ChooserEntry entry : this.m_entries) {
            entry.selectNone();
        }
    }

    private void autoSelect() {
        if (this.m_total == -1) {
            for (ChooserEntry entry : this.m_entries) {
                entry.selectAll();
            }
        } else {
            int leftToSelect = this.m_total - this.getSelectedCount();
            for (ChooserEntry entry : this.m_entries) {
                int canSelect = entry.getMax() - entry.getFirstHits();
                if (leftToSelect >= canSelect) {
                    entry.selectAll();
                    leftToSelect -= canSelect;
                    continue;
                }
                entry.set(entry.getFirstHits() + canSelect);
                leftToSelect = 0;
                break;
            }
        }
    }

    private void addToCollection(Collection<Unit> addTo, ChooserEntry entry, int quantity, boolean addDependents) {
        List<Unit> possible = entry.getCategory().getUnits();
        if (possible.size() < quantity) {
            throw new IllegalStateException("Not enough units");
        }
        Iterator iter = possible.iterator();
        for (int i = 0; i < quantity; ++i) {
            Collection<Unit> dependents;
            Unit current = (Unit)iter.next();
            addTo.add(current);
            if (!addDependents || (dependents = this.m_dependents.get(current)) == null) continue;
            addTo.addAll(dependents);
        }
    }
}

