/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.triplea.ui.display;

import games.strategy.engine.data.PlayerID;
import games.strategy.engine.data.Territory;
import games.strategy.engine.data.Unit;
import games.strategy.engine.display.IDisplayBridge;
import games.strategy.net.GUID;
import games.strategy.triplea.delegate.DiceRoll;
import games.strategy.triplea.delegate.Die;
import games.strategy.triplea.delegate.IBattle;
import games.strategy.triplea.ui.TripleAFrame;
import games.strategy.triplea.ui.display.ITripleaDisplay;
import java.util.Collection;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TripleaDisplay
implements ITripleaDisplay {
    private IDisplayBridge m_displayBridge;
    private final TripleAFrame m_ui;

    public TripleaDisplay(TripleAFrame ui) {
        this.m_ui = ui;
    }

    @Override
    public void initialize(IDisplayBridge bridge) {
        this.m_displayBridge = bridge;
        this.m_displayBridge.toString();
    }

    @Override
    public void showBattle(GUID battleID, Territory location, String battleTitle, Collection<Unit> attackingUnits, Collection<Unit> defendingUnits, Collection<Unit> killedUnits, Collection<Unit> attackingWaitingToDie, Collection<Unit> defendingWaitingToDie, Map<Unit, Collection<Unit>> unit_dependents, PlayerID attacker, PlayerID defender, boolean isAmphibious, IBattle.BattleType battleType) {
        this.m_ui.getBattlePanel().showBattle(battleID, location, battleTitle, attackingUnits, defendingUnits, killedUnits, attackingWaitingToDie, defendingWaitingToDie, unit_dependents, attacker, defender, isAmphibious, battleType);
    }

    @Override
    public void listBattleSteps(GUID battleID, List<String> steps) {
        this.m_ui.getBattlePanel().listBattle(battleID, steps);
    }

    @Override
    public void casualtyNotification(GUID battleID, String step, DiceRoll dice, PlayerID player, Collection<Unit> killed, Collection<Unit> damaged, Map<Unit, Collection<Unit>> dependents) {
        this.m_ui.getBattlePanel().casualtyNotification(step, dice, player, killed, damaged, dependents);
    }

    @Override
    public void deadUnitNotification(GUID battleID, PlayerID player, Collection<Unit> killed, Map<Unit, Collection<Unit>> dependents) {
        this.m_ui.getBattlePanel().deadUnitNotification(player, killed, dependents);
    }

    @Override
    public void changedUnitsNotification(GUID battleID, PlayerID player, Collection<Unit> removedUnits, Collection<Unit> addedUnits, Map<Unit, Collection<Unit>> dependents) {
        this.m_ui.getBattlePanel().changedUnitsNotification(player, removedUnits, addedUnits, dependents);
    }

    @Override
    public void battleEnd(GUID battleID, String message) {
        this.m_ui.getBattlePanel().battleEndMessage(battleID, message);
    }

    @Override
    public void bombingResults(GUID battleID, List<Die> dice, int cost) {
        this.m_ui.getBattlePanel().bombingResults(battleID, dice, cost);
    }

    @Override
    public void notifyRetreat(String shortMessage, String message, String step, PlayerID retreatingPlayer) {
        if (this.m_ui.playing(retreatingPlayer)) {
            return;
        }
        this.m_ui.getBattlePanel().notifyRetreat(shortMessage, message, step, retreatingPlayer);
    }

    @Override
    public void notifyDice(GUID battleId, DiceRoll dice, String stepName) {
        this.m_ui.getBattlePanel().showDice(null, dice, stepName);
    }

    @Override
    public void notifyRetreat(GUID battleId, Collection<Unit> retreating) {
        this.m_ui.getBattlePanel().notifyRetreat(retreating);
    }

    @Override
    public void gotoBattleStep(GUID battleId, String step) {
        this.m_ui.getBattlePanel().gotoStep(battleId, step);
    }

    @Override
    public void shutDown() {
        this.m_ui.stopGame();
    }
}

