/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.triplea.ui.history;

import games.strategy.engine.data.GameData;
import games.strategy.engine.data.Territory;
import games.strategy.engine.data.Unit;
import games.strategy.engine.history.HistoryNode;
import games.strategy.engine.history.Renderable;
import games.strategy.triplea.delegate.DiceRoll;
import games.strategy.triplea.delegate.dataObjects.MoveDescription;
import games.strategy.triplea.delegate.dataObjects.PlacementDescription;
import games.strategy.triplea.ui.DicePanel;
import games.strategy.triplea.ui.MapPanel;
import games.strategy.triplea.ui.SimpleUnitPanel;
import games.strategy.triplea.util.UnitCategory;
import games.strategy.triplea.util.UnitSeperator;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import javax.swing.Box;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HistoryDetailsPanel
extends JPanel {
    private static final long serialVersionUID = 5092004144144006960L;
    private final GameData m_data;
    private final JTextArea m_title = new JTextArea();
    private final JScrollPane m_scroll = new JScrollPane(this.m_title);
    private final MapPanel m_mapPanel;

    public HistoryDetailsPanel(GameData data, MapPanel mapPanel) {
        this.m_data = data;
        this.setLayout(new GridBagLayout());
        this.m_title.setWrapStyleWord(true);
        this.m_title.setBackground(this.getBackground());
        this.m_title.setLineWrap(true);
        this.m_title.setBorder(null);
        this.m_title.setEditable(false);
        this.m_scroll.setBorder(null);
        this.m_mapPanel = mapPanel;
    }

    public void render(HistoryNode node) {
        this.removeAll();
        this.m_mapPanel.setRoute(null);
        Insets insets = new Insets(5, 0, 0, 0);
        this.m_title.setText(node.getTitle());
        this.add((Component)this.m_scroll, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.1, 11, 1, insets, 0, 0));
        GridBagConstraints mainConstraints = new GridBagConstraints(0, 1, 1, 1, 1.0, 0.9, 11, 1, insets, 0, 0);
        if (node instanceof Renderable) {
            Territory t;
            Object details = ((Renderable)((Object)node)).getRenderingData();
            if (details instanceof DiceRoll) {
                DicePanel dicePanel = new DicePanel(this.m_mapPanel.getUIContext(), this.m_data);
                dicePanel.setDiceRoll((DiceRoll)details);
                this.add((Component)dicePanel, mainConstraints);
            } else if (details instanceof MoveDescription) {
                MoveDescription moveMessage = (MoveDescription)details;
                this.renderUnits(mainConstraints, moveMessage.getUnits());
                this.m_mapPanel.setRoute(moveMessage.getRoute());
                if (!this.m_mapPanel.isShowing(moveMessage.getRoute().getEnd())) {
                    this.m_mapPanel.centerOn(moveMessage.getRoute().getEnd());
                }
            } else if (details instanceof PlacementDescription) {
                PlacementDescription placeMessage = (PlacementDescription)details;
                this.renderUnits(mainConstraints, placeMessage.getUnits());
                if (!this.m_mapPanel.isShowing(placeMessage.getTerritory())) {
                    this.m_mapPanel.centerOn(placeMessage.getTerritory());
                }
            } else if (details instanceof Collection) {
                Object obj;
                Collection objects = (Collection)details;
                Iterator objIter = objects.iterator();
                if (objIter.hasNext() && (obj = objIter.next()) instanceof Unit) {
                    Collection units = (Collection)details;
                    this.renderUnits(mainConstraints, units);
                }
            } else if (details instanceof Territory && !this.m_mapPanel.isShowing(t = (Territory)details)) {
                this.m_mapPanel.centerOn(t);
            }
        }
        this.add(Box.createGlue());
        this.validate();
        this.repaint();
    }

    private void renderUnits(GridBagConstraints mainConstraints, Collection<Unit> units) {
        Set<UnitCategory> unitsCategories = UnitSeperator.categorize(units);
        SimpleUnitPanel unitsPanel = new SimpleUnitPanel(this.m_mapPanel.getUIContext());
        unitsPanel.setUnitsFromCategories(unitsCategories, this.m_data);
        this.add((Component)unitsPanel, mainConstraints);
    }
}

