/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.triplea.ui.history;

import games.strategy.engine.data.GameData;
import games.strategy.engine.data.PlayerID;
import games.strategy.engine.data.Territory;
import games.strategy.engine.data.Unit;
import games.strategy.engine.history.HistoryNode;
import games.strategy.engine.history.Renderable;
import games.strategy.engine.history.Round;
import games.strategy.engine.history.Step;
import games.strategy.engine.random.IRandomStats;
import games.strategy.engine.random.RandomStatsDetails;
import games.strategy.triplea.attatchments.TerritoryAttachment;
import games.strategy.triplea.delegate.DiceRoll;
import games.strategy.triplea.delegate.Matches;
import games.strategy.triplea.delegate.MoveDelegate;
import games.strategy.triplea.delegate.OriginalOwnerTracker;
import games.strategy.triplea.delegate.dataObjects.MoveDescription;
import games.strategy.triplea.formatter.MyFormatter;
import games.strategy.util.IntegerMap;
import java.awt.BorderLayout;
import java.awt.Component;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HistoryLog
extends JFrame {
    private static final long serialVersionUID = 4880602702815333376L;
    private final JTextArea m_textArea = new JTextArea(40, 80);
    private final StringWriter m_stringWriter;
    private final PrintWriter m_printWriter;

    public HistoryLog() {
        this.m_textArea.setEditable(false);
        JScrollPane scrollingArea = new JScrollPane(this.m_textArea);
        JPanel content = new JPanel();
        content.setLayout(new BorderLayout());
        content.add((Component)scrollingArea, "Center");
        this.m_stringWriter = new StringWriter();
        this.m_printWriter = new PrintWriter(this.m_stringWriter);
        this.setContentPane(content);
        this.setTitle("History Log");
        this.pack();
        this.setLocationRelativeTo(null);
    }

    public PrintWriter getWriter() {
        return this.m_printWriter;
    }

    @Override
    public String toString() {
        return this.m_stringWriter.toString();
    }

    public void clear() {
        this.m_stringWriter.getBuffer().delete(0, this.m_stringWriter.getBuffer().length());
        this.m_textArea.setText("");
    }

    public void printFullTurn(GameData data, boolean verbose, Collection<PlayerID> playersAllowed) {
        HistoryNode printNode;
        HistoryNode curNode = printNode = data.getHistory().getLastNode();
        Step stepNode = null;
        Step turnStartNode = null;
        PlayerID curPlayer = null;
        HashSet<PlayerID> players = new HashSet<PlayerID>();
        if (playersAllowed != null) {
            players.addAll(playersAllowed);
        }
        while (curNode != null) {
            if (curNode instanceof Step) {
                stepNode = (Step)curNode;
                break;
            }
            curNode = (HistoryNode)curNode.getPreviousNode();
        }
        if (stepNode != null) {
            curPlayer = stepNode.getPlayerID();
            if (players.isEmpty()) {
                players.add(curPlayer);
            }
            while (stepNode != null) {
                turnStartNode = stepNode;
                if ((stepNode = (Step)stepNode.getPreviousSibling()) != null && stepNode.getPlayerID() != null && players.contains(stepNode.getPlayerID())) continue;
            }
            this.printRemainingTurn(turnStartNode, verbose, data.getDiceSides(), players);
        } else {
            System.err.println("No Step node found!");
        }
    }

    private static PlayerID getPlayerID(HistoryNode printNode) {
        DefaultMutableTreeNode curNode = printNode;
        TreePath parentPath = new TreePath(printNode.getPath()).getParentPath();
        PlayerID curPlayer = null;
        if (parentPath != null) {
            Object[] pathToNode;
            for (Object pathNode : pathToNode = parentPath.getPath()) {
                HistoryNode node = (HistoryNode)pathNode;
                if (!(node instanceof Step)) continue;
                curPlayer = ((Step)node).getPlayerID();
            }
        }
        do {
            Enumeration<TreeNode> nodeEnum = curNode.preorderEnumeration();
            while (nodeEnum.hasMoreElements()) {
                HistoryNode node = (HistoryNode)nodeEnum.nextElement();
                if (!(node instanceof Step)) continue;
                String title = node.getTitle();
                PlayerID playerId = ((Step)node).getPlayerID();
                if (title.equals("Initializing Delegates") || playerId == null) continue;
                curPlayer = playerId;
            }
        } while ((curNode = curNode.getNextSibling()) instanceof Step && ((Step)curNode).getPlayerID().equals(curPlayer));
        return curPlayer;
    }

    public void printRemainingTurn(HistoryNode printNode, boolean verbose, int diceSides, Collection<PlayerID> playersAllowed) {
        HistoryNode node;
        PrintWriter logWriter = this.m_printWriter;
        String moreIndent = "    ";
        DefaultMutableTreeNode curNode = printNode;
        TreePath parentPath = new TreePath(printNode.getPath()).getParentPath();
        PlayerID currentPlayer = null;
        if (parentPath != null) {
            Object[] pathToNode;
            for (Object pathNode : pathToNode = parentPath.getPath()) {
                node = (HistoryNode)pathNode;
                for (int i = 0; i < node.getLevel(); ++i) {
                    logWriter.print("    ");
                }
                logWriter.println(node.getTitle());
                if (node.getLevel() == 0) {
                    logWriter.println();
                }
                if (!(node instanceof Step)) continue;
                currentPlayer = ((Step)node).getPlayerID();
            }
        }
        HashSet<PlayerID> players = new HashSet<PlayerID>();
        if (playersAllowed != null) {
            players.addAll(playersAllowed);
        }
        if (currentPlayer != null) {
            players.add(currentPlayer);
        }
        ArrayList<String> moveList = new ArrayList<String>();
        boolean moving = false;
        do {
            String conquerStr = "";
            Enumeration<TreeNode> nodeEnum = curNode.preorderEnumeration();
            while (nodeEnum.hasMoreElements()) {
                node = (HistoryNode)nodeEnum.nextElement();
                String title = node.getTitle();
                String indent = "";
                for (int i = 0; i < node.getLevel(); ++i) {
                    indent = indent + "    ";
                }
                if (moving && !(node instanceof Renderable)) {
                    Iterator moveIter = moveList.iterator();
                    while (moveIter.hasNext()) {
                        logWriter.println((String)moveIter.next());
                        moveIter.remove();
                    }
                    moving = false;
                }
                if (node instanceof Renderable) {
                    Object details = ((Renderable)((Object)node)).getRenderingData();
                    if (details instanceof DiceRoll) {
                        if (!verbose) continue;
                        String diceMsg1 = title.substring(0, title.indexOf(58) + 1);
                        if (diceMsg1.equals("")) {
                            logWriter.println(indent + "    " + title);
                            continue;
                        }
                        logWriter.print(indent + "    " + diceMsg1);
                        DiceRoll diceRoll = (DiceRoll)details;
                        int hits = diceRoll.getHits();
                        int rolls = 0;
                        for (int i = 1; i <= diceSides; ++i) {
                            rolls += diceRoll.getRolls(i).size();
                        }
                        logWriter.println("  " + hits + "/" + rolls + " hits");
                        continue;
                    }
                    if (details instanceof MoveDescription) {
                        Pattern p = Pattern.compile("\\w+ undo move (\\d+).");
                        Matcher m = p.matcher(title);
                        if (m.matches()) {
                            moveList.remove(Integer.valueOf(m.group(1)) - 1);
                            continue;
                        }
                        moveList.add(indent + title);
                        moving = true;
                        continue;
                    }
                    if (details instanceof Collection) {
                        Collection objects = (Collection)details;
                        Iterator objIter = objects.iterator();
                        if (objIter.hasNext()) {
                            Object obj = objIter.next();
                            if (obj instanceof Unit) {
                                Collection allUnitsInDetails = (Collection)details;
                                Unit unit = (Unit)obj;
                                if (title.matches("\\w+ buy .*")) {
                                    logWriter.println(indent + title);
                                    continue;
                                }
                                if (title.matches("\\w+ attack with .*")) {
                                    logWriter.println(indent + title);
                                    continue;
                                }
                                if (title.matches("\\w+ defend with .*")) {
                                    logWriter.println(indent + title);
                                    continue;
                                }
                                if (title.matches("\\d+ \\w+ owned by the .*? lost .*")) {
                                    if (!verbose) continue;
                                    logWriter.println(indent + "    " + title);
                                    continue;
                                }
                                if (title.matches("\\d+ \\w+ owned by the .*? lost")) {
                                    if (!verbose) continue;
                                    logWriter.println(indent + "    " + title);
                                    continue;
                                }
                                if (title.startsWith("Battle casualty summary:")) {
                                    logWriter.println(indent + conquerStr + ". Battle score " + title.substring(title.indexOf("for attacker is")));
                                    conquerStr = "";
                                    IntegerMap<PlayerID> unitCount = new IntegerMap<PlayerID>();
                                    unitCount.add(unit.getOwner(), 1);
                                    while (objIter.hasNext()) {
                                        unit = (Unit)objIter.next();
                                        unitCount.add(unit.getOwner(), 1);
                                    }
                                    for (PlayerID player : unitCount.keySet()) {
                                        logWriter.println(indent + "Casualties for " + player.getName() + ": " + MyFormatter.unitsToTextNoOwner(allUnitsInDetails, player));
                                    }
                                    continue;
                                }
                                if (title.matches(".*? placed in .*")) {
                                    logWriter.println(indent + title);
                                    continue;
                                }
                                if (title.matches(".* owned by the \\w+ retreated to .*")) {
                                    logWriter.println(indent + title);
                                    continue;
                                }
                                if (title.matches("\\w+ win")) {
                                    conquerStr = title + conquerStr + " with " + MyFormatter.unitsToTextNoOwner(allUnitsInDetails) + " remaining";
                                    continue;
                                }
                                logWriter.println(indent + title);
                                continue;
                            }
                            logWriter.println(indent + title);
                            continue;
                        }
                        if (title.matches("\\w+ win")) {
                            conquerStr = title + conquerStr + " with no units remaining";
                            continue;
                        }
                        logWriter.println(indent + title);
                        continue;
                    }
                    if (details instanceof Territory) {
                        logWriter.println(indent + title);
                        continue;
                    }
                    if (details == null) {
                        if (title.equals("Adding original owners") || title.equals(MoveDelegate.CLEANING_UP_AFTER_MOVEMENT_PHASES) || title.equals("Game Loaded") || title.indexOf("now being played by") != -1 || title.indexOf("Turn Summary") != -1 || title.indexOf("Move Summary") != -1 || title.indexOf("Setting uses for triggers used") != -1 || title.equals("Giving bonus movement to units") || title.equals("Recording Battle Statistics") || title.equals("Preparing Airbases for Possible Scrambling")) continue;
                        if (title.matches("\\w+ collect \\d+ PUs?.*")) {
                            logWriter.println(indent + title);
                            continue;
                        }
                        if (title.matches("\\w+ takes? .*? from \\w+")) {
                            if (moving) {
                                String str = (String)moveList.remove(moveList.size() - 1);
                                moveList.add(str + "\n  " + indent + title.replaceAll(" takes ", " take "));
                                continue;
                            }
                            conquerStr = conquerStr + title.replaceAll("^\\w+ takes ", ", taking ");
                            continue;
                        }
                        if (title.matches("\\w+ spend \\d+ on tech rolls")) {
                            logWriter.println(indent + title);
                            continue;
                        }
                        if (title.startsWith("Rolls to resolve tech hits:")) continue;
                        if (title.matches("\\w+ discover .*")) {
                            logWriter.println(indent + title);
                            continue;
                        }
                        if (title.matches("AA raid costs .*")) {
                            logWriter.println(indent + title);
                            continue;
                        }
                        logWriter.println(indent + title);
                        continue;
                    }
                    logWriter.println(indent + title);
                    continue;
                }
                if (node instanceof Step) {
                    PlayerID playerId = ((Step)node).getPlayerID();
                    if (title.equals("Initializing Delegates")) continue;
                    logWriter.println();
                    logWriter.print(indent + title);
                    if (playerId != null) {
                        currentPlayer = playerId;
                        players.add(currentPlayer);
                        logWriter.print(" - " + playerId.getName());
                    }
                    logWriter.println();
                    continue;
                }
                if (node instanceof Round) {
                    logWriter.println();
                    logWriter.println(indent + title);
                    continue;
                }
                if (title.equals("Game History")) {
                    logWriter.println(indent + title);
                    continue;
                }
                logWriter.println(indent + title);
            }
        } while ((curNode = curNode.getNextSibling()) != null && curNode instanceof Step && players.contains(((Step)curNode).getPlayerID()));
        if (moving && !moveList.isEmpty()) {
            Iterator moveIter = moveList.iterator();
            while (moveIter.hasNext()) {
                logWriter.println((String)moveIter.next());
                moveIter.remove();
            }
            moving = false;
        }
        logWriter.println();
        logWriter.println();
        this.m_textArea.setText(this.m_stringWriter.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void printTerritorySummary(HistoryNode printNode, GameData data) {
        Collection<Territory> territories;
        PlayerID player = HistoryLog.getPlayerID(printNode);
        data.acquireReadLock();
        try {
            territories = data.getMap().getTerritories();
        }
        finally {
            data.releaseReadLock();
        }
        HashSet<PlayerID> players = new HashSet<PlayerID>();
        players.add(player);
        this.printTerritorySummary(data, players, territories);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void printTerritorySummary(GameData data) {
        Collection<Territory> territories;
        PlayerID player;
        data.acquireReadLock();
        try {
            player = data.getSequence().getStep().getPlayerID();
            territories = data.getMap().getTerritories();
        }
        finally {
            data.releaseReadLock();
        }
        HashSet<PlayerID> players = new HashSet<PlayerID>();
        players.add(player);
        this.printTerritorySummary(data, players, territories);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void printTerritorySummary(GameData data, Collection<PlayerID> allowedPlayers) {
        Collection<Territory> territories;
        if (allowedPlayers == null || allowedPlayers.isEmpty()) {
            this.printTerritorySummary(data);
            return;
        }
        data.acquireReadLock();
        try {
            territories = data.getMap().getTerritories();
        }
        finally {
            data.releaseReadLock();
        }
        this.printTerritorySummary(data, allowedPlayers, territories);
    }

    private void printTerritorySummary(GameData data, Collection<PlayerID> players, Collection<Territory> territories) {
        if (players == null || players.isEmpty() || territories == null || territories.isEmpty()) {
            return;
        }
        PrintWriter logWriter = this.m_printWriter;
        logWriter.println("Territory Summary for " + MyFormatter.asList(players) + " : \n");
        for (Territory t : territories) {
            List<Unit> ownedUnits = t.getUnits().getMatches(Matches.unitIsOwnedByOfAnyOfThesePlayers(players));
            TerritoryAttachment ta = TerritoryAttachment.get(t);
            boolean hasFlag = false;
            if (ta == null) {
                hasFlag = false;
            } else {
                boolean bl = hasFlag = t.getOwner() != null && players.contains(t.getOwner()) && (ta.getOriginalOwner() == null || !players.contains(ta.getOriginalOwner()));
            }
            if (!hasFlag && ownedUnits.isEmpty()) continue;
            logWriter.print("    " + t.getName() + " : ");
            if (hasFlag && ownedUnits.isEmpty()) {
                logWriter.println("1 flag");
            } else if (hasFlag) {
                logWriter.print("1 flag, ");
            }
            if (ownedUnits.isEmpty()) continue;
            logWriter.println(MyFormatter.unitsToTextNoOwner(ownedUnits));
        }
        logWriter.println();
        logWriter.println();
        this.m_textArea.setText(this.m_stringWriter.toString());
    }

    public void printDiceStatistics(GameData data, IRandomStats randomStats) {
        PrintWriter logWriter = this.m_printWriter;
        RandomStatsDetails stats = randomStats.getRandomStats(data.getDiceSides());
        String diceStats = stats.getAllStatsString("    ");
        if (diceStats.length() > 0) {
            logWriter.println(diceStats);
            logWriter.println();
            logWriter.println();
        }
        this.m_textArea.setText(this.m_stringWriter.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void printProductionSummary(GameData data) {
        Collection<PlayerID> players;
        PrintWriter logWriter = this.m_printWriter;
        logWriter.println("Production/PUs Summary :\n");
        data.acquireReadLock();
        try {
            players = data.getPlayerList().getPlayers();
        }
        finally {
            data.releaseReadLock();
        }
        for (PlayerID player : players) {
            int PUs = player.getResources().getQuantity("PUs");
            int production = this.getProduction(player, data);
            logWriter.println("    " + player.getName() + " : " + production + " / " + PUs);
        }
        logWriter.println();
        logWriter.println();
        this.m_textArea.setText(this.m_stringWriter.toString());
    }

    private int getProduction(PlayerID player, GameData data) {
        int rVal = 0;
        Iterator<Territory> iter = data.getMap().getTerritories().iterator();
        while (iter.hasNext()) {
            boolean isConvoyOrLand = false;
            Territory place = iter.next();
            TerritoryAttachment ta = TerritoryAttachment.get(place);
            if (!place.isWater()) {
                isConvoyOrLand = true;
            } else if (place.isWater() && ta != null && OriginalOwnerTracker.getOriginalOwner(place) != PlayerID.NULL_PLAYERID && OriginalOwnerTracker.getOriginalOwner(place) == player && place.getOwner().equals(player)) {
                isConvoyOrLand = true;
            }
            if (!place.getOwner().equals(player) || !isConvoyOrLand || ta == null) continue;
            rVal += ta.getProduction();
        }
        return rVal;
    }
}

