/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.triplea.ui.history;

import games.strategy.engine.data.GameData;
import games.strategy.engine.history.HistoryNode;
import games.strategy.engine.history.Step;
import games.strategy.triplea.ui.UIContext;
import games.strategy.triplea.ui.history.HistoryDetailsPanel;
import games.strategy.triplea.ui.history.HistoryTreeCellRenderer;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Stack;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HistoryPanel
extends JPanel {
    private static final long serialVersionUID = -8353246449552215276L;
    private final GameData m_data;
    private final JTree m_tree;
    private final HistoryDetailsPanel m_details;
    private HistoryNode m_currentPopupNode;
    private final JPopupMenu m_popup;
    final Collection<TreePath> m_stayExpandedPaths = new ArrayList<TreePath>();
    private boolean m_mouseOverPanel = false;
    boolean m_mouseWasOverPanel = false;
    TreePath m_lastParent = null;

    public HistoryPanel(GameData data, HistoryDetailsPanel details, JPopupMenu popup, UIContext uiContext) {
        MouseListener mouseFocusListener = new MouseListener(){

            public void mouseReleased(MouseEvent e) {
            }

            public void mousePressed(MouseEvent e) {
            }

            public void mouseClicked(MouseEvent e) {
            }

            public void mouseExited(MouseEvent e) {
                HistoryPanel.this.m_mouseOverPanel = false;
            }

            public void mouseEntered(MouseEvent e) {
                HistoryPanel.this.m_mouseOverPanel = true;
            }
        };
        this.addMouseListener(mouseFocusListener);
        this.m_data = data;
        this.m_details = details;
        this.setLayout(new BorderLayout());
        if (!this.m_data.areChangesOnlyInSwingEventThread()) {
            throw new IllegalStateException();
        }
        this.m_tree = new JTree(this.m_data.getHistory());
        this.m_data.getHistory().setTreePanel(this);
        this.m_tree.expandRow(0);
        this.m_popup = popup;
        this.m_tree.add(this.m_popup);
        this.m_popup.addPopupMenuListener(new PopupMenuListener(){

            public void popupMenuCanceled(PopupMenuEvent pme) {
                HistoryPanel.this.m_currentPopupNode = null;
            }

            public void popupMenuWillBecomeInvisible(PopupMenuEvent pme) {
            }

            public void popupMenuWillBecomeVisible(PopupMenuEvent pme) {
            }
        });
        HistoryTreeCellRenderer renderer = new HistoryTreeCellRenderer(uiContext);
        renderer.setLeafIcon(null);
        renderer.setClosedIcon(null);
        renderer.setOpenIcon(null);
        renderer.setBackgroundNonSelectionColor(this.getBackground());
        this.m_tree.setCellRenderer(renderer);
        this.m_tree.setBackground(this.getBackground());
        JScrollPane scroll = new JScrollPane(this.m_tree);
        scroll.addMouseListener(mouseFocusListener);
        for (Component comp : scroll.getComponents()) {
            comp.addMouseListener(mouseFocusListener);
        }
        scroll.setBorder(null);
        scroll.setViewportBorder(null);
        this.add((Component)scroll, "Center");
        this.m_tree.setEditable(false);
        HistoryNode node = this.m_data.getHistory().getLastNode();
        this.m_data.getHistory().gotoNode(node);
        this.m_tree.expandPath(new TreePath(node.getPath()));
        this.m_tree.setSelectionPath(new TreePath(node.getPath()));
        this.m_currentPopupNode = null;
        JButton previousButton = new JButton("<-Back");
        previousButton.addMouseListener(mouseFocusListener);
        previousButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                HistoryPanel.this.previous();
            }
        });
        JButton nextButton = new JButton("Next->");
        nextButton.addMouseListener(mouseFocusListener);
        nextButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                HistoryPanel.this.next();
            }
        });
        JPanel buttons = new JPanel();
        buttons.setLayout(new GridBagLayout());
        buttons.add((Component)previousButton, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
        buttons.add((Component)nextButton, new GridBagConstraints(1, 0, 1, 1, 1.0, 1.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)buttons, "South");
        this.m_tree.addMouseListener(new MouseListener(){

            public void mouseClicked(MouseEvent me) {
                if (SwingUtilities.isRightMouseButton(me)) {
                    HistoryPanel.this.m_currentPopupNode = (HistoryNode)HistoryPanel.this.m_tree.getClosestPathForLocation(me.getX(), me.getY()).getLastPathComponent();
                    HistoryPanel.this.m_popup.show(me.getComponent(), me.getX(), me.getY());
                } else if (HistoryPanel.this.m_mouseWasOverPanel) {
                    TreePath clickedPath = new TreePath(((HistoryNode)HistoryPanel.this.m_tree.getClosestPathForLocation(me.getX(), me.getY()).getLastPathComponent()).getPath());
                    this.adaptStayExpandedPathsOnClickedPath(clickedPath);
                }
            }

            private void adaptStayExpandedPathsOnClickedPath(TreePath clickedPath) {
                if (HistoryPanel.this.m_stayExpandedPaths.contains(clickedPath)) {
                    HistoryPanel.this.m_stayExpandedPaths.remove(clickedPath);
                    HistoryPanel.this.m_tree.collapsePath(clickedPath);
                } else {
                    HistoryPanel.this.m_stayExpandedPaths.add(clickedPath);
                    HistoryPanel.this.m_tree.expandPath(clickedPath);
                }
            }

            public void mouseEntered(MouseEvent me) {
                HistoryPanel.this.m_mouseOverPanel = true;
            }

            public void mouseExited(MouseEvent me) {
                HistoryPanel.this.m_mouseOverPanel = false;
            }

            public void mousePressed(MouseEvent me) {
            }

            public void mouseReleased(MouseEvent me) {
            }
        });
        this.m_tree.addTreeSelectionListener(new TreeSelectionListener(){

            public void valueChanged(TreeSelectionEvent e) {
                HistoryPanel.this.treeSelectionChanged(e);
            }
        });
    }

    private void previous() {
        TreeNode current;
        if (this.m_tree.getSelectionCount() == 0) {
            this.m_tree.setSelectionInterval(0, 0);
            return;
        }
        TreePath path = this.m_tree.getSelectionPath();
        TreeNode selected = (TreeNode)path.getLastPathComponent();
        Enumeration<TreeNode> nodeEnum = ((DefaultMutableTreeNode)this.m_tree.getModel().getRoot()).depthFirstEnumeration();
        TreeNode previous = null;
        while (nodeEnum.hasMoreElements() && (current = nodeEnum.nextElement()) != selected) {
            if (!(current.getParent() instanceof Step)) continue;
            previous = current;
        }
        if (previous != null) {
            this.navigateTo(previous);
        }
    }

    private void navigateTo(TreeNode target) {
        Object[] nodes = ((DefaultMutableTreeNode)target).getPath();
        TreePath newPath = new TreePath(nodes);
        this.m_tree.expandPath(newPath);
        this.m_tree.setSelectionPath(newPath);
        int row = this.m_tree.getRowForPath(newPath);
        if (row == -1) {
            return;
        }
        Rectangle bounds = this.m_tree.getRowBounds(row);
        if (bounds == null) {
            return;
        }
        bounds.x = 0;
        bounds.width = 10;
        this.m_tree.scrollRectToVisible(bounds);
    }

    private void next() {
        if (this.m_tree.getSelectionCount() == 0) {
            this.m_tree.setSelectionInterval(0, 0);
            return;
        }
        TreePath path = this.m_tree.getSelectionPath();
        TreeNode selected = (TreeNode)path.getLastPathComponent();
        Enumeration<TreeNode> nodeEnum = ((DefaultMutableTreeNode)this.m_tree.getModel().getRoot()).preorderEnumeration();
        TreeNode next = null;
        boolean foundSelected = false;
        while (nodeEnum.hasMoreElements()) {
            TreeNode current = nodeEnum.nextElement();
            if (current == selected) {
                foundSelected = true;
                continue;
            }
            if (!foundSelected || !(current.getParent() instanceof Step)) continue;
            next = current;
            break;
        }
        if (next != null) {
            this.navigateTo(next);
        }
    }

    private void treeSelectionChanged(TreeSelectionEvent e) {
        if (!SwingUtilities.isEventDispatchThread()) {
            throw new IllegalStateException("Wrong thread");
        }
        HistoryNode node = (HistoryNode)e.getPath().getLastPathComponent();
        this.gotoNode(node);
    }

    private void gotoNode(HistoryNode node) {
        if (!SwingUtilities.isEventDispatchThread()) {
            throw new IllegalStateException("Not EDT");
        }
        this.m_details.render(node);
        this.m_data.getHistory().gotoNode(node);
    }

    public HistoryNode getCurrentNode() {
        TreePath path = this.m_tree.getSelectionPath();
        HistoryNode curNode = (HistoryNode)path.getLastPathComponent();
        return curNode;
    }

    public HistoryNode getCurrentPopupNode() {
        return this.m_currentPopupNode;
    }

    public void clearCurrentPopupNode() {
        this.m_currentPopupNode = null;
    }

    private boolean addToStayExpanded(Enumeration<TreePath> paths) {
        ArrayList<TreePath> expandPaths = new ArrayList<TreePath>();
        while (paths.hasMoreElements()) {
            expandPaths.add(paths.nextElement());
        }
        return this.m_stayExpandedPaths.addAll(expandPaths);
    }

    private void collapseUpFromLastParent(TreePath newPath) {
        for (TreePath currentParent = this.m_lastParent; currentParent != null && !currentParent.isDescendant(newPath) && !this.stayExpandedContainsDescendantOf(currentParent); currentParent = currentParent.getParentPath()) {
            this.m_tree.collapsePath(currentParent);
        }
    }

    private boolean stayExpandedContainsDescendantOf(TreePath parentPath) {
        for (TreePath currentPath : this.m_stayExpandedPaths) {
            if (!parentPath.isDescendant(currentPath)) continue;
            return true;
        }
        return false;
    }

    private void collapseExpanded(TreePath newPath) {
        if (!this.m_stayExpandedPaths.isEmpty()) {
            TreePath root = newPath;
            while (root.getPathCount() > 1) {
                root = root.getParentPath();
            }
            Enumeration<TreePath> expandedDescendants = this.m_tree.getExpandedDescendants(root);
            TreePath selectedPath = this.m_tree.getSelectionPath();
            Stack<TreePath> collapsePaths = new Stack<TreePath>();
            while (expandedDescendants.hasMoreElements()) {
                TreePath currentDescendant = expandedDescendants.nextElement();
                if (currentDescendant.isDescendant(newPath) || selectedPath != null && currentDescendant.isDescendant(selectedPath)) continue;
                collapsePaths.add(currentDescendant);
            }
            if (!collapsePaths.isEmpty()) {
                for (TreePath currentPath : collapsePaths) {
                    this.m_tree.collapsePath(currentPath);
                }
                this.m_stayExpandedPaths.removeAll(collapsePaths);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void goToEnd() {
        HistoryNode last;
        try {
            this.m_data.acquireWriteLock();
            last = this.m_data.getHistory().getLastNode();
        }
        finally {
            this.m_data.releaseWriteLock();
        }
        TreePath path = new TreePath(last.getPath());
        TreePath parent = path.getParentPath();
        if (!this.m_mouseOverPanel) {
            this.gotoNode(last);
            if (this.m_lastParent == null) {
                this.m_lastParent = this.m_tree.getSelectionPath();
            }
            this.m_tree.setSelectionPath(path);
            this.collapseExpanded(path);
            this.collapseUpFromLastParent(parent);
            Rectangle rect = this.m_tree.getPathBounds(path);
            rect.setRect(0.0, rect.getY(), rect.getWidth(), rect.getHeight());
            this.m_tree.scrollRectToVisible(rect);
        } else {
            if (!this.m_mouseWasOverPanel) {
                TreePath root = parent;
                while (root.getPathCount() > 1) {
                    root = root.getParentPath();
                }
                Enumeration<TreePath> expandedDescendants = this.m_tree.getExpandedDescendants(root);
                this.addToStayExpanded(expandedDescendants);
            } else {
                this.collapseUpFromLastParent(parent);
            }
            this.m_tree.expandPath(parent);
        }
        this.m_mouseWasOverPanel = this.m_mouseOverPanel;
        this.m_lastParent = parent;
    }
}

