/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.triplea.ui.screen;

import games.strategy.engine.data.DefaultNamed;
import games.strategy.engine.data.GameData;
import games.strategy.engine.data.PlayerID;
import games.strategy.engine.data.Territory;
import games.strategy.engine.data.Unit;
import games.strategy.triplea.TripleAUnit;
import games.strategy.triplea.ui.MapData;
import games.strategy.triplea.ui.screen.IDrawable;
import games.strategy.triplea.ui.screen.TerritoryDrawable;
import java.awt.Color;
import java.awt.GradientPaint;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.util.HashSet;

class BattleDrawable
extends TerritoryDrawable
implements IDrawable {
    private final String m_territoryName;

    public BattleDrawable(String territoryName) {
        this.m_territoryName = territoryName;
    }

    public void draw(Rectangle bounds, GameData data, Graphics2D graphics, MapData mapData, AffineTransform unscaled, AffineTransform scaled) {
        HashSet<PlayerID> players = new HashSet<PlayerID>();
        for (Unit u : data.getMap().getTerritory(this.m_territoryName).getUnits()) {
            if (TripleAUnit.get(u).getSubmerged()) continue;
            players.add(u.getOwner());
        }
        Territory territory = data.getMap().getTerritory(this.m_territoryName);
        DefaultNamed attacker = null;
        boolean draw = false;
        block1: for (PlayerID p : players) {
            if (!territory.isWater()) {
                if (data.getRelationshipTracker().isAtWar(p, territory.getOwner())) {
                    attacker = p;
                    draw = true;
                    break;
                }
                for (PlayerID p2 : players) {
                    if (!data.getRelationshipTracker().isAtWar(p, p2)) continue;
                    draw = true;
                    continue block1;
                }
                continue;
            }
            for (PlayerID p2 : players) {
                if (!data.getRelationshipTracker().isAtWar(p, p2)) continue;
                draw = true;
                continue block1;
            }
        }
        if (draw) {
            Color stripeColor = attacker == null || territory.isWater() ? Color.RED.brighter() : mapData.getPlayerColor(attacker.getName());
            GradientPaint paint = new GradientPaint(0.0f - (float)bounds.getX(), 0.0f - (float)bounds.getY(), new Color(stripeColor.getRed(), stripeColor.getGreen(), stripeColor.getBlue(), 120), 30.0f - (float)bounds.getX(), 50.0f - (float)bounds.getY(), new Color(0, 0, 0, 0), true);
            super.draw(bounds, graphics, mapData, unscaled, scaled, territory, paint);
        }
    }

    public int getLevel() {
        return 14;
    }
}

