/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.triplea.ui.screen;

import games.strategy.engine.data.GameData;
import games.strategy.engine.data.Territory;
import games.strategy.triplea.attatchments.TerritoryAttachment;
import games.strategy.triplea.formatter.MyFormatter;
import games.strategy.triplea.image.MapImage;
import games.strategy.triplea.ui.MapData;
import games.strategy.triplea.ui.UIContext;
import games.strategy.triplea.ui.screen.IDrawable;
import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;

class TerritoryNameDrawable
implements IDrawable {
    private final String m_territoryName;
    private final UIContext m_uiContext;

    public TerritoryNameDrawable(String territoryName, UIContext context) {
        this.m_territoryName = territoryName;
        this.m_uiContext = context;
    }

    public void draw(Rectangle bounds, GameData data, Graphics2D graphics, MapData mapData, AffineTransform unscaled, AffineTransform scaled) {
        int y;
        int x;
        Territory territory = data.getMap().getTerritory(this.m_territoryName);
        TerritoryAttachment ta = TerritoryAttachment.get(territory);
        boolean drawFromTopLeft = mapData.drawNamesFromTopLeft();
        boolean showSeaNames = mapData.drawSeaZoneNames();
        boolean showComments = mapData.drawComments();
        boolean drawComments = false;
        String commentText = null;
        if (territory.isWater()) {
            if (ta != null && showComments) {
                if (ta.getConvoyRoute() && ta.getProduction() > 0 && ta.getOriginalOwner() != null) {
                    drawComments = true;
                    commentText = ta.getConvoyAttached().isEmpty() ? MyFormatter.asList(TerritoryAttachment.getWhatTerritoriesThisIsUsedInConvoysFor(territory, data)) + " " + ta.getOriginalOwner().getName() + " Convoy Route" : MyFormatter.asList(ta.getConvoyAttached()) + " " + ta.getOriginalOwner().getName() + " Convoy Dependent Route";
                } else if (ta.getConvoyRoute()) {
                    drawComments = true;
                    commentText = ta.getConvoyAttached().isEmpty() ? MyFormatter.asList(TerritoryAttachment.getWhatTerritoriesThisIsUsedInConvoysFor(territory, data)) + " Convoy Route" : MyFormatter.asList(ta.getConvoyAttached()) + " Convoy Dependent Route";
                } else if (ta.getProduction() > 0 && ta.getOriginalOwner() != null) {
                    drawComments = true;
                    commentText = ta.getOccupiedTerrOf() == null ? ta.getOriginalOwner().getName() + " Convoy Center" : ta.getOccupiedTerrOf().getName() + " Convoy Center";
                }
            }
            if (!drawComments && !showSeaNames) {
                return;
            }
        }
        Rectangle territoryBounds = mapData.getBoundingRect(territory);
        graphics.setFont(MapImage.MAP_FONT);
        graphics.setColor(Color.black);
        FontMetrics fm = graphics.getFontMetrics();
        Point namePlace = mapData.getNamePlacementPoint(territory);
        if (namePlace == null) {
            x = territoryBounds.x;
            y = territoryBounds.y;
            x += (int)territoryBounds.getWidth() >> 1;
            y += (int)territoryBounds.getHeight() >> 1;
            x -= fm.stringWidth(territory.getName()) >> 1;
            y += fm.getAscent() >> 1;
        } else {
            x = namePlace.x;
            y = namePlace.y;
        }
        if (showComments && drawComments && commentText != null) {
            Point place = mapData.getCommentMarkerLocation(territory);
            if (place != null) {
                this.draw(bounds, graphics, place.x, place.y, null, commentText, drawFromTopLeft);
            } else {
                this.draw(bounds, graphics, x, y - fm.getHeight(), null, commentText, drawFromTopLeft);
            }
        }
        if (mapData.drawTerritoryNames() && mapData.shouldDrawTerritoryName(this.m_territoryName) && (!territory.isWater() || showSeaNames)) {
            Image nameImage = mapData.getTerritoryNameImages().get(territory.getName());
            this.draw(bounds, graphics, x, y, nameImage, territory.getName(), drawFromTopLeft);
        }
        if (ta != null && ta.getProduction() > 0 && mapData.drawResources()) {
            Image img = this.m_uiContext.getPUImageFactory().getPUImage(ta.getProduction());
            String prod = Integer.valueOf(ta.getProduction()).toString();
            Point place = mapData.getPUPlacementPoint(territory);
            if (place != null) {
                this.draw(bounds, graphics, place.x, place.y, img, prod, drawFromTopLeft);
            } else {
                this.draw(bounds, graphics, x + (fm.stringWidth(this.m_territoryName) >> 1) - (fm.stringWidth(prod) >> 1), y + fm.getLeading() + fm.getAscent(), img, prod, drawFromTopLeft);
            }
        }
    }

    private void draw(Rectangle bounds, Graphics2D graphics, int x, int y, Image img, String prod, boolean drawFromTopLeft) {
        if (img == null) {
            if (drawFromTopLeft) {
                FontMetrics fm = graphics.getFontMetrics();
                y += fm.getHeight();
            }
            graphics.drawString(prod, x - bounds.x, y - bounds.y);
        } else {
            if (!drawFromTopLeft) {
                y -= img.getHeight(null);
            }
            graphics.drawImage(img, x - bounds.x, y - bounds.y, null);
        }
    }

    public int getLevel() {
        return 13;
    }
}

