/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.triplea.util;

import games.strategy.engine.data.GameData;
import games.strategy.engine.data.GameSequence;
import games.strategy.engine.data.GameStep;
import games.strategy.engine.data.PlayerID;
import games.strategy.engine.delegate.IDelegate;
import java.util.Comparator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PlayerOrderComparator
implements Comparator<PlayerID> {
    private final GameData m_data;

    public PlayerOrderComparator(GameData data) {
        this.m_data = data;
    }

    @Override
    public int compare(PlayerID p1, PlayerID p2) {
        if (p1.equals(p2)) {
            return 0;
        }
        this.m_data.acquireReadLock();
        GameSequence sequence = this.m_data.getSequence();
        this.m_data.releaseReadLock();
        for (GameStep s : sequence) {
            String delegateClassName;
            if (s.getPlayerID() == null) continue;
            this.m_data.acquireReadLock();
            IDelegate delegate = s.getDelegate();
            this.m_data.releaseReadLock();
            if (delegate == null || delegate.getClass() == null ? s.getName() != null && (s.getName().endsWith("Bid") || s.getName().endsWith("BidPlace")) : (delegateClassName = delegate.getClass().getName()).equals("games.strategy.triplea.delegate.InitializationDelegate") || delegateClassName.equals("games.strategy.triplea.delegate.BidPurchaseDelegate") || delegateClassName.equals("games.strategy.triplea.delegate.BidPlaceDelegate") || delegateClassName.equals("games.strategy.triplea.delegate.EndRoundDelegate")) continue;
            if (s.getPlayerID().equals(p1)) {
                return -1;
            }
            if (!s.getPlayerID().equals(p2)) continue;
            return 1;
        }
        return 0;
    }
}

