/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.triplea.util;

import games.strategy.engine.data.PlayerID;
import games.strategy.engine.data.Unit;
import games.strategy.engine.data.UnitType;

public class UnitOwner {
    private final UnitType m_type;
    private final PlayerID m_owner;

    public UnitOwner(Unit unit) {
        this.m_type = unit.getType();
        this.m_owner = unit.getOwner();
    }

    public UnitOwner(UnitType type, PlayerID owner) {
        this.m_type = type;
        this.m_owner = owner;
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (!(o instanceof UnitOwner)) {
            return false;
        }
        UnitOwner other = (UnitOwner)o;
        return other.m_type.equals(this.m_type) && other.m_owner.equals(this.m_owner);
    }

    public int hashCode() {
        return this.m_type.hashCode() ^ this.m_owner.hashCode();
    }

    public String toString() {
        return "Unit owner:" + this.m_owner.getName() + " type:" + this.m_type.getName();
    }

    public UnitType getType() {
        return this.m_type;
    }

    public PlayerID getOwner() {
        return this.m_owner;
    }
}

