/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.triplea.util;

import games.strategy.engine.data.Territory;
import games.strategy.engine.data.Unit;
import games.strategy.triplea.TripleAUnit;
import games.strategy.triplea.attatchments.UnitAttachment;
import games.strategy.triplea.delegate.Matches;
import games.strategy.triplea.util.UnitCategory;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UnitSeperator {
    private UnitSeperator() {
    }

    public static Set<UnitCategory> categorize(Collection<Unit> units) {
        return UnitSeperator.categorize(units, null, false, false);
    }

    public static Set<UnitCategory> categorize(Collection<Unit> units, Map<Unit, Collection<Unit>> dependent, boolean categorizeMovement, boolean categorizeTransportCost, boolean sort) {
        return UnitSeperator.categorize(units, dependent, categorizeMovement, categorizeTransportCost, false, false, sort);
    }

    public static Set<UnitCategory> categorize(boolean sort, Collection<Unit> units, Map<Unit, Collection<Unit>> dependent, boolean categorizeMovement, boolean categorizeTransportCost, boolean categorizeTerritories) {
        return UnitSeperator.categorize(units, dependent, categorizeMovement, categorizeTransportCost, false, categorizeTerritories, sort);
    }

    public static Set<UnitCategory> categorize(Collection<Unit> units, Map<Unit, Collection<Unit>> dependent, boolean categorizeMovement, boolean categorizeTransportCost, boolean categorizeTrnMovement, boolean categorizeTerritories, boolean sort) {
        HashMap<UnitCategory, UnitCategory> categories = sort ? new HashMap<UnitCategory, UnitCategory>() : new LinkedHashMap();
        for (Unit current : units) {
            UnitCategory entry;
            boolean damaged;
            int unitMovement = -1;
            if (categorizeMovement || categorizeTrnMovement && Matches.UnitIsTransport.match(current)) {
                unitMovement = TripleAUnit.get(current).getMovementLeft();
            }
            int unitTransportCost = -1;
            if (categorizeTransportCost) {
                unitTransportCost = UnitAttachment.get(current.getUnitType()).getTransportCost();
            }
            Collection<Unit> currentDependents = null;
            if (dependent != null) {
                currentDependents = dependent.get(current);
            }
            boolean bl = damaged = current.getHits() == 1;
            if (damaged) {
                // empty if block
            }
            boolean disabled = Matches.UnitIsDisabled().match(current);
            Territory originatingTerr = null;
            if (categorizeTerritories) {
                originatingTerr = TripleAUnit.get(current).getOriginatedFrom();
            }
            if (categories.containsKey(entry = new UnitCategory(current, currentDependents, unitMovement, damaged, disabled, unitTransportCost, originatingTerr))) {
                UnitCategory stored = (UnitCategory)categories.get(entry);
                stored.addUnit(current);
                continue;
            }
            categories.put(entry, entry);
        }
        if (sort) {
            return new TreeSet<UnitCategory>(categories.keySet());
        }
        return new LinkedHashSet<UnitCategory>(categories.keySet());
    }

    public static Set<UnitCategory> categorize(Collection<Unit> units, Map<Unit, Collection<Unit>> dependent, boolean categorizeMovement, boolean categorizeTransportCost) {
        return UnitSeperator.categorize(units, dependent, categorizeMovement, categorizeTransportCost, true);
    }

    public static Set<UnitCategory> categorize(Map<Unit, Collection<Unit>> dependent, Collection<Unit> units, boolean categorizeMovement, boolean categorizeTransportCost, boolean categorizeTerritories) {
        return UnitSeperator.categorize(true, units, dependent, categorizeMovement, categorizeTransportCost, categorizeTerritories);
    }
}

