/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.util;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.HeadlessException;
import java.awt.Toolkit;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicInteger;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;

public class EventThreadJOptionPane {
    public static void showMessageDialog(Component parentComponent, Object message, String title, int messageType) {
        EventThreadJOptionPane.showMessageDialog(parentComponent, message, title, messageType, false);
    }

    private static JScrollPane createJLabelInScrollPane(String message) {
        int newWidth;
        JLabel label = new JLabel(message);
        JScrollPane scroll = new JScrollPane(label);
        scroll.setBorder(BorderFactory.createEmptyBorder());
        Dimension screenResolution = Toolkit.getDefaultToolkit().getScreenSize();
        int availWidth = screenResolution.width - 40;
        int availHeight = screenResolution.height - 140;
        int n = scroll.getPreferredSize().width > availWidth ? availWidth : (newWidth = scroll.getPreferredSize().width + (scroll.getPreferredSize().height > availHeight ? 20 : 0));
        int newHeight = scroll.getPreferredSize().height > availHeight ? availHeight : scroll.getPreferredSize().height + (scroll.getPreferredSize().width > availWidth ? 20 : 0);
        scroll.setPreferredSize(new Dimension(newWidth, newHeight));
        return scroll;
    }

    public static void showMessageDialog(final Component parentComponent, final Object message, final String title, final int messageType, final boolean useJLabel) {
        if (SwingUtilities.isEventDispatchThread()) {
            JOptionPane.showMessageDialog(parentComponent, useJLabel ? EventThreadJOptionPane.createJLabelInScrollPane((String)message) : message, title, messageType);
            return;
        }
        final CountDownLatch latch = new CountDownLatch(1);
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                JOptionPane.showMessageDialog(parentComponent, useJLabel ? EventThreadJOptionPane.createJLabelInScrollPane((String)message) : message, title, messageType);
                latch.countDown();
            }
        });
        boolean done = false;
        while (!done) {
            try {
                latch.await();
                done = true;
            }
            catch (InterruptedException e) {}
        }
    }

    public static void showMessageDialog(final Frame parentComponent, final String message) {
        if (SwingUtilities.isEventDispatchThread()) {
            JOptionPane.showMessageDialog(parentComponent, message);
            return;
        }
        final CountDownLatch latch = new CountDownLatch(1);
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                JOptionPane.showMessageDialog(parentComponent, message);
                latch.countDown();
            }
        });
        boolean done = false;
        while (!done) {
            try {
                latch.await();
                done = true;
            }
            catch (InterruptedException e) {}
        }
    }

    public static void showMessageDialog(final Component parentComponent, final Object message) throws HeadlessException {
        if (SwingUtilities.isEventDispatchThread()) {
            JOptionPane.showMessageDialog(parentComponent, message);
            return;
        }
        final CountDownLatch latch = new CountDownLatch(1);
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                JOptionPane.showMessageDialog(parentComponent, message);
                latch.countDown();
            }
        });
        boolean done = false;
        while (!done) {
            try {
                latch.await();
                done = true;
            }
            catch (InterruptedException e) {}
        }
    }

    public static void showMessageDialog(Component parentComponent, Object message, String title, int messageType, Icon icon) {
        EventThreadJOptionPane.showOptionDialog(parentComponent, message, title, -1, messageType, icon, null, null);
    }

    public static int showOptionDialog(final Component parentComponent, final Object message, final String title, final int optionType, final int messageType, final Icon icon, final Object[] options, final Object initialValue) {
        if (SwingUtilities.isEventDispatchThread()) {
            return JOptionPane.showOptionDialog(parentComponent, message, title, optionType, messageType, icon, options, initialValue);
        }
        final CountDownLatch latch = new CountDownLatch(1);
        final AtomicInteger rVal = new AtomicInteger();
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                rVal.set(JOptionPane.showOptionDialog(parentComponent, message, title, optionType, messageType, icon, options, initialValue));
                latch.countDown();
            }
        });
        boolean done = false;
        while (!done) {
            try {
                latch.await();
                done = true;
            }
            catch (InterruptedException e) {}
        }
        return rVal.get();
    }

    public static int showConfirmDialog(final Component parentComponent, final Object message, final String title, final int optionType) throws HeadlessException {
        if (SwingUtilities.isEventDispatchThread()) {
            return JOptionPane.showConfirmDialog(parentComponent, message, title, optionType);
        }
        final CountDownLatch latch = new CountDownLatch(1);
        final AtomicInteger rVal = new AtomicInteger();
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                rVal.set(JOptionPane.showConfirmDialog(parentComponent, message, title, optionType));
                latch.countDown();
            }
        });
        boolean done = false;
        while (!done) {
            try {
                latch.await();
                done = true;
            }
            catch (InterruptedException e) {}
        }
        return rVal.get();
    }
}

