/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.util;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Date;
import java.util.logging.Formatter;
import java.util.logging.LogRecord;

public class TALogFormatter
extends Formatter {
    private boolean m_showDates = false;

    public void setShowDates(boolean aVal) {
        this.m_showDates = aVal;
    }

    public String format(LogRecord record) {
        String shortName = record.getLoggerName() == null ? "." : (record.getLoggerName().indexOf(46) == -1 ? record.getLoggerName() : record.getLoggerName().substring(record.getLoggerName().lastIndexOf(46) + 1, record.getLoggerName().length()));
        StringBuilder builder = new StringBuilder();
        if (this.m_showDates) {
            builder.append(new Date());
            builder.append("");
        }
        builder.append(record.getLevel());
        builder.append(" [");
        builder.append(Thread.currentThread().getName());
        builder.append("] ");
        builder.append(shortName);
        builder.append("->");
        builder.append(record.getMessage());
        builder.append("\n");
        if (record.getThrown() != null) {
            StringWriter writer = new StringWriter();
            PrintWriter pw = new PrintWriter(writer);
            record.getThrown().printStackTrace(pw);
            pw.flush();
            builder.append(writer.getBuffer());
        }
        return builder.toString();
    }
}

